/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import java.math.BigDecimal;

class JsonLazyNumber
extends Number {
    private String value;

    public JsonLazyNumber(String string) {
        this.value = string;
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.value);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public int intValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return (int)Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException2) {
                return new BigDecimal(this.value).intValue();
            }
        }
    }

    @Override
    public long longValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return new BigDecimal(this.value).longValue();
        }
    }

    private Object writeReplace() {
        return new BigDecimal(this.value);
    }
}

