/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.profile.commands;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.cli.config.CodeGenConfig;
import io.micronaut.cli.config.ConfigMap;
import io.micronaut.cli.console.logging.MicronautConsole;
import io.micronaut.cli.profile.Command;
import io.micronaut.cli.profile.ExecutionContext;
import io.micronaut.cli.profile.Feature;
import io.micronaut.cli.profile.Profile;
import io.micronaut.cli.profile.ProfileRepository;
import io.micronaut.cli.profile.ProfileRepositoryAware;
import io.micronaut.cli.profile.ProjectContext;
import io.micronaut.cli.profile.commands.ArgumentCompletingCommand;
import io.micronaut.cli.profile.commands.CommonOptionsMixin;
import io.micronaut.cli.profile.commands.ProfileCompletionCandidates;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import picocli.CommandLine;

@CommandLine.Command(name="profile-info", description={"Display information about a given profile"})
public class ProfileInfoCommand
extends ArgumentCompletingCommand
implements ProfileRepositoryAware {
    public static final String NAME = "profile-info";
    private final String name;
    @CommandLine.Parameters(arity="1", completionCandidates=ProfileCompletionCandidates.class, paramLabel="PROFILE-NAME", description={"The name or coordinates of the profile"})
    private String profileName;
    @CommandLine.Mixin
    private CommonOptionsMixin commonOptionsMixin;
    private ProfileRepository profileRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ProfileInfoCommand() {
        MetaClass metaClass;
        String string;
        this.name = string = NAME;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    @CommandLine.Spec
    public void setCommandSpec(CommandLine.Model.CommandSpec commandSpec) {
        super.setCommandSpec(commandSpec);
        ProfileCompletionCandidates.updateCommandArguments(commandSpec, this.profileRepository);
    }

    @Override
    public void setProfileRepository(ProfileRepository profileRepository) {
        ProfileRepository profileRepository2;
        this.profileRepository = profileRepository2 = profileRepository;
    }

    @Override
    public boolean handle(ExecutionContext executionContext) {
        MicronautConsole console = executionContext.getConsole();
        if (this.profileRepository == null) {
            console.error("No profile repository provided");
            return false;
        }
        Profile profile = this.profileRepository.getProfile(this.profileName);
        if (profile == null) {
            console.error(ShortTypeHandling.castToString(new GStringImpl(new Object[]{this.profileName}, new String[]{"Profile not found for name [", "]"})));
        } else {
            console.addStatus(ShortTypeHandling.castToString(new GStringImpl(new Object[]{profile.getName()}, new String[]{"Profile: ", ""})));
            console.log("--------------------");
            console.log(profile.getDescription());
            console.log("");
            console.addStatus("Provided Commands:");
            console.log("--------------------");
            public final class _handle_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Command c) {
                    return c.getName();
                }

                public Object call(Command c) {
                    return this.doCall(c);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            public final class _handle_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Command)it).getName();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List<Command> commands = DefaultGroovyMethods.sort(DefaultGroovyMethods.toUnique(this.findCommands(profile, console), (Closure)new _handle_closure1(this, this)), (Closure)new _handle_closure2(this, this));
            if (!commands.isEmpty()) {
                public final class _handle_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure3(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Command)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure4(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int width = Math.min(20, ((String)DefaultGroovyMethods.last(DefaultGroovyMethods.sort(DefaultGroovyMethods.collect(commands, new _handle_closure3(this, this)), (Closure)new _handle_closure4(this, this)))).length());
                String separator = StringGroovyMethods.padRight((CharSequence)String.format("%n", new Object[0]), (Number)width);
                Command cmd = null;
                Iterator<Command> iterator = commands.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray;
                    cmd = (Command)ScriptBytecodeAdapter.castToType(iterator.next(), Command.class);
                    CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
                    console.log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)spec.name(), (Number)width), (stringArray = spec.usageMessage().description()) != null ? DefaultGroovyMethods.join((Object[])ScriptBytecodeAdapter.castToType(stringArray, Object[].class), separator) : null}, new String[]{"  ", "  ", ""})));
                }
            }
            console.log("");
            console.addStatus("Provided Features:");
            console.log("--------------------");
            public final class _handle_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Feature)it).getName();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Override
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != _handle_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass(this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List<Feature> features = DefaultGroovyMethods.sort(profile.getFeatures(), (Closure)new _handle_closure5(this, this));
            if (!features.isEmpty()) {
                public final class _handle_closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure6(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((Feature)it).getName();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                public final class _handle_closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((String)it).length();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Override
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _handle_closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                int width = Math.min(20, ((String)DefaultGroovyMethods.last(DefaultGroovyMethods.sort(DefaultGroovyMethods.collect(features, new _handle_closure6(this, this)), (Closure)new _handle_closure7(this, this)))).length());
                Feature feature = null;
                Iterator<Feature> iterator = features.iterator();
                while (iterator.hasNext()) {
                    feature = (Feature)ScriptBytecodeAdapter.castToType(iterator.next(), Feature.class);
                    console.log(ShortTypeHandling.castToString(new GStringImpl(new Object[]{StringGroovyMethods.padRight((CharSequence)feature.getName(), (Number)width), feature.getDescription()}, new String[]{"  ", "  ", ""})));
                }
            }
        }
        return true;
    }

    public Iterable<Command> findCommands(Profile profile, MicronautConsole console) {
        Reference<MicronautConsole> console2 = new Reference<MicronautConsole>(console);
        Iterable<Command> commands = profile.getCommands(new ProjectContext(this, console2){
            public /* synthetic */ Reference console;
            public /* synthetic */ ProfileInfoCommand this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ProfileInfoCommand profileInfoCommand;
                this.this$0 = profileInfoCommand = p0;
                this.console = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public MicronautConsole getConsole() {
                return (MicronautConsole)ScriptBytecodeAdapter.castToType(this.console.get(), MicronautConsole.class);
            }

            @Override
            public File getBaseDir() {
                return new File(".");
            }

            @Override
            public ConfigMap getConfig() {
                return new CodeGenConfig();
            }

            @Override
            public String navigateConfig(String ... path) {
                return ShortTypeHandling.castToString(this.getConfig().navigate(path));
            }

            @Override
            public <T> T navigateConfigForType(Class<T> requiredType, String ... path) {
                return (T)this.getConfig().navigate(path);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty(object, null, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, ProfileInfoCommand.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty(this, string);
            }

            @Override
            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty(this, string, object);
            }
        });
        return commands;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProfileInfoCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProfileInfoCommand.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public void setProfileName(String string) {
        this.profileName = string;
    }

    @Generated
    public CommonOptionsMixin getCommonOptionsMixin() {
        return this.commonOptionsMixin;
    }

    @Generated
    public void setCommonOptionsMixin(CommonOptionsMixin commonOptionsMixin) {
        this.commonOptionsMixin = commonOptionsMixin;
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }
}

