/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cli.io.support;

import io.micronaut.cli.io.support.Resource;
import io.micronaut.cli.io.support.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public abstract class AbstractFileResolvingResource
implements Resource {
    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        return ResourceUtils.getFile(url, this.getDescription());
    }

    @Override
    public boolean exists() {
        try {
            HttpURLConnection httpCon;
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            AbstractFileResolvingResource.useCachesIfNecessary(con);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (con.getContentLength() >= 0) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            InputStream is = this.getInputStream();
            is.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isReadable() {
        try {
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                File file = this.getFile();
                return file.canRead() && !file.isDirectory();
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url)) {
            return this.getFile().length();
        }
        URLConnection con = url.openConnection();
        AbstractFileResolvingResource.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getContentLength();
    }

    @Override
    public long lastModified() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url) || ResourceUtils.isJarURL(url)) {
            return this.getFile().lastModified();
        }
        URLConnection con = url.openConnection();
        AbstractFileResolvingResource.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("HEAD");
        }
        return con.getLastModified();
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(url);
            return ResourceUtils.getFile(actualUrl, "Jar URL");
        }
        return this.getFile();
    }

    protected File getFile(URI uri) throws IOException {
        return ResourceUtils.getFile(uri, this.getDescription());
    }

    private static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }
}

