/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.objectweb.util.ant.DirectoryScannerHelper;

public class JavadocMultipleLink
extends Javadoc {
    public static final String PACKAGE_HTML_FILE_NAME = "package.html";
    public static final String TEMP_CLASS_NAME = "Temp";
    private Path sourcePath = null;

    public void setLinks(String d) {
        StringTokenizer st = new StringTokenizer(d, ",");
        while (st.hasMoreTokens()) {
            Javadoc.LinkArgument la = this.createLink();
            la.setHref(st.nextToken());
        }
    }

    public void setSourcepath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
        super.setSourcepath(src);
    }

    public void execute() throws BuildException {
        Enumeration enu;
        Vector<File> v = new Vector<File>();
        String[] paths = this.sourcePath.list();
        for (int i = 0; i < paths.length; ++i) {
            FileSet fs = new FileSet();
            fs.setProject(this.getProject());
            fs.setIncludes("**/*");
            fs.setDir(new File(paths[i]));
            fs.setDefaultexcludes(true);
            String[] dirs = DirectoryScannerHelper.getSelectedFilesAsString(fs.getDirectoryScanner(this.getProject()), this.getProject());
            for (int j = 0; j < dirs.length; ++j) {
                try {
                    if (!this.containsOnlyOneFile(new File(paths[i], dirs[j]), PACKAGE_HTML_FILE_NAME)) continue;
                    v.add(new File(paths[i], dirs[j]));
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println(ioe.getMessage());
                }
            }
        }
        try {
            enu = v.elements();
            while (enu.hasMoreElements()) {
                File current = new File((File)enu.nextElement(), "Temp.java");
                if (!current.createNewFile()) continue;
                FileWriter fw = new FileWriter(current);
                fw.write("class Temp{}");
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        super.execute();
        enu = v.elements();
        while (enu.hasMoreElements()) {
            new File((File)enu.nextElement(), "Temp.java").delete();
        }
    }

    public boolean containsOnlyOneFile(File dirfile, String filename) throws IOException {
        if (!dirfile.isDirectory()) {
            throw new IOException(dirfile + " is not a directory");
        }
        File[] packfiles = dirfile.listFiles(new FileFilter(filename));
        if (packfiles != null && packfiles.length > 0) {
            for (int i = 0; i < packfiles.length; ++i) {
                File[] res = packfiles[i].getParentFile().listFiles(new FileFilter(".java"));
                if (res != null && res.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    class FileFilter
    implements FilenameFilter {
        String filter = null;

        public FileFilter(String f) {
            this.filter = f;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.filter);
        }
    }
}

