/*****************************************************************************
 * Copyright (c) 2014-2020 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "VehicleSubpositionData.h"

#include "Vehicle.h"

#define CREATE_VEHICLE_INFO(VAR, ...)                                                                                          \
    static constexpr const rct_vehicle_info VAR##_data[] = __VA_ARGS__;                                                        \
    static constexpr const rct_vehicle_info_list VAR = { static_cast<uint16_t>(std::size(VAR##_data)), VAR##_data };

#define MINI_GOLF_STATE(STATE)                                                                                                 \
    {                                                                                                                          \
        LOCATION_NULL, EnumValue(MiniGolfState::STATE), 0, 0, 0, 0                                                             \
    }
#define MINI_GOLF_ANIMATION(VALUE)                                                                                             \
    {                                                                                                                          \
        LOCATION_NULL, EnumValue(MiniGolfState::Unk4), EnumValue(MiniGolfAnimation::VALUE), 0, 0, 0                            \
    }

// clang-format off
CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE57A, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  0,  0,  0 }, {     23,   16,    0,  0,  0,  0 }, {     22,   16,    0,  0,  0,  0 },
    {     21,   16,    0,  0,  0,  0 }, {     20,   16,    0,  0,  0,  0 }, {     19,   16,    0,  0,  0,  0 }, {     18,   16,    0,  0,  0,  0 }, {     17,   16,    0,  0,  0,  0 },
    {     16,   16,    0,  0,  0,  0 }, {     15,   16,    0,  0,  0,  0 }, {     14,   16,    0,  0,  0,  0 }, {     13,   16,    0,  0,  0,  0 }, {     12,   16,    0,  0,  0,  0 },
    {     11,   16,    0,  0,  0,  0 }, {     10,   16,    0,  0,  0,  0 }, {      9,   16,    0,  0,  0,  0 }, {      8,   16,    0,  0,  0,  0 }, {      7,   16,    0,  0,  0,  0 },
    {      6,   16,    0,  0,  0,  0 }, {      5,   16,    0,  0,  0,  0 }, {      4,   16,    0,  0,  0,  0 }, {      3,   16,    0,  0,  0,  0 }, {      2,   16,    0,  0,  0,  0 },
    {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})


CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE69C, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  8,  0,  0 }, {     16,    9,    0,  8,  0,  0 },
    {     16,   10,    0,  8,  0,  0 }, {     16,   11,    0,  8,  0,  0 }, {     16,   12,    0,  8,  0,  0 }, {     16,   13,    0,  8,  0,  0 }, {     16,   14,    0,  8,  0,  0 },
    {     16,   15,    0,  8,  0,  0 }, {     16,   16,    0,  8,  0,  0 }, {     16,   17,    0,  8,  0,  0 }, {     16,   18,    0,  8,  0,  0 }, {     16,   19,    0,  8,  0,  0 },
    {     16,   20,    0,  8,  0,  0 }, {     16,   21,    0,  8,  0,  0 }, {     16,   22,    0,  8,  0,  0 }, {     16,   23,    0,  8,  0,  0 }, {     16,   24,    0,  8,  0,  0 },
    {     16,   25,    0,  8,  0,  0 }, {     16,   26,    0,  8,  0,  0 }, {     16,   27,    0,  8,  0,  0 }, {     16,   28,    0,  8,  0,  0 }, {     16,   29,    0,  8,  0,  0 },
    {     16,   30,    0,  8,  0,  0 }, {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE7BE, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 16,  0,  0 }, {      9,   16,    0, 16,  0,  0 },
    {     10,   16,    0, 16,  0,  0 }, {     11,   16,    0, 16,  0,  0 }, {     12,   16,    0, 16,  0,  0 }, {     13,   16,    0, 16,  0,  0 }, {     14,   16,    0, 16,  0,  0 },
    {     15,   16,    0, 16,  0,  0 }, {     16,   16,    0, 16,  0,  0 }, {     17,   16,    0, 16,  0,  0 }, {     18,   16,    0, 16,  0,  0 }, {     19,   16,    0, 16,  0,  0 },
    {     20,   16,    0, 16,  0,  0 }, {     21,   16,    0, 16,  0,  0 }, {     22,   16,    0, 16,  0,  0 }, {     23,   16,    0, 16,  0,  0 }, {     24,   16,    0, 16,  0,  0 },
    {     25,   16,    0, 16,  0,  0 }, {     26,   16,    0, 16,  0,  0 }, {     27,   16,    0, 16,  0,  0 }, {     28,   16,    0, 16,  0,  0 }, {     29,   16,    0, 16,  0,  0 },
    {     30,   16,    0, 16,  0,  0 }, {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BE8E0, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 24,  0,  0 }, {     16,   23,    0, 24,  0,  0 }, {     16,   22,    0, 24,  0,  0 },
    {     16,   21,    0, 24,  0,  0 }, {     16,   20,    0, 24,  0,  0 }, {     16,   19,    0, 24,  0,  0 }, {     16,   18,    0, 24,  0,  0 }, {     16,   17,    0, 24,  0,  0 },
    {     16,   16,    0, 24,  0,  0 }, {     16,   15,    0, 24,  0,  0 }, {     16,   14,    0, 24,  0,  0 }, {     16,   13,    0, 24,  0,  0 }, {     16,   12,    0, 24,  0,  0 },
    {     16,   11,    0, 24,  0,  0 }, {     16,   10,    0, 24,  0,  0 }, {     16,    9,    0, 24,  0,  0 }, {     16,    8,    0, 24,  0,  0 }, {     16,    7,    0, 24,  0,  0 },
    {     16,    6,    0, 24,  0,  0 }, {     16,    5,    0, 24,  0,  0 }, {     16,    4,    0, 24,  0,  0 }, {     16,    3,    0, 24,  0,  0 }, {     16,    2,    0, 24,  0,  0 },
    {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C232A, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    1,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    2,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    3,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    4,  0,  2,  0 }, {     23,   16,    4,  0,  2,  0 }, {     22,   16,    5,  0,  2,  0 },
    {     21,   16,    5,  0,  2,  0 }, {     20,   16,    6,  0,  2,  0 }, {     19,   16,    6,  0,  2,  0 }, {     18,   16,    7,  0,  2,  0 }, {     17,   16,    7,  0,  2,  0 },
    {     16,   16,    8,  0,  2,  0 }, {     15,   16,    8,  0,  2,  0 }, {     14,   16,    9,  0,  2,  0 }, {     13,   16,    9,  0,  2,  0 }, {     12,   16,   10,  0,  2,  0 },
    {     11,   16,   10,  0,  2,  0 }, {     10,   16,   11,  0,  2,  0 }, {      9,   16,   11,  0,  2,  0 }, {      8,   16,   12,  0,  2,  0 }, {      7,   16,   12,  0,  2,  0 },
    {      6,   16,   13,  0,  2,  0 }, {      5,   16,   13,  0,  2,  0 }, {      4,   16,   14,  0,  2,  0 }, {      3,   16,   14,  0,  2,  0 }, {      2,   16,   15,  0,  2,  0 },
    {      1,   16,   15,  0,  2,  0 }, {      0,   16,   16,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C244C, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    4,  8,  2,  0 }, {     16,    9,    4,  8,  2,  0 },
    {     16,   10,    5,  8,  2,  0 }, {     16,   11,    5,  8,  2,  0 }, {     16,   12,    6,  8,  2,  0 }, {     16,   13,    6,  8,  2,  0 }, {     16,   14,    7,  8,  2,  0 },
    {     16,   15,    7,  8,  2,  0 }, {     16,   16,    8,  8,  2,  0 }, {     16,   17,    8,  8,  2,  0 }, {     16,   18,    9,  8,  2,  0 }, {     16,   19,    9,  8,  2,  0 },
    {     16,   20,   10,  8,  2,  0 }, {     16,   21,   10,  8,  2,  0 }, {     16,   22,   11,  8,  2,  0 }, {     16,   23,   11,  8,  2,  0 }, {     16,   24,   12,  8,  2,  0 },
    {     16,   25,   12,  8,  2,  0 }, {     16,   26,   13,  8,  2,  0 }, {     16,   27,   13,  8,  2,  0 }, {     16,   28,   14,  8,  2,  0 }, {     16,   29,   14,  8,  2,  0 },
    {     16,   30,   15,  8,  2,  0 }, {     16,   31,   15,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C256E, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    4, 16,  2,  0 }, {      9,   16,    4, 16,  2,  0 },
    {     10,   16,    5, 16,  2,  0 }, {     11,   16,    5, 16,  2,  0 }, {     12,   16,    6, 16,  2,  0 }, {     13,   16,    6, 16,  2,  0 }, {     14,   16,    7, 16,  2,  0 },
    {     15,   16,    7, 16,  2,  0 }, {     16,   16,    8, 16,  2,  0 }, {     17,   16,    8, 16,  2,  0 }, {     18,   16,    9, 16,  2,  0 }, {     19,   16,    9, 16,  2,  0 },
    {     20,   16,   10, 16,  2,  0 }, {     21,   16,   10, 16,  2,  0 }, {     22,   16,   11, 16,  2,  0 }, {     23,   16,   11, 16,  2,  0 }, {     24,   16,   12, 16,  2,  0 },
    {     25,   16,   12, 16,  2,  0 }, {     26,   16,   13, 16,  2,  0 }, {     27,   16,   13, 16,  2,  0 }, {     28,   16,   14, 16,  2,  0 }, {     29,   16,   14, 16,  2,  0 },
    {     30,   16,   15, 16,  2,  0 }, {     31,   16,   15, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2690, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    1, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    2, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    3, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    4, 24,  2,  0 }, {     16,   23,    4, 24,  2,  0 }, {     16,   22,    5, 24,  2,  0 },
    {     16,   21,    5, 24,  2,  0 }, {     16,   20,    6, 24,  2,  0 }, {     16,   19,    6, 24,  2,  0 }, {     16,   18,    7, 24,  2,  0 }, {     16,   17,    7, 24,  2,  0 },
    {     16,   16,    8, 24,  2,  0 }, {     16,   15,    8, 24,  2,  0 }, {     16,   14,    9, 24,  2,  0 }, {     16,   13,    9, 24,  2,  0 }, {     16,   12,   10, 24,  2,  0 },
    {     16,   11,   10, 24,  2,  0 }, {     16,   10,   11, 24,  2,  0 }, {     16,    9,   11, 24,  2,  0 }, {     16,    8,   12, 24,  2,  0 }, {     16,    7,   12, 24,  2,  0 },
    {     16,    6,   13, 24,  2,  0 }, {     16,    5,   13, 24,  2,  0 }, {     16,    4,   14, 24,  2,  0 }, {     16,    3,   14, 24,  2,  0 }, {     16,    2,   15, 24,  2,  0 },
    {     16,    1,   15, 24,  2,  0 }, {     16,    0,   16, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF312, {
    {     31,   16,    0,  0,  4,  0 }, {     31,   16,    1,  0,  4,  0 }, {     30,   16,    2,  0,  4,  0 }, {     30,   16,    3,  0,  4,  0 }, {     29,   16,    4,  0,  4,  0 },
    {     29,   16,    5,  0,  4,  0 }, {     28,   16,    6,  0,  4,  0 }, {     28,   16,    7,  0,  4,  0 }, {     27,   16,    8,  0,  4,  0 }, {     27,   16,    9,  0,  4,  0 },
    {     26,   16,   10,  0,  4,  0 }, {     26,   16,   11,  0,  4,  0 }, {     25,   16,   12,  0,  4,  0 }, {     25,   16,   13,  0,  4,  0 }, {     24,   16,   14,  0,  4,  0 },
    {     24,   16,   15,  0,  4,  0 }, {     23,   16,   16,  0,  4,  0 }, {     23,   16,   17,  0,  4,  0 }, {     22,   16,   18,  0,  4,  0 }, {     22,   16,   19,  0,  4,  0 },
    {     21,   16,   20,  0,  4,  0 }, {     21,   16,   21,  0,  4,  0 }, {     20,   16,   22,  0,  4,  0 }, {     20,   16,   23,  0,  4,  0 }, {     19,   16,   24,  0,  4,  0 },
    {     19,   16,   25,  0,  4,  0 }, {     18,   16,   26,  0,  4,  0 }, {     18,   16,   27,  0,  4,  0 }, {     17,   16,   28,  0,  4,  0 }, {     17,   16,   29,  0,  4,  0 },
    {     16,   16,   30,  0,  4,  0 }, {     16,   16,   31,  0,  4,  0 }, {     15,   16,   32,  0,  4,  0 }, {     15,   16,   33,  0,  4,  0 }, {     14,   16,   34,  0,  4,  0 },
    {     14,   16,   35,  0,  4,  0 }, {     13,   16,   36,  0,  4,  0 }, {     13,   16,   37,  0,  4,  0 }, {     12,   16,   38,  0,  4,  0 }, {     12,   16,   39,  0,  4,  0 },
    {     11,   16,   40,  0,  4,  0 }, {     11,   16,   41,  0,  4,  0 }, {     10,   16,   42,  0,  4,  0 }, {     10,   16,   43,  0,  4,  0 }, {      9,   16,   44,  0,  4,  0 },
    {      9,   16,   45,  0,  4,  0 }, {      8,   16,   46,  0,  4,  0 }, {      8,   16,   47,  0,  4,  0 }, {      7,   16,   48,  0,  4,  0 }, {      7,   16,   49,  0,  4,  0 },
    {      6,   16,   50,  0,  4,  0 }, {      6,   16,   51,  0,  4,  0 }, {      5,   16,   52,  0,  4,  0 }, {      5,   16,   53,  0,  4,  0 }, {      4,   16,   54,  0,  4,  0 },
    {      4,   16,   55,  0,  4,  0 }, {      3,   16,   56,  0,  4,  0 }, {      3,   16,   57,  0,  4,  0 }, {      2,   16,   58,  0,  4,  0 }, {      2,   16,   59,  0,  4,  0 },
    {      1,   16,   60,  0,  4,  0 }, {      1,   16,   61,  0,  4,  0 }, {      0,   16,   62,  0,  4,  0 }, {      0,   16,   63,  0,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF554, {
    {     16,    0,    0,  8,  4,  0 }, {     16,    0,    1,  8,  4,  0 }, {     16,    1,    2,  8,  4,  0 }, {     16,    1,    3,  8,  4,  0 }, {     16,    2,    4,  8,  4,  0 },
    {     16,    2,    5,  8,  4,  0 }, {     16,    3,    6,  8,  4,  0 }, {     16,    3,    7,  8,  4,  0 }, {     16,    4,    8,  8,  4,  0 }, {     16,    4,    9,  8,  4,  0 },
    {     16,    5,   10,  8,  4,  0 }, {     16,    5,   11,  8,  4,  0 }, {     16,    6,   12,  8,  4,  0 }, {     16,    6,   13,  8,  4,  0 }, {     16,    7,   14,  8,  4,  0 },
    {     16,    7,   15,  8,  4,  0 }, {     16,    8,   16,  8,  4,  0 }, {     16,    8,   17,  8,  4,  0 }, {     16,    9,   18,  8,  4,  0 }, {     16,    9,   19,  8,  4,  0 },
    {     16,   10,   20,  8,  4,  0 }, {     16,   10,   21,  8,  4,  0 }, {     16,   11,   22,  8,  4,  0 }, {     16,   11,   23,  8,  4,  0 }, {     16,   12,   24,  8,  4,  0 },
    {     16,   12,   25,  8,  4,  0 }, {     16,   13,   26,  8,  4,  0 }, {     16,   13,   27,  8,  4,  0 }, {     16,   14,   28,  8,  4,  0 }, {     16,   14,   29,  8,  4,  0 },
    {     16,   15,   30,  8,  4,  0 }, {     16,   15,   31,  8,  4,  0 }, {     16,   16,   32,  8,  4,  0 }, {     16,   16,   33,  8,  4,  0 }, {     16,   17,   34,  8,  4,  0 },
    {     16,   17,   35,  8,  4,  0 }, {     16,   18,   36,  8,  4,  0 }, {     16,   18,   37,  8,  4,  0 }, {     16,   19,   38,  8,  4,  0 }, {     16,   19,   39,  8,  4,  0 },
    {     16,   20,   40,  8,  4,  0 }, {     16,   20,   41,  8,  4,  0 }, {     16,   21,   42,  8,  4,  0 }, {     16,   21,   43,  8,  4,  0 }, {     16,   22,   44,  8,  4,  0 },
    {     16,   22,   45,  8,  4,  0 }, {     16,   23,   46,  8,  4,  0 }, {     16,   23,   47,  8,  4,  0 }, {     16,   24,   48,  8,  4,  0 }, {     16,   24,   49,  8,  4,  0 },
    {     16,   25,   50,  8,  4,  0 }, {     16,   25,   51,  8,  4,  0 }, {     16,   26,   52,  8,  4,  0 }, {     16,   26,   53,  8,  4,  0 }, {     16,   27,   54,  8,  4,  0 },
    {     16,   27,   55,  8,  4,  0 }, {     16,   28,   56,  8,  4,  0 }, {     16,   28,   57,  8,  4,  0 }, {     16,   29,   58,  8,  4,  0 }, {     16,   29,   59,  8,  4,  0 },
    {     16,   30,   60,  8,  4,  0 }, {     16,   30,   61,  8,  4,  0 }, {     16,   31,   62,  8,  4,  0 }, {     16,   31,   63,  8,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF796, {
    {      0,   16,    0, 16,  4,  0 }, {      0,   16,    1, 16,  4,  0 }, {      1,   16,    2, 16,  4,  0 }, {      1,   16,    3, 16,  4,  0 }, {      2,   16,    4, 16,  4,  0 },
    {      2,   16,    5, 16,  4,  0 }, {      3,   16,    6, 16,  4,  0 }, {      3,   16,    7, 16,  4,  0 }, {      4,   16,    8, 16,  4,  0 }, {      4,   16,    9, 16,  4,  0 },
    {      5,   16,   10, 16,  4,  0 }, {      5,   16,   11, 16,  4,  0 }, {      6,   16,   12, 16,  4,  0 }, {      6,   16,   13, 16,  4,  0 }, {      7,   16,   14, 16,  4,  0 },
    {      7,   16,   15, 16,  4,  0 }, {      8,   16,   16, 16,  4,  0 }, {      8,   16,   17, 16,  4,  0 }, {      9,   16,   18, 16,  4,  0 }, {      9,   16,   19, 16,  4,  0 },
    {     10,   16,   20, 16,  4,  0 }, {     10,   16,   21, 16,  4,  0 }, {     11,   16,   22, 16,  4,  0 }, {     11,   16,   23, 16,  4,  0 }, {     12,   16,   24, 16,  4,  0 },
    {     12,   16,   25, 16,  4,  0 }, {     13,   16,   26, 16,  4,  0 }, {     13,   16,   27, 16,  4,  0 }, {     14,   16,   28, 16,  4,  0 }, {     14,   16,   29, 16,  4,  0 },
    {     15,   16,   30, 16,  4,  0 }, {     15,   16,   31, 16,  4,  0 }, {     16,   16,   32, 16,  4,  0 }, {     16,   16,   33, 16,  4,  0 }, {     17,   16,   34, 16,  4,  0 },
    {     17,   16,   35, 16,  4,  0 }, {     18,   16,   36, 16,  4,  0 }, {     18,   16,   37, 16,  4,  0 }, {     19,   16,   38, 16,  4,  0 }, {     19,   16,   39, 16,  4,  0 },
    {     20,   16,   40, 16,  4,  0 }, {     20,   16,   41, 16,  4,  0 }, {     21,   16,   42, 16,  4,  0 }, {     21,   16,   43, 16,  4,  0 }, {     22,   16,   44, 16,  4,  0 },
    {     22,   16,   45, 16,  4,  0 }, {     23,   16,   46, 16,  4,  0 }, {     23,   16,   47, 16,  4,  0 }, {     24,   16,   48, 16,  4,  0 }, {     24,   16,   49, 16,  4,  0 },
    {     25,   16,   50, 16,  4,  0 }, {     25,   16,   51, 16,  4,  0 }, {     26,   16,   52, 16,  4,  0 }, {     26,   16,   53, 16,  4,  0 }, {     27,   16,   54, 16,  4,  0 },
    {     27,   16,   55, 16,  4,  0 }, {     28,   16,   56, 16,  4,  0 }, {     28,   16,   57, 16,  4,  0 }, {     29,   16,   58, 16,  4,  0 }, {     29,   16,   59, 16,  4,  0 },
    {     30,   16,   60, 16,  4,  0 }, {     30,   16,   61, 16,  4,  0 }, {     31,   16,   62, 16,  4,  0 }, {     31,   16,   63, 16,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF9D8, {
    {     16,   31,    0, 24,  4,  0 }, {     16,   31,    1, 24,  4,  0 }, {     16,   30,    2, 24,  4,  0 }, {     16,   30,    3, 24,  4,  0 }, {     16,   29,    4, 24,  4,  0 },
    {     16,   29,    5, 24,  4,  0 }, {     16,   28,    6, 24,  4,  0 }, {     16,   28,    7, 24,  4,  0 }, {     16,   27,    8, 24,  4,  0 }, {     16,   27,    9, 24,  4,  0 },
    {     16,   26,   10, 24,  4,  0 }, {     16,   26,   11, 24,  4,  0 }, {     16,   25,   12, 24,  4,  0 }, {     16,   25,   13, 24,  4,  0 }, {     16,   24,   14, 24,  4,  0 },
    {     16,   24,   15, 24,  4,  0 }, {     16,   23,   16, 24,  4,  0 }, {     16,   23,   17, 24,  4,  0 }, {     16,   22,   18, 24,  4,  0 }, {     16,   22,   19, 24,  4,  0 },
    {     16,   21,   20, 24,  4,  0 }, {     16,   21,   21, 24,  4,  0 }, {     16,   20,   22, 24,  4,  0 }, {     16,   20,   23, 24,  4,  0 }, {     16,   19,   24, 24,  4,  0 },
    {     16,   19,   25, 24,  4,  0 }, {     16,   18,   26, 24,  4,  0 }, {     16,   18,   27, 24,  4,  0 }, {     16,   17,   28, 24,  4,  0 }, {     16,   17,   29, 24,  4,  0 },
    {     16,   16,   30, 24,  4,  0 }, {     16,   16,   31, 24,  4,  0 }, {     16,   15,   32, 24,  4,  0 }, {     16,   15,   33, 24,  4,  0 }, {     16,   14,   34, 24,  4,  0 },
    {     16,   14,   35, 24,  4,  0 }, {     16,   13,   36, 24,  4,  0 }, {     16,   13,   37, 24,  4,  0 }, {     16,   12,   38, 24,  4,  0 }, {     16,   12,   39, 24,  4,  0 },
    {     16,   11,   40, 24,  4,  0 }, {     16,   11,   41, 24,  4,  0 }, {     16,   10,   42, 24,  4,  0 }, {     16,   10,   43, 24,  4,  0 }, {     16,    9,   44, 24,  4,  0 },
    {     16,    9,   45, 24,  4,  0 }, {     16,    8,   46, 24,  4,  0 }, {     16,    8,   47, 24,  4,  0 }, {     16,    7,   48, 24,  4,  0 }, {     16,    7,   49, 24,  4,  0 },
    {     16,    6,   50, 24,  4,  0 }, {     16,    6,   51, 24,  4,  0 }, {     16,    5,   52, 24,  4,  0 }, {     16,    5,   53, 24,  4,  0 }, {     16,    4,   54, 24,  4,  0 },
    {     16,    4,   55, 24,  4,  0 }, {     16,    3,   56, 24,  4,  0 }, {     16,    3,   57, 24,  4,  0 }, {     16,    2,   58, 24,  4,  0 }, {     16,    2,   59, 24,  4,  0 },
    {     16,    1,   60, 24,  4,  0 }, {     16,    1,   61, 24,  4,  0 }, {     16,    0,   62, 24,  4,  0 }, {     16,    0,   63, 24,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFC1A, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  0,  0,  0 }, {     23,   16,    0,  0,  1,  0 }, {     22,   16,    0,  0,  1,  0 },
    {     21,   16,    1,  0,  1,  0 }, {     20,   16,    1,  0,  1,  0 }, {     19,   16,    1,  0,  1,  0 }, {     18,   16,    1,  0,  1,  0 }, {     17,   16,    1,  0,  1,  0 },
    {     16,   16,    1,  0,  1,  0 }, {     15,   16,    2,  0,  1,  0 }, {     14,   16,    2,  0,  1,  0 }, {     13,   16,    2,  0,  1,  0 }, {     12,   16,    2,  0,  1,  0 },
    {     11,   16,    3,  0,  1,  0 }, {     10,   16,    3,  0,  1,  0 }, {      9,   16,    3,  0,  1,  0 }, {      8,   16,    4,  0,  1,  0 }, {      7,   16,    4,  0,  2,  0 },
    {      6,   16,    5,  0,  2,  0 }, {      5,   16,    5,  0,  2,  0 }, {      4,   16,    6,  0,  2,  0 }, {      3,   16,    6,  0,  2,  0 }, {      2,   16,    7,  0,  2,  0 },
    {      1,   16,    7,  0,  2,  0 }, {      0,   16,    8,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFD3C, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  8,  1,  0 }, {     16,    9,    0,  8,  1,  0 },
    {     16,   10,    1,  8,  1,  0 }, {     16,   11,    1,  8,  1,  0 }, {     16,   12,    1,  8,  1,  0 }, {     16,   13,    1,  8,  1,  0 }, {     16,   14,    1,  8,  1,  0 },
    {     16,   15,    1,  8,  1,  0 }, {     16,   16,    2,  8,  1,  0 }, {     16,   17,    2,  8,  1,  0 }, {     16,   18,    2,  8,  1,  0 }, {     16,   19,    2,  8,  1,  0 },
    {     16,   20,    3,  8,  1,  0 }, {     16,   21,    3,  8,  1,  0 }, {     16,   22,    3,  8,  1,  0 }, {     16,   23,    4,  8,  1,  0 }, {     16,   24,    4,  8,  2,  0 },
    {     16,   25,    4,  8,  2,  0 }, {     16,   26,    5,  8,  2,  0 }, {     16,   27,    5,  8,  2,  0 }, {     16,   28,    6,  8,  2,  0 }, {     16,   29,    6,  8,  2,  0 },
    {     16,   30,    7,  8,  2,  0 }, {     16,   31,    7,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFE5E, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 16,  1,  0 }, {      9,   16,    0, 16,  1,  0 },
    {     10,   16,    1, 16,  1,  0 }, {     11,   16,    1, 16,  1,  0 }, {     12,   16,    1, 16,  1,  0 }, {     13,   16,    1, 16,  1,  0 }, {     14,   16,    1, 16,  1,  0 },
    {     15,   16,    1, 16,  1,  0 }, {     16,   16,    2, 16,  1,  0 }, {     17,   16,    2, 16,  1,  0 }, {     18,   16,    2, 16,  1,  0 }, {     19,   16,    2, 16,  1,  0 },
    {     20,   16,    3, 16,  1,  0 }, {     21,   16,    3, 16,  1,  0 }, {     22,   16,    3, 16,  1,  0 }, {     23,   16,    4, 16,  1,  0 }, {     24,   16,    4, 16,  2,  0 },
    {     25,   16,    4, 16,  2,  0 }, {     26,   16,    5, 16,  2,  0 }, {     27,   16,    5, 16,  2,  0 }, {     28,   16,    6, 16,  2,  0 }, {     29,   16,    6, 16,  2,  0 },
    {     30,   16,    7, 16,  2,  0 }, {     31,   16,    7, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BFF80, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 24,  0,  0 }, {     16,   23,    0, 24,  1,  0 }, {     16,   22,    0, 24,  1,  0 },
    {     16,   21,    1, 24,  1,  0 }, {     16,   20,    1, 24,  1,  0 }, {     16,   19,    1, 24,  1,  0 }, {     16,   18,    1, 24,  1,  0 }, {     16,   17,    1, 24,  1,  0 },
    {     16,   16,    1, 24,  1,  0 }, {     16,   15,    2, 24,  1,  0 }, {     16,   14,    2, 24,  1,  0 }, {     16,   13,    2, 24,  1,  0 }, {     16,   12,    2, 24,  1,  0 },
    {     16,   11,    3, 24,  1,  0 }, {     16,   10,    3, 24,  1,  0 }, {     16,    9,    3, 24,  1,  0 }, {     16,    8,    4, 24,  1,  0 }, {     16,    7,    4, 24,  2,  0 },
    {     16,    6,    5, 24,  2,  0 }, {     16,    5,    5, 24,  2,  0 }, {     16,    4,    6, 24,  2,  0 }, {     16,    3,    6, 24,  2,  0 }, {     16,    2,    7, 24,  2,  0 },
    {     16,    1,    7, 24,  2,  0 }, {     16,    0,    8, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0E3A, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    3,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    4,  0,  2,  0 }, {     23,   16,    5,  0,  2,  0 }, {     22,   16,    5,  0,  2,  0 },
    {     21,   16,    6,  0,  3,  0 }, {     20,   16,    7,  0,  3,  0 }, {     19,   16,    8,  0,  3,  0 }, {     18,   16,    8,  0,  3,  0 }, {     17,   16,    9,  0,  3,  0 },
    {     16,   16,   10,  0,  3,  0 }, {     15,   16,   11,  0,  3,  0 }, {     14,   16,   12,  0,  3,  0 }, {     13,   16,   13,  0,  3,  0 }, {     12,   16,   14,  0,  3,  0 },
    {     11,   16,   15,  0,  3,  0 }, {     10,   16,   16,  0,  3,  0 }, {      9,   16,   17,  0,  3,  0 }, {      8,   16,   18,  0,  3,  0 }, {      8,   16,   19,  0,  3,  0 },
    {      7,   16,   20,  0,  3,  0 }, {      6,   16,   21,  0,  3,  0 }, {      5,   16,   22,  0,  4,  0 }, {      5,   16,   23,  0,  4,  0 }, {      4,   16,   24,  0,  4,  0 },
    {      3,   16,   25,  0,  4,  0 }, {      3,   16,   26,  0,  4,  0 }, {      2,   16,   27,  0,  4,  0 }, {      1,   16,   28,  0,  4,  0 }, {      1,   16,   29,  0,  4,  0 },
    {      0,   16,   30,  0,  4,  0 }, {      0,   16,   31,  0,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0F89, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    3,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    4,  8,  2,  0 }, {     16,    8,    5,  8,  2,  0 }, {     16,    9,    5,  8,  2,  0 },
    {     16,   10,    6,  8,  3,  0 }, {     16,   11,    7,  8,  3,  0 }, {     16,   12,    8,  8,  3,  0 }, {     16,   13,    8,  8,  3,  0 }, {     16,   14,    9,  8,  3,  0 },
    {     16,   15,   10,  8,  3,  0 }, {     16,   16,   11,  8,  3,  0 }, {     16,   17,   12,  8,  3,  0 }, {     16,   18,   13,  8,  3,  0 }, {     16,   19,   14,  8,  3,  0 },
    {     16,   20,   15,  8,  3,  0 }, {     16,   21,   16,  8,  3,  0 }, {     16,   22,   17,  8,  3,  0 }, {     16,   23,   18,  8,  3,  0 }, {     16,   23,   19,  8,  3,  0 },
    {     16,   24,   20,  8,  3,  0 }, {     16,   25,   21,  8,  3,  0 }, {     16,   26,   22,  8,  4,  0 }, {     16,   26,   23,  8,  4,  0 }, {     16,   27,   24,  8,  4,  0 },
    {     16,   28,   25,  8,  4,  0 }, {     16,   28,   26,  8,  4,  0 }, {     16,   29,   27,  8,  4,  0 }, {     16,   30,   28,  8,  4,  0 }, {     16,   30,   29,  8,  4,  0 },
    {     16,   31,   30,  8,  4,  0 }, {     16,   31,   31,  8,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C10D8, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    3, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    4, 16,  2,  0 }, {      8,   16,    5, 16,  2,  0 }, {      9,   16,    5, 16,  2,  0 },
    {     10,   16,    6, 16,  3,  0 }, {     11,   16,    7, 16,  3,  0 }, {     12,   16,    8, 16,  3,  0 }, {     13,   16,    8, 16,  3,  0 }, {     14,   16,    9, 16,  3,  0 },
    {     15,   16,   10, 16,  3,  0 }, {     16,   16,   11, 16,  3,  0 }, {     17,   16,   12, 16,  3,  0 }, {     18,   16,   13, 16,  3,  0 }, {     19,   16,   14, 16,  3,  0 },
    {     20,   16,   15, 16,  3,  0 }, {     21,   16,   16, 16,  3,  0 }, {     22,   16,   17, 16,  3,  0 }, {     23,   16,   18, 16,  3,  0 }, {     23,   16,   19, 16,  3,  0 },
    {     24,   16,   20, 16,  3,  0 }, {     25,   16,   21, 16,  3,  0 }, {     26,   16,   22, 16,  4,  0 }, {     26,   16,   23, 16,  4,  0 }, {     27,   16,   24, 16,  4,  0 },
    {     28,   16,   25, 16,  4,  0 }, {     28,   16,   26, 16,  4,  0 }, {     29,   16,   27, 16,  4,  0 }, {     30,   16,   28, 16,  4,  0 }, {     30,   16,   29, 16,  4,  0 },
    {     31,   16,   30, 16,  4,  0 }, {     31,   16,   31, 16,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1227, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    3, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    4, 24,  2,  0 }, {     16,   23,    5, 24,  2,  0 }, {     16,   22,    5, 24,  2,  0 },
    {     16,   21,    6, 24,  3,  0 }, {     16,   20,    7, 24,  3,  0 }, {     16,   19,    8, 24,  3,  0 }, {     16,   18,    8, 24,  3,  0 }, {     16,   17,    9, 24,  3,  0 },
    {     16,   16,   10, 24,  3,  0 }, {     16,   15,   11, 24,  3,  0 }, {     16,   14,   12, 24,  3,  0 }, {     16,   13,   13, 24,  3,  0 }, {     16,   12,   14, 24,  3,  0 },
    {     16,   11,   15, 24,  3,  0 }, {     16,   10,   16, 24,  3,  0 }, {     16,    9,   17, 24,  3,  0 }, {     16,    8,   18, 24,  3,  0 }, {     16,    8,   19, 24,  3,  0 },
    {     16,    7,   20, 24,  3,  0 }, {     16,    6,   21, 24,  3,  0 }, {     16,    5,   22, 24,  4,  0 }, {     16,    5,   23, 24,  4,  0 }, {     16,    4,   24, 24,  4,  0 },
    {     16,    3,   25, 24,  4,  0 }, {     16,    3,   26, 24,  4,  0 }, {     16,    2,   27, 24,  4,  0 }, {     16,    1,   28, 24,  4,  0 }, {     16,    1,   29, 24,  4,  0 },
    {     16,    0,   30, 24,  4,  0 }, {     16,    0,   31, 24,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1376, {
    {     31,   16,    0,  0,  4,  0 }, {     31,   16,    1,  0,  4,  0 }, {     30,   16,    2,  0,  4,  0 }, {     30,   16,    3,  0,  4,  0 }, {     29,   16,    4,  0,  4,  0 },
    {     28,   16,    5,  0,  4,  0 }, {     28,   16,    6,  0,  4,  0 }, {     27,   16,    7,  0,  4,  0 }, {     26,   16,    8,  0,  4,  0 }, {     26,   16,    9,  0,  4,  0 },
    {     25,   16,   10,  0,  3,  0 }, {     24,   16,   11,  0,  3,  0 }, {     23,   16,   12,  0,  3,  0 }, {     23,   16,   13,  0,  3,  0 }, {     22,   16,   14,  0,  3,  0 },
    {     21,   16,   15,  0,  3,  0 }, {     20,   16,   16,  0,  3,  0 }, {     19,   16,   17,  0,  3,  0 }, {     18,   16,   18,  0,  3,  0 }, {     17,   16,   19,  0,  3,  0 },
    {     16,   16,   20,  0,  3,  0 }, {     15,   16,   21,  0,  3,  0 }, {     14,   16,   22,  0,  3,  0 }, {     13,   16,   23,  0,  3,  0 }, {     12,   16,   23,  0,  3,  0 },
    {     11,   16,   24,  0,  3,  0 }, {     10,   16,   25,  0,  3,  0 }, {      9,   16,   26,  0,  2,  0 }, {      8,   16,   26,  0,  2,  0 }, {      7,   16,   27,  0,  2,  0 },
    {      6,   16,   28,  0,  2,  0 }, {      5,   16,   28,  0,  2,  0 }, {      4,   16,   29,  0,  2,  0 }, {      3,   16,   30,  0,  2,  0 }, {      2,   16,   30,  0,  2,  0 },
    {      1,   16,   31,  0,  2,  0 }, {      0,   16,   31,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C14C5, {
    {     16,    0,    0,  8,  4,  0 }, {     16,    0,    1,  8,  4,  0 }, {     16,    1,    2,  8,  4,  0 }, {     16,    1,    3,  8,  4,  0 }, {     16,    2,    4,  8,  4,  0 },
    {     16,    3,    5,  8,  4,  0 }, {     16,    3,    6,  8,  4,  0 }, {     16,    4,    7,  8,  4,  0 }, {     16,    5,    8,  8,  4,  0 }, {     16,    5,    9,  8,  4,  0 },
    {     16,    6,   10,  8,  3,  0 }, {     16,    7,   11,  8,  3,  0 }, {     16,    8,   12,  8,  3,  0 }, {     16,    8,   13,  8,  3,  0 }, {     16,    9,   14,  8,  3,  0 },
    {     16,   10,   15,  8,  3,  0 }, {     16,   11,   16,  8,  3,  0 }, {     16,   12,   17,  8,  3,  0 }, {     16,   13,   18,  8,  3,  0 }, {     16,   14,   19,  8,  3,  0 },
    {     16,   15,   20,  8,  3,  0 }, {     16,   16,   21,  8,  3,  0 }, {     16,   17,   22,  8,  3,  0 }, {     16,   18,   23,  8,  3,  0 }, {     16,   19,   23,  8,  3,  0 },
    {     16,   20,   24,  8,  3,  0 }, {     16,   21,   25,  8,  3,  0 }, {     16,   22,   26,  8,  2,  0 }, {     16,   23,   26,  8,  2,  0 }, {     16,   24,   27,  8,  2,  0 },
    {     16,   25,   28,  8,  2,  0 }, {     16,   26,   28,  8,  2,  0 }, {     16,   27,   29,  8,  2,  0 }, {     16,   28,   30,  8,  2,  0 }, {     16,   29,   30,  8,  2,  0 },
    {     16,   30,   31,  8,  2,  0 }, {     16,   31,   31,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1614, {
    {      0,   16,    0, 16,  4,  0 }, {      0,   16,    1, 16,  4,  0 }, {      1,   16,    2, 16,  4,  0 }, {      1,   16,    3, 16,  4,  0 }, {      2,   16,    4, 16,  4,  0 },
    {      3,   16,    5, 16,  4,  0 }, {      3,   16,    6, 16,  4,  0 }, {      4,   16,    7, 16,  4,  0 }, {      5,   16,    8, 16,  4,  0 }, {      5,   16,    9, 16,  4,  0 },
    {      6,   16,   10, 16,  3,  0 }, {      7,   16,   11, 16,  3,  0 }, {      8,   16,   12, 16,  3,  0 }, {      8,   16,   13, 16,  3,  0 }, {      9,   16,   14, 16,  3,  0 },
    {     10,   16,   15, 16,  3,  0 }, {     11,   16,   16, 16,  3,  0 }, {     12,   16,   17, 16,  3,  0 }, {     13,   16,   18, 16,  3,  0 }, {     14,   16,   19, 16,  3,  0 },
    {     15,   16,   20, 16,  3,  0 }, {     16,   16,   21, 16,  3,  0 }, {     17,   16,   22, 16,  3,  0 }, {     18,   16,   23, 16,  3,  0 }, {     19,   16,   23, 16,  3,  0 },
    {     20,   16,   24, 16,  3,  0 }, {     21,   16,   25, 16,  3,  0 }, {     22,   16,   26, 16,  2,  0 }, {     23,   16,   26, 16,  2,  0 }, {     24,   16,   27, 16,  2,  0 },
    {     25,   16,   28, 16,  2,  0 }, {     26,   16,   28, 16,  2,  0 }, {     27,   16,   29, 16,  2,  0 }, {     28,   16,   30, 16,  2,  0 }, {     29,   16,   30, 16,  2,  0 },
    {     30,   16,   31, 16,  2,  0 }, {     31,   16,   31, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1763, {
    {     16,   31,    0, 24,  4,  0 }, {     16,   31,    1, 24,  4,  0 }, {     16,   30,    2, 24,  4,  0 }, {     16,   30,    3, 24,  4,  0 }, {     16,   29,    4, 24,  4,  0 },
    {     16,   28,    5, 24,  4,  0 }, {     16,   28,    6, 24,  4,  0 }, {     16,   27,    7, 24,  4,  0 }, {     16,   26,    8, 24,  4,  0 }, {     16,   26,    9, 24,  4,  0 },
    {     16,   25,   10, 24,  3,  0 }, {     16,   24,   11, 24,  3,  0 }, {     16,   23,   12, 24,  3,  0 }, {     16,   23,   13, 24,  3,  0 }, {     16,   22,   14, 24,  3,  0 },
    {     16,   21,   15, 24,  3,  0 }, {     16,   20,   16, 24,  3,  0 }, {     16,   19,   17, 24,  3,  0 }, {     16,   18,   18, 24,  3,  0 }, {     16,   17,   19, 24,  3,  0 },
    {     16,   16,   20, 24,  3,  0 }, {     16,   15,   21, 24,  3,  0 }, {     16,   14,   22, 24,  3,  0 }, {     16,   13,   23, 24,  3,  0 }, {     16,   12,   23, 24,  3,  0 },
    {     16,   11,   24, 24,  3,  0 }, {     16,   10,   25, 24,  3,  0 }, {     16,    9,   26, 24,  2,  0 }, {     16,    8,   26, 24,  2,  0 }, {     16,    7,   27, 24,  2,  0 },
    {     16,    6,   28, 24,  2,  0 }, {     16,    5,   28, 24,  2,  0 }, {     16,    4,   29, 24,  2,  0 }, {     16,    3,   30, 24,  2,  0 }, {     16,    2,   30, 24,  2,  0 },
    {     16,    1,   31, 24,  2,  0 }, {     16,    0,   31, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C00A2, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    1,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    2,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    3,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  0,  2,  0 }, {     23,   16,    4,  0,  1,  0 }, {     22,   16,    4,  0,  1,  0 },
    {     21,   16,    4,  0,  1,  0 }, {     20,   16,    5,  0,  1,  0 }, {     19,   16,    5,  0,  1,  0 }, {     18,   16,    5,  0,  1,  0 }, {     17,   16,    6,  0,  1,  0 },
    {     16,   16,    6,  0,  1,  0 }, {     15,   16,    6,  0,  1,  0 }, {     14,   16,    6,  0,  1,  0 }, {     13,   16,    7,  0,  1,  0 }, {     12,   16,    7,  0,  1,  0 },
    {     11,   16,    7,  0,  1,  0 }, {     10,   16,    7,  0,  1,  0 }, {      9,   16,    7,  0,  0,  0 }, {      8,   16,    7,  0,  0,  0 }, {      7,   16,    8,  0,  0,  0 },
    {      6,   16,    8,  0,  0,  0 }, {      5,   16,    8,  0,  0,  0 }, {      4,   16,    8,  0,  0,  0 }, {      3,   16,    8,  0,  0,  0 }, {      2,   16,    8,  0,  0,  0 },
    {      1,   16,    8,  0,  0,  0 }, {      0,   16,    8,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C01C4, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    4,  8,  1,  0 }, {     16,    9,    4,  8,  1,  0 },
    {     16,   10,    4,  8,  1,  0 }, {     16,   11,    5,  8,  1,  0 }, {     16,   12,    5,  8,  1,  0 }, {     16,   13,    5,  8,  1,  0 }, {     16,   14,    6,  8,  1,  0 },
    {     16,   15,    6,  8,  1,  0 }, {     16,   16,    6,  8,  1,  0 }, {     16,   17,    6,  8,  1,  0 }, {     16,   18,    7,  8,  1,  0 }, {     16,   19,    7,  8,  1,  0 },
    {     16,   20,    7,  8,  1,  0 }, {     16,   21,    7,  8,  1,  0 }, {     16,   22,    7,  8,  0,  0 }, {     16,   23,    7,  8,  0,  0 }, {     16,   24,    8,  8,  0,  0 },
    {     16,   25,    8,  8,  0,  0 }, {     16,   26,    8,  8,  0,  0 }, {     16,   27,    8,  8,  0,  0 }, {     16,   28,    8,  8,  0,  0 }, {     16,   29,    8,  8,  0,  0 },
    {     16,   30,    8,  8,  0,  0 }, {     16,   31,    8,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C02E6, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    4, 16,  1,  0 }, {      9,   16,    4, 16,  1,  0 },
    {     10,   16,    4, 16,  1,  0 }, {     11,   16,    5, 16,  1,  0 }, {     12,   16,    5, 16,  1,  0 }, {     13,   16,    5, 16,  1,  0 }, {     14,   16,    6, 16,  1,  0 },
    {     15,   16,    6, 16,  1,  0 }, {     16,   16,    6, 16,  1,  0 }, {     17,   16,    6, 16,  1,  0 }, {     18,   16,    7, 16,  1,  0 }, {     19,   16,    7, 16,  1,  0 },
    {     20,   16,    7, 16,  1,  0 }, {     21,   16,    7, 16,  1,  0 }, {     22,   16,    7, 16,  0,  0 }, {     23,   16,    7, 16,  0,  0 }, {     24,   16,    8, 16,  0,  0 },
    {     25,   16,    8, 16,  0,  0 }, {     26,   16,    8, 16,  0,  0 }, {     27,   16,    8, 16,  0,  0 }, {     28,   16,    8, 16,  0,  0 }, {     29,   16,    8, 16,  0,  0 },
    {     30,   16,    8, 16,  0,  0 }, {     31,   16,    8, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0408, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    1, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    2, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    3, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 24,  2,  0 }, {     16,   23,    4, 24,  1,  0 }, {     16,   22,    4, 24,  1,  0 },
    {     16,   21,    4, 24,  1,  0 }, {     16,   20,    5, 24,  1,  0 }, {     16,   19,    5, 24,  1,  0 }, {     16,   18,    5, 24,  1,  0 }, {     16,   17,    6, 24,  1,  0 },
    {     16,   16,    6, 24,  1,  0 }, {     16,   15,    6, 24,  1,  0 }, {     16,   14,    6, 24,  1,  0 }, {     16,   13,    7, 24,  1,  0 }, {     16,   12,    7, 24,  1,  0 },
    {     16,   11,    7, 24,  1,  0 }, {     16,   10,    7, 24,  1,  0 }, {     16,    9,    7, 24,  0,  0 }, {     16,    8,    7, 24,  0,  0 }, {     16,    7,    8, 24,  0,  0 },
    {     16,    6,    8, 24,  0,  0 }, {     16,    5,    8, 24,  0,  0 }, {     16,    4,    8, 24,  0,  0 }, {     16,    3,    8, 24,  0,  0 }, {     16,    2,    8, 24,  0,  0 },
    {     16,    1,    8, 24,  0,  0 }, {     16,    0,    8, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C27B2, {
    {     31,   16,   15,  0,  6,  0 }, {     30,   16,   15,  0,  6,  0 }, {     29,   16,   14,  0,  6,  0 }, {     28,   16,   14,  0,  6,  0 }, {     27,   16,   13,  0,  6,  0 },
    {     26,   16,   13,  0,  6,  0 }, {     25,   16,   12,  0,  6,  0 }, {     24,   16,   12,  0,  6,  0 }, {     23,   16,   11,  0,  6,  0 }, {     22,   16,   11,  0,  6,  0 },
    {     21,   16,   10,  0,  6,  0 }, {     20,   16,   10,  0,  6,  0 }, {     19,   16,    9,  0,  6,  0 }, {     18,   16,    9,  0,  6,  0 }, {     17,   16,    8,  0,  6,  0 },
    {     16,   16,    8,  0,  6,  0 }, {     15,   16,    7,  0,  6,  0 }, {     14,   16,    7,  0,  6,  0 }, {     13,   16,    6,  0,  6,  0 }, {     12,   16,    6,  0,  6,  0 },
    {     11,   16,    5,  0,  6,  0 }, {     10,   16,    5,  0,  6,  0 }, {      9,   16,    4,  0,  6,  0 }, {      8,   16,    4,  0,  6,  0 }, {      7,   16,    3,  0,  6,  0 },
    {      6,   16,    3,  0,  6,  0 }, {      5,   16,    2,  0,  6,  0 }, {      4,   16,    2,  0,  6,  0 }, {      3,   16,    1,  0,  6,  0 }, {      2,   16,    1,  0,  6,  0 },
    {      1,   16,    0,  0,  6,  0 }, {      0,   16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C28D4, {
    {     16,    0,   15,  8,  6,  0 }, {     16,    1,   14,  8,  6,  0 }, {     16,    2,   14,  8,  6,  0 }, {     16,    3,   13,  8,  6,  0 }, {     16,    4,   13,  8,  6,  0 },
    {     16,    5,   12,  8,  6,  0 }, {     16,    6,   12,  8,  6,  0 }, {     16,    7,   11,  8,  6,  0 }, {     16,    8,   11,  8,  6,  0 }, {     16,    9,   10,  8,  6,  0 },
    {     16,   10,   10,  8,  6,  0 }, {     16,   11,    9,  8,  6,  0 }, {     16,   12,    9,  8,  6,  0 }, {     16,   13,    8,  8,  6,  0 }, {     16,   14,    8,  8,  6,  0 },
    {     16,   15,    7,  8,  6,  0 }, {     16,   16,    7,  8,  6,  0 }, {     16,   17,    6,  8,  6,  0 }, {     16,   18,    6,  8,  6,  0 }, {     16,   19,    5,  8,  6,  0 },
    {     16,   20,    5,  8,  6,  0 }, {     16,   21,    4,  8,  6,  0 }, {     16,   22,    4,  8,  6,  0 }, {     16,   23,    3,  8,  6,  0 }, {     16,   24,    3,  8,  6,  0 },
    {     16,   25,    2,  8,  6,  0 }, {     16,   26,    2,  8,  6,  0 }, {     16,   27,    1,  8,  6,  0 }, {     16,   28,    1,  8,  6,  0 }, {     16,   29,    0,  8,  6,  0 },
    {     16,   30,    0,  8,  6,  0 }, {     16,   31,   -1,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C29F6, {
    {      0,   16,   15, 16,  6,  0 }, {      1,   16,   14, 16,  6,  0 }, {      2,   16,   14, 16,  6,  0 }, {      3,   16,   13, 16,  6,  0 }, {      4,   16,   13, 16,  6,  0 },
    {      5,   16,   12, 16,  6,  0 }, {      6,   16,   12, 16,  6,  0 }, {      7,   16,   11, 16,  6,  0 }, {      8,   16,   11, 16,  6,  0 }, {      9,   16,   10, 16,  6,  0 },
    {     10,   16,   10, 16,  6,  0 }, {     11,   16,    9, 16,  6,  0 }, {     12,   16,    9, 16,  6,  0 }, {     13,   16,    8, 16,  6,  0 }, {     14,   16,    8, 16,  6,  0 },
    {     15,   16,    7, 16,  6,  0 }, {     16,   16,    7, 16,  6,  0 }, {     17,   16,    6, 16,  6,  0 }, {     18,   16,    6, 16,  6,  0 }, {     19,   16,    5, 16,  6,  0 },
    {     20,   16,    5, 16,  6,  0 }, {     21,   16,    4, 16,  6,  0 }, {     22,   16,    4, 16,  6,  0 }, {     23,   16,    3, 16,  6,  0 }, {     24,   16,    3, 16,  6,  0 },
    {     25,   16,    2, 16,  6,  0 }, {     26,   16,    2, 16,  6,  0 }, {     27,   16,    1, 16,  6,  0 }, {     28,   16,    1, 16,  6,  0 }, {     29,   16,    0, 16,  6,  0 },
    {     30,   16,    0, 16,  6,  0 }, {     31,   16,   -1, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2B18, {
    {     16,   31,   15, 24,  6,  0 }, {     16,   30,   15, 24,  6,  0 }, {     16,   29,   14, 24,  6,  0 }, {     16,   28,   14, 24,  6,  0 }, {     16,   27,   13, 24,  6,  0 },
    {     16,   26,   13, 24,  6,  0 }, {     16,   25,   12, 24,  6,  0 }, {     16,   24,   12, 24,  6,  0 }, {     16,   23,   11, 24,  6,  0 }, {     16,   22,   11, 24,  6,  0 },
    {     16,   21,   10, 24,  6,  0 }, {     16,   20,   10, 24,  6,  0 }, {     16,   19,    9, 24,  6,  0 }, {     16,   18,    9, 24,  6,  0 }, {     16,   17,    8, 24,  6,  0 },
    {     16,   16,    8, 24,  6,  0 }, {     16,   15,    7, 24,  6,  0 }, {     16,   14,    7, 24,  6,  0 }, {     16,   13,    6, 24,  6,  0 }, {     16,   12,    6, 24,  6,  0 },
    {     16,   11,    5, 24,  6,  0 }, {     16,   10,    5, 24,  6,  0 }, {     16,    9,    4, 24,  6,  0 }, {     16,    8,    4, 24,  6,  0 }, {     16,    7,    3, 24,  6,  0 },
    {     16,    6,    3, 24,  6,  0 }, {     16,    5,    2, 24,  6,  0 }, {     16,    4,    2, 24,  6,  0 }, {     16,    3,    1, 24,  6,  0 }, {     16,    2,    1, 24,  6,  0 },
    {     16,    1,    0, 24,  6,  0 }, {     16,    0,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2C3A, {
    {     31,   16,   63,  0,  8,  0 }, {     31,   16,   62,  0,  8,  0 }, {     30,   16,   61,  0,  8,  0 }, {     30,   16,   60,  0,  8,  0 }, {     29,   16,   59,  0,  8,  0 },
    {     29,   16,   58,  0,  8,  0 }, {     28,   16,   57,  0,  8,  0 }, {     28,   16,   56,  0,  8,  0 }, {     27,   16,   55,  0,  8,  0 }, {     27,   16,   54,  0,  8,  0 },
    {     26,   16,   53,  0,  8,  0 }, {     26,   16,   52,  0,  8,  0 }, {     25,   16,   51,  0,  8,  0 }, {     25,   16,   50,  0,  8,  0 }, {     24,   16,   49,  0,  8,  0 },
    {     24,   16,   48,  0,  8,  0 }, {     23,   16,   47,  0,  8,  0 }, {     23,   16,   46,  0,  8,  0 }, {     22,   16,   45,  0,  8,  0 }, {     22,   16,   44,  0,  8,  0 },
    {     21,   16,   43,  0,  8,  0 }, {     21,   16,   42,  0,  8,  0 }, {     20,   16,   41,  0,  8,  0 }, {     20,   16,   40,  0,  8,  0 }, {     19,   16,   39,  0,  8,  0 },
    {     19,   16,   38,  0,  8,  0 }, {     18,   16,   37,  0,  8,  0 }, {     18,   16,   36,  0,  8,  0 }, {     17,   16,   35,  0,  8,  0 }, {     17,   16,   34,  0,  8,  0 },
    {     16,   16,   33,  0,  8,  0 }, {     16,   16,   32,  0,  8,  0 }, {     15,   16,   31,  0,  8,  0 }, {     15,   16,   30,  0,  8,  0 }, {     14,   16,   29,  0,  8,  0 },
    {     14,   16,   28,  0,  8,  0 }, {     13,   16,   27,  0,  8,  0 }, {     13,   16,   26,  0,  8,  0 }, {     12,   16,   25,  0,  8,  0 }, {     12,   16,   24,  0,  8,  0 },
    {     11,   16,   23,  0,  8,  0 }, {     11,   16,   22,  0,  8,  0 }, {     10,   16,   21,  0,  8,  0 }, {     10,   16,   20,  0,  8,  0 }, {      9,   16,   19,  0,  8,  0 },
    {      9,   16,   18,  0,  8,  0 }, {      8,   16,   17,  0,  8,  0 }, {      8,   16,   16,  0,  8,  0 }, {      7,   16,   15,  0,  8,  0 }, {      7,   16,   14,  0,  8,  0 },
    {      6,   16,   13,  0,  8,  0 }, {      6,   16,   12,  0,  8,  0 }, {      5,   16,   11,  0,  8,  0 }, {      5,   16,   10,  0,  8,  0 }, {      4,   16,    9,  0,  8,  0 },
    {      4,   16,    8,  0,  8,  0 }, {      3,   16,    7,  0,  8,  0 }, {      3,   16,    6,  0,  8,  0 }, {      2,   16,    5,  0,  8,  0 }, {      2,   16,    4,  0,  8,  0 },
    {      1,   16,    3,  0,  8,  0 }, {      1,   16,    2,  0,  8,  0 }, {      0,   16,    1,  0,  8,  0 }, {      0,   16,    0,  0,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C2E7C, {
    {     16,    0,   63,  8,  8,  0 }, {     16,    0,   62,  8,  8,  0 }, {     16,    1,   61,  8,  8,  0 }, {     16,    1,   60,  8,  8,  0 }, {     16,    2,   59,  8,  8,  0 },
    {     16,    2,   58,  8,  8,  0 }, {     16,    3,   57,  8,  8,  0 }, {     16,    3,   56,  8,  8,  0 }, {     16,    4,   55,  8,  8,  0 }, {     16,    4,   54,  8,  8,  0 },
    {     16,    5,   53,  8,  8,  0 }, {     16,    5,   52,  8,  8,  0 }, {     16,    6,   51,  8,  8,  0 }, {     16,    6,   50,  8,  8,  0 }, {     16,    7,   49,  8,  8,  0 },
    {     16,    7,   48,  8,  8,  0 }, {     16,    8,   47,  8,  8,  0 }, {     16,    8,   46,  8,  8,  0 }, {     16,    9,   45,  8,  8,  0 }, {     16,    9,   44,  8,  8,  0 },
    {     16,   10,   43,  8,  8,  0 }, {     16,   10,   42,  8,  8,  0 }, {     16,   11,   41,  8,  8,  0 }, {     16,   11,   40,  8,  8,  0 }, {     16,   12,   39,  8,  8,  0 },
    {     16,   12,   38,  8,  8,  0 }, {     16,   13,   37,  8,  8,  0 }, {     16,   13,   36,  8,  8,  0 }, {     16,   14,   35,  8,  8,  0 }, {     16,   14,   34,  8,  8,  0 },
    {     16,   15,   33,  8,  8,  0 }, {     16,   15,   32,  8,  8,  0 }, {     16,   16,   31,  8,  8,  0 }, {     16,   16,   30,  8,  8,  0 }, {     16,   17,   29,  8,  8,  0 },
    {     16,   17,   28,  8,  8,  0 }, {     16,   18,   27,  8,  8,  0 }, {     16,   18,   26,  8,  8,  0 }, {     16,   19,   25,  8,  8,  0 }, {     16,   19,   24,  8,  8,  0 },
    {     16,   20,   23,  8,  8,  0 }, {     16,   20,   22,  8,  8,  0 }, {     16,   21,   21,  8,  8,  0 }, {     16,   21,   20,  8,  8,  0 }, {     16,   22,   19,  8,  8,  0 },
    {     16,   22,   18,  8,  8,  0 }, {     16,   23,   17,  8,  8,  0 }, {     16,   23,   16,  8,  8,  0 }, {     16,   24,   15,  8,  8,  0 }, {     16,   24,   14,  8,  8,  0 },
    {     16,   25,   13,  8,  8,  0 }, {     16,   25,   12,  8,  8,  0 }, {     16,   26,   11,  8,  8,  0 }, {     16,   26,   10,  8,  8,  0 }, {     16,   27,    9,  8,  8,  0 },
    {     16,   27,    8,  8,  8,  0 }, {     16,   28,    7,  8,  8,  0 }, {     16,   28,    6,  8,  8,  0 }, {     16,   29,    5,  8,  8,  0 }, {     16,   29,    4,  8,  8,  0 },
    {     16,   30,    3,  8,  8,  0 }, {     16,   30,    2,  8,  8,  0 }, {     16,   31,    1,  8,  8,  0 }, {     16,   31,    0,  8,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C30BE, {
    {      0,   16,   63, 16,  8,  0 }, {      0,   16,   62, 16,  8,  0 }, {      1,   16,   61, 16,  8,  0 }, {      1,   16,   60, 16,  8,  0 }, {      2,   16,   59, 16,  8,  0 },
    {      2,   16,   58, 16,  8,  0 }, {      3,   16,   57, 16,  8,  0 }, {      3,   16,   56, 16,  8,  0 }, {      4,   16,   55, 16,  8,  0 }, {      4,   16,   54, 16,  8,  0 },
    {      5,   16,   53, 16,  8,  0 }, {      5,   16,   52, 16,  8,  0 }, {      6,   16,   51, 16,  8,  0 }, {      6,   16,   50, 16,  8,  0 }, {      7,   16,   49, 16,  8,  0 },
    {      7,   16,   48, 16,  8,  0 }, {      8,   16,   47, 16,  8,  0 }, {      8,   16,   46, 16,  8,  0 }, {      9,   16,   45, 16,  8,  0 }, {      9,   16,   44, 16,  8,  0 },
    {     10,   16,   43, 16,  8,  0 }, {     10,   16,   42, 16,  8,  0 }, {     11,   16,   41, 16,  8,  0 }, {     11,   16,   40, 16,  8,  0 }, {     12,   16,   39, 16,  8,  0 },
    {     12,   16,   38, 16,  8,  0 }, {     13,   16,   37, 16,  8,  0 }, {     13,   16,   36, 16,  8,  0 }, {     14,   16,   35, 16,  8,  0 }, {     14,   16,   34, 16,  8,  0 },
    {     15,   16,   33, 16,  8,  0 }, {     15,   16,   32, 16,  8,  0 }, {     16,   16,   31, 16,  8,  0 }, {     16,   16,   30, 16,  8,  0 }, {     17,   16,   29, 16,  8,  0 },
    {     17,   16,   28, 16,  8,  0 }, {     18,   16,   27, 16,  8,  0 }, {     18,   16,   26, 16,  8,  0 }, {     19,   16,   25, 16,  8,  0 }, {     19,   16,   24, 16,  8,  0 },
    {     20,   16,   23, 16,  8,  0 }, {     20,   16,   22, 16,  8,  0 }, {     21,   16,   21, 16,  8,  0 }, {     21,   16,   20, 16,  8,  0 }, {     22,   16,   19, 16,  8,  0 },
    {     22,   16,   18, 16,  8,  0 }, {     23,   16,   17, 16,  8,  0 }, {     23,   16,   16, 16,  8,  0 }, {     24,   16,   15, 16,  8,  0 }, {     24,   16,   14, 16,  8,  0 },
    {     25,   16,   13, 16,  8,  0 }, {     25,   16,   12, 16,  8,  0 }, {     26,   16,   11, 16,  8,  0 }, {     26,   16,   10, 16,  8,  0 }, {     27,   16,    9, 16,  8,  0 },
    {     27,   16,    8, 16,  8,  0 }, {     28,   16,    7, 16,  8,  0 }, {     28,   16,    6, 16,  8,  0 }, {     29,   16,    5, 16,  8,  0 }, {     29,   16,    4, 16,  8,  0 },
    {     30,   16,    3, 16,  8,  0 }, {     30,   16,    2, 16,  8,  0 }, {     31,   16,    1, 16,  8,  0 }, {     31,   16,    0, 16,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3300, {
    {     16,   31,   63, 24,  8,  0 }, {     16,   31,   62, 24,  8,  0 }, {     16,   30,   61, 24,  8,  0 }, {     16,   30,   60, 24,  8,  0 }, {     16,   29,   59, 24,  8,  0 },
    {     16,   29,   58, 24,  8,  0 }, {     16,   28,   57, 24,  8,  0 }, {     16,   28,   56, 24,  8,  0 }, {     16,   27,   55, 24,  8,  0 }, {     16,   27,   54, 24,  8,  0 },
    {     16,   26,   53, 24,  8,  0 }, {     16,   26,   52, 24,  8,  0 }, {     16,   25,   51, 24,  8,  0 }, {     16,   25,   50, 24,  8,  0 }, {     16,   24,   49, 24,  8,  0 },
    {     16,   24,   48, 24,  8,  0 }, {     16,   23,   47, 24,  8,  0 }, {     16,   23,   46, 24,  8,  0 }, {     16,   22,   45, 24,  8,  0 }, {     16,   22,   44, 24,  8,  0 },
    {     16,   21,   43, 24,  8,  0 }, {     16,   21,   42, 24,  8,  0 }, {     16,   20,   41, 24,  8,  0 }, {     16,   20,   40, 24,  8,  0 }, {     16,   19,   39, 24,  8,  0 },
    {     16,   19,   38, 24,  8,  0 }, {     16,   18,   37, 24,  8,  0 }, {     16,   18,   36, 24,  8,  0 }, {     16,   17,   35, 24,  8,  0 }, {     16,   17,   34, 24,  8,  0 },
    {     16,   16,   33, 24,  8,  0 }, {     16,   16,   32, 24,  8,  0 }, {     16,   15,   31, 24,  8,  0 }, {     16,   15,   30, 24,  8,  0 }, {     16,   14,   29, 24,  8,  0 },
    {     16,   14,   28, 24,  8,  0 }, {     16,   13,   27, 24,  8,  0 }, {     16,   13,   26, 24,  8,  0 }, {     16,   12,   25, 24,  8,  0 }, {     16,   12,   24, 24,  8,  0 },
    {     16,   11,   23, 24,  8,  0 }, {     16,   11,   22, 24,  8,  0 }, {     16,   10,   21, 24,  8,  0 }, {     16,   10,   20, 24,  8,  0 }, {     16,    9,   19, 24,  8,  0 },
    {     16,    9,   18, 24,  8,  0 }, {     16,    8,   17, 24,  8,  0 }, {     16,    8,   16, 24,  8,  0 }, {     16,    7,   15, 24,  8,  0 }, {     16,    7,   14, 24,  8,  0 },
    {     16,    6,   13, 24,  8,  0 }, {     16,    6,   12, 24,  8,  0 }, {     16,    5,   11, 24,  8,  0 }, {     16,    5,   10, 24,  8,  0 }, {     16,    4,    9, 24,  8,  0 },
    {     16,    4,    8, 24,  8,  0 }, {     16,    3,    7, 24,  8,  0 }, {     16,    3,    6, 24,  8,  0 }, {     16,    2,    5, 24,  8,  0 }, {     16,    2,    4, 24,  8,  0 },
    {     16,    1,    3, 24,  8,  0 }, {     16,    1,    2, 24,  8,  0 }, {     16,    0,    1, 24,  8,  0 }, {     16,    0,    0, 24,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C09B2, {
    {     31,   16,    8,  0,  0,  0 }, {     30,   16,    8,  0,  0,  0 }, {     29,   16,    8,  0,  0,  0 }, {     28,   16,    8,  0,  0,  0 }, {     27,   16,    8,  0,  0,  0 },
    {     26,   16,    8,  0,  0,  0 }, {     25,   16,    8,  0,  0,  0 }, {     24,   16,    8,  0,  0,  0 }, {     23,   16,    7,  0,  5,  0 }, {     22,   16,    7,  0,  5,  0 },
    {     21,   16,    7,  0,  5,  0 }, {     20,   16,    7,  0,  5,  0 }, {     19,   16,    7,  0,  5,  0 }, {     18,   16,    7,  0,  5,  0 }, {     17,   16,    6,  0,  5,  0 },
    {     16,   16,    6,  0,  5,  0 }, {     15,   16,    6,  0,  5,  0 }, {     14,   16,    6,  0,  5,  0 }, {     13,   16,    5,  0,  5,  0 }, {     12,   16,    5,  0,  5,  0 },
    {     11,   16,    5,  0,  5,  0 }, {     10,   16,    4,  0,  5,  0 }, {      9,   16,    4,  0,  5,  0 }, {      8,   16,    4,  0,  5,  0 }, {      7,   16,    3,  0,  6,  0 },
    {      6,   16,    3,  0,  6,  0 }, {      5,   16,    2,  0,  6,  0 }, {      4,   16,    2,  0,  6,  0 }, {      3,   16,    1,  0,  6,  0 }, {      2,   16,    1,  0,  6,  0 },
    {      1,   16,    0,  0,  6,  0 }, {      0,   16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0AD4, {
    {     16,    0,    8,  8,  0,  0 }, {     16,    1,    8,  8,  0,  0 }, {     16,    2,    8,  8,  0,  0 }, {     16,    3,    8,  8,  0,  0 }, {     16,    4,    8,  8,  0,  0 },
    {     16,    5,    8,  8,  0,  0 }, {     16,    6,    8,  8,  0,  0 }, {     16,    7,    8,  8,  0,  0 }, {     16,    8,    7,  8,  5,  0 }, {     16,    9,    7,  8,  5,  0 },
    {     16,   10,    7,  8,  5,  0 }, {     16,   11,    7,  8,  5,  0 }, {     16,   12,    7,  8,  5,  0 }, {     16,   13,    7,  8,  5,  0 }, {     16,   14,    6,  8,  5,  0 },
    {     16,   15,    6,  8,  5,  0 }, {     16,   16,    6,  8,  5,  0 }, {     16,   17,    6,  8,  5,  0 }, {     16,   18,    5,  8,  5,  0 }, {     16,   19,    5,  8,  5,  0 },
    {     16,   20,    5,  8,  5,  0 }, {     16,   21,    4,  8,  5,  0 }, {     16,   22,    4,  8,  5,  0 }, {     16,   23,    4,  8,  5,  0 }, {     16,   24,    3,  8,  6,  0 },
    {     16,   25,    3,  8,  6,  0 }, {     16,   26,    3,  8,  6,  0 }, {     16,   27,    2,  8,  6,  0 }, {     16,   28,    2,  8,  6,  0 }, {     16,   29,    1,  8,  6,  0 },
    {     16,   30,    1,  8,  6,  0 }, {     16,   31,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0BF6, {
    {      0,   16,    8, 16,  0,  0 }, {      1,   16,    8, 16,  0,  0 }, {      2,   16,    8, 16,  0,  0 }, {      3,   16,    8, 16,  0,  0 }, {      4,   16,    8, 16,  0,  0 },
    {      5,   16,    8, 16,  0,  0 }, {      6,   16,    8, 16,  0,  0 }, {      7,   16,    8, 16,  0,  0 }, {      8,   16,    7, 16,  5,  0 }, {      9,   16,    7, 16,  5,  0 },
    {     10,   16,    7, 16,  5,  0 }, {     11,   16,    7, 16,  5,  0 }, {     12,   16,    7, 16,  5,  0 }, {     13,   16,    7, 16,  5,  0 }, {     14,   16,    6, 16,  5,  0 },
    {     15,   16,    6, 16,  5,  0 }, {     16,   16,    6, 16,  5,  0 }, {     17,   16,    6, 16,  5,  0 }, {     18,   16,    5, 16,  5,  0 }, {     19,   16,    5, 16,  5,  0 },
    {     20,   16,    5, 16,  5,  0 }, {     21,   16,    4, 16,  5,  0 }, {     22,   16,    4, 16,  5,  0 }, {     23,   16,    4, 16,  5,  0 }, {     24,   16,    3, 16,  6,  0 },
    {     25,   16,    3, 16,  6,  0 }, {     26,   16,    3, 16,  6,  0 }, {     27,   16,    2, 16,  6,  0 }, {     28,   16,    2, 16,  6,  0 }, {     29,   16,    1, 16,  6,  0 },
    {     30,   16,    1, 16,  6,  0 }, {     31,   16,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0D18, {
    {     16,   31,    8, 24,  0,  0 }, {     16,   30,    8, 24,  0,  0 }, {     16,   29,    8, 24,  0,  0 }, {     16,   28,    8, 24,  0,  0 }, {     16,   27,    8, 24,  0,  0 },
    {     16,   26,    8, 24,  0,  0 }, {     16,   25,    8, 24,  0,  0 }, {     16,   24,    8, 24,  0,  0 }, {     16,   23,    7, 24,  5,  0 }, {     16,   22,    7, 24,  5,  0 },
    {     16,   21,    7, 24,  5,  0 }, {     16,   20,    7, 24,  5,  0 }, {     16,   19,    7, 24,  5,  0 }, {     16,   18,    7, 24,  5,  0 }, {     16,   17,    6, 24,  5,  0 },
    {     16,   16,    6, 24,  5,  0 }, {     16,   15,    6, 24,  5,  0 }, {     16,   14,    6, 24,  5,  0 }, {     16,   13,    5, 24,  5,  0 }, {     16,   12,    5, 24,  5,  0 },
    {     16,   11,    5, 24,  5,  0 }, {     16,   10,    4, 24,  5,  0 }, {     16,    9,    4, 24,  5,  0 }, {     16,    8,    4, 24,  5,  0 }, {     16,    7,    3, 24,  6,  0 },
    {     16,    6,    3, 24,  6,  0 }, {     16,    5,    2, 24,  6,  0 }, {     16,    4,    2, 24,  6,  0 }, {     16,    3,    1, 24,  6,  0 }, {     16,    2,    1, 24,  6,  0 },
    {     16,    1,    0, 24,  6,  0 }, {     16,    0,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1DEE, {
    {     31,   16,   31,  0,  6,  0 }, {     30,   16,   31,  0,  6,  0 }, {     29,   16,   30,  0,  6,  0 }, {     28,   16,   30,  0,  6,  0 }, {     27,   16,   29,  0,  6,  0 },
    {     26,   16,   28,  0,  6,  0 }, {     25,   16,   28,  0,  6,  0 }, {     24,   16,   27,  0,  6,  0 }, {     23,   16,   26,  0,  6,  0 }, {     22,   16,   26,  0,  6,  0 },
    {     21,   16,   25,  0,  7,  0 }, {     20,   16,   24,  0,  7,  0 }, {     19,   16,   23,  0,  7,  0 }, {     18,   16,   23,  0,  7,  0 }, {     17,   16,   22,  0,  7,  0 },
    {     16,   16,   21,  0,  7,  0 }, {     15,   16,   20,  0,  7,  0 }, {     14,   16,   19,  0,  7,  0 }, {     13,   16,   18,  0,  7,  0 }, {     12,   16,   16,  0,  7,  0 },
    {     11,   16,   15,  0,  7,  0 }, {     10,   16,   14,  0,  7,  0 }, {      9,   16,   13,  0,  7,  0 }, {      8,   16,   12,  0,  7,  0 }, {      8,   16,   11,  0,  7,  0 },
    {      7,   16,   10,  0,  7,  0 }, {      6,   16,    9,  0,  7,  0 }, {      5,   16,    8,  0,  8,  0 }, {      5,   16,    7,  0,  8,  0 }, {      4,   16,    6,  0,  8,  0 },
    {      3,   16,    5,  0,  8,  0 }, {      3,   16,    4,  0,  8,  0 }, {      2,   16,    3,  0,  8,  0 }, {      1,   16,    2,  0,  8,  0 }, {      1,   16,    1,  0,  8,  0 },
    {      0,   16,    0,  0,  8,  0 }, {      0,   16,   -1,  0,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1F3D, {
    {     16,    0,   31,  8,  6,  0 }, {     16,    1,   31,  8,  6,  0 }, {     16,    2,   30,  8,  6,  0 }, {     16,    3,   30,  8,  6,  0 }, {     16,    4,   29,  8,  6,  0 },
    {     16,    5,   28,  8,  6,  0 }, {     16,    6,   28,  8,  6,  0 }, {     16,    7,   27,  8,  6,  0 }, {     16,    8,   26,  8,  6,  0 }, {     16,    9,   26,  8,  6,  0 },
    {     16,   10,   25,  8,  7,  0 }, {     16,   11,   24,  8,  7,  0 }, {     16,   12,   23,  8,  7,  0 }, {     16,   13,   23,  8,  7,  0 }, {     16,   14,   22,  8,  7,  0 },
    {     16,   15,   21,  8,  7,  0 }, {     16,   16,   20,  8,  7,  0 }, {     16,   17,   19,  8,  7,  0 }, {     16,   18,   18,  8,  7,  0 }, {     16,   19,   16,  8,  7,  0 },
    {     16,   20,   15,  8,  7,  0 }, {     16,   21,   14,  8,  7,  0 }, {     16,   22,   13,  8,  7,  0 }, {     16,   23,   12,  8,  7,  0 }, {     16,   23,   11,  8,  7,  0 },
    {     16,   24,   10,  8,  7,  0 }, {     16,   25,    9,  8,  7,  0 }, {     16,   26,    8,  8,  8,  0 }, {     16,   26,    7,  8,  8,  0 }, {     16,   27,    6,  8,  8,  0 },
    {     16,   28,    5,  8,  8,  0 }, {     16,   28,    4,  8,  8,  0 }, {     16,   29,    3,  8,  8,  0 }, {     16,   30,    2,  8,  8,  0 }, {     16,   30,    1,  8,  8,  0 },
    {     16,   31,    0,  8,  8,  0 }, {     16,   31,   -1,  8,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C208C, {
    {      0,   16,   31, 16,  6,  0 }, {      1,   16,   31, 16,  6,  0 }, {      2,   16,   30, 16,  6,  0 }, {      3,   16,   30, 16,  6,  0 }, {      4,   16,   29, 16,  6,  0 },
    {      5,   16,   28, 16,  6,  0 }, {      6,   16,   28, 16,  6,  0 }, {      7,   16,   27, 16,  6,  0 }, {      8,   16,   26, 16,  6,  0 }, {      9,   16,   26, 16,  6,  0 },
    {     10,   16,   25, 16,  7,  0 }, {     11,   16,   24, 16,  7,  0 }, {     12,   16,   23, 16,  7,  0 }, {     13,   16,   23, 16,  7,  0 }, {     14,   16,   22, 16,  7,  0 },
    {     15,   16,   21, 16,  7,  0 }, {     16,   16,   20, 16,  7,  0 }, {     17,   16,   19, 16,  7,  0 }, {     18,   16,   18, 16,  7,  0 }, {     19,   16,   16, 16,  7,  0 },
    {     20,   16,   15, 16,  7,  0 }, {     21,   16,   14, 16,  7,  0 }, {     22,   16,   13, 16,  7,  0 }, {     23,   16,   12, 16,  7,  0 }, {     23,   16,   11, 16,  7,  0 },
    {     24,   16,   10, 16,  7,  0 }, {     25,   16,    9, 16,  7,  0 }, {     26,   16,    8, 16,  8,  0 }, {     26,   16,    7, 16,  8,  0 }, {     27,   16,    6, 16,  8,  0 },
    {     28,   16,    5, 16,  8,  0 }, {     28,   16,    4, 16,  8,  0 }, {     29,   16,    3, 16,  8,  0 }, {     30,   16,    2, 16,  8,  0 }, {     30,   16,    1, 16,  8,  0 },
    {     31,   16,    0, 16,  8,  0 }, {     31,   16,   -1, 16,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C21DB, {
    {     16,   31,   31, 24,  6,  0 }, {     16,   30,   31, 24,  6,  0 }, {     16,   29,   30, 24,  6,  0 }, {     16,   28,   30, 24,  6,  0 }, {     16,   27,   29, 24,  6,  0 },
    {     16,   26,   28, 24,  6,  0 }, {     16,   25,   28, 24,  6,  0 }, {     16,   24,   27, 24,  6,  0 }, {     16,   23,   26, 24,  6,  0 }, {     16,   22,   26, 24,  6,  0 },
    {     16,   21,   25, 24,  7,  0 }, {     16,   20,   24, 24,  7,  0 }, {     16,   19,   23, 24,  7,  0 }, {     16,   18,   23, 24,  7,  0 }, {     16,   17,   22, 24,  7,  0 },
    {     16,   16,   21, 24,  7,  0 }, {     16,   15,   20, 24,  7,  0 }, {     16,   14,   19, 24,  7,  0 }, {     16,   13,   18, 24,  7,  0 }, {     16,   12,   16, 24,  7,  0 },
    {     16,   11,   15, 24,  7,  0 }, {     16,   10,   14, 24,  7,  0 }, {     16,    9,   13, 24,  7,  0 }, {     16,    8,   12, 24,  7,  0 }, {     16,    8,   11, 24,  7,  0 },
    {     16,    7,   10, 24,  7,  0 }, {     16,    6,    9, 24,  7,  0 }, {     16,    5,    8, 24,  8,  0 }, {     16,    5,    7, 24,  8,  0 }, {     16,    4,    6, 24,  8,  0 },
    {     16,    3,    5, 24,  8,  0 }, {     16,    3,    4, 24,  8,  0 }, {     16,    2,    3, 24,  8,  0 }, {     16,    1,    2, 24,  8,  0 }, {     16,    1,    1, 24,  8,  0 },
    {     16,    0,    0, 24,  8,  0 }, {     16,    0,   -1, 24,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C18B2, {
    {     31,   16,   31,  0,  8,  0 }, {     31,   16,   30,  0,  8,  0 }, {     30,   16,   29,  0,  8,  0 }, {     30,   16,   28,  0,  8,  0 }, {     29,   16,   27,  0,  8,  0 },
    {     28,   16,   26,  0,  8,  0 }, {     28,   16,   25,  0,  8,  0 }, {     27,   16,   24,  0,  8,  0 }, {     26,   16,   23,  0,  8,  0 }, {     26,   16,   22,  0,  8,  0 },
    {     25,   16,   21,  0,  7,  0 }, {     24,   16,   20,  0,  7,  0 }, {     23,   16,   19,  0,  7,  0 }, {     23,   16,   18,  0,  7,  0 }, {     22,   16,   17,  0,  7,  0 },
    {     21,   16,   16,  0,  7,  0 }, {     20,   16,   15,  0,  7,  0 }, {     19,   16,   14,  0,  7,  0 }, {     18,   16,   13,  0,  7,  0 }, {     16,   16,   12,  0,  7,  0 },
    {     15,   16,   11,  0,  7,  0 }, {     14,   16,   10,  0,  7,  0 }, {     13,   16,    9,  0,  7,  0 }, {     12,   16,    8,  0,  7,  0 }, {     11,   16,    8,  0,  7,  0 },
    {     10,   16,    7,  0,  7,  0 }, {      9,   16,    6,  0,  7,  0 }, {      8,   16,    5,  0,  6,  0 }, {      7,   16,    5,  0,  6,  0 }, {      6,   16,    4,  0,  6,  0 },
    {      5,   16,    3,  0,  6,  0 }, {      4,   16,    3,  0,  6,  0 }, {      3,   16,    2,  0,  6,  0 }, {      2,   16,    1,  0,  6,  0 }, {      1,   16,    1,  0,  6,  0 },
    {      0,   16,    0,  0,  6,  0 }, {     -1,   16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1A01, {
    {     16,    0,   31,  8,  8,  0 }, {     16,    0,   30,  8,  8,  0 }, {     16,    1,   29,  8,  8,  0 }, {     16,    1,   28,  8,  8,  0 }, {     16,    2,   27,  8,  8,  0 },
    {     16,    3,   26,  8,  8,  0 }, {     16,    3,   25,  8,  8,  0 }, {     16,    4,   24,  8,  8,  0 }, {     16,    5,   23,  8,  8,  0 }, {     16,    5,   22,  8,  8,  0 },
    {     16,    6,   21,  8,  7,  0 }, {     16,    7,   20,  8,  7,  0 }, {     16,    8,   19,  8,  7,  0 }, {     16,    8,   18,  8,  7,  0 }, {     16,    9,   17,  8,  7,  0 },
    {     16,   10,   16,  8,  7,  0 }, {     16,   11,   15,  8,  7,  0 }, {     16,   12,   14,  8,  7,  0 }, {     16,   13,   13,  8,  7,  0 }, {     16,   15,   12,  8,  7,  0 },
    {     16,   16,   11,  8,  7,  0 }, {     16,   17,   10,  8,  7,  0 }, {     16,   18,    9,  8,  7,  0 }, {     16,   19,    8,  8,  7,  0 }, {     16,   20,    8,  8,  7,  0 },
    {     16,   21,    7,  8,  7,  0 }, {     16,   22,    6,  8,  7,  0 }, {     16,   23,    5,  8,  6,  0 }, {     16,   24,    5,  8,  6,  0 }, {     16,   25,    4,  8,  6,  0 },
    {     16,   26,    3,  8,  6,  0 }, {     16,   27,    3,  8,  6,  0 }, {     16,   28,    2,  8,  6,  0 }, {     16,   29,    1,  8,  6,  0 }, {     16,   30,    1,  8,  6,  0 },
    {     16,   31,    0,  8,  6,  0 }, {     16,   32,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1B50, {
    {      0,   16,   31, 16,  8,  0 }, {      0,   16,   30, 16,  8,  0 }, {      1,   16,   29, 16,  8,  0 }, {      1,   16,   28, 16,  8,  0 }, {      2,   16,   27, 16,  8,  0 },
    {      3,   16,   26, 16,  8,  0 }, {      3,   16,   25, 16,  8,  0 }, {      4,   16,   24, 16,  8,  0 }, {      5,   16,   23, 16,  8,  0 }, {      5,   16,   22, 16,  8,  0 },
    {      6,   16,   21, 16,  7,  0 }, {      7,   16,   20, 16,  7,  0 }, {      8,   16,   19, 16,  7,  0 }, {      8,   16,   18, 16,  7,  0 }, {      9,   16,   17, 16,  7,  0 },
    {     10,   16,   16, 16,  7,  0 }, {     11,   16,   15, 16,  7,  0 }, {     12,   16,   14, 16,  7,  0 }, {     13,   16,   13, 16,  7,  0 }, {     15,   16,   12, 16,  7,  0 },
    {     16,   16,   11, 16,  7,  0 }, {     17,   16,   10, 16,  7,  0 }, {     18,   16,    9, 16,  7,  0 }, {     19,   16,    8, 16,  7,  0 }, {     20,   16,    8, 16,  7,  0 },
    {     21,   16,    7, 16,  7,  0 }, {     22,   16,    6, 16,  7,  0 }, {     23,   16,    5, 16,  6,  0 }, {     24,   16,    5, 16,  6,  0 }, {     25,   16,    4, 16,  6,  0 },
    {     26,   16,    3, 16,  6,  0 }, {     27,   16,    3, 16,  6,  0 }, {     28,   16,    2, 16,  6,  0 }, {     29,   16,    1, 16,  6,  0 }, {     30,   16,    1, 16,  6,  0 },
    {     31,   16,    0, 16,  6,  0 }, {     32,   16,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C1C9F, {
    {     16,   31,   31, 24,  8,  0 }, {     16,   31,   30, 24,  8,  0 }, {     16,   30,   29, 24,  8,  0 }, {     16,   30,   28, 24,  8,  0 }, {     16,   29,   27, 24,  8,  0 },
    {     16,   28,   26, 24,  8,  0 }, {     16,   28,   25, 24,  8,  0 }, {     16,   27,   24, 24,  8,  0 }, {     16,   26,   23, 24,  8,  0 }, {     16,   26,   22, 24,  8,  0 },
    {     16,   25,   21, 24,  7,  0 }, {     16,   24,   20, 24,  7,  0 }, {     16,   23,   19, 24,  7,  0 }, {     16,   23,   18, 24,  7,  0 }, {     16,   22,   17, 24,  7,  0 },
    {     16,   21,   16, 24,  7,  0 }, {     16,   20,   15, 24,  7,  0 }, {     16,   19,   14, 24,  7,  0 }, {     16,   18,   13, 24,  7,  0 }, {     16,   16,   12, 24,  7,  0 },
    {     16,   15,   11, 24,  7,  0 }, {     16,   14,   10, 24,  7,  0 }, {     16,   13,    9, 24,  7,  0 }, {     16,   12,    8, 24,  7,  0 }, {     16,   11,    8, 24,  7,  0 },
    {     16,   10,    7, 24,  7,  0 }, {     16,    9,    6, 24,  7,  0 }, {     16,    8,    5, 24,  6,  0 }, {     16,    7,    5, 24,  6,  0 }, {     16,    6,    4, 24,  6,  0 },
    {     16,    5,    3, 24,  6,  0 }, {     16,    4,    3, 24,  6,  0 }, {     16,    3,    2, 24,  6,  0 }, {     16,    2,    1, 24,  6,  0 }, {     16,    1,    1, 24,  6,  0 },
    {     16,    0,    0, 24,  6,  0 }, {     16,   -1,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C052A, {
    {     31,   16,    7,  0,  6,  0 }, {     30,   16,    7,  0,  6,  0 }, {     29,   16,    6,  0,  6,  0 }, {     28,   16,    6,  0,  6,  0 }, {     27,   16,    5,  0,  6,  0 },
    {     26,   16,    5,  0,  6,  0 }, {     25,   16,    4,  0,  6,  0 }, {     24,   16,    4,  0,  6,  0 }, {     23,   16,    4,  0,  5,  0 }, {     22,   16,    3,  0,  5,  0 },
    {     21,   16,    3,  0,  5,  0 }, {     20,   16,    3,  0,  5,  0 }, {     19,   16,    2,  0,  5,  0 }, {     18,   16,    2,  0,  5,  0 }, {     17,   16,    2,  0,  5,  0 },
    {     16,   16,    2,  0,  5,  0 }, {     15,   16,    1,  0,  5,  0 }, {     14,   16,    1,  0,  5,  0 }, {     13,   16,    1,  0,  5,  0 }, {     12,   16,    1,  0,  5,  0 },
    {     11,   16,    1,  0,  5,  0 }, {     10,   16,    1,  0,  5,  0 }, {      9,   16,    0,  0,  0,  0 }, {      8,   16,    0,  0,  0,  0 }, {      7,   16,    0,  0,  0,  0 },
    {      6,   16,    0,  0,  0,  0 }, {      5,   16,    0,  0,  0,  0 }, {      4,   16,    0,  0,  0,  0 }, {      3,   16,    0,  0,  0,  0 }, {      2,   16,    0,  0,  0,  0 },
    {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C064C, {
    {     16,    0,    8,  8,  6,  0 }, {     16,    1,    7,  8,  6,  0 }, {     16,    2,    7,  8,  6,  0 }, {     16,    3,    6,  8,  6,  0 }, {     16,    4,    6,  8,  6,  0 },
    {     16,    5,    5,  8,  6,  0 }, {     16,    6,    5,  8,  6,  0 }, {     16,    7,    4,  8,  6,  0 }, {     16,    8,    4,  8,  5,  0 }, {     16,    9,    3,  8,  5,  0 },
    {     16,   10,    3,  8,  5,  0 }, {     16,   11,    3,  8,  5,  0 }, {     16,   12,    2,  8,  5,  0 }, {     16,   13,    2,  8,  5,  0 }, {     16,   14,    2,  8,  5,  0 },
    {     16,   15,    2,  8,  5,  0 }, {     16,   16,    1,  8,  5,  0 }, {     16,   17,    1,  8,  5,  0 }, {     16,   18,    1,  8,  5,  0 }, {     16,   19,    1,  8,  5,  0 },
    {     16,   20,    1,  8,  5,  0 }, {     16,   21,    1,  8,  5,  0 }, {     16,   22,    0,  8,  0,  0 }, {     16,   23,    0,  8,  0,  0 }, {     16,   24,    0,  8,  0,  0 },
    {     16,   25,    0,  8,  0,  0 }, {     16,   26,    0,  8,  0,  0 }, {     16,   27,    0,  8,  0,  0 }, {     16,   28,    0,  8,  0,  0 }, {     16,   29,    0,  8,  0,  0 },
    {     16,   30,    0,  8,  0,  0 }, {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C076E, {
    {      0,   16,    8, 16,  6,  0 }, {      1,   16,    7, 16,  6,  0 }, {      2,   16,    7, 16,  6,  0 }, {      3,   16,    6, 16,  6,  0 }, {      4,   16,    6, 16,  6,  0 },
    {      5,   16,    5, 16,  6,  0 }, {      6,   16,    5, 16,  6,  0 }, {      7,   16,    4, 16,  6,  0 }, {      8,   16,    4, 16,  5,  0 }, {      9,   16,    3, 16,  5,  0 },
    {     10,   16,    3, 16,  5,  0 }, {     11,   16,    3, 16,  5,  0 }, {     12,   16,    2, 16,  5,  0 }, {     13,   16,    2, 16,  5,  0 }, {     14,   16,    2, 16,  5,  0 },
    {     15,   16,    2, 16,  5,  0 }, {     16,   16,    1, 16,  5,  0 }, {     17,   16,    1, 16,  5,  0 }, {     18,   16,    1, 16,  5,  0 }, {     19,   16,    1, 16,  5,  0 },
    {     20,   16,    1, 16,  5,  0 }, {     21,   16,    1, 16,  5,  0 }, {     22,   16,    0, 16,  0,  0 }, {     23,   16,    0, 16,  0,  0 }, {     24,   16,    0, 16,  0,  0 },
    {     25,   16,    0, 16,  0,  0 }, {     26,   16,    0, 16,  0,  0 }, {     27,   16,    0, 16,  0,  0 }, {     28,   16,    0, 16,  0,  0 }, {     29,   16,    0, 16,  0,  0 },
    {     30,   16,    0, 16,  0,  0 }, {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C0890, {
    {     16,   31,    7, 24,  6,  0 }, {     16,   30,    7, 24,  6,  0 }, {     16,   29,    6, 24,  6,  0 }, {     16,   28,    6, 24,  6,  0 }, {     16,   27,    5, 24,  6,  0 },
    {     16,   26,    5, 24,  6,  0 }, {     16,   25,    4, 24,  6,  0 }, {     16,   24,    4, 24,  6,  0 }, {     16,   23,    4, 24,  5,  0 }, {     16,   22,    3, 24,  5,  0 },
    {     16,   21,    3, 24,  5,  0 }, {     16,   20,    3, 24,  5,  0 }, {     16,   19,    2, 24,  5,  0 }, {     16,   18,    2, 24,  5,  0 }, {     16,   17,    2, 24,  5,  0 },
    {     16,   16,    2, 24,  5,  0 }, {     16,   15,    1, 24,  5,  0 }, {     16,   14,    1, 24,  5,  0 }, {     16,   13,    1, 24,  5,  0 }, {     16,   12,    1, 24,  5,  0 },
    {     16,   11,    1, 24,  5,  0 }, {     16,   10,    1, 24,  5,  0 }, {     16,    9,    0, 24,  0,  0 }, {     16,    8,    0, 24,  0,  0 }, {     16,    7,    0, 24,  0,  0 },
    {     16,    6,    0, 24,  0,  0 }, {     16,    5,    0, 24,  0,  0 }, {     16,    4,    0, 24,  0,  0 }, {     16,    3,    0, 24,  0,  0 }, {     16,    2,    0, 24,  0,  0 },
    {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8092, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0, 31,  0,  0 }, {     23,   15,    0, 31,  0,  0 }, {     22,   15,    0, 31,  0,  0 },
    {     21,   15,    0, 31,  0,  0 }, {     20,   15,    0, 31,  0,  0 }, {     19,   15,    0, 31,  0,  0 }, {     18,   15,    0, 31,  0,  0 }, {     17,   14,    0, 31,  0,  0 },
    {     16,   14,    0, 31,  0,  0 }, {     15,   14,    0, 31,  0,  0 }, {     14,   14,    0, 31,  0,  0 }, {     13,   14,    0, 31,  0,  0 }, {     12,   13,    0, 31,  0,  0 },
    {     11,   13,    0, 31,  0,  0 }, {     10,   13,    0, 30,  0,  0 }, {      9,   13,    0, 30,  0,  0 }, {      8,   12,    0, 30,  0,  0 }, {      7,   12,    0, 30,  0,  0 },
    {      6,   12,    0, 30,  0,  0 }, {      5,   11,    0, 30,  0,  0 }, {      4,   11,    0, 30,  0,  0 }, {      3,   11,    0, 30,  0,  0 }, {      2,   10,    0, 30,  0,  0 },
    {      1,   10,    0, 30,  0,  0 }, {      0,    9,    0, 30,  0,  0 }, {     -1,    9,    0, 30,  0,  0 }, {     -2,    8,    0, 30,  0,  0 }, {     -3,    8,    0, 30,  0,  0 },
    {     -4,    7,    0, 30,  0,  0 }, {     -5,    7,    0, 29,  0,  0 }, {     -6,    6,    0, 29,  0,  0 }, {     -7,    6,    0, 29,  0,  0 }, {     -8,    5,    0, 29,  0,  0 },
    {     -9,    4,    0, 29,  0,  0 }, {    -10,    4,    0, 29,  0,  0 }, {    -11,    3,    0, 29,  0,  0 }, {    -12,    2,    0, 29,  0,  0 }, {    -13,    2,    0, 29,  0,  0 },
    {    -14,    1,    0, 29,  0,  0 }, {    -15,    0,    0, 29,  0,  0 }, {    -16,    0,    0, 29,  0,  0 }, {    -17,   -1,    0, 29,  0,  0 }, {    -18,   -2,    0, 28,  0,  0 },
    {    -19,   -3,    0, 28,  0,  0 }, {    -20,   -3,    0, 28,  0,  0 }, {    -21,   -4,    0, 28,  0,  0 }, {    -22,   -5,    0, 28,  0,  0 }, {    -23,   -6,    0, 28,  0,  0 },
    {    -24,   -7,    0, 28,  0,  0 }, {    -25,   -7,    0, 28,  0,  0 }, {    -26,   -8,    0, 28,  0,  0 }, {    -27,   -9,    0, 28,  0,  0 }, {    -28,  -10,    0, 28,  0,  0 },
    {    -29,  -11,    0, 28,  0,  0 }, {    -29,  -12,    0, 28,  0,  0 }, {    -30,  -13,    0, 27,  0,  0 }, {    -31,  -14,    0, 27,  0,  0 }, {    -32,  -15,    0, 27,  0,  0 },
    {    -32,  -16,    0, 27,  0,  0 }, {    -33,  -17,    0, 27,  0,  0 }, {    -34,  -18,    0, 27,  0,  0 }, {    -34,  -19,    0, 27,  0,  0 }, {    -35,  -20,    0, 27,  0,  0 },
    {    -36,  -21,    0, 27,  0,  0 }, {    -36,  -22,    0, 27,  0,  0 }, {    -37,  -23,    0, 27,  0,  0 }, {    -38,  -24,    0, 27,  0,  0 }, {    -38,  -25,    0, 27,  0,  0 },
    {    -39,  -26,    0, 26,  0,  0 }, {    -39,  -27,    0, 26,  0,  0 }, {    -40,  -28,    0, 26,  0,  0 }, {    -40,  -29,    0, 26,  0,  0 }, {    -41,  -30,    0, 26,  0,  0 },
    {    -41,  -31,    0, 26,  0,  0 }, {    -42,  -32,    0, 26,  0,  0 }, {    -42,  -33,    0, 26,  0,  0 }, {    -43,  -34,    0, 26,  0,  0 }, {    -43,  -35,    0, 26,  0,  0 },
    {    -43,  -36,    0, 26,  0,  0 }, {    -44,  -37,    0, 26,  0,  0 }, {    -44,  -38,    0, 26,  0,  0 }, {    -44,  -39,    0, 26,  0,  0 }, {    -45,  -40,    0, 25,  0,  0 },
    {    -45,  -41,    0, 25,  0,  0 }, {    -45,  -42,    0, 25,  0,  0 }, {    -45,  -43,    0, 25,  0,  0 }, {    -46,  -44,    0, 25,  0,  0 }, {    -46,  -45,    0, 25,  0,  0 },
    {    -46,  -46,    0, 25,  0,  0 }, {    -46,  -47,    0, 25,  0,  0 }, {    -46,  -48,    0, 25,  0,  0 }, {    -47,  -49,    0, 25,  0,  0 }, {    -47,  -50,    0, 25,  0,  0 },
    {    -47,  -51,    0, 25,  0,  0 }, {    -47,  -52,    0, 25,  0,  0 }, {    -47,  -53,    0, 25,  0,  0 }, {    -47,  -54,    0, 25,  0,  0 }, {    -48,  -55,    0, 25,  0,  0 },
    {    -48,  -56,    0, 24,  0,  0 }, {    -48,  -57,    0, 24,  0,  0 }, {    -48,  -58,    0, 24,  0,  0 }, {    -48,  -59,    0, 24,  0,  0 }, {    -48,  -60,    0, 24,  0,  0 },
    {    -48,  -61,    0, 24,  0,  0 }, {    -48,  -62,    0, 24,  0,  0 }, {    -48,  -63,    0, 24,  0,  0 }, {    -48,  -64,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8496, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  7,  0,  0 }, {     15,    9,    0,  7,  0,  0 },
    {     15,   10,    0,  7,  0,  0 }, {     15,   11,    0,  7,  0,  0 }, {     15,   12,    0,  7,  0,  0 }, {     15,   13,    0,  7,  0,  0 }, {     15,   14,    0,  7,  0,  0 },
    {     14,   15,    0,  7,  0,  0 }, {     14,   16,    0,  7,  0,  0 }, {     14,   17,    0,  7,  0,  0 }, {     14,   18,    0,  7,  0,  0 }, {     14,   19,    0,  7,  0,  0 },
    {     13,   20,    0,  7,  0,  0 }, {     13,   21,    0,  7,  0,  0 }, {     13,   22,    0,  6,  0,  0 }, {     13,   23,    0,  6,  0,  0 }, {     12,   24,    0,  6,  0,  0 },
    {     12,   25,    0,  6,  0,  0 }, {     12,   26,    0,  6,  0,  0 }, {     11,   27,    0,  6,  0,  0 }, {     11,   28,    0,  6,  0,  0 }, {     11,   29,    0,  6,  0,  0 },
    {     10,   30,    0,  6,  0,  0 }, {     10,   31,    0,  6,  0,  0 }, {      9,   32,    0,  6,  0,  0 }, {      9,   33,    0,  6,  0,  0 }, {      8,   34,    0,  6,  0,  0 },
    {      8,   35,    0,  6,  0,  0 }, {      7,   36,    0,  6,  0,  0 }, {      7,   37,    0,  5,  0,  0 }, {      6,   38,    0,  5,  0,  0 }, {      6,   39,    0,  5,  0,  0 },
    {      5,   40,    0,  5,  0,  0 }, {      4,   41,    0,  5,  0,  0 }, {      4,   42,    0,  5,  0,  0 }, {      3,   43,    0,  5,  0,  0 }, {      2,   44,    0,  5,  0,  0 },
    {      2,   45,    0,  5,  0,  0 }, {      1,   46,    0,  5,  0,  0 }, {      0,   47,    0,  5,  0,  0 }, {      0,   48,    0,  5,  0,  0 }, {     -1,   49,    0,  5,  0,  0 },
    {     -2,   50,    0,  4,  0,  0 }, {     -3,   51,    0,  4,  0,  0 }, {     -3,   52,    0,  4,  0,  0 }, {     -4,   53,    0,  4,  0,  0 }, {     -5,   54,    0,  4,  0,  0 },
    {     -6,   55,    0,  4,  0,  0 }, {     -7,   56,    0,  4,  0,  0 }, {     -7,   57,    0,  4,  0,  0 }, {     -8,   58,    0,  4,  0,  0 }, {     -9,   59,    0,  4,  0,  0 },
    {    -10,   60,    0,  4,  0,  0 }, {    -11,   61,    0,  4,  0,  0 }, {    -12,   61,    0,  4,  0,  0 }, {    -13,   62,    0,  3,  0,  0 }, {    -14,   63,    0,  3,  0,  0 },
    {    -15,   64,    0,  3,  0,  0 }, {    -16,   64,    0,  3,  0,  0 }, {    -17,   65,    0,  3,  0,  0 }, {    -18,   66,    0,  3,  0,  0 }, {    -19,   66,    0,  3,  0,  0 },
    {    -20,   67,    0,  3,  0,  0 }, {    -21,   68,    0,  3,  0,  0 }, {    -22,   68,    0,  3,  0,  0 }, {    -23,   69,    0,  3,  0,  0 }, {    -24,   70,    0,  3,  0,  0 },
    {    -25,   70,    0,  3,  0,  0 }, {    -26,   71,    0,  2,  0,  0 }, {    -27,   71,    0,  2,  0,  0 }, {    -28,   72,    0,  2,  0,  0 }, {    -29,   72,    0,  2,  0,  0 },
    {    -30,   73,    0,  2,  0,  0 }, {    -31,   73,    0,  2,  0,  0 }, {    -32,   74,    0,  2,  0,  0 }, {    -33,   74,    0,  2,  0,  0 }, {    -34,   75,    0,  2,  0,  0 },
    {    -35,   75,    0,  2,  0,  0 }, {    -36,   75,    0,  2,  0,  0 }, {    -37,   76,    0,  2,  0,  0 }, {    -38,   76,    0,  2,  0,  0 }, {    -39,   76,    0,  2,  0,  0 },
    {    -40,   77,    0,  1,  0,  0 }, {    -41,   77,    0,  1,  0,  0 }, {    -42,   77,    0,  1,  0,  0 }, {    -43,   77,    0,  1,  0,  0 }, {    -44,   78,    0,  1,  0,  0 },
    {    -45,   78,    0,  1,  0,  0 }, {    -46,   78,    0,  1,  0,  0 }, {    -47,   78,    0,  1,  0,  0 }, {    -48,   78,    0,  1,  0,  0 }, {    -49,   79,    0,  1,  0,  0 },
    {    -50,   79,    0,  1,  0,  0 }, {    -51,   79,    0,  1,  0,  0 }, {    -52,   79,    0,  1,  0,  0 }, {    -53,   79,    0,  1,  0,  0 }, {    -54,   79,    0,  1,  0,  0 },
    {    -55,   80,    0,  1,  0,  0 }, {    -56,   80,    0,  0,  0,  0 }, {    -57,   80,    0,  0,  0,  0 }, {    -58,   80,    0,  0,  0,  0 }, {    -59,   80,    0,  0,  0,  0 },
    {    -60,   80,    0,  0,  0,  0 }, {    -61,   80,    0,  0,  0,  0 }, {    -62,   80,    0,  0,  0,  0 }, {    -63,   80,    0,  0,  0,  0 }, {    -64,   80,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C88A3, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 15,  0,  0 }, {      9,   17,    0, 15,  0,  0 },
    {     10,   17,    0, 15,  0,  0 }, {     11,   17,    0, 15,  0,  0 }, {     12,   17,    0, 15,  0,  0 }, {     13,   17,    0, 15,  0,  0 }, {     14,   17,    0, 15,  0,  0 },
    {     15,   18,    0, 15,  0,  0 }, {     16,   18,    0, 15,  0,  0 }, {     17,   18,    0, 15,  0,  0 }, {     18,   18,    0, 15,  0,  0 }, {     19,   18,    0, 15,  0,  0 },
    {     20,   19,    0, 15,  0,  0 }, {     21,   19,    0, 15,  0,  0 }, {     22,   19,    0, 14,  0,  0 }, {     23,   19,    0, 14,  0,  0 }, {     24,   20,    0, 14,  0,  0 },
    {     25,   20,    0, 14,  0,  0 }, {     26,   20,    0, 14,  0,  0 }, {     27,   21,    0, 14,  0,  0 }, {     28,   21,    0, 14,  0,  0 }, {     29,   21,    0, 14,  0,  0 },
    {     30,   22,    0, 14,  0,  0 }, {     31,   22,    0, 14,  0,  0 }, {     32,   23,    0, 14,  0,  0 }, {     33,   23,    0, 14,  0,  0 }, {     34,   24,    0, 14,  0,  0 },
    {     35,   24,    0, 14,  0,  0 }, {     36,   25,    0, 14,  0,  0 }, {     37,   25,    0, 13,  0,  0 }, {     38,   26,    0, 13,  0,  0 }, {     39,   26,    0, 13,  0,  0 },
    {     40,   27,    0, 13,  0,  0 }, {     41,   28,    0, 13,  0,  0 }, {     42,   28,    0, 13,  0,  0 }, {     43,   29,    0, 13,  0,  0 }, {     44,   30,    0, 13,  0,  0 },
    {     45,   30,    0, 13,  0,  0 }, {     46,   31,    0, 13,  0,  0 }, {     47,   32,    0, 13,  0,  0 }, {     48,   32,    0, 13,  0,  0 }, {     49,   33,    0, 13,  0,  0 },
    {     50,   34,    0, 12,  0,  0 }, {     51,   35,    0, 12,  0,  0 }, {     52,   35,    0, 12,  0,  0 }, {     53,   36,    0, 12,  0,  0 }, {     54,   37,    0, 12,  0,  0 },
    {     55,   38,    0, 12,  0,  0 }, {     56,   39,    0, 12,  0,  0 }, {     57,   39,    0, 12,  0,  0 }, {     58,   40,    0, 12,  0,  0 }, {     59,   41,    0, 12,  0,  0 },
    {     60,   42,    0, 12,  0,  0 }, {     61,   43,    0, 12,  0,  0 }, {     61,   44,    0, 12,  0,  0 }, {     62,   45,    0, 11,  0,  0 }, {     63,   46,    0, 11,  0,  0 },
    {     64,   47,    0, 11,  0,  0 }, {     64,   48,    0, 11,  0,  0 }, {     65,   49,    0, 11,  0,  0 }, {     66,   50,    0, 11,  0,  0 }, {     66,   51,    0, 11,  0,  0 },
    {     67,   52,    0, 11,  0,  0 }, {     68,   53,    0, 11,  0,  0 }, {     68,   54,    0, 11,  0,  0 }, {     69,   55,    0, 11,  0,  0 }, {     70,   56,    0, 11,  0,  0 },
    {     70,   57,    0, 11,  0,  0 }, {     71,   58,    0, 10,  0,  0 }, {     71,   59,    0, 10,  0,  0 }, {     72,   60,    0, 10,  0,  0 }, {     72,   61,    0, 10,  0,  0 },
    {     73,   62,    0, 10,  0,  0 }, {     73,   63,    0, 10,  0,  0 }, {     74,   64,    0, 10,  0,  0 }, {     74,   65,    0, 10,  0,  0 }, {     75,   66,    0, 10,  0,  0 },
    {     75,   67,    0, 10,  0,  0 }, {     75,   68,    0, 10,  0,  0 }, {     76,   69,    0, 10,  0,  0 }, {     76,   70,    0, 10,  0,  0 }, {     76,   71,    0, 10,  0,  0 },
    {     77,   72,    0,  9,  0,  0 }, {     77,   73,    0,  9,  0,  0 }, {     77,   74,    0,  9,  0,  0 }, {     77,   75,    0,  9,  0,  0 }, {     78,   76,    0,  9,  0,  0 },
    {     78,   77,    0,  9,  0,  0 }, {     78,   78,    0,  9,  0,  0 }, {     78,   79,    0,  9,  0,  0 }, {     78,   80,    0,  9,  0,  0 }, {     79,   81,    0,  9,  0,  0 },
    {     79,   82,    0,  9,  0,  0 }, {     79,   83,    0,  9,  0,  0 }, {     79,   84,    0,  9,  0,  0 }, {     79,   85,    0,  9,  0,  0 }, {     79,   86,    0,  9,  0,  0 },
    {     80,   87,    0,  9,  0,  0 }, {     80,   88,    0,  8,  0,  0 }, {     80,   89,    0,  8,  0,  0 }, {     80,   90,    0,  8,  0,  0 }, {     80,   91,    0,  8,  0,  0 },
    {     80,   92,    0,  8,  0,  0 }, {     80,   93,    0,  8,  0,  0 }, {     80,   94,    0,  8,  0,  0 }, {     80,   95,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C8CA7, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 23,  0,  0 }, {     17,   23,    0, 23,  0,  0 }, {     17,   22,    0, 23,  0,  0 },
    {     17,   21,    0, 23,  0,  0 }, {     17,   20,    0, 23,  0,  0 }, {     17,   19,    0, 23,  0,  0 }, {     17,   18,    0, 23,  0,  0 }, {     18,   17,    0, 23,  0,  0 },
    {     18,   16,    0, 23,  0,  0 }, {     18,   15,    0, 23,  0,  0 }, {     18,   14,    0, 23,  0,  0 }, {     18,   13,    0, 23,  0,  0 }, {     19,   12,    0, 23,  0,  0 },
    {     19,   11,    0, 23,  0,  0 }, {     19,   10,    0, 22,  0,  0 }, {     19,    9,    0, 22,  0,  0 }, {     20,    8,    0, 22,  0,  0 }, {     20,    7,    0, 22,  0,  0 },
    {     20,    6,    0, 22,  0,  0 }, {     21,    5,    0, 22,  0,  0 }, {     21,    4,    0, 22,  0,  0 }, {     21,    3,    0, 22,  0,  0 }, {     22,    2,    0, 22,  0,  0 },
    {     22,    1,    0, 22,  0,  0 }, {     23,    0,    0, 22,  0,  0 }, {     23,   -1,    0, 22,  0,  0 }, {     24,   -2,    0, 22,  0,  0 }, {     24,   -3,    0, 22,  0,  0 },
    {     25,   -4,    0, 22,  0,  0 }, {     25,   -5,    0, 21,  0,  0 }, {     26,   -6,    0, 21,  0,  0 }, {     26,   -7,    0, 21,  0,  0 }, {     27,   -8,    0, 21,  0,  0 },
    {     28,   -9,    0, 21,  0,  0 }, {     28,  -10,    0, 21,  0,  0 }, {     29,  -11,    0, 21,  0,  0 }, {     30,  -12,    0, 21,  0,  0 }, {     30,  -13,    0, 21,  0,  0 },
    {     31,  -14,    0, 21,  0,  0 }, {     32,  -15,    0, 21,  0,  0 }, {     32,  -16,    0, 21,  0,  0 }, {     33,  -17,    0, 21,  0,  0 }, {     34,  -18,    0, 20,  0,  0 },
    {     35,  -19,    0, 20,  0,  0 }, {     35,  -20,    0, 20,  0,  0 }, {     36,  -21,    0, 20,  0,  0 }, {     37,  -22,    0, 20,  0,  0 }, {     38,  -23,    0, 20,  0,  0 },
    {     39,  -24,    0, 20,  0,  0 }, {     39,  -25,    0, 20,  0,  0 }, {     40,  -26,    0, 20,  0,  0 }, {     41,  -27,    0, 20,  0,  0 }, {     42,  -28,    0, 20,  0,  0 },
    {     43,  -29,    0, 20,  0,  0 }, {     44,  -29,    0, 20,  0,  0 }, {     45,  -30,    0, 19,  0,  0 }, {     46,  -31,    0, 19,  0,  0 }, {     47,  -32,    0, 19,  0,  0 },
    {     48,  -32,    0, 19,  0,  0 }, {     49,  -33,    0, 19,  0,  0 }, {     50,  -34,    0, 19,  0,  0 }, {     51,  -34,    0, 19,  0,  0 }, {     52,  -35,    0, 19,  0,  0 },
    {     53,  -36,    0, 19,  0,  0 }, {     54,  -36,    0, 19,  0,  0 }, {     55,  -37,    0, 19,  0,  0 }, {     56,  -38,    0, 19,  0,  0 }, {     57,  -38,    0, 19,  0,  0 },
    {     58,  -39,    0, 18,  0,  0 }, {     59,  -39,    0, 18,  0,  0 }, {     60,  -40,    0, 18,  0,  0 }, {     61,  -40,    0, 18,  0,  0 }, {     62,  -41,    0, 18,  0,  0 },
    {     63,  -41,    0, 18,  0,  0 }, {     64,  -42,    0, 18,  0,  0 }, {     65,  -42,    0, 18,  0,  0 }, {     66,  -43,    0, 18,  0,  0 }, {     67,  -43,    0, 18,  0,  0 },
    {     68,  -43,    0, 18,  0,  0 }, {     69,  -44,    0, 18,  0,  0 }, {     70,  -44,    0, 18,  0,  0 }, {     71,  -44,    0, 18,  0,  0 }, {     72,  -45,    0, 17,  0,  0 },
    {     73,  -45,    0, 17,  0,  0 }, {     74,  -45,    0, 17,  0,  0 }, {     75,  -45,    0, 17,  0,  0 }, {     76,  -46,    0, 17,  0,  0 }, {     77,  -46,    0, 17,  0,  0 },
    {     78,  -46,    0, 17,  0,  0 }, {     79,  -46,    0, 17,  0,  0 }, {     80,  -46,    0, 17,  0,  0 }, {     81,  -47,    0, 17,  0,  0 }, {     82,  -47,    0, 17,  0,  0 },
    {     83,  -47,    0, 17,  0,  0 }, {     84,  -47,    0, 17,  0,  0 }, {     85,  -47,    0, 17,  0,  0 }, {     86,  -47,    0, 17,  0,  0 }, {     87,  -48,    0, 17,  0,  0 },
    {     88,  -48,    0, 16,  0,  0 }, {     89,  -48,    0, 16,  0,  0 }, {     90,  -48,    0, 16,  0,  0 }, {     91,  -48,    0, 16,  0,  0 }, {     92,  -48,    0, 16,  0,  0 },
    {     93,  -48,    0, 16,  0,  0 }, {     94,  -48,    0, 16,  0,  0 }, {     95,  -48,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C90A2, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  1,  0,  0 }, {     23,   17,    0,  1,  0,  0 }, {     22,   17,    0,  1,  0,  0 },
    {     21,   17,    0,  1,  0,  0 }, {     20,   17,    0,  1,  0,  0 }, {     19,   17,    0,  1,  0,  0 }, {     18,   17,    0,  1,  0,  0 }, {     17,   18,    0,  1,  0,  0 },
    {     16,   18,    0,  1,  0,  0 }, {     15,   18,    0,  1,  0,  0 }, {     14,   18,    0,  1,  0,  0 }, {     13,   18,    0,  1,  0,  0 }, {     12,   19,    0,  1,  0,  0 },
    {     11,   19,    0,  1,  0,  0 }, {     10,   19,    0,  2,  0,  0 }, {      9,   19,    0,  2,  0,  0 }, {      8,   20,    0,  2,  0,  0 }, {      7,   20,    0,  2,  0,  0 },
    {      6,   20,    0,  2,  0,  0 }, {      5,   21,    0,  2,  0,  0 }, {      4,   21,    0,  2,  0,  0 }, {      3,   21,    0,  2,  0,  0 }, {      2,   22,    0,  2,  0,  0 },
    {      1,   22,    0,  2,  0,  0 }, {      0,   23,    0,  2,  0,  0 }, {     -1,   23,    0,  2,  0,  0 }, {     -2,   24,    0,  2,  0,  0 }, {     -3,   24,    0,  2,  0,  0 },
    {     -4,   25,    0,  2,  0,  0 }, {     -5,   25,    0,  3,  0,  0 }, {     -6,   26,    0,  3,  0,  0 }, {     -7,   26,    0,  3,  0,  0 }, {     -8,   27,    0,  3,  0,  0 },
    {     -9,   28,    0,  3,  0,  0 }, {    -10,   28,    0,  3,  0,  0 }, {    -11,   29,    0,  3,  0,  0 }, {    -12,   30,    0,  3,  0,  0 }, {    -13,   30,    0,  3,  0,  0 },
    {    -14,   31,    0,  3,  0,  0 }, {    -15,   32,    0,  3,  0,  0 }, {    -16,   32,    0,  3,  0,  0 }, {    -17,   33,    0,  3,  0,  0 }, {    -18,   34,    0,  4,  0,  0 },
    {    -19,   35,    0,  4,  0,  0 }, {    -20,   35,    0,  4,  0,  0 }, {    -21,   36,    0,  4,  0,  0 }, {    -22,   37,    0,  4,  0,  0 }, {    -23,   38,    0,  4,  0,  0 },
    {    -24,   39,    0,  4,  0,  0 }, {    -25,   39,    0,  4,  0,  0 }, {    -26,   40,    0,  4,  0,  0 }, {    -27,   41,    0,  4,  0,  0 }, {    -28,   42,    0,  4,  0,  0 },
    {    -29,   43,    0,  4,  0,  0 }, {    -29,   44,    0,  4,  0,  0 }, {    -30,   45,    0,  5,  0,  0 }, {    -31,   46,    0,  5,  0,  0 }, {    -32,   47,    0,  5,  0,  0 },
    {    -32,   48,    0,  5,  0,  0 }, {    -33,   49,    0,  5,  0,  0 }, {    -34,   50,    0,  5,  0,  0 }, {    -34,   51,    0,  5,  0,  0 }, {    -35,   52,    0,  5,  0,  0 },
    {    -36,   53,    0,  5,  0,  0 }, {    -36,   54,    0,  5,  0,  0 }, {    -37,   55,    0,  5,  0,  0 }, {    -38,   56,    0,  5,  0,  0 }, {    -38,   57,    0,  5,  0,  0 },
    {    -39,   58,    0,  6,  0,  0 }, {    -39,   59,    0,  6,  0,  0 }, {    -40,   60,    0,  6,  0,  0 }, {    -40,   61,    0,  6,  0,  0 }, {    -41,   62,    0,  6,  0,  0 },
    {    -41,   63,    0,  6,  0,  0 }, {    -42,   64,    0,  6,  0,  0 }, {    -42,   65,    0,  6,  0,  0 }, {    -43,   66,    0,  6,  0,  0 }, {    -43,   67,    0,  6,  0,  0 },
    {    -43,   68,    0,  6,  0,  0 }, {    -44,   69,    0,  6,  0,  0 }, {    -44,   70,    0,  6,  0,  0 }, {    -44,   71,    0,  6,  0,  0 }, {    -45,   72,    0,  7,  0,  0 },
    {    -45,   73,    0,  7,  0,  0 }, {    -45,   74,    0,  7,  0,  0 }, {    -45,   75,    0,  7,  0,  0 }, {    -46,   76,    0,  7,  0,  0 }, {    -46,   77,    0,  7,  0,  0 },
    {    -46,   78,    0,  7,  0,  0 }, {    -46,   79,    0,  7,  0,  0 }, {    -46,   80,    0,  7,  0,  0 }, {    -47,   81,    0,  7,  0,  0 }, {    -47,   82,    0,  7,  0,  0 },
    {    -47,   83,    0,  7,  0,  0 }, {    -47,   84,    0,  7,  0,  0 }, {    -47,   85,    0,  7,  0,  0 }, {    -47,   86,    0,  7,  0,  0 }, {    -48,   87,    0,  7,  0,  0 },
    {    -48,   88,    0,  8,  0,  0 }, {    -48,   89,    0,  8,  0,  0 }, {    -48,   90,    0,  8,  0,  0 }, {    -48,   91,    0,  8,  0,  0 }, {    -48,   92,    0,  8,  0,  0 },
    {    -48,   93,    0,  8,  0,  0 }, {    -48,   94,    0,  8,  0,  0 }, {    -48,   95,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C949D, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  9,  0,  0 }, {     17,    9,    0,  9,  0,  0 },
    {     17,   10,    0,  9,  0,  0 }, {     17,   11,    0,  9,  0,  0 }, {     17,   12,    0,  9,  0,  0 }, {     17,   13,    0,  9,  0,  0 }, {     17,   14,    0,  9,  0,  0 },
    {     18,   15,    0,  9,  0,  0 }, {     18,   16,    0,  9,  0,  0 }, {     18,   17,    0,  9,  0,  0 }, {     18,   18,    0,  9,  0,  0 }, {     18,   19,    0,  9,  0,  0 },
    {     19,   20,    0,  9,  0,  0 }, {     19,   21,    0,  9,  0,  0 }, {     19,   22,    0, 10,  0,  0 }, {     19,   23,    0, 10,  0,  0 }, {     20,   24,    0, 10,  0,  0 },
    {     20,   25,    0, 10,  0,  0 }, {     20,   26,    0, 10,  0,  0 }, {     21,   27,    0, 10,  0,  0 }, {     21,   28,    0, 10,  0,  0 }, {     21,   29,    0, 10,  0,  0 },
    {     22,   30,    0, 10,  0,  0 }, {     22,   31,    0, 10,  0,  0 }, {     23,   32,    0, 10,  0,  0 }, {     23,   33,    0, 10,  0,  0 }, {     24,   34,    0, 10,  0,  0 },
    {     24,   35,    0, 10,  0,  0 }, {     25,   36,    0, 10,  0,  0 }, {     25,   37,    0, 11,  0,  0 }, {     26,   38,    0, 11,  0,  0 }, {     26,   39,    0, 11,  0,  0 },
    {     27,   40,    0, 11,  0,  0 }, {     28,   41,    0, 11,  0,  0 }, {     28,   42,    0, 11,  0,  0 }, {     29,   43,    0, 11,  0,  0 }, {     30,   44,    0, 11,  0,  0 },
    {     30,   45,    0, 11,  0,  0 }, {     31,   46,    0, 11,  0,  0 }, {     32,   47,    0, 11,  0,  0 }, {     32,   48,    0, 11,  0,  0 }, {     33,   49,    0, 11,  0,  0 },
    {     34,   50,    0, 12,  0,  0 }, {     35,   51,    0, 12,  0,  0 }, {     35,   52,    0, 12,  0,  0 }, {     36,   53,    0, 12,  0,  0 }, {     37,   54,    0, 12,  0,  0 },
    {     38,   55,    0, 12,  0,  0 }, {     39,   56,    0, 12,  0,  0 }, {     39,   57,    0, 12,  0,  0 }, {     40,   58,    0, 12,  0,  0 }, {     41,   59,    0, 12,  0,  0 },
    {     42,   60,    0, 12,  0,  0 }, {     43,   61,    0, 12,  0,  0 }, {     44,   61,    0, 12,  0,  0 }, {     45,   62,    0, 13,  0,  0 }, {     46,   63,    0, 13,  0,  0 },
    {     47,   64,    0, 13,  0,  0 }, {     48,   64,    0, 13,  0,  0 }, {     49,   65,    0, 13,  0,  0 }, {     50,   66,    0, 13,  0,  0 }, {     51,   66,    0, 13,  0,  0 },
    {     52,   67,    0, 13,  0,  0 }, {     53,   68,    0, 13,  0,  0 }, {     54,   68,    0, 13,  0,  0 }, {     55,   69,    0, 13,  0,  0 }, {     56,   70,    0, 13,  0,  0 },
    {     57,   70,    0, 13,  0,  0 }, {     58,   71,    0, 14,  0,  0 }, {     59,   71,    0, 14,  0,  0 }, {     60,   72,    0, 14,  0,  0 }, {     61,   72,    0, 14,  0,  0 },
    {     62,   73,    0, 14,  0,  0 }, {     63,   73,    0, 14,  0,  0 }, {     64,   74,    0, 14,  0,  0 }, {     65,   74,    0, 14,  0,  0 }, {     66,   75,    0, 14,  0,  0 },
    {     67,   75,    0, 14,  0,  0 }, {     68,   75,    0, 14,  0,  0 }, {     69,   76,    0, 14,  0,  0 }, {     70,   76,    0, 14,  0,  0 }, {     71,   76,    0, 14,  0,  0 },
    {     72,   77,    0, 15,  0,  0 }, {     73,   77,    0, 15,  0,  0 }, {     74,   77,    0, 15,  0,  0 }, {     75,   77,    0, 15,  0,  0 }, {     76,   78,    0, 15,  0,  0 },
    {     77,   78,    0, 15,  0,  0 }, {     78,   78,    0, 15,  0,  0 }, {     79,   78,    0, 15,  0,  0 }, {     80,   78,    0, 15,  0,  0 }, {     81,   79,    0, 15,  0,  0 },
    {     82,   79,    0, 15,  0,  0 }, {     83,   79,    0, 15,  0,  0 }, {     84,   79,    0, 15,  0,  0 }, {     85,   79,    0, 15,  0,  0 }, {     86,   79,    0, 15,  0,  0 },
    {     87,   80,    0, 15,  0,  0 }, {     88,   80,    0, 16,  0,  0 }, {     89,   80,    0, 16,  0,  0 }, {     90,   80,    0, 16,  0,  0 }, {     91,   80,    0, 16,  0,  0 },
    {     92,   80,    0, 16,  0,  0 }, {     93,   80,    0, 16,  0,  0 }, {     94,   80,    0, 16,  0,  0 }, {     95,   80,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C98A1, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 17,  0,  0 }, {      9,   15,    0, 17,  0,  0 },
    {     10,   15,    0, 17,  0,  0 }, {     11,   15,    0, 17,  0,  0 }, {     12,   15,    0, 17,  0,  0 }, {     13,   15,    0, 17,  0,  0 }, {     14,   15,    0, 17,  0,  0 },
    {     15,   14,    0, 17,  0,  0 }, {     16,   14,    0, 17,  0,  0 }, {     17,   14,    0, 17,  0,  0 }, {     18,   14,    0, 17,  0,  0 }, {     19,   14,    0, 17,  0,  0 },
    {     20,   13,    0, 17,  0,  0 }, {     21,   13,    0, 17,  0,  0 }, {     22,   13,    0, 18,  0,  0 }, {     23,   13,    0, 18,  0,  0 }, {     24,   12,    0, 18,  0,  0 },
    {     25,   12,    0, 18,  0,  0 }, {     26,   12,    0, 18,  0,  0 }, {     27,   11,    0, 18,  0,  0 }, {     28,   11,    0, 18,  0,  0 }, {     29,   11,    0, 18,  0,  0 },
    {     30,   10,    0, 18,  0,  0 }, {     31,   10,    0, 18,  0,  0 }, {     32,    9,    0, 18,  0,  0 }, {     33,    9,    0, 18,  0,  0 }, {     34,    8,    0, 18,  0,  0 },
    {     35,    8,    0, 18,  0,  0 }, {     36,    7,    0, 18,  0,  0 }, {     37,    7,    0, 19,  0,  0 }, {     38,    6,    0, 19,  0,  0 }, {     39,    6,    0, 19,  0,  0 },
    {     40,    5,    0, 19,  0,  0 }, {     41,    4,    0, 19,  0,  0 }, {     42,    4,    0, 19,  0,  0 }, {     43,    3,    0, 19,  0,  0 }, {     44,    2,    0, 19,  0,  0 },
    {     45,    2,    0, 19,  0,  0 }, {     46,    1,    0, 19,  0,  0 }, {     47,    0,    0, 19,  0,  0 }, {     48,    0,    0, 19,  0,  0 }, {     49,   -1,    0, 19,  0,  0 },
    {     50,   -2,    0, 20,  0,  0 }, {     51,   -3,    0, 20,  0,  0 }, {     52,   -3,    0, 20,  0,  0 }, {     53,   -4,    0, 20,  0,  0 }, {     54,   -5,    0, 20,  0,  0 },
    {     55,   -6,    0, 20,  0,  0 }, {     56,   -7,    0, 20,  0,  0 }, {     57,   -7,    0, 20,  0,  0 }, {     58,   -8,    0, 20,  0,  0 }, {     59,   -9,    0, 20,  0,  0 },
    {     60,  -10,    0, 20,  0,  0 }, {     61,  -11,    0, 20,  0,  0 }, {     61,  -12,    0, 20,  0,  0 }, {     62,  -13,    0, 21,  0,  0 }, {     63,  -14,    0, 21,  0,  0 },
    {     64,  -15,    0, 21,  0,  0 }, {     64,  -16,    0, 21,  0,  0 }, {     65,  -17,    0, 21,  0,  0 }, {     66,  -18,    0, 21,  0,  0 }, {     66,  -19,    0, 21,  0,  0 },
    {     67,  -20,    0, 21,  0,  0 }, {     68,  -21,    0, 21,  0,  0 }, {     68,  -22,    0, 21,  0,  0 }, {     69,  -23,    0, 21,  0,  0 }, {     70,  -24,    0, 21,  0,  0 },
    {     70,  -25,    0, 21,  0,  0 }, {     71,  -26,    0, 22,  0,  0 }, {     71,  -27,    0, 22,  0,  0 }, {     72,  -28,    0, 22,  0,  0 }, {     72,  -29,    0, 22,  0,  0 },
    {     73,  -30,    0, 22,  0,  0 }, {     73,  -31,    0, 22,  0,  0 }, {     74,  -32,    0, 22,  0,  0 }, {     74,  -33,    0, 22,  0,  0 }, {     75,  -34,    0, 22,  0,  0 },
    {     75,  -35,    0, 22,  0,  0 }, {     75,  -36,    0, 22,  0,  0 }, {     76,  -37,    0, 22,  0,  0 }, {     76,  -38,    0, 22,  0,  0 }, {     76,  -39,    0, 22,  0,  0 },
    {     77,  -40,    0, 23,  0,  0 }, {     77,  -41,    0, 23,  0,  0 }, {     77,  -42,    0, 23,  0,  0 }, {     77,  -43,    0, 23,  0,  0 }, {     78,  -44,    0, 23,  0,  0 },
    {     78,  -45,    0, 23,  0,  0 }, {     78,  -46,    0, 23,  0,  0 }, {     78,  -47,    0, 23,  0,  0 }, {     78,  -48,    0, 23,  0,  0 }, {     79,  -49,    0, 23,  0,  0 },
    {     79,  -50,    0, 23,  0,  0 }, {     79,  -51,    0, 23,  0,  0 }, {     79,  -52,    0, 23,  0,  0 }, {     79,  -53,    0, 23,  0,  0 }, {     79,  -54,    0, 23,  0,  0 },
    {     80,  -55,    0, 23,  0,  0 }, {     80,  -56,    0, 24,  0,  0 }, {     80,  -57,    0, 24,  0,  0 }, {     80,  -58,    0, 24,  0,  0 }, {     80,  -59,    0, 24,  0,  0 },
    {     80,  -60,    0, 24,  0,  0 }, {     80,  -61,    0, 24,  0,  0 }, {     80,  -62,    0, 24,  0,  0 }, {     80,  -63,    0, 24,  0,  0 }, {     80,  -64,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C9CAE, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 25,  0,  0 }, {     15,   23,    0, 25,  0,  0 }, {     15,   22,    0, 25,  0,  0 },
    {     15,   21,    0, 25,  0,  0 }, {     15,   20,    0, 25,  0,  0 }, {     15,   19,    0, 25,  0,  0 }, {     15,   18,    0, 25,  0,  0 }, {     14,   17,    0, 25,  0,  0 },
    {     14,   16,    0, 25,  0,  0 }, {     14,   15,    0, 25,  0,  0 }, {     14,   14,    0, 25,  0,  0 }, {     14,   13,    0, 25,  0,  0 }, {     13,   12,    0, 25,  0,  0 },
    {     13,   11,    0, 25,  0,  0 }, {     13,   10,    0, 26,  0,  0 }, {     13,    9,    0, 26,  0,  0 }, {     12,    8,    0, 26,  0,  0 }, {     12,    7,    0, 26,  0,  0 },
    {     12,    6,    0, 26,  0,  0 }, {     11,    5,    0, 26,  0,  0 }, {     11,    4,    0, 26,  0,  0 }, {     11,    3,    0, 26,  0,  0 }, {     10,    2,    0, 26,  0,  0 },
    {     10,    1,    0, 26,  0,  0 }, {      9,    0,    0, 26,  0,  0 }, {      9,   -1,    0, 26,  0,  0 }, {      8,   -2,    0, 26,  0,  0 }, {      8,   -3,    0, 26,  0,  0 },
    {      7,   -4,    0, 26,  0,  0 }, {      7,   -5,    0, 27,  0,  0 }, {      6,   -6,    0, 27,  0,  0 }, {      6,   -7,    0, 27,  0,  0 }, {      5,   -8,    0, 27,  0,  0 },
    {      4,   -9,    0, 27,  0,  0 }, {      4,  -10,    0, 27,  0,  0 }, {      3,  -11,    0, 27,  0,  0 }, {      2,  -12,    0, 27,  0,  0 }, {      2,  -13,    0, 27,  0,  0 },
    {      1,  -14,    0, 27,  0,  0 }, {      0,  -15,    0, 27,  0,  0 }, {      0,  -16,    0, 27,  0,  0 }, {     -1,  -17,    0, 27,  0,  0 }, {     -2,  -18,    0, 28,  0,  0 },
    {     -3,  -19,    0, 28,  0,  0 }, {     -3,  -20,    0, 28,  0,  0 }, {     -4,  -21,    0, 28,  0,  0 }, {     -5,  -22,    0, 28,  0,  0 }, {     -6,  -23,    0, 28,  0,  0 },
    {     -7,  -24,    0, 28,  0,  0 }, {     -7,  -25,    0, 28,  0,  0 }, {     -8,  -26,    0, 28,  0,  0 }, {     -9,  -27,    0, 28,  0,  0 }, {    -10,  -28,    0, 28,  0,  0 },
    {    -11,  -29,    0, 28,  0,  0 }, {    -12,  -29,    0, 28,  0,  0 }, {    -13,  -30,    0, 29,  0,  0 }, {    -14,  -31,    0, 29,  0,  0 }, {    -15,  -32,    0, 29,  0,  0 },
    {    -16,  -32,    0, 29,  0,  0 }, {    -17,  -33,    0, 29,  0,  0 }, {    -18,  -34,    0, 29,  0,  0 }, {    -19,  -34,    0, 29,  0,  0 }, {    -20,  -35,    0, 29,  0,  0 },
    {    -21,  -36,    0, 29,  0,  0 }, {    -22,  -36,    0, 29,  0,  0 }, {    -23,  -37,    0, 29,  0,  0 }, {    -24,  -38,    0, 29,  0,  0 }, {    -25,  -38,    0, 29,  0,  0 },
    {    -26,  -39,    0, 30,  0,  0 }, {    -27,  -39,    0, 30,  0,  0 }, {    -28,  -40,    0, 30,  0,  0 }, {    -29,  -40,    0, 30,  0,  0 }, {    -30,  -41,    0, 30,  0,  0 },
    {    -31,  -41,    0, 30,  0,  0 }, {    -32,  -42,    0, 30,  0,  0 }, {    -33,  -42,    0, 30,  0,  0 }, {    -34,  -43,    0, 30,  0,  0 }, {    -35,  -43,    0, 30,  0,  0 },
    {    -36,  -43,    0, 30,  0,  0 }, {    -37,  -44,    0, 30,  0,  0 }, {    -38,  -44,    0, 30,  0,  0 }, {    -39,  -44,    0, 30,  0,  0 }, {    -40,  -45,    0, 31,  0,  0 },
    {    -41,  -45,    0, 31,  0,  0 }, {    -42,  -45,    0, 31,  0,  0 }, {    -43,  -45,    0, 31,  0,  0 }, {    -44,  -46,    0, 31,  0,  0 }, {    -45,  -46,    0, 31,  0,  0 },
    {    -46,  -46,    0, 31,  0,  0 }, {    -47,  -46,    0, 31,  0,  0 }, {    -48,  -46,    0, 31,  0,  0 }, {    -49,  -47,    0, 31,  0,  0 }, {    -50,  -47,    0, 31,  0,  0 },
    {    -51,  -47,    0, 31,  0,  0 }, {    -52,  -47,    0, 31,  0,  0 }, {    -53,  -47,    0, 31,  0,  0 }, {    -54,  -47,    0, 31,  0,  0 }, {    -55,  -48,    0, 31,  0,  0 },
    {    -56,  -48,    0,  0,  0,  0 }, {    -57,  -48,    0,  0,  0,  0 }, {    -58,  -48,    0,  0,  0,  0 }, {    -59,  -48,    0,  0,  0,  0 }, {    -60,  -48,    0,  0,  0,  0 },
    {    -61,  -48,    0,  0,  0,  0 }, {    -62,  -48,    0,  0,  0,  0 }, {    -63,  -48,    0,  0,  0,  0 }, {    -64,  -48,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3542, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  0,  0,  0 }, {     23,   16,    0,  0,  0,  1 }, {     22,   16,    0,  0,  0,  1 },
    {     21,   16,    0,  0,  0,  1 }, {     20,   16,    0,  0,  0,  1 }, {     19,   16,    0,  0,  0,  1 }, {     18,   16,    0,  0,  0,  1 }, {     17,   16,    0,  0,  0,  1 },
    {     16,   16,    0,  0,  0,  1 }, {     15,   16,    0,  0,  0,  1 }, {     14,   16,    0,  0,  0,  1 }, {     13,   16,    0,  0,  0,  1 }, {     12,   16,    0,  0,  0,  1 },
    {     11,   16,    0,  0,  0,  1 }, {     10,   16,    0,  0,  0,  1 }, {      9,   16,    0,  0,  0,  1 }, {      8,   16,    0,  0,  0,  1 }, {      7,   16,    0,  0,  0,  2 },
    {      6,   16,    0,  0,  0,  2 }, {      5,   16,    0,  0,  0,  2 }, {      4,   16,    0,  0,  0,  2 }, {      3,   16,    0,  0,  0,  2 }, {      2,   16,    0,  0,  0,  2 },
    {      1,   16,    0,  0,  0,  2 }, {      0,   16,    0,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3664, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  8,  0,  1 }, {     16,    9,    0,  8,  0,  1 },
    {     16,   10,    0,  8,  0,  1 }, {     16,   11,    0,  8,  0,  1 }, {     16,   12,    0,  8,  0,  1 }, {     16,   13,    0,  8,  0,  1 }, {     16,   14,    0,  8,  0,  1 },
    {     16,   15,    0,  8,  0,  1 }, {     16,   16,    0,  8,  0,  1 }, {     16,   17,    0,  8,  0,  1 }, {     16,   18,    0,  8,  0,  1 }, {     16,   19,    0,  8,  0,  1 },
    {     16,   20,    0,  8,  0,  1 }, {     16,   21,    0,  8,  0,  1 }, {     16,   22,    0,  8,  0,  1 }, {     16,   23,    0,  8,  0,  1 }, {     16,   24,    0,  8,  0,  2 },
    {     16,   25,    0,  8,  0,  2 }, {     16,   26,    0,  8,  0,  2 }, {     16,   27,    0,  8,  0,  2 }, {     16,   28,    0,  8,  0,  2 }, {     16,   29,    0,  8,  0,  2 },
    {     16,   30,    0,  8,  0,  2 }, {     16,   31,    0,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3786, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 16,  0,  1 }, {      9,   16,    0, 16,  0,  1 },
    {     10,   16,    0, 16,  0,  1 }, {     11,   16,    0, 16,  0,  1 }, {     12,   16,    0, 16,  0,  1 }, {     13,   16,    0, 16,  0,  1 }, {     14,   16,    0, 16,  0,  1 },
    {     15,   16,    0, 16,  0,  1 }, {     16,   16,    0, 16,  0,  1 }, {     17,   16,    0, 16,  0,  1 }, {     18,   16,    0, 16,  0,  1 }, {     19,   16,    0, 16,  0,  1 },
    {     20,   16,    0, 16,  0,  1 }, {     21,   16,    0, 16,  0,  1 }, {     22,   16,    0, 16,  0,  1 }, {     23,   16,    0, 16,  0,  1 }, {     24,   16,    0, 16,  0,  2 },
    {     25,   16,    0, 16,  0,  2 }, {     26,   16,    0, 16,  0,  2 }, {     27,   16,    0, 16,  0,  2 }, {     28,   16,    0, 16,  0,  2 }, {     29,   16,    0, 16,  0,  2 },
    {     30,   16,    0, 16,  0,  2 }, {     31,   16,    0, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C38A8, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 24,  0,  0 }, {     16,   23,    0, 24,  0,  1 }, {     16,   22,    0, 24,  0,  1 },
    {     16,   21,    0, 24,  0,  1 }, {     16,   20,    0, 24,  0,  1 }, {     16,   19,    0, 24,  0,  1 }, {     16,   18,    0, 24,  0,  1 }, {     16,   17,    0, 24,  0,  1 },
    {     16,   16,    0, 24,  0,  1 }, {     16,   15,    0, 24,  0,  1 }, {     16,   14,    0, 24,  0,  1 }, {     16,   13,    0, 24,  0,  1 }, {     16,   12,    0, 24,  0,  1 },
    {     16,   11,    0, 24,  0,  1 }, {     16,   10,    0, 24,  0,  1 }, {     16,    9,    0, 24,  0,  1 }, {     16,    8,    0, 24,  0,  1 }, {     16,    7,    0, 24,  0,  2 },
    {     16,    6,    0, 24,  0,  2 }, {     16,    5,    0, 24,  0,  2 }, {     16,    4,    0, 24,  0,  2 }, {     16,    3,    0, 24,  0,  2 }, {     16,    2,    0, 24,  0,  2 },
    {     16,    1,    0, 24,  0,  2 }, {     16,    0,    0, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C39CA, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  0,  0,  0 }, {     23,   16,    0,  0,  0,  3 }, {     22,   16,    0,  0,  0,  3 },
    {     21,   16,    0,  0,  0,  3 }, {     20,   16,    0,  0,  0,  3 }, {     19,   16,    0,  0,  0,  3 }, {     18,   16,    0,  0,  0,  3 }, {     17,   16,    0,  0,  0,  3 },
    {     16,   16,    0,  0,  0,  3 }, {     15,   16,    0,  0,  0,  3 }, {     14,   16,    0,  0,  0,  3 }, {     13,   16,    0,  0,  0,  3 }, {     12,   16,    0,  0,  0,  3 },
    {     11,   16,    0,  0,  0,  3 }, {     10,   16,    0,  0,  0,  3 }, {      9,   16,    0,  0,  0,  3 }, {      8,   16,    0,  0,  0,  3 }, {      7,   16,    0,  0,  0,  4 },
    {      6,   16,    0,  0,  0,  4 }, {      5,   16,    0,  0,  0,  4 }, {      4,   16,    0,  0,  0,  4 }, {      3,   16,    0,  0,  0,  4 }, {      2,   16,    0,  0,  0,  4 },
    {      1,   16,    0,  0,  0,  4 }, {      0,   16,    0,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3AEC, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  8,  0,  3 }, {     16,    9,    0,  8,  0,  3 },
    {     16,   10,    0,  8,  0,  3 }, {     16,   11,    0,  8,  0,  3 }, {     16,   12,    0,  8,  0,  3 }, {     16,   13,    0,  8,  0,  3 }, {     16,   14,    0,  8,  0,  3 },
    {     16,   15,    0,  8,  0,  3 }, {     16,   16,    0,  8,  0,  3 }, {     16,   17,    0,  8,  0,  3 }, {     16,   18,    0,  8,  0,  3 }, {     16,   19,    0,  8,  0,  3 },
    {     16,   20,    0,  8,  0,  3 }, {     16,   21,    0,  8,  0,  3 }, {     16,   22,    0,  8,  0,  3 }, {     16,   23,    0,  8,  0,  3 }, {     16,   24,    0,  8,  0,  4 },
    {     16,   25,    0,  8,  0,  4 }, {     16,   26,    0,  8,  0,  4 }, {     16,   27,    0,  8,  0,  4 }, {     16,   28,    0,  8,  0,  4 }, {     16,   29,    0,  8,  0,  4 },
    {     16,   30,    0,  8,  0,  4 }, {     16,   31,    0,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3C0E, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 16,  0,  3 }, {      9,   16,    0, 16,  0,  3 },
    {     10,   16,    0, 16,  0,  3 }, {     11,   16,    0, 16,  0,  3 }, {     12,   16,    0, 16,  0,  3 }, {     13,   16,    0, 16,  0,  3 }, {     14,   16,    0, 16,  0,  3 },
    {     15,   16,    0, 16,  0,  3 }, {     16,   16,    0, 16,  0,  3 }, {     17,   16,    0, 16,  0,  3 }, {     18,   16,    0, 16,  0,  3 }, {     19,   16,    0, 16,  0,  3 },
    {     20,   16,    0, 16,  0,  3 }, {     21,   16,    0, 16,  0,  3 }, {     22,   16,    0, 16,  0,  3 }, {     23,   16,    0, 16,  0,  3 }, {     24,   16,    0, 16,  0,  4 },
    {     25,   16,    0, 16,  0,  4 }, {     26,   16,    0, 16,  0,  4 }, {     27,   16,    0, 16,  0,  4 }, {     28,   16,    0, 16,  0,  4 }, {     29,   16,    0, 16,  0,  4 },
    {     30,   16,    0, 16,  0,  4 }, {     31,   16,    0, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3D30, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 24,  0,  0 }, {     16,   23,    0, 24,  0,  3 }, {     16,   22,    0, 24,  0,  3 },
    {     16,   21,    0, 24,  0,  3 }, {     16,   20,    0, 24,  0,  3 }, {     16,   19,    0, 24,  0,  3 }, {     16,   18,    0, 24,  0,  3 }, {     16,   17,    0, 24,  0,  3 },
    {     16,   16,    0, 24,  0,  3 }, {     16,   15,    0, 24,  0,  3 }, {     16,   14,    0, 24,  0,  3 }, {     16,   13,    0, 24,  0,  3 }, {     16,   12,    0, 24,  0,  3 },
    {     16,   11,    0, 24,  0,  3 }, {     16,   10,    0, 24,  0,  3 }, {     16,    9,    0, 24,  0,  3 }, {     16,    8,    0, 24,  0,  3 }, {     16,    7,    0, 24,  0,  4 },
    {     16,    6,    0, 24,  0,  4 }, {     16,    5,    0, 24,  0,  4 }, {     16,    4,    0, 24,  0,  4 }, {     16,    3,    0, 24,  0,  4 }, {     16,    2,    0, 24,  0,  4 },
    {     16,    1,    0, 24,  0,  4 }, {     16,    0,    0, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3E52, {
    {     31,   16,    0,  0,  0,  2 }, {     30,   16,    0,  0,  0,  2 }, {     29,   16,    0,  0,  0,  2 }, {     28,   16,    0,  0,  0,  2 }, {     27,   16,    0,  0,  0,  2 },
    {     26,   16,    0,  0,  0,  2 }, {     25,   16,    0,  0,  0,  2 }, {     24,   16,    0,  0,  0,  2 }, {     23,   16,    0,  0,  0,  1 }, {     22,   16,    0,  0,  0,  1 },
    {     21,   16,    0,  0,  0,  1 }, {     20,   16,    0,  0,  0,  1 }, {     19,   16,    0,  0,  0,  1 }, {     18,   16,    0,  0,  0,  1 }, {     17,   16,    0,  0,  0,  1 },
    {     16,   16,    0,  0,  0,  1 }, {     15,   16,    0,  0,  0,  1 }, {     14,   16,    0,  0,  0,  1 }, {     13,   16,    0,  0,  0,  1 }, {     12,   16,    0,  0,  0,  1 },
    {     11,   16,    0,  0,  0,  1 }, {     10,   16,    0,  0,  0,  1 }, {      9,   16,    0,  0,  0,  1 }, {      8,   16,    0,  0,  0,  1 }, {      7,   16,    0,  0,  0,  0 },
    {      6,   16,    0,  0,  0,  0 }, {      5,   16,    0,  0,  0,  0 }, {      4,   16,    0,  0,  0,  0 }, {      3,   16,    0,  0,  0,  0 }, {      2,   16,    0,  0,  0,  0 },
    {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C3F74, {
    {     16,    0,    0,  8,  0,  2 }, {     16,    1,    0,  8,  0,  2 }, {     16,    2,    0,  8,  0,  2 }, {     16,    3,    0,  8,  0,  2 }, {     16,    4,    0,  8,  0,  2 },
    {     16,    5,    0,  8,  0,  2 }, {     16,    6,    0,  8,  0,  2 }, {     16,    7,    0,  8,  0,  2 }, {     16,    8,    0,  8,  0,  1 }, {     16,    9,    0,  8,  0,  1 },
    {     16,   10,    0,  8,  0,  1 }, {     16,   11,    0,  8,  0,  1 }, {     16,   12,    0,  8,  0,  1 }, {     16,   13,    0,  8,  0,  1 }, {     16,   14,    0,  8,  0,  1 },
    {     16,   15,    0,  8,  0,  1 }, {     16,   16,    0,  8,  0,  1 }, {     16,   17,    0,  8,  0,  1 }, {     16,   18,    0,  8,  0,  1 }, {     16,   19,    0,  8,  0,  1 },
    {     16,   20,    0,  8,  0,  1 }, {     16,   21,    0,  8,  0,  1 }, {     16,   22,    0,  8,  0,  1 }, {     16,   23,    0,  8,  0,  1 }, {     16,   24,    0,  8,  0,  0 },
    {     16,   25,    0,  8,  0,  0 }, {     16,   26,    0,  8,  0,  0 }, {     16,   27,    0,  8,  0,  0 }, {     16,   28,    0,  8,  0,  0 }, {     16,   29,    0,  8,  0,  0 },
    {     16,   30,    0,  8,  0,  0 }, {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4096, {
    {      0,   16,    0, 16,  0,  2 }, {      1,   16,    0, 16,  0,  2 }, {      2,   16,    0, 16,  0,  2 }, {      3,   16,    0, 16,  0,  2 }, {      4,   16,    0, 16,  0,  2 },
    {      5,   16,    0, 16,  0,  2 }, {      6,   16,    0, 16,  0,  2 }, {      7,   16,    0, 16,  0,  2 }, {      8,   16,    0, 16,  0,  1 }, {      9,   16,    0, 16,  0,  1 },
    {     10,   16,    0, 16,  0,  1 }, {     11,   16,    0, 16,  0,  1 }, {     12,   16,    0, 16,  0,  1 }, {     13,   16,    0, 16,  0,  1 }, {     14,   16,    0, 16,  0,  1 },
    {     15,   16,    0, 16,  0,  1 }, {     16,   16,    0, 16,  0,  1 }, {     17,   16,    0, 16,  0,  1 }, {     18,   16,    0, 16,  0,  1 }, {     19,   16,    0, 16,  0,  1 },
    {     20,   16,    0, 16,  0,  1 }, {     21,   16,    0, 16,  0,  1 }, {     22,   16,    0, 16,  0,  1 }, {     23,   16,    0, 16,  0,  1 }, {     24,   16,    0, 16,  0,  0 },
    {     25,   16,    0, 16,  0,  0 }, {     26,   16,    0, 16,  0,  0 }, {     27,   16,    0, 16,  0,  0 }, {     28,   16,    0, 16,  0,  0 }, {     29,   16,    0, 16,  0,  0 },
    {     30,   16,    0, 16,  0,  0 }, {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C41B8, {
    {     16,   31,    0, 24,  0,  2 }, {     16,   30,    0, 24,  0,  2 }, {     16,   29,    0, 24,  0,  2 }, {     16,   28,    0, 24,  0,  2 }, {     16,   27,    0, 24,  0,  2 },
    {     16,   26,    0, 24,  0,  2 }, {     16,   25,    0, 24,  0,  2 }, {     16,   24,    0, 24,  0,  2 }, {     16,   23,    0, 24,  0,  1 }, {     16,   22,    0, 24,  0,  1 },
    {     16,   21,    0, 24,  0,  1 }, {     16,   20,    0, 24,  0,  1 }, {     16,   19,    0, 24,  0,  1 }, {     16,   18,    0, 24,  0,  1 }, {     16,   17,    0, 24,  0,  1 },
    {     16,   16,    0, 24,  0,  1 }, {     16,   15,    0, 24,  0,  1 }, {     16,   14,    0, 24,  0,  1 }, {     16,   13,    0, 24,  0,  1 }, {     16,   12,    0, 24,  0,  1 },
    {     16,   11,    0, 24,  0,  1 }, {     16,   10,    0, 24,  0,  1 }, {     16,    9,    0, 24,  0,  1 }, {     16,    8,    0, 24,  0,  1 }, {     16,    7,    0, 24,  0,  0 },
    {     16,    6,    0, 24,  0,  0 }, {     16,    5,    0, 24,  0,  0 }, {     16,    4,    0, 24,  0,  0 }, {     16,    3,    0, 24,  0,  0 }, {     16,    2,    0, 24,  0,  0 },
    {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C42DA, {
    {     31,   16,    0,  0,  0,  4 }, {     30,   16,    0,  0,  0,  4 }, {     29,   16,    0,  0,  0,  4 }, {     28,   16,    0,  0,  0,  4 }, {     27,   16,    0,  0,  0,  4 },
    {     26,   16,    0,  0,  0,  4 }, {     25,   16,    0,  0,  0,  4 }, {     24,   16,    0,  0,  0,  4 }, {     23,   16,    0,  0,  0,  3 }, {     22,   16,    0,  0,  0,  3 },
    {     21,   16,    0,  0,  0,  3 }, {     20,   16,    0,  0,  0,  3 }, {     19,   16,    0,  0,  0,  3 }, {     18,   16,    0,  0,  0,  3 }, {     17,   16,    0,  0,  0,  3 },
    {     16,   16,    0,  0,  0,  3 }, {     15,   16,    0,  0,  0,  3 }, {     14,   16,    0,  0,  0,  3 }, {     13,   16,    0,  0,  0,  3 }, {     12,   16,    0,  0,  0,  3 },
    {     11,   16,    0,  0,  0,  3 }, {     10,   16,    0,  0,  0,  3 }, {      9,   16,    0,  0,  0,  3 }, {      8,   16,    0,  0,  0,  3 }, {      7,   16,    0,  0,  0,  0 },
    {      6,   16,    0,  0,  0,  0 }, {      5,   16,    0,  0,  0,  0 }, {      4,   16,    0,  0,  0,  0 }, {      3,   16,    0,  0,  0,  0 }, {      2,   16,    0,  0,  0,  0 },
    {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C43FC, {
    {     16,    0,    0,  8,  0,  4 }, {     16,    1,    0,  8,  0,  4 }, {     16,    2,    0,  8,  0,  4 }, {     16,    3,    0,  8,  0,  4 }, {     16,    4,    0,  8,  0,  4 },
    {     16,    5,    0,  8,  0,  4 }, {     16,    6,    0,  8,  0,  4 }, {     16,    7,    0,  8,  0,  4 }, {     16,    8,    0,  8,  0,  3 }, {     16,    9,    0,  8,  0,  3 },
    {     16,   10,    0,  8,  0,  3 }, {     16,   11,    0,  8,  0,  3 }, {     16,   12,    0,  8,  0,  3 }, {     16,   13,    0,  8,  0,  3 }, {     16,   14,    0,  8,  0,  3 },
    {     16,   15,    0,  8,  0,  3 }, {     16,   16,    0,  8,  0,  3 }, {     16,   17,    0,  8,  0,  3 }, {     16,   18,    0,  8,  0,  3 }, {     16,   19,    0,  8,  0,  3 },
    {     16,   20,    0,  8,  0,  3 }, {     16,   21,    0,  8,  0,  3 }, {     16,   22,    0,  8,  0,  3 }, {     16,   23,    0,  8,  0,  3 }, {     16,   24,    0,  8,  0,  0 },
    {     16,   25,    0,  8,  0,  0 }, {     16,   26,    0,  8,  0,  0 }, {     16,   27,    0,  8,  0,  0 }, {     16,   28,    0,  8,  0,  0 }, {     16,   29,    0,  8,  0,  0 },
    {     16,   30,    0,  8,  0,  0 }, {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C451E, {
    {      0,   16,    0, 16,  0,  4 }, {      1,   16,    0, 16,  0,  4 }, {      2,   16,    0, 16,  0,  4 }, {      3,   16,    0, 16,  0,  4 }, {      4,   16,    0, 16,  0,  4 },
    {      5,   16,    0, 16,  0,  4 }, {      6,   16,    0, 16,  0,  4 }, {      7,   16,    0, 16,  0,  4 }, {      8,   16,    0, 16,  0,  3 }, {      9,   16,    0, 16,  0,  3 },
    {     10,   16,    0, 16,  0,  3 }, {     11,   16,    0, 16,  0,  3 }, {     12,   16,    0, 16,  0,  3 }, {     13,   16,    0, 16,  0,  3 }, {     14,   16,    0, 16,  0,  3 },
    {     15,   16,    0, 16,  0,  3 }, {     16,   16,    0, 16,  0,  3 }, {     17,   16,    0, 16,  0,  3 }, {     18,   16,    0, 16,  0,  3 }, {     19,   16,    0, 16,  0,  3 },
    {     20,   16,    0, 16,  0,  3 }, {     21,   16,    0, 16,  0,  3 }, {     22,   16,    0, 16,  0,  3 }, {     23,   16,    0, 16,  0,  3 }, {     24,   16,    0, 16,  0,  0 },
    {     25,   16,    0, 16,  0,  0 }, {     26,   16,    0, 16,  0,  0 }, {     27,   16,    0, 16,  0,  0 }, {     28,   16,    0, 16,  0,  0 }, {     29,   16,    0, 16,  0,  0 },
    {     30,   16,    0, 16,  0,  0 }, {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4640, {
    {     16,   31,    0, 24,  0,  4 }, {     16,   30,    0, 24,  0,  4 }, {     16,   29,    0, 24,  0,  4 }, {     16,   28,    0, 24,  0,  4 }, {     16,   27,    0, 24,  0,  4 },
    {     16,   26,    0, 24,  0,  4 }, {     16,   25,    0, 24,  0,  4 }, {     16,   24,    0, 24,  0,  4 }, {     16,   23,    0, 24,  0,  3 }, {     16,   22,    0, 24,  0,  3 },
    {     16,   21,    0, 24,  0,  3 }, {     16,   20,    0, 24,  0,  3 }, {     16,   19,    0, 24,  0,  3 }, {     16,   18,    0, 24,  0,  3 }, {     16,   17,    0, 24,  0,  3 },
    {     16,   16,    0, 24,  0,  3 }, {     16,   15,    0, 24,  0,  3 }, {     16,   14,    0, 24,  0,  3 }, {     16,   13,    0, 24,  0,  3 }, {     16,   12,    0, 24,  0,  3 },
    {     16,   11,    0, 24,  0,  3 }, {     16,   10,    0, 24,  0,  3 }, {     16,    9,    0, 24,  0,  3 }, {     16,    8,    0, 24,  0,  3 }, {     16,    7,    0, 24,  0,  0 },
    {     16,    6,    0, 24,  0,  0 }, {     16,    5,    0, 24,  0,  0 }, {     16,    4,    0, 24,  0,  0 }, {     16,    3,    0, 24,  0,  0 }, {     16,    2,    0, 24,  0,  0 },
    {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA0B2, {
    {     31,   16,    0,  0,  0,  2 }, {     30,   16,    0,  0,  0,  2 }, {     29,   16,    0,  0,  0,  2 }, {     28,   16,    0,  0,  0,  2 }, {     27,   16,    0,  0,  0,  2 },
    {     26,   16,    0,  0,  0,  2 }, {     25,   16,    0,  0,  0,  2 }, {     24,   16,    0, 31,  0,  2 }, {     23,   15,    0, 31,  0,  2 }, {     22,   15,    0, 31,  0,  2 },
    {     21,   15,    0, 31,  0,  2 }, {     20,   15,    0, 31,  0,  2 }, {     19,   15,    0, 31,  0,  2 }, {     18,   15,    0, 31,  0,  2 }, {     17,   14,    0, 31,  0,  2 },
    {     16,   14,    0, 31,  0,  2 }, {     15,   14,    0, 31,  0,  2 }, {     14,   14,    0, 31,  0,  2 }, {     13,   14,    0, 31,  0,  2 }, {     12,   13,    0, 31,  0,  2 },
    {     11,   13,    0, 31,  0,  2 }, {     10,   13,    0, 30,  0,  2 }, {      9,   13,    0, 30,  0,  2 }, {      8,   12,    0, 30,  0,  2 }, {      7,   12,    0, 30,  0,  2 },
    {      6,   12,    0, 30,  0,  2 }, {      5,   11,    0, 30,  0,  2 }, {      4,   11,    0, 30,  0,  2 }, {      3,   11,    0, 30,  0,  2 }, {      2,   10,    0, 30,  0,  2 },
    {      1,   10,    0, 30,  0,  2 }, {      0,    9,    0, 30,  0,  2 }, {     -1,    9,    0, 30,  0,  2 }, {     -2,    8,    0, 30,  0,  2 }, {     -3,    8,    0, 30,  0,  2 },
    {     -4,    7,    0, 30,  0,  2 }, {     -5,    7,    0, 29,  0,  2 }, {     -6,    6,    0, 29,  0,  2 }, {     -7,    6,    0, 29,  0,  2 }, {     -8,    5,    0, 29,  0,  2 },
    {     -9,    4,    0, 29,  0,  2 }, {    -10,    4,    0, 29,  0,  2 }, {    -11,    3,    0, 29,  0,  2 }, {    -12,    2,    0, 29,  0,  2 }, {    -13,    2,    0, 29,  0,  2 },
    {    -14,    1,    0, 29,  0,  2 }, {    -15,    0,    0, 29,  0,  2 }, {    -16,    0,    0, 29,  0,  2 }, {    -17,   -1,    0, 29,  0,  2 }, {    -18,   -2,    0, 28,  0,  2 },
    {    -19,   -3,    0, 28,  0,  2 }, {    -20,   -3,    0, 28,  0,  2 }, {    -21,   -4,    0, 28,  0,  2 }, {    -22,   -5,    0, 28,  0,  2 }, {    -23,   -6,    0, 28,  0,  2 },
    {    -24,   -7,    0, 28,  0,  2 }, {    -25,   -7,    0, 28,  0,  2 }, {    -26,   -8,    0, 28,  0,  2 }, {    -27,   -9,    0, 28,  0,  2 }, {    -28,  -10,    0, 28,  0,  2 },
    {    -29,  -11,    0, 28,  0,  2 }, {    -29,  -12,    0, 28,  0,  2 }, {    -30,  -13,    0, 27,  0,  2 }, {    -31,  -14,    0, 27,  0,  2 }, {    -32,  -15,    0, 27,  0,  2 },
    {    -32,  -16,    0, 27,  0,  2 }, {    -33,  -17,    0, 27,  0,  2 }, {    -34,  -18,    0, 27,  0,  2 }, {    -34,  -19,    0, 27,  0,  2 }, {    -35,  -20,    0, 27,  0,  2 },
    {    -36,  -21,    0, 27,  0,  2 }, {    -36,  -22,    0, 27,  0,  2 }, {    -37,  -23,    0, 27,  0,  2 }, {    -38,  -24,    0, 27,  0,  2 }, {    -38,  -25,    0, 27,  0,  2 },
    {    -39,  -26,    0, 26,  0,  2 }, {    -39,  -27,    0, 26,  0,  2 }, {    -40,  -28,    0, 26,  0,  2 }, {    -40,  -29,    0, 26,  0,  2 }, {    -41,  -30,    0, 26,  0,  2 },
    {    -41,  -31,    0, 26,  0,  2 }, {    -42,  -32,    0, 26,  0,  2 }, {    -42,  -33,    0, 26,  0,  2 }, {    -43,  -34,    0, 26,  0,  2 }, {    -43,  -35,    0, 26,  0,  2 },
    {    -43,  -36,    0, 26,  0,  2 }, {    -44,  -37,    0, 26,  0,  2 }, {    -44,  -38,    0, 26,  0,  2 }, {    -44,  -39,    0, 26,  0,  2 }, {    -45,  -40,    0, 25,  0,  2 },
    {    -45,  -41,    0, 25,  0,  2 }, {    -45,  -42,    0, 25,  0,  2 }, {    -45,  -43,    0, 25,  0,  2 }, {    -46,  -44,    0, 25,  0,  2 }, {    -46,  -45,    0, 25,  0,  2 },
    {    -46,  -46,    0, 25,  0,  2 }, {    -46,  -47,    0, 25,  0,  2 }, {    -46,  -48,    0, 25,  0,  2 }, {    -47,  -49,    0, 25,  0,  2 }, {    -47,  -50,    0, 25,  0,  2 },
    {    -47,  -51,    0, 25,  0,  2 }, {    -47,  -52,    0, 25,  0,  2 }, {    -47,  -53,    0, 25,  0,  2 }, {    -47,  -54,    0, 25,  0,  2 }, {    -48,  -55,    0, 25,  0,  2 },
    {    -48,  -56,    0, 24,  0,  2 }, {    -48,  -57,    0, 24,  0,  2 }, {    -48,  -58,    0, 24,  0,  2 }, {    -48,  -59,    0, 24,  0,  2 }, {    -48,  -60,    0, 24,  0,  2 },
    {    -48,  -61,    0, 24,  0,  2 }, {    -48,  -62,    0, 24,  0,  2 }, {    -48,  -63,    0, 24,  0,  2 }, {    -48,  -64,    0, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA4B6, {
    {     16,    0,    0,  8,  0,  2 }, {     16,    1,    0,  8,  0,  2 }, {     16,    2,    0,  8,  0,  2 }, {     16,    3,    0,  8,  0,  2 }, {     16,    4,    0,  8,  0,  2 },
    {     16,    5,    0,  8,  0,  2 }, {     16,    6,    0,  8,  0,  2 }, {     16,    7,    0,  8,  0,  2 }, {     16,    8,    0,  7,  0,  2 }, {     15,    9,    0,  7,  0,  2 },
    {     15,   10,    0,  7,  0,  2 }, {     15,   11,    0,  7,  0,  2 }, {     15,   12,    0,  7,  0,  2 }, {     15,   13,    0,  7,  0,  2 }, {     15,   14,    0,  7,  0,  2 },
    {     14,   15,    0,  7,  0,  2 }, {     14,   16,    0,  7,  0,  2 }, {     14,   17,    0,  7,  0,  2 }, {     14,   18,    0,  7,  0,  2 }, {     14,   19,    0,  7,  0,  2 },
    {     13,   20,    0,  7,  0,  2 }, {     13,   21,    0,  7,  0,  2 }, {     13,   22,    0,  6,  0,  2 }, {     13,   23,    0,  6,  0,  2 }, {     12,   24,    0,  6,  0,  2 },
    {     12,   25,    0,  6,  0,  2 }, {     12,   26,    0,  6,  0,  2 }, {     11,   27,    0,  6,  0,  2 }, {     11,   28,    0,  6,  0,  2 }, {     11,   29,    0,  6,  0,  2 },
    {     10,   30,    0,  6,  0,  2 }, {     10,   31,    0,  6,  0,  2 }, {      9,   32,    0,  6,  0,  2 }, {      9,   33,    0,  6,  0,  2 }, {      8,   34,    0,  6,  0,  2 },
    {      8,   35,    0,  6,  0,  2 }, {      7,   36,    0,  6,  0,  2 }, {      7,   37,    0,  5,  0,  2 }, {      6,   38,    0,  5,  0,  2 }, {      6,   39,    0,  5,  0,  2 },
    {      5,   40,    0,  5,  0,  2 }, {      4,   41,    0,  5,  0,  2 }, {      4,   42,    0,  5,  0,  2 }, {      3,   43,    0,  5,  0,  2 }, {      2,   44,    0,  5,  0,  2 },
    {      2,   45,    0,  5,  0,  2 }, {      1,   46,    0,  5,  0,  2 }, {      0,   47,    0,  5,  0,  2 }, {      0,   48,    0,  5,  0,  2 }, {     -1,   49,    0,  5,  0,  2 },
    {     -2,   50,    0,  4,  0,  2 }, {     -3,   51,    0,  4,  0,  2 }, {     -3,   52,    0,  4,  0,  2 }, {     -4,   53,    0,  4,  0,  2 }, {     -5,   54,    0,  4,  0,  2 },
    {     -6,   55,    0,  4,  0,  2 }, {     -7,   56,    0,  4,  0,  2 }, {     -7,   57,    0,  4,  0,  2 }, {     -8,   58,    0,  4,  0,  2 }, {     -9,   59,    0,  4,  0,  2 },
    {    -10,   60,    0,  4,  0,  2 }, {    -11,   61,    0,  4,  0,  2 }, {    -12,   61,    0,  4,  0,  2 }, {    -13,   62,    0,  3,  0,  2 }, {    -14,   63,    0,  3,  0,  2 },
    {    -15,   64,    0,  3,  0,  2 }, {    -16,   64,    0,  3,  0,  2 }, {    -17,   65,    0,  3,  0,  2 }, {    -18,   66,    0,  3,  0,  2 }, {    -19,   66,    0,  3,  0,  2 },
    {    -20,   67,    0,  3,  0,  2 }, {    -21,   68,    0,  3,  0,  2 }, {    -22,   68,    0,  3,  0,  2 }, {    -23,   69,    0,  3,  0,  2 }, {    -24,   70,    0,  3,  0,  2 },
    {    -25,   70,    0,  3,  0,  2 }, {    -26,   71,    0,  2,  0,  2 }, {    -27,   71,    0,  2,  0,  2 }, {    -28,   72,    0,  2,  0,  2 }, {    -29,   72,    0,  2,  0,  2 },
    {    -30,   73,    0,  2,  0,  2 }, {    -31,   73,    0,  2,  0,  2 }, {    -32,   74,    0,  2,  0,  2 }, {    -33,   74,    0,  2,  0,  2 }, {    -34,   75,    0,  2,  0,  2 },
    {    -35,   75,    0,  2,  0,  2 }, {    -36,   75,    0,  2,  0,  2 }, {    -37,   76,    0,  2,  0,  2 }, {    -38,   76,    0,  2,  0,  2 }, {    -39,   76,    0,  2,  0,  2 },
    {    -40,   77,    0,  1,  0,  2 }, {    -41,   77,    0,  1,  0,  2 }, {    -42,   77,    0,  1,  0,  2 }, {    -43,   77,    0,  1,  0,  2 }, {    -44,   78,    0,  1,  0,  2 },
    {    -45,   78,    0,  1,  0,  2 }, {    -46,   78,    0,  1,  0,  2 }, {    -47,   78,    0,  1,  0,  2 }, {    -48,   78,    0,  1,  0,  2 }, {    -49,   79,    0,  1,  0,  2 },
    {    -50,   79,    0,  1,  0,  2 }, {    -51,   79,    0,  1,  0,  2 }, {    -52,   79,    0,  1,  0,  2 }, {    -53,   79,    0,  1,  0,  2 }, {    -54,   79,    0,  1,  0,  2 },
    {    -55,   80,    0,  1,  0,  2 }, {    -56,   80,    0,  0,  0,  2 }, {    -57,   80,    0,  0,  0,  2 }, {    -58,   80,    0,  0,  0,  2 }, {    -59,   80,    0,  0,  0,  2 },
    {    -60,   80,    0,  0,  0,  2 }, {    -61,   80,    0,  0,  0,  2 }, {    -62,   80,    0,  0,  0,  2 }, {    -63,   80,    0,  0,  0,  2 }, {    -64,   80,    0,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CA8C3, {
    {      0,   16,    0, 16,  0,  2 }, {      1,   16,    0, 16,  0,  2 }, {      2,   16,    0, 16,  0,  2 }, {      3,   16,    0, 16,  0,  2 }, {      4,   16,    0, 16,  0,  2 },
    {      5,   16,    0, 16,  0,  2 }, {      6,   16,    0, 16,  0,  2 }, {      7,   16,    0, 16,  0,  2 }, {      8,   16,    0, 15,  0,  2 }, {      9,   17,    0, 15,  0,  2 },
    {     10,   17,    0, 15,  0,  2 }, {     11,   17,    0, 15,  0,  2 }, {     12,   17,    0, 15,  0,  2 }, {     13,   17,    0, 15,  0,  2 }, {     14,   17,    0, 15,  0,  2 },
    {     15,   18,    0, 15,  0,  2 }, {     16,   18,    0, 15,  0,  2 }, {     17,   18,    0, 15,  0,  2 }, {     18,   18,    0, 15,  0,  2 }, {     19,   18,    0, 15,  0,  2 },
    {     20,   19,    0, 15,  0,  2 }, {     21,   19,    0, 15,  0,  2 }, {     22,   19,    0, 14,  0,  2 }, {     23,   19,    0, 14,  0,  2 }, {     24,   20,    0, 14,  0,  2 },
    {     25,   20,    0, 14,  0,  2 }, {     26,   20,    0, 14,  0,  2 }, {     27,   21,    0, 14,  0,  2 }, {     28,   21,    0, 14,  0,  2 }, {     29,   21,    0, 14,  0,  2 },
    {     30,   22,    0, 14,  0,  2 }, {     31,   22,    0, 14,  0,  2 }, {     32,   23,    0, 14,  0,  2 }, {     33,   23,    0, 14,  0,  2 }, {     34,   24,    0, 14,  0,  2 },
    {     35,   24,    0, 14,  0,  2 }, {     36,   25,    0, 14,  0,  2 }, {     37,   25,    0, 13,  0,  2 }, {     38,   26,    0, 13,  0,  2 }, {     39,   26,    0, 13,  0,  2 },
    {     40,   27,    0, 13,  0,  2 }, {     41,   28,    0, 13,  0,  2 }, {     42,   28,    0, 13,  0,  2 }, {     43,   29,    0, 13,  0,  2 }, {     44,   30,    0, 13,  0,  2 },
    {     45,   30,    0, 13,  0,  2 }, {     46,   31,    0, 13,  0,  2 }, {     47,   32,    0, 13,  0,  2 }, {     48,   32,    0, 13,  0,  2 }, {     49,   33,    0, 13,  0,  2 },
    {     50,   34,    0, 12,  0,  2 }, {     51,   35,    0, 12,  0,  2 }, {     52,   35,    0, 12,  0,  2 }, {     53,   36,    0, 12,  0,  2 }, {     54,   37,    0, 12,  0,  2 },
    {     55,   38,    0, 12,  0,  2 }, {     56,   39,    0, 12,  0,  2 }, {     57,   39,    0, 12,  0,  2 }, {     58,   40,    0, 12,  0,  2 }, {     59,   41,    0, 12,  0,  2 },
    {     60,   42,    0, 12,  0,  2 }, {     61,   43,    0, 12,  0,  2 }, {     61,   44,    0, 12,  0,  2 }, {     62,   45,    0, 11,  0,  2 }, {     63,   46,    0, 11,  0,  2 },
    {     64,   47,    0, 11,  0,  2 }, {     64,   48,    0, 11,  0,  2 }, {     65,   49,    0, 11,  0,  2 }, {     66,   50,    0, 11,  0,  2 }, {     66,   51,    0, 11,  0,  2 },
    {     67,   52,    0, 11,  0,  2 }, {     68,   53,    0, 11,  0,  2 }, {     68,   54,    0, 11,  0,  2 }, {     69,   55,    0, 11,  0,  2 }, {     70,   56,    0, 11,  0,  2 },
    {     70,   57,    0, 11,  0,  2 }, {     71,   58,    0, 10,  0,  2 }, {     71,   59,    0, 10,  0,  2 }, {     72,   60,    0, 10,  0,  2 }, {     72,   61,    0, 10,  0,  2 },
    {     73,   62,    0, 10,  0,  2 }, {     73,   63,    0, 10,  0,  2 }, {     74,   64,    0, 10,  0,  2 }, {     74,   65,    0, 10,  0,  2 }, {     75,   66,    0, 10,  0,  2 },
    {     75,   67,    0, 10,  0,  2 }, {     75,   68,    0, 10,  0,  2 }, {     76,   69,    0, 10,  0,  2 }, {     76,   70,    0, 10,  0,  2 }, {     76,   71,    0, 10,  0,  2 },
    {     77,   72,    0,  9,  0,  2 }, {     77,   73,    0,  9,  0,  2 }, {     77,   74,    0,  9,  0,  2 }, {     77,   75,    0,  9,  0,  2 }, {     78,   76,    0,  9,  0,  2 },
    {     78,   77,    0,  9,  0,  2 }, {     78,   78,    0,  9,  0,  2 }, {     78,   79,    0,  9,  0,  2 }, {     78,   80,    0,  9,  0,  2 }, {     79,   81,    0,  9,  0,  2 },
    {     79,   82,    0,  9,  0,  2 }, {     79,   83,    0,  9,  0,  2 }, {     79,   84,    0,  9,  0,  2 }, {     79,   85,    0,  9,  0,  2 }, {     79,   86,    0,  9,  0,  2 },
    {     80,   87,    0,  9,  0,  2 }, {     80,   88,    0,  8,  0,  2 }, {     80,   89,    0,  8,  0,  2 }, {     80,   90,    0,  8,  0,  2 }, {     80,   91,    0,  8,  0,  2 },
    {     80,   92,    0,  8,  0,  2 }, {     80,   93,    0,  8,  0,  2 }, {     80,   94,    0,  8,  0,  2 }, {     80,   95,    0,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CACC7, {
    {     16,   31,    0, 24,  0,  2 }, {     16,   30,    0, 24,  0,  2 }, {     16,   29,    0, 24,  0,  2 }, {     16,   28,    0, 24,  0,  2 }, {     16,   27,    0, 24,  0,  2 },
    {     16,   26,    0, 24,  0,  2 }, {     16,   25,    0, 24,  0,  2 }, {     16,   24,    0, 23,  0,  2 }, {     17,   23,    0, 23,  0,  2 }, {     17,   22,    0, 23,  0,  2 },
    {     17,   21,    0, 23,  0,  2 }, {     17,   20,    0, 23,  0,  2 }, {     17,   19,    0, 23,  0,  2 }, {     17,   18,    0, 23,  0,  2 }, {     18,   17,    0, 23,  0,  2 },
    {     18,   16,    0, 23,  0,  2 }, {     18,   15,    0, 23,  0,  2 }, {     18,   14,    0, 23,  0,  2 }, {     18,   13,    0, 23,  0,  2 }, {     19,   12,    0, 23,  0,  2 },
    {     19,   11,    0, 23,  0,  2 }, {     19,   10,    0, 22,  0,  2 }, {     19,    9,    0, 22,  0,  2 }, {     20,    8,    0, 22,  0,  2 }, {     20,    7,    0, 22,  0,  2 },
    {     20,    6,    0, 22,  0,  2 }, {     21,    5,    0, 22,  0,  2 }, {     21,    4,    0, 22,  0,  2 }, {     21,    3,    0, 22,  0,  2 }, {     22,    2,    0, 22,  0,  2 },
    {     22,    1,    0, 22,  0,  2 }, {     23,    0,    0, 22,  0,  2 }, {     23,   -1,    0, 22,  0,  2 }, {     24,   -2,    0, 22,  0,  2 }, {     24,   -3,    0, 22,  0,  2 },
    {     25,   -4,    0, 22,  0,  2 }, {     25,   -5,    0, 21,  0,  2 }, {     26,   -6,    0, 21,  0,  2 }, {     26,   -7,    0, 21,  0,  2 }, {     27,   -8,    0, 21,  0,  2 },
    {     28,   -9,    0, 21,  0,  2 }, {     28,  -10,    0, 21,  0,  2 }, {     29,  -11,    0, 21,  0,  2 }, {     30,  -12,    0, 21,  0,  2 }, {     30,  -13,    0, 21,  0,  2 },
    {     31,  -14,    0, 21,  0,  2 }, {     32,  -15,    0, 21,  0,  2 }, {     32,  -16,    0, 21,  0,  2 }, {     33,  -17,    0, 21,  0,  2 }, {     34,  -18,    0, 20,  0,  2 },
    {     35,  -19,    0, 20,  0,  2 }, {     35,  -20,    0, 20,  0,  2 }, {     36,  -21,    0, 20,  0,  2 }, {     37,  -22,    0, 20,  0,  2 }, {     38,  -23,    0, 20,  0,  2 },
    {     39,  -24,    0, 20,  0,  2 }, {     39,  -25,    0, 20,  0,  2 }, {     40,  -26,    0, 20,  0,  2 }, {     41,  -27,    0, 20,  0,  2 }, {     42,  -28,    0, 20,  0,  2 },
    {     43,  -29,    0, 20,  0,  2 }, {     44,  -29,    0, 20,  0,  2 }, {     45,  -30,    0, 19,  0,  2 }, {     46,  -31,    0, 19,  0,  2 }, {     47,  -32,    0, 19,  0,  2 },
    {     48,  -32,    0, 19,  0,  2 }, {     49,  -33,    0, 19,  0,  2 }, {     50,  -34,    0, 19,  0,  2 }, {     51,  -34,    0, 19,  0,  2 }, {     52,  -35,    0, 19,  0,  2 },
    {     53,  -36,    0, 19,  0,  2 }, {     54,  -36,    0, 19,  0,  2 }, {     55,  -37,    0, 19,  0,  2 }, {     56,  -38,    0, 19,  0,  2 }, {     57,  -38,    0, 19,  0,  2 },
    {     58,  -39,    0, 18,  0,  2 }, {     59,  -39,    0, 18,  0,  2 }, {     60,  -40,    0, 18,  0,  2 }, {     61,  -40,    0, 18,  0,  2 }, {     62,  -41,    0, 18,  0,  2 },
    {     63,  -41,    0, 18,  0,  2 }, {     64,  -42,    0, 18,  0,  2 }, {     65,  -42,    0, 18,  0,  2 }, {     66,  -43,    0, 18,  0,  2 }, {     67,  -43,    0, 18,  0,  2 },
    {     68,  -43,    0, 18,  0,  2 }, {     69,  -44,    0, 18,  0,  2 }, {     70,  -44,    0, 18,  0,  2 }, {     71,  -44,    0, 18,  0,  2 }, {     72,  -45,    0, 17,  0,  2 },
    {     73,  -45,    0, 17,  0,  2 }, {     74,  -45,    0, 17,  0,  2 }, {     75,  -45,    0, 17,  0,  2 }, {     76,  -46,    0, 17,  0,  2 }, {     77,  -46,    0, 17,  0,  2 },
    {     78,  -46,    0, 17,  0,  2 }, {     79,  -46,    0, 17,  0,  2 }, {     80,  -46,    0, 17,  0,  2 }, {     81,  -47,    0, 17,  0,  2 }, {     82,  -47,    0, 17,  0,  2 },
    {     83,  -47,    0, 17,  0,  2 }, {     84,  -47,    0, 17,  0,  2 }, {     85,  -47,    0, 17,  0,  2 }, {     86,  -47,    0, 17,  0,  2 }, {     87,  -48,    0, 17,  0,  2 },
    {     88,  -48,    0, 16,  0,  2 }, {     89,  -48,    0, 16,  0,  2 }, {     90,  -48,    0, 16,  0,  2 }, {     91,  -48,    0, 16,  0,  2 }, {     92,  -48,    0, 16,  0,  2 },
    {     93,  -48,    0, 16,  0,  2 }, {     94,  -48,    0, 16,  0,  2 }, {     95,  -48,    0, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB0C2, {
    {     31,   16,    0,  0,  0,  4 }, {     30,   16,    0,  0,  0,  4 }, {     29,   16,    0,  0,  0,  4 }, {     28,   16,    0,  0,  0,  4 }, {     27,   16,    0,  0,  0,  4 },
    {     26,   16,    0,  0,  0,  4 }, {     25,   16,    0,  0,  0,  4 }, {     24,   16,    0,  1,  0,  4 }, {     23,   17,    0,  1,  0,  4 }, {     22,   17,    0,  1,  0,  4 },
    {     21,   17,    0,  1,  0,  4 }, {     20,   17,    0,  1,  0,  4 }, {     19,   17,    0,  1,  0,  4 }, {     18,   17,    0,  1,  0,  4 }, {     17,   18,    0,  1,  0,  4 },
    {     16,   18,    0,  1,  0,  4 }, {     15,   18,    0,  1,  0,  4 }, {     14,   18,    0,  1,  0,  4 }, {     13,   18,    0,  1,  0,  4 }, {     12,   19,    0,  1,  0,  4 },
    {     11,   19,    0,  1,  0,  4 }, {     10,   19,    0,  2,  0,  4 }, {      9,   19,    0,  2,  0,  4 }, {      8,   20,    0,  2,  0,  4 }, {      7,   20,    0,  2,  0,  4 },
    {      6,   20,    0,  2,  0,  4 }, {      5,   21,    0,  2,  0,  4 }, {      4,   21,    0,  2,  0,  4 }, {      3,   21,    0,  2,  0,  4 }, {      2,   22,    0,  2,  0,  4 },
    {      1,   22,    0,  2,  0,  4 }, {      0,   23,    0,  2,  0,  4 }, {     -1,   23,    0,  2,  0,  4 }, {     -2,   24,    0,  2,  0,  4 }, {     -3,   24,    0,  2,  0,  4 },
    {     -4,   25,    0,  2,  0,  4 }, {     -5,   25,    0,  3,  0,  4 }, {     -6,   26,    0,  3,  0,  4 }, {     -7,   26,    0,  3,  0,  4 }, {     -8,   27,    0,  3,  0,  4 },
    {     -9,   28,    0,  3,  0,  4 }, {    -10,   28,    0,  3,  0,  4 }, {    -11,   29,    0,  3,  0,  4 }, {    -12,   30,    0,  3,  0,  4 }, {    -13,   30,    0,  3,  0,  4 },
    {    -14,   31,    0,  3,  0,  4 }, {    -15,   32,    0,  3,  0,  4 }, {    -16,   32,    0,  3,  0,  4 }, {    -17,   33,    0,  3,  0,  4 }, {    -18,   34,    0,  4,  0,  4 },
    {    -19,   35,    0,  4,  0,  4 }, {    -20,   35,    0,  4,  0,  4 }, {    -21,   36,    0,  4,  0,  4 }, {    -22,   37,    0,  4,  0,  4 }, {    -23,   38,    0,  4,  0,  4 },
    {    -24,   39,    0,  4,  0,  4 }, {    -25,   39,    0,  4,  0,  4 }, {    -26,   40,    0,  4,  0,  4 }, {    -27,   41,    0,  4,  0,  4 }, {    -28,   42,    0,  4,  0,  4 },
    {    -29,   43,    0,  4,  0,  4 }, {    -29,   44,    0,  4,  0,  4 }, {    -30,   45,    0,  5,  0,  4 }, {    -31,   46,    0,  5,  0,  4 }, {    -32,   47,    0,  5,  0,  4 },
    {    -32,   48,    0,  5,  0,  4 }, {    -33,   49,    0,  5,  0,  4 }, {    -34,   50,    0,  5,  0,  4 }, {    -34,   51,    0,  5,  0,  4 }, {    -35,   52,    0,  5,  0,  4 },
    {    -36,   53,    0,  5,  0,  4 }, {    -36,   54,    0,  5,  0,  4 }, {    -37,   55,    0,  5,  0,  4 }, {    -38,   56,    0,  5,  0,  4 }, {    -38,   57,    0,  5,  0,  4 },
    {    -39,   58,    0,  6,  0,  4 }, {    -39,   59,    0,  6,  0,  4 }, {    -40,   60,    0,  6,  0,  4 }, {    -40,   61,    0,  6,  0,  4 }, {    -41,   62,    0,  6,  0,  4 },
    {    -41,   63,    0,  6,  0,  4 }, {    -42,   64,    0,  6,  0,  4 }, {    -42,   65,    0,  6,  0,  4 }, {    -43,   66,    0,  6,  0,  4 }, {    -43,   67,    0,  6,  0,  4 },
    {    -43,   68,    0,  6,  0,  4 }, {    -44,   69,    0,  6,  0,  4 }, {    -44,   70,    0,  6,  0,  4 }, {    -44,   71,    0,  6,  0,  4 }, {    -45,   72,    0,  7,  0,  4 },
    {    -45,   73,    0,  7,  0,  4 }, {    -45,   74,    0,  7,  0,  4 }, {    -45,   75,    0,  7,  0,  4 }, {    -46,   76,    0,  7,  0,  4 }, {    -46,   77,    0,  7,  0,  4 },
    {    -46,   78,    0,  7,  0,  4 }, {    -46,   79,    0,  7,  0,  4 }, {    -46,   80,    0,  7,  0,  4 }, {    -47,   81,    0,  7,  0,  4 }, {    -47,   82,    0,  7,  0,  4 },
    {    -47,   83,    0,  7,  0,  4 }, {    -47,   84,    0,  7,  0,  4 }, {    -47,   85,    0,  7,  0,  4 }, {    -47,   86,    0,  7,  0,  4 }, {    -48,   87,    0,  7,  0,  4 },
    {    -48,   88,    0,  8,  0,  4 }, {    -48,   89,    0,  8,  0,  4 }, {    -48,   90,    0,  8,  0,  4 }, {    -48,   91,    0,  8,  0,  4 }, {    -48,   92,    0,  8,  0,  4 },
    {    -48,   93,    0,  8,  0,  4 }, {    -48,   94,    0,  8,  0,  4 }, {    -48,   95,    0,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB4BD, {
    {     16,    0,    0,  8,  0,  4 }, {     16,    1,    0,  8,  0,  4 }, {     16,    2,    0,  8,  0,  4 }, {     16,    3,    0,  8,  0,  4 }, {     16,    4,    0,  8,  0,  4 },
    {     16,    5,    0,  8,  0,  4 }, {     16,    6,    0,  8,  0,  4 }, {     16,    7,    0,  8,  0,  4 }, {     16,    8,    0,  9,  0,  4 }, {     17,    9,    0,  9,  0,  4 },
    {     17,   10,    0,  9,  0,  4 }, {     17,   11,    0,  9,  0,  4 }, {     17,   12,    0,  9,  0,  4 }, {     17,   13,    0,  9,  0,  4 }, {     17,   14,    0,  9,  0,  4 },
    {     18,   15,    0,  9,  0,  4 }, {     18,   16,    0,  9,  0,  4 }, {     18,   17,    0,  9,  0,  4 }, {     18,   18,    0,  9,  0,  4 }, {     18,   19,    0,  9,  0,  4 },
    {     19,   20,    0,  9,  0,  4 }, {     19,   21,    0,  9,  0,  4 }, {     19,   22,    0, 10,  0,  4 }, {     19,   23,    0, 10,  0,  4 }, {     20,   24,    0, 10,  0,  4 },
    {     20,   25,    0, 10,  0,  4 }, {     20,   26,    0, 10,  0,  4 }, {     21,   27,    0, 10,  0,  4 }, {     21,   28,    0, 10,  0,  4 }, {     21,   29,    0, 10,  0,  4 },
    {     22,   30,    0, 10,  0,  4 }, {     22,   31,    0, 10,  0,  4 }, {     23,   32,    0, 10,  0,  4 }, {     23,   33,    0, 10,  0,  4 }, {     24,   34,    0, 10,  0,  4 },
    {     24,   35,    0, 10,  0,  4 }, {     25,   36,    0, 10,  0,  4 }, {     25,   37,    0, 11,  0,  4 }, {     26,   38,    0, 11,  0,  4 }, {     26,   39,    0, 11,  0,  4 },
    {     27,   40,    0, 11,  0,  4 }, {     28,   41,    0, 11,  0,  4 }, {     28,   42,    0, 11,  0,  4 }, {     29,   43,    0, 11,  0,  4 }, {     30,   44,    0, 11,  0,  4 },
    {     30,   45,    0, 11,  0,  4 }, {     31,   46,    0, 11,  0,  4 }, {     32,   47,    0, 11,  0,  4 }, {     32,   48,    0, 11,  0,  4 }, {     33,   49,    0, 11,  0,  4 },
    {     34,   50,    0, 12,  0,  4 }, {     35,   51,    0, 12,  0,  4 }, {     35,   52,    0, 12,  0,  4 }, {     36,   53,    0, 12,  0,  4 }, {     37,   54,    0, 12,  0,  4 },
    {     38,   55,    0, 12,  0,  4 }, {     39,   56,    0, 12,  0,  4 }, {     39,   57,    0, 12,  0,  4 }, {     40,   58,    0, 12,  0,  4 }, {     41,   59,    0, 12,  0,  4 },
    {     42,   60,    0, 12,  0,  4 }, {     43,   61,    0, 12,  0,  4 }, {     44,   61,    0, 12,  0,  4 }, {     45,   62,    0, 13,  0,  4 }, {     46,   63,    0, 13,  0,  4 },
    {     47,   64,    0, 13,  0,  4 }, {     48,   64,    0, 13,  0,  4 }, {     49,   65,    0, 13,  0,  4 }, {     50,   66,    0, 13,  0,  4 }, {     51,   66,    0, 13,  0,  4 },
    {     52,   67,    0, 13,  0,  4 }, {     53,   68,    0, 13,  0,  4 }, {     54,   68,    0, 13,  0,  4 }, {     55,   69,    0, 13,  0,  4 }, {     56,   70,    0, 13,  0,  4 },
    {     57,   70,    0, 13,  0,  4 }, {     58,   71,    0, 14,  0,  4 }, {     59,   71,    0, 14,  0,  4 }, {     60,   72,    0, 14,  0,  4 }, {     61,   72,    0, 14,  0,  4 },
    {     62,   73,    0, 14,  0,  4 }, {     63,   73,    0, 14,  0,  4 }, {     64,   74,    0, 14,  0,  4 }, {     65,   74,    0, 14,  0,  4 }, {     66,   75,    0, 14,  0,  4 },
    {     67,   75,    0, 14,  0,  4 }, {     68,   75,    0, 14,  0,  4 }, {     69,   76,    0, 14,  0,  4 }, {     70,   76,    0, 14,  0,  4 }, {     71,   76,    0, 14,  0,  4 },
    {     72,   77,    0, 15,  0,  4 }, {     73,   77,    0, 15,  0,  4 }, {     74,   77,    0, 15,  0,  4 }, {     75,   77,    0, 15,  0,  4 }, {     76,   78,    0, 15,  0,  4 },
    {     77,   78,    0, 15,  0,  4 }, {     78,   78,    0, 15,  0,  4 }, {     79,   78,    0, 15,  0,  4 }, {     80,   78,    0, 15,  0,  4 }, {     81,   79,    0, 15,  0,  4 },
    {     82,   79,    0, 15,  0,  4 }, {     83,   79,    0, 15,  0,  4 }, {     84,   79,    0, 15,  0,  4 }, {     85,   79,    0, 15,  0,  4 }, {     86,   79,    0, 15,  0,  4 },
    {     87,   80,    0, 15,  0,  4 }, {     88,   80,    0, 16,  0,  4 }, {     89,   80,    0, 16,  0,  4 }, {     90,   80,    0, 16,  0,  4 }, {     91,   80,    0, 16,  0,  4 },
    {     92,   80,    0, 16,  0,  4 }, {     93,   80,    0, 16,  0,  4 }, {     94,   80,    0, 16,  0,  4 }, {     95,   80,    0, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CB8C1, {
    {      0,   16,    0, 16,  0,  4 }, {      1,   16,    0, 16,  0,  4 }, {      2,   16,    0, 16,  0,  4 }, {      3,   16,    0, 16,  0,  4 }, {      4,   16,    0, 16,  0,  4 },
    {      5,   16,    0, 16,  0,  4 }, {      6,   16,    0, 16,  0,  4 }, {      7,   16,    0, 16,  0,  4 }, {      8,   16,    0, 17,  0,  4 }, {      9,   15,    0, 17,  0,  4 },
    {     10,   15,    0, 17,  0,  4 }, {     11,   15,    0, 17,  0,  4 }, {     12,   15,    0, 17,  0,  4 }, {     13,   15,    0, 17,  0,  4 }, {     14,   15,    0, 17,  0,  4 },
    {     15,   14,    0, 17,  0,  4 }, {     16,   14,    0, 17,  0,  4 }, {     17,   14,    0, 17,  0,  4 }, {     18,   14,    0, 17,  0,  4 }, {     19,   14,    0, 17,  0,  4 },
    {     20,   13,    0, 17,  0,  4 }, {     21,   13,    0, 17,  0,  4 }, {     22,   13,    0, 18,  0,  4 }, {     23,   13,    0, 18,  0,  4 }, {     24,   12,    0, 18,  0,  4 },
    {     25,   12,    0, 18,  0,  4 }, {     26,   12,    0, 18,  0,  4 }, {     27,   11,    0, 18,  0,  4 }, {     28,   11,    0, 18,  0,  4 }, {     29,   11,    0, 18,  0,  4 },
    {     30,   10,    0, 18,  0,  4 }, {     31,   10,    0, 18,  0,  4 }, {     32,    9,    0, 18,  0,  4 }, {     33,    9,    0, 18,  0,  4 }, {     34,    8,    0, 18,  0,  4 },
    {     35,    8,    0, 18,  0,  4 }, {     36,    7,    0, 18,  0,  4 }, {     37,    7,    0, 19,  0,  4 }, {     38,    6,    0, 19,  0,  4 }, {     39,    6,    0, 19,  0,  4 },
    {     40,    5,    0, 19,  0,  4 }, {     41,    4,    0, 19,  0,  4 }, {     42,    4,    0, 19,  0,  4 }, {     43,    3,    0, 19,  0,  4 }, {     44,    2,    0, 19,  0,  4 },
    {     45,    2,    0, 19,  0,  4 }, {     46,    1,    0, 19,  0,  4 }, {     47,    0,    0, 19,  0,  4 }, {     48,    0,    0, 19,  0,  4 }, {     49,   -1,    0, 19,  0,  4 },
    {     50,   -2,    0, 20,  0,  4 }, {     51,   -3,    0, 20,  0,  4 }, {     52,   -3,    0, 20,  0,  4 }, {     53,   -4,    0, 20,  0,  4 }, {     54,   -5,    0, 20,  0,  4 },
    {     55,   -6,    0, 20,  0,  4 }, {     56,   -7,    0, 20,  0,  4 }, {     57,   -7,    0, 20,  0,  4 }, {     58,   -8,    0, 20,  0,  4 }, {     59,   -9,    0, 20,  0,  4 },
    {     60,  -10,    0, 20,  0,  4 }, {     61,  -11,    0, 20,  0,  4 }, {     61,  -12,    0, 20,  0,  4 }, {     62,  -13,    0, 21,  0,  4 }, {     63,  -14,    0, 21,  0,  4 },
    {     64,  -15,    0, 21,  0,  4 }, {     64,  -16,    0, 21,  0,  4 }, {     65,  -17,    0, 21,  0,  4 }, {     66,  -18,    0, 21,  0,  4 }, {     66,  -19,    0, 21,  0,  4 },
    {     67,  -20,    0, 21,  0,  4 }, {     68,  -21,    0, 21,  0,  4 }, {     68,  -22,    0, 21,  0,  4 }, {     69,  -23,    0, 21,  0,  4 }, {     70,  -24,    0, 21,  0,  4 },
    {     70,  -25,    0, 21,  0,  4 }, {     71,  -26,    0, 22,  0,  4 }, {     71,  -27,    0, 22,  0,  4 }, {     72,  -28,    0, 22,  0,  4 }, {     72,  -29,    0, 22,  0,  4 },
    {     73,  -30,    0, 22,  0,  4 }, {     73,  -31,    0, 22,  0,  4 }, {     74,  -32,    0, 22,  0,  4 }, {     74,  -33,    0, 22,  0,  4 }, {     75,  -34,    0, 22,  0,  4 },
    {     75,  -35,    0, 22,  0,  4 }, {     75,  -36,    0, 22,  0,  4 }, {     76,  -37,    0, 22,  0,  4 }, {     76,  -38,    0, 22,  0,  4 }, {     76,  -39,    0, 22,  0,  4 },
    {     77,  -40,    0, 23,  0,  4 }, {     77,  -41,    0, 23,  0,  4 }, {     77,  -42,    0, 23,  0,  4 }, {     77,  -43,    0, 23,  0,  4 }, {     78,  -44,    0, 23,  0,  4 },
    {     78,  -45,    0, 23,  0,  4 }, {     78,  -46,    0, 23,  0,  4 }, {     78,  -47,    0, 23,  0,  4 }, {     78,  -48,    0, 23,  0,  4 }, {     79,  -49,    0, 23,  0,  4 },
    {     79,  -50,    0, 23,  0,  4 }, {     79,  -51,    0, 23,  0,  4 }, {     79,  -52,    0, 23,  0,  4 }, {     79,  -53,    0, 23,  0,  4 }, {     79,  -54,    0, 23,  0,  4 },
    {     80,  -55,    0, 23,  0,  4 }, {     80,  -56,    0, 24,  0,  4 }, {     80,  -57,    0, 24,  0,  4 }, {     80,  -58,    0, 24,  0,  4 }, {     80,  -59,    0, 24,  0,  4 },
    {     80,  -60,    0, 24,  0,  4 }, {     80,  -61,    0, 24,  0,  4 }, {     80,  -62,    0, 24,  0,  4 }, {     80,  -63,    0, 24,  0,  4 }, {     80,  -64,    0, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CBCCE, {
    {     16,   31,    0, 24,  0,  4 }, {     16,   30,    0, 24,  0,  4 }, {     16,   29,    0, 24,  0,  4 }, {     16,   28,    0, 24,  0,  4 }, {     16,   27,    0, 24,  0,  4 },
    {     16,   26,    0, 24,  0,  4 }, {     16,   25,    0, 24,  0,  4 }, {     16,   24,    0, 25,  0,  4 }, {     15,   23,    0, 25,  0,  4 }, {     15,   22,    0, 25,  0,  4 },
    {     15,   21,    0, 25,  0,  4 }, {     15,   20,    0, 25,  0,  4 }, {     15,   19,    0, 25,  0,  4 }, {     15,   18,    0, 25,  0,  4 }, {     14,   17,    0, 25,  0,  4 },
    {     14,   16,    0, 25,  0,  4 }, {     14,   15,    0, 25,  0,  4 }, {     14,   14,    0, 25,  0,  4 }, {     14,   13,    0, 25,  0,  4 }, {     13,   12,    0, 25,  0,  4 },
    {     13,   11,    0, 25,  0,  4 }, {     13,   10,    0, 26,  0,  4 }, {     13,    9,    0, 26,  0,  4 }, {     12,    8,    0, 26,  0,  4 }, {     12,    7,    0, 26,  0,  4 },
    {     12,    6,    0, 26,  0,  4 }, {     11,    5,    0, 26,  0,  4 }, {     11,    4,    0, 26,  0,  4 }, {     11,    3,    0, 26,  0,  4 }, {     10,    2,    0, 26,  0,  4 },
    {     10,    1,    0, 26,  0,  4 }, {      9,    0,    0, 26,  0,  4 }, {      9,   -1,    0, 26,  0,  4 }, {      8,   -2,    0, 26,  0,  4 }, {      8,   -3,    0, 26,  0,  4 },
    {      7,   -4,    0, 26,  0,  4 }, {      7,   -5,    0, 27,  0,  4 }, {      6,   -6,    0, 27,  0,  4 }, {      6,   -7,    0, 27,  0,  4 }, {      5,   -8,    0, 27,  0,  4 },
    {      4,   -9,    0, 27,  0,  4 }, {      4,  -10,    0, 27,  0,  4 }, {      3,  -11,    0, 27,  0,  4 }, {      2,  -12,    0, 27,  0,  4 }, {      2,  -13,    0, 27,  0,  4 },
    {      1,  -14,    0, 27,  0,  4 }, {      0,  -15,    0, 27,  0,  4 }, {      0,  -16,    0, 27,  0,  4 }, {     -1,  -17,    0, 27,  0,  4 }, {     -2,  -18,    0, 28,  0,  4 },
    {     -3,  -19,    0, 28,  0,  4 }, {     -3,  -20,    0, 28,  0,  4 }, {     -4,  -21,    0, 28,  0,  4 }, {     -5,  -22,    0, 28,  0,  4 }, {     -6,  -23,    0, 28,  0,  4 },
    {     -7,  -24,    0, 28,  0,  4 }, {     -7,  -25,    0, 28,  0,  4 }, {     -8,  -26,    0, 28,  0,  4 }, {     -9,  -27,    0, 28,  0,  4 }, {    -10,  -28,    0, 28,  0,  4 },
    {    -11,  -29,    0, 28,  0,  4 }, {    -12,  -29,    0, 28,  0,  4 }, {    -13,  -30,    0, 29,  0,  4 }, {    -14,  -31,    0, 29,  0,  4 }, {    -15,  -32,    0, 29,  0,  4 },
    {    -16,  -32,    0, 29,  0,  4 }, {    -17,  -33,    0, 29,  0,  4 }, {    -18,  -34,    0, 29,  0,  4 }, {    -19,  -34,    0, 29,  0,  4 }, {    -20,  -35,    0, 29,  0,  4 },
    {    -21,  -36,    0, 29,  0,  4 }, {    -22,  -36,    0, 29,  0,  4 }, {    -23,  -37,    0, 29,  0,  4 }, {    -24,  -38,    0, 29,  0,  4 }, {    -25,  -38,    0, 29,  0,  4 },
    {    -26,  -39,    0, 30,  0,  4 }, {    -27,  -39,    0, 30,  0,  4 }, {    -28,  -40,    0, 30,  0,  4 }, {    -29,  -40,    0, 30,  0,  4 }, {    -30,  -41,    0, 30,  0,  4 },
    {    -31,  -41,    0, 30,  0,  4 }, {    -32,  -42,    0, 30,  0,  4 }, {    -33,  -42,    0, 30,  0,  4 }, {    -34,  -43,    0, 30,  0,  4 }, {    -35,  -43,    0, 30,  0,  4 },
    {    -36,  -43,    0, 30,  0,  4 }, {    -37,  -44,    0, 30,  0,  4 }, {    -38,  -44,    0, 30,  0,  4 }, {    -39,  -44,    0, 30,  0,  4 }, {    -40,  -45,    0, 31,  0,  4 },
    {    -41,  -45,    0, 31,  0,  4 }, {    -42,  -45,    0, 31,  0,  4 }, {    -43,  -45,    0, 31,  0,  4 }, {    -44,  -46,    0, 31,  0,  4 }, {    -45,  -46,    0, 31,  0,  4 },
    {    -46,  -46,    0, 31,  0,  4 }, {    -47,  -46,    0, 31,  0,  4 }, {    -48,  -46,    0, 31,  0,  4 }, {    -49,  -47,    0, 31,  0,  4 }, {    -50,  -47,    0, 31,  0,  4 },
    {    -51,  -47,    0, 31,  0,  4 }, {    -52,  -47,    0, 31,  0,  4 }, {    -53,  -47,    0, 31,  0,  4 }, {    -54,  -47,    0, 31,  0,  4 }, {    -55,  -48,    0, 31,  0,  4 },
    {    -56,  -48,    0,  0,  0,  4 }, {    -57,  -48,    0,  0,  0,  4 }, {    -58,  -48,    0,  0,  0,  4 }, {    -59,  -48,    0,  0,  0,  4 }, {    -60,  -48,    0,  0,  0,  4 },
    {    -61,  -48,    0,  0,  0,  4 }, {    -62,  -48,    0,  0,  0,  4 }, {    -63,  -48,    0,  0,  0,  4 }, {    -64,  -48,    0,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4762, {
    {     31,   16,    0,  0,  0,  2 }, {     30,   16,    0,  0,  0,  2 }, {     29,   16,    0,  0,  0,  2 }, {     28,   16,    0,  0,  0,  2 }, {     27,   16,    0,  0,  0,  2 },
    {     26,   16,    0,  0,  0,  2 }, {     25,   16,    0,  0,  0,  2 }, {     24,   16,    0,  0,  0,  2 }, {     23,   16,    0,  0,  1,  1 }, {     22,   16,    0,  0,  1,  1 },
    {     21,   16,    1,  0,  1,  1 }, {     20,   16,    1,  0,  1,  1 }, {     19,   16,    1,  0,  1,  1 }, {     18,   16,    1,  0,  1,  1 }, {     17,   16,    1,  0,  1,  1 },
    {     16,   16,    1,  0,  1,  1 }, {     15,   16,    2,  0,  1,  1 }, {     14,   16,    2,  0,  1,  1 }, {     13,   16,    2,  0,  1,  1 }, {     12,   16,    2,  0,  1,  1 },
    {     11,   16,    3,  0,  1,  1 }, {     10,   16,    3,  0,  1,  1 }, {      9,   16,    3,  0,  1,  1 }, {      8,   16,    4,  0,  1,  1 }, {      7,   16,    4,  0,  2,  0 },
    {      6,   16,    4,  0,  2,  0 }, {      5,   16,    5,  0,  2,  0 }, {      4,   16,    5,  0,  2,  0 }, {      3,   16,    6,  0,  2,  0 }, {      2,   16,    6,  0,  2,  0 },
    {      1,   16,    7,  0,  2,  0 }, {      0,   16,    7,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4884, {
    {     16,    0,    0,  8,  0,  2 }, {     16,    1,    0,  8,  0,  2 }, {     16,    2,    0,  8,  0,  2 }, {     16,    3,    0,  8,  0,  2 }, {     16,    4,    0,  8,  0,  2 },
    {     16,    5,    0,  8,  0,  2 }, {     16,    6,    0,  8,  0,  2 }, {     16,    7,    0,  8,  0,  2 }, {     16,    8,    0,  8,  1,  1 }, {     16,    9,    0,  8,  1,  1 },
    {     16,   10,    1,  8,  1,  1 }, {     16,   11,    1,  8,  1,  1 }, {     16,   12,    1,  8,  1,  1 }, {     16,   13,    1,  8,  1,  1 }, {     16,   14,    1,  8,  1,  1 },
    {     16,   15,    1,  8,  1,  1 }, {     16,   16,    2,  8,  1,  1 }, {     16,   17,    2,  8,  1,  1 }, {     16,   18,    2,  8,  1,  1 }, {     16,   19,    2,  8,  1,  1 },
    {     16,   20,    3,  8,  1,  1 }, {     16,   21,    3,  8,  1,  1 }, {     16,   22,    3,  8,  1,  1 }, {     16,   23,    4,  8,  1,  1 }, {     16,   24,    4,  8,  2,  0 },
    {     16,   25,    4,  8,  2,  0 }, {     16,   26,    5,  8,  2,  0 }, {     16,   27,    5,  8,  2,  0 }, {     16,   28,    6,  8,  2,  0 }, {     16,   29,    6,  8,  2,  0 },
    {     16,   30,    7,  8,  2,  0 }, {     16,   31,    7,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C49A6, {
    {      0,   16,    0, 16,  0,  2 }, {      1,   16,    0, 16,  0,  2 }, {      2,   16,    0, 16,  0,  2 }, {      3,   16,    0, 16,  0,  2 }, {      4,   16,    0, 16,  0,  2 },
    {      5,   16,    0, 16,  0,  2 }, {      6,   16,    0, 16,  0,  2 }, {      7,   16,    0, 16,  0,  2 }, {      8,   16,    0, 16,  1,  1 }, {      9,   16,    0, 16,  1,  1 },
    {     10,   16,    1, 16,  1,  1 }, {     11,   16,    1, 16,  1,  1 }, {     12,   16,    1, 16,  1,  1 }, {     13,   16,    1, 16,  1,  1 }, {     14,   16,    1, 16,  1,  1 },
    {     15,   16,    1, 16,  1,  1 }, {     16,   16,    2, 16,  1,  1 }, {     17,   16,    2, 16,  1,  1 }, {     18,   16,    2, 16,  1,  1 }, {     19,   16,    2, 16,  1,  1 },
    {     20,   16,    3, 16,  1,  1 }, {     21,   16,    3, 16,  1,  1 }, {     22,   16,    3, 16,  1,  1 }, {     23,   16,    4, 16,  1,  1 }, {     24,   16,    4, 16,  2,  0 },
    {     25,   16,    4, 16,  2,  0 }, {     26,   16,    5, 16,  2,  0 }, {     27,   16,    5, 16,  2,  0 }, {     28,   16,    6, 16,  2,  0 }, {     29,   16,    6, 16,  2,  0 },
    {     30,   16,    7, 16,  2,  0 }, {     31,   16,    7, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4AC8, {
    {     16,   31,    0, 24,  0,  2 }, {     16,   30,    0, 24,  0,  2 }, {     16,   29,    0, 24,  0,  2 }, {     16,   28,    0, 24,  0,  2 }, {     16,   27,    0, 24,  0,  2 },
    {     16,   26,    0, 24,  0,  2 }, {     16,   25,    0, 24,  0,  2 }, {     16,   24,    0, 24,  0,  2 }, {     16,   23,    0, 24,  1,  1 }, {     16,   22,    0, 24,  1,  1 },
    {     16,   21,    1, 24,  1,  1 }, {     16,   20,    1, 24,  1,  1 }, {     16,   19,    1, 24,  1,  1 }, {     16,   18,    1, 24,  1,  1 }, {     16,   17,    1, 24,  1,  1 },
    {     16,   16,    1, 24,  1,  1 }, {     16,   15,    2, 24,  1,  1 }, {     16,   14,    2, 24,  1,  1 }, {     16,   13,    2, 24,  1,  1 }, {     16,   12,    2, 24,  1,  1 },
    {     16,   11,    3, 24,  1,  1 }, {     16,   10,    3, 24,  1,  1 }, {     16,    9,    3, 24,  1,  1 }, {     16,    8,    4, 24,  1,  1 }, {     16,    7,    4, 24,  2,  0 },
    {     16,    6,    4, 24,  2,  0 }, {     16,    5,    5, 24,  2,  0 }, {     16,    4,    5, 24,  2,  0 }, {     16,    3,    6, 24,  2,  0 }, {     16,    2,    6, 24,  2,  0 },
    {     16,    1,    7, 24,  2,  0 }, {     16,    0,    7, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4BEA, {
    {     31,   16,    0,  0,  0,  4 }, {     30,   16,    0,  0,  0,  4 }, {     29,   16,    0,  0,  0,  4 }, {     28,   16,    0,  0,  0,  4 }, {     27,   16,    0,  0,  0,  4 },
    {     26,   16,    0,  0,  0,  4 }, {     25,   16,    0,  0,  0,  4 }, {     24,   16,    0,  0,  0,  4 }, {     23,   16,    0,  0,  1,  3 }, {     22,   16,    0,  0,  1,  3 },
    {     21,   16,    1,  0,  1,  3 }, {     20,   16,    1,  0,  1,  3 }, {     19,   16,    1,  0,  1,  3 }, {     18,   16,    1,  0,  1,  3 }, {     17,   16,    1,  0,  1,  3 },
    {     16,   16,    1,  0,  1,  3 }, {     15,   16,    2,  0,  1,  3 }, {     14,   16,    2,  0,  1,  3 }, {     13,   16,    2,  0,  1,  3 }, {     12,   16,    2,  0,  1,  3 },
    {     11,   16,    3,  0,  1,  3 }, {     10,   16,    3,  0,  1,  3 }, {      9,   16,    3,  0,  1,  3 }, {      8,   16,    4,  0,  1,  3 }, {      7,   16,    4,  0,  2,  0 },
    {      6,   16,    4,  0,  2,  0 }, {      5,   16,    5,  0,  2,  0 }, {      4,   16,    5,  0,  2,  0 }, {      3,   16,    6,  0,  2,  0 }, {      2,   16,    6,  0,  2,  0 },
    {      1,   16,    7,  0,  2,  0 }, {      0,   16,    7,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4D0C, {
    {     16,    0,    0,  8,  0,  4 }, {     16,    1,    0,  8,  0,  4 }, {     16,    2,    0,  8,  0,  4 }, {     16,    3,    0,  8,  0,  4 }, {     16,    4,    0,  8,  0,  4 },
    {     16,    5,    0,  8,  0,  4 }, {     16,    6,    0,  8,  0,  4 }, {     16,    7,    0,  8,  0,  4 }, {     16,    8,    0,  8,  1,  3 }, {     16,    9,    0,  8,  1,  3 },
    {     16,   10,    1,  8,  1,  3 }, {     16,   11,    1,  8,  1,  3 }, {     16,   12,    1,  8,  1,  3 }, {     16,   13,    1,  8,  1,  3 }, {     16,   14,    1,  8,  1,  3 },
    {     16,   15,    1,  8,  1,  3 }, {     16,   16,    2,  8,  1,  3 }, {     16,   17,    2,  8,  1,  3 }, {     16,   18,    2,  8,  1,  3 }, {     16,   19,    2,  8,  1,  3 },
    {     16,   20,    3,  8,  1,  3 }, {     16,   21,    3,  8,  1,  3 }, {     16,   22,    3,  8,  1,  3 }, {     16,   23,    4,  8,  1,  3 }, {     16,   24,    4,  8,  2,  0 },
    {     16,   25,    4,  8,  2,  0 }, {     16,   26,    5,  8,  2,  0 }, {     16,   27,    5,  8,  2,  0 }, {     16,   28,    6,  8,  2,  0 }, {     16,   29,    6,  8,  2,  0 },
    {     16,   30,    7,  8,  2,  0 }, {     16,   31,    7,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4E2E, {
    {      0,   16,    0, 16,  0,  4 }, {      1,   16,    0, 16,  0,  4 }, {      2,   16,    0, 16,  0,  4 }, {      3,   16,    0, 16,  0,  4 }, {      4,   16,    0, 16,  0,  4 },
    {      5,   16,    0, 16,  0,  4 }, {      6,   16,    0, 16,  0,  4 }, {      7,   16,    0, 16,  0,  4 }, {      8,   16,    0, 16,  1,  3 }, {      9,   16,    0, 16,  1,  3 },
    {     10,   16,    1, 16,  1,  3 }, {     11,   16,    1, 16,  1,  3 }, {     12,   16,    1, 16,  1,  3 }, {     13,   16,    1, 16,  1,  3 }, {     14,   16,    1, 16,  1,  3 },
    {     15,   16,    1, 16,  1,  3 }, {     16,   16,    2, 16,  1,  3 }, {     17,   16,    2, 16,  1,  3 }, {     18,   16,    2, 16,  1,  3 }, {     19,   16,    2, 16,  1,  3 },
    {     20,   16,    3, 16,  1,  3 }, {     21,   16,    3, 16,  1,  3 }, {     22,   16,    3, 16,  1,  3 }, {     23,   16,    4, 16,  1,  3 }, {     24,   16,    4, 16,  2,  0 },
    {     25,   16,    4, 16,  2,  0 }, {     26,   16,    5, 16,  2,  0 }, {     27,   16,    5, 16,  2,  0 }, {     28,   16,    6, 16,  2,  0 }, {     29,   16,    6, 16,  2,  0 },
    {     30,   16,    7, 16,  2,  0 }, {     31,   16,    7, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C4F50, {
    {     16,   31,    0, 24,  0,  4 }, {     16,   30,    0, 24,  0,  4 }, {     16,   29,    0, 24,  0,  4 }, {     16,   28,    0, 24,  0,  4 }, {     16,   27,    0, 24,  0,  4 },
    {     16,   26,    0, 24,  0,  4 }, {     16,   25,    0, 24,  0,  4 }, {     16,   24,    0, 24,  0,  4 }, {     16,   23,    0, 24,  1,  3 }, {     16,   22,    0, 24,  1,  3 },
    {     16,   21,    1, 24,  1,  3 }, {     16,   20,    1, 24,  1,  3 }, {     16,   19,    1, 24,  1,  3 }, {     16,   18,    1, 24,  1,  3 }, {     16,   17,    1, 24,  1,  3 },
    {     16,   16,    1, 24,  1,  3 }, {     16,   15,    2, 24,  1,  3 }, {     16,   14,    2, 24,  1,  3 }, {     16,   13,    2, 24,  1,  3 }, {     16,   12,    2, 24,  1,  3 },
    {     16,   11,    3, 24,  1,  3 }, {     16,   10,    3, 24,  1,  3 }, {     16,    9,    3, 24,  1,  3 }, {     16,    8,    4, 24,  1,  3 }, {     16,    7,    4, 24,  2,  0 },
    {     16,    6,    4, 24,  2,  0 }, {     16,    5,    5, 24,  2,  0 }, {     16,    4,    5, 24,  2,  0 }, {     16,    3,    6, 24,  2,  0 }, {     16,    2,    6, 24,  2,  0 },
    {     16,    1,    7, 24,  2,  0 }, {     16,    0,    7, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5072, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  0,  2,  0 }, {     23,   16,    4,  0,  1,  1 }, {     22,   16,    4,  0,  1,  1 },
    {     21,   16,    4,  0,  1,  1 }, {     20,   16,    5,  0,  1,  1 }, {     19,   16,    5,  0,  1,  1 }, {     18,   16,    5,  0,  1,  1 }, {     17,   16,    6,  0,  1,  1 },
    {     16,   16,    6,  0,  1,  1 }, {     15,   16,    6,  0,  1,  1 }, {     14,   16,    6,  0,  1,  1 }, {     13,   16,    7,  0,  1,  1 }, {     12,   16,    7,  0,  1,  1 },
    {     11,   16,    7,  0,  1,  1 }, {     10,   16,    7,  0,  1,  1 }, {      9,   16,    7,  0,  0,  2 }, {      8,   16,    7,  0,  0,  2 }, {      7,   16,    8,  0,  0,  2 },
    {      6,   16,    8,  0,  0,  2 }, {      5,   16,    8,  0,  0,  2 }, {      4,   16,    8,  0,  0,  2 }, {      3,   16,    8,  0,  0,  2 }, {      2,   16,    8,  0,  0,  2 },
    {      1,   16,    8,  0,  0,  2 }, {      0,   16,    8,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C51A6, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    4,  8,  1,  1 }, {     16,    9,    4,  8,  1,  1 },
    {     16,   10,    4,  8,  1,  1 }, {     16,   11,    5,  8,  1,  1 }, {     16,   12,    5,  8,  1,  1 }, {     16,   13,    5,  8,  1,  1 }, {     16,   14,    6,  8,  1,  1 },
    {     16,   15,    6,  8,  1,  1 }, {     16,   16,    6,  8,  1,  1 }, {     16,   17,    6,  8,  1,  1 }, {     16,   18,    7,  8,  1,  1 }, {     16,   19,    7,  8,  1,  1 },
    {     16,   20,    7,  8,  1,  1 }, {     16,   21,    7,  8,  1,  1 }, {     16,   22,    7,  8,  0,  2 }, {     16,   23,    7,  8,  0,  2 }, {     16,   24,    8,  8,  0,  2 },
    {     16,   25,    8,  8,  0,  2 }, {     16,   26,    8,  8,  0,  2 }, {     16,   27,    8,  8,  0,  2 }, {     16,   28,    8,  8,  0,  2 }, {     16,   29,    8,  8,  0,  2 },
    {     16,   30,    8,  8,  0,  2 }, {     16,   31,    8,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C52DA, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    4, 16,  1,  1 }, {      9,   16,    4, 16,  1,  1 },
    {     10,   16,    4, 16,  1,  1 }, {     11,   16,    5, 16,  1,  1 }, {     12,   16,    5, 16,  1,  1 }, {     13,   16,    5, 16,  1,  1 }, {     14,   16,    6, 16,  1,  1 },
    {     15,   16,    6, 16,  1,  1 }, {     16,   16,    6, 16,  1,  1 }, {     17,   16,    6, 16,  1,  1 }, {     18,   16,    7, 16,  1,  1 }, {     19,   16,    7, 16,  1,  1 },
    {     20,   16,    7, 16,  1,  1 }, {     21,   16,    7, 16,  1,  1 }, {     22,   16,    7, 16,  0,  2 }, {     23,   16,    7, 16,  0,  2 }, {     24,   16,    8, 16,  0,  2 },
    {     25,   16,    8, 16,  0,  2 }, {     26,   16,    8, 16,  0,  2 }, {     27,   16,    8, 16,  0,  2 }, {     28,   16,    8, 16,  0,  2 }, {     29,   16,    8, 16,  0,  2 },
    {     30,   16,    8, 16,  0,  2 }, {     31,   16,    8, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C540E, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 24,  2,  0 }, {     16,   23,    4, 24,  1,  1 }, {     16,   22,    4, 24,  1,  1 },
    {     16,   21,    4, 24,  1,  1 }, {     16,   20,    5, 24,  1,  1 }, {     16,   19,    5, 24,  1,  1 }, {     16,   18,    5, 24,  1,  1 }, {     16,   17,    6, 24,  1,  1 },
    {     16,   16,    6, 24,  1,  1 }, {     16,   15,    6, 24,  1,  1 }, {     16,   14,    6, 24,  1,  1 }, {     16,   13,    7, 24,  1,  1 }, {     16,   12,    7, 24,  1,  1 },
    {     16,   11,    7, 24,  1,  1 }, {     16,   10,    7, 24,  1,  1 }, {     16,    9,    7, 24,  0,  2 }, {     16,    8,    7, 24,  0,  2 }, {     16,    7,    8, 24,  0,  2 },
    {     16,    6,    8, 24,  0,  2 }, {     16,    5,    8, 24,  0,  2 }, {     16,    4,    8, 24,  0,  2 }, {     16,    3,    8, 24,  0,  2 }, {     16,    2,    8, 24,  0,  2 },
    {     16,    1,    8, 24,  0,  2 }, {     16,    0,    8, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5542, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  0,  2,  0 }, {     23,   16,    4,  0,  1,  3 }, {     22,   16,    4,  0,  1,  3 },
    {     21,   16,    4,  0,  1,  3 }, {     20,   16,    5,  0,  1,  3 }, {     19,   16,    5,  0,  1,  3 }, {     18,   16,    5,  0,  1,  3 }, {     17,   16,    6,  0,  1,  3 },
    {     16,   16,    6,  0,  1,  3 }, {     15,   16,    6,  0,  1,  3 }, {     14,   16,    6,  0,  1,  3 }, {     13,   16,    7,  0,  1,  3 }, {     12,   16,    7,  0,  1,  3 },
    {     11,   16,    7,  0,  1,  3 }, {     10,   16,    7,  0,  1,  3 }, {      9,   16,    7,  0,  0,  4 }, {      8,   16,    7,  0,  0,  4 }, {      7,   16,    8,  0,  0,  4 },
    {      6,   16,    8,  0,  0,  4 }, {      5,   16,    8,  0,  0,  4 }, {      4,   16,    8,  0,  0,  4 }, {      3,   16,    8,  0,  0,  4 }, {      2,   16,    8,  0,  0,  4 },
    {      1,   16,    8,  0,  0,  4 }, {      0,   16,    8,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5676, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    4,  8,  1,  3 }, {     16,    9,    4,  8,  1,  3 },
    {     16,   10,    4,  8,  1,  3 }, {     16,   11,    5,  8,  1,  3 }, {     16,   12,    5,  8,  1,  3 }, {     16,   13,    5,  8,  1,  3 }, {     16,   14,    6,  8,  1,  3 },
    {     16,   15,    6,  8,  1,  3 }, {     16,   16,    6,  8,  1,  3 }, {     16,   17,    6,  8,  1,  3 }, {     16,   18,    7,  8,  1,  3 }, {     16,   19,    7,  8,  1,  3 },
    {     16,   20,    7,  8,  1,  3 }, {     16,   21,    7,  8,  1,  3 }, {     16,   22,    7,  8,  0,  4 }, {     16,   23,    7,  8,  0,  4 }, {     16,   24,    8,  8,  0,  4 },
    {     16,   25,    8,  8,  0,  4 }, {     16,   26,    8,  8,  0,  4 }, {     16,   27,    8,  8,  0,  4 }, {     16,   28,    8,  8,  0,  4 }, {     16,   29,    8,  8,  0,  4 },
    {     16,   30,    8,  8,  0,  4 }, {     16,   31,    8,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C57AA, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    4, 16,  1,  3 }, {      9,   16,    4, 16,  1,  3 },
    {     10,   16,    4, 16,  1,  3 }, {     11,   16,    5, 16,  1,  3 }, {     12,   16,    5, 16,  1,  3 }, {     13,   16,    5, 16,  1,  3 }, {     14,   16,    6, 16,  1,  3 },
    {     15,   16,    6, 16,  1,  3 }, {     16,   16,    6, 16,  1,  3 }, {     17,   16,    6, 16,  1,  3 }, {     18,   16,    7, 16,  1,  3 }, {     19,   16,    7, 16,  1,  3 },
    {     20,   16,    7, 16,  1,  3 }, {     21,   16,    7, 16,  1,  3 }, {     22,   16,    7, 16,  0,  4 }, {     23,   16,    7, 16,  0,  4 }, {     24,   16,    8, 16,  0,  4 },
    {     25,   16,    8, 16,  0,  4 }, {     26,   16,    8, 16,  0,  4 }, {     27,   16,    8, 16,  0,  4 }, {     28,   16,    8, 16,  0,  4 }, {     29,   16,    8, 16,  0,  4 },
    {     30,   16,    8, 16,  0,  4 }, {     31,   16,    8, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C58DE, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 24,  2,  0 }, {     16,   23,    4, 24,  1,  3 }, {     16,   22,    4, 24,  1,  3 },
    {     16,   21,    4, 24,  1,  3 }, {     16,   20,    5, 24,  1,  3 }, {     16,   19,    5, 24,  1,  3 }, {     16,   18,    5, 24,  1,  3 }, {     16,   17,    6, 24,  1,  3 },
    {     16,   16,    6, 24,  1,  3 }, {     16,   15,    6, 24,  1,  3 }, {     16,   14,    6, 24,  1,  3 }, {     16,   13,    7, 24,  1,  3 }, {     16,   12,    7, 24,  1,  3 },
    {     16,   11,    7, 24,  1,  3 }, {     16,   10,    7, 24,  1,  3 }, {     16,    9,    7, 24,  0,  4 }, {     16,    8,    7, 24,  0,  4 }, {     16,    7,    8, 24,  0,  4 },
    {     16,    6,    8, 24,  0,  4 }, {     16,    5,    8, 24,  0,  4 }, {     16,    4,    8, 24,  0,  4 }, {     16,    3,    8, 24,  0,  4 }, {     16,    2,    8, 24,  0,  4 },
    {     16,    1,    8, 24,  0,  4 }, {     16,    0,    8, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6322, {
    {     31,   16,    8,  0,  0,  2 }, {     30,   16,    8,  0,  0,  2 }, {     29,   16,    8,  0,  0,  2 }, {     28,   16,    8,  0,  0,  2 }, {     27,   16,    8,  0,  0,  2 },
    {     26,   16,    8,  0,  0,  2 }, {     25,   16,    8,  0,  0,  2 }, {     24,   16,    8,  0,  0,  2 }, {     23,   16,    7,  0,  5,  1 }, {     22,   16,    7,  0,  5,  1 },
    {     21,   16,    7,  0,  5,  1 }, {     20,   16,    7,  0,  5,  1 }, {     19,   16,    7,  0,  5,  1 }, {     18,   16,    7,  0,  5,  1 }, {     17,   16,    6,  0,  5,  1 },
    {     16,   16,    6,  0,  5,  1 }, {     15,   16,    6,  0,  5,  1 }, {     14,   16,    6,  0,  5,  1 }, {     13,   16,    5,  0,  5,  1 }, {     12,   16,    5,  0,  5,  1 },
    {     11,   16,    5,  0,  5,  1 }, {     10,   16,    4,  0,  5,  1 }, {      9,   16,    4,  0,  5,  1 }, {      8,   16,    4,  0,  5,  1 }, {      7,   16,    3,  0,  6,  0 },
    {      6,   16,    3,  0,  6,  0 }, {      5,   16,    2,  0,  6,  0 }, {      4,   16,    2,  0,  6,  0 }, {      3,   16,    1,  0,  6,  0 }, {      2,   16,    1,  0,  6,  0 },
    {      1,   16,    0,  0,  6,  0 }, {      0,   16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6444, {
    {     16,    0,    8,  8,  0,  2 }, {     16,    1,    8,  8,  0,  2 }, {     16,    2,    8,  8,  0,  2 }, {     16,    3,    8,  8,  0,  2 }, {     16,    4,    8,  8,  0,  2 },
    {     16,    5,    8,  8,  0,  2 }, {     16,    6,    8,  8,  0,  2 }, {     16,    7,    8,  8,  0,  2 }, {     16,    8,    7,  8,  5,  1 }, {     16,    9,    7,  8,  5,  1 },
    {     16,   10,    7,  8,  5,  1 }, {     16,   11,    7,  8,  5,  1 }, {     16,   12,    7,  8,  5,  1 }, {     16,   13,    7,  8,  5,  1 }, {     16,   14,    6,  8,  5,  1 },
    {     16,   15,    6,  8,  5,  1 }, {     16,   16,    6,  8,  5,  1 }, {     16,   17,    6,  8,  5,  1 }, {     16,   18,    5,  8,  5,  1 }, {     16,   19,    5,  8,  5,  1 },
    {     16,   20,    5,  8,  5,  1 }, {     16,   21,    4,  8,  5,  1 }, {     16,   22,    4,  8,  5,  1 }, {     16,   23,    4,  8,  5,  1 }, {     16,   24,    3,  8,  6,  0 },
    {     16,   25,    3,  8,  6,  0 }, {     16,   26,    2,  8,  6,  0 }, {     16,   27,    2,  8,  6,  0 }, {     16,   28,    1,  8,  6,  0 }, {     16,   29,    1,  8,  6,  0 },
    {     16,   30,    0,  8,  6,  0 }, {     16,   31,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6566, {
    {      0,   16,    8, 16,  0,  2 }, {      1,   16,    8, 16,  0,  2 }, {      2,   16,    8, 16,  0,  2 }, {      3,   16,    8, 16,  0,  2 }, {      4,   16,    8, 16,  0,  2 },
    {      5,   16,    8, 16,  0,  2 }, {      6,   16,    8, 16,  0,  2 }, {      7,   16,    8, 16,  0,  2 }, {      8,   16,    7, 16,  5,  1 }, {      9,   16,    7, 16,  5,  1 },
    {     10,   16,    7, 16,  5,  1 }, {     11,   16,    7, 16,  5,  1 }, {     12,   16,    7, 16,  5,  1 }, {     13,   16,    7, 16,  5,  1 }, {     14,   16,    6, 16,  5,  1 },
    {     15,   16,    6, 16,  5,  1 }, {     16,   16,    6, 16,  5,  1 }, {     17,   16,    6, 16,  5,  1 }, {     18,   16,    5, 16,  5,  1 }, {     19,   16,    5, 16,  5,  1 },
    {     20,   16,    5, 16,  5,  1 }, {     21,   16,    4, 16,  5,  1 }, {     22,   16,    4, 16,  5,  1 }, {     23,   16,    4, 16,  5,  1 }, {     24,   16,    3, 16,  6,  0 },
    {     25,   16,    3, 16,  6,  0 }, {     26,   16,    2, 16,  6,  0 }, {     27,   16,    2, 16,  6,  0 }, {     28,   16,    1, 16,  6,  0 }, {     29,   16,    1, 16,  6,  0 },
    {     30,   16,    0, 16,  6,  0 }, {     31,   16,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6688, {
    {     16,   31,    8, 24,  0,  2 }, {     16,   30,    8, 24,  0,  2 }, {     16,   29,    8, 24,  0,  2 }, {     16,   28,    8, 24,  0,  2 }, {     16,   27,    8, 24,  0,  2 },
    {     16,   26,    8, 24,  0,  2 }, {     16,   25,    8, 24,  0,  2 }, {     16,   24,    8, 24,  0,  2 }, {     16,   23,    7, 24,  5,  1 }, {     16,   22,    7, 24,  5,  1 },
    {     16,   21,    7, 24,  5,  1 }, {     16,   20,    7, 24,  5,  1 }, {     16,   19,    7, 24,  5,  1 }, {     16,   18,    7, 24,  5,  1 }, {     16,   17,    6, 24,  5,  1 },
    {     16,   16,    6, 24,  5,  1 }, {     16,   15,    6, 24,  5,  1 }, {     16,   14,    6, 24,  5,  1 }, {     16,   13,    5, 24,  5,  1 }, {     16,   12,    5, 24,  5,  1 },
    {     16,   11,    5, 24,  5,  1 }, {     16,   10,    4, 24,  5,  1 }, {     16,    9,    4, 24,  5,  1 }, {     16,    8,    4, 24,  5,  1 }, {     16,    7,    3, 24,  6,  0 },
    {     16,    6,    3, 24,  6,  0 }, {     16,    5,    2, 24,  6,  0 }, {     16,    4,    2, 24,  6,  0 }, {     16,    3,    1, 24,  6,  0 }, {     16,    2,    1, 24,  6,  0 },
    {     16,    1,    0, 24,  6,  0 }, {     16,    0,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C67AA, {
    {     31,   16,    8,  0,  0,  4 }, {     30,   16,    8,  0,  0,  4 }, {     29,   16,    8,  0,  0,  4 }, {     28,   16,    8,  0,  0,  4 }, {     27,   16,    8,  0,  0,  4 },
    {     26,   16,    8,  0,  0,  4 }, {     25,   16,    8,  0,  0,  4 }, {     24,   16,    8,  0,  0,  4 }, {     23,   16,    7,  0,  5,  3 }, {     22,   16,    7,  0,  5,  3 },
    {     21,   16,    7,  0,  5,  3 }, {     20,   16,    7,  0,  5,  3 }, {     19,   16,    7,  0,  5,  3 }, {     18,   16,    7,  0,  5,  3 }, {     17,   16,    6,  0,  5,  3 },
    {     16,   16,    6,  0,  5,  3 }, {     15,   16,    6,  0,  5,  3 }, {     14,   16,    6,  0,  5,  3 }, {     13,   16,    5,  0,  5,  3 }, {     12,   16,    5,  0,  5,  3 },
    {     11,   16,    5,  0,  5,  3 }, {     10,   16,    4,  0,  5,  3 }, {      9,   16,    4,  0,  5,  3 }, {      8,   16,    4,  0,  5,  3 }, {      7,   16,    3,  0,  6,  0 },
    {      6,   16,    3,  0,  6,  0 }, {      5,   16,    2,  0,  6,  0 }, {      4,   16,    2,  0,  6,  0 }, {      3,   16,    1,  0,  6,  0 }, {      2,   16,    1,  0,  6,  0 },
    {      1,   16,    0,  0,  6,  0 }, {      0,   16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C68CC, {
    {     16,    0,    8,  8,  0,  4 }, {     16,    1,    8,  8,  0,  4 }, {     16,    2,    8,  8,  0,  4 }, {     16,    3,    8,  8,  0,  4 }, {     16,    4,    8,  8,  0,  4 },
    {     16,    5,    8,  8,  0,  4 }, {     16,    6,    8,  8,  0,  4 }, {     16,    7,    8,  8,  0,  4 }, {     16,    8,    7,  8,  5,  3 }, {     16,    9,    7,  8,  5,  3 },
    {     16,   10,    7,  8,  5,  3 }, {     16,   11,    7,  8,  5,  3 }, {     16,   12,    7,  8,  5,  3 }, {     16,   13,    7,  8,  5,  3 }, {     16,   14,    6,  8,  5,  3 },
    {     16,   15,    6,  8,  5,  3 }, {     16,   16,    6,  8,  5,  3 }, {     16,   17,    6,  8,  5,  3 }, {     16,   18,    5,  8,  5,  3 }, {     16,   19,    5,  8,  5,  3 },
    {     16,   20,    5,  8,  5,  3 }, {     16,   21,    4,  8,  5,  3 }, {     16,   22,    4,  8,  5,  3 }, {     16,   23,    4,  8,  5,  3 }, {     16,   24,    3,  8,  6,  0 },
    {     16,   25,    3,  8,  6,  0 }, {     16,   26,    2,  8,  6,  0 }, {     16,   27,    2,  8,  6,  0 }, {     16,   28,    1,  8,  6,  0 }, {     16,   29,    1,  8,  6,  0 },
    {     16,   30,    0,  8,  6,  0 }, {     16,   31,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C69EE, {
    {      0,   16,    8, 16,  0,  4 }, {      1,   16,    8, 16,  0,  4 }, {      2,   16,    8, 16,  0,  4 }, {      3,   16,    8, 16,  0,  4 }, {      4,   16,    8, 16,  0,  4 },
    {      5,   16,    8, 16,  0,  4 }, {      6,   16,    8, 16,  0,  4 }, {      7,   16,    8, 16,  0,  4 }, {      8,   16,    7, 16,  5,  3 }, {      9,   16,    7, 16,  5,  3 },
    {     10,   16,    7, 16,  5,  3 }, {     11,   16,    7, 16,  5,  3 }, {     12,   16,    7, 16,  5,  3 }, {     13,   16,    7, 16,  5,  3 }, {     14,   16,    6, 16,  5,  3 },
    {     15,   16,    6, 16,  5,  3 }, {     16,   16,    6, 16,  5,  3 }, {     17,   16,    6, 16,  5,  3 }, {     18,   16,    5, 16,  5,  3 }, {     19,   16,    5, 16,  5,  3 },
    {     20,   16,    5, 16,  5,  3 }, {     21,   16,    4, 16,  5,  3 }, {     22,   16,    4, 16,  5,  3 }, {     23,   16,    4, 16,  5,  3 }, {     24,   16,    3, 16,  6,  0 },
    {     25,   16,    3, 16,  6,  0 }, {     26,   16,    2, 16,  6,  0 }, {     27,   16,    2, 16,  6,  0 }, {     28,   16,    1, 16,  6,  0 }, {     29,   16,    1, 16,  6,  0 },
    {     30,   16,    0, 16,  6,  0 }, {     31,   16,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6B10, {
    {     16,   31,    8, 24,  0,  4 }, {     16,   30,    8, 24,  0,  4 }, {     16,   29,    8, 24,  0,  4 }, {     16,   28,    8, 24,  0,  4 }, {     16,   27,    8, 24,  0,  4 },
    {     16,   26,    8, 24,  0,  4 }, {     16,   25,    8, 24,  0,  4 }, {     16,   24,    8, 24,  0,  4 }, {     16,   23,    7, 24,  5,  3 }, {     16,   22,    7, 24,  5,  3 },
    {     16,   21,    7, 24,  5,  3 }, {     16,   20,    7, 24,  5,  3 }, {     16,   19,    7, 24,  5,  3 }, {     16,   18,    7, 24,  5,  3 }, {     16,   17,    6, 24,  5,  3 },
    {     16,   16,    6, 24,  5,  3 }, {     16,   15,    6, 24,  5,  3 }, {     16,   14,    6, 24,  5,  3 }, {     16,   13,    5, 24,  5,  3 }, {     16,   12,    5, 24,  5,  3 },
    {     16,   11,    5, 24,  5,  3 }, {     16,   10,    4, 24,  5,  3 }, {     16,    9,    4, 24,  5,  3 }, {     16,    8,    4, 24,  5,  3 }, {     16,    7,    3, 24,  6,  0 },
    {     16,    6,    3, 24,  6,  0 }, {     16,    5,    2, 24,  6,  0 }, {     16,    4,    2, 24,  6,  0 }, {     16,    3,    1, 24,  6,  0 }, {     16,    2,    1, 24,  6,  0 },
    {     16,    1,    0, 24,  6,  0 }, {     16,    0,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5A12, {
    {     31,   16,    7,  0,  6,  0 }, {     30,   16,    7,  0,  6,  0 }, {     29,   16,    6,  0,  6,  0 }, {     28,   16,    6,  0,  6,  0 }, {     27,   16,    5,  0,  6,  0 },
    {     26,   16,    5,  0,  6,  0 }, {     25,   16,    4,  0,  6,  0 }, {     24,   16,    4,  0,  6,  0 }, {     23,   16,    4,  0,  5,  1 }, {     22,   16,    3,  0,  5,  1 },
    {     21,   16,    3,  0,  5,  1 }, {     20,   16,    3,  0,  5,  1 }, {     19,   16,    2,  0,  5,  1 }, {     18,   16,    2,  0,  5,  1 }, {     17,   16,    2,  0,  5,  1 },
    {     16,   16,    2,  0,  5,  1 }, {     15,   16,    1,  0,  5,  1 }, {     14,   16,    1,  0,  5,  1 }, {     13,   16,    1,  0,  5,  1 }, {     12,   16,    1,  0,  5,  1 },
    {     11,   16,    1,  0,  5,  1 }, {     10,   16,    1,  0,  5,  1 }, {      9,   16,    0,  0,  0,  2 }, {      8,   16,    0,  0,  0,  2 }, {      7,   16,    0,  0,  0,  2 },
    {      6,   16,    0,  0,  0,  2 }, {      5,   16,    0,  0,  0,  2 }, {      4,   16,    0,  0,  0,  2 }, {      3,   16,    0,  0,  0,  2 }, {      2,   16,    0,  0,  0,  2 },
    {      1,   16,    0,  0,  0,  2 }, {      0,   16,    0,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5B34, {
    {     16,    0,    7,  8,  6,  0 }, {     16,    1,    7,  8,  6,  0 }, {     16,    2,    6,  8,  6,  0 }, {     16,    3,    6,  8,  6,  0 }, {     16,    4,    5,  8,  6,  0 },
    {     16,    5,    5,  8,  6,  0 }, {     16,    6,    4,  8,  6,  0 }, {     16,    7,    4,  8,  6,  0 }, {     16,    8,    4,  8,  5,  1 }, {     16,    9,    3,  8,  5,  1 },
    {     16,   10,    3,  8,  5,  1 }, {     16,   11,    3,  8,  5,  1 }, {     16,   12,    2,  8,  5,  1 }, {     16,   13,    2,  8,  5,  1 }, {     16,   14,    2,  8,  5,  1 },
    {     16,   15,    2,  8,  5,  1 }, {     16,   16,    1,  8,  5,  1 }, {     16,   17,    1,  8,  5,  1 }, {     16,   18,    1,  8,  5,  1 }, {     16,   19,    1,  8,  5,  1 },
    {     16,   20,    1,  8,  5,  1 }, {     16,   21,    1,  8,  5,  1 }, {     16,   22,    0,  8,  0,  2 }, {     16,   23,    0,  8,  0,  2 }, {     16,   24,    0,  8,  0,  2 },
    {     16,   25,    0,  8,  0,  2 }, {     16,   26,    0,  8,  0,  2 }, {     16,   27,    0,  8,  0,  2 }, {     16,   28,    0,  8,  0,  2 }, {     16,   29,    0,  8,  0,  2 },
    {     16,   30,    0,  8,  0,  2 }, {     16,   31,    0,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5C56, {
    {      0,   16,    7, 16,  6,  0 }, {      1,   16,    7, 16,  6,  0 }, {      2,   16,    6, 16,  6,  0 }, {      3,   16,    6, 16,  6,  0 }, {      4,   16,    5, 16,  6,  0 },
    {      5,   16,    5, 16,  6,  0 }, {      6,   16,    4, 16,  6,  0 }, {      7,   16,    4, 16,  6,  0 }, {      8,   16,    4, 16,  5,  1 }, {      9,   16,    3, 16,  5,  1 },
    {     10,   16,    3, 16,  5,  1 }, {     11,   16,    3, 16,  5,  1 }, {     12,   16,    2, 16,  5,  1 }, {     13,   16,    2, 16,  5,  1 }, {     14,   16,    2, 16,  5,  1 },
    {     15,   16,    2, 16,  5,  1 }, {     16,   16,    1, 16,  5,  1 }, {     17,   16,    1, 16,  5,  1 }, {     18,   16,    1, 16,  5,  1 }, {     19,   16,    1, 16,  5,  1 },
    {     20,   16,    1, 16,  5,  1 }, {     21,   16,    1, 16,  5,  1 }, {     22,   16,    0, 16,  0,  2 }, {     23,   16,    0, 16,  0,  2 }, {     24,   16,    0, 16,  0,  2 },
    {     25,   16,    0, 16,  0,  2 }, {     26,   16,    0, 16,  0,  2 }, {     27,   16,    0, 16,  0,  2 }, {     28,   16,    0, 16,  0,  2 }, {     29,   16,    0, 16,  0,  2 },
    {     30,   16,    0, 16,  0,  2 }, {     31,   16,    0, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5D78, {
    {     16,   31,    7, 24,  6,  0 }, {     16,   30,    7, 24,  6,  0 }, {     16,   29,    6, 24,  6,  0 }, {     16,   28,    6, 24,  6,  0 }, {     16,   27,    5, 24,  6,  0 },
    {     16,   26,    5, 24,  6,  0 }, {     16,   25,    4, 24,  6,  0 }, {     16,   24,    4, 24,  6,  0 }, {     16,   23,    4, 24,  5,  1 }, {     16,   22,    3, 24,  5,  1 },
    {     16,   21,    3, 24,  5,  1 }, {     16,   20,    3, 24,  5,  1 }, {     16,   19,    2, 24,  5,  1 }, {     16,   18,    2, 24,  5,  1 }, {     16,   17,    2, 24,  5,  1 },
    {     16,   16,    2, 24,  5,  1 }, {     16,   15,    1, 24,  5,  1 }, {     16,   14,    1, 24,  5,  1 }, {     16,   13,    1, 24,  5,  1 }, {     16,   12,    1, 24,  5,  1 },
    {     16,   11,    1, 24,  5,  1 }, {     16,   10,    1, 24,  5,  1 }, {     16,    9,    0, 24,  0,  2 }, {     16,    8,    0, 24,  0,  2 }, {     16,    7,    0, 24,  0,  2 },
    {     16,    6,    0, 24,  0,  2 }, {     16,    5,    0, 24,  0,  2 }, {     16,    4,    0, 24,  0,  2 }, {     16,    3,    0, 24,  0,  2 }, {     16,    2,    0, 24,  0,  2 },
    {     16,    1,    0, 24,  0,  2 }, {     16,    0,    0, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5E9A, {
    {     31,   16,    7,  0,  6,  0 }, {     30,   16,    7,  0,  6,  0 }, {     29,   16,    6,  0,  6,  0 }, {     28,   16,    6,  0,  6,  0 }, {     27,   16,    5,  0,  6,  0 },
    {     26,   16,    5,  0,  6,  0 }, {     25,   16,    4,  0,  6,  0 }, {     24,   16,    4,  0,  6,  0 }, {     23,   16,    4,  0,  5,  3 }, {     22,   16,    3,  0,  5,  3 },
    {     21,   16,    3,  0,  5,  3 }, {     20,   16,    3,  0,  5,  3 }, {     19,   16,    2,  0,  5,  3 }, {     18,   16,    2,  0,  5,  3 }, {     17,   16,    2,  0,  5,  3 },
    {     16,   16,    2,  0,  5,  3 }, {     15,   16,    1,  0,  5,  3 }, {     14,   16,    1,  0,  5,  3 }, {     13,   16,    1,  0,  5,  3 }, {     12,   16,    1,  0,  5,  3 },
    {     11,   16,    1,  0,  5,  3 }, {     10,   16,    1,  0,  5,  3 }, {      9,   16,    0,  0,  0,  4 }, {      8,   16,    0,  0,  0,  4 }, {      7,   16,    0,  0,  0,  4 },
    {      6,   16,    0,  0,  0,  4 }, {      5,   16,    0,  0,  0,  4 }, {      4,   16,    0,  0,  0,  4 }, {      3,   16,    0,  0,  0,  4 }, {      2,   16,    0,  0,  0,  4 },
    {      1,   16,    0,  0,  0,  4 }, {      0,   16,    0,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C5FBC, {
    {     16,    0,    7,  8,  6,  0 }, {     16,    1,    7,  8,  6,  0 }, {     16,    2,    6,  8,  6,  0 }, {     16,    3,    6,  8,  6,  0 }, {     16,    4,    5,  8,  6,  0 },
    {     16,    5,    5,  8,  6,  0 }, {     16,    6,    4,  8,  6,  0 }, {     16,    7,    4,  8,  6,  0 }, {     16,    8,    4,  8,  5,  3 }, {     16,    9,    3,  8,  5,  3 },
    {     16,   10,    3,  8,  5,  3 }, {     16,   11,    3,  8,  5,  3 }, {     16,   12,    2,  8,  5,  3 }, {     16,   13,    2,  8,  5,  3 }, {     16,   14,    2,  8,  5,  3 },
    {     16,   15,    2,  8,  5,  3 }, {     16,   16,    1,  8,  5,  3 }, {     16,   17,    1,  8,  5,  3 }, {     16,   18,    1,  8,  5,  3 }, {     16,   19,    1,  8,  5,  3 },
    {     16,   20,    1,  8,  5,  3 }, {     16,   21,    1,  8,  5,  3 }, {     16,   22,    0,  8,  0,  4 }, {     16,   23,    0,  8,  0,  4 }, {     16,   24,    0,  8,  0,  4 },
    {     16,   25,    0,  8,  0,  4 }, {     16,   26,    0,  8,  0,  4 }, {     16,   27,    0,  8,  0,  4 }, {     16,   28,    0,  8,  0,  4 }, {     16,   29,    0,  8,  0,  4 },
    {     16,   30,    0,  8,  0,  4 }, {     16,   31,    0,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C60DE, {
    {      0,   16,    7, 16,  6,  0 }, {      1,   16,    7, 16,  6,  0 }, {      2,   16,    6, 16,  6,  0 }, {      3,   16,    6, 16,  6,  0 }, {      4,   16,    5, 16,  6,  0 },
    {      5,   16,    5, 16,  6,  0 }, {      6,   16,    4, 16,  6,  0 }, {      7,   16,    4, 16,  6,  0 }, {      8,   16,    4, 16,  5,  3 }, {      9,   16,    3, 16,  5,  3 },
    {     10,   16,    3, 16,  5,  3 }, {     11,   16,    3, 16,  5,  3 }, {     12,   16,    2, 16,  5,  3 }, {     13,   16,    2, 16,  5,  3 }, {     14,   16,    2, 16,  5,  3 },
    {     15,   16,    2, 16,  5,  3 }, {     16,   16,    1, 16,  5,  3 }, {     17,   16,    1, 16,  5,  3 }, {     18,   16,    1, 16,  5,  3 }, {     19,   16,    1, 16,  5,  3 },
    {     20,   16,    1, 16,  5,  3 }, {     21,   16,    1, 16,  5,  3 }, {     22,   16,    0, 16,  0,  4 }, {     23,   16,    0, 16,  0,  4 }, {     24,   16,    0, 16,  0,  4 },
    {     25,   16,    0, 16,  0,  4 }, {     26,   16,    0, 16,  0,  4 }, {     27,   16,    0, 16,  0,  4 }, {     28,   16,    0, 16,  0,  4 }, {     29,   16,    0, 16,  0,  4 },
    {     30,   16,    0, 16,  0,  4 }, {     31,   16,    0, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6200, {
    {     16,   31,    7, 24,  6,  0 }, {     16,   30,    7, 24,  6,  0 }, {     16,   29,    6, 24,  6,  0 }, {     16,   28,    6, 24,  6,  0 }, {     16,   27,    5, 24,  6,  0 },
    {     16,   26,    5, 24,  6,  0 }, {     16,   25,    4, 24,  6,  0 }, {     16,   24,    4, 24,  6,  0 }, {     16,   23,    4, 24,  5,  3 }, {     16,   22,    3, 24,  5,  3 },
    {     16,   21,    3, 24,  5,  3 }, {     16,   20,    3, 24,  5,  3 }, {     16,   19,    2, 24,  5,  3 }, {     16,   18,    2, 24,  5,  3 }, {     16,   17,    2, 24,  5,  3 },
    {     16,   16,    2, 24,  5,  3 }, {     16,   15,    1, 24,  5,  3 }, {     16,   14,    1, 24,  5,  3 }, {     16,   13,    1, 24,  5,  3 }, {     16,   12,    1, 24,  5,  3 },
    {     16,   11,    1, 24,  5,  3 }, {     16,   10,    1, 24,  5,  3 }, {     16,    9,    0, 24,  0,  4 }, {     16,    8,    0, 24,  0,  4 }, {     16,    7,    0, 24,  0,  4 },
    {     16,    6,    0, 24,  0,  4 }, {     16,    5,    0, 24,  0,  4 }, {     16,    4,    0, 24,  0,  4 }, {     16,    3,    0, 24,  0,  4 }, {     16,    2,    0, 24,  0,  4 },
    {     16,    1,    0, 24,  0,  4 }, {     16,    0,    0, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEA02, {
    {     31,   16,    0,  0,  0,  2 }, {     30,   16,    0,  0,  0,  2 }, {     29,   16,    0,  0,  0,  2 }, {     28,   16,    0,  0,  0,  2 }, {     27,   16,    0,  0,  0,  2 },
    {     26,   16,    0,  0,  0,  2 }, {     25,   16,    0,  0,  0,  2 }, {     24,   16,    0,  0,  0,  2 }, {     23,   16,    0,  0,  0,  2 }, {     22,   16,    0,  0,  0,  2 },
    {     21,   16,    0,  0,  0,  2 }, {     20,   16,    0,  0,  0,  2 }, {     19,   16,    0,  0,  0,  2 }, {     18,   16,    0,  0,  0,  2 }, {     17,   16,    0,  0,  0,  2 },
    {     16,   16,    0,  0,  0,  2 }, {     15,   16,    0,  0,  0,  2 }, {     14,   16,    0,  0,  0,  2 }, {     13,   16,    0,  0,  0,  2 }, {     12,   16,    0,  0,  0,  2 },
    {     11,   16,    0,  0,  0,  2 }, {     10,   16,    0,  0,  0,  2 }, {      9,   16,    0,  0,  0,  2 }, {      8,   16,    0,  0,  0,  2 }, {      7,   16,    0,  0,  0,  2 },
    {      6,   16,    0,  0,  0,  2 }, {      5,   16,    0,  0,  0,  2 }, {      4,   16,    0,  0,  0,  2 }, {      3,   16,    0,  0,  0,  2 }, {      2,   16,    0,  0,  0,  2 },
    {      1,   16,    0,  0,  0,  2 }, {      0,   16,    0,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEB24, {
    {     16,    0,    0,  8,  0,  2 }, {     16,    1,    0,  8,  0,  2 }, {     16,    2,    0,  8,  0,  2 }, {     16,    3,    0,  8,  0,  2 }, {     16,    4,    0,  8,  0,  2 },
    {     16,    5,    0,  8,  0,  2 }, {     16,    6,    0,  8,  0,  2 }, {     16,    7,    0,  8,  0,  2 }, {     16,    8,    0,  8,  0,  2 }, {     16,    9,    0,  8,  0,  2 },
    {     16,   10,    0,  8,  0,  2 }, {     16,   11,    0,  8,  0,  2 }, {     16,   12,    0,  8,  0,  2 }, {     16,   13,    0,  8,  0,  2 }, {     16,   14,    0,  8,  0,  2 },
    {     16,   15,    0,  8,  0,  2 }, {     16,   16,    0,  8,  0,  2 }, {     16,   17,    0,  8,  0,  2 }, {     16,   18,    0,  8,  0,  2 }, {     16,   19,    0,  8,  0,  2 },
    {     16,   20,    0,  8,  0,  2 }, {     16,   21,    0,  8,  0,  2 }, {     16,   22,    0,  8,  0,  2 }, {     16,   23,    0,  8,  0,  2 }, {     16,   24,    0,  8,  0,  2 },
    {     16,   25,    0,  8,  0,  2 }, {     16,   26,    0,  8,  0,  2 }, {     16,   27,    0,  8,  0,  2 }, {     16,   28,    0,  8,  0,  2 }, {     16,   29,    0,  8,  0,  2 },
    {     16,   30,    0,  8,  0,  2 }, {     16,   31,    0,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEC46, {
    {      0,   16,    0, 16,  0,  2 }, {      1,   16,    0, 16,  0,  2 }, {      2,   16,    0, 16,  0,  2 }, {      3,   16,    0, 16,  0,  2 }, {      4,   16,    0, 16,  0,  2 },
    {      5,   16,    0, 16,  0,  2 }, {      6,   16,    0, 16,  0,  2 }, {      7,   16,    0, 16,  0,  2 }, {      8,   16,    0, 16,  0,  2 }, {      9,   16,    0, 16,  0,  2 },
    {     10,   16,    0, 16,  0,  2 }, {     11,   16,    0, 16,  0,  2 }, {     12,   16,    0, 16,  0,  2 }, {     13,   16,    0, 16,  0,  2 }, {     14,   16,    0, 16,  0,  2 },
    {     15,   16,    0, 16,  0,  2 }, {     16,   16,    0, 16,  0,  2 }, {     17,   16,    0, 16,  0,  2 }, {     18,   16,    0, 16,  0,  2 }, {     19,   16,    0, 16,  0,  2 },
    {     20,   16,    0, 16,  0,  2 }, {     21,   16,    0, 16,  0,  2 }, {     22,   16,    0, 16,  0,  2 }, {     23,   16,    0, 16,  0,  2 }, {     24,   16,    0, 16,  0,  2 },
    {     25,   16,    0, 16,  0,  2 }, {     26,   16,    0, 16,  0,  2 }, {     27,   16,    0, 16,  0,  2 }, {     28,   16,    0, 16,  0,  2 }, {     29,   16,    0, 16,  0,  2 },
    {     30,   16,    0, 16,  0,  2 }, {     31,   16,    0, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BED68, {
    {     16,   31,    0, 24,  0,  2 }, {     16,   30,    0, 24,  0,  2 }, {     16,   29,    0, 24,  0,  2 }, {     16,   28,    0, 24,  0,  2 }, {     16,   27,    0, 24,  0,  2 },
    {     16,   26,    0, 24,  0,  2 }, {     16,   25,    0, 24,  0,  2 }, {     16,   24,    0, 24,  0,  2 }, {     16,   23,    0, 24,  0,  2 }, {     16,   22,    0, 24,  0,  2 },
    {     16,   21,    0, 24,  0,  2 }, {     16,   20,    0, 24,  0,  2 }, {     16,   19,    0, 24,  0,  2 }, {     16,   18,    0, 24,  0,  2 }, {     16,   17,    0, 24,  0,  2 },
    {     16,   16,    0, 24,  0,  2 }, {     16,   15,    0, 24,  0,  2 }, {     16,   14,    0, 24,  0,  2 }, {     16,   13,    0, 24,  0,  2 }, {     16,   12,    0, 24,  0,  2 },
    {     16,   11,    0, 24,  0,  2 }, {     16,   10,    0, 24,  0,  2 }, {     16,    9,    0, 24,  0,  2 }, {     16,    8,    0, 24,  0,  2 }, {     16,    7,    0, 24,  0,  2 },
    {     16,    6,    0, 24,  0,  2 }, {     16,    5,    0, 24,  0,  2 }, {     16,    4,    0, 24,  0,  2 }, {     16,    3,    0, 24,  0,  2 }, {     16,    2,    0, 24,  0,  2 },
    {     16,    1,    0, 24,  0,  2 }, {     16,    0,    0, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEE8A, {
    {     31,   16,    0,  0,  0,  4 }, {     30,   16,    0,  0,  0,  4 }, {     29,   16,    0,  0,  0,  4 }, {     28,   16,    0,  0,  0,  4 }, {     27,   16,    0,  0,  0,  4 },
    {     26,   16,    0,  0,  0,  4 }, {     25,   16,    0,  0,  0,  4 }, {     24,   16,    0,  0,  0,  4 }, {     23,   16,    0,  0,  0,  4 }, {     22,   16,    0,  0,  0,  4 },
    {     21,   16,    0,  0,  0,  4 }, {     20,   16,    0,  0,  0,  4 }, {     19,   16,    0,  0,  0,  4 }, {     18,   16,    0,  0,  0,  4 }, {     17,   16,    0,  0,  0,  4 },
    {     16,   16,    0,  0,  0,  4 }, {     15,   16,    0,  0,  0,  4 }, {     14,   16,    0,  0,  0,  4 }, {     13,   16,    0,  0,  0,  4 }, {     12,   16,    0,  0,  0,  4 },
    {     11,   16,    0,  0,  0,  4 }, {     10,   16,    0,  0,  0,  4 }, {      9,   16,    0,  0,  0,  4 }, {      8,   16,    0,  0,  0,  4 }, {      7,   16,    0,  0,  0,  4 },
    {      6,   16,    0,  0,  0,  4 }, {      5,   16,    0,  0,  0,  4 }, {      4,   16,    0,  0,  0,  4 }, {      3,   16,    0,  0,  0,  4 }, {      2,   16,    0,  0,  0,  4 },
    {      1,   16,    0,  0,  0,  4 }, {      0,   16,    0,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BEFAC, {
    {     16,    0,    0,  8,  0,  4 }, {     16,    1,    0,  8,  0,  4 }, {     16,    2,    0,  8,  0,  4 }, {     16,    3,    0,  8,  0,  4 }, {     16,    4,    0,  8,  0,  4 },
    {     16,    5,    0,  8,  0,  4 }, {     16,    6,    0,  8,  0,  4 }, {     16,    7,    0,  8,  0,  4 }, {     16,    8,    0,  8,  0,  4 }, {     16,    9,    0,  8,  0,  4 },
    {     16,   10,    0,  8,  0,  4 }, {     16,   11,    0,  8,  0,  4 }, {     16,   12,    0,  8,  0,  4 }, {     16,   13,    0,  8,  0,  4 }, {     16,   14,    0,  8,  0,  4 },
    {     16,   15,    0,  8,  0,  4 }, {     16,   16,    0,  8,  0,  4 }, {     16,   17,    0,  8,  0,  4 }, {     16,   18,    0,  8,  0,  4 }, {     16,   19,    0,  8,  0,  4 },
    {     16,   20,    0,  8,  0,  4 }, {     16,   21,    0,  8,  0,  4 }, {     16,   22,    0,  8,  0,  4 }, {     16,   23,    0,  8,  0,  4 }, {     16,   24,    0,  8,  0,  4 },
    {     16,   25,    0,  8,  0,  4 }, {     16,   26,    0,  8,  0,  4 }, {     16,   27,    0,  8,  0,  4 }, {     16,   28,    0,  8,  0,  4 }, {     16,   29,    0,  8,  0,  4 },
    {     16,   30,    0,  8,  0,  4 }, {     16,   31,    0,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF0CE, {
    {      0,   16,    0, 16,  0,  4 }, {      1,   16,    0, 16,  0,  4 }, {      2,   16,    0, 16,  0,  4 }, {      3,   16,    0, 16,  0,  4 }, {      4,   16,    0, 16,  0,  4 },
    {      5,   16,    0, 16,  0,  4 }, {      6,   16,    0, 16,  0,  4 }, {      7,   16,    0, 16,  0,  4 }, {      8,   16,    0, 16,  0,  4 }, {      9,   16,    0, 16,  0,  4 },
    {     10,   16,    0, 16,  0,  4 }, {     11,   16,    0, 16,  0,  4 }, {     12,   16,    0, 16,  0,  4 }, {     13,   16,    0, 16,  0,  4 }, {     14,   16,    0, 16,  0,  4 },
    {     15,   16,    0, 16,  0,  4 }, {     16,   16,    0, 16,  0,  4 }, {     17,   16,    0, 16,  0,  4 }, {     18,   16,    0, 16,  0,  4 }, {     19,   16,    0, 16,  0,  4 },
    {     20,   16,    0, 16,  0,  4 }, {     21,   16,    0, 16,  0,  4 }, {     22,   16,    0, 16,  0,  4 }, {     23,   16,    0, 16,  0,  4 }, {     24,   16,    0, 16,  0,  4 },
    {     25,   16,    0, 16,  0,  4 }, {     26,   16,    0, 16,  0,  4 }, {     27,   16,    0, 16,  0,  4 }, {     28,   16,    0, 16,  0,  4 }, {     29,   16,    0, 16,  0,  4 },
    {     30,   16,    0, 16,  0,  4 }, {     31,   16,    0, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8BF1F0, {
    {     16,   31,    0, 24,  0,  4 }, {     16,   30,    0, 24,  0,  4 }, {     16,   29,    0, 24,  0,  4 }, {     16,   28,    0, 24,  0,  4 }, {     16,   27,    0, 24,  0,  4 },
    {     16,   26,    0, 24,  0,  4 }, {     16,   25,    0, 24,  0,  4 }, {     16,   24,    0, 24,  0,  4 }, {     16,   23,    0, 24,  0,  4 }, {     16,   22,    0, 24,  0,  4 },
    {     16,   21,    0, 24,  0,  4 }, {     16,   20,    0, 24,  0,  4 }, {     16,   19,    0, 24,  0,  4 }, {     16,   18,    0, 24,  0,  4 }, {     16,   17,    0, 24,  0,  4 },
    {     16,   16,    0, 24,  0,  4 }, {     16,   15,    0, 24,  0,  4 }, {     16,   14,    0, 24,  0,  4 }, {     16,   13,    0, 24,  0,  4 }, {     16,   12,    0, 24,  0,  4 },
    {     16,   11,    0, 24,  0,  4 }, {     16,   10,    0, 24,  0,  4 }, {     16,    9,    0, 24,  0,  4 }, {     16,    8,    0, 24,  0,  4 }, {     16,    7,    0, 24,  0,  4 },
    {     16,    6,    0, 24,  0,  4 }, {     16,    5,    0, 24,  0,  4 }, {     16,    4,    0, 24,  0,  4 }, {     16,    3,    0, 24,  0,  4 }, {     16,    2,    0, 24,  0,  4 },
    {     16,    1,    0, 24,  0,  4 }, {     16,    0,    0, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D047E, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3, 31,  2,  0 }, {     23,   15,    4, 31,  2,  0 }, {     22,   15,    4, 31,  2,  0 },
    {     21,   15,    5, 31,  2,  0 }, {     20,   15,    5, 31,  2,  0 }, {     19,   15,    6, 31,  2,  0 }, {     18,   15,    6, 31,  2,  0 }, {     17,   14,    7, 31,  2,  0 },
    {     16,   14,    8, 31,  2,  0 }, {     15,   14,    8, 31,  2,  0 }, {     14,   14,    8, 31,  2,  0 }, {     13,   14,    9, 31,  2,  0 }, {     12,   13,    9, 31,  2,  0 },
    {     11,   13,   10, 31,  2,  0 }, {     10,   13,   11, 30,  2,  0 }, {      9,   13,   11, 30,  2,  0 }, {      8,   12,   12, 30,  2,  0 }, {      7,   12,   12, 30,  2,  0 },
    {      6,   12,   13, 30,  2,  0 }, {      5,   11,   13, 30,  2,  0 }, {      4,   11,   14, 30,  2,  0 }, {      3,   11,   14, 30,  2,  0 }, {      2,   10,   15, 30,  2,  0 },
    {      1,   10,   15, 30,  2,  0 }, {      0,    9,   16, 30,  2,  0 }, {     -1,    9,   17, 30,  2,  0 }, {     -2,    8,   17, 30,  2,  0 }, {     -3,    8,   18, 30,  2,  0 },
    {     -4,    7,   18, 30,  2,  0 }, {     -5,    7,   19, 29,  2,  0 }, {     -6,    6,   19, 29,  2,  0 }, {     -7,    6,   20, 29,  2,  0 }, {     -8,    5,   21, 29,  2,  0 },
    {     -9,    4,   21, 29,  2,  0 }, {    -10,    4,   22, 29,  2,  0 }, {    -11,    3,   22, 29,  2,  0 }, {    -12,    2,   23, 29,  2,  0 }, {    -13,    2,   24, 29,  2,  0 },
    {    -14,    1,   24, 29,  2,  0 }, {    -15,    0,   25, 29,  2,  0 }, {    -16,    0,   26, 29,  2,  0 }, {    -17,   -1,   26, 29,  2,  0 }, {    -18,   -2,   27, 28,  2,  0 },
    {    -19,   -3,   27, 28,  2,  0 }, {    -20,   -3,   28, 28,  2,  0 }, {    -21,   -4,   29, 28,  2,  0 }, {    -22,   -5,   29, 28,  2,  0 }, {    -23,   -6,   30, 28,  2,  0 },
    {    -24,   -7,   31, 28,  2,  0 }, {    -25,   -7,   31, 28,  2,  0 }, {    -26,   -8,   32, 28,  2,  0 }, {    -27,   -9,   32, 28,  2,  0 }, {    -28,  -10,   33, 28,  2,  0 },
    {    -29,  -11,   34, 28,  2,  0 }, {    -29,  -12,   34, 28,  2,  0 }, {    -30,  -13,   35, 27,  2,  0 }, {    -31,  -14,   36, 27,  2,  0 }, {    -32,  -15,   36, 27,  2,  0 },
    {    -32,  -16,   37, 27,  2,  0 }, {    -33,  -17,   37, 27,  2,  0 }, {    -34,  -18,   38, 27,  2,  0 }, {    -34,  -19,   39, 27,  2,  0 }, {    -35,  -20,   39, 27,  2,  0 },
    {    -36,  -21,   40, 27,  2,  0 }, {    -36,  -22,   41, 27,  2,  0 }, {    -37,  -23,   41, 27,  2,  0 }, {    -38,  -24,   42, 27,  2,  0 }, {    -38,  -25,   42, 27,  2,  0 },
    {    -39,  -26,   43, 26,  2,  0 }, {    -39,  -27,   44, 26,  2,  0 }, {    -40,  -28,   44, 26,  2,  0 }, {    -40,  -29,   45, 26,  2,  0 }, {    -41,  -30,   45, 26,  2,  0 },
    {    -41,  -31,   46, 26,  2,  0 }, {    -42,  -32,   46, 26,  2,  0 }, {    -42,  -33,   47, 26,  2,  0 }, {    -43,  -34,   48, 26,  2,  0 }, {    -43,  -35,   48, 26,  2,  0 },
    {    -43,  -36,   49, 26,  2,  0 }, {    -44,  -37,   49, 26,  2,  0 }, {    -44,  -38,   50, 26,  2,  0 }, {    -44,  -39,   50, 26,  2,  0 }, {    -45,  -40,   51, 25,  2,  0 },
    {    -45,  -41,   51, 25,  2,  0 }, {    -45,  -42,   52, 25,  2,  0 }, {    -45,  -43,   52, 25,  2,  0 }, {    -46,  -44,   53, 25,  2,  0 }, {    -46,  -45,   54, 25,  2,  0 },
    {    -46,  -46,   54, 25,  2,  0 }, {    -46,  -47,   55, 25,  2,  0 }, {    -46,  -48,   55, 25,  2,  0 }, {    -47,  -49,   55, 25,  2,  0 }, {    -47,  -50,   56, 25,  2,  0 },
    {    -47,  -51,   57, 25,  2,  0 }, {    -47,  -52,   57, 25,  2,  0 }, {    -47,  -53,   58, 25,  2,  0 }, {    -47,  -54,   58, 25,  2,  0 }, {    -48,  -55,   59, 25,  2,  0 },
    {    -48,  -56,   59, 24,  2,  0 }, {    -48,  -57,   60, 24,  2,  0 }, {    -48,  -58,   60, 24,  2,  0 }, {    -48,  -59,   61, 24,  2,  0 }, {    -48,  -60,   61, 24,  2,  0 },
    {    -48,  -61,   62, 24,  2,  0 }, {    -48,  -62,   62, 24,  2,  0 }, {    -48,  -63,   63, 24,  2,  0 }, {    -48,  -64,   64, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D0882, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    0,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    1,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    2,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    3,  7,  2,  0 }, {     15,    9,    4,  7,  2,  0 },
    {     15,   10,    4,  7,  2,  0 }, {     15,   11,    5,  7,  2,  0 }, {     15,   12,    5,  7,  2,  0 }, {     15,   13,    6,  7,  2,  0 }, {     15,   14,    6,  7,  2,  0 },
    {     14,   15,    7,  7,  2,  0 }, {     14,   16,    8,  7,  2,  0 }, {     14,   17,    8,  7,  2,  0 }, {     14,   18,    8,  7,  2,  0 }, {     14,   19,    9,  7,  2,  0 },
    {     13,   20,    9,  7,  2,  0 }, {     13,   21,   10,  7,  2,  0 }, {     13,   22,   11,  6,  2,  0 }, {     13,   23,   11,  6,  2,  0 }, {     12,   24,   12,  6,  2,  0 },
    {     12,   25,   12,  6,  2,  0 }, {     12,   26,   13,  6,  2,  0 }, {     11,   27,   13,  6,  2,  0 }, {     11,   28,   14,  6,  2,  0 }, {     11,   29,   14,  6,  2,  0 },
    {     10,   30,   15,  6,  2,  0 }, {     10,   31,   15,  6,  2,  0 }, {      9,   32,   16,  6,  2,  0 }, {      9,   33,   17,  6,  2,  0 }, {      8,   34,   17,  6,  2,  0 },
    {      8,   35,   18,  6,  2,  0 }, {      7,   36,   18,  6,  2,  0 }, {      7,   37,   19,  5,  2,  0 }, {      6,   38,   19,  5,  2,  0 }, {      6,   39,   20,  5,  2,  0 },
    {      5,   40,   21,  5,  2,  0 }, {      4,   41,   21,  5,  2,  0 }, {      4,   42,   22,  5,  2,  0 }, {      3,   43,   22,  5,  2,  0 }, {      2,   44,   23,  5,  2,  0 },
    {      2,   45,   24,  5,  2,  0 }, {      1,   46,   24,  5,  2,  0 }, {      0,   47,   25,  5,  2,  0 }, {      0,   48,   26,  5,  2,  0 }, {     -1,   49,   26,  5,  2,  0 },
    {     -2,   50,   27,  4,  2,  0 }, {     -3,   51,   27,  4,  2,  0 }, {     -3,   52,   28,  4,  2,  0 }, {     -4,   53,   29,  4,  2,  0 }, {     -5,   54,   29,  4,  2,  0 },
    {     -6,   55,   30,  4,  2,  0 }, {     -7,   56,   31,  4,  2,  0 }, {     -7,   57,   31,  4,  2,  0 }, {     -8,   58,   32,  4,  2,  0 }, {     -9,   59,   32,  4,  2,  0 },
    {    -10,   60,   33,  4,  2,  0 }, {    -11,   61,   34,  4,  2,  0 }, {    -12,   61,   34,  4,  2,  0 }, {    -13,   62,   35,  3,  2,  0 }, {    -14,   63,   36,  3,  2,  0 },
    {    -15,   64,   36,  3,  2,  0 }, {    -16,   64,   37,  3,  2,  0 }, {    -17,   65,   37,  3,  2,  0 }, {    -18,   66,   38,  3,  2,  0 }, {    -19,   66,   39,  3,  2,  0 },
    {    -20,   67,   39,  3,  2,  0 }, {    -21,   68,   40,  3,  2,  0 }, {    -22,   68,   41,  3,  2,  0 }, {    -23,   69,   41,  3,  2,  0 }, {    -24,   70,   42,  3,  2,  0 },
    {    -25,   70,   42,  3,  2,  0 }, {    -26,   71,   43,  2,  2,  0 }, {    -27,   71,   44,  2,  2,  0 }, {    -28,   72,   44,  2,  2,  0 }, {    -29,   72,   45,  2,  2,  0 },
    {    -30,   73,   45,  2,  2,  0 }, {    -31,   73,   46,  2,  2,  0 }, {    -32,   74,   46,  2,  2,  0 }, {    -33,   74,   47,  2,  2,  0 }, {    -34,   75,   48,  2,  2,  0 },
    {    -35,   75,   48,  2,  2,  0 }, {    -36,   75,   49,  2,  2,  0 }, {    -37,   76,   49,  2,  2,  0 }, {    -38,   76,   50,  2,  2,  0 }, {    -39,   76,   50,  2,  2,  0 },
    {    -40,   77,   51,  1,  2,  0 }, {    -41,   77,   51,  1,  2,  0 }, {    -42,   77,   52,  1,  2,  0 }, {    -43,   77,   52,  1,  2,  0 }, {    -44,   78,   53,  1,  2,  0 },
    {    -45,   78,   54,  1,  2,  0 }, {    -46,   78,   54,  1,  2,  0 }, {    -47,   78,   55,  1,  2,  0 }, {    -48,   78,   55,  1,  2,  0 }, {    -49,   79,   55,  1,  2,  0 },
    {    -50,   79,   56,  1,  2,  0 }, {    -51,   79,   57,  1,  2,  0 }, {    -52,   79,   57,  1,  2,  0 }, {    -53,   79,   58,  1,  2,  0 }, {    -54,   79,   58,  1,  2,  0 },
    {    -55,   80,   59,  1,  2,  0 }, {    -56,   80,   59,  0,  2,  0 }, {    -57,   80,   60,  0,  2,  0 }, {    -58,   80,   60,  0,  2,  0 }, {    -59,   80,   61,  0,  2,  0 },
    {    -60,   80,   61,  0,  2,  0 }, {    -61,   80,   62,  0,  2,  0 }, {    -62,   80,   62,  0,  2,  0 }, {    -63,   80,   63,  0,  2,  0 }, {    -64,   80,   64,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D0C8F, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    0, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    1, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    2, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    3, 15,  2,  0 }, {      9,   17,    4, 15,  2,  0 },
    {     10,   17,    5, 15,  2,  0 }, {     11,   17,    5, 15,  2,  0 }, {     12,   17,    5, 15,  2,  0 }, {     13,   17,    6, 15,  2,  0 }, {     14,   17,    6, 15,  2,  0 },
    {     15,   18,    7, 15,  2,  0 }, {     16,   18,    8, 15,  2,  0 }, {     17,   18,    8, 15,  2,  0 }, {     18,   18,    9, 15,  2,  0 }, {     19,   18,    9, 15,  2,  0 },
    {     20,   19,   10, 15,  2,  0 }, {     21,   19,   10, 15,  2,  0 }, {     22,   19,   11, 14,  2,  0 }, {     23,   19,   11, 14,  2,  0 }, {     24,   20,   12, 14,  2,  0 },
    {     25,   20,   12, 14,  2,  0 }, {     26,   20,   13, 14,  2,  0 }, {     27,   21,   13, 14,  2,  0 }, {     28,   21,   14, 14,  2,  0 }, {     29,   21,   14, 14,  2,  0 },
    {     30,   22,   15, 14,  2,  0 }, {     31,   22,   16, 14,  2,  0 }, {     32,   23,   16, 14,  2,  0 }, {     33,   23,   17, 14,  2,  0 }, {     34,   24,   17, 14,  2,  0 },
    {     35,   24,   18, 14,  2,  0 }, {     36,   25,   18, 14,  2,  0 }, {     37,   25,   19, 13,  2,  0 }, {     38,   26,   20, 13,  2,  0 }, {     39,   26,   20, 13,  2,  0 },
    {     40,   27,   21, 13,  2,  0 }, {     41,   28,   21, 13,  2,  0 }, {     42,   28,   22, 13,  2,  0 }, {     43,   29,   23, 13,  2,  0 }, {     44,   30,   23, 13,  2,  0 },
    {     45,   30,   24, 13,  2,  0 }, {     46,   31,   24, 13,  2,  0 }, {     47,   32,   25, 13,  2,  0 }, {     48,   32,   26, 13,  2,  0 }, {     49,   33,   26, 13,  2,  0 },
    {     50,   34,   27, 12,  2,  0 }, {     51,   35,   28, 12,  2,  0 }, {     52,   35,   28, 12,  2,  0 }, {     53,   36,   29, 12,  2,  0 }, {     54,   37,   29, 12,  2,  0 },
    {     55,   38,   30, 12,  2,  0 }, {     56,   39,   31, 12,  2,  0 }, {     57,   39,   32, 12,  2,  0 }, {     58,   40,   32, 12,  2,  0 }, {     59,   41,   33, 12,  2,  0 },
    {     60,   42,   33, 12,  2,  0 }, {     61,   43,   34, 12,  2,  0 }, {     61,   44,   35, 12,  2,  0 }, {     62,   45,   35, 11,  2,  0 }, {     63,   46,   36, 11,  2,  0 },
    {     64,   47,   37, 11,  2,  0 }, {     64,   48,   37, 11,  2,  0 }, {     65,   49,   38, 11,  2,  0 }, {     66,   50,   38, 11,  2,  0 }, {     66,   51,   39, 11,  2,  0 },
    {     67,   52,   40, 11,  2,  0 }, {     68,   53,   40, 11,  2,  0 }, {     68,   54,   41, 11,  2,  0 }, {     69,   55,   41, 11,  2,  0 }, {     70,   56,   42, 11,  2,  0 },
    {     70,   57,   43, 11,  2,  0 }, {     71,   58,   43, 10,  2,  0 }, {     71,   59,   44, 10,  2,  0 }, {     72,   60,   44, 10,  2,  0 }, {     72,   61,   45, 10,  2,  0 },
    {     73,   62,   46, 10,  2,  0 }, {     73,   63,   46, 10,  2,  0 }, {     74,   64,   47, 10,  2,  0 }, {     74,   65,   47, 10,  2,  0 }, {     75,   66,   48, 10,  2,  0 },
    {     75,   67,   49, 10,  2,  0 }, {     75,   68,   49, 10,  2,  0 }, {     76,   69,   50, 10,  2,  0 }, {     76,   70,   50, 10,  2,  0 }, {     76,   71,   51, 10,  2,  0 },
    {     77,   72,   51,  9,  2,  0 }, {     77,   73,   52,  9,  2,  0 }, {     77,   74,   52,  9,  2,  0 }, {     77,   75,   53,  9,  2,  0 }, {     78,   76,   53,  9,  2,  0 },
    {     78,   77,   54,  9,  2,  0 }, {     78,   78,   54,  9,  2,  0 }, {     78,   79,   55,  9,  2,  0 }, {     78,   80,   55,  9,  2,  0 }, {     79,   81,   56,  9,  2,  0 },
    {     79,   82,   57,  9,  2,  0 }, {     79,   83,   57,  9,  2,  0 }, {     79,   84,   58,  9,  2,  0 }, {     79,   85,   58,  9,  2,  0 }, {     79,   86,   58,  9,  2,  0 },
    {     80,   87,   59,  9,  2,  0 }, {     80,   88,   60,  8,  2,  0 }, {     80,   89,   60,  8,  2,  0 }, {     80,   90,   61,  8,  2,  0 }, {     80,   91,   61,  8,  2,  0 },
    {     80,   92,   62,  8,  2,  0 }, {     80,   93,   62,  8,  2,  0 }, {     80,   94,   63,  8,  2,  0 }, {     80,   95,   63,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1093, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 23,  2,  0 }, {     17,   23,    4, 23,  2,  0 }, {     17,   22,    5, 23,  2,  0 },
    {     17,   21,    5, 23,  2,  0 }, {     17,   20,    5, 23,  2,  0 }, {     17,   19,    6, 23,  2,  0 }, {     17,   18,    6, 23,  2,  0 }, {     18,   17,    7, 23,  2,  0 },
    {     18,   16,    8, 23,  2,  0 }, {     18,   15,    8, 23,  2,  0 }, {     18,   14,    9, 23,  2,  0 }, {     18,   13,    9, 23,  2,  0 }, {     19,   12,   10, 23,  2,  0 },
    {     19,   11,   10, 23,  2,  0 }, {     19,   10,   11, 22,  2,  0 }, {     19,    9,   11, 22,  2,  0 }, {     20,    8,   12, 22,  2,  0 }, {     20,    7,   12, 22,  2,  0 },
    {     20,    6,   13, 22,  2,  0 }, {     21,    5,   13, 22,  2,  0 }, {     21,    4,   14, 22,  2,  0 }, {     21,    3,   14, 22,  2,  0 }, {     22,    2,   15, 22,  2,  0 },
    {     22,    1,   16, 22,  2,  0 }, {     23,    0,   16, 22,  2,  0 }, {     23,   -1,   17, 22,  2,  0 }, {     24,   -2,   17, 22,  2,  0 }, {     24,   -3,   18, 22,  2,  0 },
    {     25,   -4,   18, 22,  2,  0 }, {     25,   -5,   19, 21,  2,  0 }, {     26,   -6,   20, 21,  2,  0 }, {     26,   -7,   20, 21,  2,  0 }, {     27,   -8,   21, 21,  2,  0 },
    {     28,   -9,   21, 21,  2,  0 }, {     28,  -10,   22, 21,  2,  0 }, {     29,  -11,   23, 21,  2,  0 }, {     30,  -12,   23, 21,  2,  0 }, {     30,  -13,   24, 21,  2,  0 },
    {     31,  -14,   24, 21,  2,  0 }, {     32,  -15,   25, 21,  2,  0 }, {     32,  -16,   26, 21,  2,  0 }, {     33,  -17,   26, 21,  2,  0 }, {     34,  -18,   27, 20,  2,  0 },
    {     35,  -19,   28, 20,  2,  0 }, {     35,  -20,   28, 20,  2,  0 }, {     36,  -21,   29, 20,  2,  0 }, {     37,  -22,   29, 20,  2,  0 }, {     38,  -23,   30, 20,  2,  0 },
    {     39,  -24,   31, 20,  2,  0 }, {     39,  -25,   32, 20,  2,  0 }, {     40,  -26,   32, 20,  2,  0 }, {     41,  -27,   33, 20,  2,  0 }, {     42,  -28,   33, 20,  2,  0 },
    {     43,  -29,   34, 20,  2,  0 }, {     44,  -29,   35, 20,  2,  0 }, {     45,  -30,   35, 19,  2,  0 }, {     46,  -31,   36, 19,  2,  0 }, {     47,  -32,   37, 19,  2,  0 },
    {     48,  -32,   37, 19,  2,  0 }, {     49,  -33,   38, 19,  2,  0 }, {     50,  -34,   38, 19,  2,  0 }, {     51,  -34,   39, 19,  2,  0 }, {     52,  -35,   40, 19,  2,  0 },
    {     53,  -36,   40, 19,  2,  0 }, {     54,  -36,   41, 19,  2,  0 }, {     55,  -37,   41, 19,  2,  0 }, {     56,  -38,   42, 19,  2,  0 }, {     57,  -38,   43, 19,  2,  0 },
    {     58,  -39,   43, 18,  2,  0 }, {     59,  -39,   44, 18,  2,  0 }, {     60,  -40,   44, 18,  2,  0 }, {     61,  -40,   45, 18,  2,  0 }, {     62,  -41,   46, 18,  2,  0 },
    {     63,  -41,   46, 18,  2,  0 }, {     64,  -42,   47, 18,  2,  0 }, {     65,  -42,   47, 18,  2,  0 }, {     66,  -43,   48, 18,  2,  0 }, {     67,  -43,   49, 18,  2,  0 },
    {     68,  -43,   49, 18,  2,  0 }, {     69,  -44,   50, 18,  2,  0 }, {     70,  -44,   50, 18,  2,  0 }, {     71,  -44,   51, 18,  2,  0 }, {     72,  -45,   51, 17,  2,  0 },
    {     73,  -45,   52, 17,  2,  0 }, {     74,  -45,   52, 17,  2,  0 }, {     75,  -45,   53, 17,  2,  0 }, {     76,  -46,   53, 17,  2,  0 }, {     77,  -46,   54, 17,  2,  0 },
    {     78,  -46,   54, 17,  2,  0 }, {     79,  -46,   55, 17,  2,  0 }, {     80,  -46,   55, 17,  2,  0 }, {     81,  -47,   56, 17,  2,  0 }, {     82,  -47,   57, 17,  2,  0 },
    {     83,  -47,   57, 17,  2,  0 }, {     84,  -47,   58, 17,  2,  0 }, {     85,  -47,   58, 17,  2,  0 }, {     86,  -47,   58, 17,  2,  0 }, {     87,  -48,   59, 17,  2,  0 },
    {     88,  -48,   60, 16,  2,  0 }, {     89,  -48,   60, 16,  2,  0 }, {     90,  -48,   61, 16,  2,  0 }, {     91,  -48,   61, 16,  2,  0 }, {     92,  -48,   62, 16,  2,  0 },
    {     93,  -48,   62, 16,  2,  0 }, {     94,  -48,   63, 16,  2,  0 }, {     95,  -48,   63, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D148E, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  1,  2,  0 }, {     23,   17,    4,  1,  2,  0 }, {     22,   17,    5,  1,  2,  0 },
    {     21,   17,    5,  1,  2,  0 }, {     20,   17,    5,  1,  2,  0 }, {     19,   17,    6,  1,  2,  0 }, {     18,   17,    6,  1,  2,  0 }, {     17,   18,    7,  1,  2,  0 },
    {     16,   18,    8,  1,  2,  0 }, {     15,   18,    8,  1,  2,  0 }, {     14,   18,    9,  1,  2,  0 }, {     13,   18,    9,  1,  2,  0 }, {     12,   19,   10,  1,  2,  0 },
    {     11,   19,   10,  1,  2,  0 }, {     10,   19,   11,  2,  2,  0 }, {      9,   19,   11,  2,  2,  0 }, {      8,   20,   12,  2,  2,  0 }, {      7,   20,   12,  2,  2,  0 },
    {      6,   20,   13,  2,  2,  0 }, {      5,   21,   13,  2,  2,  0 }, {      4,   21,   14,  2,  2,  0 }, {      3,   21,   14,  2,  2,  0 }, {      2,   22,   15,  2,  2,  0 },
    {      1,   22,   16,  2,  2,  0 }, {      0,   23,   16,  2,  2,  0 }, {     -1,   23,   17,  2,  2,  0 }, {     -2,   24,   17,  2,  2,  0 }, {     -3,   24,   18,  2,  2,  0 },
    {     -4,   25,   18,  2,  2,  0 }, {     -5,   25,   19,  3,  2,  0 }, {     -6,   26,   20,  3,  2,  0 }, {     -7,   26,   20,  3,  2,  0 }, {     -8,   27,   21,  3,  2,  0 },
    {     -9,   28,   21,  3,  2,  0 }, {    -10,   28,   22,  3,  2,  0 }, {    -11,   29,   23,  3,  2,  0 }, {    -12,   30,   23,  3,  2,  0 }, {    -13,   30,   24,  3,  2,  0 },
    {    -14,   31,   24,  3,  2,  0 }, {    -15,   32,   25,  3,  2,  0 }, {    -16,   32,   26,  3,  2,  0 }, {    -17,   33,   26,  3,  2,  0 }, {    -18,   34,   27,  4,  2,  0 },
    {    -19,   35,   28,  4,  2,  0 }, {    -20,   35,   28,  4,  2,  0 }, {    -21,   36,   29,  4,  2,  0 }, {    -22,   37,   29,  4,  2,  0 }, {    -23,   38,   30,  4,  2,  0 },
    {    -24,   39,   31,  4,  2,  0 }, {    -25,   39,   32,  4,  2,  0 }, {    -26,   40,   32,  4,  2,  0 }, {    -27,   41,   33,  4,  2,  0 }, {    -28,   42,   33,  4,  2,  0 },
    {    -29,   43,   34,  4,  2,  0 }, {    -29,   44,   35,  4,  2,  0 }, {    -30,   45,   35,  5,  2,  0 }, {    -31,   46,   36,  5,  2,  0 }, {    -32,   47,   37,  5,  2,  0 },
    {    -32,   48,   37,  5,  2,  0 }, {    -33,   49,   38,  5,  2,  0 }, {    -34,   50,   38,  5,  2,  0 }, {    -34,   51,   39,  5,  2,  0 }, {    -35,   52,   40,  5,  2,  0 },
    {    -36,   53,   40,  5,  2,  0 }, {    -36,   54,   41,  5,  2,  0 }, {    -37,   55,   41,  5,  2,  0 }, {    -38,   56,   42,  5,  2,  0 }, {    -38,   57,   43,  5,  2,  0 },
    {    -39,   58,   43,  6,  2,  0 }, {    -39,   59,   44,  6,  2,  0 }, {    -40,   60,   44,  6,  2,  0 }, {    -40,   61,   45,  6,  2,  0 }, {    -41,   62,   46,  6,  2,  0 },
    {    -41,   63,   46,  6,  2,  0 }, {    -42,   64,   47,  6,  2,  0 }, {    -42,   65,   47,  6,  2,  0 }, {    -43,   66,   48,  6,  2,  0 }, {    -43,   67,   49,  6,  2,  0 },
    {    -43,   68,   49,  6,  2,  0 }, {    -44,   69,   50,  6,  2,  0 }, {    -44,   70,   50,  6,  2,  0 }, {    -44,   71,   51,  6,  2,  0 }, {    -45,   72,   51,  7,  2,  0 },
    {    -45,   73,   52,  7,  2,  0 }, {    -45,   74,   52,  7,  2,  0 }, {    -45,   75,   53,  7,  2,  0 }, {    -46,   76,   53,  7,  2,  0 }, {    -46,   77,   54,  7,  2,  0 },
    {    -46,   78,   54,  7,  2,  0 }, {    -46,   79,   55,  7,  2,  0 }, {    -46,   80,   55,  7,  2,  0 }, {    -47,   81,   56,  7,  2,  0 }, {    -47,   82,   57,  7,  2,  0 },
    {    -47,   83,   57,  7,  2,  0 }, {    -47,   84,   58,  7,  2,  0 }, {    -47,   85,   58,  7,  2,  0 }, {    -47,   86,   58,  7,  2,  0 }, {    -48,   87,   59,  7,  2,  0 },
    {    -48,   88,   60,  8,  2,  0 }, {    -48,   89,   60,  8,  2,  0 }, {    -48,   90,   61,  8,  2,  0 }, {    -48,   91,   61,  8,  2,  0 }, {    -48,   92,   62,  8,  2,  0 },
    {    -48,   93,   62,  8,  2,  0 }, {    -48,   94,   63,  8,  2,  0 }, {    -48,   95,   63,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1889, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    0,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    1,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    2,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    3,  9,  2,  0 }, {     17,    9,    4,  9,  2,  0 },
    {     17,   10,    5,  9,  2,  0 }, {     17,   11,    5,  9,  2,  0 }, {     17,   12,    5,  9,  2,  0 }, {     17,   13,    6,  9,  2,  0 }, {     17,   14,    6,  9,  2,  0 },
    {     18,   15,    7,  9,  2,  0 }, {     18,   16,    8,  9,  2,  0 }, {     18,   17,    8,  9,  2,  0 }, {     18,   18,    9,  9,  2,  0 }, {     18,   19,    9,  9,  2,  0 },
    {     19,   20,   10,  9,  2,  0 }, {     19,   21,   10,  9,  2,  0 }, {     19,   22,   11, 10,  2,  0 }, {     19,   23,   11, 10,  2,  0 }, {     20,   24,   12, 10,  2,  0 },
    {     20,   25,   12, 10,  2,  0 }, {     20,   26,   13, 10,  2,  0 }, {     21,   27,   13, 10,  2,  0 }, {     21,   28,   14, 10,  2,  0 }, {     21,   29,   14, 10,  2,  0 },
    {     22,   30,   15, 10,  2,  0 }, {     22,   31,   16, 10,  2,  0 }, {     23,   32,   16, 10,  2,  0 }, {     23,   33,   17, 10,  2,  0 }, {     24,   34,   17, 10,  2,  0 },
    {     24,   35,   18, 10,  2,  0 }, {     25,   36,   18, 10,  2,  0 }, {     25,   37,   19, 11,  2,  0 }, {     26,   38,   20, 11,  2,  0 }, {     26,   39,   20, 11,  2,  0 },
    {     27,   40,   21, 11,  2,  0 }, {     28,   41,   21, 11,  2,  0 }, {     28,   42,   22, 11,  2,  0 }, {     29,   43,   23, 11,  2,  0 }, {     30,   44,   23, 11,  2,  0 },
    {     30,   45,   24, 11,  2,  0 }, {     31,   46,   24, 11,  2,  0 }, {     32,   47,   25, 11,  2,  0 }, {     32,   48,   26, 11,  2,  0 }, {     33,   49,   26, 11,  2,  0 },
    {     34,   50,   27, 12,  2,  0 }, {     35,   51,   28, 12,  2,  0 }, {     35,   52,   28, 12,  2,  0 }, {     36,   53,   29, 12,  2,  0 }, {     37,   54,   29, 12,  2,  0 },
    {     38,   55,   30, 12,  2,  0 }, {     39,   56,   31, 12,  2,  0 }, {     39,   57,   32, 12,  2,  0 }, {     40,   58,   32, 12,  2,  0 }, {     41,   59,   33, 12,  2,  0 },
    {     42,   60,   33, 12,  2,  0 }, {     43,   61,   34, 12,  2,  0 }, {     44,   61,   35, 12,  2,  0 }, {     45,   62,   35, 13,  2,  0 }, {     46,   63,   36, 13,  2,  0 },
    {     47,   64,   37, 13,  2,  0 }, {     48,   64,   37, 13,  2,  0 }, {     49,   65,   38, 13,  2,  0 }, {     50,   66,   38, 13,  2,  0 }, {     51,   66,   39, 13,  2,  0 },
    {     52,   67,   40, 13,  2,  0 }, {     53,   68,   40, 13,  2,  0 }, {     54,   68,   41, 13,  2,  0 }, {     55,   69,   41, 13,  2,  0 }, {     56,   70,   42, 13,  2,  0 },
    {     57,   70,   43, 13,  2,  0 }, {     58,   71,   43, 14,  2,  0 }, {     59,   71,   44, 14,  2,  0 }, {     60,   72,   44, 14,  2,  0 }, {     61,   72,   45, 14,  2,  0 },
    {     62,   73,   46, 14,  2,  0 }, {     63,   73,   46, 14,  2,  0 }, {     64,   74,   47, 14,  2,  0 }, {     65,   74,   47, 14,  2,  0 }, {     66,   75,   48, 14,  2,  0 },
    {     67,   75,   49, 14,  2,  0 }, {     68,   75,   49, 14,  2,  0 }, {     69,   76,   50, 14,  2,  0 }, {     70,   76,   50, 14,  2,  0 }, {     71,   76,   51, 14,  2,  0 },
    {     72,   77,   51, 15,  2,  0 }, {     73,   77,   52, 15,  2,  0 }, {     74,   77,   52, 15,  2,  0 }, {     75,   77,   53, 15,  2,  0 }, {     76,   78,   53, 15,  2,  0 },
    {     77,   78,   54, 15,  2,  0 }, {     78,   78,   54, 15,  2,  0 }, {     79,   78,   55, 15,  2,  0 }, {     80,   78,   55, 15,  2,  0 }, {     81,   79,   56, 15,  2,  0 },
    {     82,   79,   57, 15,  2,  0 }, {     83,   79,   57, 15,  2,  0 }, {     84,   79,   58, 15,  2,  0 }, {     85,   79,   58, 15,  2,  0 }, {     86,   79,   58, 15,  2,  0 },
    {     87,   80,   59, 15,  2,  0 }, {     88,   80,   60, 16,  2,  0 }, {     89,   80,   60, 16,  2,  0 }, {     90,   80,   61, 16,  2,  0 }, {     91,   80,   61, 16,  2,  0 },
    {     92,   80,   62, 16,  2,  0 }, {     93,   80,   62, 16,  2,  0 }, {     94,   80,   63, 16,  2,  0 }, {     95,   80,   63, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D1C8D, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    0, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    1, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    2, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    3, 17,  2,  0 }, {      9,   15,    4, 17,  2,  0 },
    {     10,   15,    4, 17,  2,  0 }, {     11,   15,    5, 17,  2,  0 }, {     12,   15,    5, 17,  2,  0 }, {     13,   15,    6, 17,  2,  0 }, {     14,   15,    6, 17,  2,  0 },
    {     15,   14,    7, 17,  2,  0 }, {     16,   14,    8, 17,  2,  0 }, {     17,   14,    8, 17,  2,  0 }, {     18,   14,    8, 17,  2,  0 }, {     19,   14,    9, 17,  2,  0 },
    {     20,   13,    9, 17,  2,  0 }, {     21,   13,   10, 17,  2,  0 }, {     22,   13,   11, 18,  2,  0 }, {     23,   13,   11, 18,  2,  0 }, {     24,   12,   12, 18,  2,  0 },
    {     25,   12,   12, 18,  2,  0 }, {     26,   12,   13, 18,  2,  0 }, {     27,   11,   13, 18,  2,  0 }, {     28,   11,   14, 18,  2,  0 }, {     29,   11,   14, 18,  2,  0 },
    {     30,   10,   15, 18,  2,  0 }, {     31,   10,   15, 18,  2,  0 }, {     32,    9,   16, 18,  2,  0 }, {     33,    9,   17, 18,  2,  0 }, {     34,    8,   17, 18,  2,  0 },
    {     35,    8,   18, 18,  2,  0 }, {     36,    7,   18, 18,  2,  0 }, {     37,    7,   19, 19,  2,  0 }, {     38,    6,   19, 19,  2,  0 }, {     39,    6,   20, 19,  2,  0 },
    {     40,    5,   21, 19,  2,  0 }, {     41,    4,   21, 19,  2,  0 }, {     42,    4,   22, 19,  2,  0 }, {     43,    3,   22, 19,  2,  0 }, {     44,    2,   23, 19,  2,  0 },
    {     45,    2,   24, 19,  2,  0 }, {     46,    1,   24, 19,  2,  0 }, {     47,    0,   25, 19,  2,  0 }, {     48,    0,   26, 19,  2,  0 }, {     49,   -1,   26, 19,  2,  0 },
    {     50,   -2,   27, 20,  2,  0 }, {     51,   -3,   27, 20,  2,  0 }, {     52,   -3,   28, 20,  2,  0 }, {     53,   -4,   29, 20,  2,  0 }, {     54,   -5,   29, 20,  2,  0 },
    {     55,   -6,   30, 20,  2,  0 }, {     56,   -7,   31, 20,  2,  0 }, {     57,   -7,   31, 20,  2,  0 }, {     58,   -8,   32, 20,  2,  0 }, {     59,   -9,   32, 20,  2,  0 },
    {     60,  -10,   33, 20,  2,  0 }, {     61,  -11,   34, 20,  2,  0 }, {     61,  -12,   34, 20,  2,  0 }, {     62,  -13,   35, 21,  2,  0 }, {     63,  -14,   36, 21,  2,  0 },
    {     64,  -15,   36, 21,  2,  0 }, {     64,  -16,   37, 21,  2,  0 }, {     65,  -17,   37, 21,  2,  0 }, {     66,  -18,   38, 21,  2,  0 }, {     66,  -19,   39, 21,  2,  0 },
    {     67,  -20,   39, 21,  2,  0 }, {     68,  -21,   40, 21,  2,  0 }, {     68,  -22,   41, 21,  2,  0 }, {     69,  -23,   41, 21,  2,  0 }, {     70,  -24,   42, 21,  2,  0 },
    {     70,  -25,   42, 21,  2,  0 }, {     71,  -26,   43, 22,  2,  0 }, {     71,  -27,   44, 22,  2,  0 }, {     72,  -28,   44, 22,  2,  0 }, {     72,  -29,   45, 22,  2,  0 },
    {     73,  -30,   45, 22,  2,  0 }, {     73,  -31,   46, 22,  2,  0 }, {     74,  -32,   46, 22,  2,  0 }, {     74,  -33,   47, 22,  2,  0 }, {     75,  -34,   48, 22,  2,  0 },
    {     75,  -35,   48, 22,  2,  0 }, {     75,  -36,   49, 22,  2,  0 }, {     76,  -37,   49, 22,  2,  0 }, {     76,  -38,   50, 22,  2,  0 }, {     76,  -39,   50, 22,  2,  0 },
    {     77,  -40,   51, 23,  2,  0 }, {     77,  -41,   51, 23,  2,  0 }, {     77,  -42,   52, 23,  2,  0 }, {     77,  -43,   52, 23,  2,  0 }, {     78,  -44,   53, 23,  2,  0 },
    {     78,  -45,   54, 23,  2,  0 }, {     78,  -46,   54, 23,  2,  0 }, {     78,  -47,   55, 23,  2,  0 }, {     78,  -48,   55, 23,  2,  0 }, {     79,  -49,   55, 23,  2,  0 },
    {     79,  -50,   56, 23,  2,  0 }, {     79,  -51,   57, 23,  2,  0 }, {     79,  -52,   57, 23,  2,  0 }, {     79,  -53,   58, 23,  2,  0 }, {     79,  -54,   58, 23,  2,  0 },
    {     80,  -55,   59, 23,  2,  0 }, {     80,  -56,   59, 24,  2,  0 }, {     80,  -57,   60, 24,  2,  0 }, {     80,  -58,   60, 24,  2,  0 }, {     80,  -59,   61, 24,  2,  0 },
    {     80,  -60,   61, 24,  2,  0 }, {     80,  -61,   62, 24,  2,  0 }, {     80,  -62,   62, 24,  2,  0 }, {     80,  -63,   63, 24,  2,  0 }, {     80,  -64,   64, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D209A, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 25,  2,  0 }, {     15,   23,    4, 25,  2,  0 }, {     15,   22,    4, 25,  2,  0 },
    {     15,   21,    5, 25,  2,  0 }, {     15,   20,    5, 25,  2,  0 }, {     15,   19,    6, 25,  2,  0 }, {     15,   18,    6, 25,  2,  0 }, {     14,   17,    7, 25,  2,  0 },
    {     14,   16,    8, 25,  2,  0 }, {     14,   15,    8, 25,  2,  0 }, {     14,   14,    8, 25,  2,  0 }, {     14,   13,    9, 25,  2,  0 }, {     13,   12,    9, 25,  2,  0 },
    {     13,   11,   10, 25,  2,  0 }, {     13,   10,   11, 26,  2,  0 }, {     13,    9,   11, 26,  2,  0 }, {     12,    8,   12, 26,  2,  0 }, {     12,    7,   12, 26,  2,  0 },
    {     12,    6,   13, 26,  2,  0 }, {     11,    5,   13, 26,  2,  0 }, {     11,    4,   14, 26,  2,  0 }, {     11,    3,   14, 26,  2,  0 }, {     10,    2,   15, 26,  2,  0 },
    {     10,    1,   15, 26,  2,  0 }, {      9,    0,   16, 26,  2,  0 }, {      9,   -1,   17, 26,  2,  0 }, {      8,   -2,   17, 26,  2,  0 }, {      8,   -3,   18, 26,  2,  0 },
    {      7,   -4,   18, 26,  2,  0 }, {      7,   -5,   19, 27,  2,  0 }, {      6,   -6,   19, 27,  2,  0 }, {      6,   -7,   20, 27,  2,  0 }, {      5,   -8,   21, 27,  2,  0 },
    {      4,   -9,   21, 27,  2,  0 }, {      4,  -10,   22, 27,  2,  0 }, {      3,  -11,   22, 27,  2,  0 }, {      2,  -12,   23, 27,  2,  0 }, {      2,  -13,   24, 27,  2,  0 },
    {      1,  -14,   24, 27,  2,  0 }, {      0,  -15,   25, 27,  2,  0 }, {      0,  -16,   26, 27,  2,  0 }, {     -1,  -17,   26, 27,  2,  0 }, {     -2,  -18,   27, 28,  2,  0 },
    {     -3,  -19,   27, 28,  2,  0 }, {     -3,  -20,   28, 28,  2,  0 }, {     -4,  -21,   29, 28,  2,  0 }, {     -5,  -22,   29, 28,  2,  0 }, {     -6,  -23,   30, 28,  2,  0 },
    {     -7,  -24,   31, 28,  2,  0 }, {     -7,  -25,   32, 28,  2,  0 }, {     -8,  -26,   32, 28,  2,  0 }, {     -9,  -27,   33, 28,  2,  0 }, {    -10,  -28,   33, 28,  2,  0 },
    {    -11,  -29,   34, 28,  2,  0 }, {    -12,  -29,   35, 28,  2,  0 }, {    -13,  -30,   35, 29,  2,  0 }, {    -14,  -31,   36, 29,  2,  0 }, {    -15,  -32,   37, 29,  2,  0 },
    {    -16,  -32,   37, 29,  2,  0 }, {    -17,  -33,   38, 29,  2,  0 }, {    -18,  -34,   38, 29,  2,  0 }, {    -19,  -34,   39, 29,  2,  0 }, {    -20,  -35,   40, 29,  2,  0 },
    {    -21,  -36,   40, 29,  2,  0 }, {    -22,  -36,   41, 29,  2,  0 }, {    -23,  -37,   41, 29,  2,  0 }, {    -24,  -38,   42, 29,  2,  0 }, {    -25,  -38,   43, 29,  2,  0 },
    {    -26,  -39,   43, 30,  2,  0 }, {    -27,  -39,   44, 30,  2,  0 }, {    -28,  -40,   44, 30,  2,  0 }, {    -29,  -40,   45, 30,  2,  0 }, {    -30,  -41,   45, 30,  2,  0 },
    {    -31,  -41,   46, 30,  2,  0 }, {    -32,  -42,   47, 30,  2,  0 }, {    -33,  -42,   47, 30,  2,  0 }, {    -34,  -43,   48, 30,  2,  0 }, {    -35,  -43,   48, 30,  2,  0 },
    {    -36,  -43,   49, 30,  2,  0 }, {    -37,  -44,   49, 30,  2,  0 }, {    -38,  -44,   50, 30,  2,  0 }, {    -39,  -44,   51, 30,  2,  0 }, {    -40,  -45,   51, 31,  2,  0 },
    {    -41,  -45,   52, 31,  2,  0 }, {    -42,  -45,   52, 31,  2,  0 }, {    -43,  -45,   53, 31,  2,  0 }, {    -44,  -46,   53, 31,  2,  0 }, {    -45,  -46,   54, 31,  2,  0 },
    {    -46,  -46,   54, 31,  2,  0 }, {    -47,  -46,   55, 31,  2,  0 }, {    -48,  -46,   55, 31,  2,  0 }, {    -49,  -47,   56, 31,  2,  0 }, {    -50,  -47,   56, 31,  2,  0 },
    {    -51,  -47,   57, 31,  2,  0 }, {    -52,  -47,   57, 31,  2,  0 }, {    -53,  -47,   58, 31,  2,  0 }, {    -54,  -47,   58, 31,  2,  0 }, {    -55,  -48,   59, 31,  2,  0 },
    {    -56,  -48,   59,  0,  2,  0 }, {    -57,  -48,   60,  0,  2,  0 }, {    -58,  -48,   60,  0,  2,  0 }, {    -59,  -48,   61,  0,  2,  0 }, {    -60,  -48,   61,  0,  2,  0 },
    {    -61,  -48,   62,  0,  2,  0 }, {    -62,  -48,   62,  0,  2,  0 }, {    -63,  -48,   63,  0,  2,  0 }, {    -64,  -48,   64,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D249E, {
    {     31,   16,   15,  0,  6,  0 }, {     30,   16,   15,  0,  6,  0 }, {     29,   16,   14,  0,  6,  0 }, {     28,   16,   14,  0,  6,  0 }, {     27,   16,   13,  0,  6,  0 },
    {     26,   16,   13,  0,  6,  0 }, {     25,   16,   12,  0,  6,  0 }, {     24,   16,   12, 31,  6,  0 }, {     23,   15,   11, 31,  6,  0 }, {     22,   15,   11, 31,  6,  0 },
    {     21,   15,   10, 31,  6,  0 }, {     20,   15,   10, 31,  6,  0 }, {     19,   15,    9, 31,  6,  0 }, {     18,   15,    9, 31,  6,  0 }, {     17,   14,    8, 31,  6,  0 },
    {     16,   14,    7, 31,  6,  0 }, {     15,   14,    7, 31,  6,  0 }, {     14,   14,    7, 31,  6,  0 }, {     13,   14,    6, 31,  6,  0 }, {     12,   13,    6, 31,  6,  0 },
    {     11,   13,    5, 31,  6,  0 }, {     10,   13,    4, 30,  6,  0 }, {      9,   13,    4, 30,  6,  0 }, {      8,   12,    3, 30,  6,  0 }, {      7,   12,    3, 30,  6,  0 },
    {      6,   12,    2, 30,  6,  0 }, {      5,   11,    2, 30,  6,  0 }, {      4,   11,    1, 30,  6,  0 }, {      3,   11,    1, 30,  6,  0 }, {      2,   10,    0, 30,  6,  0 },
    {      1,   10,    0, 30,  6,  0 }, {      0,    9,   -1, 30,  6,  0 }, {     -1,    9,   -2, 30,  6,  0 }, {     -2,    8,   -2, 30,  6,  0 }, {     -3,    8,   -3, 30,  6,  0 },
    {     -4,    7,   -3, 30,  6,  0 }, {     -5,    7,   -4, 29,  6,  0 }, {     -6,    6,   -4, 29,  6,  0 }, {     -7,    6,   -5, 29,  6,  0 }, {     -8,    5,   -6, 29,  6,  0 },
    {     -9,    4,   -6, 29,  6,  0 }, {    -10,    4,   -7, 29,  6,  0 }, {    -11,    3,   -7, 29,  6,  0 }, {    -12,    2,   -8, 29,  6,  0 }, {    -13,    2,   -9, 29,  6,  0 },
    {    -14,    1,   -9, 29,  6,  0 }, {    -15,    0,  -10, 29,  6,  0 }, {    -16,    0,  -11, 29,  6,  0 }, {    -17,   -1,  -11, 29,  6,  0 }, {    -18,   -2,  -12, 28,  6,  0 },
    {    -19,   -3,  -12, 28,  6,  0 }, {    -20,   -3,  -13, 28,  6,  0 }, {    -21,   -4,  -14, 28,  6,  0 }, {    -22,   -5,  -14, 28,  6,  0 }, {    -23,   -6,  -15, 28,  6,  0 },
    {    -24,   -7,  -16, 28,  6,  0 }, {    -25,   -7,  -16, 28,  6,  0 }, {    -26,   -8,  -17, 28,  6,  0 }, {    -27,   -9,  -17, 28,  6,  0 }, {    -28,  -10,  -18, 28,  6,  0 },
    {    -29,  -11,  -19, 28,  6,  0 }, {    -29,  -12,  -19, 28,  6,  0 }, {    -30,  -13,  -20, 27,  6,  0 }, {    -31,  -14,  -21, 27,  6,  0 }, {    -32,  -15,  -21, 27,  6,  0 },
    {    -32,  -16,  -22, 27,  6,  0 }, {    -33,  -17,  -22, 27,  6,  0 }, {    -34,  -18,  -23, 27,  6,  0 }, {    -34,  -19,  -24, 27,  6,  0 }, {    -35,  -20,  -24, 27,  6,  0 },
    {    -36,  -21,  -25, 27,  6,  0 }, {    -36,  -22,  -26, 27,  6,  0 }, {    -37,  -23,  -26, 27,  6,  0 }, {    -38,  -24,  -27, 27,  6,  0 }, {    -38,  -25,  -27, 27,  6,  0 },
    {    -39,  -26,  -28, 26,  6,  0 }, {    -39,  -27,  -29, 26,  6,  0 }, {    -40,  -28,  -29, 26,  6,  0 }, {    -40,  -29,  -30, 26,  6,  0 }, {    -41,  -30,  -30, 26,  6,  0 },
    {    -41,  -31,  -31, 26,  6,  0 }, {    -42,  -32,  -31, 26,  6,  0 }, {    -42,  -33,  -32, 26,  6,  0 }, {    -43,  -34,  -33, 26,  6,  0 }, {    -43,  -35,  -33, 26,  6,  0 },
    {    -43,  -36,  -34, 26,  6,  0 }, {    -44,  -37,  -34, 26,  6,  0 }, {    -44,  -38,  -35, 26,  6,  0 }, {    -44,  -39,  -35, 26,  6,  0 }, {    -45,  -40,  -36, 25,  6,  0 },
    {    -45,  -41,  -36, 25,  6,  0 }, {    -45,  -42,  -37, 25,  6,  0 }, {    -45,  -43,  -37, 25,  6,  0 }, {    -46,  -44,  -38, 25,  6,  0 }, {    -46,  -45,  -39, 25,  6,  0 },
    {    -46,  -46,  -39, 25,  6,  0 }, {    -46,  -47,  -40, 25,  6,  0 }, {    -46,  -48,  -40, 25,  6,  0 }, {    -47,  -49,  -40, 25,  6,  0 }, {    -47,  -50,  -41, 25,  6,  0 },
    {    -47,  -51,  -42, 25,  6,  0 }, {    -47,  -52,  -42, 25,  6,  0 }, {    -47,  -53,  -43, 25,  6,  0 }, {    -47,  -54,  -43, 25,  6,  0 }, {    -48,  -55,  -44, 25,  6,  0 },
    {    -48,  -56,  -44, 24,  6,  0 }, {    -48,  -57,  -45, 24,  6,  0 }, {    -48,  -58,  -45, 24,  6,  0 }, {    -48,  -59,  -46, 24,  6,  0 }, {    -48,  -60,  -46, 24,  6,  0 },
    {    -48,  -61,  -47, 24,  6,  0 }, {    -48,  -62,  -47, 24,  6,  0 }, {    -48,  -63,  -48, 24,  6,  0 }, {    -48,  -64,  -49, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D28A2, {
    {     16,    0,   15,  8,  6,  0 }, {     16,    1,   15,  8,  6,  0 }, {     16,    2,   15,  8,  6,  0 }, {     16,    3,   14,  8,  6,  0 }, {     16,    4,   14,  8,  6,  0 },
    {     16,    5,   13,  8,  6,  0 }, {     16,    6,   13,  8,  6,  0 }, {     16,    7,   12,  8,  6,  0 }, {     16,    8,   12,  7,  6,  0 }, {     15,    9,   11,  7,  6,  0 },
    {     15,   10,   11,  7,  6,  0 }, {     15,   11,   10,  7,  6,  0 }, {     15,   12,   10,  7,  6,  0 }, {     15,   13,    9,  7,  6,  0 }, {     15,   14,    9,  7,  6,  0 },
    {     14,   15,    8,  7,  6,  0 }, {     14,   16,    7,  7,  6,  0 }, {     14,   17,    7,  7,  6,  0 }, {     14,   18,    7,  7,  6,  0 }, {     14,   19,    6,  7,  6,  0 },
    {     13,   20,    6,  7,  6,  0 }, {     13,   21,    5,  7,  6,  0 }, {     13,   22,    4,  6,  6,  0 }, {     13,   23,    4,  6,  6,  0 }, {     12,   24,    3,  6,  6,  0 },
    {     12,   25,    3,  6,  6,  0 }, {     12,   26,    2,  6,  6,  0 }, {     11,   27,    2,  6,  6,  0 }, {     11,   28,    1,  6,  6,  0 }, {     11,   29,    1,  6,  6,  0 },
    {     10,   30,    0,  6,  6,  0 }, {     10,   31,    0,  6,  6,  0 }, {      9,   32,   -1,  6,  6,  0 }, {      9,   33,   -2,  6,  6,  0 }, {      8,   34,   -2,  6,  6,  0 },
    {      8,   35,   -3,  6,  6,  0 }, {      7,   36,   -3,  6,  6,  0 }, {      7,   37,   -4,  5,  6,  0 }, {      6,   38,   -4,  5,  6,  0 }, {      6,   39,   -5,  5,  6,  0 },
    {      5,   40,   -6,  5,  6,  0 }, {      4,   41,   -6,  5,  6,  0 }, {      4,   42,   -7,  5,  6,  0 }, {      3,   43,   -7,  5,  6,  0 }, {      2,   44,   -8,  5,  6,  0 },
    {      2,   45,   -9,  5,  6,  0 }, {      1,   46,   -9,  5,  6,  0 }, {      0,   47,  -10,  5,  6,  0 }, {      0,   48,  -11,  5,  6,  0 }, {     -1,   49,  -11,  5,  6,  0 },
    {     -2,   50,  -12,  4,  6,  0 }, {     -3,   51,  -12,  4,  6,  0 }, {     -3,   52,  -13,  4,  6,  0 }, {     -4,   53,  -14,  4,  6,  0 }, {     -5,   54,  -14,  4,  6,  0 },
    {     -6,   55,  -15,  4,  6,  0 }, {     -7,   56,  -16,  4,  6,  0 }, {     -7,   57,  -16,  4,  6,  0 }, {     -8,   58,  -17,  4,  6,  0 }, {     -9,   59,  -17,  4,  6,  0 },
    {    -10,   60,  -18,  4,  6,  0 }, {    -11,   61,  -19,  4,  6,  0 }, {    -12,   61,  -19,  4,  6,  0 }, {    -13,   62,  -20,  3,  6,  0 }, {    -14,   63,  -21,  3,  6,  0 },
    {    -15,   64,  -21,  3,  6,  0 }, {    -16,   64,  -22,  3,  6,  0 }, {    -17,   65,  -22,  3,  6,  0 }, {    -18,   66,  -23,  3,  6,  0 }, {    -19,   66,  -24,  3,  6,  0 },
    {    -20,   67,  -24,  3,  6,  0 }, {    -21,   68,  -25,  3,  6,  0 }, {    -22,   68,  -26,  3,  6,  0 }, {    -23,   69,  -26,  3,  6,  0 }, {    -24,   70,  -27,  3,  6,  0 },
    {    -25,   70,  -27,  3,  6,  0 }, {    -26,   71,  -28,  2,  6,  0 }, {    -27,   71,  -29,  2,  6,  0 }, {    -28,   72,  -29,  2,  6,  0 }, {    -29,   72,  -30,  2,  6,  0 },
    {    -30,   73,  -30,  2,  6,  0 }, {    -31,   73,  -31,  2,  6,  0 }, {    -32,   74,  -31,  2,  6,  0 }, {    -33,   74,  -32,  2,  6,  0 }, {    -34,   75,  -33,  2,  6,  0 },
    {    -35,   75,  -33,  2,  6,  0 }, {    -36,   75,  -34,  2,  6,  0 }, {    -37,   76,  -34,  2,  6,  0 }, {    -38,   76,  -35,  2,  6,  0 }, {    -39,   76,  -35,  2,  6,  0 },
    {    -40,   77,  -36,  1,  6,  0 }, {    -41,   77,  -36,  1,  6,  0 }, {    -42,   77,  -37,  1,  6,  0 }, {    -43,   77,  -37,  1,  6,  0 }, {    -44,   78,  -38,  1,  6,  0 },
    {    -45,   78,  -39,  1,  6,  0 }, {    -46,   78,  -39,  1,  6,  0 }, {    -47,   78,  -40,  1,  6,  0 }, {    -48,   78,  -40,  1,  6,  0 }, {    -49,   79,  -40,  1,  6,  0 },
    {    -50,   79,  -41,  1,  6,  0 }, {    -51,   79,  -42,  1,  6,  0 }, {    -52,   79,  -42,  1,  6,  0 }, {    -53,   79,  -43,  1,  6,  0 }, {    -54,   79,  -43,  1,  6,  0 },
    {    -55,   80,  -44,  1,  6,  0 }, {    -56,   80,  -44,  0,  6,  0 }, {    -57,   80,  -45,  0,  6,  0 }, {    -58,   80,  -45,  0,  6,  0 }, {    -59,   80,  -46,  0,  6,  0 },
    {    -60,   80,  -46,  0,  6,  0 }, {    -61,   80,  -47,  0,  6,  0 }, {    -62,   80,  -47,  0,  6,  0 }, {    -63,   80,  -48,  0,  6,  0 }, {    -64,   80,  -49,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D2CAF, {
    {      0,   16,   15, 16,  6,  0 }, {      1,   16,   15, 16,  6,  0 }, {      2,   16,   15, 16,  6,  0 }, {      3,   16,   14, 16,  6,  0 }, {      4,   16,   14, 16,  6,  0 },
    {      5,   16,   13, 16,  6,  0 }, {      6,   16,   13, 16,  6,  0 }, {      7,   16,   12, 16,  6,  0 }, {      8,   16,   12, 15,  6,  0 }, {      9,   17,   11, 15,  6,  0 },
    {     10,   17,   10, 15,  6,  0 }, {     11,   17,   10, 15,  6,  0 }, {     12,   17,   10, 15,  6,  0 }, {     13,   17,    9, 15,  6,  0 }, {     14,   17,    9, 15,  6,  0 },
    {     15,   18,    8, 15,  6,  0 }, {     16,   18,    7, 15,  6,  0 }, {     17,   18,    7, 15,  6,  0 }, {     18,   18,    6, 15,  6,  0 }, {     19,   18,    6, 15,  6,  0 },
    {     20,   19,    5, 15,  6,  0 }, {     21,   19,    5, 15,  6,  0 }, {     22,   19,    4, 14,  6,  0 }, {     23,   19,    4, 14,  6,  0 }, {     24,   20,    3, 14,  6,  0 },
    {     25,   20,    3, 14,  6,  0 }, {     26,   20,    2, 14,  6,  0 }, {     27,   21,    2, 14,  6,  0 }, {     28,   21,    1, 14,  6,  0 }, {     29,   21,    1, 14,  6,  0 },
    {     30,   22,    0, 14,  6,  0 }, {     31,   22,   -1, 14,  6,  0 }, {     32,   23,   -1, 14,  6,  0 }, {     33,   23,   -2, 14,  6,  0 }, {     34,   24,   -2, 14,  6,  0 },
    {     35,   24,   -3, 14,  6,  0 }, {     36,   25,   -3, 14,  6,  0 }, {     37,   25,   -4, 13,  6,  0 }, {     38,   26,   -5, 13,  6,  0 }, {     39,   26,   -5, 13,  6,  0 },
    {     40,   27,   -6, 13,  6,  0 }, {     41,   28,   -6, 13,  6,  0 }, {     42,   28,   -7, 13,  6,  0 }, {     43,   29,   -8, 13,  6,  0 }, {     44,   30,   -8, 13,  6,  0 },
    {     45,   30,   -9, 13,  6,  0 }, {     46,   31,   -9, 13,  6,  0 }, {     47,   32,  -10, 13,  6,  0 }, {     48,   32,  -11, 13,  6,  0 }, {     49,   33,  -11, 13,  6,  0 },
    {     50,   34,  -12, 12,  6,  0 }, {     51,   35,  -13, 12,  6,  0 }, {     52,   35,  -13, 12,  6,  0 }, {     53,   36,  -14, 12,  6,  0 }, {     54,   37,  -14, 12,  6,  0 },
    {     55,   38,  -15, 12,  6,  0 }, {     56,   39,  -16, 12,  6,  0 }, {     57,   39,  -17, 12,  6,  0 }, {     58,   40,  -17, 12,  6,  0 }, {     59,   41,  -18, 12,  6,  0 },
    {     60,   42,  -18, 12,  6,  0 }, {     61,   43,  -19, 12,  6,  0 }, {     61,   44,  -20, 12,  6,  0 }, {     62,   45,  -20, 11,  6,  0 }, {     63,   46,  -21, 11,  6,  0 },
    {     64,   47,  -22, 11,  6,  0 }, {     64,   48,  -22, 11,  6,  0 }, {     65,   49,  -23, 11,  6,  0 }, {     66,   50,  -23, 11,  6,  0 }, {     66,   51,  -24, 11,  6,  0 },
    {     67,   52,  -25, 11,  6,  0 }, {     68,   53,  -25, 11,  6,  0 }, {     68,   54,  -26, 11,  6,  0 }, {     69,   55,  -26, 11,  6,  0 }, {     70,   56,  -27, 11,  6,  0 },
    {     70,   57,  -28, 11,  6,  0 }, {     71,   58,  -28, 10,  6,  0 }, {     71,   59,  -29, 10,  6,  0 }, {     72,   60,  -29, 10,  6,  0 }, {     72,   61,  -30, 10,  6,  0 },
    {     73,   62,  -31, 10,  6,  0 }, {     73,   63,  -31, 10,  6,  0 }, {     74,   64,  -32, 10,  6,  0 }, {     74,   65,  -32, 10,  6,  0 }, {     75,   66,  -33, 10,  6,  0 },
    {     75,   67,  -34, 10,  6,  0 }, {     75,   68,  -34, 10,  6,  0 }, {     76,   69,  -35, 10,  6,  0 }, {     76,   70,  -35, 10,  6,  0 }, {     76,   71,  -36, 10,  6,  0 },
    {     77,   72,  -36,  9,  6,  0 }, {     77,   73,  -37,  9,  6,  0 }, {     77,   74,  -37,  9,  6,  0 }, {     77,   75,  -38,  9,  6,  0 }, {     78,   76,  -38,  9,  6,  0 },
    {     78,   77,  -39,  9,  6,  0 }, {     78,   78,  -39,  9,  6,  0 }, {     78,   79,  -40,  9,  6,  0 }, {     78,   80,  -40,  9,  6,  0 }, {     79,   81,  -41,  9,  6,  0 },
    {     79,   82,  -42,  9,  6,  0 }, {     79,   83,  -42,  9,  6,  0 }, {     79,   84,  -43,  9,  6,  0 }, {     79,   85,  -43,  9,  6,  0 }, {     79,   86,  -43,  9,  6,  0 },
    {     80,   87,  -44,  9,  6,  0 }, {     80,   88,  -45,  8,  6,  0 }, {     80,   89,  -45,  8,  6,  0 }, {     80,   90,  -46,  8,  6,  0 }, {     80,   91,  -46,  8,  6,  0 },
    {     80,   92,  -47,  8,  6,  0 }, {     80,   93,  -47,  8,  6,  0 }, {     80,   94,  -48,  8,  6,  0 }, {     80,   95,  -48,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D30B3, {
    {     16,   31,   15, 24,  6,  0 }, {     16,   30,   15, 24,  6,  0 }, {     16,   29,   14, 24,  6,  0 }, {     16,   28,   14, 24,  6,  0 }, {     16,   27,   13, 24,  6,  0 },
    {     16,   26,   13, 24,  6,  0 }, {     16,   25,   12, 24,  6,  0 }, {     16,   24,   12, 23,  6,  0 }, {     17,   23,   11, 23,  6,  0 }, {     17,   22,   10, 23,  6,  0 },
    {     17,   21,   10, 23,  6,  0 }, {     17,   20,   10, 23,  6,  0 }, {     17,   19,    9, 23,  6,  0 }, {     17,   18,    9, 23,  6,  0 }, {     18,   17,    8, 23,  6,  0 },
    {     18,   16,    7, 23,  6,  0 }, {     18,   15,    7, 23,  6,  0 }, {     18,   14,    6, 23,  6,  0 }, {     18,   13,    6, 23,  6,  0 }, {     19,   12,    5, 23,  6,  0 },
    {     19,   11,    5, 23,  6,  0 }, {     19,   10,    4, 22,  6,  0 }, {     19,    9,    4, 22,  6,  0 }, {     20,    8,    3, 22,  6,  0 }, {     20,    7,    3, 22,  6,  0 },
    {     20,    6,    2, 22,  6,  0 }, {     21,    5,    2, 22,  6,  0 }, {     21,    4,    1, 22,  6,  0 }, {     21,    3,    1, 22,  6,  0 }, {     22,    2,    0, 22,  6,  0 },
    {     22,    1,   -1, 22,  6,  0 }, {     23,    0,   -1, 22,  6,  0 }, {     23,   -1,   -2, 22,  6,  0 }, {     24,   -2,   -2, 22,  6,  0 }, {     24,   -3,   -3, 22,  6,  0 },
    {     25,   -4,   -3, 22,  6,  0 }, {     25,   -5,   -4, 21,  6,  0 }, {     26,   -6,   -5, 21,  6,  0 }, {     26,   -7,   -5, 21,  6,  0 }, {     27,   -8,   -6, 21,  6,  0 },
    {     28,   -9,   -6, 21,  6,  0 }, {     28,  -10,   -7, 21,  6,  0 }, {     29,  -11,   -8, 21,  6,  0 }, {     30,  -12,   -8, 21,  6,  0 }, {     30,  -13,   -9, 21,  6,  0 },
    {     31,  -14,   -9, 21,  6,  0 }, {     32,  -15,  -10, 21,  6,  0 }, {     32,  -16,  -11, 21,  6,  0 }, {     33,  -17,  -11, 21,  6,  0 }, {     34,  -18,  -12, 20,  6,  0 },
    {     35,  -19,  -13, 20,  6,  0 }, {     35,  -20,  -13, 20,  6,  0 }, {     36,  -21,  -14, 20,  6,  0 }, {     37,  -22,  -14, 20,  6,  0 }, {     38,  -23,  -15, 20,  6,  0 },
    {     39,  -24,  -16, 20,  6,  0 }, {     39,  -25,  -17, 20,  6,  0 }, {     40,  -26,  -17, 20,  6,  0 }, {     41,  -27,  -18, 20,  6,  0 }, {     42,  -28,  -18, 20,  6,  0 },
    {     43,  -29,  -19, 20,  6,  0 }, {     44,  -29,  -20, 20,  6,  0 }, {     45,  -30,  -20, 19,  6,  0 }, {     46,  -31,  -21, 19,  6,  0 }, {     47,  -32,  -22, 19,  6,  0 },
    {     48,  -32,  -22, 19,  6,  0 }, {     49,  -33,  -23, 19,  6,  0 }, {     50,  -34,  -23, 19,  6,  0 }, {     51,  -34,  -24, 19,  6,  0 }, {     52,  -35,  -25, 19,  6,  0 },
    {     53,  -36,  -25, 19,  6,  0 }, {     54,  -36,  -26, 19,  6,  0 }, {     55,  -37,  -26, 19,  6,  0 }, {     56,  -38,  -27, 19,  6,  0 }, {     57,  -38,  -28, 19,  6,  0 },
    {     58,  -39,  -28, 18,  6,  0 }, {     59,  -39,  -29, 18,  6,  0 }, {     60,  -40,  -29, 18,  6,  0 }, {     61,  -40,  -30, 18,  6,  0 }, {     62,  -41,  -31, 18,  6,  0 },
    {     63,  -41,  -31, 18,  6,  0 }, {     64,  -42,  -32, 18,  6,  0 }, {     65,  -42,  -32, 18,  6,  0 }, {     66,  -43,  -33, 18,  6,  0 }, {     67,  -43,  -34, 18,  6,  0 },
    {     68,  -43,  -34, 18,  6,  0 }, {     69,  -44,  -35, 18,  6,  0 }, {     70,  -44,  -35, 18,  6,  0 }, {     71,  -44,  -36, 18,  6,  0 }, {     72,  -45,  -36, 17,  6,  0 },
    {     73,  -45,  -37, 17,  6,  0 }, {     74,  -45,  -37, 17,  6,  0 }, {     75,  -45,  -38, 17,  6,  0 }, {     76,  -46,  -38, 17,  6,  0 }, {     77,  -46,  -39, 17,  6,  0 },
    {     78,  -46,  -39, 17,  6,  0 }, {     79,  -46,  -40, 17,  6,  0 }, {     80,  -46,  -40, 17,  6,  0 }, {     81,  -47,  -41, 17,  6,  0 }, {     82,  -47,  -42, 17,  6,  0 },
    {     83,  -47,  -42, 17,  6,  0 }, {     84,  -47,  -43, 17,  6,  0 }, {     85,  -47,  -43, 17,  6,  0 }, {     86,  -47,  -43, 17,  6,  0 }, {     87,  -48,  -44, 17,  6,  0 },
    {     88,  -48,  -45, 16,  6,  0 }, {     89,  -48,  -45, 16,  6,  0 }, {     90,  -48,  -46, 16,  6,  0 }, {     91,  -48,  -46, 16,  6,  0 }, {     92,  -48,  -47, 16,  6,  0 },
    {     93,  -48,  -47, 16,  6,  0 }, {     94,  -48,  -48, 16,  6,  0 }, {     95,  -48,  -48, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D34AE, {
    {     31,   16,   15,  0,  6,  0 }, {     30,   16,   15,  0,  6,  0 }, {     29,   16,   14,  0,  6,  0 }, {     28,   16,   14,  0,  6,  0 }, {     27,   16,   13,  0,  6,  0 },
    {     26,   16,   13,  0,  6,  0 }, {     25,   16,   12,  0,  6,  0 }, {     24,   16,   12,  1,  6,  0 }, {     23,   17,   11,  1,  6,  0 }, {     22,   17,   10,  1,  6,  0 },
    {     21,   17,   10,  1,  6,  0 }, {     20,   17,   10,  1,  6,  0 }, {     19,   17,    9,  1,  6,  0 }, {     18,   17,    9,  1,  6,  0 }, {     17,   18,    8,  1,  6,  0 },
    {     16,   18,    7,  1,  6,  0 }, {     15,   18,    7,  1,  6,  0 }, {     14,   18,    6,  1,  6,  0 }, {     13,   18,    6,  1,  6,  0 }, {     12,   19,    5,  1,  6,  0 },
    {     11,   19,    5,  1,  6,  0 }, {     10,   19,    4,  2,  6,  0 }, {      9,   19,    4,  2,  6,  0 }, {      8,   20,    3,  2,  6,  0 }, {      7,   20,    3,  2,  6,  0 },
    {      6,   20,    2,  2,  6,  0 }, {      5,   21,    2,  2,  6,  0 }, {      4,   21,    1,  2,  6,  0 }, {      3,   21,    1,  2,  6,  0 }, {      2,   22,    0,  2,  6,  0 },
    {      1,   22,   -1,  2,  6,  0 }, {      0,   23,   -1,  2,  6,  0 }, {     -1,   23,   -2,  2,  6,  0 }, {     -2,   24,   -2,  2,  6,  0 }, {     -3,   24,   -3,  2,  6,  0 },
    {     -4,   25,   -3,  2,  6,  0 }, {     -5,   25,   -4,  3,  6,  0 }, {     -6,   26,   -5,  3,  6,  0 }, {     -7,   26,   -5,  3,  6,  0 }, {     -8,   27,   -6,  3,  6,  0 },
    {     -9,   28,   -6,  3,  6,  0 }, {    -10,   28,   -7,  3,  6,  0 }, {    -11,   29,   -8,  3,  6,  0 }, {    -12,   30,   -8,  3,  6,  0 }, {    -13,   30,   -9,  3,  6,  0 },
    {    -14,   31,   -9,  3,  6,  0 }, {    -15,   32,  -10,  3,  6,  0 }, {    -16,   32,  -11,  3,  6,  0 }, {    -17,   33,  -11,  3,  6,  0 }, {    -18,   34,  -12,  4,  6,  0 },
    {    -19,   35,  -13,  4,  6,  0 }, {    -20,   35,  -13,  4,  6,  0 }, {    -21,   36,  -14,  4,  6,  0 }, {    -22,   37,  -14,  4,  6,  0 }, {    -23,   38,  -15,  4,  6,  0 },
    {    -24,   39,  -16,  4,  6,  0 }, {    -25,   39,  -17,  4,  6,  0 }, {    -26,   40,  -17,  4,  6,  0 }, {    -27,   41,  -18,  4,  6,  0 }, {    -28,   42,  -18,  4,  6,  0 },
    {    -29,   43,  -19,  4,  6,  0 }, {    -29,   44,  -20,  4,  6,  0 }, {    -30,   45,  -20,  5,  6,  0 }, {    -31,   46,  -21,  5,  6,  0 }, {    -32,   47,  -22,  5,  6,  0 },
    {    -32,   48,  -22,  5,  6,  0 }, {    -33,   49,  -23,  5,  6,  0 }, {    -34,   50,  -23,  5,  6,  0 }, {    -34,   51,  -24,  5,  6,  0 }, {    -35,   52,  -25,  5,  6,  0 },
    {    -36,   53,  -25,  5,  6,  0 }, {    -36,   54,  -26,  5,  6,  0 }, {    -37,   55,  -26,  5,  6,  0 }, {    -38,   56,  -27,  5,  6,  0 }, {    -38,   57,  -28,  5,  6,  0 },
    {    -39,   58,  -28,  6,  6,  0 }, {    -39,   59,  -29,  6,  6,  0 }, {    -40,   60,  -29,  6,  6,  0 }, {    -40,   61,  -30,  6,  6,  0 }, {    -41,   62,  -31,  6,  6,  0 },
    {    -41,   63,  -31,  6,  6,  0 }, {    -42,   64,  -32,  6,  6,  0 }, {    -42,   65,  -32,  6,  6,  0 }, {    -43,   66,  -33,  6,  6,  0 }, {    -43,   67,  -34,  6,  6,  0 },
    {    -43,   68,  -34,  6,  6,  0 }, {    -44,   69,  -35,  6,  6,  0 }, {    -44,   70,  -35,  6,  6,  0 }, {    -44,   71,  -36,  6,  6,  0 }, {    -45,   72,  -36,  7,  6,  0 },
    {    -45,   73,  -37,  7,  6,  0 }, {    -45,   74,  -37,  7,  6,  0 }, {    -45,   75,  -38,  7,  6,  0 }, {    -46,   76,  -38,  7,  6,  0 }, {    -46,   77,  -39,  7,  6,  0 },
    {    -46,   78,  -39,  7,  6,  0 }, {    -46,   79,  -40,  7,  6,  0 }, {    -46,   80,  -40,  7,  6,  0 }, {    -47,   81,  -41,  7,  6,  0 }, {    -47,   82,  -42,  7,  6,  0 },
    {    -47,   83,  -42,  7,  6,  0 }, {    -47,   84,  -43,  7,  6,  0 }, {    -47,   85,  -43,  7,  6,  0 }, {    -47,   86,  -43,  7,  6,  0 }, {    -48,   87,  -44,  7,  6,  0 },
    {    -48,   88,  -45,  8,  6,  0 }, {    -48,   89,  -45,  8,  6,  0 }, {    -48,   90,  -46,  8,  6,  0 }, {    -48,   91,  -46,  8,  6,  0 }, {    -48,   92,  -47,  8,  6,  0 },
    {    -48,   93,  -47,  8,  6,  0 }, {    -48,   94,  -48,  8,  6,  0 }, {    -48,   95,  -48,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D38A9, {
    {     16,    0,   15,  8,  6,  0 }, {     16,    1,   15,  8,  6,  0 }, {     16,    2,   15,  8,  6,  0 }, {     16,    3,   14,  8,  6,  0 }, {     16,    4,   14,  8,  6,  0 },
    {     16,    5,   13,  8,  6,  0 }, {     16,    6,   13,  8,  6,  0 }, {     16,    7,   12,  8,  6,  0 }, {     16,    8,   12,  9,  6,  0 }, {     17,    9,   11,  9,  6,  0 },
    {     17,   10,   10,  9,  6,  0 }, {     17,   11,   10,  9,  6,  0 }, {     17,   12,   10,  9,  6,  0 }, {     17,   13,    9,  9,  6,  0 }, {     17,   14,    9,  9,  6,  0 },
    {     18,   15,    8,  9,  6,  0 }, {     18,   16,    7,  9,  6,  0 }, {     18,   17,    7,  9,  6,  0 }, {     18,   18,    6,  9,  6,  0 }, {     18,   19,    6,  9,  6,  0 },
    {     19,   20,    5,  9,  6,  0 }, {     19,   21,    5,  9,  6,  0 }, {     19,   22,    4, 10,  6,  0 }, {     19,   23,    4, 10,  6,  0 }, {     20,   24,    3, 10,  6,  0 },
    {     20,   25,    3, 10,  6,  0 }, {     20,   26,    2, 10,  6,  0 }, {     21,   27,    2, 10,  6,  0 }, {     21,   28,    1, 10,  6,  0 }, {     21,   29,    1, 10,  6,  0 },
    {     22,   30,    0, 10,  6,  0 }, {     22,   31,   -1, 10,  6,  0 }, {     23,   32,   -1, 10,  6,  0 }, {     23,   33,   -2, 10,  6,  0 }, {     24,   34,   -2, 10,  6,  0 },
    {     24,   35,   -3, 10,  6,  0 }, {     25,   36,   -3, 10,  6,  0 }, {     25,   37,   -4, 11,  6,  0 }, {     26,   38,   -5, 11,  6,  0 }, {     26,   39,   -5, 11,  6,  0 },
    {     27,   40,   -6, 11,  6,  0 }, {     28,   41,   -6, 11,  6,  0 }, {     28,   42,   -7, 11,  6,  0 }, {     29,   43,   -8, 11,  6,  0 }, {     30,   44,   -8, 11,  6,  0 },
    {     30,   45,   -9, 11,  6,  0 }, {     31,   46,   -9, 11,  6,  0 }, {     32,   47,  -10, 11,  6,  0 }, {     32,   48,  -11, 11,  6,  0 }, {     33,   49,  -11, 11,  6,  0 },
    {     34,   50,  -12, 12,  6,  0 }, {     35,   51,  -13, 12,  6,  0 }, {     35,   52,  -13, 12,  6,  0 }, {     36,   53,  -14, 12,  6,  0 }, {     37,   54,  -14, 12,  6,  0 },
    {     38,   55,  -15, 12,  6,  0 }, {     39,   56,  -16, 12,  6,  0 }, {     39,   57,  -17, 12,  6,  0 }, {     40,   58,  -17, 12,  6,  0 }, {     41,   59,  -18, 12,  6,  0 },
    {     42,   60,  -18, 12,  6,  0 }, {     43,   61,  -19, 12,  6,  0 }, {     44,   61,  -20, 12,  6,  0 }, {     45,   62,  -20, 13,  6,  0 }, {     46,   63,  -21, 13,  6,  0 },
    {     47,   64,  -22, 13,  6,  0 }, {     48,   64,  -22, 13,  6,  0 }, {     49,   65,  -23, 13,  6,  0 }, {     50,   66,  -23, 13,  6,  0 }, {     51,   66,  -24, 13,  6,  0 },
    {     52,   67,  -25, 13,  6,  0 }, {     53,   68,  -25, 13,  6,  0 }, {     54,   68,  -26, 13,  6,  0 }, {     55,   69,  -26, 13,  6,  0 }, {     56,   70,  -27, 13,  6,  0 },
    {     57,   70,  -28, 13,  6,  0 }, {     58,   71,  -28, 14,  6,  0 }, {     59,   71,  -29, 14,  6,  0 }, {     60,   72,  -29, 14,  6,  0 }, {     61,   72,  -30, 14,  6,  0 },
    {     62,   73,  -31, 14,  6,  0 }, {     63,   73,  -31, 14,  6,  0 }, {     64,   74,  -32, 14,  6,  0 }, {     65,   74,  -32, 14,  6,  0 }, {     66,   75,  -33, 14,  6,  0 },
    {     67,   75,  -34, 14,  6,  0 }, {     68,   75,  -34, 14,  6,  0 }, {     69,   76,  -35, 14,  6,  0 }, {     70,   76,  -35, 14,  6,  0 }, {     71,   76,  -36, 14,  6,  0 },
    {     72,   77,  -36, 15,  6,  0 }, {     73,   77,  -37, 15,  6,  0 }, {     74,   77,  -37, 15,  6,  0 }, {     75,   77,  -38, 15,  6,  0 }, {     76,   78,  -38, 15,  6,  0 },
    {     77,   78,  -39, 15,  6,  0 }, {     78,   78,  -39, 15,  6,  0 }, {     79,   78,  -40, 15,  6,  0 }, {     80,   78,  -40, 15,  6,  0 }, {     81,   79,  -41, 15,  6,  0 },
    {     82,   79,  -42, 15,  6,  0 }, {     83,   79,  -42, 15,  6,  0 }, {     84,   79,  -43, 15,  6,  0 }, {     85,   79,  -43, 15,  6,  0 }, {     86,   79,  -43, 15,  6,  0 },
    {     87,   80,  -44, 15,  6,  0 }, {     88,   80,  -45, 16,  6,  0 }, {     89,   80,  -45, 16,  6,  0 }, {     90,   80,  -46, 16,  6,  0 }, {     91,   80,  -46, 16,  6,  0 },
    {     92,   80,  -47, 16,  6,  0 }, {     93,   80,  -47, 16,  6,  0 }, {     94,   80,  -48, 16,  6,  0 }, {     95,   80,  -48, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D3CAD, {
    {      0,   16,   15, 16,  6,  0 }, {      1,   16,   15, 16,  6,  0 }, {      2,   16,   15, 16,  6,  0 }, {      3,   16,   14, 16,  6,  0 }, {      4,   16,   14, 16,  6,  0 },
    {      5,   16,   13, 16,  6,  0 }, {      6,   16,   13, 16,  6,  0 }, {      7,   16,   12, 16,  6,  0 }, {      8,   16,   12, 17,  6,  0 }, {      9,   15,   11, 17,  6,  0 },
    {     10,   15,   11, 17,  6,  0 }, {     11,   15,   10, 17,  6,  0 }, {     12,   15,   10, 17,  6,  0 }, {     13,   15,    9, 17,  6,  0 }, {     14,   15,    9, 17,  6,  0 },
    {     15,   14,    8, 17,  6,  0 }, {     16,   14,    7, 17,  6,  0 }, {     17,   14,    7, 17,  6,  0 }, {     18,   14,    7, 17,  6,  0 }, {     19,   14,    6, 17,  6,  0 },
    {     20,   13,    6, 17,  6,  0 }, {     21,   13,    5, 17,  6,  0 }, {     22,   13,    4, 18,  6,  0 }, {     23,   13,    4, 18,  6,  0 }, {     24,   12,    3, 18,  6,  0 },
    {     25,   12,    3, 18,  6,  0 }, {     26,   12,    2, 18,  6,  0 }, {     27,   11,    2, 18,  6,  0 }, {     28,   11,    1, 18,  6,  0 }, {     29,   11,    1, 18,  6,  0 },
    {     30,   10,    0, 18,  6,  0 }, {     31,   10,    0, 18,  6,  0 }, {     32,    9,   -1, 18,  6,  0 }, {     33,    9,   -2, 18,  6,  0 }, {     34,    8,   -2, 18,  6,  0 },
    {     35,    8,   -3, 18,  6,  0 }, {     36,    7,   -3, 18,  6,  0 }, {     37,    7,   -4, 19,  6,  0 }, {     38,    6,   -4, 19,  6,  0 }, {     39,    6,   -5, 19,  6,  0 },
    {     40,    5,   -6, 19,  6,  0 }, {     41,    4,   -6, 19,  6,  0 }, {     42,    4,   -7, 19,  6,  0 }, {     43,    3,   -7, 19,  6,  0 }, {     44,    2,   -8, 19,  6,  0 },
    {     45,    2,   -9, 19,  6,  0 }, {     46,    1,   -9, 19,  6,  0 }, {     47,    0,  -10, 19,  6,  0 }, {     48,    0,  -11, 19,  6,  0 }, {     49,   -1,  -11, 19,  6,  0 },
    {     50,   -2,  -12, 20,  6,  0 }, {     51,   -3,  -12, 20,  6,  0 }, {     52,   -3,  -13, 20,  6,  0 }, {     53,   -4,  -14, 20,  6,  0 }, {     54,   -5,  -14, 20,  6,  0 },
    {     55,   -6,  -15, 20,  6,  0 }, {     56,   -7,  -16, 20,  6,  0 }, {     57,   -7,  -16, 20,  6,  0 }, {     58,   -8,  -17, 20,  6,  0 }, {     59,   -9,  -17, 20,  6,  0 },
    {     60,  -10,  -18, 20,  6,  0 }, {     61,  -11,  -19, 20,  6,  0 }, {     61,  -12,  -19, 20,  6,  0 }, {     62,  -13,  -20, 21,  6,  0 }, {     63,  -14,  -21, 21,  6,  0 },
    {     64,  -15,  -21, 21,  6,  0 }, {     64,  -16,  -22, 21,  6,  0 }, {     65,  -17,  -22, 21,  6,  0 }, {     66,  -18,  -23, 21,  6,  0 }, {     66,  -19,  -24, 21,  6,  0 },
    {     67,  -20,  -24, 21,  6,  0 }, {     68,  -21,  -25, 21,  6,  0 }, {     68,  -22,  -26, 21,  6,  0 }, {     69,  -23,  -26, 21,  6,  0 }, {     70,  -24,  -27, 21,  6,  0 },
    {     70,  -25,  -27, 21,  6,  0 }, {     71,  -26,  -28, 22,  6,  0 }, {     71,  -27,  -29, 22,  6,  0 }, {     72,  -28,  -29, 22,  6,  0 }, {     72,  -29,  -30, 22,  6,  0 },
    {     73,  -30,  -30, 22,  6,  0 }, {     73,  -31,  -31, 22,  6,  0 }, {     74,  -32,  -31, 22,  6,  0 }, {     74,  -33,  -32, 22,  6,  0 }, {     75,  -34,  -33, 22,  6,  0 },
    {     75,  -35,  -33, 22,  6,  0 }, {     75,  -36,  -34, 22,  6,  0 }, {     76,  -37,  -34, 22,  6,  0 }, {     76,  -38,  -35, 22,  6,  0 }, {     76,  -39,  -35, 22,  6,  0 },
    {     77,  -40,  -36, 23,  6,  0 }, {     77,  -41,  -36, 23,  6,  0 }, {     77,  -42,  -37, 23,  6,  0 }, {     77,  -43,  -37, 23,  6,  0 }, {     78,  -44,  -38, 23,  6,  0 },
    {     78,  -45,  -39, 23,  6,  0 }, {     78,  -46,  -39, 23,  6,  0 }, {     78,  -47,  -40, 23,  6,  0 }, {     78,  -48,  -40, 23,  6,  0 }, {     79,  -49,  -40, 23,  6,  0 },
    {     79,  -50,  -41, 23,  6,  0 }, {     79,  -51,  -42, 23,  6,  0 }, {     79,  -52,  -42, 23,  6,  0 }, {     79,  -53,  -43, 23,  6,  0 }, {     79,  -54,  -43, 23,  6,  0 },
    {     80,  -55,  -44, 23,  6,  0 }, {     80,  -56,  -44, 24,  6,  0 }, {     80,  -57,  -45, 24,  6,  0 }, {     80,  -58,  -45, 24,  6,  0 }, {     80,  -59,  -46, 24,  6,  0 },
    {     80,  -60,  -46, 24,  6,  0 }, {     80,  -61,  -47, 24,  6,  0 }, {     80,  -62,  -47, 24,  6,  0 }, {     80,  -63,  -48, 24,  6,  0 }, {     80,  -64,  -49, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D40BA, {
    {     16,   31,   15, 24,  6,  0 }, {     16,   30,   15, 24,  6,  0 }, {     16,   29,   14, 24,  6,  0 }, {     16,   28,   14, 24,  6,  0 }, {     16,   27,   13, 24,  6,  0 },
    {     16,   26,   13, 24,  6,  0 }, {     16,   25,   12, 24,  6,  0 }, {     16,   24,   12, 25,  6,  0 }, {     15,   23,   11, 25,  6,  0 }, {     15,   22,   11, 25,  6,  0 },
    {     15,   21,   10, 25,  6,  0 }, {     15,   20,   10, 25,  6,  0 }, {     15,   19,    9, 25,  6,  0 }, {     15,   18,    9, 25,  6,  0 }, {     14,   17,    8, 25,  6,  0 },
    {     14,   16,    7, 25,  6,  0 }, {     14,   15,    7, 25,  6,  0 }, {     14,   14,    7, 25,  6,  0 }, {     14,   13,    6, 25,  6,  0 }, {     13,   12,    6, 25,  6,  0 },
    {     13,   11,    5, 25,  6,  0 }, {     13,   10,    4, 26,  6,  0 }, {     13,    9,    4, 26,  6,  0 }, {     12,    8,    3, 26,  6,  0 }, {     12,    7,    3, 26,  6,  0 },
    {     12,    6,    2, 26,  6,  0 }, {     11,    5,    2, 26,  6,  0 }, {     11,    4,    1, 26,  6,  0 }, {     11,    3,    1, 26,  6,  0 }, {     10,    2,    0, 26,  6,  0 },
    {     10,    1,    0, 26,  6,  0 }, {      9,    0,   -1, 26,  6,  0 }, {      9,   -1,   -2, 26,  6,  0 }, {      8,   -2,   -2, 26,  6,  0 }, {      8,   -3,   -3, 26,  6,  0 },
    {      7,   -4,   -3, 26,  6,  0 }, {      7,   -5,   -4, 27,  6,  0 }, {      6,   -6,   -4, 27,  6,  0 }, {      6,   -7,   -5, 27,  6,  0 }, {      5,   -8,   -6, 27,  6,  0 },
    {      4,   -9,   -6, 27,  6,  0 }, {      4,  -10,   -7, 27,  6,  0 }, {      3,  -11,   -7, 27,  6,  0 }, {      2,  -12,   -8, 27,  6,  0 }, {      2,  -13,   -9, 27,  6,  0 },
    {      1,  -14,   -9, 27,  6,  0 }, {      0,  -15,  -10, 27,  6,  0 }, {      0,  -16,  -11, 27,  6,  0 }, {     -1,  -17,  -11, 27,  6,  0 }, {     -2,  -18,  -12, 28,  6,  0 },
    {     -3,  -19,  -12, 28,  6,  0 }, {     -3,  -20,  -13, 28,  6,  0 }, {     -4,  -21,  -14, 28,  6,  0 }, {     -5,  -22,  -14, 28,  6,  0 }, {     -6,  -23,  -15, 28,  6,  0 },
    {     -7,  -24,  -16, 28,  6,  0 }, {     -7,  -25,  -16, 28,  6,  0 }, {     -8,  -26,  -17, 28,  6,  0 }, {     -9,  -27,  -17, 28,  6,  0 }, {    -10,  -28,  -18, 28,  6,  0 },
    {    -11,  -29,  -19, 28,  6,  0 }, {    -12,  -29,  -19, 28,  6,  0 }, {    -13,  -30,  -20, 29,  6,  0 }, {    -14,  -31,  -21, 29,  6,  0 }, {    -15,  -32,  -21, 29,  6,  0 },
    {    -16,  -32,  -22, 29,  6,  0 }, {    -17,  -33,  -22, 29,  6,  0 }, {    -18,  -34,  -23, 29,  6,  0 }, {    -19,  -34,  -24, 29,  6,  0 }, {    -20,  -35,  -24, 29,  6,  0 },
    {    -21,  -36,  -25, 29,  6,  0 }, {    -22,  -36,  -26, 29,  6,  0 }, {    -23,  -37,  -26, 29,  6,  0 }, {    -24,  -38,  -27, 29,  6,  0 }, {    -25,  -38,  -27, 29,  6,  0 },
    {    -26,  -39,  -28, 30,  6,  0 }, {    -27,  -39,  -29, 30,  6,  0 }, {    -28,  -40,  -29, 30,  6,  0 }, {    -29,  -40,  -30, 30,  6,  0 }, {    -30,  -41,  -30, 30,  6,  0 },
    {    -31,  -41,  -31, 30,  6,  0 }, {    -32,  -42,  -31, 30,  6,  0 }, {    -33,  -42,  -32, 30,  6,  0 }, {    -34,  -43,  -33, 30,  6,  0 }, {    -35,  -43,  -33, 30,  6,  0 },
    {    -36,  -43,  -34, 30,  6,  0 }, {    -37,  -44,  -34, 30,  6,  0 }, {    -38,  -44,  -35, 30,  6,  0 }, {    -39,  -44,  -35, 30,  6,  0 }, {    -40,  -45,  -36, 31,  6,  0 },
    {    -41,  -45,  -36, 31,  6,  0 }, {    -42,  -45,  -37, 31,  6,  0 }, {    -43,  -45,  -37, 31,  6,  0 }, {    -44,  -46,  -38, 31,  6,  0 }, {    -45,  -46,  -39, 31,  6,  0 },
    {    -46,  -46,  -39, 31,  6,  0 }, {    -47,  -46,  -40, 31,  6,  0 }, {    -48,  -46,  -40, 31,  6,  0 }, {    -49,  -47,  -40, 31,  6,  0 }, {    -50,  -47,  -41, 31,  6,  0 },
    {    -51,  -47,  -42, 31,  6,  0 }, {    -52,  -47,  -42, 31,  6,  0 }, {    -53,  -47,  -43, 31,  6,  0 }, {    -54,  -47,  -43, 31,  6,  0 }, {    -55,  -48,  -44, 31,  6,  0 },
    {    -56,  -48,  -44,  0,  6,  0 }, {    -57,  -48,  -45,  0,  6,  0 }, {    -58,  -48,  -45,  0,  6,  0 }, {    -59,  -48,  -46,  0,  6,  0 }, {    -60,  -48,  -46,  0,  6,  0 },
    {    -61,  -48,  -47,  0,  6,  0 }, {    -62,  -48,  -47,  0,  6,  0 }, {    -63,  -48,  -48,  0,  6,  0 }, {    -64,  -48,  -49,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC0D2, {
    {     32,   16,    0,  0,  0,  0 }, {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 },
    {     27,   16,    0,  0,  0,  0 }, {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0, 31,  0,  0 }, {     23,   15,    0, 31,  0,  0 },
    {     22,   15,    0, 31,  0,  0 }, {     21,   15,    0, 31,  0,  0 }, {     20,   15,    0, 31,  0,  0 }, {     19,   15,    0, 31,  0,  0 }, {     18,   15,    0, 31,  0,  0 },
    {     17,   14,    0, 31,  0,  0 }, {     16,   14,    0, 31,  0,  0 }, {     15,   14,    0, 31,  0,  0 }, {     14,   14,    0, 31,  0,  0 }, {     13,   14,    0, 31,  0,  0 },
    {     12,   13,    0, 31,  0,  0 }, {     11,   13,    0, 31,  0,  0 }, {     10,   13,    0, 30,  0,  0 }, {      9,   13,    0, 30,  0,  0 }, {      8,   12,    0, 30,  0,  0 },
    {      7,   12,    0, 30,  0,  0 }, {      6,   12,    0, 30,  0,  0 }, {      5,   11,    0, 30,  0,  0 }, {      4,   11,    0, 30,  0,  0 }, {      3,   11,    0, 30,  0,  0 },
    {      2,   10,    0, 30,  0,  0 }, {      1,   10,    0, 30,  0,  0 }, {      0,    9,    0, 30,  0,  0 }, {     -1,    9,    0, 30,  0,  0 }, {     -2,    8,    0, 30,  0,  0 },
    {     -3,    8,    0, 30,  0,  0 }, {     -4,    7,    0, 29,  0,  0 }, {     -5,    7,    0, 29,  0,  0 }, {     -6,    6,    0, 29,  0,  0 }, {     -7,    6,    0, 29,  0,  0 },
    {     -8,    5,    0, 29,  0,  0 }, {     -9,    4,    0, 29,  0,  0 }, {    -10,    4,    0, 29,  0,  0 }, {    -11,    3,    0, 29,  0,  0 }, {    -12,    2,    0, 29,  0,  0 },
    {    -13,    2,    0, 29,  0,  0 }, {    -14,    1,    0, 29,  0,  0 }, {    -15,    0,    0, 29,  0,  0 }, {    -16,    0,    0, 29,  0,  0 }, {    -17,   -1,    0, 29,  0,  0 },
    {    -18,   -2,    0, 29,  0,  0 }, {    -19,   -2,    0, 29,  0,  0 }, {    -20,   -3,    0, 29,  0,  0 }, {    -21,   -4,    0, 29,  0,  0 }, {    -22,   -4,    0, 29,  0,  0 },
    {    -23,   -5,    0, 29,  0,  0 }, {    -24,   -6,    0, 29,  0,  0 }, {    -25,   -6,    0, 29,  0,  0 }, {    -26,   -7,    0, 29,  0,  0 }, {    -27,   -7,    0, 29,  0,  0 },
    {    -28,   -8,    0, 30,  0,  0 }, {    -29,   -8,    0, 30,  0,  0 }, {    -30,   -9,    0, 30,  0,  0 }, {    -31,   -9,    0, 30,  0,  0 }, {    -32,  -10,    0, 30,  0,  0 },
    {    -33,  -10,    0, 30,  0,  0 }, {    -34,  -11,    0, 30,  0,  0 }, {    -35,  -11,    0, 30,  0,  0 }, {    -36,  -11,    0, 30,  0,  0 }, {    -37,  -12,    0, 30,  0,  0 },
    {    -38,  -12,    0, 30,  0,  0 }, {    -39,  -12,    0, 30,  0,  0 }, {    -40,  -13,    0, 30,  0,  0 }, {    -41,  -13,    0, 31,  0,  0 }, {    -42,  -13,    0, 31,  0,  0 },
    {    -43,  -13,    0, 31,  0,  0 }, {    -44,  -14,    0, 31,  0,  0 }, {    -45,  -14,    0, 31,  0,  0 }, {    -46,  -14,    0, 31,  0,  0 }, {    -47,  -14,    0, 31,  0,  0 },
    {    -48,  -14,    0, 31,  0,  0 }, {    -49,  -15,    0, 31,  0,  0 }, {    -50,  -15,    0, 31,  0,  0 }, {    -51,  -15,    0, 31,  0,  0 }, {    -52,  -15,    0, 31,  0,  0 },
    {    -53,  -15,    0, 31,  0,  0 }, {    -54,  -15,    0, 31,  0,  0 }, {    -55,  -16,    0, 31,  0,  0 }, {    -56,  -16,    0,  0,  0,  0 }, {    -57,  -16,    0,  0,  0,  0 },
    {    -58,  -16,    0,  0,  0,  0 }, {    -59,  -16,    0,  0,  0,  0 }, {    -60,  -16,    0,  0,  0,  0 }, {    -61,  -16,    0,  0,  0,  0 }, {    -62,  -16,    0,  0,  0,  0 },
    {    -63,  -16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC434, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  7,  0,  0 }, {     15,    9,    0,  7,  0,  0 },
    {     15,   10,    0,  7,  0,  0 }, {     15,   11,    0,  7,  0,  0 }, {     15,   12,    0,  7,  0,  0 }, {     15,   13,    0,  7,  0,  0 }, {     15,   14,    0,  7,  0,  0 },
    {     14,   15,    0,  7,  0,  0 }, {     14,   16,    0,  7,  0,  0 }, {     14,   17,    0,  7,  0,  0 }, {     14,   18,    0,  7,  0,  0 }, {     14,   19,    0,  7,  0,  0 },
    {     13,   20,    0,  7,  0,  0 }, {     13,   21,    0,  7,  0,  0 }, {     13,   22,    0,  6,  0,  0 }, {     13,   23,    0,  6,  0,  0 }, {     12,   24,    0,  6,  0,  0 },
    {     12,   25,    0,  6,  0,  0 }, {     12,   26,    0,  6,  0,  0 }, {     11,   27,    0,  6,  0,  0 }, {     11,   28,    0,  6,  0,  0 }, {     11,   29,    0,  6,  0,  0 },
    {     10,   30,    0,  6,  0,  0 }, {     10,   31,    0,  6,  0,  0 }, {      9,   32,    0,  6,  0,  0 }, {      9,   33,    0,  6,  0,  0 }, {      8,   34,    0,  6,  0,  0 },
    {      8,   35,    0,  6,  0,  0 }, {      7,   36,    0,  5,  0,  0 }, {      7,   37,    0,  5,  0,  0 }, {      6,   38,    0,  5,  0,  0 }, {      6,   39,    0,  5,  0,  0 },
    {      5,   40,    0,  5,  0,  0 }, {      4,   41,    0,  5,  0,  0 }, {      4,   42,    0,  5,  0,  0 }, {      3,   43,    0,  5,  0,  0 }, {      2,   44,    0,  5,  0,  0 },
    {      2,   45,    0,  5,  0,  0 }, {      1,   46,    0,  5,  0,  0 }, {      0,   47,    0,  5,  0,  0 }, {      0,   48,    0,  5,  0,  0 }, {     -1,   49,    0,  5,  0,  0 },
    {     -2,   50,    0,  5,  0,  0 }, {     -2,   51,    0,  5,  0,  0 }, {     -3,   52,    0,  5,  0,  0 }, {     -4,   53,    0,  5,  0,  0 }, {     -4,   54,    0,  5,  0,  0 },
    {     -5,   55,    0,  5,  0,  0 }, {     -6,   56,    0,  5,  0,  0 }, {     -6,   57,    0,  5,  0,  0 }, {     -7,   58,    0,  5,  0,  0 }, {     -7,   59,    0,  5,  0,  0 },
    {     -8,   60,    0,  6,  0,  0 }, {     -8,   61,    0,  6,  0,  0 }, {     -9,   62,    0,  6,  0,  0 }, {     -9,   63,    0,  6,  0,  0 }, {    -10,   64,    0,  6,  0,  0 },
    {    -10,   65,    0,  6,  0,  0 }, {    -11,   66,    0,  6,  0,  0 }, {    -11,   67,    0,  6,  0,  0 }, {    -11,   68,    0,  6,  0,  0 }, {    -12,   69,    0,  6,  0,  0 },
    {    -12,   70,    0,  6,  0,  0 }, {    -12,   71,    0,  6,  0,  0 }, {    -13,   72,    0,  6,  0,  0 }, {    -13,   73,    0,  7,  0,  0 }, {    -13,   74,    0,  7,  0,  0 },
    {    -13,   75,    0,  7,  0,  0 }, {    -14,   76,    0,  7,  0,  0 }, {    -14,   77,    0,  7,  0,  0 }, {    -14,   78,    0,  7,  0,  0 }, {    -14,   79,    0,  7,  0,  0 },
    {    -14,   80,    0,  7,  0,  0 }, {    -15,   81,    0,  7,  0,  0 }, {    -15,   82,    0,  7,  0,  0 }, {    -15,   83,    0,  7,  0,  0 }, {    -15,   84,    0,  7,  0,  0 },
    {    -15,   85,    0,  7,  0,  0 }, {    -15,   86,    0,  7,  0,  0 }, {    -16,   87,    0,  7,  0,  0 }, {    -16,   88,    0,  8,  0,  0 }, {    -16,   89,    0,  8,  0,  0 },
    {    -16,   90,    0,  8,  0,  0 }, {    -16,   91,    0,  8,  0,  0 }, {    -16,   92,    0,  8,  0,  0 }, {    -16,   93,    0,  8,  0,  0 }, {    -16,   94,    0,  8,  0,  0 },
    {    -16,   95,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CC796, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 15,  0,  0 }, {      9,   17,    0, 15,  0,  0 },
    {     10,   17,    0, 15,  0,  0 }, {     11,   17,    0, 15,  0,  0 }, {     12,   17,    0, 15,  0,  0 }, {     13,   17,    0, 15,  0,  0 }, {     14,   17,    0, 15,  0,  0 },
    {     15,   18,    0, 15,  0,  0 }, {     16,   18,    0, 15,  0,  0 }, {     17,   18,    0, 15,  0,  0 }, {     18,   18,    0, 15,  0,  0 }, {     19,   18,    0, 15,  0,  0 },
    {     20,   19,    0, 15,  0,  0 }, {     21,   19,    0, 15,  0,  0 }, {     22,   19,    0, 14,  0,  0 }, {     23,   19,    0, 14,  0,  0 }, {     24,   20,    0, 14,  0,  0 },
    {     25,   20,    0, 14,  0,  0 }, {     26,   20,    0, 14,  0,  0 }, {     27,   21,    0, 14,  0,  0 }, {     28,   21,    0, 14,  0,  0 }, {     29,   21,    0, 14,  0,  0 },
    {     30,   22,    0, 14,  0,  0 }, {     31,   22,    0, 14,  0,  0 }, {     32,   23,    0, 14,  0,  0 }, {     33,   23,    0, 14,  0,  0 }, {     34,   24,    0, 14,  0,  0 },
    {     35,   24,    0, 14,  0,  0 }, {     36,   25,    0, 13,  0,  0 }, {     37,   25,    0, 13,  0,  0 }, {     38,   26,    0, 13,  0,  0 }, {     39,   26,    0, 13,  0,  0 },
    {     40,   27,    0, 13,  0,  0 }, {     41,   28,    0, 13,  0,  0 }, {     42,   28,    0, 13,  0,  0 }, {     43,   29,    0, 13,  0,  0 }, {     44,   30,    0, 13,  0,  0 },
    {     45,   30,    0, 13,  0,  0 }, {     46,   31,    0, 13,  0,  0 }, {     47,   32,    0, 13,  0,  0 }, {     48,   32,    0, 13,  0,  0 }, {     49,   33,    0, 13,  0,  0 },
    {     50,   34,    0, 13,  0,  0 }, {     51,   34,    0, 13,  0,  0 }, {     52,   35,    0, 13,  0,  0 }, {     53,   36,    0, 13,  0,  0 }, {     54,   36,    0, 13,  0,  0 },
    {     55,   37,    0, 13,  0,  0 }, {     56,   38,    0, 13,  0,  0 }, {     57,   38,    0, 13,  0,  0 }, {     58,   39,    0, 13,  0,  0 }, {     59,   39,    0, 13,  0,  0 },
    {     60,   40,    0, 14,  0,  0 }, {     61,   40,    0, 14,  0,  0 }, {     62,   41,    0, 14,  0,  0 }, {     63,   41,    0, 14,  0,  0 }, {     64,   42,    0, 14,  0,  0 },
    {     65,   42,    0, 14,  0,  0 }, {     66,   43,    0, 14,  0,  0 }, {     67,   43,    0, 14,  0,  0 }, {     68,   43,    0, 14,  0,  0 }, {     69,   44,    0, 14,  0,  0 },
    {     70,   44,    0, 14,  0,  0 }, {     71,   44,    0, 14,  0,  0 }, {     72,   45,    0, 14,  0,  0 }, {     73,   45,    0, 15,  0,  0 }, {     74,   45,    0, 15,  0,  0 },
    {     75,   45,    0, 15,  0,  0 }, {     76,   46,    0, 15,  0,  0 }, {     77,   46,    0, 15,  0,  0 }, {     78,   46,    0, 15,  0,  0 }, {     79,   46,    0, 15,  0,  0 },
    {     80,   46,    0, 15,  0,  0 }, {     81,   47,    0, 15,  0,  0 }, {     82,   47,    0, 15,  0,  0 }, {     83,   47,    0, 15,  0,  0 }, {     84,   47,    0, 15,  0,  0 },
    {     85,   47,    0, 15,  0,  0 }, {     86,   47,    0, 15,  0,  0 }, {     87,   48,    0, 15,  0,  0 }, {     88,   48,    0, 16,  0,  0 }, {     89,   48,    0, 16,  0,  0 },
    {     90,   48,    0, 16,  0,  0 }, {     91,   48,    0, 16,  0,  0 }, {     92,   48,    0, 16,  0,  0 }, {     93,   48,    0, 16,  0,  0 }, {     94,   48,    0, 16,  0,  0 },
    {     95,   48,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CCAF8, {
    {     16,   32,    0, 24,  0,  0 }, {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 },
    {     16,   27,    0, 24,  0,  0 }, {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 23,  0,  0 }, {     17,   23,    0, 23,  0,  0 },
    {     17,   22,    0, 23,  0,  0 }, {     17,   21,    0, 23,  0,  0 }, {     17,   20,    0, 23,  0,  0 }, {     17,   19,    0, 23,  0,  0 }, {     17,   18,    0, 23,  0,  0 },
    {     18,   17,    0, 23,  0,  0 }, {     18,   16,    0, 23,  0,  0 }, {     18,   15,    0, 23,  0,  0 }, {     18,   14,    0, 23,  0,  0 }, {     18,   13,    0, 23,  0,  0 },
    {     19,   12,    0, 23,  0,  0 }, {     19,   11,    0, 23,  0,  0 }, {     19,   10,    0, 22,  0,  0 }, {     19,    9,    0, 22,  0,  0 }, {     20,    8,    0, 22,  0,  0 },
    {     20,    7,    0, 22,  0,  0 }, {     20,    6,    0, 22,  0,  0 }, {     21,    5,    0, 22,  0,  0 }, {     21,    4,    0, 22,  0,  0 }, {     21,    3,    0, 22,  0,  0 },
    {     22,    2,    0, 22,  0,  0 }, {     22,    1,    0, 22,  0,  0 }, {     23,    0,    0, 22,  0,  0 }, {     23,   -1,    0, 22,  0,  0 }, {     24,   -2,    0, 22,  0,  0 },
    {     24,   -3,    0, 22,  0,  0 }, {     25,   -4,    0, 21,  0,  0 }, {     25,   -5,    0, 21,  0,  0 }, {     26,   -6,    0, 21,  0,  0 }, {     26,   -7,    0, 21,  0,  0 },
    {     27,   -8,    0, 21,  0,  0 }, {     28,   -9,    0, 21,  0,  0 }, {     28,  -10,    0, 21,  0,  0 }, {     29,  -11,    0, 21,  0,  0 }, {     30,  -12,    0, 21,  0,  0 },
    {     30,  -13,    0, 21,  0,  0 }, {     31,  -14,    0, 21,  0,  0 }, {     32,  -15,    0, 21,  0,  0 }, {     32,  -16,    0, 21,  0,  0 }, {     33,  -17,    0, 21,  0,  0 },
    {     34,  -18,    0, 21,  0,  0 }, {     34,  -19,    0, 21,  0,  0 }, {     35,  -20,    0, 21,  0,  0 }, {     36,  -21,    0, 21,  0,  0 }, {     36,  -22,    0, 21,  0,  0 },
    {     37,  -23,    0, 21,  0,  0 }, {     38,  -24,    0, 21,  0,  0 }, {     38,  -25,    0, 21,  0,  0 }, {     39,  -26,    0, 21,  0,  0 }, {     39,  -27,    0, 21,  0,  0 },
    {     40,  -28,    0, 22,  0,  0 }, {     40,  -29,    0, 22,  0,  0 }, {     41,  -30,    0, 22,  0,  0 }, {     41,  -31,    0, 22,  0,  0 }, {     42,  -32,    0, 22,  0,  0 },
    {     42,  -33,    0, 22,  0,  0 }, {     43,  -34,    0, 22,  0,  0 }, {     43,  -35,    0, 22,  0,  0 }, {     43,  -36,    0, 22,  0,  0 }, {     44,  -37,    0, 22,  0,  0 },
    {     44,  -38,    0, 22,  0,  0 }, {     44,  -39,    0, 22,  0,  0 }, {     45,  -40,    0, 22,  0,  0 }, {     45,  -41,    0, 23,  0,  0 }, {     45,  -42,    0, 23,  0,  0 },
    {     45,  -43,    0, 23,  0,  0 }, {     46,  -44,    0, 23,  0,  0 }, {     46,  -45,    0, 23,  0,  0 }, {     46,  -46,    0, 23,  0,  0 }, {     46,  -47,    0, 23,  0,  0 },
    {     46,  -48,    0, 23,  0,  0 }, {     47,  -49,    0, 23,  0,  0 }, {     47,  -50,    0, 23,  0,  0 }, {     47,  -51,    0, 23,  0,  0 }, {     47,  -52,    0, 23,  0,  0 },
    {     47,  -53,    0, 23,  0,  0 }, {     47,  -54,    0, 23,  0,  0 }, {     48,  -55,    0, 23,  0,  0 }, {     48,  -56,    0, 24,  0,  0 }, {     48,  -57,    0, 24,  0,  0 },
    {     48,  -58,    0, 24,  0,  0 }, {     48,  -59,    0, 24,  0,  0 }, {     48,  -60,    0, 24,  0,  0 }, {     48,  -61,    0, 24,  0,  0 }, {     48,  -62,    0, 24,  0,  0 },
    {     48,  -63,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CCE5A, {
    {     32,   16,    0,  0,  0,  0 }, {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 },
    {     27,   16,    0,  0,  0,  0 }, {     26,   16,    0,  0,  0,  0 }, {     25,   16,    0,  0,  0,  0 }, {     24,   16,    0,  1,  0,  0 }, {     23,   17,    0,  1,  0,  0 },
    {     22,   17,    0,  1,  0,  0 }, {     21,   17,    0,  1,  0,  0 }, {     20,   17,    0,  1,  0,  0 }, {     19,   17,    0,  1,  0,  0 }, {     18,   17,    0,  1,  0,  0 },
    {     17,   18,    0,  1,  0,  0 }, {     16,   18,    0,  1,  0,  0 }, {     15,   18,    0,  1,  0,  0 }, {     14,   18,    0,  1,  0,  0 }, {     13,   18,    0,  1,  0,  0 },
    {     12,   19,    0,  1,  0,  0 }, {     11,   19,    0,  1,  0,  0 }, {     10,   19,    0,  2,  0,  0 }, {      9,   19,    0,  2,  0,  0 }, {      8,   20,    0,  2,  0,  0 },
    {      7,   20,    0,  2,  0,  0 }, {      6,   20,    0,  2,  0,  0 }, {      5,   21,    0,  2,  0,  0 }, {      4,   21,    0,  2,  0,  0 }, {      3,   21,    0,  2,  0,  0 },
    {      2,   22,    0,  2,  0,  0 }, {      1,   22,    0,  2,  0,  0 }, {      0,   23,    0,  2,  0,  0 }, {     -1,   23,    0,  2,  0,  0 }, {     -2,   24,    0,  2,  0,  0 },
    {     -3,   24,    0,  2,  0,  0 }, {     -4,   25,    0,  3,  0,  0 }, {     -5,   25,    0,  3,  0,  0 }, {     -6,   26,    0,  3,  0,  0 }, {     -7,   26,    0,  3,  0,  0 },
    {     -8,   27,    0,  3,  0,  0 }, {     -9,   28,    0,  3,  0,  0 }, {    -10,   28,    0,  3,  0,  0 }, {    -11,   29,    0,  3,  0,  0 }, {    -12,   30,    0,  3,  0,  0 },
    {    -13,   30,    0,  3,  0,  0 }, {    -14,   31,    0,  3,  0,  0 }, {    -15,   32,    0,  3,  0,  0 }, {    -16,   32,    0,  3,  0,  0 }, {    -17,   33,    0,  3,  0,  0 },
    {    -18,   34,    0,  3,  0,  0 }, {    -19,   34,    0,  3,  0,  0 }, {    -20,   35,    0,  3,  0,  0 }, {    -21,   36,    0,  3,  0,  0 }, {    -22,   36,    0,  3,  0,  0 },
    {    -23,   37,    0,  3,  0,  0 }, {    -24,   38,    0,  3,  0,  0 }, {    -25,   38,    0,  3,  0,  0 }, {    -26,   39,    0,  3,  0,  0 }, {    -27,   39,    0,  3,  0,  0 },
    {    -28,   40,    0,  2,  0,  0 }, {    -29,   40,    0,  2,  0,  0 }, {    -30,   41,    0,  2,  0,  0 }, {    -31,   41,    0,  2,  0,  0 }, {    -32,   42,    0,  2,  0,  0 },
    {    -33,   42,    0,  2,  0,  0 }, {    -34,   43,    0,  2,  0,  0 }, {    -35,   43,    0,  2,  0,  0 }, {    -36,   43,    0,  2,  0,  0 }, {    -37,   44,    0,  2,  0,  0 },
    {    -38,   44,    0,  2,  0,  0 }, {    -39,   44,    0,  2,  0,  0 }, {    -40,   45,    0,  2,  0,  0 }, {    -41,   45,    0,  1,  0,  0 }, {    -42,   45,    0,  1,  0,  0 },
    {    -43,   45,    0,  1,  0,  0 }, {    -44,   46,    0,  1,  0,  0 }, {    -45,   46,    0,  1,  0,  0 }, {    -46,   46,    0,  1,  0,  0 }, {    -47,   46,    0,  1,  0,  0 },
    {    -48,   46,    0,  1,  0,  0 }, {    -49,   47,    0,  1,  0,  0 }, {    -50,   47,    0,  1,  0,  0 }, {    -51,   47,    0,  1,  0,  0 }, {    -52,   47,    0,  1,  0,  0 },
    {    -53,   47,    0,  1,  0,  0 }, {    -54,   47,    0,  1,  0,  0 }, {    -55,   48,    0,  1,  0,  0 }, {    -56,   48,    0,  0,  0,  0 }, {    -57,   48,    0,  0,  0,  0 },
    {    -58,   48,    0,  0,  0,  0 }, {    -59,   48,    0,  0,  0,  0 }, {    -60,   48,    0,  0,  0,  0 }, {    -61,   48,    0,  0,  0,  0 }, {    -62,   48,    0,  0,  0,  0 },
    {    -63,   48,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD1BC, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    0,  8,  0,  0 }, {     16,    7,    0,  8,  0,  0 }, {     16,    8,    0,  9,  0,  0 }, {     17,    9,    0,  9,  0,  0 },
    {     17,   10,    0,  9,  0,  0 }, {     17,   11,    0,  9,  0,  0 }, {     17,   12,    0,  9,  0,  0 }, {     17,   13,    0,  9,  0,  0 }, {     17,   14,    0,  9,  0,  0 },
    {     18,   15,    0,  9,  0,  0 }, {     18,   16,    0,  9,  0,  0 }, {     18,   17,    0,  9,  0,  0 }, {     18,   18,    0,  9,  0,  0 }, {     18,   19,    0,  9,  0,  0 },
    {     19,   20,    0,  9,  0,  0 }, {     19,   21,    0,  9,  0,  0 }, {     19,   22,    0, 10,  0,  0 }, {     19,   23,    0, 10,  0,  0 }, {     20,   24,    0, 10,  0,  0 },
    {     20,   25,    0, 10,  0,  0 }, {     20,   26,    0, 10,  0,  0 }, {     21,   27,    0, 10,  0,  0 }, {     21,   28,    0, 10,  0,  0 }, {     21,   29,    0, 10,  0,  0 },
    {     22,   30,    0, 10,  0,  0 }, {     22,   31,    0, 10,  0,  0 }, {     23,   32,    0, 10,  0,  0 }, {     23,   33,    0, 10,  0,  0 }, {     24,   34,    0, 10,  0,  0 },
    {     24,   35,    0, 10,  0,  0 }, {     25,   36,    0, 11,  0,  0 }, {     25,   37,    0, 11,  0,  0 }, {     26,   38,    0, 11,  0,  0 }, {     26,   39,    0, 11,  0,  0 },
    {     27,   40,    0, 11,  0,  0 }, {     28,   41,    0, 11,  0,  0 }, {     28,   42,    0, 11,  0,  0 }, {     29,   43,    0, 11,  0,  0 }, {     30,   44,    0, 11,  0,  0 },
    {     30,   45,    0, 11,  0,  0 }, {     31,   46,    0, 11,  0,  0 }, {     32,   47,    0, 11,  0,  0 }, {     32,   48,    0, 11,  0,  0 }, {     33,   49,    0, 11,  0,  0 },
    {     34,   50,    0, 11,  0,  0 }, {     34,   51,    0, 11,  0,  0 }, {     35,   52,    0, 11,  0,  0 }, {     36,   53,    0, 11,  0,  0 }, {     36,   54,    0, 11,  0,  0 },
    {     37,   55,    0, 11,  0,  0 }, {     38,   56,    0, 11,  0,  0 }, {     38,   57,    0, 11,  0,  0 }, {     39,   58,    0, 11,  0,  0 }, {     39,   59,    0, 11,  0,  0 },
    {     40,   60,    0, 10,  0,  0 }, {     40,   61,    0, 10,  0,  0 }, {     41,   62,    0, 10,  0,  0 }, {     41,   63,    0, 10,  0,  0 }, {     42,   64,    0, 10,  0,  0 },
    {     42,   65,    0, 10,  0,  0 }, {     43,   66,    0, 10,  0,  0 }, {     43,   67,    0, 10,  0,  0 }, {     43,   68,    0, 10,  0,  0 }, {     44,   69,    0, 10,  0,  0 },
    {     44,   70,    0, 10,  0,  0 }, {     44,   71,    0, 10,  0,  0 }, {     45,   72,    0, 10,  0,  0 }, {     45,   73,    0,  9,  0,  0 }, {     45,   74,    0,  9,  0,  0 },
    {     45,   75,    0,  9,  0,  0 }, {     46,   76,    0,  9,  0,  0 }, {     46,   77,    0,  9,  0,  0 }, {     46,   78,    0,  9,  0,  0 }, {     46,   79,    0,  9,  0,  0 },
    {     46,   80,    0,  9,  0,  0 }, {     47,   81,    0,  9,  0,  0 }, {     47,   82,    0,  9,  0,  0 }, {     47,   83,    0,  9,  0,  0 }, {     47,   84,    0,  9,  0,  0 },
    {     47,   85,    0,  9,  0,  0 }, {     47,   86,    0,  9,  0,  0 }, {     48,   87,    0,  9,  0,  0 }, {     48,   88,    0,  8,  0,  0 }, {     48,   89,    0,  8,  0,  0 },
    {     48,   90,    0,  8,  0,  0 }, {     48,   91,    0,  8,  0,  0 }, {     48,   92,    0,  8,  0,  0 }, {     48,   93,    0,  8,  0,  0 }, {     48,   94,    0,  8,  0,  0 },
    {     48,   95,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD51E, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    0, 16,  0,  0 }, {      7,   16,    0, 16,  0,  0 }, {      8,   16,    0, 17,  0,  0 }, {      9,   15,    0, 17,  0,  0 },
    {     10,   15,    0, 17,  0,  0 }, {     11,   15,    0, 17,  0,  0 }, {     12,   15,    0, 17,  0,  0 }, {     13,   15,    0, 17,  0,  0 }, {     14,   15,    0, 17,  0,  0 },
    {     15,   14,    0, 17,  0,  0 }, {     16,   14,    0, 17,  0,  0 }, {     17,   14,    0, 17,  0,  0 }, {     18,   14,    0, 17,  0,  0 }, {     19,   14,    0, 17,  0,  0 },
    {     20,   13,    0, 17,  0,  0 }, {     21,   13,    0, 17,  0,  0 }, {     22,   13,    0, 18,  0,  0 }, {     23,   13,    0, 18,  0,  0 }, {     24,   12,    0, 18,  0,  0 },
    {     25,   12,    0, 18,  0,  0 }, {     26,   12,    0, 18,  0,  0 }, {     27,   11,    0, 18,  0,  0 }, {     28,   11,    0, 18,  0,  0 }, {     29,   11,    0, 18,  0,  0 },
    {     30,   10,    0, 18,  0,  0 }, {     31,   10,    0, 18,  0,  0 }, {     32,    9,    0, 18,  0,  0 }, {     33,    9,    0, 18,  0,  0 }, {     34,    8,    0, 18,  0,  0 },
    {     35,    8,    0, 18,  0,  0 }, {     36,    7,    0, 19,  0,  0 }, {     37,    7,    0, 19,  0,  0 }, {     38,    6,    0, 19,  0,  0 }, {     39,    6,    0, 19,  0,  0 },
    {     40,    5,    0, 19,  0,  0 }, {     41,    4,    0, 19,  0,  0 }, {     42,    4,    0, 19,  0,  0 }, {     43,    3,    0, 19,  0,  0 }, {     44,    2,    0, 19,  0,  0 },
    {     45,    2,    0, 19,  0,  0 }, {     46,    1,    0, 19,  0,  0 }, {     47,    0,    0, 19,  0,  0 }, {     48,    0,    0, 19,  0,  0 }, {     49,   -1,    0, 19,  0,  0 },
    {     50,   -2,    0, 19,  0,  0 }, {     51,   -2,    0, 19,  0,  0 }, {     52,   -3,    0, 19,  0,  0 }, {     53,   -4,    0, 19,  0,  0 }, {     54,   -4,    0, 19,  0,  0 },
    {     55,   -5,    0, 19,  0,  0 }, {     56,   -6,    0, 19,  0,  0 }, {     57,   -6,    0, 19,  0,  0 }, {     58,   -7,    0, 19,  0,  0 }, {     59,   -7,    0, 19,  0,  0 },
    {     60,   -8,    0, 18,  0,  0 }, {     61,   -8,    0, 18,  0,  0 }, {     62,   -9,    0, 18,  0,  0 }, {     63,   -9,    0, 18,  0,  0 }, {     64,  -10,    0, 18,  0,  0 },
    {     65,  -10,    0, 18,  0,  0 }, {     66,  -11,    0, 18,  0,  0 }, {     67,  -11,    0, 18,  0,  0 }, {     68,  -11,    0, 18,  0,  0 }, {     69,  -12,    0, 18,  0,  0 },
    {     70,  -12,    0, 18,  0,  0 }, {     71,  -12,    0, 18,  0,  0 }, {     72,  -13,    0, 18,  0,  0 }, {     73,  -13,    0, 17,  0,  0 }, {     74,  -13,    0, 17,  0,  0 },
    {     75,  -13,    0, 17,  0,  0 }, {     76,  -14,    0, 17,  0,  0 }, {     77,  -14,    0, 17,  0,  0 }, {     78,  -14,    0, 17,  0,  0 }, {     79,  -14,    0, 17,  0,  0 },
    {     80,  -14,    0, 17,  0,  0 }, {     81,  -15,    0, 17,  0,  0 }, {     82,  -15,    0, 17,  0,  0 }, {     83,  -15,    0, 17,  0,  0 }, {     84,  -15,    0, 17,  0,  0 },
    {     85,  -15,    0, 17,  0,  0 }, {     86,  -15,    0, 17,  0,  0 }, {     87,  -16,    0, 17,  0,  0 }, {     88,  -16,    0, 16,  0,  0 }, {     89,  -16,    0, 16,  0,  0 },
    {     90,  -16,    0, 16,  0,  0 }, {     91,  -16,    0, 16,  0,  0 }, {     92,  -16,    0, 16,  0,  0 }, {     93,  -16,    0, 16,  0,  0 }, {     94,  -16,    0, 16,  0,  0 },
    {     95,  -16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8CD880, {
    {     16,   32,    0, 24,  0,  0 }, {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 },
    {     16,   27,    0, 24,  0,  0 }, {     16,   26,    0, 24,  0,  0 }, {     16,   25,    0, 24,  0,  0 }, {     16,   24,    0, 25,  0,  0 }, {     15,   23,    0, 25,  0,  0 },
    {     15,   22,    0, 25,  0,  0 }, {     15,   21,    0, 25,  0,  0 }, {     15,   20,    0, 25,  0,  0 }, {     15,   19,    0, 25,  0,  0 }, {     15,   18,    0, 25,  0,  0 },
    {     14,   17,    0, 25,  0,  0 }, {     14,   16,    0, 25,  0,  0 }, {     14,   15,    0, 25,  0,  0 }, {     14,   14,    0, 25,  0,  0 }, {     14,   13,    0, 25,  0,  0 },
    {     13,   12,    0, 25,  0,  0 }, {     13,   11,    0, 25,  0,  0 }, {     13,   10,    0, 26,  0,  0 }, {     13,    9,    0, 26,  0,  0 }, {     12,    8,    0, 26,  0,  0 },
    {     12,    7,    0, 26,  0,  0 }, {     12,    6,    0, 26,  0,  0 }, {     11,    5,    0, 26,  0,  0 }, {     11,    4,    0, 26,  0,  0 }, {     11,    3,    0, 26,  0,  0 },
    {     10,    2,    0, 26,  0,  0 }, {     10,    1,    0, 26,  0,  0 }, {      9,    0,    0, 26,  0,  0 }, {      9,   -1,    0, 26,  0,  0 }, {      8,   -2,    0, 26,  0,  0 },
    {      8,   -3,    0, 26,  0,  0 }, {      7,   -4,    0, 27,  0,  0 }, {      7,   -5,    0, 27,  0,  0 }, {      6,   -6,    0, 27,  0,  0 }, {      6,   -7,    0, 27,  0,  0 },
    {      5,   -8,    0, 27,  0,  0 }, {      4,   -9,    0, 27,  0,  0 }, {      4,  -10,    0, 27,  0,  0 }, {      3,  -11,    0, 27,  0,  0 }, {      2,  -12,    0, 27,  0,  0 },
    {      2,  -13,    0, 27,  0,  0 }, {      1,  -14,    0, 27,  0,  0 }, {      0,  -15,    0, 27,  0,  0 }, {      0,  -16,    0, 27,  0,  0 }, {     -1,  -17,    0, 27,  0,  0 },
    {     -2,  -18,    0, 27,  0,  0 }, {     -2,  -19,    0, 27,  0,  0 }, {     -3,  -20,    0, 27,  0,  0 }, {     -4,  -21,    0, 27,  0,  0 }, {     -4,  -22,    0, 27,  0,  0 },
    {     -5,  -23,    0, 27,  0,  0 }, {     -6,  -24,    0, 27,  0,  0 }, {     -6,  -25,    0, 27,  0,  0 }, {     -7,  -26,    0, 27,  0,  0 }, {     -7,  -27,    0, 27,  0,  0 },
    {     -8,  -28,    0, 26,  0,  0 }, {     -8,  -29,    0, 26,  0,  0 }, {     -9,  -30,    0, 26,  0,  0 }, {     -9,  -31,    0, 26,  0,  0 }, {    -10,  -32,    0, 26,  0,  0 },
    {    -10,  -33,    0, 26,  0,  0 }, {    -11,  -34,    0, 26,  0,  0 }, {    -11,  -35,    0, 26,  0,  0 }, {    -11,  -36,    0, 26,  0,  0 }, {    -12,  -37,    0, 26,  0,  0 },
    {    -12,  -38,    0, 26,  0,  0 }, {    -12,  -39,    0, 26,  0,  0 }, {    -13,  -40,    0, 26,  0,  0 }, {    -13,  -41,    0, 25,  0,  0 }, {    -13,  -42,    0, 25,  0,  0 },
    {    -13,  -43,    0, 25,  0,  0 }, {    -14,  -44,    0, 25,  0,  0 }, {    -14,  -45,    0, 25,  0,  0 }, {    -14,  -46,    0, 25,  0,  0 }, {    -14,  -47,    0, 25,  0,  0 },
    {    -14,  -48,    0, 25,  0,  0 }, {    -15,  -49,    0, 25,  0,  0 }, {    -15,  -50,    0, 25,  0,  0 }, {    -15,  -51,    0, 25,  0,  0 }, {    -15,  -52,    0, 25,  0,  0 },
    {    -15,  -53,    0, 25,  0,  0 }, {    -15,  -54,    0, 25,  0,  0 }, {    -16,  -55,    0, 25,  0,  0 }, {    -16,  -56,    0, 24,  0,  0 }, {    -16,  -57,    0, 24,  0,  0 },
    {    -16,  -58,    0, 24,  0,  0 }, {    -16,  -59,    0, 24,  0,  0 }, {    -16,  -60,    0, 24,  0,  0 }, {    -16,  -61,    0, 24,  0,  0 }, {    -16,  -62,    0, 24,  0,  0 },
    {    -16,  -63,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D44BE, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   15,    0,  0,  2,  0 }, {     29,   15,    1,  0,  2,  0 }, {     28,   15,    1,  0,  2,  0 }, {     27,   15,    2,  0,  2,  0 },
    {     26,   15,    2,  0,  2,  0 }, {     25,   15,    3,  0,  2,  0 }, {     24,   15,    3,  0,  2,  0 }, {     23,   15,    3,  0,  2,  0 }, {     22,   15,    4,  0,  2,  0 },
    {     21,   14,    4,  0,  2,  0 }, {     20,   14,    5,  0,  2,  0 }, {     19,   14,    5,  0,  2,  0 }, {     18,   14,    6,  0,  2,  0 }, {     17,   14,    6,  0,  2,  0 },
    {     16,   14,    7,  0,  2,  0 }, {     15,   14,    7,  0,  2,  0 }, {     14,   14,    8,  0,  2,  0 }, {     13,   14,    8,  0,  2,  0 }, {     12,   14,    9,  0,  3,  0 },
    {     11,   13,    9,  0,  3,  0 }, {     10,   13,   10,  0,  3,  0 }, {      9,   13,   10,  0,  3,  0 }, {      8,   13,   11,  0,  3,  0 }, {      7,   13,   11,  0,  3,  0 },
    {      6,   13,   12,  0,  3,  0 }, {      5,   13,   13,  0,  3,  0 }, {      4,   13,   14,  0,  3,  0 }, {      3,   13,   15,  0,  3,  0 }, {      2,   12,   15,  0,  3,  0 },
    {      1,   12,   16,  0,  3,  0 }, {      0,   12,   17,  0,  3,  0 }, {     -1,   12,   18,  0,  3,  0 }, {     -2,   12,   18,  0,  3,  0 }, {     -3,   12,   19,  0,  3,  0 },
    {     -4,   12,   20,  0,  3,  0 }, {     -5,   12,   21,  0,  3,  0 }, {     -6,   11,   22,  0,  3,  0 }, {     -7,   11,   23,  0,  3,  0 }, {     -8,   11,   24,  0,  3,  0 },
    {     -9,   11,   25,  0,  3,  0 }, {    -10,   11,   26,  0,  3,  0 }, {    -11,   11,   27,  0,  4,  0 }, {    -12,   11,   28,  0,  4,  0 }, {    -13,   11,   29,  0,  4,  0 },
    {    -13,   11,   30,  0,  4,  0 }, {    -14,   10,   31,  0,  4,  0 }, {    -15,   10,   32,  0,  4,  0 }, {    -16,   10,   33,  0,  4,  0 }, {    -16,   10,   34,  0,  4,  0 },
    {    -17,   10,   35,  0,  4,  0 }, {    -18,   10,   36,  0,  4,  0 }, {    -19,   10,   37,  0,  4,  0 }, {    -19,   10,   38,  0,  4,  0 }, {    -20,   10,   39,  0,  4,  0 },
    {    -20,    9,   40,  0,  4,  0 }, {    -21,    9,   41,  0,  4,  0 }, {    -22,    9,   42,  0,  4,  0 }, {    -22,    9,   43,  0,  9,  0 }, {    -23,    9,   44,  0,  9,  0 },
    {    -24,    9,   45,  0,  9,  0 }, {    -24,    9,   46,  0,  9,  0 }, {    -25,    9,   47,  0,  9,  0 }, {    -25,    9,   48,  0,  9,  0 }, {    -25,    8,   49,  0,  9,  0 },
    {    -26,    8,   50,  0,  9,  0 }, {    -26,    8,   51,  0,  9,  0 }, {    -26,    8,   52,  0,  9,  0 }, {    -27,    8,   53,  0,  9,  0 }, {    -27,    8,   54,  0,  9,  0 },
    {    -27,    8,   55,  0,  9,  0 }, {    -28,    8,   56,  0,  9,  0 }, {    -28,    8,   57,  0,  9,  0 }, {    -28,    8,   58,  0,  9,  0 }, {    -29,    7,   59,  0,  9,  0 },
    {    -29,    7,   60,  0,  9,  0 }, {    -29,    7,   61,  0,  9,  0 }, {    -30,    7,   62,  0,  9,  0 }, {    -30,    7,   63,  0,  9,  0 }, {    -30,    7,   64,  0, 10,  0 },
    {    -30,    7,   65,  0, 10,  0 }, {    -31,    7,   66,  0, 10,  0 }, {    -31,    7,   67,  0, 10,  0 }, {    -31,    7,   68,  0, 10,  0 }, {    -31,    6,   69,  0, 10,  0 },
    {    -31,    6,   70,  0, 10,  0 }, {    -32,    6,   71,  0, 10,  0 }, {    -32,    6,   72,  0, 10,  0 }, {    -32,    6,   73,  0, 10,  0 }, {    -32,    6,   74,  0, 10,  0 },
    {    -32,    6,   75,  0, 10,  0 }, {    -32,    6,   76,  0, 10,  0 }, {    -32,    6,   77,  0, 10,  0 }, {    -32,    6,   78,  0, 10,  0 }, {    -32,    6,   79,  0, 10,  0 },
    {    -32,    5,   80,  0, 10,  0 }, {    -32,    5,   81,  0, 10,  0 }, {    -32,    5,   82,  0, 10,  0 }, {    -32,    5,   83,  0, 10,  0 }, {    -32,    5,   84,  0, 10,  0 },
    {    -32,    5,   85,  0, 10,  0 }, {    -32,    5,   86,  0, 10,  0 }, {    -32,    5,   87,  0, 10,  0 }, {    -32,    5,   88,  0, 10,  0 }, {    -32,    5,   89,  0, 10,  0 },
    {    -32,    5,   90,  0, 10,  0 }, {    -32,    5,   91,  0, 11,  0 }, {    -32,    4,   92,  0, 11,  0 }, {    -31,    4,   93,  0, 11,  0 }, {    -31,    4,   94,  0, 11,  0 },
    {    -31,    4,   95,  0, 11,  0 }, {    -31,    4,   96,  0, 11,  0 }, {    -31,    4,   97,  0, 11,  0 }, {    -30,    4,   98,  0, 11,  0 }, {    -30,    4,   99,  0, 11,  0 },
    {    -30,    4,  100,  0, 11,  0 }, {    -30,    4,  101,  0, 11,  0 }, {    -29,    3,  102,  0, 11,  0 }, {    -29,    3,  103,  0, 11,  0 }, {    -29,    3,  104,  0, 11,  0 },
    {    -28,    3,  105,  0, 12,  0 }, {    -28,    3,  106,  0, 12,  0 }, {    -27,    3,  107,  0, 12,  0 }, {    -27,    3,  108,  0, 12,  0 }, {    -26,    3,  109,  0, 12,  0 },
    {    -26,    3,  110,  0, 12,  0 }, {    -26,    3,  111,  0, 12,  0 }, {    -25,    2,  112,  0, 12,  0 }, {    -25,    2,  113,  0, 12,  0 }, {    -24,    2,  114,  0, 13,  0 },
    {    -24,    2,  115,  0, 13,  0 }, {    -23,    2,  116,  0, 13,  0 }, {    -22,    2,  117,  0, 13,  0 }, {    -22,    2,  118,  0, 13,  0 }, {    -21,    2,  119,  0, 13,  0 },
    {    -20,    2,  120,  0, 13,  0 }, {    -19,    1,  121,  0, 13,  0 }, {    -18,    1,  122,  0, 14,  0 }, {    -17,    1,  123,  0, 14,  0 }, {    -16,    1,  124,  0, 14,  0 },
    {    -15,    1,  124,  0, 14,  0 }, {    -14,    1,  125,  0, 14,  0 }, {    -13,    1,  126,  0, 15,  0 }, {    -12,    1,  127,  0, 15,  0 }, {    -11,    0,  128,  0, 15,  0 },
    {    -10,    0,  128,  0, 15,  0 }, {     -9,    0,  129,  0, 15,  0 }, {     -8,    0,  129,  0, 16,  0 }, {     -7,    0,  129,  0, 16,  0 }, {     -6,    0,  130,  0, 16,  0 },
    {     -5,    0,  130,  0, 16,  0 }, {     -4,    0,  130,  0, 16,  0 }, {     -3,    0,  130,  0, 16,  0 }, {     -2,    0,  130,  0, 16,  0 }, {     -1,    0,  130,  0, 16,  0 },
    {      0,    0,  130,  0, 16,  0 }, {      1,    0,  130,  0, 16,  0 }, {      2,    0,  130,  0, 16,  0 }, {      3,    0,  130,  0, 16,  0 }, {      4,    0,  130,  0, 23,  0 },
    {      5,    0,  130,  0, 23,  0 }, {      6,    0,  129,  0, 23,  0 }, {      7,    0,  129,  0, 23,  0 }, {      8,    0,  129,  0, 23,  0 }, {      9,    0,  128,  0, 22,  0 },
    {     10,    0,  128,  0, 22,  0 }, {     11,   -1,  127,  0, 22,  0 }, {     12,   -1,  126,  0, 22,  0 }, {     13,   -1,  125,  0, 22,  0 }, {     14,   -1,  124,  0, 21,  0 },
    {     15,   -1,  124,  0, 21,  0 }, {     16,   -1,  123,  0, 21,  0 }, {     17,   -1,  122,  0, 21,  0 }, {     18,   -1,  121,  0, 21,  0 }, {     19,   -2,  120,  0, 21,  0 },
    {     20,   -2,  119,  0, 21,  0 }, {     21,   -2,  118,  0, 21,  0 }, {     21,   -2,  117,  0, 20,  0 }, {     22,   -2,  116,  0, 20,  0 }, {     23,   -2,  115,  0, 20,  0 },
    {     23,   -2,  114,  0, 20,  0 }, {     24,   -2,  113,  0, 20,  0 }, {     24,   -2,  112,  0, 20,  0 }, {     25,   -3,  111,  0, 20,  0 }, {     25,   -3,  110,  0, 20,  0 },
    {     25,   -3,  109,  0, 20,  0 }, {     26,   -3,  108,  0, 19,  0 }, {     26,   -3,  107,  0, 19,  0 }, {     27,   -3,  106,  0, 19,  0 }, {     27,   -3,  105,  0, 19,  0 },
    {     28,   -3,  104,  0, 19,  0 }, {     28,   -3,  103,  0, 19,  0 }, {     28,   -3,  102,  0, 19,  0 }, {     29,   -4,  101,  0, 19,  0 }, {     29,   -4,  100,  0, 19,  0 },
    {     29,   -4,   99,  0, 19,  0 }, {     29,   -4,   98,  0, 19,  0 }, {     30,   -4,   97,  0, 19,  0 }, {     30,   -4,   96,  0, 19,  0 }, {     30,   -4,   95,  0, 19,  0 },
    {     30,   -4,   94,  0, 18,  0 }, {     30,   -4,   93,  0, 18,  0 }, {     31,   -4,   92,  0, 18,  0 }, {     31,   -5,   91,  0, 18,  0 }, {     31,   -5,   90,  0, 18,  0 },
    {     31,   -5,   89,  0, 18,  0 }, {     31,   -5,   88,  0, 18,  0 }, {     31,   -5,   87,  0, 18,  0 }, {     31,   -5,   86,  0, 18,  0 }, {     31,   -5,   85,  0, 18,  0 },
    {     31,   -5,   84,  0, 18,  0 }, {     31,   -5,   83,  0, 18,  0 }, {     31,   -5,   82,  0, 18,  0 }, {     31,   -5,   81,  0, 18,  0 }, {     31,   -5,   80,  0, 18,  0 },
    {     31,   -6,   79,  0, 18,  0 }, {     31,   -6,   78,  0, 18,  0 }, {     31,   -6,   77,  0, 18,  0 }, {     31,   -6,   76,  0, 18,  0 }, {     31,   -6,   75,  0, 18,  0 },
    {     31,   -6,   74,  0, 18,  0 }, {     31,   -6,   73,  0, 18,  0 }, {     31,   -6,   72,  0, 18,  0 }, {     31,   -6,   71,  0, 18,  0 }, {     30,   -6,   70,  0, 18,  0 },
    {     30,   -6,   69,  0, 18,  0 }, {     30,   -7,   68,  0, 18,  0 }, {     30,   -7,   67,  0, 17,  0 }, {     30,   -7,   66,  0, 17,  0 }, {     29,   -7,   65,  0, 17,  0 },
    {     29,   -7,   64,  0, 17,  0 }, {     29,   -7,   63,  0, 17,  0 }, {     29,   -7,   62,  0, 17,  0 }, {     28,   -7,   61,  0, 17,  0 }, {     28,   -7,   60,  0, 17,  0 },
    {     28,   -7,   59,  0, 17,  0 }, {     27,   -8,   58,  0, 17,  0 }, {     27,   -8,   57,  0, 17,  0 }, {     27,   -8,   56,  0, 17,  0 }, {     26,   -8,   55,  0, 17,  0 },
    {     26,   -8,   54,  0, 17,  0 }, {     26,   -8,   53,  0, 17,  0 }, {     25,   -8,   52,  0, 17,  0 }, {     25,   -8,   51,  0, 17,  0 }, {     25,   -8,   50,  0, 17,  0 },
    {     24,   -8,   49,  0, 17,  0 }, {     24,   -9,   48,  0, 17,  0 }, {     24,   -9,   47,  0, 17,  0 }, {     23,   -9,   46,  0,  8,  0 }, {     23,   -9,   45,  0,  8,  0 },
    {     22,   -9,   44,  0,  8,  0 }, {     21,   -9,   43,  0,  8,  0 }, {     21,   -9,   42,  0,  8,  0 }, {     20,   -9,   41,  0,  8,  0 }, {     19,   -9,   40,  0,  8,  0 },
    {     19,   -9,   39,  0,  8,  0 }, {     18,  -10,   38,  0,  8,  0 }, {     18,  -10,   37,  0,  8,  0 }, {     17,  -10,   36,  0,  8,  0 }, {     16,  -10,   35,  0,  8,  0 },
    {     15,  -10,   34,  0,  8,  0 }, {     15,  -10,   33,  0,  8,  0 }, {     14,  -10,   32,  0,  8,  0 }, {     13,  -10,   31,  0,  8,  0 }, {     12,  -11,   30,  0,  7,  0 },
    {     12,  -11,   29,  0,  7,  0 }, {     11,  -11,   28,  0,  7,  0 }, {     10,  -11,   27,  0,  7,  0 }, {      9,  -11,   26,  0,  7,  0 }, {      8,  -11,   25,  0,  7,  0 },
    {      7,  -11,   24,  0,  7,  0 }, {      6,  -11,   23,  0,  7,  0 }, {      5,  -11,   22,  0,  7,  0 }, {      4,  -12,   21,  0,  7,  0 }, {      3,  -12,   20,  0,  7,  0 },
    {      2,  -12,   19,  0,  7,  0 }, {      1,  -12,   18,  0,  7,  0 }, {      0,  -12,   18,  0,  7,  0 }, {     -1,  -12,   17,  0,  7,  0 }, {     -2,  -12,   16,  0,  7,  0 },
    {     -3,  -12,   15,  0,  7,  0 }, {     -4,  -13,   15,  0,  7,  0 }, {     -5,  -13,   14,  0,  7,  0 }, {     -6,  -13,   13,  0,  7,  0 }, {     -7,  -13,   12,  0,  7,  0 },
    {     -8,  -13,   11,  0,  7,  0 }, {     -9,  -13,   11,  0,  7,  0 }, {    -10,  -13,   10,  0,  6,  0 }, {    -11,  -13,   10,  0,  6,  0 }, {    -12,  -13,    9,  0,  6,  0 },
    {    -13,  -14,    9,  0,  6,  0 }, {    -14,  -14,    8,  0,  6,  0 }, {    -15,  -14,    8,  0,  6,  0 }, {    -16,  -14,    7,  0,  6,  0 }, {    -17,  -14,    7,  0,  6,  0 },
    {    -18,  -14,    6,  0,  6,  0 }, {    -19,  -14,    6,  0,  6,  0 }, {    -20,  -14,    5,  0,  6,  0 }, {    -21,  -14,    5,  0,  6,  0 }, {    -22,  -14,    4,  0,  6,  0 },
    {    -23,  -15,    4,  0,  6,  0 }, {    -24,  -15,    3,  0,  6,  0 }, {    -25,  -15,    3,  0,  6,  0 }, {    -26,  -15,    3,  0,  6,  0 }, {    -27,  -15,    2,  0,  6,  0 },
    {    -28,  -15,    2,  0,  6,  0 }, {    -29,  -15,    1,  0,  6,  0 }, {    -30,  -15,    1,  0,  6,  0 }, {    -31,  -15,    0,  0,  6,  0 }, {    -32,  -16,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D4FA6, {
    {     16,    0,    0,  8,  2,  0 }, {     15,    1,    0,  8,  2,  0 }, {     15,    2,    1,  8,  2,  0 }, {     15,    3,    1,  8,  2,  0 }, {     15,    4,    2,  8,  2,  0 },
    {     15,    5,    2,  8,  2,  0 }, {     15,    6,    3,  8,  2,  0 }, {     15,    7,    3,  8,  2,  0 }, {     15,    8,    3,  8,  2,  0 }, {     15,    9,    4,  8,  2,  0 },
    {     14,   10,    4,  8,  2,  0 }, {     14,   11,    5,  8,  2,  0 }, {     14,   12,    5,  8,  2,  0 }, {     14,   13,    6,  8,  2,  0 }, {     14,   14,    6,  8,  2,  0 },
    {     14,   15,    7,  8,  2,  0 }, {     14,   16,    7,  8,  2,  0 }, {     14,   17,    8,  8,  2,  0 }, {     14,   18,    8,  8,  2,  0 }, {     14,   19,    9,  8,  3,  0 },
    {     13,   20,    9,  8,  3,  0 }, {     13,   21,   10,  8,  3,  0 }, {     13,   22,   10,  8,  3,  0 }, {     13,   23,   11,  8,  3,  0 }, {     13,   24,   11,  8,  3,  0 },
    {     13,   25,   12,  8,  3,  0 }, {     13,   26,   13,  8,  3,  0 }, {     13,   27,   14,  8,  3,  0 }, {     13,   28,   15,  8,  3,  0 }, {     12,   29,   15,  8,  3,  0 },
    {     12,   30,   16,  8,  3,  0 }, {     12,   31,   17,  8,  3,  0 }, {     12,   32,   18,  8,  3,  0 }, {     12,   33,   18,  8,  3,  0 }, {     12,   34,   19,  8,  3,  0 },
    {     12,   35,   20,  8,  3,  0 }, {     12,   36,   21,  8,  3,  0 }, {     11,   37,   22,  8,  3,  0 }, {     11,   38,   23,  8,  3,  0 }, {     11,   39,   24,  8,  3,  0 },
    {     11,   40,   25,  8,  3,  0 }, {     11,   41,   26,  8,  3,  0 }, {     11,   42,   27,  8,  4,  0 }, {     11,   43,   28,  8,  4,  0 }, {     11,   44,   29,  8,  4,  0 },
    {     11,   44,   30,  8,  4,  0 }, {     10,   45,   31,  8,  4,  0 }, {     10,   46,   32,  8,  4,  0 }, {     10,   47,   33,  8,  4,  0 }, {     10,   47,   34,  8,  4,  0 },
    {     10,   48,   35,  8,  4,  0 }, {     10,   49,   36,  8,  4,  0 }, {     10,   50,   37,  8,  4,  0 }, {     10,   50,   38,  8,  4,  0 }, {     10,   51,   39,  8,  4,  0 },
    {      9,   51,   40,  8,  4,  0 }, {      9,   52,   41,  8,  4,  0 }, {      9,   53,   42,  8,  4,  0 }, {      9,   53,   43,  8,  9,  0 }, {      9,   54,   44,  8,  9,  0 },
    {      9,   55,   45,  8,  9,  0 }, {      9,   55,   46,  8,  9,  0 }, {      9,   56,   47,  8,  9,  0 }, {      9,   56,   48,  8,  9,  0 }, {      8,   56,   49,  8,  9,  0 },
    {      8,   57,   50,  8,  9,  0 }, {      8,   57,   51,  8,  9,  0 }, {      8,   57,   52,  8,  9,  0 }, {      8,   58,   53,  8,  9,  0 }, {      8,   58,   54,  8,  9,  0 },
    {      8,   58,   55,  8,  9,  0 }, {      8,   59,   56,  8,  9,  0 }, {      8,   59,   57,  8,  9,  0 }, {      8,   59,   58,  8,  9,  0 }, {      7,   60,   59,  8,  9,  0 },
    {      7,   60,   60,  8,  9,  0 }, {      7,   60,   61,  8,  9,  0 }, {      7,   61,   62,  8,  9,  0 }, {      7,   61,   63,  8,  9,  0 }, {      7,   61,   64,  8, 10,  0 },
    {      7,   61,   65,  8, 10,  0 }, {      7,   62,   66,  8, 10,  0 }, {      7,   62,   67,  8, 10,  0 }, {      7,   62,   68,  8, 10,  0 }, {      6,   62,   69,  8, 10,  0 },
    {      6,   62,   70,  8, 10,  0 }, {      6,   63,   71,  8, 10,  0 }, {      6,   63,   72,  8, 10,  0 }, {      6,   63,   73,  8, 10,  0 }, {      6,   63,   74,  8, 10,  0 },
    {      6,   63,   75,  8, 10,  0 }, {      6,   63,   76,  8, 10,  0 }, {      6,   63,   77,  8, 10,  0 }, {      6,   63,   78,  8, 10,  0 }, {      6,   63,   79,  8, 10,  0 },
    {      5,   63,   80,  8, 10,  0 }, {      5,   63,   81,  8, 10,  0 }, {      5,   63,   82,  8, 10,  0 }, {      5,   63,   83,  8, 10,  0 }, {      5,   63,   84,  8, 10,  0 },
    {      5,   63,   85,  8, 10,  0 }, {      5,   63,   86,  8, 10,  0 }, {      5,   63,   87,  8, 10,  0 }, {      5,   63,   88,  8, 10,  0 }, {      5,   63,   89,  8, 10,  0 },
    {      5,   63,   90,  8, 10,  0 }, {      5,   63,   91,  8, 11,  0 }, {      4,   63,   92,  8, 11,  0 }, {      4,   62,   93,  8, 11,  0 }, {      4,   62,   94,  8, 11,  0 },
    {      4,   62,   95,  8, 11,  0 }, {      4,   62,   96,  8, 11,  0 }, {      4,   62,   97,  8, 11,  0 }, {      4,   61,   98,  8, 11,  0 }, {      4,   61,   99,  8, 11,  0 },
    {      4,   61,  100,  8, 11,  0 }, {      4,   61,  101,  8, 11,  0 }, {      3,   60,  102,  8, 11,  0 }, {      3,   60,  103,  8, 11,  0 }, {      3,   60,  104,  8, 11,  0 },
    {      3,   59,  105,  8, 12,  0 }, {      3,   59,  106,  8, 12,  0 }, {      3,   58,  107,  8, 12,  0 }, {      3,   58,  108,  8, 12,  0 }, {      3,   57,  109,  8, 12,  0 },
    {      3,   57,  110,  8, 12,  0 }, {      3,   57,  111,  8, 12,  0 }, {      2,   56,  112,  8, 12,  0 }, {      2,   56,  113,  8, 12,  0 }, {      2,   55,  114,  8, 13,  0 },
    {      2,   55,  115,  8, 13,  0 }, {      2,   54,  116,  8, 13,  0 }, {      2,   53,  117,  8, 13,  0 }, {      2,   53,  118,  8, 13,  0 }, {      2,   52,  119,  8, 13,  0 },
    {      2,   51,  120,  8, 13,  0 }, {      1,   50,  121,  8, 13,  0 }, {      1,   49,  122,  8, 14,  0 }, {      1,   48,  123,  8, 14,  0 }, {      1,   47,  124,  8, 14,  0 },
    {      1,   46,  124,  8, 14,  0 }, {      1,   45,  125,  8, 14,  0 }, {      1,   44,  126,  8, 15,  0 }, {      1,   43,  127,  8, 15,  0 }, {      0,   42,  128,  8, 15,  0 },
    {      0,   41,  128,  8, 15,  0 }, {      0,   40,  129,  8, 15,  0 }, {      0,   39,  129,  8, 16,  0 }, {      0,   38,  129,  8, 16,  0 }, {      0,   37,  130,  8, 16,  0 },
    {      0,   36,  130,  8, 16,  0 }, {      0,   35,  130,  8, 16,  0 }, {      0,   34,  130,  8, 16,  0 }, {      0,   33,  130,  8, 16,  0 }, {      0,   32,  130,  8, 16,  0 },
    {      0,   31,  130,  8, 16,  0 }, {      0,   30,  130,  8, 16,  0 }, {      0,   29,  130,  8, 16,  0 }, {      0,   28,  130,  8, 16,  0 }, {      0,   27,  130,  8, 23,  0 },
    {      0,   26,  130,  8, 23,  0 }, {      0,   25,  129,  8, 23,  0 }, {      0,   24,  129,  8, 23,  0 }, {      0,   23,  129,  8, 23,  0 }, {      0,   22,  128,  8, 22,  0 },
    {      0,   21,  128,  8, 22,  0 }, {     -1,   20,  127,  8, 22,  0 }, {     -1,   19,  126,  8, 22,  0 }, {     -1,   18,  125,  8, 22,  0 }, {     -1,   17,  124,  8, 21,  0 },
    {     -1,   16,  124,  8, 21,  0 }, {     -1,   15,  123,  8, 21,  0 }, {     -1,   14,  122,  8, 21,  0 }, {     -1,   13,  121,  8, 21,  0 }, {     -2,   12,  120,  8, 21,  0 },
    {     -2,   11,  119,  8, 21,  0 }, {     -2,   10,  118,  8, 21,  0 }, {     -2,   10,  117,  8, 20,  0 }, {     -2,    9,  116,  8, 20,  0 }, {     -2,    8,  115,  8, 20,  0 },
    {     -2,    8,  114,  8, 20,  0 }, {     -2,    7,  113,  8, 20,  0 }, {     -2,    7,  112,  8, 20,  0 }, {     -3,    6,  111,  8, 20,  0 }, {     -3,    6,  110,  8, 20,  0 },
    {     -3,    6,  109,  8, 20,  0 }, {     -3,    5,  108,  8, 19,  0 }, {     -3,    5,  107,  8, 19,  0 }, {     -3,    4,  106,  8, 19,  0 }, {     -3,    4,  105,  8, 19,  0 },
    {     -3,    3,  104,  8, 19,  0 }, {     -3,    3,  103,  8, 19,  0 }, {     -3,    3,  102,  8, 19,  0 }, {     -4,    2,  101,  8, 19,  0 }, {     -4,    2,  100,  8, 19,  0 },
    {     -4,    2,   99,  8, 19,  0 }, {     -4,    2,   98,  8, 19,  0 }, {     -4,    1,   97,  8, 19,  0 }, {     -4,    1,   96,  8, 19,  0 }, {     -4,    1,   95,  8, 19,  0 },
    {     -4,    1,   94,  8, 18,  0 }, {     -4,    1,   93,  8, 18,  0 }, {     -4,    0,   92,  8, 18,  0 }, {     -5,    0,   91,  8, 18,  0 }, {     -5,    0,   90,  8, 18,  0 },
    {     -5,    0,   89,  8, 18,  0 }, {     -5,    0,   88,  8, 18,  0 }, {     -5,    0,   87,  8, 18,  0 }, {     -5,    0,   86,  8, 18,  0 }, {     -5,    0,   85,  8, 18,  0 },
    {     -5,    0,   84,  8, 18,  0 }, {     -5,    0,   83,  8, 18,  0 }, {     -5,    0,   82,  8, 18,  0 }, {     -5,    0,   81,  8, 18,  0 }, {     -5,    0,   80,  8, 18,  0 },
    {     -6,    0,   79,  8, 18,  0 }, {     -6,    0,   78,  8, 18,  0 }, {     -6,    0,   77,  8, 18,  0 }, {     -6,    0,   76,  8, 18,  0 }, {     -6,    0,   75,  8, 18,  0 },
    {     -6,    0,   74,  8, 18,  0 }, {     -6,    0,   73,  8, 18,  0 }, {     -6,    0,   72,  8, 18,  0 }, {     -6,    0,   71,  8, 18,  0 }, {     -6,    1,   70,  8, 18,  0 },
    {     -6,    1,   69,  8, 18,  0 }, {     -7,    1,   68,  8, 18,  0 }, {     -7,    1,   67,  8, 17,  0 }, {     -7,    1,   66,  8, 17,  0 }, {     -7,    2,   65,  8, 17,  0 },
    {     -7,    2,   64,  8, 17,  0 }, {     -7,    2,   63,  8, 17,  0 }, {     -7,    2,   62,  8, 17,  0 }, {     -7,    3,   61,  8, 17,  0 }, {     -7,    3,   60,  8, 17,  0 },
    {     -7,    3,   59,  8, 17,  0 }, {     -8,    4,   58,  8, 17,  0 }, {     -8,    4,   57,  8, 17,  0 }, {     -8,    4,   56,  8, 17,  0 }, {     -8,    5,   55,  8, 17,  0 },
    {     -8,    5,   54,  8, 17,  0 }, {     -8,    5,   53,  8, 17,  0 }, {     -8,    6,   52,  8, 17,  0 }, {     -8,    6,   51,  8, 17,  0 }, {     -8,    6,   50,  8, 17,  0 },
    {     -8,    7,   49,  8, 17,  0 }, {     -9,    7,   48,  8, 17,  0 }, {     -9,    7,   47,  8, 17,  0 }, {     -9,    8,   46,  8,  8,  0 }, {     -9,    8,   45,  8,  8,  0 },
    {     -9,    9,   44,  8,  8,  0 }, {     -9,   10,   43,  8,  8,  0 }, {     -9,   10,   42,  8,  8,  0 }, {     -9,   11,   41,  8,  8,  0 }, {     -9,   12,   40,  8,  8,  0 },
    {     -9,   12,   39,  8,  8,  0 }, {    -10,   13,   38,  8,  8,  0 }, {    -10,   13,   37,  8,  8,  0 }, {    -10,   14,   36,  8,  8,  0 }, {    -10,   15,   35,  8,  8,  0 },
    {    -10,   16,   34,  8,  8,  0 }, {    -10,   16,   33,  8,  8,  0 }, {    -10,   17,   32,  8,  8,  0 }, {    -10,   18,   31,  8,  8,  0 }, {    -11,   19,   30,  8,  7,  0 },
    {    -11,   19,   29,  8,  7,  0 }, {    -11,   20,   28,  8,  7,  0 }, {    -11,   21,   27,  8,  7,  0 }, {    -11,   22,   26,  8,  7,  0 }, {    -11,   23,   25,  8,  7,  0 },
    {    -11,   24,   24,  8,  7,  0 }, {    -11,   25,   23,  8,  7,  0 }, {    -11,   26,   22,  8,  7,  0 }, {    -12,   27,   21,  8,  7,  0 }, {    -12,   28,   20,  8,  7,  0 },
    {    -12,   29,   19,  8,  7,  0 }, {    -12,   30,   18,  8,  7,  0 }, {    -12,   31,   18,  8,  7,  0 }, {    -12,   32,   17,  8,  7,  0 }, {    -12,   33,   16,  8,  7,  0 },
    {    -12,   34,   15,  8,  7,  0 }, {    -13,   35,   15,  8,  7,  0 }, {    -13,   36,   14,  8,  7,  0 }, {    -13,   37,   13,  8,  7,  0 }, {    -13,   38,   12,  8,  7,  0 },
    {    -13,   39,   11,  8,  7,  0 }, {    -13,   40,   11,  8,  7,  0 }, {    -13,   41,   10,  8,  6,  0 }, {    -13,   42,   10,  8,  6,  0 }, {    -13,   43,    9,  8,  6,  0 },
    {    -14,   44,    9,  8,  6,  0 }, {    -14,   45,    8,  8,  6,  0 }, {    -14,   46,    8,  8,  6,  0 }, {    -14,   47,    7,  8,  6,  0 }, {    -14,   48,    7,  8,  6,  0 },
    {    -14,   49,    6,  8,  6,  0 }, {    -14,   50,    6,  8,  6,  0 }, {    -14,   51,    5,  8,  6,  0 }, {    -14,   52,    5,  8,  6,  0 }, {    -14,   53,    4,  8,  6,  0 },
    {    -15,   54,    4,  8,  6,  0 }, {    -15,   55,    3,  8,  6,  0 }, {    -15,   56,    3,  8,  6,  0 }, {    -15,   57,    3,  8,  6,  0 }, {    -15,   58,    2,  8,  6,  0 },
    {    -15,   59,    2,  8,  6,  0 }, {    -15,   60,    1,  8,  6,  0 }, {    -15,   61,    1,  8,  6,  0 }, {    -15,   62,    0,  8,  6,  0 }, {    -16,   63,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D5A8E, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    3, 16,  2,  0 }, {      9,   16,    4, 16,  2,  0 },
    {     10,   17,    4, 16,  2,  0 }, {     11,   17,    5, 16,  2,  0 }, {     12,   17,    5, 16,  2,  0 }, {     13,   17,    6, 16,  2,  0 }, {     14,   17,    6, 16,  2,  0 },
    {     15,   17,    7, 16,  2,  0 }, {     16,   17,    7, 16,  2,  0 }, {     17,   17,    8, 16,  2,  0 }, {     18,   17,    8, 16,  2,  0 }, {     19,   17,    9, 16,  3,  0 },
    {     20,   18,    9, 16,  3,  0 }, {     21,   18,   10, 16,  3,  0 }, {     22,   18,   10, 16,  3,  0 }, {     23,   18,   11, 16,  3,  0 }, {     24,   18,   11, 16,  3,  0 },
    {     25,   18,   12, 16,  3,  0 }, {     26,   18,   13, 16,  3,  0 }, {     27,   18,   14, 16,  3,  0 }, {     28,   18,   15, 16,  3,  0 }, {     29,   19,   15, 16,  3,  0 },
    {     30,   19,   16, 16,  3,  0 }, {     31,   19,   17, 16,  3,  0 }, {     32,   19,   18, 16,  3,  0 }, {     33,   19,   18, 16,  3,  0 }, {     34,   19,   19, 16,  3,  0 },
    {     35,   19,   20, 16,  3,  0 }, {     36,   19,   21, 16,  3,  0 }, {     37,   20,   22, 16,  3,  0 }, {     38,   20,   23, 16,  3,  0 }, {     39,   20,   24, 16,  3,  0 },
    {     40,   20,   25, 16,  3,  0 }, {     41,   20,   26, 16,  3,  0 }, {     42,   20,   27, 16,  4,  0 }, {     43,   20,   28, 16,  4,  0 }, {     44,   20,   29, 16,  4,  0 },
    {     44,   20,   30, 16,  4,  0 }, {     45,   21,   31, 16,  4,  0 }, {     46,   21,   32, 16,  4,  0 }, {     47,   21,   33, 16,  4,  0 }, {     47,   21,   34, 16,  4,  0 },
    {     48,   21,   35, 16,  4,  0 }, {     49,   21,   36, 16,  4,  0 }, {     50,   21,   37, 16,  4,  0 }, {     50,   21,   38, 16,  4,  0 }, {     51,   22,   39, 16,  4,  0 },
    {     51,   22,   40, 16,  4,  0 }, {     52,   22,   41, 16,  4,  0 }, {     53,   22,   42, 16,  4,  0 }, {     53,   22,   43, 16,  9,  0 }, {     54,   22,   44, 16,  9,  0 },
    {     55,   22,   45, 16,  9,  0 }, {     55,   22,   46, 16,  9,  0 }, {     56,   22,   47, 16,  9,  0 }, {     56,   22,   48, 16,  9,  0 }, {     56,   23,   49, 16,  9,  0 },
    {     57,   23,   50, 16,  9,  0 }, {     57,   23,   51, 16,  9,  0 }, {     57,   23,   52, 16,  9,  0 }, {     58,   23,   53, 16,  9,  0 }, {     58,   23,   54, 16,  9,  0 },
    {     58,   23,   55, 16,  9,  0 }, {     59,   23,   56, 16,  9,  0 }, {     59,   23,   57, 16,  9,  0 }, {     59,   23,   58, 16,  9,  0 }, {     60,   24,   59, 16,  9,  0 },
    {     60,   24,   60, 16,  9,  0 }, {     60,   24,   61, 16,  9,  0 }, {     61,   24,   62, 16,  9,  0 }, {     61,   24,   63, 16,  9,  0 }, {     61,   24,   64, 16, 10,  0 },
    {     61,   24,   65, 16, 10,  0 }, {     62,   24,   66, 16, 10,  0 }, {     62,   24,   67, 16, 10,  0 }, {     62,   24,   68, 16, 10,  0 }, {     62,   25,   69, 16, 10,  0 },
    {     62,   25,   70, 16, 10,  0 }, {     63,   25,   71, 16, 10,  0 }, {     63,   25,   72, 16, 10,  0 }, {     63,   25,   73, 16, 10,  0 }, {     63,   25,   74, 16, 10,  0 },
    {     63,   25,   75, 16, 10,  0 }, {     63,   25,   76, 16, 10,  0 }, {     63,   25,   77, 16, 10,  0 }, {     63,   25,   78, 16, 10,  0 }, {     63,   25,   79, 16, 10,  0 },
    {     63,   26,   80, 16, 10,  0 }, {     63,   26,   81, 16, 10,  0 }, {     63,   26,   82, 16, 10,  0 }, {     63,   26,   83, 16, 10,  0 }, {     63,   26,   84, 16, 10,  0 },
    {     63,   26,   85, 16, 10,  0 }, {     63,   26,   86, 16, 10,  0 }, {     63,   26,   87, 16, 10,  0 }, {     63,   26,   88, 16, 10,  0 }, {     63,   26,   89, 16, 10,  0 },
    {     63,   26,   90, 16, 10,  0 }, {     63,   26,   91, 16, 11,  0 }, {     63,   27,   92, 16, 11,  0 }, {     62,   27,   93, 16, 11,  0 }, {     62,   27,   94, 16, 11,  0 },
    {     62,   27,   95, 16, 11,  0 }, {     62,   27,   96, 16, 11,  0 }, {     62,   27,   97, 16, 11,  0 }, {     61,   27,   98, 16, 11,  0 }, {     61,   27,   99, 16, 11,  0 },
    {     61,   27,  100, 16, 11,  0 }, {     61,   27,  101, 16, 11,  0 }, {     60,   28,  102, 16, 11,  0 }, {     60,   28,  103, 16, 11,  0 }, {     60,   28,  104, 16, 11,  0 },
    {     59,   28,  105, 16, 12,  0 }, {     59,   28,  106, 16, 12,  0 }, {     58,   28,  107, 16, 12,  0 }, {     58,   28,  108, 16, 12,  0 }, {     57,   28,  109, 16, 12,  0 },
    {     57,   28,  110, 16, 12,  0 }, {     57,   28,  111, 16, 12,  0 }, {     56,   29,  112, 16, 12,  0 }, {     56,   29,  113, 16, 12,  0 }, {     55,   29,  114, 16, 13,  0 },
    {     55,   29,  115, 16, 13,  0 }, {     54,   29,  116, 16, 13,  0 }, {     53,   29,  117, 16, 13,  0 }, {     53,   29,  118, 16, 13,  0 }, {     52,   29,  119, 16, 13,  0 },
    {     51,   29,  120, 16, 13,  0 }, {     50,   30,  121, 16, 13,  0 }, {     49,   30,  122, 16, 14,  0 }, {     48,   30,  123, 16, 14,  0 }, {     47,   30,  124, 16, 14,  0 },
    {     46,   30,  124, 16, 14,  0 }, {     45,   30,  125, 16, 14,  0 }, {     44,   30,  126, 16, 15,  0 }, {     43,   30,  127, 16, 15,  0 }, {     42,   31,  128, 16, 15,  0 },
    {     41,   31,  128, 16, 15,  0 }, {     40,   31,  129, 16, 15,  0 }, {     39,   31,  129, 16, 16,  0 }, {     38,   31,  129, 16, 16,  0 }, {     37,   31,  130, 16, 16,  0 },
    {     36,   31,  130, 16, 16,  0 }, {     35,   31,  130, 16, 16,  0 }, {     34,   31,  130, 16, 16,  0 }, {     33,   31,  130, 16, 16,  0 }, {     32,   31,  130, 16, 16,  0 },
    {     31,   32,  130, 16, 16,  0 }, {     30,   32,  130, 16, 16,  0 }, {     29,   32,  130, 16, 16,  0 }, {     28,   32,  130, 16, 16,  0 }, {     27,   32,  130, 16, 23,  0 },
    {     26,   32,  130, 16, 23,  0 }, {     25,   32,  129, 16, 23,  0 }, {     24,   32,  129, 16, 23,  0 }, {     23,   32,  129, 16, 23,  0 }, {     22,   32,  128, 16, 22,  0 },
    {     21,   32,  128, 16, 22,  0 }, {     20,   33,  127, 16, 22,  0 }, {     19,   33,  126, 16, 22,  0 }, {     18,   33,  125, 16, 22,  0 }, {     17,   33,  124, 16, 21,  0 },
    {     16,   33,  124, 16, 21,  0 }, {     15,   33,  123, 16, 21,  0 }, {     14,   33,  122, 16, 21,  0 }, {     13,   33,  121, 16, 21,  0 }, {     12,   34,  120, 16, 21,  0 },
    {     11,   34,  119, 16, 21,  0 }, {     10,   34,  118, 16, 21,  0 }, {     10,   34,  117, 16, 20,  0 }, {      9,   34,  116, 16, 20,  0 }, {      8,   34,  115, 16, 20,  0 },
    {      8,   34,  114, 16, 20,  0 }, {      7,   34,  113, 16, 20,  0 }, {      7,   34,  112, 16, 20,  0 }, {      6,   35,  111, 16, 20,  0 }, {      6,   35,  110, 16, 20,  0 },
    {      6,   35,  109, 16, 20,  0 }, {      5,   35,  108, 16, 19,  0 }, {      5,   35,  107, 16, 19,  0 }, {      4,   35,  106, 16, 19,  0 }, {      4,   35,  105, 16, 19,  0 },
    {      3,   35,  104, 16, 19,  0 }, {      3,   35,  103, 16, 19,  0 }, {      3,   35,  102, 16, 19,  0 }, {      2,   36,  101, 16, 19,  0 }, {      2,   36,  100, 16, 19,  0 },
    {      2,   36,   99, 16, 19,  0 }, {      2,   36,   98, 16, 19,  0 }, {      1,   36,   97, 16, 19,  0 }, {      1,   36,   96, 16, 19,  0 }, {      1,   36,   95, 16, 19,  0 },
    {      1,   36,   94, 16, 18,  0 }, {      1,   36,   93, 16, 18,  0 }, {      0,   36,   92, 16, 18,  0 }, {      0,   37,   91, 16, 18,  0 }, {      0,   37,   90, 16, 18,  0 },
    {      0,   37,   89, 16, 18,  0 }, {      0,   37,   88, 16, 18,  0 }, {      0,   37,   87, 16, 18,  0 }, {      0,   37,   86, 16, 18,  0 }, {      0,   37,   85, 16, 18,  0 },
    {      0,   37,   84, 16, 18,  0 }, {      0,   37,   83, 16, 18,  0 }, {      0,   37,   82, 16, 18,  0 }, {      0,   37,   81, 16, 18,  0 }, {      0,   37,   80, 16, 18,  0 },
    {      0,   38,   79, 16, 18,  0 }, {      0,   38,   78, 16, 18,  0 }, {      0,   38,   77, 16, 18,  0 }, {      0,   38,   76, 16, 18,  0 }, {      0,   38,   75, 16, 18,  0 },
    {      0,   38,   74, 16, 18,  0 }, {      0,   38,   73, 16, 18,  0 }, {      0,   38,   72, 16, 18,  0 }, {      0,   38,   71, 16, 18,  0 }, {      1,   38,   70, 16, 18,  0 },
    {      1,   38,   69, 16, 18,  0 }, {      1,   39,   68, 16, 18,  0 }, {      1,   39,   67, 16, 17,  0 }, {      1,   39,   66, 16, 17,  0 }, {      2,   39,   65, 16, 17,  0 },
    {      2,   39,   64, 16, 17,  0 }, {      2,   39,   63, 16, 17,  0 }, {      2,   39,   62, 16, 17,  0 }, {      3,   39,   61, 16, 17,  0 }, {      3,   39,   60, 16, 17,  0 },
    {      3,   39,   59, 16, 17,  0 }, {      4,   40,   58, 16, 17,  0 }, {      4,   40,   57, 16, 17,  0 }, {      4,   40,   56, 16, 17,  0 }, {      5,   40,   55, 16, 17,  0 },
    {      5,   40,   54, 16, 17,  0 }, {      5,   40,   53, 16, 17,  0 }, {      6,   40,   52, 16, 17,  0 }, {      6,   40,   51, 16, 17,  0 }, {      6,   40,   50, 16, 17,  0 },
    {      7,   40,   49, 16, 17,  0 }, {      7,   41,   48, 16, 17,  0 }, {      7,   41,   47, 16, 17,  0 }, {      8,   41,   46, 16,  8,  0 }, {      8,   41,   45, 16,  8,  0 },
    {      9,   41,   44, 16,  8,  0 }, {     10,   41,   43, 16,  8,  0 }, {     10,   41,   42, 16,  8,  0 }, {     11,   41,   41, 16,  8,  0 }, {     12,   41,   40, 16,  8,  0 },
    {     12,   41,   39, 16,  8,  0 }, {     13,   42,   38, 16,  8,  0 }, {     13,   42,   37, 16,  8,  0 }, {     14,   42,   36, 16,  8,  0 }, {     15,   42,   35, 16,  8,  0 },
    {     16,   42,   34, 16,  8,  0 }, {     16,   42,   33, 16,  8,  0 }, {     17,   42,   32, 16,  8,  0 }, {     18,   42,   31, 16,  8,  0 }, {     19,   43,   30, 16,  7,  0 },
    {     19,   43,   29, 16,  7,  0 }, {     20,   43,   28, 16,  7,  0 }, {     21,   43,   27, 16,  7,  0 }, {     22,   43,   26, 16,  7,  0 }, {     23,   43,   25, 16,  7,  0 },
    {     24,   43,   24, 16,  7,  0 }, {     25,   43,   23, 16,  7,  0 }, {     26,   43,   22, 16,  7,  0 }, {     27,   44,   21, 16,  7,  0 }, {     28,   44,   20, 16,  7,  0 },
    {     29,   44,   19, 16,  7,  0 }, {     30,   44,   18, 16,  7,  0 }, {     31,   44,   18, 16,  7,  0 }, {     32,   44,   17, 16,  7,  0 }, {     33,   44,   16, 16,  7,  0 },
    {     34,   44,   15, 16,  7,  0 }, {     35,   45,   15, 16,  7,  0 }, {     36,   45,   14, 16,  7,  0 }, {     37,   45,   13, 16,  7,  0 }, {     38,   45,   12, 16,  7,  0 },
    {     39,   45,   11, 16,  7,  0 }, {     40,   45,   11, 16,  7,  0 }, {     41,   45,   10, 16,  6,  0 }, {     42,   45,   10, 16,  6,  0 }, {     43,   45,    9, 16,  6,  0 },
    {     44,   46,    9, 16,  6,  0 }, {     45,   46,    8, 16,  6,  0 }, {     46,   46,    8, 16,  6,  0 }, {     47,   46,    7, 16,  6,  0 }, {     48,   46,    7, 16,  6,  0 },
    {     49,   46,    6, 16,  6,  0 }, {     50,   46,    6, 16,  6,  0 }, {     51,   46,    5, 16,  6,  0 }, {     52,   46,    5, 16,  6,  0 }, {     53,   46,    4, 16,  6,  0 },
    {     54,   47,    4, 16,  6,  0 }, {     55,   47,    3, 16,  6,  0 }, {     56,   47,    3, 16,  6,  0 }, {     57,   47,    3, 16,  6,  0 }, {     58,   47,    2, 16,  6,  0 },
    {     59,   47,    2, 16,  6,  0 }, {     60,   47,    1, 16,  6,  0 }, {     61,   47,    1, 16,  6,  0 }, {     62,   47,    0, 16,  6,  0 }, {     63,   48,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D6576, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 24,  2,  0 }, {     16,   23,    3, 24,  2,  0 }, {     16,   22,    4, 24,  2,  0 },
    {     17,   21,    4, 24,  2,  0 }, {     17,   20,    5, 24,  2,  0 }, {     17,   19,    5, 24,  2,  0 }, {     17,   18,    6, 24,  2,  0 }, {     17,   17,    6, 24,  2,  0 },
    {     17,   16,    7, 24,  2,  0 }, {     17,   15,    7, 24,  2,  0 }, {     17,   14,    8, 24,  2,  0 }, {     17,   13,    8, 24,  2,  0 }, {     17,   12,    9, 24,  3,  0 },
    {     18,   11,    9, 24,  3,  0 }, {     18,   10,   10, 24,  3,  0 }, {     18,    9,   10, 24,  3,  0 }, {     18,    8,   11, 24,  3,  0 }, {     18,    7,   11, 24,  3,  0 },
    {     18,    6,   12, 24,  3,  0 }, {     18,    5,   13, 24,  3,  0 }, {     18,    4,   14, 24,  3,  0 }, {     18,    3,   15, 24,  3,  0 }, {     19,    2,   15, 24,  3,  0 },
    {     19,    1,   16, 24,  3,  0 }, {     19,    0,   17, 24,  3,  0 }, {     19,   -1,   18, 24,  3,  0 }, {     19,   -2,   18, 24,  3,  0 }, {     19,   -3,   19, 24,  3,  0 },
    {     19,   -4,   20, 24,  3,  0 }, {     19,   -5,   21, 24,  3,  0 }, {     20,   -6,   22, 24,  3,  0 }, {     20,   -7,   23, 24,  3,  0 }, {     20,   -8,   24, 24,  3,  0 },
    {     20,   -9,   25, 24,  3,  0 }, {     20,  -10,   26, 24,  3,  0 }, {     20,  -11,   27, 24,  4,  0 }, {     20,  -12,   28, 24,  4,  0 }, {     20,  -13,   29, 24,  4,  0 },
    {     20,  -13,   30, 24,  4,  0 }, {     21,  -14,   31, 24,  4,  0 }, {     21,  -15,   32, 24,  4,  0 }, {     21,  -16,   33, 24,  4,  0 }, {     21,  -16,   34, 24,  4,  0 },
    {     21,  -17,   35, 24,  4,  0 }, {     21,  -18,   36, 24,  4,  0 }, {     21,  -19,   37, 24,  4,  0 }, {     21,  -19,   38, 24,  4,  0 }, {     22,  -20,   39, 24,  4,  0 },
    {     22,  -20,   40, 24,  4,  0 }, {     22,  -21,   41, 24,  4,  0 }, {     22,  -22,   42, 24,  4,  0 }, {     22,  -22,   43, 24,  9,  0 }, {     22,  -23,   44, 24,  9,  0 },
    {     22,  -24,   45, 24,  9,  0 }, {     22,  -24,   46, 24,  9,  0 }, {     22,  -25,   47, 24,  9,  0 }, {     22,  -25,   48, 24,  9,  0 }, {     23,  -25,   49, 24,  9,  0 },
    {     23,  -26,   50, 24,  9,  0 }, {     23,  -26,   51, 24,  9,  0 }, {     23,  -26,   52, 24,  9,  0 }, {     23,  -27,   53, 24,  9,  0 }, {     23,  -27,   54, 24,  9,  0 },
    {     23,  -27,   55, 24,  9,  0 }, {     23,  -28,   56, 24,  9,  0 }, {     23,  -28,   57, 24,  9,  0 }, {     23,  -28,   58, 24,  9,  0 }, {     24,  -29,   59, 24,  9,  0 },
    {     24,  -29,   60, 24,  9,  0 }, {     24,  -29,   61, 24,  9,  0 }, {     24,  -30,   62, 24,  9,  0 }, {     24,  -30,   63, 24,  9,  0 }, {     24,  -30,   64, 24, 10,  0 },
    {     24,  -30,   65, 24, 10,  0 }, {     24,  -31,   66, 24, 10,  0 }, {     24,  -31,   67, 24, 10,  0 }, {     24,  -31,   68, 24, 10,  0 }, {     25,  -31,   69, 24, 10,  0 },
    {     25,  -31,   70, 24, 10,  0 }, {     25,  -32,   71, 24, 10,  0 }, {     25,  -32,   72, 24, 10,  0 }, {     25,  -32,   73, 24, 10,  0 }, {     25,  -32,   74, 24, 10,  0 },
    {     25,  -32,   75, 24, 10,  0 }, {     25,  -32,   76, 24, 10,  0 }, {     25,  -32,   77, 24, 10,  0 }, {     25,  -32,   78, 24, 10,  0 }, {     25,  -32,   79, 24, 10,  0 },
    {     26,  -32,   80, 24, 10,  0 }, {     26,  -32,   81, 24, 10,  0 }, {     26,  -32,   82, 24, 10,  0 }, {     26,  -32,   83, 24, 10,  0 }, {     26,  -32,   84, 24, 10,  0 },
    {     26,  -32,   85, 24, 10,  0 }, {     26,  -32,   86, 24, 10,  0 }, {     26,  -32,   87, 24, 10,  0 }, {     26,  -32,   88, 24, 10,  0 }, {     26,  -32,   89, 24, 10,  0 },
    {     26,  -32,   90, 24, 10,  0 }, {     26,  -32,   91, 24, 11,  0 }, {     27,  -32,   92, 24, 11,  0 }, {     27,  -31,   93, 24, 11,  0 }, {     27,  -31,   94, 24, 11,  0 },
    {     27,  -31,   95, 24, 11,  0 }, {     27,  -31,   96, 24, 11,  0 }, {     27,  -31,   97, 24, 11,  0 }, {     27,  -30,   98, 24, 11,  0 }, {     27,  -30,   99, 24, 11,  0 },
    {     27,  -30,  100, 24, 11,  0 }, {     27,  -30,  101, 24, 11,  0 }, {     28,  -29,  102, 24, 11,  0 }, {     28,  -29,  103, 24, 11,  0 }, {     28,  -29,  104, 24, 11,  0 },
    {     28,  -28,  105, 24, 12,  0 }, {     28,  -28,  106, 24, 12,  0 }, {     28,  -27,  107, 24, 12,  0 }, {     28,  -27,  108, 24, 12,  0 }, {     28,  -26,  109, 24, 12,  0 },
    {     28,  -26,  110, 24, 12,  0 }, {     28,  -26,  111, 24, 12,  0 }, {     29,  -25,  112, 24, 12,  0 }, {     29,  -25,  113, 24, 12,  0 }, {     29,  -24,  114, 24, 13,  0 },
    {     29,  -24,  115, 24, 13,  0 }, {     29,  -23,  116, 24, 13,  0 }, {     29,  -22,  117, 24, 13,  0 }, {     29,  -22,  118, 24, 13,  0 }, {     29,  -21,  119, 24, 13,  0 },
    {     29,  -20,  120, 24, 13,  0 }, {     30,  -19,  121, 24, 13,  0 }, {     30,  -18,  122, 24, 14,  0 }, {     30,  -17,  123, 24, 14,  0 }, {     30,  -16,  124, 24, 14,  0 },
    {     30,  -15,  124, 24, 14,  0 }, {     30,  -14,  125, 24, 14,  0 }, {     30,  -13,  126, 24, 15,  0 }, {     30,  -12,  127, 24, 15,  0 }, {     31,  -11,  128, 24, 15,  0 },
    {     31,  -10,  128, 24, 15,  0 }, {     31,   -9,  129, 24, 15,  0 }, {     31,   -8,  129, 24, 16,  0 }, {     31,   -7,  129, 24, 16,  0 }, {     31,   -6,  130, 24, 16,  0 },
    {     31,   -5,  130, 24, 16,  0 }, {     31,   -4,  130, 24, 16,  0 }, {     31,   -3,  130, 24, 16,  0 }, {     31,   -2,  130, 24, 16,  0 }, {     31,   -1,  130, 24, 16,  0 },
    {     32,    0,  130, 24, 16,  0 }, {     32,    1,  130, 24, 16,  0 }, {     32,    2,  130, 24, 16,  0 }, {     32,    3,  130, 24, 16,  0 }, {     32,    4,  130, 24, 23,  0 },
    {     32,    5,  130, 24, 23,  0 }, {     32,    6,  129, 24, 23,  0 }, {     32,    7,  129, 24, 23,  0 }, {     32,    8,  129, 24, 23,  0 }, {     32,    9,  128, 24, 22,  0 },
    {     32,   10,  128, 24, 22,  0 }, {     33,   11,  127, 24, 22,  0 }, {     33,   12,  126, 24, 22,  0 }, {     33,   13,  125, 24, 22,  0 }, {     33,   14,  124, 24, 21,  0 },
    {     33,   15,  124, 24, 21,  0 }, {     33,   16,  123, 24, 21,  0 }, {     33,   17,  122, 24, 21,  0 }, {     33,   18,  121, 24, 21,  0 }, {     34,   19,  120, 24, 21,  0 },
    {     34,   20,  119, 24, 21,  0 }, {     34,   21,  118, 24, 21,  0 }, {     34,   21,  117, 24, 20,  0 }, {     34,   22,  116, 24, 20,  0 }, {     34,   23,  115, 24, 20,  0 },
    {     34,   23,  114, 24, 20,  0 }, {     34,   24,  113, 24, 20,  0 }, {     34,   24,  112, 24, 20,  0 }, {     35,   25,  111, 24, 20,  0 }, {     35,   25,  110, 24, 20,  0 },
    {     35,   25,  109, 24, 20,  0 }, {     35,   26,  108, 24, 19,  0 }, {     35,   26,  107, 24, 19,  0 }, {     35,   27,  106, 24, 19,  0 }, {     35,   27,  105, 24, 19,  0 },
    {     35,   28,  104, 24, 19,  0 }, {     35,   28,  103, 24, 19,  0 }, {     35,   28,  102, 24, 19,  0 }, {     36,   29,  101, 24, 19,  0 }, {     36,   29,  100, 24, 19,  0 },
    {     36,   29,   99, 24, 19,  0 }, {     36,   29,   98, 24, 19,  0 }, {     36,   30,   97, 24, 19,  0 }, {     36,   30,   96, 24, 19,  0 }, {     36,   30,   95, 24, 19,  0 },
    {     36,   30,   94, 24, 18,  0 }, {     36,   30,   93, 24, 18,  0 }, {     36,   31,   92, 24, 18,  0 }, {     37,   31,   91, 24, 18,  0 }, {     37,   31,   90, 24, 18,  0 },
    {     37,   31,   89, 24, 18,  0 }, {     37,   31,   88, 24, 18,  0 }, {     37,   31,   87, 24, 18,  0 }, {     37,   31,   86, 24, 18,  0 }, {     37,   31,   85, 24, 18,  0 },
    {     37,   31,   84, 24, 18,  0 }, {     37,   31,   83, 24, 18,  0 }, {     37,   31,   82, 24, 18,  0 }, {     37,   31,   81, 24, 18,  0 }, {     37,   31,   80, 24, 18,  0 },
    {     38,   31,   79, 24, 18,  0 }, {     38,   31,   78, 24, 18,  0 }, {     38,   31,   77, 24, 18,  0 }, {     38,   31,   76, 24, 18,  0 }, {     38,   31,   75, 24, 18,  0 },
    {     38,   31,   74, 24, 18,  0 }, {     38,   31,   73, 24, 18,  0 }, {     38,   31,   72, 24, 18,  0 }, {     38,   31,   71, 24, 18,  0 }, {     38,   30,   70, 24, 18,  0 },
    {     38,   30,   69, 24, 18,  0 }, {     39,   30,   68, 24, 18,  0 }, {     39,   30,   67, 24, 17,  0 }, {     39,   30,   66, 24, 17,  0 }, {     39,   29,   65, 24, 17,  0 },
    {     39,   29,   64, 24, 17,  0 }, {     39,   29,   63, 24, 17,  0 }, {     39,   29,   62, 24, 17,  0 }, {     39,   28,   61, 24, 17,  0 }, {     39,   28,   60, 24, 17,  0 },
    {     39,   28,   59, 24, 17,  0 }, {     40,   27,   58, 24, 17,  0 }, {     40,   27,   57, 24, 17,  0 }, {     40,   27,   56, 24, 17,  0 }, {     40,   26,   55, 24, 17,  0 },
    {     40,   26,   54, 24, 17,  0 }, {     40,   26,   53, 24, 17,  0 }, {     40,   25,   52, 24, 17,  0 }, {     40,   25,   51, 24, 17,  0 }, {     40,   25,   50, 24, 17,  0 },
    {     40,   24,   49, 24, 17,  0 }, {     41,   24,   48, 24, 17,  0 }, {     41,   24,   47, 24, 17,  0 }, {     41,   23,   46, 24,  8,  0 }, {     41,   23,   45, 24,  8,  0 },
    {     41,   22,   44, 24,  8,  0 }, {     41,   21,   43, 24,  8,  0 }, {     41,   21,   42, 24,  8,  0 }, {     41,   20,   41, 24,  8,  0 }, {     41,   19,   40, 24,  8,  0 },
    {     41,   19,   39, 24,  8,  0 }, {     42,   18,   38, 24,  8,  0 }, {     42,   18,   37, 24,  8,  0 }, {     42,   17,   36, 24,  8,  0 }, {     42,   16,   35, 24,  8,  0 },
    {     42,   15,   34, 24,  8,  0 }, {     42,   15,   33, 24,  8,  0 }, {     42,   14,   32, 24,  8,  0 }, {     42,   13,   31, 24,  8,  0 }, {     43,   12,   30, 24,  7,  0 },
    {     43,   12,   29, 24,  7,  0 }, {     43,   11,   28, 24,  7,  0 }, {     43,   10,   27, 24,  7,  0 }, {     43,    9,   26, 24,  7,  0 }, {     43,    8,   25, 24,  7,  0 },
    {     43,    7,   24, 24,  7,  0 }, {     43,    6,   23, 24,  7,  0 }, {     43,    5,   22, 24,  7,  0 }, {     44,    4,   21, 24,  7,  0 }, {     44,    3,   20, 24,  7,  0 },
    {     44,    2,   19, 24,  7,  0 }, {     44,    1,   18, 24,  7,  0 }, {     44,    0,   18, 24,  7,  0 }, {     44,   -1,   17, 24,  7,  0 }, {     44,   -2,   16, 24,  7,  0 },
    {     44,   -3,   15, 24,  7,  0 }, {     45,   -4,   15, 24,  7,  0 }, {     45,   -5,   14, 24,  7,  0 }, {     45,   -6,   13, 24,  7,  0 }, {     45,   -7,   12, 24,  7,  0 },
    {     45,   -8,   11, 24,  7,  0 }, {     45,   -9,   11, 24,  7,  0 }, {     45,  -10,   10, 24,  6,  0 }, {     45,  -11,   10, 24,  6,  0 }, {     45,  -12,    9, 24,  6,  0 },
    {     46,  -13,    9, 24,  6,  0 }, {     46,  -14,    8, 24,  6,  0 }, {     46,  -15,    8, 24,  6,  0 }, {     46,  -16,    7, 24,  6,  0 }, {     46,  -17,    7, 24,  6,  0 },
    {     46,  -18,    6, 24,  6,  0 }, {     46,  -19,    6, 24,  6,  0 }, {     46,  -20,    5, 24,  6,  0 }, {     46,  -21,    5, 24,  6,  0 }, {     46,  -22,    4, 24,  6,  0 },
    {     47,  -23,    4, 24,  6,  0 }, {     47,  -24,    3, 24,  6,  0 }, {     47,  -25,    3, 24,  6,  0 }, {     47,  -26,    3, 24,  6,  0 }, {     47,  -27,    2, 24,  6,  0 },
    {     47,  -28,    2, 24,  6,  0 }, {     47,  -29,    1, 24,  6,  0 }, {     47,  -30,    1, 24,  6,  0 }, {     47,  -31,    0, 24,  6,  0 }, {     48,  -32,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D705E, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  0,  2,  0 }, {     23,   16,    3,  0,  2,  0 }, {     22,   16,    4,  0,  2,  0 },
    {     21,   17,    4,  0,  2,  0 }, {     20,   17,    5,  0,  2,  0 }, {     19,   17,    5,  0,  2,  0 }, {     18,   17,    6,  0,  2,  0 }, {     17,   17,    6,  0,  2,  0 },
    {     16,   17,    7,  0,  2,  0 }, {     15,   17,    7,  0,  2,  0 }, {     14,   17,    8,  0,  2,  0 }, {     13,   17,    8,  0,  2,  0 }, {     12,   17,    9,  0,  3,  0 },
    {     11,   18,    9,  0,  3,  0 }, {     10,   18,   10,  0,  3,  0 }, {      9,   18,   10,  0,  3,  0 }, {      8,   18,   11,  0,  3,  0 }, {      7,   18,   11,  0,  3,  0 },
    {      6,   18,   12,  0,  3,  0 }, {      5,   18,   13,  0,  3,  0 }, {      4,   18,   14,  0,  3,  0 }, {      3,   18,   15,  0,  3,  0 }, {      2,   19,   15,  0,  3,  0 },
    {      1,   19,   16,  0,  3,  0 }, {      0,   19,   17,  0,  3,  0 }, {     -1,   19,   18,  0,  3,  0 }, {     -2,   19,   18,  0,  3,  0 }, {     -3,   19,   19,  0,  3,  0 },
    {     -4,   19,   20,  0,  3,  0 }, {     -5,   19,   21,  0,  3,  0 }, {     -6,   20,   22,  0,  3,  0 }, {     -7,   20,   23,  0,  3,  0 }, {     -8,   20,   24,  0,  3,  0 },
    {     -9,   20,   25,  0,  3,  0 }, {    -10,   20,   26,  0,  3,  0 }, {    -11,   20,   27,  0,  4,  0 }, {    -12,   20,   28,  0,  4,  0 }, {    -13,   20,   29,  0,  4,  0 },
    {    -13,   20,   30,  0,  4,  0 }, {    -14,   21,   31,  0,  4,  0 }, {    -15,   21,   32,  0,  4,  0 }, {    -16,   21,   33,  0,  4,  0 }, {    -16,   21,   34,  0,  4,  0 },
    {    -17,   21,   35,  0,  4,  0 }, {    -18,   21,   36,  0,  4,  0 }, {    -19,   21,   37,  0,  4,  0 }, {    -19,   21,   38,  0,  4,  0 }, {    -20,   22,   39,  0,  4,  0 },
    {    -20,   22,   40,  0,  4,  0 }, {    -21,   22,   41,  0,  4,  0 }, {    -22,   22,   42,  0,  4,  0 }, {    -22,   22,   43,  0,  9,  0 }, {    -23,   22,   44,  0,  9,  0 },
    {    -24,   22,   45,  0,  9,  0 }, {    -24,   22,   46,  0,  9,  0 }, {    -25,   22,   47,  0,  9,  0 }, {    -25,   22,   48,  0,  9,  0 }, {    -25,   23,   49,  0,  9,  0 },
    {    -26,   23,   50,  0,  9,  0 }, {    -26,   23,   51,  0,  9,  0 }, {    -26,   23,   52,  0,  9,  0 }, {    -27,   23,   53,  0,  9,  0 }, {    -27,   23,   54,  0,  9,  0 },
    {    -27,   23,   55,  0,  9,  0 }, {    -28,   23,   56,  0,  9,  0 }, {    -28,   23,   57,  0,  9,  0 }, {    -28,   23,   58,  0,  9,  0 }, {    -29,   24,   59,  0,  9,  0 },
    {    -29,   24,   60,  0,  9,  0 }, {    -29,   24,   61,  0,  9,  0 }, {    -30,   24,   62,  0,  9,  0 }, {    -30,   24,   63,  0,  9,  0 }, {    -30,   24,   64,  0, 10,  0 },
    {    -30,   24,   65,  0, 10,  0 }, {    -31,   24,   66,  0, 10,  0 }, {    -31,   24,   67,  0, 10,  0 }, {    -31,   24,   68,  0, 10,  0 }, {    -31,   25,   69,  0, 10,  0 },
    {    -31,   25,   70,  0, 10,  0 }, {    -32,   25,   71,  0, 10,  0 }, {    -32,   25,   72,  0, 10,  0 }, {    -32,   25,   73,  0, 10,  0 }, {    -32,   25,   74,  0, 10,  0 },
    {    -32,   25,   75,  0, 10,  0 }, {    -32,   25,   76,  0, 10,  0 }, {    -32,   25,   77,  0, 10,  0 }, {    -32,   25,   78,  0, 10,  0 }, {    -32,   25,   79,  0, 10,  0 },
    {    -32,   26,   80,  0, 10,  0 }, {    -32,   26,   81,  0, 10,  0 }, {    -32,   26,   82,  0, 10,  0 }, {    -32,   26,   83,  0, 10,  0 }, {    -32,   26,   84,  0, 10,  0 },
    {    -32,   26,   85,  0, 10,  0 }, {    -32,   26,   86,  0, 10,  0 }, {    -32,   26,   87,  0, 10,  0 }, {    -32,   26,   88,  0, 10,  0 }, {    -32,   26,   89,  0, 10,  0 },
    {    -32,   26,   90,  0, 10,  0 }, {    -32,   26,   91,  0, 11,  0 }, {    -32,   27,   92,  0, 11,  0 }, {    -31,   27,   93,  0, 11,  0 }, {    -31,   27,   94,  0, 11,  0 },
    {    -31,   27,   95,  0, 11,  0 }, {    -31,   27,   96,  0, 11,  0 }, {    -31,   27,   97,  0, 11,  0 }, {    -30,   27,   98,  0, 11,  0 }, {    -30,   27,   99,  0, 11,  0 },
    {    -30,   27,  100,  0, 11,  0 }, {    -30,   27,  101,  0, 11,  0 }, {    -29,   28,  102,  0, 11,  0 }, {    -29,   28,  103,  0, 11,  0 }, {    -29,   28,  104,  0, 11,  0 },
    {    -28,   28,  105,  0, 12,  0 }, {    -28,   28,  106,  0, 12,  0 }, {    -27,   28,  107,  0, 12,  0 }, {    -27,   28,  108,  0, 12,  0 }, {    -26,   28,  109,  0, 12,  0 },
    {    -26,   28,  110,  0, 12,  0 }, {    -26,   28,  111,  0, 12,  0 }, {    -25,   29,  112,  0, 12,  0 }, {    -25,   29,  113,  0, 12,  0 }, {    -24,   29,  114,  0, 13,  0 },
    {    -24,   29,  115,  0, 13,  0 }, {    -23,   29,  116,  0, 13,  0 }, {    -22,   29,  117,  0, 13,  0 }, {    -22,   29,  118,  0, 13,  0 }, {    -21,   29,  119,  0, 13,  0 },
    {    -20,   29,  120,  0, 13,  0 }, {    -19,   30,  121,  0, 13,  0 }, {    -18,   30,  122,  0, 14,  0 }, {    -17,   30,  123,  0, 14,  0 }, {    -16,   30,  124,  0, 14,  0 },
    {    -15,   30,  124,  0, 14,  0 }, {    -14,   30,  125,  0, 14,  0 }, {    -13,   30,  126,  0, 15,  0 }, {    -12,   30,  127,  0, 15,  0 }, {    -11,   31,  128,  0, 15,  0 },
    {    -10,   31,  128,  0, 15,  0 }, {     -9,   31,  129,  0, 15,  0 }, {     -8,   31,  129,  0, 16,  0 }, {     -7,   31,  129,  0, 16,  0 }, {     -6,   31,  130,  0, 16,  0 },
    {     -5,   31,  130,  0, 16,  0 }, {     -4,   31,  130,  0, 16,  0 }, {     -3,   31,  130,  0, 16,  0 }, {     -2,   31,  130,  0, 16,  0 }, {     -1,   31,  130,  0, 16,  0 },
    {      0,   32,  130,  0, 16,  0 }, {      1,   32,  130,  0, 16,  0 }, {      2,   32,  130,  0, 16,  0 }, {      3,   32,  130,  0, 16,  0 }, {      4,   32,  130,  0, 23,  0 },
    {      5,   32,  130,  0, 23,  0 }, {      6,   32,  129,  0, 23,  0 }, {      7,   32,  129,  0, 23,  0 }, {      8,   32,  129,  0, 23,  0 }, {      9,   32,  128,  0, 22,  0 },
    {     10,   32,  128,  0, 22,  0 }, {     11,   33,  127,  0, 22,  0 }, {     12,   33,  126,  0, 22,  0 }, {     13,   33,  125,  0, 22,  0 }, {     14,   33,  124,  0, 21,  0 },
    {     15,   33,  124,  0, 21,  0 }, {     16,   33,  123,  0, 21,  0 }, {     17,   33,  122,  0, 21,  0 }, {     18,   33,  121,  0, 21,  0 }, {     19,   34,  120,  0, 21,  0 },
    {     20,   34,  119,  0, 21,  0 }, {     21,   34,  118,  0, 21,  0 }, {     21,   34,  117,  0, 20,  0 }, {     22,   34,  116,  0, 20,  0 }, {     23,   34,  115,  0, 20,  0 },
    {     23,   34,  114,  0, 20,  0 }, {     24,   34,  113,  0, 20,  0 }, {     24,   34,  112,  0, 20,  0 }, {     25,   35,  111,  0, 20,  0 }, {     25,   35,  110,  0, 20,  0 },
    {     25,   35,  109,  0, 20,  0 }, {     26,   35,  108,  0, 19,  0 }, {     26,   35,  107,  0, 19,  0 }, {     27,   35,  106,  0, 19,  0 }, {     27,   35,  105,  0, 19,  0 },
    {     28,   35,  104,  0, 19,  0 }, {     28,   35,  103,  0, 19,  0 }, {     28,   35,  102,  0, 19,  0 }, {     29,   36,  101,  0, 19,  0 }, {     29,   36,  100,  0, 19,  0 },
    {     29,   36,   99,  0, 19,  0 }, {     29,   36,   98,  0, 19,  0 }, {     30,   36,   97,  0, 19,  0 }, {     30,   36,   96,  0, 19,  0 }, {     30,   36,   95,  0, 19,  0 },
    {     30,   36,   94,  0, 18,  0 }, {     30,   36,   93,  0, 18,  0 }, {     31,   36,   92,  0, 18,  0 }, {     31,   37,   91,  0, 18,  0 }, {     31,   37,   90,  0, 18,  0 },
    {     31,   37,   89,  0, 18,  0 }, {     31,   37,   88,  0, 18,  0 }, {     31,   37,   87,  0, 18,  0 }, {     31,   37,   86,  0, 18,  0 }, {     31,   37,   85,  0, 18,  0 },
    {     31,   37,   84,  0, 18,  0 }, {     31,   37,   83,  0, 18,  0 }, {     31,   37,   82,  0, 18,  0 }, {     31,   37,   81,  0, 18,  0 }, {     31,   37,   80,  0, 18,  0 },
    {     31,   38,   79,  0, 18,  0 }, {     31,   38,   78,  0, 18,  0 }, {     31,   38,   77,  0, 18,  0 }, {     31,   38,   76,  0, 18,  0 }, {     31,   38,   75,  0, 18,  0 },
    {     31,   38,   74,  0, 18,  0 }, {     31,   38,   73,  0, 18,  0 }, {     31,   38,   72,  0, 18,  0 }, {     31,   38,   71,  0, 18,  0 }, {     30,   38,   70,  0, 18,  0 },
    {     30,   38,   69,  0, 18,  0 }, {     30,   39,   68,  0, 18,  0 }, {     30,   39,   67,  0, 17,  0 }, {     30,   39,   66,  0, 17,  0 }, {     29,   39,   65,  0, 17,  0 },
    {     29,   39,   64,  0, 17,  0 }, {     29,   39,   63,  0, 17,  0 }, {     29,   39,   62,  0, 17,  0 }, {     28,   39,   61,  0, 17,  0 }, {     28,   39,   60,  0, 17,  0 },
    {     28,   39,   59,  0, 17,  0 }, {     27,   40,   58,  0, 17,  0 }, {     27,   40,   57,  0, 17,  0 }, {     27,   40,   56,  0, 17,  0 }, {     26,   40,   55,  0, 17,  0 },
    {     26,   40,   54,  0, 17,  0 }, {     26,   40,   53,  0, 17,  0 }, {     25,   40,   52,  0, 17,  0 }, {     25,   40,   51,  0, 17,  0 }, {     25,   40,   50,  0, 17,  0 },
    {     24,   40,   49,  0, 17,  0 }, {     24,   41,   48,  0, 17,  0 }, {     24,   41,   47,  0, 17,  0 }, {     23,   41,   46,  0,  8,  0 }, {     23,   41,   45,  0,  8,  0 },
    {     22,   41,   44,  0,  8,  0 }, {     21,   41,   43,  0,  8,  0 }, {     21,   41,   42,  0,  8,  0 }, {     20,   41,   41,  0,  8,  0 }, {     19,   41,   40,  0,  8,  0 },
    {     19,   41,   39,  0,  8,  0 }, {     18,   42,   38,  0,  8,  0 }, {     18,   42,   37,  0,  8,  0 }, {     17,   42,   36,  0,  8,  0 }, {     16,   42,   35,  0,  8,  0 },
    {     15,   42,   34,  0,  8,  0 }, {     15,   42,   33,  0,  8,  0 }, {     14,   42,   32,  0,  8,  0 }, {     13,   42,   31,  0,  8,  0 }, {     12,   43,   30,  0,  7,  0 },
    {     12,   43,   29,  0,  7,  0 }, {     11,   43,   28,  0,  7,  0 }, {     10,   43,   27,  0,  7,  0 }, {      9,   43,   26,  0,  7,  0 }, {      8,   43,   25,  0,  7,  0 },
    {      7,   43,   24,  0,  7,  0 }, {      6,   43,   23,  0,  7,  0 }, {      5,   43,   22,  0,  7,  0 }, {      4,   44,   21,  0,  7,  0 }, {      3,   44,   20,  0,  7,  0 },
    {      2,   44,   19,  0,  7,  0 }, {      1,   44,   18,  0,  7,  0 }, {      0,   44,   18,  0,  7,  0 }, {     -1,   44,   17,  0,  7,  0 }, {     -2,   44,   16,  0,  7,  0 },
    {     -3,   44,   15,  0,  7,  0 }, {     -4,   45,   15,  0,  7,  0 }, {     -5,   45,   14,  0,  7,  0 }, {     -6,   45,   13,  0,  7,  0 }, {     -7,   45,   12,  0,  7,  0 },
    {     -8,   45,   11,  0,  7,  0 }, {     -9,   45,   11,  0,  7,  0 }, {    -10,   45,   10,  0,  6,  0 }, {    -11,   45,   10,  0,  6,  0 }, {    -12,   45,    9,  0,  6,  0 },
    {    -13,   46,    9,  0,  6,  0 }, {    -14,   46,    8,  0,  6,  0 }, {    -15,   46,    8,  0,  6,  0 }, {    -16,   46,    7,  0,  6,  0 }, {    -17,   46,    7,  0,  6,  0 },
    {    -18,   46,    6,  0,  6,  0 }, {    -19,   46,    6,  0,  6,  0 }, {    -20,   46,    5,  0,  6,  0 }, {    -21,   46,    5,  0,  6,  0 }, {    -22,   46,    4,  0,  6,  0 },
    {    -23,   47,    4,  0,  6,  0 }, {    -24,   47,    3,  0,  6,  0 }, {    -25,   47,    3,  0,  6,  0 }, {    -26,   47,    3,  0,  6,  0 }, {    -27,   47,    2,  0,  6,  0 },
    {    -28,   47,    2,  0,  6,  0 }, {    -29,   47,    1,  0,  6,  0 }, {    -30,   47,    1,  0,  6,  0 }, {    -31,   47,    0,  0,  6,  0 }, {    -32,   48,    0,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D7B46, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    3,  8,  2,  0 }, {     16,    9,    4,  8,  2,  0 },
    {     17,   10,    4,  8,  2,  0 }, {     17,   11,    5,  8,  2,  0 }, {     17,   12,    5,  8,  2,  0 }, {     17,   13,    6,  8,  2,  0 }, {     17,   14,    6,  8,  2,  0 },
    {     17,   15,    7,  8,  2,  0 }, {     17,   16,    7,  8,  2,  0 }, {     17,   17,    8,  8,  2,  0 }, {     17,   18,    8,  8,  2,  0 }, {     17,   19,    9,  8,  3,  0 },
    {     18,   20,    9,  8,  3,  0 }, {     18,   21,   10,  8,  3,  0 }, {     18,   22,   10,  8,  3,  0 }, {     18,   23,   11,  8,  3,  0 }, {     18,   24,   11,  8,  3,  0 },
    {     18,   25,   12,  8,  3,  0 }, {     18,   26,   13,  8,  3,  0 }, {     18,   27,   14,  8,  3,  0 }, {     18,   28,   15,  8,  3,  0 }, {     19,   29,   15,  8,  3,  0 },
    {     19,   30,   16,  8,  3,  0 }, {     19,   31,   17,  8,  3,  0 }, {     19,   32,   18,  8,  3,  0 }, {     19,   33,   18,  8,  3,  0 }, {     19,   34,   19,  8,  3,  0 },
    {     19,   35,   20,  8,  3,  0 }, {     19,   36,   21,  8,  3,  0 }, {     20,   37,   22,  8,  3,  0 }, {     20,   38,   23,  8,  3,  0 }, {     20,   39,   24,  8,  3,  0 },
    {     20,   40,   25,  8,  3,  0 }, {     20,   41,   26,  8,  3,  0 }, {     20,   42,   27,  8,  4,  0 }, {     20,   43,   28,  8,  4,  0 }, {     20,   44,   29,  8,  4,  0 },
    {     20,   44,   30,  8,  4,  0 }, {     21,   45,   31,  8,  4,  0 }, {     21,   46,   32,  8,  4,  0 }, {     21,   47,   33,  8,  4,  0 }, {     21,   47,   34,  8,  4,  0 },
    {     21,   48,   35,  8,  4,  0 }, {     21,   49,   36,  8,  4,  0 }, {     21,   50,   37,  8,  4,  0 }, {     21,   50,   38,  8,  4,  0 }, {     22,   51,   39,  8,  4,  0 },
    {     22,   51,   40,  8,  4,  0 }, {     22,   52,   41,  8,  4,  0 }, {     22,   53,   42,  8,  4,  0 }, {     22,   53,   43,  8,  9,  0 }, {     22,   54,   44,  8,  9,  0 },
    {     22,   55,   45,  8,  9,  0 }, {     22,   55,   46,  8,  9,  0 }, {     22,   56,   47,  8,  9,  0 }, {     22,   56,   48,  8,  9,  0 }, {     23,   56,   49,  8,  9,  0 },
    {     23,   57,   50,  8,  9,  0 }, {     23,   57,   51,  8,  9,  0 }, {     23,   57,   52,  8,  9,  0 }, {     23,   58,   53,  8,  9,  0 }, {     23,   58,   54,  8,  9,  0 },
    {     23,   58,   55,  8,  9,  0 }, {     23,   59,   56,  8,  9,  0 }, {     23,   59,   57,  8,  9,  0 }, {     23,   59,   58,  8,  9,  0 }, {     24,   60,   59,  8,  9,  0 },
    {     24,   60,   60,  8,  9,  0 }, {     24,   60,   61,  8,  9,  0 }, {     24,   61,   62,  8,  9,  0 }, {     24,   61,   63,  8,  9,  0 }, {     24,   61,   64,  8, 10,  0 },
    {     24,   61,   65,  8, 10,  0 }, {     24,   62,   66,  8, 10,  0 }, {     24,   62,   67,  8, 10,  0 }, {     24,   62,   68,  8, 10,  0 }, {     25,   62,   69,  8, 10,  0 },
    {     25,   62,   70,  8, 10,  0 }, {     25,   63,   71,  8, 10,  0 }, {     25,   63,   72,  8, 10,  0 }, {     25,   63,   73,  8, 10,  0 }, {     25,   63,   74,  8, 10,  0 },
    {     25,   63,   75,  8, 10,  0 }, {     25,   63,   76,  8, 10,  0 }, {     25,   63,   77,  8, 10,  0 }, {     25,   63,   78,  8, 10,  0 }, {     25,   63,   79,  8, 10,  0 },
    {     26,   63,   80,  8, 10,  0 }, {     26,   63,   81,  8, 10,  0 }, {     26,   63,   82,  8, 10,  0 }, {     26,   63,   83,  8, 10,  0 }, {     26,   63,   84,  8, 10,  0 },
    {     26,   63,   85,  8, 10,  0 }, {     26,   63,   86,  8, 10,  0 }, {     26,   63,   87,  8, 10,  0 }, {     26,   63,   88,  8, 10,  0 }, {     26,   63,   89,  8, 10,  0 },
    {     26,   63,   90,  8, 10,  0 }, {     26,   63,   91,  8, 11,  0 }, {     27,   63,   92,  8, 11,  0 }, {     27,   62,   93,  8, 11,  0 }, {     27,   62,   94,  8, 11,  0 },
    {     27,   62,   95,  8, 11,  0 }, {     27,   62,   96,  8, 11,  0 }, {     27,   62,   97,  8, 11,  0 }, {     27,   61,   98,  8, 11,  0 }, {     27,   61,   99,  8, 11,  0 },
    {     27,   61,  100,  8, 11,  0 }, {     27,   61,  101,  8, 11,  0 }, {     28,   60,  102,  8, 11,  0 }, {     28,   60,  103,  8, 11,  0 }, {     28,   60,  104,  8, 11,  0 },
    {     28,   59,  105,  8, 12,  0 }, {     28,   59,  106,  8, 12,  0 }, {     28,   58,  107,  8, 12,  0 }, {     28,   58,  108,  8, 12,  0 }, {     28,   57,  109,  8, 12,  0 },
    {     28,   57,  110,  8, 12,  0 }, {     28,   57,  111,  8, 12,  0 }, {     29,   56,  112,  8, 12,  0 }, {     29,   56,  113,  8, 12,  0 }, {     29,   55,  114,  8, 13,  0 },
    {     29,   55,  115,  8, 13,  0 }, {     29,   54,  116,  8, 13,  0 }, {     29,   53,  117,  8, 13,  0 }, {     29,   53,  118,  8, 13,  0 }, {     29,   52,  119,  8, 13,  0 },
    {     29,   51,  120,  8, 13,  0 }, {     30,   50,  121,  8, 13,  0 }, {     30,   49,  122,  8, 14,  0 }, {     30,   48,  123,  8, 14,  0 }, {     30,   47,  124,  8, 14,  0 },
    {     30,   46,  124,  8, 14,  0 }, {     30,   45,  125,  8, 14,  0 }, {     30,   44,  126,  8, 15,  0 }, {     30,   43,  127,  8, 15,  0 }, {     31,   42,  128,  8, 15,  0 },
    {     31,   41,  128,  8, 15,  0 }, {     31,   40,  129,  8, 15,  0 }, {     31,   39,  129,  8, 16,  0 }, {     31,   38,  129,  8, 16,  0 }, {     31,   37,  130,  8, 16,  0 },
    {     31,   36,  130,  8, 16,  0 }, {     31,   35,  130,  8, 16,  0 }, {     31,   34,  130,  8, 16,  0 }, {     31,   33,  130,  8, 16,  0 }, {     31,   32,  130,  8, 16,  0 },
    {     32,   31,  130,  8, 16,  0 }, {     32,   30,  130,  8, 16,  0 }, {     32,   29,  130,  8, 16,  0 }, {     32,   28,  130,  8, 16,  0 }, {     32,   27,  130,  8, 23,  0 },
    {     32,   26,  130,  8, 23,  0 }, {     32,   25,  129,  8, 23,  0 }, {     32,   24,  129,  8, 23,  0 }, {     32,   23,  129,  8, 23,  0 }, {     32,   22,  128,  8, 22,  0 },
    {     32,   21,  128,  8, 22,  0 }, {     33,   20,  127,  8, 22,  0 }, {     33,   19,  126,  8, 22,  0 }, {     33,   18,  125,  8, 22,  0 }, {     33,   17,  124,  8, 21,  0 },
    {     33,   16,  124,  8, 21,  0 }, {     33,   15,  123,  8, 21,  0 }, {     33,   14,  122,  8, 21,  0 }, {     33,   13,  121,  8, 21,  0 }, {     34,   12,  120,  8, 21,  0 },
    {     34,   11,  119,  8, 21,  0 }, {     34,   10,  118,  8, 21,  0 }, {     34,   10,  117,  8, 20,  0 }, {     34,    9,  116,  8, 20,  0 }, {     34,    8,  115,  8, 20,  0 },
    {     34,    8,  114,  8, 20,  0 }, {     34,    7,  113,  8, 20,  0 }, {     34,    7,  112,  8, 20,  0 }, {     35,    6,  111,  8, 20,  0 }, {     35,    6,  110,  8, 20,  0 },
    {     35,    6,  109,  8, 20,  0 }, {     35,    5,  108,  8, 19,  0 }, {     35,    5,  107,  8, 19,  0 }, {     35,    4,  106,  8, 19,  0 }, {     35,    4,  105,  8, 19,  0 },
    {     35,    3,  104,  8, 19,  0 }, {     35,    3,  103,  8, 19,  0 }, {     35,    3,  102,  8, 19,  0 }, {     36,    2,  101,  8, 19,  0 }, {     36,    2,  100,  8, 19,  0 },
    {     36,    2,   99,  8, 19,  0 }, {     36,    2,   98,  8, 19,  0 }, {     36,    1,   97,  8, 19,  0 }, {     36,    1,   96,  8, 19,  0 }, {     36,    1,   95,  8, 19,  0 },
    {     36,    1,   94,  8, 18,  0 }, {     36,    1,   93,  8, 18,  0 }, {     36,    0,   92,  8, 18,  0 }, {     37,    0,   91,  8, 18,  0 }, {     37,    0,   90,  8, 18,  0 },
    {     37,    0,   89,  8, 18,  0 }, {     37,    0,   88,  8, 18,  0 }, {     37,    0,   87,  8, 18,  0 }, {     37,    0,   86,  8, 18,  0 }, {     37,    0,   85,  8, 18,  0 },
    {     37,    0,   84,  8, 18,  0 }, {     37,    0,   83,  8, 18,  0 }, {     37,    0,   82,  8, 18,  0 }, {     37,    0,   81,  8, 18,  0 }, {     37,    0,   80,  8, 18,  0 },
    {     38,    0,   79,  8, 18,  0 }, {     38,    0,   78,  8, 18,  0 }, {     38,    0,   77,  8, 18,  0 }, {     38,    0,   76,  8, 18,  0 }, {     38,    0,   75,  8, 18,  0 },
    {     38,    0,   74,  8, 18,  0 }, {     38,    0,   73,  8, 18,  0 }, {     38,    0,   72,  8, 18,  0 }, {     38,    0,   71,  8, 18,  0 }, {     38,    1,   70,  8, 18,  0 },
    {     38,    1,   69,  8, 18,  0 }, {     39,    1,   68,  8, 18,  0 }, {     39,    1,   67,  8, 17,  0 }, {     39,    1,   66,  8, 17,  0 }, {     39,    2,   65,  8, 17,  0 },
    {     39,    2,   64,  8, 17,  0 }, {     39,    2,   63,  8, 17,  0 }, {     39,    2,   62,  8, 17,  0 }, {     39,    3,   61,  8, 17,  0 }, {     39,    3,   60,  8, 17,  0 },
    {     39,    3,   59,  8, 17,  0 }, {     40,    4,   58,  8, 17,  0 }, {     40,    4,   57,  8, 17,  0 }, {     40,    4,   56,  8, 17,  0 }, {     40,    5,   55,  8, 17,  0 },
    {     40,    5,   54,  8, 17,  0 }, {     40,    5,   53,  8, 17,  0 }, {     40,    6,   52,  8, 17,  0 }, {     40,    6,   51,  8, 17,  0 }, {     40,    6,   50,  8, 17,  0 },
    {     40,    7,   49,  8, 17,  0 }, {     41,    7,   48,  8, 17,  0 }, {     41,    7,   47,  8, 17,  0 }, {     41,    8,   46,  8,  8,  0 }, {     41,    8,   45,  8,  8,  0 },
    {     41,    9,   44,  8,  8,  0 }, {     41,   10,   43,  8,  8,  0 }, {     41,   10,   42,  8,  8,  0 }, {     41,   11,   41,  8,  8,  0 }, {     41,   12,   40,  8,  8,  0 },
    {     41,   12,   39,  8,  8,  0 }, {     42,   13,   38,  8,  8,  0 }, {     42,   13,   37,  8,  8,  0 }, {     42,   14,   36,  8,  8,  0 }, {     42,   15,   35,  8,  8,  0 },
    {     42,   16,   34,  8,  8,  0 }, {     42,   16,   33,  8,  8,  0 }, {     42,   17,   32,  8,  8,  0 }, {     42,   18,   31,  8,  8,  0 }, {     43,   19,   30,  8,  7,  0 },
    {     43,   19,   29,  8,  7,  0 }, {     43,   20,   28,  8,  7,  0 }, {     43,   21,   27,  8,  7,  0 }, {     43,   22,   26,  8,  7,  0 }, {     43,   23,   25,  8,  7,  0 },
    {     43,   24,   24,  8,  7,  0 }, {     43,   25,   23,  8,  7,  0 }, {     43,   26,   22,  8,  7,  0 }, {     44,   27,   21,  8,  7,  0 }, {     44,   28,   20,  8,  7,  0 },
    {     44,   29,   19,  8,  7,  0 }, {     44,   30,   18,  8,  7,  0 }, {     44,   31,   18,  8,  7,  0 }, {     44,   32,   17,  8,  7,  0 }, {     44,   33,   16,  8,  7,  0 },
    {     44,   34,   15,  8,  7,  0 }, {     45,   35,   15,  8,  7,  0 }, {     45,   36,   14,  8,  7,  0 }, {     45,   37,   13,  8,  7,  0 }, {     45,   38,   12,  8,  7,  0 },
    {     45,   39,   11,  8,  7,  0 }, {     45,   40,   11,  8,  7,  0 }, {     45,   41,   10,  8,  6,  0 }, {     45,   42,   10,  8,  6,  0 }, {     45,   43,    9,  8,  6,  0 },
    {     46,   44,    9,  8,  6,  0 }, {     46,   45,    8,  8,  6,  0 }, {     46,   46,    8,  8,  6,  0 }, {     46,   47,    7,  8,  6,  0 }, {     46,   48,    7,  8,  6,  0 },
    {     46,   49,    6,  8,  6,  0 }, {     46,   50,    6,  8,  6,  0 }, {     46,   51,    5,  8,  6,  0 }, {     46,   52,    5,  8,  6,  0 }, {     46,   53,    4,  8,  6,  0 },
    {     47,   54,    4,  8,  6,  0 }, {     47,   55,    3,  8,  6,  0 }, {     47,   56,    3,  8,  6,  0 }, {     47,   57,    3,  8,  6,  0 }, {     47,   58,    2,  8,  6,  0 },
    {     47,   59,    2,  8,  6,  0 }, {     47,   60,    1,  8,  6,  0 }, {     47,   61,    1,  8,  6,  0 }, {     47,   62,    0,  8,  6,  0 }, {     48,   63,    0,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D862E, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   15,    0, 16,  2,  0 }, {      2,   15,    1, 16,  2,  0 }, {      3,   15,    1, 16,  2,  0 }, {      4,   15,    2, 16,  2,  0 },
    {      5,   15,    2, 16,  2,  0 }, {      6,   15,    3, 16,  2,  0 }, {      7,   15,    3, 16,  2,  0 }, {      8,   15,    3, 16,  2,  0 }, {      9,   15,    4, 16,  2,  0 },
    {     10,   14,    4, 16,  2,  0 }, {     11,   14,    5, 16,  2,  0 }, {     12,   14,    5, 16,  2,  0 }, {     13,   14,    6, 16,  2,  0 }, {     14,   14,    6, 16,  2,  0 },
    {     15,   14,    7, 16,  2,  0 }, {     16,   14,    7, 16,  2,  0 }, {     17,   14,    8, 16,  2,  0 }, {     18,   14,    8, 16,  2,  0 }, {     19,   14,    9, 16,  3,  0 },
    {     20,   13,    9, 16,  3,  0 }, {     21,   13,   10, 16,  3,  0 }, {     22,   13,   10, 16,  3,  0 }, {     23,   13,   11, 16,  3,  0 }, {     24,   13,   11, 16,  3,  0 },
    {     25,   13,   12, 16,  3,  0 }, {     26,   13,   13, 16,  3,  0 }, {     27,   13,   14, 16,  3,  0 }, {     28,   13,   15, 16,  3,  0 }, {     29,   12,   15, 16,  3,  0 },
    {     30,   12,   16, 16,  3,  0 }, {     31,   12,   17, 16,  3,  0 }, {     32,   12,   18, 16,  3,  0 }, {     33,   12,   18, 16,  3,  0 }, {     34,   12,   19, 16,  3,  0 },
    {     35,   12,   20, 16,  3,  0 }, {     36,   12,   21, 16,  3,  0 }, {     37,   11,   22, 16,  3,  0 }, {     38,   11,   23, 16,  3,  0 }, {     39,   11,   24, 16,  3,  0 },
    {     40,   11,   25, 16,  3,  0 }, {     41,   11,   26, 16,  3,  0 }, {     42,   11,   27, 16,  4,  0 }, {     43,   11,   28, 16,  4,  0 }, {     44,   11,   29, 16,  4,  0 },
    {     44,   11,   30, 16,  4,  0 }, {     45,   10,   31, 16,  4,  0 }, {     46,   10,   32, 16,  4,  0 }, {     47,   10,   33, 16,  4,  0 }, {     47,   10,   34, 16,  4,  0 },
    {     48,   10,   35, 16,  4,  0 }, {     49,   10,   36, 16,  4,  0 }, {     50,   10,   37, 16,  4,  0 }, {     50,   10,   38, 16,  4,  0 }, {     51,   10,   39, 16,  4,  0 },
    {     51,    9,   40, 16,  4,  0 }, {     52,    9,   41, 16,  4,  0 }, {     53,    9,   42, 16,  4,  0 }, {     53,    9,   43, 16,  9,  0 }, {     54,    9,   44, 16,  9,  0 },
    {     55,    9,   45, 16,  9,  0 }, {     55,    9,   46, 16,  9,  0 }, {     56,    9,   47, 16,  9,  0 }, {     56,    9,   48, 16,  9,  0 }, {     56,    8,   49, 16,  9,  0 },
    {     57,    8,   50, 16,  9,  0 }, {     57,    8,   51, 16,  9,  0 }, {     57,    8,   52, 16,  9,  0 }, {     58,    8,   53, 16,  9,  0 }, {     58,    8,   54, 16,  9,  0 },
    {     58,    8,   55, 16,  9,  0 }, {     59,    8,   56, 16,  9,  0 }, {     59,    8,   57, 16,  9,  0 }, {     59,    8,   58, 16,  9,  0 }, {     60,    7,   59, 16,  9,  0 },
    {     60,    7,   60, 16,  9,  0 }, {     60,    7,   61, 16,  9,  0 }, {     61,    7,   62, 16,  9,  0 }, {     61,    7,   63, 16,  9,  0 }, {     61,    7,   64, 16, 10,  0 },
    {     61,    7,   65, 16, 10,  0 }, {     62,    7,   66, 16, 10,  0 }, {     62,    7,   67, 16, 10,  0 }, {     62,    7,   68, 16, 10,  0 }, {     62,    6,   69, 16, 10,  0 },
    {     62,    6,   70, 16, 10,  0 }, {     63,    6,   71, 16, 10,  0 }, {     63,    6,   72, 16, 10,  0 }, {     63,    6,   73, 16, 10,  0 }, {     63,    6,   74, 16, 10,  0 },
    {     63,    6,   75, 16, 10,  0 }, {     63,    6,   76, 16, 10,  0 }, {     63,    6,   77, 16, 10,  0 }, {     63,    6,   78, 16, 10,  0 }, {     63,    6,   79, 16, 10,  0 },
    {     63,    5,   80, 16, 10,  0 }, {     63,    5,   81, 16, 10,  0 }, {     63,    5,   82, 16, 10,  0 }, {     63,    5,   83, 16, 10,  0 }, {     63,    5,   84, 16, 10,  0 },
    {     63,    5,   85, 16, 10,  0 }, {     63,    5,   86, 16, 10,  0 }, {     63,    5,   87, 16, 10,  0 }, {     63,    5,   88, 16, 10,  0 }, {     63,    5,   89, 16, 10,  0 },
    {     63,    5,   90, 16, 10,  0 }, {     63,    5,   91, 16, 11,  0 }, {     63,    4,   92, 16, 11,  0 }, {     62,    4,   93, 16, 11,  0 }, {     62,    4,   94, 16, 11,  0 },
    {     62,    4,   95, 16, 11,  0 }, {     62,    4,   96, 16, 11,  0 }, {     62,    4,   97, 16, 11,  0 }, {     61,    4,   98, 16, 11,  0 }, {     61,    4,   99, 16, 11,  0 },
    {     61,    4,  100, 16, 11,  0 }, {     61,    4,  101, 16, 11,  0 }, {     60,    3,  102, 16, 11,  0 }, {     60,    3,  103, 16, 11,  0 }, {     60,    3,  104, 16, 11,  0 },
    {     59,    3,  105, 16, 12,  0 }, {     59,    3,  106, 16, 12,  0 }, {     58,    3,  107, 16, 12,  0 }, {     58,    3,  108, 16, 12,  0 }, {     57,    3,  109, 16, 12,  0 },
    {     57,    3,  110, 16, 12,  0 }, {     57,    3,  111, 16, 12,  0 }, {     56,    2,  112, 16, 12,  0 }, {     56,    2,  113, 16, 12,  0 }, {     55,    2,  114, 16, 13,  0 },
    {     55,    2,  115, 16, 13,  0 }, {     54,    2,  116, 16, 13,  0 }, {     53,    2,  117, 16, 13,  0 }, {     53,    2,  118, 16, 13,  0 }, {     52,    2,  119, 16, 13,  0 },
    {     51,    2,  120, 16, 13,  0 }, {     50,    1,  121, 16, 13,  0 }, {     49,    1,  122, 16, 14,  0 }, {     48,    1,  123, 16, 14,  0 }, {     47,    1,  124, 16, 14,  0 },
    {     46,    1,  124, 16, 14,  0 }, {     45,    1,  125, 16, 14,  0 }, {     44,    1,  126, 16, 15,  0 }, {     43,    1,  127, 16, 15,  0 }, {     42,    0,  128, 16, 15,  0 },
    {     41,    0,  128, 16, 15,  0 }, {     40,    0,  129, 16, 15,  0 }, {     39,    0,  129, 16, 16,  0 }, {     38,    0,  129, 16, 16,  0 }, {     37,    0,  130, 16, 16,  0 },
    {     36,    0,  130, 16, 16,  0 }, {     35,    0,  130, 16, 16,  0 }, {     34,    0,  130, 16, 16,  0 }, {     33,    0,  130, 16, 16,  0 }, {     32,    0,  130, 16, 16,  0 },
    {     31,    0,  130, 16, 16,  0 }, {     30,    0,  130, 16, 16,  0 }, {     29,    0,  130, 16, 16,  0 }, {     28,    0,  130, 16, 16,  0 }, {     27,    0,  130, 16, 23,  0 },
    {     26,    0,  130, 16, 23,  0 }, {     25,    0,  129, 16, 23,  0 }, {     24,    0,  129, 16, 23,  0 }, {     23,    0,  129, 16, 23,  0 }, {     22,    0,  128, 16, 22,  0 },
    {     21,    0,  128, 16, 22,  0 }, {     20,   -1,  127, 16, 22,  0 }, {     19,   -1,  126, 16, 22,  0 }, {     18,   -1,  125, 16, 22,  0 }, {     17,   -1,  124, 16, 21,  0 },
    {     16,   -1,  124, 16, 21,  0 }, {     15,   -1,  123, 16, 21,  0 }, {     14,   -1,  122, 16, 21,  0 }, {     13,   -1,  121, 16, 21,  0 }, {     12,   -2,  120, 16, 21,  0 },
    {     11,   -2,  119, 16, 21,  0 }, {     10,   -2,  118, 16, 21,  0 }, {     10,   -2,  117, 16, 20,  0 }, {      9,   -2,  116, 16, 20,  0 }, {      8,   -2,  115, 16, 20,  0 },
    {      8,   -2,  114, 16, 20,  0 }, {      7,   -2,  113, 16, 20,  0 }, {      7,   -2,  112, 16, 20,  0 }, {      6,   -3,  111, 16, 20,  0 }, {      6,   -3,  110, 16, 20,  0 },
    {      6,   -3,  109, 16, 20,  0 }, {      5,   -3,  108, 16, 19,  0 }, {      5,   -3,  107, 16, 19,  0 }, {      4,   -3,  106, 16, 19,  0 }, {      4,   -3,  105, 16, 19,  0 },
    {      3,   -3,  104, 16, 19,  0 }, {      3,   -3,  103, 16, 19,  0 }, {      3,   -3,  102, 16, 19,  0 }, {      2,   -4,  101, 16, 19,  0 }, {      2,   -4,  100, 16, 19,  0 },
    {      2,   -4,   99, 16, 19,  0 }, {      2,   -4,   98, 16, 19,  0 }, {      1,   -4,   97, 16, 19,  0 }, {      1,   -4,   96, 16, 19,  0 }, {      1,   -4,   95, 16, 19,  0 },
    {      1,   -4,   94, 16, 18,  0 }, {      1,   -4,   93, 16, 18,  0 }, {      0,   -4,   92, 16, 18,  0 }, {      0,   -5,   91, 16, 18,  0 }, {      0,   -5,   90, 16, 18,  0 },
    {      0,   -5,   89, 16, 18,  0 }, {      0,   -5,   88, 16, 18,  0 }, {      0,   -5,   87, 16, 18,  0 }, {      0,   -5,   86, 16, 18,  0 }, {      0,   -5,   85, 16, 18,  0 },
    {      0,   -5,   84, 16, 18,  0 }, {      0,   -5,   83, 16, 18,  0 }, {      0,   -5,   82, 16, 18,  0 }, {      0,   -5,   81, 16, 18,  0 }, {      0,   -5,   80, 16, 18,  0 },
    {      0,   -6,   79, 16, 18,  0 }, {      0,   -6,   78, 16, 18,  0 }, {      0,   -6,   77, 16, 18,  0 }, {      0,   -6,   76, 16, 18,  0 }, {      0,   -6,   75, 16, 18,  0 },
    {      0,   -6,   74, 16, 18,  0 }, {      0,   -6,   73, 16, 18,  0 }, {      0,   -6,   72, 16, 18,  0 }, {      0,   -6,   71, 16, 18,  0 }, {      1,   -6,   70, 16, 18,  0 },
    {      1,   -6,   69, 16, 18,  0 }, {      1,   -7,   68, 16, 18,  0 }, {      1,   -7,   67, 16, 17,  0 }, {      1,   -7,   66, 16, 17,  0 }, {      2,   -7,   65, 16, 17,  0 },
    {      2,   -7,   64, 16, 17,  0 }, {      2,   -7,   63, 16, 17,  0 }, {      2,   -7,   62, 16, 17,  0 }, {      3,   -7,   61, 16, 17,  0 }, {      3,   -7,   60, 16, 17,  0 },
    {      3,   -7,   59, 16, 17,  0 }, {      4,   -8,   58, 16, 17,  0 }, {      4,   -8,   57, 16, 17,  0 }, {      4,   -8,   56, 16, 17,  0 }, {      5,   -8,   55, 16, 17,  0 },
    {      5,   -8,   54, 16, 17,  0 }, {      5,   -8,   53, 16, 17,  0 }, {      6,   -8,   52, 16, 17,  0 }, {      6,   -8,   51, 16, 17,  0 }, {      6,   -8,   50, 16, 17,  0 },
    {      7,   -8,   49, 16, 17,  0 }, {      7,   -9,   48, 16, 17,  0 }, {      7,   -9,   47, 16, 17,  0 }, {      8,   -9,   46, 16,  8,  0 }, {      8,   -9,   45, 16,  8,  0 },
    {      9,   -9,   44, 16,  8,  0 }, {     10,   -9,   43, 16,  8,  0 }, {     10,   -9,   42, 16,  8,  0 }, {     11,   -9,   41, 16,  8,  0 }, {     12,   -9,   40, 16,  8,  0 },
    {     12,   -9,   39, 16,  8,  0 }, {     13,  -10,   38, 16,  8,  0 }, {     13,  -10,   37, 16,  8,  0 }, {     14,  -10,   36, 16,  8,  0 }, {     15,  -10,   35, 16,  8,  0 },
    {     16,  -10,   34, 16,  8,  0 }, {     16,  -10,   33, 16,  8,  0 }, {     17,  -10,   32, 16,  8,  0 }, {     18,  -10,   31, 16,  8,  0 }, {     19,  -11,   30, 16,  7,  0 },
    {     19,  -11,   29, 16,  7,  0 }, {     20,  -11,   28, 16,  7,  0 }, {     21,  -11,   27, 16,  7,  0 }, {     22,  -11,   26, 16,  7,  0 }, {     23,  -11,   25, 16,  7,  0 },
    {     24,  -11,   24, 16,  7,  0 }, {     25,  -11,   23, 16,  7,  0 }, {     26,  -11,   22, 16,  7,  0 }, {     27,  -12,   21, 16,  7,  0 }, {     28,  -12,   20, 16,  7,  0 },
    {     29,  -12,   19, 16,  7,  0 }, {     30,  -12,   18, 16,  7,  0 }, {     31,  -12,   18, 16,  7,  0 }, {     32,  -12,   17, 16,  7,  0 }, {     33,  -12,   16, 16,  7,  0 },
    {     34,  -12,   15, 16,  7,  0 }, {     35,  -13,   15, 16,  7,  0 }, {     36,  -13,   14, 16,  7,  0 }, {     37,  -13,   13, 16,  7,  0 }, {     38,  -13,   12, 16,  7,  0 },
    {     39,  -13,   11, 16,  7,  0 }, {     40,  -13,   11, 16,  7,  0 }, {     41,  -13,   10, 16,  6,  0 }, {     42,  -13,   10, 16,  6,  0 }, {     43,  -13,    9, 16,  6,  0 },
    {     44,  -14,    9, 16,  6,  0 }, {     45,  -14,    8, 16,  6,  0 }, {     46,  -14,    8, 16,  6,  0 }, {     47,  -14,    7, 16,  6,  0 }, {     48,  -14,    7, 16,  6,  0 },
    {     49,  -14,    6, 16,  6,  0 }, {     50,  -14,    6, 16,  6,  0 }, {     51,  -14,    5, 16,  6,  0 }, {     52,  -14,    5, 16,  6,  0 }, {     53,  -14,    4, 16,  6,  0 },
    {     54,  -15,    4, 16,  6,  0 }, {     55,  -15,    3, 16,  6,  0 }, {     56,  -15,    3, 16,  6,  0 }, {     57,  -15,    3, 16,  6,  0 }, {     58,  -15,    2, 16,  6,  0 },
    {     59,  -15,    2, 16,  6,  0 }, {     60,  -15,    1, 16,  6,  0 }, {     61,  -15,    1, 16,  6,  0 }, {     62,  -15,    0, 16,  6,  0 }, {     63,  -16,    0, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9116, {
    {     16,   31,    0, 24,  2,  0 }, {     15,   30,    0, 24,  2,  0 }, {     15,   29,    1, 24,  2,  0 }, {     15,   28,    1, 24,  2,  0 }, {     15,   27,    2, 24,  2,  0 },
    {     15,   26,    2, 24,  2,  0 }, {     15,   25,    3, 24,  2,  0 }, {     15,   24,    3, 24,  2,  0 }, {     15,   23,    3, 24,  2,  0 }, {     15,   22,    4, 24,  2,  0 },
    {     14,   21,    4, 24,  2,  0 }, {     14,   20,    5, 24,  2,  0 }, {     14,   19,    5, 24,  2,  0 }, {     14,   18,    6, 24,  2,  0 }, {     14,   17,    6, 24,  2,  0 },
    {     14,   16,    7, 24,  2,  0 }, {     14,   15,    7, 24,  2,  0 }, {     14,   14,    8, 24,  2,  0 }, {     14,   13,    8, 24,  2,  0 }, {     14,   12,    9, 24,  3,  0 },
    {     13,   11,    9, 24,  3,  0 }, {     13,   10,   10, 24,  3,  0 }, {     13,    9,   10, 24,  3,  0 }, {     13,    8,   11, 24,  3,  0 }, {     13,    7,   11, 24,  3,  0 },
    {     13,    6,   12, 24,  3,  0 }, {     13,    5,   13, 24,  3,  0 }, {     13,    4,   14, 24,  3,  0 }, {     13,    3,   15, 24,  3,  0 }, {     12,    2,   15, 24,  3,  0 },
    {     12,    1,   16, 24,  3,  0 }, {     12,    0,   17, 24,  3,  0 }, {     12,   -1,   18, 24,  3,  0 }, {     12,   -2,   18, 24,  3,  0 }, {     12,   -3,   19, 24,  3,  0 },
    {     12,   -4,   20, 24,  3,  0 }, {     12,   -5,   21, 24,  3,  0 }, {     11,   -6,   22, 24,  3,  0 }, {     11,   -7,   23, 24,  3,  0 }, {     11,   -8,   24, 24,  3,  0 },
    {     11,   -9,   25, 24,  3,  0 }, {     11,  -10,   26, 24,  3,  0 }, {     11,  -11,   27, 24,  4,  0 }, {     11,  -12,   28, 24,  4,  0 }, {     11,  -13,   29, 24,  4,  0 },
    {     11,  -13,   30, 24,  4,  0 }, {     10,  -14,   31, 24,  4,  0 }, {     10,  -15,   32, 24,  4,  0 }, {     10,  -16,   33, 24,  4,  0 }, {     10,  -16,   34, 24,  4,  0 },
    {     10,  -17,   35, 24,  4,  0 }, {     10,  -18,   36, 24,  4,  0 }, {     10,  -19,   37, 24,  4,  0 }, {     10,  -19,   38, 24,  4,  0 }, {     10,  -20,   39, 24,  4,  0 },
    {      9,  -20,   40, 24,  4,  0 }, {      9,  -21,   41, 24,  4,  0 }, {      9,  -22,   42, 24,  4,  0 }, {      9,  -22,   43, 24,  9,  0 }, {      9,  -23,   44, 24,  9,  0 },
    {      9,  -24,   45, 24,  9,  0 }, {      9,  -24,   46, 24,  9,  0 }, {      9,  -25,   47, 24,  9,  0 }, {      9,  -25,   48, 24,  9,  0 }, {      8,  -25,   49, 24,  9,  0 },
    {      8,  -26,   50, 24,  9,  0 }, {      8,  -26,   51, 24,  9,  0 }, {      8,  -26,   52, 24,  9,  0 }, {      8,  -27,   53, 24,  9,  0 }, {      8,  -27,   54, 24,  9,  0 },
    {      8,  -27,   55, 24,  9,  0 }, {      8,  -28,   56, 24,  9,  0 }, {      8,  -28,   57, 24,  9,  0 }, {      8,  -28,   58, 24,  9,  0 }, {      7,  -29,   59, 24,  9,  0 },
    {      7,  -29,   60, 24,  9,  0 }, {      7,  -29,   61, 24,  9,  0 }, {      7,  -30,   62, 24,  9,  0 }, {      7,  -30,   63, 24,  9,  0 }, {      7,  -30,   64, 24, 10,  0 },
    {      7,  -30,   65, 24, 10,  0 }, {      7,  -31,   66, 24, 10,  0 }, {      7,  -31,   67, 24, 10,  0 }, {      7,  -31,   68, 24, 10,  0 }, {      6,  -31,   69, 24, 10,  0 },
    {      6,  -31,   70, 24, 10,  0 }, {      6,  -32,   71, 24, 10,  0 }, {      6,  -32,   72, 24, 10,  0 }, {      6,  -32,   73, 24, 10,  0 }, {      6,  -32,   74, 24, 10,  0 },
    {      6,  -32,   75, 24, 10,  0 }, {      6,  -32,   76, 24, 10,  0 }, {      6,  -32,   77, 24, 10,  0 }, {      6,  -32,   78, 24, 10,  0 }, {      6,  -32,   79, 24, 10,  0 },
    {      5,  -32,   80, 24, 10,  0 }, {      5,  -32,   81, 24, 10,  0 }, {      5,  -32,   82, 24, 10,  0 }, {      5,  -32,   83, 24, 10,  0 }, {      5,  -32,   84, 24, 10,  0 },
    {      5,  -32,   85, 24, 10,  0 }, {      5,  -32,   86, 24, 10,  0 }, {      5,  -32,   87, 24, 10,  0 }, {      5,  -32,   88, 24, 10,  0 }, {      5,  -32,   89, 24, 10,  0 },
    {      5,  -32,   90, 24, 10,  0 }, {      5,  -32,   91, 24, 11,  0 }, {      4,  -32,   92, 24, 11,  0 }, {      4,  -31,   93, 24, 11,  0 }, {      4,  -31,   94, 24, 11,  0 },
    {      4,  -31,   95, 24, 11,  0 }, {      4,  -31,   96, 24, 11,  0 }, {      4,  -31,   97, 24, 11,  0 }, {      4,  -30,   98, 24, 11,  0 }, {      4,  -30,   99, 24, 11,  0 },
    {      4,  -30,  100, 24, 11,  0 }, {      4,  -30,  101, 24, 11,  0 }, {      3,  -29,  102, 24, 11,  0 }, {      3,  -29,  103, 24, 11,  0 }, {      3,  -29,  104, 24, 11,  0 },
    {      3,  -28,  105, 24, 12,  0 }, {      3,  -28,  106, 24, 12,  0 }, {      3,  -27,  107, 24, 12,  0 }, {      3,  -27,  108, 24, 12,  0 }, {      3,  -26,  109, 24, 12,  0 },
    {      3,  -26,  110, 24, 12,  0 }, {      3,  -26,  111, 24, 12,  0 }, {      2,  -25,  112, 24, 12,  0 }, {      2,  -25,  113, 24, 12,  0 }, {      2,  -24,  114, 24, 13,  0 },
    {      2,  -24,  115, 24, 13,  0 }, {      2,  -23,  116, 24, 13,  0 }, {      2,  -22,  117, 24, 13,  0 }, {      2,  -22,  118, 24, 13,  0 }, {      2,  -21,  119, 24, 13,  0 },
    {      2,  -20,  120, 24, 13,  0 }, {      1,  -19,  121, 24, 13,  0 }, {      1,  -18,  122, 24, 14,  0 }, {      1,  -17,  123, 24, 14,  0 }, {      1,  -16,  124, 24, 14,  0 },
    {      1,  -15,  124, 24, 14,  0 }, {      1,  -14,  125, 24, 14,  0 }, {      1,  -13,  126, 24, 15,  0 }, {      1,  -12,  127, 24, 15,  0 }, {      0,  -11,  128, 24, 15,  0 },
    {      0,  -10,  128, 24, 15,  0 }, {      0,   -9,  129, 24, 15,  0 }, {      0,   -8,  129, 24, 16,  0 }, {      0,   -7,  129, 24, 16,  0 }, {      0,   -6,  130, 24, 16,  0 },
    {      0,   -5,  130, 24, 16,  0 }, {      0,   -4,  130, 24, 16,  0 }, {      0,   -3,  130, 24, 16,  0 }, {      0,   -2,  130, 24, 16,  0 }, {      0,   -1,  130, 24, 16,  0 },
    {      0,    0,  130, 24, 16,  0 }, {      0,    1,  130, 24, 16,  0 }, {      0,    2,  130, 24, 16,  0 }, {      0,    3,  130, 24, 16,  0 }, {      0,    4,  130, 24, 23,  0 },
    {      0,    5,  130, 24, 23,  0 }, {      0,    6,  129, 24, 23,  0 }, {      0,    7,  129, 24, 23,  0 }, {      0,    8,  129, 24, 23,  0 }, {      0,    9,  128, 24, 22,  0 },
    {      0,   10,  128, 24, 22,  0 }, {     -1,   11,  127, 24, 22,  0 }, {     -1,   12,  126, 24, 22,  0 }, {     -1,   13,  125, 24, 22,  0 }, {     -1,   14,  124, 24, 21,  0 },
    {     -1,   15,  124, 24, 21,  0 }, {     -1,   16,  123, 24, 21,  0 }, {     -1,   17,  122, 24, 21,  0 }, {     -1,   18,  121, 24, 21,  0 }, {     -2,   19,  120, 24, 21,  0 },
    {     -2,   20,  119, 24, 21,  0 }, {     -2,   21,  118, 24, 21,  0 }, {     -2,   21,  117, 24, 20,  0 }, {     -2,   22,  116, 24, 20,  0 }, {     -2,   23,  115, 24, 20,  0 },
    {     -2,   23,  114, 24, 20,  0 }, {     -2,   24,  113, 24, 20,  0 }, {     -2,   24,  112, 24, 20,  0 }, {     -3,   25,  111, 24, 20,  0 }, {     -3,   25,  110, 24, 20,  0 },
    {     -3,   25,  109, 24, 20,  0 }, {     -3,   26,  108, 24, 19,  0 }, {     -3,   26,  107, 24, 19,  0 }, {     -3,   27,  106, 24, 19,  0 }, {     -3,   27,  105, 24, 19,  0 },
    {     -3,   28,  104, 24, 19,  0 }, {     -3,   28,  103, 24, 19,  0 }, {     -3,   28,  102, 24, 19,  0 }, {     -4,   29,  101, 24, 19,  0 }, {     -4,   29,  100, 24, 19,  0 },
    {     -4,   29,   99, 24, 19,  0 }, {     -4,   29,   98, 24, 19,  0 }, {     -4,   30,   97, 24, 19,  0 }, {     -4,   30,   96, 24, 19,  0 }, {     -4,   30,   95, 24, 19,  0 },
    {     -4,   30,   94, 24, 18,  0 }, {     -4,   30,   93, 24, 18,  0 }, {     -4,   31,   92, 24, 18,  0 }, {     -5,   31,   91, 24, 18,  0 }, {     -5,   31,   90, 24, 18,  0 },
    {     -5,   31,   89, 24, 18,  0 }, {     -5,   31,   88, 24, 18,  0 }, {     -5,   31,   87, 24, 18,  0 }, {     -5,   31,   86, 24, 18,  0 }, {     -5,   31,   85, 24, 18,  0 },
    {     -5,   31,   84, 24, 18,  0 }, {     -5,   31,   83, 24, 18,  0 }, {     -5,   31,   82, 24, 18,  0 }, {     -5,   31,   81, 24, 18,  0 }, {     -5,   31,   80, 24, 18,  0 },
    {     -6,   31,   79, 24, 18,  0 }, {     -6,   31,   78, 24, 18,  0 }, {     -6,   31,   77, 24, 18,  0 }, {     -6,   31,   76, 24, 18,  0 }, {     -6,   31,   75, 24, 18,  0 },
    {     -6,   31,   74, 24, 18,  0 }, {     -6,   31,   73, 24, 18,  0 }, {     -6,   31,   72, 24, 18,  0 }, {     -6,   31,   71, 24, 18,  0 }, {     -6,   30,   70, 24, 18,  0 },
    {     -6,   30,   69, 24, 18,  0 }, {     -7,   30,   68, 24, 18,  0 }, {     -7,   30,   67, 24, 17,  0 }, {     -7,   30,   66, 24, 17,  0 }, {     -7,   29,   65, 24, 17,  0 },
    {     -7,   29,   64, 24, 17,  0 }, {     -7,   29,   63, 24, 17,  0 }, {     -7,   29,   62, 24, 17,  0 }, {     -7,   28,   61, 24, 17,  0 }, {     -7,   28,   60, 24, 17,  0 },
    {     -7,   28,   59, 24, 17,  0 }, {     -8,   27,   58, 24, 17,  0 }, {     -8,   27,   57, 24, 17,  0 }, {     -8,   27,   56, 24, 17,  0 }, {     -8,   26,   55, 24, 17,  0 },
    {     -8,   26,   54, 24, 17,  0 }, {     -8,   26,   53, 24, 17,  0 }, {     -8,   25,   52, 24, 17,  0 }, {     -8,   25,   51, 24, 17,  0 }, {     -8,   25,   50, 24, 17,  0 },
    {     -8,   24,   49, 24, 17,  0 }, {     -9,   24,   48, 24, 17,  0 }, {     -9,   24,   47, 24, 17,  0 }, {     -9,   23,   46, 24,  8,  0 }, {     -9,   23,   45, 24,  8,  0 },
    {     -9,   22,   44, 24,  8,  0 }, {     -9,   21,   43, 24,  8,  0 }, {     -9,   21,   42, 24,  8,  0 }, {     -9,   20,   41, 24,  8,  0 }, {     -9,   19,   40, 24,  8,  0 },
    {     -9,   19,   39, 24,  8,  0 }, {    -10,   18,   38, 24,  8,  0 }, {    -10,   18,   37, 24,  8,  0 }, {    -10,   17,   36, 24,  8,  0 }, {    -10,   16,   35, 24,  8,  0 },
    {    -10,   15,   34, 24,  8,  0 }, {    -10,   15,   33, 24,  8,  0 }, {    -10,   14,   32, 24,  8,  0 }, {    -10,   13,   31, 24,  8,  0 }, {    -11,   12,   30, 24,  7,  0 },
    {    -11,   12,   29, 24,  7,  0 }, {    -11,   11,   28, 24,  7,  0 }, {    -11,   10,   27, 24,  7,  0 }, {    -11,    9,   26, 24,  7,  0 }, {    -11,    8,   25, 24,  7,  0 },
    {    -11,    7,   24, 24,  7,  0 }, {    -11,    6,   23, 24,  7,  0 }, {    -11,    5,   22, 24,  7,  0 }, {    -12,    4,   21, 24,  7,  0 }, {    -12,    3,   20, 24,  7,  0 },
    {    -12,    2,   19, 24,  7,  0 }, {    -12,    1,   18, 24,  7,  0 }, {    -12,    0,   18, 24,  7,  0 }, {    -12,   -1,   17, 24,  7,  0 }, {    -12,   -2,   16, 24,  7,  0 },
    {    -12,   -3,   15, 24,  7,  0 }, {    -13,   -4,   15, 24,  7,  0 }, {    -13,   -5,   14, 24,  7,  0 }, {    -13,   -6,   13, 24,  7,  0 }, {    -13,   -7,   12, 24,  7,  0 },
    {    -13,   -8,   11, 24,  7,  0 }, {    -13,   -9,   11, 24,  7,  0 }, {    -13,  -10,   10, 24,  6,  0 }, {    -13,  -11,   10, 24,  6,  0 }, {    -13,  -12,    9, 24,  6,  0 },
    {    -14,  -13,    9, 24,  6,  0 }, {    -14,  -14,    8, 24,  6,  0 }, {    -14,  -15,    8, 24,  6,  0 }, {    -14,  -16,    7, 24,  6,  0 }, {    -14,  -17,    7, 24,  6,  0 },
    {    -14,  -18,    6, 24,  6,  0 }, {    -14,  -19,    6, 24,  6,  0 }, {    -14,  -20,    5, 24,  6,  0 }, {    -14,  -21,    5, 24,  6,  0 }, {    -14,  -22,    4, 24,  6,  0 },
    {    -15,  -23,    4, 24,  6,  0 }, {    -15,  -24,    3, 24,  6,  0 }, {    -15,  -25,    3, 24,  6,  0 }, {    -15,  -26,    3, 24,  6,  0 }, {    -15,  -27,    2, 24,  6,  0 },
    {    -15,  -28,    2, 24,  6,  0 }, {    -15,  -29,    1, 24,  6,  0 }, {    -15,  -30,    1, 24,  6,  0 }, {    -15,  -31,    0, 24,  6,  0 }, {    -16,  -32,    0, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DED2E, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0, 31,  0,  0 },
    {     26,   16,    0, 31,  0,  0 }, {     25,   15,    0, 31,  0,  0 }, {     24,   15,    0, 31,  0,  0 }, {     23,   15,    0, 31,  0,  0 }, {     22,   15,    0, 31,  0,  0 },
    {     21,   15,    0, 31,  0,  0 }, {     20,   15,    0, 31,  0,  0 }, {     19,   14,    0, 31,  0,  0 }, {     18,   14,    0, 30,  0,  0 }, {     17,   14,    0, 30,  0,  0 },
    {     16,   13,    0, 30,  0,  0 }, {     15,   13,    0, 30,  0,  0 }, {     14,   13,    0, 30,  0,  0 }, {     13,   12,    0, 30,  0,  0 }, {     12,   12,    0, 30,  0,  0 },
    {     11,   11,    0, 30,  0,  0 }, {     10,   11,    0, 30,  0,  0 }, {      9,   10,    0, 30,  0,  0 }, {      8,   10,    0, 29,  0,  0 }, {      7,    9,    0, 29,  0,  0 },
    {      6,    9,    0, 29,  0,  0 }, {      5,    8,    0, 29,  0,  0 }, {      4,    7,    0, 29,  0,  0 }, {      3,    7,    0, 29,  0,  0 }, {      2,    6,    0, 29,  0,  0 },
    {      1,    5,    0, 29,  0,  0 }, {      0,    4,    0, 29,  0,  0 }, {     -1,    3,    0, 28,  0,  0 }, {     -3,    3,    0, 28,  0,  0 }, {     -4,    2,    0, 28,  0,  0 },
    {     -5,    1,    0, 28,  0,  0 }, {     -6,    0,    0, 28,  0,  0 }, {     -7,   -1,    0, 27,  0,  0 }, {     -7,   -2,    0, 27,  0,  0 }, {     -8,   -3,    0, 27,  0,  0 },
    {     -9,   -4,    0, 27,  0,  0 }, {     -9,   -5,    0, 27,  0,  0 }, {    -10,   -6,    0, 27,  0,  0 }, {    -10,   -7,    0, 27,  0,  0 }, {    -11,   -8,    0, 27,  0,  0 },
    {    -11,   -9,    0, 27,  0,  0 }, {    -12,  -10,    0, 26,  0,  0 }, {    -12,  -11,    0, 26,  0,  0 }, {    -13,  -12,    0, 26,  0,  0 }, {    -13,  -13,    0, 26,  0,  0 },
    {    -13,  -14,    0, 26,  0,  0 }, {    -14,  -15,    0, 26,  0,  0 }, {    -14,  -16,    0, 26,  0,  0 }, {    -14,  -17,    0, 26,  0,  0 }, {    -15,  -18,    0, 26,  0,  0 },
    {    -15,  -19,    0, 26,  0,  0 }, {    -15,  -20,    0, 25,  0,  0 }, {    -15,  -21,    0, 25,  0,  0 }, {    -15,  -22,    0, 25,  0,  0 }, {    -15,  -23,    0, 25,  0,  0 },
    {    -16,  -24,    0, 25,  0,  0 }, {    -16,  -25,    0, 25,  0,  0 }, {    -16,  -26,    0, 25,  0,  0 }, {    -16,  -27,    0, 25,  0,  0 }, {    -16,  -28,    0, 24,  0,  0 },
    {    -16,  -29,    0, 24,  0,  0 }, {    -16,  -30,    0, 24,  0,  0 }, {    -16,  -31,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DEF94, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  7,  0,  0 }, {     16,    6,    0,  7,  0,  0 }, {     15,    7,    0,  7,  0,  0 }, {     15,    8,    0,  7,  0,  0 }, {     15,    9,    0,  7,  0,  0 },
    {     15,   10,    0,  7,  0,  0 }, {     15,   11,    0,  7,  0,  0 }, {     15,   12,    0,  7,  0,  0 }, {     14,   13,    0,  7,  0,  0 }, {     14,   14,    0,  6,  0,  0 },
    {     14,   15,    0,  6,  0,  0 }, {     13,   16,    0,  6,  0,  0 }, {     13,   17,    0,  6,  0,  0 }, {     13,   18,    0,  6,  0,  0 }, {     12,   19,    0,  6,  0,  0 },
    {     12,   20,    0,  6,  0,  0 }, {     11,   21,    0,  6,  0,  0 }, {     11,   22,    0,  6,  0,  0 }, {     10,   23,    0,  6,  0,  0 }, {     10,   24,    0,  5,  0,  0 },
    {      9,   25,    0,  5,  0,  0 }, {      9,   26,    0,  5,  0,  0 }, {      8,   27,    0,  5,  0,  0 }, {      7,   28,    0,  5,  0,  0 }, {      7,   29,    0,  5,  0,  0 },
    {      6,   30,    0,  5,  0,  0 }, {      5,   31,    0,  5,  0,  0 }, {      4,   32,    0,  5,  0,  0 }, {      3,   33,    0,  4,  0,  0 }, {      3,   35,    0,  4,  0,  0 },
    {      2,   36,    0,  4,  0,  0 }, {      1,   37,    0,  4,  0,  0 }, {      0,   38,    0,  4,  0,  0 }, {     -1,   39,    0,  3,  0,  0 }, {     -2,   39,    0,  3,  0,  0 },
    {     -3,   40,    0,  3,  0,  0 }, {     -4,   41,    0,  3,  0,  0 }, {     -5,   41,    0,  3,  0,  0 }, {     -6,   42,    0,  3,  0,  0 }, {     -7,   42,    0,  3,  0,  0 },
    {     -8,   43,    0,  3,  0,  0 }, {     -9,   43,    0,  3,  0,  0 }, {    -10,   44,    0,  2,  0,  0 }, {    -11,   44,    0,  2,  0,  0 }, {    -12,   45,    0,  2,  0,  0 },
    {    -13,   45,    0,  2,  0,  0 }, {    -14,   45,    0,  2,  0,  0 }, {    -15,   46,    0,  2,  0,  0 }, {    -16,   46,    0,  2,  0,  0 }, {    -17,   46,    0,  2,  0,  0 },
    {    -18,   47,    0,  2,  0,  0 }, {    -19,   47,    0,  2,  0,  0 }, {    -20,   47,    0,  1,  0,  0 }, {    -21,   47,    0,  1,  0,  0 }, {    -22,   47,    0,  1,  0,  0 },
    {    -23,   47,    0,  1,  0,  0 }, {    -24,   48,    0,  1,  0,  0 }, {    -25,   48,    0,  1,  0,  0 }, {    -26,   48,    0,  1,  0,  0 }, {    -27,   48,    0,  1,  0,  0 },
    {    -28,   48,    0,  0,  0,  0 }, {    -29,   48,    0,  0,  0,  0 }, {    -30,   48,    0,  0,  0,  0 }, {    -31,   48,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF203, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 15,  0,  0 }, {      6,   16,    0, 15,  0,  0 }, {      7,   17,    0, 15,  0,  0 }, {      8,   17,    0, 15,  0,  0 }, {      9,   17,    0, 15,  0,  0 },
    {     10,   17,    0, 15,  0,  0 }, {     11,   17,    0, 15,  0,  0 }, {     12,   17,    0, 15,  0,  0 }, {     13,   18,    0, 15,  0,  0 }, {     14,   18,    0, 14,  0,  0 },
    {     15,   18,    0, 14,  0,  0 }, {     16,   19,    0, 14,  0,  0 }, {     17,   19,    0, 14,  0,  0 }, {     18,   19,    0, 14,  0,  0 }, {     19,   20,    0, 14,  0,  0 },
    {     20,   20,    0, 14,  0,  0 }, {     21,   21,    0, 14,  0,  0 }, {     22,   21,    0, 14,  0,  0 }, {     23,   22,    0, 14,  0,  0 }, {     24,   22,    0, 13,  0,  0 },
    {     25,   23,    0, 13,  0,  0 }, {     26,   23,    0, 13,  0,  0 }, {     27,   24,    0, 13,  0,  0 }, {     28,   25,    0, 13,  0,  0 }, {     29,   25,    0, 13,  0,  0 },
    {     30,   26,    0, 13,  0,  0 }, {     31,   27,    0, 13,  0,  0 }, {     32,   28,    0, 13,  0,  0 }, {     33,   29,    0, 12,  0,  0 }, {     35,   29,    0, 12,  0,  0 },
    {     36,   30,    0, 12,  0,  0 }, {     37,   31,    0, 12,  0,  0 }, {     38,   32,    0, 12,  0,  0 }, {     39,   33,    0, 11,  0,  0 }, {     39,   34,    0, 11,  0,  0 },
    {     40,   35,    0, 11,  0,  0 }, {     41,   36,    0, 11,  0,  0 }, {     41,   37,    0, 11,  0,  0 }, {     42,   38,    0, 11,  0,  0 }, {     42,   39,    0, 11,  0,  0 },
    {     43,   40,    0, 11,  0,  0 }, {     43,   41,    0, 11,  0,  0 }, {     44,   42,    0, 10,  0,  0 }, {     44,   43,    0, 10,  0,  0 }, {     45,   44,    0, 10,  0,  0 },
    {     45,   45,    0, 10,  0,  0 }, {     45,   46,    0, 10,  0,  0 }, {     46,   47,    0, 10,  0,  0 }, {     46,   48,    0, 10,  0,  0 }, {     46,   49,    0, 10,  0,  0 },
    {     47,   50,    0, 10,  0,  0 }, {     47,   51,    0, 10,  0,  0 }, {     47,   52,    0,  9,  0,  0 }, {     47,   53,    0,  9,  0,  0 }, {     47,   54,    0,  9,  0,  0 },
    {     47,   55,    0,  9,  0,  0 }, {     48,   56,    0,  9,  0,  0 }, {     48,   57,    0,  9,  0,  0 }, {     48,   58,    0,  9,  0,  0 }, {     48,   59,    0,  9,  0,  0 },
    {     48,   60,    0,  8,  0,  0 }, {     48,   61,    0,  8,  0,  0 }, {     48,   62,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF469, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 23,  0,  0 },
    {     16,   26,    0, 23,  0,  0 }, {     17,   25,    0, 23,  0,  0 }, {     17,   24,    0, 23,  0,  0 }, {     17,   23,    0, 23,  0,  0 }, {     17,   22,    0, 23,  0,  0 },
    {     17,   21,    0, 23,  0,  0 }, {     17,   20,    0, 23,  0,  0 }, {     18,   19,    0, 23,  0,  0 }, {     18,   18,    0, 22,  0,  0 }, {     18,   17,    0, 22,  0,  0 },
    {     19,   16,    0, 22,  0,  0 }, {     19,   15,    0, 22,  0,  0 }, {     19,   14,    0, 22,  0,  0 }, {     20,   13,    0, 22,  0,  0 }, {     20,   12,    0, 22,  0,  0 },
    {     21,   11,    0, 22,  0,  0 }, {     21,   10,    0, 22,  0,  0 }, {     22,    9,    0, 22,  0,  0 }, {     22,    8,    0, 21,  0,  0 }, {     23,    7,    0, 21,  0,  0 },
    {     23,    6,    0, 21,  0,  0 }, {     24,    5,    0, 21,  0,  0 }, {     25,    4,    0, 21,  0,  0 }, {     25,    3,    0, 21,  0,  0 }, {     26,    2,    0, 21,  0,  0 },
    {     27,    1,    0, 21,  0,  0 }, {     28,    0,    0, 21,  0,  0 }, {     29,   -1,    0, 20,  0,  0 }, {     29,   -3,    0, 20,  0,  0 }, {     30,   -4,    0, 20,  0,  0 },
    {     31,   -5,    0, 20,  0,  0 }, {     32,   -6,    0, 20,  0,  0 }, {     33,   -7,    0, 19,  0,  0 }, {     34,   -7,    0, 19,  0,  0 }, {     35,   -8,    0, 19,  0,  0 },
    {     36,   -9,    0, 19,  0,  0 }, {     37,   -9,    0, 19,  0,  0 }, {     38,  -10,    0, 19,  0,  0 }, {     39,  -10,    0, 19,  0,  0 }, {     40,  -11,    0, 19,  0,  0 },
    {     41,  -11,    0, 19,  0,  0 }, {     42,  -12,    0, 18,  0,  0 }, {     43,  -12,    0, 18,  0,  0 }, {     44,  -13,    0, 18,  0,  0 }, {     45,  -13,    0, 18,  0,  0 },
    {     46,  -13,    0, 18,  0,  0 }, {     47,  -14,    0, 18,  0,  0 }, {     48,  -14,    0, 18,  0,  0 }, {     49,  -14,    0, 18,  0,  0 }, {     50,  -15,    0, 18,  0,  0 },
    {     51,  -15,    0, 18,  0,  0 }, {     52,  -15,    0, 17,  0,  0 }, {     53,  -15,    0, 17,  0,  0 }, {     54,  -15,    0, 17,  0,  0 }, {     55,  -15,    0, 17,  0,  0 },
    {     56,  -16,    0, 17,  0,  0 }, {     57,  -16,    0, 17,  0,  0 }, {     58,  -16,    0, 17,  0,  0 }, {     59,  -16,    0, 17,  0,  0 }, {     60,  -16,    0, 16,  0,  0 },
    {     61,  -16,    0, 16,  0,  0 }, {     62,  -16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF6C6, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  1,  0,  0 },
    {     26,   16,    0,  1,  0,  0 }, {     25,   17,    0,  1,  0,  0 }, {     24,   17,    0,  1,  0,  0 }, {     23,   17,    0,  1,  0,  0 }, {     22,   17,    0,  1,  0,  0 },
    {     21,   17,    0,  1,  0,  0 }, {     20,   17,    0,  1,  0,  0 }, {     19,   18,    0,  1,  0,  0 }, {     18,   18,    0,  2,  0,  0 }, {     17,   18,    0,  2,  0,  0 },
    {     16,   19,    0,  2,  0,  0 }, {     15,   19,    0,  2,  0,  0 }, {     14,   19,    0,  2,  0,  0 }, {     13,   20,    0,  2,  0,  0 }, {     12,   20,    0,  2,  0,  0 },
    {     11,   21,    0,  2,  0,  0 }, {     10,   21,    0,  2,  0,  0 }, {      9,   22,    0,  2,  0,  0 }, {      8,   22,    0,  3,  0,  0 }, {      7,   23,    0,  3,  0,  0 },
    {      6,   23,    0,  3,  0,  0 }, {      5,   24,    0,  3,  0,  0 }, {      4,   25,    0,  3,  0,  0 }, {      3,   25,    0,  3,  0,  0 }, {      2,   26,    0,  3,  0,  0 },
    {      1,   27,    0,  3,  0,  0 }, {      0,   28,    0,  3,  0,  0 }, {     -1,   29,    0,  4,  0,  0 }, {     -3,   29,    0,  4,  0,  0 }, {     -4,   30,    0,  4,  0,  0 },
    {     -5,   31,    0,  4,  0,  0 }, {     -6,   32,    0,  4,  0,  0 }, {     -7,   33,    0,  5,  0,  0 }, {     -7,   34,    0,  5,  0,  0 }, {     -8,   35,    0,  5,  0,  0 },
    {     -9,   36,    0,  5,  0,  0 }, {     -9,   37,    0,  5,  0,  0 }, {    -10,   38,    0,  5,  0,  0 }, {    -10,   39,    0,  5,  0,  0 }, {    -11,   40,    0,  5,  0,  0 },
    {    -11,   41,    0,  5,  0,  0 }, {    -12,   42,    0,  6,  0,  0 }, {    -12,   43,    0,  6,  0,  0 }, {    -13,   44,    0,  6,  0,  0 }, {    -13,   45,    0,  6,  0,  0 },
    {    -13,   46,    0,  6,  0,  0 }, {    -14,   47,    0,  6,  0,  0 }, {    -14,   48,    0,  6,  0,  0 }, {    -14,   49,    0,  6,  0,  0 }, {    -15,   50,    0,  6,  0,  0 },
    {    -15,   51,    0,  6,  0,  0 }, {    -15,   52,    0,  7,  0,  0 }, {    -15,   53,    0,  7,  0,  0 }, {    -15,   54,    0,  7,  0,  0 }, {    -15,   55,    0,  7,  0,  0 },
    {    -16,   56,    0,  7,  0,  0 }, {    -16,   57,    0,  7,  0,  0 }, {    -16,   58,    0,  7,  0,  0 }, {    -16,   59,    0,  7,  0,  0 }, {    -16,   60,    0,  8,  0,  0 },
    {    -16,   61,    0,  8,  0,  0 }, {    -16,   62,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DF923, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  9,  0,  0 }, {     16,    6,    0,  9,  0,  0 }, {     17,    7,    0,  9,  0,  0 }, {     17,    8,    0,  9,  0,  0 }, {     17,    9,    0,  9,  0,  0 },
    {     17,   10,    0,  9,  0,  0 }, {     17,   11,    0,  9,  0,  0 }, {     17,   12,    0,  9,  0,  0 }, {     18,   13,    0,  9,  0,  0 }, {     18,   14,    0, 10,  0,  0 },
    {     18,   15,    0, 10,  0,  0 }, {     19,   16,    0, 10,  0,  0 }, {     19,   17,    0, 10,  0,  0 }, {     19,   18,    0, 10,  0,  0 }, {     20,   19,    0, 10,  0,  0 },
    {     20,   20,    0, 10,  0,  0 }, {     21,   21,    0, 10,  0,  0 }, {     21,   22,    0, 10,  0,  0 }, {     22,   23,    0, 10,  0,  0 }, {     22,   24,    0, 11,  0,  0 },
    {     23,   25,    0, 11,  0,  0 }, {     23,   26,    0, 11,  0,  0 }, {     24,   27,    0, 11,  0,  0 }, {     25,   28,    0, 11,  0,  0 }, {     25,   29,    0, 11,  0,  0 },
    {     26,   30,    0, 11,  0,  0 }, {     27,   31,    0, 11,  0,  0 }, {     28,   32,    0, 11,  0,  0 }, {     29,   33,    0, 12,  0,  0 }, {     29,   35,    0, 12,  0,  0 },
    {     30,   36,    0, 12,  0,  0 }, {     31,   37,    0, 12,  0,  0 }, {     32,   38,    0, 12,  0,  0 }, {     33,   39,    0, 13,  0,  0 }, {     34,   39,    0, 13,  0,  0 },
    {     35,   40,    0, 13,  0,  0 }, {     36,   41,    0, 13,  0,  0 }, {     37,   41,    0, 13,  0,  0 }, {     38,   42,    0, 13,  0,  0 }, {     39,   42,    0, 13,  0,  0 },
    {     40,   43,    0, 13,  0,  0 }, {     41,   43,    0, 13,  0,  0 }, {     42,   44,    0, 14,  0,  0 }, {     43,   44,    0, 14,  0,  0 }, {     44,   45,    0, 14,  0,  0 },
    {     45,   45,    0, 14,  0,  0 }, {     46,   45,    0, 14,  0,  0 }, {     47,   46,    0, 14,  0,  0 }, {     48,   46,    0, 14,  0,  0 }, {     49,   46,    0, 14,  0,  0 },
    {     50,   47,    0, 14,  0,  0 }, {     51,   47,    0, 14,  0,  0 }, {     52,   47,    0, 15,  0,  0 }, {     53,   47,    0, 15,  0,  0 }, {     54,   47,    0, 15,  0,  0 },
    {     55,   47,    0, 15,  0,  0 }, {     56,   48,    0, 15,  0,  0 }, {     57,   48,    0, 15,  0,  0 }, {     58,   48,    0, 15,  0,  0 }, {     59,   48,    0, 15,  0,  0 },
    {     60,   48,    0, 16,  0,  0 }, {     61,   48,    0, 16,  0,  0 }, {     62,   48,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DFB89, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 17,  0,  0 }, {      6,   16,    0, 17,  0,  0 }, {      7,   15,    0, 17,  0,  0 }, {      8,   15,    0, 17,  0,  0 }, {      9,   15,    0, 17,  0,  0 },
    {     10,   15,    0, 17,  0,  0 }, {     11,   15,    0, 17,  0,  0 }, {     12,   15,    0, 17,  0,  0 }, {     13,   14,    0, 17,  0,  0 }, {     14,   14,    0, 18,  0,  0 },
    {     15,   14,    0, 18,  0,  0 }, {     16,   13,    0, 18,  0,  0 }, {     17,   13,    0, 18,  0,  0 }, {     18,   13,    0, 18,  0,  0 }, {     19,   12,    0, 18,  0,  0 },
    {     20,   12,    0, 18,  0,  0 }, {     21,   11,    0, 18,  0,  0 }, {     22,   11,    0, 18,  0,  0 }, {     23,   10,    0, 18,  0,  0 }, {     24,   10,    0, 19,  0,  0 },
    {     25,    9,    0, 19,  0,  0 }, {     26,    9,    0, 19,  0,  0 }, {     27,    8,    0, 19,  0,  0 }, {     28,    7,    0, 19,  0,  0 }, {     29,    7,    0, 19,  0,  0 },
    {     30,    6,    0, 19,  0,  0 }, {     31,    5,    0, 19,  0,  0 }, {     32,    4,    0, 19,  0,  0 }, {     33,    3,    0, 20,  0,  0 }, {     35,    3,    0, 20,  0,  0 },
    {     36,    2,    0, 20,  0,  0 }, {     37,    1,    0, 20,  0,  0 }, {     38,    0,    0, 20,  0,  0 }, {     39,   -1,    0, 21,  0,  0 }, {     39,   -2,    0, 21,  0,  0 },
    {     40,   -3,    0, 21,  0,  0 }, {     41,   -4,    0, 21,  0,  0 }, {     41,   -5,    0, 21,  0,  0 }, {     42,   -6,    0, 21,  0,  0 }, {     42,   -7,    0, 21,  0,  0 },
    {     43,   -8,    0, 21,  0,  0 }, {     43,   -9,    0, 21,  0,  0 }, {     44,  -10,    0, 22,  0,  0 }, {     44,  -11,    0, 22,  0,  0 }, {     45,  -12,    0, 22,  0,  0 },
    {     45,  -13,    0, 22,  0,  0 }, {     45,  -14,    0, 22,  0,  0 }, {     46,  -15,    0, 22,  0,  0 }, {     46,  -16,    0, 22,  0,  0 }, {     46,  -17,    0, 22,  0,  0 },
    {     47,  -18,    0, 22,  0,  0 }, {     47,  -19,    0, 22,  0,  0 }, {     47,  -20,    0, 23,  0,  0 }, {     47,  -21,    0, 23,  0,  0 }, {     47,  -22,    0, 23,  0,  0 },
    {     47,  -23,    0, 23,  0,  0 }, {     48,  -24,    0, 23,  0,  0 }, {     48,  -25,    0, 23,  0,  0 }, {     48,  -26,    0, 23,  0,  0 }, {     48,  -27,    0, 23,  0,  0 },
    {     48,  -28,    0, 24,  0,  0 }, {     48,  -29,    0, 24,  0,  0 }, {     48,  -30,    0, 24,  0,  0 }, {     48,  -31,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DFDF8, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 25,  0,  0 },
    {     16,   26,    0, 25,  0,  0 }, {     15,   25,    0, 25,  0,  0 }, {     15,   24,    0, 25,  0,  0 }, {     15,   23,    0, 25,  0,  0 }, {     15,   22,    0, 25,  0,  0 },
    {     15,   21,    0, 25,  0,  0 }, {     15,   20,    0, 25,  0,  0 }, {     14,   19,    0, 25,  0,  0 }, {     14,   18,    0, 26,  0,  0 }, {     14,   17,    0, 26,  0,  0 },
    {     13,   16,    0, 26,  0,  0 }, {     13,   15,    0, 26,  0,  0 }, {     13,   14,    0, 26,  0,  0 }, {     12,   13,    0, 26,  0,  0 }, {     12,   12,    0, 26,  0,  0 },
    {     11,   11,    0, 26,  0,  0 }, {     11,   10,    0, 26,  0,  0 }, {     10,    9,    0, 26,  0,  0 }, {     10,    8,    0, 27,  0,  0 }, {      9,    7,    0, 27,  0,  0 },
    {      9,    6,    0, 27,  0,  0 }, {      8,    5,    0, 27,  0,  0 }, {      7,    4,    0, 27,  0,  0 }, {      7,    3,    0, 27,  0,  0 }, {      6,    2,    0, 27,  0,  0 },
    {      5,    1,    0, 27,  0,  0 }, {      4,    0,    0, 27,  0,  0 }, {      3,   -1,    0, 28,  0,  0 }, {      3,   -3,    0, 28,  0,  0 }, {      2,   -4,    0, 28,  0,  0 },
    {      1,   -5,    0, 28,  0,  0 }, {      0,   -6,    0, 28,  0,  0 }, {     -1,   -7,    0, 29,  0,  0 }, {     -2,   -7,    0, 29,  0,  0 }, {     -3,   -8,    0, 29,  0,  0 },
    {     -4,   -9,    0, 29,  0,  0 }, {     -5,   -9,    0, 29,  0,  0 }, {     -6,  -10,    0, 29,  0,  0 }, {     -7,  -10,    0, 29,  0,  0 }, {     -8,  -11,    0, 29,  0,  0 },
    {     -9,  -11,    0, 29,  0,  0 }, {    -10,  -12,    0, 30,  0,  0 }, {    -11,  -12,    0, 30,  0,  0 }, {    -12,  -13,    0, 30,  0,  0 }, {    -13,  -13,    0, 30,  0,  0 },
    {    -14,  -13,    0, 30,  0,  0 }, {    -15,  -14,    0, 30,  0,  0 }, {    -16,  -14,    0, 30,  0,  0 }, {    -17,  -14,    0, 30,  0,  0 }, {    -18,  -15,    0, 30,  0,  0 },
    {    -19,  -15,    0, 30,  0,  0 }, {    -20,  -15,    0, 31,  0,  0 }, {    -21,  -15,    0, 31,  0,  0 }, {    -22,  -15,    0, 31,  0,  0 }, {    -23,  -15,    0, 31,  0,  0 },
    {    -24,  -16,    0, 31,  0,  0 }, {    -25,  -16,    0, 31,  0,  0 }, {    -26,  -16,    0, 31,  0,  0 }, {    -27,  -16,    0, 31,  0,  0 }, {    -28,  -16,    0,  0,  0,  0 },
    {    -29,  -16,    0,  0,  0,  0 }, {    -30,  -16,    0,  0,  0,  0 }, {    -31,  -16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E005E, {
    {     31,   16,    0,  0,  0,  2 }, {     30,   16,    0,  0,  0,  2 }, {     29,   16,    0,  0,  0,  2 }, {     28,   16,    0,  0,  0,  2 }, {     27,   16,    0, 31,  0,  2 },
    {     26,   16,    0, 31,  0,  2 }, {     25,   15,    0, 31,  0,  2 }, {     24,   15,    0, 31,  0,  2 }, {     23,   15,    0, 31,  0,  2 }, {     22,   15,    0, 31,  0,  2 },
    {     21,   15,    0, 31,  0,  2 }, {     20,   15,    0, 31,  0,  2 }, {     19,   14,    0, 31,  0,  2 }, {     18,   14,    0, 30,  0,  2 }, {     17,   14,    0, 30,  0,  2 },
    {     16,   13,    0, 30,  0,  2 }, {     15,   13,    0, 30,  0,  2 }, {     14,   13,    0, 30,  0,  2 }, {     13,   12,    0, 30,  0,  2 }, {     12,   12,    0, 30,  0,  2 },
    {     11,   11,    0, 30,  0,  2 }, {     10,   11,    0, 30,  0,  2 }, {      9,   10,    0, 30,  0,  2 }, {      8,   10,    0, 29,  0,  2 }, {      7,    9,    0, 29,  0,  2 },
    {      6,    9,    0, 29,  0,  2 }, {      5,    8,    0, 29,  0,  2 }, {      4,    7,    0, 29,  0,  2 }, {      3,    7,    0, 29,  0,  2 }, {      2,    6,    0, 29,  0,  2 },
    {      1,    5,    0, 29,  0,  2 }, {      0,    4,    0, 29,  0,  2 }, {     -1,    3,    0, 28,  0,  2 }, {     -3,    3,    0, 28,  0,  2 }, {     -4,    2,    0, 28,  0,  2 },
    {     -5,    1,    0, 28,  0,  2 }, {     -6,    0,    0, 28,  0,  2 }, {     -7,   -1,    0, 27,  0,  2 }, {     -7,   -2,    0, 27,  0,  2 }, {     -8,   -3,    0, 27,  0,  2 },
    {     -9,   -4,    0, 27,  0,  2 }, {     -9,   -5,    0, 27,  0,  2 }, {    -10,   -6,    0, 27,  0,  2 }, {    -10,   -7,    0, 27,  0,  2 }, {    -11,   -8,    0, 27,  0,  2 },
    {    -11,   -9,    0, 27,  0,  2 }, {    -12,  -10,    0, 26,  0,  2 }, {    -12,  -11,    0, 26,  0,  2 }, {    -13,  -12,    0, 26,  0,  2 }, {    -13,  -13,    0, 26,  0,  2 },
    {    -13,  -14,    0, 26,  0,  2 }, {    -14,  -15,    0, 26,  0,  2 }, {    -14,  -16,    0, 26,  0,  2 }, {    -14,  -17,    0, 26,  0,  2 }, {    -15,  -18,    0, 26,  0,  2 },
    {    -15,  -19,    0, 26,  0,  2 }, {    -15,  -20,    0, 25,  0,  2 }, {    -15,  -21,    0, 25,  0,  2 }, {    -15,  -22,    0, 25,  0,  2 }, {    -15,  -23,    0, 25,  0,  2 },
    {    -16,  -24,    0, 25,  0,  2 }, {    -16,  -25,    0, 25,  0,  2 }, {    -16,  -26,    0, 25,  0,  2 }, {    -16,  -27,    0, 25,  0,  2 }, {    -16,  -28,    0, 24,  0,  2 },
    {    -16,  -29,    0, 24,  0,  2 }, {    -16,  -30,    0, 24,  0,  2 }, {    -16,  -31,    0, 24,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E02C4, {
    {     16,    0,    0,  8,  0,  2 }, {     16,    1,    0,  8,  0,  2 }, {     16,    2,    0,  8,  0,  2 }, {     16,    3,    0,  8,  0,  2 }, {     16,    4,    0,  8,  0,  2 },
    {     16,    5,    0,  7,  0,  2 }, {     16,    6,    0,  7,  0,  2 }, {     15,    7,    0,  7,  0,  2 }, {     15,    8,    0,  7,  0,  2 }, {     15,    9,    0,  7,  0,  2 },
    {     15,   10,    0,  7,  0,  2 }, {     15,   11,    0,  7,  0,  2 }, {     15,   12,    0,  7,  0,  2 }, {     14,   13,    0,  7,  0,  2 }, {     14,   14,    0,  6,  0,  2 },
    {     14,   15,    0,  6,  0,  2 }, {     13,   16,    0,  6,  0,  2 }, {     13,   17,    0,  6,  0,  2 }, {     13,   18,    0,  6,  0,  2 }, {     12,   19,    0,  6,  0,  2 },
    {     12,   20,    0,  6,  0,  2 }, {     11,   21,    0,  6,  0,  2 }, {     11,   22,    0,  6,  0,  2 }, {     10,   23,    0,  6,  0,  2 }, {     10,   24,    0,  5,  0,  2 },
    {      9,   25,    0,  5,  0,  2 }, {      9,   26,    0,  5,  0,  2 }, {      8,   27,    0,  5,  0,  2 }, {      7,   28,    0,  5,  0,  2 }, {      7,   29,    0,  5,  0,  2 },
    {      6,   30,    0,  5,  0,  2 }, {      5,   31,    0,  5,  0,  2 }, {      4,   32,    0,  5,  0,  2 }, {      3,   33,    0,  4,  0,  2 }, {      3,   35,    0,  4,  0,  2 },
    {      2,   36,    0,  4,  0,  2 }, {      1,   37,    0,  4,  0,  2 }, {      0,   38,    0,  4,  0,  2 }, {     -1,   39,    0,  3,  0,  2 }, {     -2,   39,    0,  3,  0,  2 },
    {     -3,   40,    0,  3,  0,  2 }, {     -4,   41,    0,  3,  0,  2 }, {     -5,   41,    0,  3,  0,  2 }, {     -6,   42,    0,  3,  0,  2 }, {     -7,   42,    0,  3,  0,  2 },
    {     -8,   43,    0,  3,  0,  2 }, {     -9,   43,    0,  3,  0,  2 }, {    -10,   44,    0,  2,  0,  2 }, {    -11,   44,    0,  2,  0,  2 }, {    -12,   45,    0,  2,  0,  2 },
    {    -13,   45,    0,  2,  0,  2 }, {    -14,   45,    0,  2,  0,  2 }, {    -15,   46,    0,  2,  0,  2 }, {    -16,   46,    0,  2,  0,  2 }, {    -17,   46,    0,  2,  0,  2 },
    {    -18,   47,    0,  2,  0,  2 }, {    -19,   47,    0,  2,  0,  2 }, {    -20,   47,    0,  1,  0,  2 }, {    -21,   47,    0,  1,  0,  2 }, {    -22,   47,    0,  1,  0,  2 },
    {    -23,   47,    0,  1,  0,  2 }, {    -24,   48,    0,  1,  0,  2 }, {    -25,   48,    0,  1,  0,  2 }, {    -26,   48,    0,  1,  0,  2 }, {    -27,   48,    0,  1,  0,  2 },
    {    -28,   48,    0,  0,  0,  2 }, {    -29,   48,    0,  0,  0,  2 }, {    -30,   48,    0,  0,  0,  2 }, {    -31,   48,    0,  0,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0533, {
    {      0,   16,    0, 16,  0,  2 }, {      1,   16,    0, 16,  0,  2 }, {      2,   16,    0, 16,  0,  2 }, {      3,   16,    0, 16,  0,  2 }, {      4,   16,    0, 16,  0,  2 },
    {      5,   16,    0, 15,  0,  2 }, {      6,   16,    0, 15,  0,  2 }, {      7,   17,    0, 15,  0,  2 }, {      8,   17,    0, 15,  0,  2 }, {      9,   17,    0, 15,  0,  2 },
    {     10,   17,    0, 15,  0,  2 }, {     11,   17,    0, 15,  0,  2 }, {     12,   17,    0, 15,  0,  2 }, {     13,   18,    0, 15,  0,  2 }, {     14,   18,    0, 14,  0,  2 },
    {     15,   18,    0, 14,  0,  2 }, {     16,   19,    0, 14,  0,  2 }, {     17,   19,    0, 14,  0,  2 }, {     18,   19,    0, 14,  0,  2 }, {     19,   20,    0, 14,  0,  2 },
    {     20,   20,    0, 14,  0,  2 }, {     21,   21,    0, 14,  0,  2 }, {     22,   21,    0, 14,  0,  2 }, {     23,   22,    0, 14,  0,  2 }, {     24,   22,    0, 13,  0,  2 },
    {     25,   23,    0, 13,  0,  2 }, {     26,   23,    0, 13,  0,  2 }, {     27,   24,    0, 13,  0,  2 }, {     28,   25,    0, 13,  0,  2 }, {     29,   25,    0, 13,  0,  2 },
    {     30,   26,    0, 13,  0,  2 }, {     31,   27,    0, 13,  0,  2 }, {     32,   28,    0, 13,  0,  2 }, {     33,   29,    0, 12,  0,  2 }, {     35,   29,    0, 12,  0,  2 },
    {     36,   30,    0, 12,  0,  2 }, {     37,   31,    0, 12,  0,  2 }, {     38,   32,    0, 12,  0,  2 }, {     39,   33,    0, 11,  0,  2 }, {     39,   34,    0, 11,  0,  2 },
    {     40,   35,    0, 11,  0,  2 }, {     41,   36,    0, 11,  0,  2 }, {     41,   37,    0, 11,  0,  2 }, {     42,   38,    0, 11,  0,  2 }, {     42,   39,    0, 11,  0,  2 },
    {     43,   40,    0, 11,  0,  2 }, {     43,   41,    0, 11,  0,  2 }, {     44,   42,    0, 10,  0,  2 }, {     44,   43,    0, 10,  0,  2 }, {     45,   44,    0, 10,  0,  2 },
    {     45,   45,    0, 10,  0,  2 }, {     45,   46,    0, 10,  0,  2 }, {     46,   47,    0, 10,  0,  2 }, {     46,   48,    0, 10,  0,  2 }, {     46,   49,    0, 10,  0,  2 },
    {     47,   50,    0, 10,  0,  2 }, {     47,   51,    0, 10,  0,  2 }, {     47,   52,    0,  9,  0,  2 }, {     47,   53,    0,  9,  0,  2 }, {     47,   54,    0,  9,  0,  2 },
    {     47,   55,    0,  9,  0,  2 }, {     48,   56,    0,  9,  0,  2 }, {     48,   57,    0,  9,  0,  2 }, {     48,   58,    0,  9,  0,  2 }, {     48,   59,    0,  9,  0,  2 },
    {     48,   60,    0,  8,  0,  2 }, {     48,   61,    0,  8,  0,  2 }, {     48,   62,    0,  8,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0799, {
    {     16,   31,    0, 24,  0,  2 }, {     16,   30,    0, 24,  0,  2 }, {     16,   29,    0, 24,  0,  2 }, {     16,   28,    0, 24,  0,  2 }, {     16,   27,    0, 23,  0,  2 },
    {     16,   26,    0, 23,  0,  2 }, {     17,   25,    0, 23,  0,  2 }, {     17,   24,    0, 23,  0,  2 }, {     17,   23,    0, 23,  0,  2 }, {     17,   22,    0, 23,  0,  2 },
    {     17,   21,    0, 23,  0,  2 }, {     17,   20,    0, 23,  0,  2 }, {     18,   19,    0, 23,  0,  2 }, {     18,   18,    0, 22,  0,  2 }, {     18,   17,    0, 22,  0,  2 },
    {     19,   16,    0, 22,  0,  2 }, {     19,   15,    0, 22,  0,  2 }, {     19,   14,    0, 22,  0,  2 }, {     20,   13,    0, 22,  0,  2 }, {     20,   12,    0, 22,  0,  2 },
    {     21,   11,    0, 22,  0,  2 }, {     21,   10,    0, 22,  0,  2 }, {     22,    9,    0, 22,  0,  2 }, {     22,    8,    0, 21,  0,  2 }, {     23,    7,    0, 21,  0,  2 },
    {     23,    6,    0, 21,  0,  2 }, {     24,    5,    0, 21,  0,  2 }, {     25,    4,    0, 21,  0,  2 }, {     25,    3,    0, 21,  0,  2 }, {     26,    2,    0, 21,  0,  2 },
    {     27,    1,    0, 21,  0,  2 }, {     28,    0,    0, 21,  0,  2 }, {     29,   -1,    0, 20,  0,  2 }, {     29,   -3,    0, 20,  0,  2 }, {     30,   -4,    0, 20,  0,  2 },
    {     31,   -5,    0, 20,  0,  2 }, {     32,   -6,    0, 20,  0,  2 }, {     33,   -7,    0, 19,  0,  2 }, {     34,   -7,    0, 19,  0,  2 }, {     35,   -8,    0, 19,  0,  2 },
    {     36,   -9,    0, 19,  0,  2 }, {     37,   -9,    0, 19,  0,  2 }, {     38,  -10,    0, 19,  0,  2 }, {     39,  -10,    0, 19,  0,  2 }, {     40,  -11,    0, 19,  0,  2 },
    {     41,  -11,    0, 19,  0,  2 }, {     42,  -12,    0, 18,  0,  2 }, {     43,  -12,    0, 18,  0,  2 }, {     44,  -13,    0, 18,  0,  2 }, {     45,  -13,    0, 18,  0,  2 },
    {     46,  -13,    0, 18,  0,  2 }, {     47,  -14,    0, 18,  0,  2 }, {     48,  -14,    0, 18,  0,  2 }, {     49,  -14,    0, 18,  0,  2 }, {     50,  -15,    0, 18,  0,  2 },
    {     51,  -15,    0, 18,  0,  2 }, {     52,  -15,    0, 17,  0,  2 }, {     53,  -15,    0, 17,  0,  2 }, {     54,  -15,    0, 17,  0,  2 }, {     55,  -15,    0, 17,  0,  2 },
    {     56,  -16,    0, 17,  0,  2 }, {     57,  -16,    0, 17,  0,  2 }, {     58,  -16,    0, 17,  0,  2 }, {     59,  -16,    0, 17,  0,  2 }, {     60,  -16,    0, 16,  0,  2 },
    {     61,  -16,    0, 16,  0,  2 }, {     62,  -16,    0, 16,  0,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E09F6, {
    {     31,   16,    0,  0,  0,  4 }, {     30,   16,    0,  0,  0,  4 }, {     29,   16,    0,  0,  0,  4 }, {     28,   16,    0,  0,  0,  4 }, {     27,   16,    0,  1,  0,  4 },
    {     26,   16,    0,  1,  0,  4 }, {     25,   17,    0,  1,  0,  4 }, {     24,   17,    0,  1,  0,  4 }, {     23,   17,    0,  1,  0,  4 }, {     22,   17,    0,  1,  0,  4 },
    {     21,   17,    0,  1,  0,  4 }, {     20,   17,    0,  1,  0,  4 }, {     19,   18,    0,  1,  0,  4 }, {     18,   18,    0,  2,  0,  4 }, {     17,   18,    0,  2,  0,  4 },
    {     16,   19,    0,  2,  0,  4 }, {     15,   19,    0,  2,  0,  4 }, {     14,   19,    0,  2,  0,  4 }, {     13,   20,    0,  2,  0,  4 }, {     12,   20,    0,  2,  0,  4 },
    {     11,   21,    0,  2,  0,  4 }, {     10,   21,    0,  2,  0,  4 }, {      9,   22,    0,  2,  0,  4 }, {      8,   22,    0,  3,  0,  4 }, {      7,   23,    0,  3,  0,  4 },
    {      6,   23,    0,  3,  0,  4 }, {      5,   24,    0,  3,  0,  4 }, {      4,   25,    0,  3,  0,  4 }, {      3,   25,    0,  3,  0,  4 }, {      2,   26,    0,  3,  0,  4 },
    {      1,   27,    0,  3,  0,  4 }, {      0,   28,    0,  3,  0,  4 }, {     -1,   29,    0,  4,  0,  4 }, {     -3,   29,    0,  4,  0,  4 }, {     -4,   30,    0,  4,  0,  4 },
    {     -5,   31,    0,  4,  0,  4 }, {     -6,   32,    0,  4,  0,  4 }, {     -7,   33,    0,  5,  0,  4 }, {     -7,   34,    0,  5,  0,  4 }, {     -8,   35,    0,  5,  0,  4 },
    {     -9,   36,    0,  5,  0,  4 }, {     -9,   37,    0,  5,  0,  4 }, {    -10,   38,    0,  5,  0,  4 }, {    -10,   39,    0,  5,  0,  4 }, {    -11,   40,    0,  5,  0,  4 },
    {    -11,   41,    0,  5,  0,  4 }, {    -12,   42,    0,  6,  0,  4 }, {    -12,   43,    0,  6,  0,  4 }, {    -13,   44,    0,  6,  0,  4 }, {    -13,   45,    0,  6,  0,  4 },
    {    -13,   46,    0,  6,  0,  4 }, {    -14,   47,    0,  6,  0,  4 }, {    -14,   48,    0,  6,  0,  4 }, {    -14,   49,    0,  6,  0,  4 }, {    -15,   50,    0,  6,  0,  4 },
    {    -15,   51,    0,  6,  0,  4 }, {    -15,   52,    0,  7,  0,  4 }, {    -15,   53,    0,  7,  0,  4 }, {    -15,   54,    0,  7,  0,  4 }, {    -15,   55,    0,  7,  0,  4 },
    {    -16,   56,    0,  7,  0,  4 }, {    -16,   57,    0,  7,  0,  4 }, {    -16,   58,    0,  7,  0,  4 }, {    -16,   59,    0,  7,  0,  4 }, {    -16,   60,    0,  8,  0,  4 },
    {    -16,   61,    0,  8,  0,  4 }, {    -16,   62,    0,  8,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0C53, {
    {     16,    0,    0,  8,  0,  4 }, {     16,    1,    0,  8,  0,  4 }, {     16,    2,    0,  8,  0,  4 }, {     16,    3,    0,  8,  0,  4 }, {     16,    4,    0,  8,  0,  4 },
    {     16,    5,    0,  9,  0,  4 }, {     16,    6,    0,  9,  0,  4 }, {     17,    7,    0,  9,  0,  4 }, {     17,    8,    0,  9,  0,  4 }, {     17,    9,    0,  9,  0,  4 },
    {     17,   10,    0,  9,  0,  4 }, {     17,   11,    0,  9,  0,  4 }, {     17,   12,    0,  9,  0,  4 }, {     18,   13,    0,  9,  0,  4 }, {     18,   14,    0, 10,  0,  4 },
    {     18,   15,    0, 10,  0,  4 }, {     19,   16,    0, 10,  0,  4 }, {     19,   17,    0, 10,  0,  4 }, {     19,   18,    0, 10,  0,  4 }, {     20,   19,    0, 10,  0,  4 },
    {     20,   20,    0, 10,  0,  4 }, {     21,   21,    0, 10,  0,  4 }, {     21,   22,    0, 10,  0,  4 }, {     22,   23,    0, 10,  0,  4 }, {     22,   24,    0, 11,  0,  4 },
    {     23,   25,    0, 11,  0,  4 }, {     23,   26,    0, 11,  0,  4 }, {     24,   27,    0, 11,  0,  4 }, {     25,   28,    0, 11,  0,  4 }, {     25,   29,    0, 11,  0,  4 },
    {     26,   30,    0, 11,  0,  4 }, {     27,   31,    0, 11,  0,  4 }, {     28,   32,    0, 11,  0,  4 }, {     29,   33,    0, 12,  0,  4 }, {     29,   35,    0, 12,  0,  4 },
    {     30,   36,    0, 12,  0,  4 }, {     31,   37,    0, 12,  0,  4 }, {     32,   38,    0, 12,  0,  4 }, {     33,   39,    0, 13,  0,  4 }, {     34,   39,    0, 13,  0,  4 },
    {     35,   40,    0, 13,  0,  4 }, {     36,   41,    0, 13,  0,  4 }, {     37,   41,    0, 13,  0,  4 }, {     38,   42,    0, 13,  0,  4 }, {     39,   42,    0, 13,  0,  4 },
    {     40,   43,    0, 13,  0,  4 }, {     41,   43,    0, 13,  0,  4 }, {     42,   44,    0, 14,  0,  4 }, {     43,   44,    0, 14,  0,  4 }, {     44,   45,    0, 14,  0,  4 },
    {     45,   45,    0, 14,  0,  4 }, {     46,   45,    0, 14,  0,  4 }, {     47,   46,    0, 14,  0,  4 }, {     48,   46,    0, 14,  0,  4 }, {     49,   46,    0, 14,  0,  4 },
    {     50,   47,    0, 14,  0,  4 }, {     51,   47,    0, 14,  0,  4 }, {     52,   47,    0, 15,  0,  4 }, {     53,   47,    0, 15,  0,  4 }, {     54,   47,    0, 15,  0,  4 },
    {     55,   47,    0, 15,  0,  4 }, {     56,   48,    0, 15,  0,  4 }, {     57,   48,    0, 15,  0,  4 }, {     58,   48,    0, 15,  0,  4 }, {     59,   48,    0, 15,  0,  4 },
    {     60,   48,    0, 16,  0,  4 }, {     61,   48,    0, 16,  0,  4 }, {     62,   48,    0, 16,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E0EB9, {
    {      0,   16,    0, 16,  0,  4 }, {      1,   16,    0, 16,  0,  4 }, {      2,   16,    0, 16,  0,  4 }, {      3,   16,    0, 16,  0,  4 }, {      4,   16,    0, 16,  0,  4 },
    {      5,   16,    0, 17,  0,  4 }, {      6,   16,    0, 17,  0,  4 }, {      7,   15,    0, 17,  0,  4 }, {      8,   15,    0, 17,  0,  4 }, {      9,   15,    0, 17,  0,  4 },
    {     10,   15,    0, 17,  0,  4 }, {     11,   15,    0, 17,  0,  4 }, {     12,   15,    0, 17,  0,  4 }, {     13,   14,    0, 17,  0,  4 }, {     14,   14,    0, 18,  0,  4 },
    {     15,   14,    0, 18,  0,  4 }, {     16,   13,    0, 18,  0,  4 }, {     17,   13,    0, 18,  0,  4 }, {     18,   13,    0, 18,  0,  4 }, {     19,   12,    0, 18,  0,  4 },
    {     20,   12,    0, 18,  0,  4 }, {     21,   11,    0, 18,  0,  4 }, {     22,   11,    0, 18,  0,  4 }, {     23,   10,    0, 18,  0,  4 }, {     24,   10,    0, 19,  0,  4 },
    {     25,    9,    0, 19,  0,  4 }, {     26,    9,    0, 19,  0,  4 }, {     27,    8,    0, 19,  0,  4 }, {     28,    7,    0, 19,  0,  4 }, {     29,    7,    0, 19,  0,  4 },
    {     30,    6,    0, 19,  0,  4 }, {     31,    5,    0, 19,  0,  4 }, {     32,    4,    0, 19,  0,  4 }, {     33,    3,    0, 20,  0,  4 }, {     35,    3,    0, 20,  0,  4 },
    {     36,    2,    0, 20,  0,  4 }, {     37,    1,    0, 20,  0,  4 }, {     38,    0,    0, 20,  0,  4 }, {     39,   -1,    0, 21,  0,  4 }, {     39,   -2,    0, 21,  0,  4 },
    {     40,   -3,    0, 21,  0,  4 }, {     41,   -4,    0, 21,  0,  4 }, {     41,   -5,    0, 21,  0,  4 }, {     42,   -6,    0, 21,  0,  4 }, {     42,   -7,    0, 21,  0,  4 },
    {     43,   -8,    0, 21,  0,  4 }, {     43,   -9,    0, 21,  0,  4 }, {     44,  -10,    0, 22,  0,  4 }, {     44,  -11,    0, 22,  0,  4 }, {     45,  -12,    0, 22,  0,  4 },
    {     45,  -13,    0, 22,  0,  4 }, {     45,  -14,    0, 22,  0,  4 }, {     46,  -15,    0, 22,  0,  4 }, {     46,  -16,    0, 22,  0,  4 }, {     46,  -17,    0, 22,  0,  4 },
    {     47,  -18,    0, 22,  0,  4 }, {     47,  -19,    0, 22,  0,  4 }, {     47,  -20,    0, 23,  0,  4 }, {     47,  -21,    0, 23,  0,  4 }, {     47,  -22,    0, 23,  0,  4 },
    {     47,  -23,    0, 23,  0,  4 }, {     48,  -24,    0, 23,  0,  4 }, {     48,  -25,    0, 23,  0,  4 }, {     48,  -26,    0, 23,  0,  4 }, {     48,  -27,    0, 23,  0,  4 },
    {     48,  -28,    0, 24,  0,  4 }, {     48,  -29,    0, 24,  0,  4 }, {     48,  -30,    0, 24,  0,  4 }, {     48,  -31,    0, 24,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1128, {
    {     16,   31,    0, 24,  0,  4 }, {     16,   30,    0, 24,  0,  4 }, {     16,   29,    0, 24,  0,  4 }, {     16,   28,    0, 24,  0,  4 }, {     16,   27,    0, 25,  0,  4 },
    {     16,   26,    0, 25,  0,  4 }, {     15,   25,    0, 25,  0,  4 }, {     15,   24,    0, 25,  0,  4 }, {     15,   23,    0, 25,  0,  4 }, {     15,   22,    0, 25,  0,  4 },
    {     15,   21,    0, 25,  0,  4 }, {     15,   20,    0, 25,  0,  4 }, {     14,   19,    0, 25,  0,  4 }, {     14,   18,    0, 26,  0,  4 }, {     14,   17,    0, 26,  0,  4 },
    {     13,   16,    0, 26,  0,  4 }, {     13,   15,    0, 26,  0,  4 }, {     13,   14,    0, 26,  0,  4 }, {     12,   13,    0, 26,  0,  4 }, {     12,   12,    0, 26,  0,  4 },
    {     11,   11,    0, 26,  0,  4 }, {     11,   10,    0, 26,  0,  4 }, {     10,    9,    0, 26,  0,  4 }, {     10,    8,    0, 27,  0,  4 }, {      9,    7,    0, 27,  0,  4 },
    {      9,    6,    0, 27,  0,  4 }, {      8,    5,    0, 27,  0,  4 }, {      7,    4,    0, 27,  0,  4 }, {      7,    3,    0, 27,  0,  4 }, {      6,    2,    0, 27,  0,  4 },
    {      5,    1,    0, 27,  0,  4 }, {      4,    0,    0, 27,  0,  4 }, {      3,   -1,    0, 28,  0,  4 }, {      3,   -3,    0, 28,  0,  4 }, {      2,   -4,    0, 28,  0,  4 },
    {      1,   -5,    0, 28,  0,  4 }, {      0,   -6,    0, 28,  0,  4 }, {     -1,   -7,    0, 29,  0,  4 }, {     -2,   -7,    0, 29,  0,  4 }, {     -3,   -8,    0, 29,  0,  4 },
    {     -4,   -9,    0, 29,  0,  4 }, {     -5,   -9,    0, 29,  0,  4 }, {     -6,  -10,    0, 29,  0,  4 }, {     -7,  -10,    0, 29,  0,  4 }, {     -8,  -11,    0, 29,  0,  4 },
    {     -9,  -11,    0, 29,  0,  4 }, {    -10,  -12,    0, 30,  0,  4 }, {    -11,  -12,    0, 30,  0,  4 }, {    -12,  -13,    0, 30,  0,  4 }, {    -13,  -13,    0, 30,  0,  4 },
    {    -14,  -13,    0, 30,  0,  4 }, {    -15,  -14,    0, 30,  0,  4 }, {    -16,  -14,    0, 30,  0,  4 }, {    -17,  -14,    0, 30,  0,  4 }, {    -18,  -15,    0, 30,  0,  4 },
    {    -19,  -15,    0, 30,  0,  4 }, {    -20,  -15,    0, 31,  0,  4 }, {    -21,  -15,    0, 31,  0,  4 }, {    -22,  -15,    0, 31,  0,  4 }, {    -23,  -15,    0, 31,  0,  4 },
    {    -24,  -16,    0, 31,  0,  4 }, {    -25,  -16,    0, 31,  0,  4 }, {    -26,  -16,    0, 31,  0,  4 }, {    -27,  -16,    0, 31,  0,  4 }, {    -28,  -16,    0,  0,  0,  4 },
    {    -29,  -16,    0,  0,  0,  4 }, {    -30,  -16,    0,  0,  0,  4 }, {    -31,  -16,    0,  0,  0,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E26BE, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2, 31,  2,  0 },
    {     26,   16,    2, 31,  2,  0 }, {     25,   15,    2, 31,  2,  0 }, {     24,   15,    3, 31,  2,  0 }, {     23,   15,    3, 31,  2,  0 }, {     22,   15,    4, 31,  2,  0 },
    {     21,   15,    4, 31,  2,  0 }, {     20,   15,    4, 31,  2,  0 }, {     19,   14,    5, 31,  2,  0 }, {     18,   14,    5, 30,  2,  0 }, {     17,   14,    6, 30,  2,  0 },
    {     16,   13,    6, 30,  2,  0 }, {     15,   13,    7, 30,  2,  0 }, {     14,   13,    7, 30,  2,  0 }, {     13,   12,    8, 30,  2,  0 }, {     12,   12,    8, 30,  2,  0 },
    {     11,   11,    9, 30,  2,  0 }, {     10,   11,    9, 30,  2,  0 }, {      9,   10,   10, 30,  2,  0 }, {      8,   10,   10, 29,  2,  0 }, {      7,    9,   11, 29,  2,  0 },
    {      6,    9,   11, 29,  2,  0 }, {      5,    8,   11, 29,  2,  0 }, {      4,    7,   12, 29,  2,  0 }, {      3,    7,   13, 29,  2,  0 }, {      2,    6,   13, 29,  2,  0 },
    {      1,    5,   14, 29,  2,  0 }, {      0,    4,   14, 29,  2,  0 }, {     -1,    3,   15, 28,  2,  0 }, {     -3,    3,   15, 28,  2,  0 }, {     -4,    2,   16, 28,  2,  0 },
    {     -5,    1,   16, 28,  2,  0 }, {     -6,    0,   17, 28,  2,  0 }, {     -7,   -1,   17, 27,  2,  0 }, {     -7,   -2,   18, 27,  2,  0 }, {     -8,   -3,   18, 27,  2,  0 },
    {     -9,   -4,   19, 27,  2,  0 }, {     -9,   -5,   19, 27,  2,  0 }, {    -10,   -6,   20, 27,  2,  0 }, {    -10,   -7,   20, 27,  2,  0 }, {    -11,   -8,   21, 27,  2,  0 },
    {    -11,   -9,   21, 27,  2,  0 }, {    -12,  -10,   22, 26,  2,  0 }, {    -12,  -11,   22, 26,  2,  0 }, {    -13,  -12,   23, 26,  2,  0 }, {    -13,  -13,   23, 26,  2,  0 },
    {    -13,  -14,   24, 26,  2,  0 }, {    -14,  -15,   24, 26,  2,  0 }, {    -14,  -16,   25, 26,  2,  0 }, {    -14,  -17,   25, 26,  2,  0 }, {    -15,  -18,   25, 26,  2,  0 },
    {    -15,  -19,   26, 26,  2,  0 }, {    -15,  -20,   26, 25,  2,  0 }, {    -15,  -21,   27, 25,  2,  0 }, {    -15,  -22,   27, 25,  2,  0 }, {    -15,  -23,   28, 25,  2,  0 },
    {    -16,  -24,   28, 25,  2,  0 }, {    -16,  -25,   29, 25,  2,  0 }, {    -16,  -26,   29, 25,  2,  0 }, {    -16,  -27,   29, 25,  2,  0 }, {    -16,  -28,   30, 24,  2,  0 },
    {    -16,  -29,   30, 24,  2,  0 }, {    -16,  -30,   31, 24,  2,  0 }, {    -16,  -31,   31, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2924, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    0,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    1,  8,  2,  0 },
    {     16,    5,    2,  7,  2,  0 }, {     16,    6,    2,  7,  2,  0 }, {     15,    7,    2,  7,  2,  0 }, {     15,    8,    3,  7,  2,  0 }, {     15,    9,    3,  7,  2,  0 },
    {     15,   10,    4,  7,  2,  0 }, {     15,   11,    4,  7,  2,  0 }, {     15,   12,    4,  7,  2,  0 }, {     14,   13,    5,  7,  2,  0 }, {     14,   14,    5,  6,  2,  0 },
    {     14,   15,    6,  6,  2,  0 }, {     13,   16,    6,  6,  2,  0 }, {     13,   17,    7,  6,  2,  0 }, {     13,   18,    7,  6,  2,  0 }, {     12,   19,    8,  6,  2,  0 },
    {     12,   20,    8,  6,  2,  0 }, {     11,   21,    9,  6,  2,  0 }, {     11,   22,    9,  6,  2,  0 }, {     10,   23,   10,  6,  2,  0 }, {     10,   24,   10,  5,  2,  0 },
    {      9,   25,   11,  5,  2,  0 }, {      9,   26,   11,  5,  2,  0 }, {      8,   27,   11,  5,  2,  0 }, {      7,   28,   12,  5,  2,  0 }, {      7,   29,   13,  5,  2,  0 },
    {      6,   30,   13,  5,  2,  0 }, {      5,   31,   14,  5,  2,  0 }, {      4,   32,   14,  5,  2,  0 }, {      3,   33,   15,  4,  2,  0 }, {      3,   35,   15,  4,  2,  0 },
    {      2,   36,   16,  4,  2,  0 }, {      1,   37,   16,  4,  2,  0 }, {      0,   38,   17,  4,  2,  0 }, {     -1,   39,   17,  3,  2,  0 }, {     -2,   39,   18,  3,  2,  0 },
    {     -3,   40,   18,  3,  2,  0 }, {     -4,   41,   19,  3,  2,  0 }, {     -5,   41,   19,  3,  2,  0 }, {     -6,   42,   20,  3,  2,  0 }, {     -7,   42,   20,  3,  2,  0 },
    {     -8,   43,   21,  3,  2,  0 }, {     -9,   43,   21,  3,  2,  0 }, {    -10,   44,   22,  2,  2,  0 }, {    -11,   44,   22,  2,  2,  0 }, {    -12,   45,   23,  2,  2,  0 },
    {    -13,   45,   23,  2,  2,  0 }, {    -14,   45,   24,  2,  2,  0 }, {    -15,   46,   24,  2,  2,  0 }, {    -16,   46,   25,  2,  2,  0 }, {    -17,   46,   25,  2,  2,  0 },
    {    -18,   47,   25,  2,  2,  0 }, {    -19,   47,   26,  2,  2,  0 }, {    -20,   47,   26,  1,  2,  0 }, {    -21,   47,   27,  1,  2,  0 }, {    -22,   47,   27,  1,  2,  0 },
    {    -23,   47,   28,  1,  2,  0 }, {    -24,   48,   28,  1,  2,  0 }, {    -25,   48,   29,  1,  2,  0 }, {    -26,   48,   29,  1,  2,  0 }, {    -27,   48,   29,  1,  2,  0 },
    {    -28,   48,   30,  0,  2,  0 }, {    -29,   48,   30,  0,  2,  0 }, {    -30,   48,   31,  0,  2,  0 }, {    -31,   48,   31,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2B93, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    0, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    1, 16,  2,  0 },
    {      5,   16,    2, 15,  2,  0 }, {      6,   16,    2, 15,  2,  0 }, {      7,   17,    2, 15,  2,  0 }, {      8,   17,    3, 15,  2,  0 }, {      9,   17,    3, 15,  2,  0 },
    {     10,   17,    4, 15,  2,  0 }, {     11,   17,    4, 15,  2,  0 }, {     12,   17,    5, 15,  2,  0 }, {     13,   18,    5, 15,  2,  0 }, {     14,   18,    6, 14,  2,  0 },
    {     15,   18,    6, 14,  2,  0 }, {     16,   19,    6, 14,  2,  0 }, {     17,   19,    7, 14,  2,  0 }, {     18,   19,    7, 14,  2,  0 }, {     19,   20,    8, 14,  2,  0 },
    {     20,   20,    8, 14,  2,  0 }, {     21,   21,    9, 14,  2,  0 }, {     22,   21,    9, 14,  2,  0 }, {     23,   22,   10, 14,  2,  0 }, {     24,   22,   10, 13,  2,  0 },
    {     25,   23,   11, 13,  2,  0 }, {     26,   23,   11, 13,  2,  0 }, {     27,   24,   12, 13,  2,  0 }, {     28,   25,   12, 13,  2,  0 }, {     29,   25,   13, 13,  2,  0 },
    {     30,   26,   13, 13,  2,  0 }, {     31,   27,   14, 13,  2,  0 }, {     32,   28,   14, 13,  2,  0 }, {     33,   29,   15, 12,  2,  0 }, {     35,   29,   15, 12,  2,  0 },
    {     36,   30,   16, 12,  2,  0 }, {     37,   31,   16, 12,  2,  0 }, {     38,   32,   17, 12,  2,  0 }, {     39,   33,   18, 11,  2,  0 }, {     39,   34,   18, 11,  2,  0 },
    {     40,   35,   19, 11,  2,  0 }, {     41,   36,   19, 11,  2,  0 }, {     41,   37,   20, 11,  2,  0 }, {     42,   38,   20, 11,  2,  0 }, {     42,   39,   21, 11,  2,  0 },
    {     43,   40,   21, 11,  2,  0 }, {     43,   41,   22, 11,  2,  0 }, {     44,   42,   22, 10,  2,  0 }, {     44,   43,   23, 10,  2,  0 }, {     45,   44,   23, 10,  2,  0 },
    {     45,   45,   24, 10,  2,  0 }, {     45,   46,   24, 10,  2,  0 }, {     46,   47,   24, 10,  2,  0 }, {     46,   48,   25, 10,  2,  0 }, {     46,   49,   25, 10,  2,  0 },
    {     47,   50,   26, 10,  2,  0 }, {     47,   51,   26, 10,  2,  0 }, {     47,   52,   27,  9,  2,  0 }, {     47,   53,   27,  9,  2,  0 }, {     47,   54,   28,  9,  2,  0 },
    {     47,   55,   28,  9,  2,  0 }, {     48,   56,   28,  9,  2,  0 }, {     48,   57,   29,  9,  2,  0 }, {     48,   58,   29,  9,  2,  0 }, {     48,   59,   30,  9,  2,  0 },
    {     48,   60,   30,  8,  2,  0 }, {     48,   61,   31,  8,  2,  0 }, {     48,   62,   31,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2DF9, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 23,  2,  0 },
    {     16,   26,    2, 23,  2,  0 }, {     17,   25,    2, 23,  2,  0 }, {     17,   24,    3, 23,  2,  0 }, {     17,   23,    3, 23,  2,  0 }, {     17,   22,    4, 23,  2,  0 },
    {     17,   21,    4, 23,  2,  0 }, {     17,   20,    5, 23,  2,  0 }, {     18,   19,    5, 23,  2,  0 }, {     18,   18,    6, 22,  2,  0 }, {     18,   17,    6, 22,  2,  0 },
    {     19,   16,    6, 22,  2,  0 }, {     19,   15,    7, 22,  2,  0 }, {     19,   14,    7, 22,  2,  0 }, {     20,   13,    8, 22,  2,  0 }, {     20,   12,    8, 22,  2,  0 },
    {     21,   11,    9, 22,  2,  0 }, {     21,   10,    9, 22,  2,  0 }, {     22,    9,   10, 22,  2,  0 }, {     22,    8,   10, 21,  2,  0 }, {     23,    7,   11, 21,  2,  0 },
    {     23,    6,   11, 21,  2,  0 }, {     24,    5,   12, 21,  2,  0 }, {     25,    4,   12, 21,  2,  0 }, {     25,    3,   13, 21,  2,  0 }, {     26,    2,   13, 21,  2,  0 },
    {     27,    1,   14, 21,  2,  0 }, {     28,    0,   14, 21,  2,  0 }, {     29,   -1,   15, 20,  2,  0 }, {     29,   -3,   15, 20,  2,  0 }, {     30,   -4,   16, 20,  2,  0 },
    {     31,   -5,   16, 20,  2,  0 }, {     32,   -6,   17, 20,  2,  0 }, {     33,   -7,   18, 19,  2,  0 }, {     34,   -7,   18, 19,  2,  0 }, {     35,   -8,   19, 19,  2,  0 },
    {     36,   -9,   19, 19,  2,  0 }, {     37,   -9,   20, 19,  2,  0 }, {     38,  -10,   20, 19,  2,  0 }, {     39,  -10,   21, 19,  2,  0 }, {     40,  -11,   21, 19,  2,  0 },
    {     41,  -11,   22, 19,  2,  0 }, {     42,  -12,   22, 18,  2,  0 }, {     43,  -12,   23, 18,  2,  0 }, {     44,  -13,   23, 18,  2,  0 }, {     45,  -13,   24, 18,  2,  0 },
    {     46,  -13,   24, 18,  2,  0 }, {     47,  -14,   24, 18,  2,  0 }, {     48,  -14,   25, 18,  2,  0 }, {     49,  -14,   25, 18,  2,  0 }, {     50,  -15,   26, 18,  2,  0 },
    {     51,  -15,   26, 18,  2,  0 }, {     52,  -15,   27, 17,  2,  0 }, {     53,  -15,   27, 17,  2,  0 }, {     54,  -15,   28, 17,  2,  0 }, {     55,  -15,   28, 17,  2,  0 },
    {     56,  -16,   28, 17,  2,  0 }, {     57,  -16,   29, 17,  2,  0 }, {     58,  -16,   29, 17,  2,  0 }, {     59,  -16,   30, 17,  2,  0 }, {     60,  -16,   30, 16,  2,  0 },
    {     61,  -16,   31, 16,  2,  0 }, {     62,  -16,   31, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3056, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  1,  2,  0 },
    {     26,   16,    2,  1,  2,  0 }, {     25,   17,    2,  1,  2,  0 }, {     24,   17,    3,  1,  2,  0 }, {     23,   17,    3,  1,  2,  0 }, {     22,   17,    4,  1,  2,  0 },
    {     21,   17,    4,  1,  2,  0 }, {     20,   17,    5,  1,  2,  0 }, {     19,   18,    5,  1,  2,  0 }, {     18,   18,    6,  2,  2,  0 }, {     17,   18,    6,  2,  2,  0 },
    {     16,   19,    6,  2,  2,  0 }, {     15,   19,    7,  2,  2,  0 }, {     14,   19,    7,  2,  2,  0 }, {     13,   20,    8,  2,  2,  0 }, {     12,   20,    8,  2,  2,  0 },
    {     11,   21,    9,  2,  2,  0 }, {     10,   21,    9,  2,  2,  0 }, {      9,   22,   10,  2,  2,  0 }, {      8,   22,   10,  3,  2,  0 }, {      7,   23,   11,  3,  2,  0 },
    {      6,   23,   11,  3,  2,  0 }, {      5,   24,   12,  3,  2,  0 }, {      4,   25,   12,  3,  2,  0 }, {      3,   25,   13,  3,  2,  0 }, {      2,   26,   13,  3,  2,  0 },
    {      1,   27,   14,  3,  2,  0 }, {      0,   28,   14,  3,  2,  0 }, {     -1,   29,   15,  4,  2,  0 }, {     -3,   29,   15,  4,  2,  0 }, {     -4,   30,   16,  4,  2,  0 },
    {     -5,   31,   16,  4,  2,  0 }, {     -6,   32,   17,  4,  2,  0 }, {     -7,   33,   18,  5,  2,  0 }, {     -7,   34,   18,  5,  2,  0 }, {     -8,   35,   19,  5,  2,  0 },
    {     -9,   36,   19,  5,  2,  0 }, {     -9,   37,   20,  5,  2,  0 }, {    -10,   38,   20,  5,  2,  0 }, {    -10,   39,   21,  5,  2,  0 }, {    -11,   40,   21,  5,  2,  0 },
    {    -11,   41,   22,  5,  2,  0 }, {    -12,   42,   22,  6,  2,  0 }, {    -12,   43,   23,  6,  2,  0 }, {    -13,   44,   23,  6,  2,  0 }, {    -13,   45,   24,  6,  2,  0 },
    {    -13,   46,   24,  6,  2,  0 }, {    -14,   47,   24,  6,  2,  0 }, {    -14,   48,   25,  6,  2,  0 }, {    -14,   49,   25,  6,  2,  0 }, {    -15,   50,   26,  6,  2,  0 },
    {    -15,   51,   26,  6,  2,  0 }, {    -15,   52,   27,  7,  2,  0 }, {    -15,   53,   27,  7,  2,  0 }, {    -15,   54,   28,  7,  2,  0 }, {    -15,   55,   28,  7,  2,  0 },
    {    -16,   56,   28,  7,  2,  0 }, {    -16,   57,   29,  7,  2,  0 }, {    -16,   58,   29,  7,  2,  0 }, {    -16,   59,   30,  7,  2,  0 }, {    -16,   60,   30,  8,  2,  0 },
    {    -16,   61,   31,  8,  2,  0 }, {    -16,   62,   31,  8,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E32B3, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    0,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    1,  8,  2,  0 },
    {     16,    5,    2,  9,  2,  0 }, {     16,    6,    2,  9,  2,  0 }, {     17,    7,    2,  9,  2,  0 }, {     17,    8,    3,  9,  2,  0 }, {     17,    9,    3,  9,  2,  0 },
    {     17,   10,    4,  9,  2,  0 }, {     17,   11,    4,  9,  2,  0 }, {     17,   12,    5,  9,  2,  0 }, {     18,   13,    5,  9,  2,  0 }, {     18,   14,    6, 10,  2,  0 },
    {     18,   15,    6, 10,  2,  0 }, {     19,   16,    6, 10,  2,  0 }, {     19,   17,    7, 10,  2,  0 }, {     19,   18,    7, 10,  2,  0 }, {     20,   19,    8, 10,  2,  0 },
    {     20,   20,    8, 10,  2,  0 }, {     21,   21,    9, 10,  2,  0 }, {     21,   22,    9, 10,  2,  0 }, {     22,   23,   10, 10,  2,  0 }, {     22,   24,   10, 11,  2,  0 },
    {     23,   25,   11, 11,  2,  0 }, {     23,   26,   11, 11,  2,  0 }, {     24,   27,   12, 11,  2,  0 }, {     25,   28,   12, 11,  2,  0 }, {     25,   29,   13, 11,  2,  0 },
    {     26,   30,   13, 11,  2,  0 }, {     27,   31,   14, 11,  2,  0 }, {     28,   32,   14, 11,  2,  0 }, {     29,   33,   15, 12,  2,  0 }, {     29,   35,   15, 12,  2,  0 },
    {     30,   36,   16, 12,  2,  0 }, {     31,   37,   16, 12,  2,  0 }, {     32,   38,   17, 12,  2,  0 }, {     33,   39,   18, 13,  2,  0 }, {     34,   39,   18, 13,  2,  0 },
    {     35,   40,   19, 13,  2,  0 }, {     36,   41,   19, 13,  2,  0 }, {     37,   41,   20, 13,  2,  0 }, {     38,   42,   20, 13,  2,  0 }, {     39,   42,   21, 13,  2,  0 },
    {     40,   43,   21, 13,  2,  0 }, {     41,   43,   22, 13,  2,  0 }, {     42,   44,   22, 14,  2,  0 }, {     43,   44,   23, 14,  2,  0 }, {     44,   45,   23, 14,  2,  0 },
    {     45,   45,   24, 14,  2,  0 }, {     46,   45,   24, 14,  2,  0 }, {     47,   46,   24, 14,  2,  0 }, {     48,   46,   25, 14,  2,  0 }, {     49,   46,   25, 14,  2,  0 },
    {     50,   47,   26, 14,  2,  0 }, {     51,   47,   26, 14,  2,  0 }, {     52,   47,   27, 15,  2,  0 }, {     53,   47,   27, 15,  2,  0 }, {     54,   47,   28, 15,  2,  0 },
    {     55,   47,   28, 15,  2,  0 }, {     56,   48,   28, 15,  2,  0 }, {     57,   48,   29, 15,  2,  0 }, {     58,   48,   29, 15,  2,  0 }, {     59,   48,   30, 15,  2,  0 },
    {     60,   48,   30, 16,  2,  0 }, {     61,   48,   31, 16,  2,  0 }, {     62,   48,   31, 16,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3519, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    0, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    1, 16,  2,  0 },
    {      5,   16,    2, 17,  2,  0 }, {      6,   16,    2, 17,  2,  0 }, {      7,   15,    2, 17,  2,  0 }, {      8,   15,    3, 17,  2,  0 }, {      9,   15,    3, 17,  2,  0 },
    {     10,   15,    4, 17,  2,  0 }, {     11,   15,    4, 17,  2,  0 }, {     12,   15,    4, 17,  2,  0 }, {     13,   14,    5, 17,  2,  0 }, {     14,   14,    5, 18,  2,  0 },
    {     15,   14,    6, 18,  2,  0 }, {     16,   13,    6, 18,  2,  0 }, {     17,   13,    7, 18,  2,  0 }, {     18,   13,    7, 18,  2,  0 }, {     19,   12,    8, 18,  2,  0 },
    {     20,   12,    8, 18,  2,  0 }, {     21,   11,    9, 18,  2,  0 }, {     22,   11,    9, 18,  2,  0 }, {     23,   10,   10, 18,  2,  0 }, {     24,   10,   10, 19,  2,  0 },
    {     25,    9,   11, 19,  2,  0 }, {     26,    9,   11, 19,  2,  0 }, {     27,    8,   11, 19,  2,  0 }, {     28,    7,   12, 19,  2,  0 }, {     29,    7,   13, 19,  2,  0 },
    {     30,    6,   13, 19,  2,  0 }, {     31,    5,   14, 19,  2,  0 }, {     32,    4,   14, 19,  2,  0 }, {     33,    3,   15, 20,  2,  0 }, {     35,    3,   15, 20,  2,  0 },
    {     36,    2,   16, 20,  2,  0 }, {     37,    1,   16, 20,  2,  0 }, {     38,    0,   17, 20,  2,  0 }, {     39,   -1,   17, 21,  2,  0 }, {     39,   -2,   18, 21,  2,  0 },
    {     40,   -3,   18, 21,  2,  0 }, {     41,   -4,   19, 21,  2,  0 }, {     41,   -5,   19, 21,  2,  0 }, {     42,   -6,   20, 21,  2,  0 }, {     42,   -7,   20, 21,  2,  0 },
    {     43,   -8,   21, 21,  2,  0 }, {     43,   -9,   21, 21,  2,  0 }, {     44,  -10,   22, 22,  2,  0 }, {     44,  -11,   22, 22,  2,  0 }, {     45,  -12,   23, 22,  2,  0 },
    {     45,  -13,   23, 22,  2,  0 }, {     45,  -14,   24, 22,  2,  0 }, {     46,  -15,   24, 22,  2,  0 }, {     46,  -16,   25, 22,  2,  0 }, {     46,  -17,   25, 22,  2,  0 },
    {     47,  -18,   25, 22,  2,  0 }, {     47,  -19,   26, 22,  2,  0 }, {     47,  -20,   26, 23,  2,  0 }, {     47,  -21,   27, 23,  2,  0 }, {     47,  -22,   27, 23,  2,  0 },
    {     47,  -23,   28, 23,  2,  0 }, {     48,  -24,   28, 23,  2,  0 }, {     48,  -25,   29, 23,  2,  0 }, {     48,  -26,   29, 23,  2,  0 }, {     48,  -27,   29, 23,  2,  0 },
    {     48,  -28,   30, 24,  2,  0 }, {     48,  -29,   30, 24,  2,  0 }, {     48,  -30,   31, 24,  2,  0 }, {     48,  -31,   31, 24,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3788, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 25,  2,  0 },
    {     16,   26,    2, 25,  2,  0 }, {     15,   25,    2, 25,  2,  0 }, {     15,   24,    3, 25,  2,  0 }, {     15,   23,    3, 25,  2,  0 }, {     15,   22,    4, 25,  2,  0 },
    {     15,   21,    4, 25,  2,  0 }, {     15,   20,    4, 25,  2,  0 }, {     14,   19,    5, 25,  2,  0 }, {     14,   18,    5, 26,  2,  0 }, {     14,   17,    6, 26,  2,  0 },
    {     13,   16,    6, 26,  2,  0 }, {     13,   15,    7, 26,  2,  0 }, {     13,   14,    7, 26,  2,  0 }, {     12,   13,    8, 26,  2,  0 }, {     12,   12,    8, 26,  2,  0 },
    {     11,   11,    9, 26,  2,  0 }, {     11,   10,    9, 26,  2,  0 }, {     10,    9,   10, 26,  2,  0 }, {     10,    8,   10, 27,  2,  0 }, {      9,    7,   11, 27,  2,  0 },
    {      9,    6,   11, 27,  2,  0 }, {      8,    5,   11, 27,  2,  0 }, {      7,    4,   12, 27,  2,  0 }, {      7,    3,   13, 27,  2,  0 }, {      6,    2,   13, 27,  2,  0 },
    {      5,    1,   14, 27,  2,  0 }, {      4,    0,   14, 27,  2,  0 }, {      3,   -1,   15, 28,  2,  0 }, {      3,   -3,   15, 28,  2,  0 }, {      2,   -4,   16, 28,  2,  0 },
    {      1,   -5,   16, 28,  2,  0 }, {      0,   -6,   17, 28,  2,  0 }, {     -1,   -7,   17, 29,  2,  0 }, {     -2,   -7,   18, 29,  2,  0 }, {     -3,   -8,   18, 29,  2,  0 },
    {     -4,   -9,   19, 29,  2,  0 }, {     -5,   -9,   19, 29,  2,  0 }, {     -6,  -10,   20, 29,  2,  0 }, {     -7,  -10,   20, 29,  2,  0 }, {     -8,  -11,   21, 29,  2,  0 },
    {     -9,  -11,   21, 29,  2,  0 }, {    -10,  -12,   22, 30,  2,  0 }, {    -11,  -12,   22, 30,  2,  0 }, {    -12,  -13,   23, 30,  2,  0 }, {    -13,  -13,   23, 30,  2,  0 },
    {    -14,  -13,   24, 30,  2,  0 }, {    -15,  -14,   24, 30,  2,  0 }, {    -16,  -14,   25, 30,  2,  0 }, {    -17,  -14,   25, 30,  2,  0 }, {    -18,  -15,   25, 30,  2,  0 },
    {    -19,  -15,   26, 30,  2,  0 }, {    -20,  -15,   26, 31,  2,  0 }, {    -21,  -15,   27, 31,  2,  0 }, {    -22,  -15,   27, 31,  2,  0 }, {    -23,  -15,   28, 31,  2,  0 },
    {    -24,  -16,   28, 31,  2,  0 }, {    -25,  -16,   29, 31,  2,  0 }, {    -26,  -16,   29, 31,  2,  0 }, {    -27,  -16,   29, 31,  2,  0 }, {    -28,  -16,   30,  0,  2,  0 },
    {    -29,  -16,   30,  0,  2,  0 }, {    -30,  -16,   31,  0,  2,  0 }, {    -31,  -16,   31,  0,  2,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E138E, {
    {     31,   16,   15,  0,  6,  0 }, {     30,   16,   15,  0,  6,  0 }, {     29,   16,   14,  0,  6,  0 }, {     28,   16,   14,  0,  6,  0 }, {     27,   16,   13, 31,  6,  0 },
    {     26,   16,   13, 31,  6,  0 }, {     25,   15,   13, 31,  6,  0 }, {     24,   15,   12, 31,  6,  0 }, {     23,   15,   12, 31,  6,  0 }, {     22,   15,   11, 31,  6,  0 },
    {     21,   15,   11, 31,  6,  0 }, {     20,   15,   11, 31,  6,  0 }, {     19,   14,   10, 31,  6,  0 }, {     18,   14,   10, 30,  6,  0 }, {     17,   14,    9, 30,  6,  0 },
    {     16,   13,    9, 30,  6,  0 }, {     15,   13,    8, 30,  6,  0 }, {     14,   13,    8, 30,  6,  0 }, {     13,   12,    7, 30,  6,  0 }, {     12,   12,    7, 30,  6,  0 },
    {     11,   11,    6, 30,  6,  0 }, {     10,   11,    6, 30,  6,  0 }, {      9,   10,    5, 30,  6,  0 }, {      8,   10,    5, 29,  6,  0 }, {      7,    9,    4, 29,  6,  0 },
    {      6,    9,    4, 29,  6,  0 }, {      5,    8,    4, 29,  6,  0 }, {      4,    7,    3, 29,  6,  0 }, {      3,    7,    2, 29,  6,  0 }, {      2,    6,    2, 29,  6,  0 },
    {      1,    5,    1, 29,  6,  0 }, {      0,    4,    1, 29,  6,  0 }, {     -1,    3,    0, 28,  6,  0 }, {     -3,    3,    0, 28,  6,  0 }, {     -4,    2,   -1, 28,  6,  0 },
    {     -5,    1,   -1, 28,  6,  0 }, {     -6,    0,   -2, 28,  6,  0 }, {     -7,   -1,   -2, 27,  6,  0 }, {     -7,   -2,   -3, 27,  6,  0 }, {     -8,   -3,   -3, 27,  6,  0 },
    {     -9,   -4,   -4, 27,  6,  0 }, {     -9,   -5,   -5, 27,  6,  0 }, {    -10,   -6,   -5, 27,  6,  0 }, {    -10,   -7,   -5, 27,  6,  0 }, {    -11,   -8,   -6, 27,  6,  0 },
    {    -11,   -9,   -6, 27,  6,  0 }, {    -12,  -10,   -7, 26,  6,  0 }, {    -12,  -11,   -7, 26,  6,  0 }, {    -13,  -12,   -8, 26,  6,  0 }, {    -13,  -13,   -8, 26,  6,  0 },
    {    -13,  -14,   -9, 26,  6,  0 }, {    -14,  -15,   -9, 26,  6,  0 }, {    -14,  -16,  -10, 26,  6,  0 }, {    -14,  -17,  -10, 26,  6,  0 }, {    -15,  -18,  -11, 26,  6,  0 },
    {    -15,  -19,  -11, 26,  6,  0 }, {    -15,  -20,  -12, 25,  6,  0 }, {    -15,  -21,  -12, 25,  6,  0 }, {    -15,  -22,  -12, 25,  6,  0 }, {    -15,  -23,  -13, 25,  6,  0 },
    {    -16,  -24,  -13, 25,  6,  0 }, {    -16,  -25,  -14, 25,  6,  0 }, {    -16,  -26,  -14, 25,  6,  0 }, {    -16,  -27,  -14, 25,  6,  0 }, {    -16,  -28,  -15, 24,  6,  0 },
    {    -16,  -29,  -15, 24,  6,  0 }, {    -16,  -30,  -16, 24,  6,  0 }, {    -16,  -31,  -17, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E15F4, {
    {     16,    0,   15,  8,  6,  0 }, {     16,    1,   15,  8,  6,  0 }, {     16,    2,   15,  8,  6,  0 }, {     16,    3,   14,  8,  6,  0 }, {     16,    4,   14,  8,  6,  0 },
    {     16,    5,   13,  7,  6,  0 }, {     16,    6,   13,  7,  6,  0 }, {     15,    7,   13,  7,  6,  0 }, {     15,    8,   12,  7,  6,  0 }, {     15,    9,   12,  7,  6,  0 },
    {     15,   10,   11,  7,  6,  0 }, {     15,   11,   11,  7,  6,  0 }, {     15,   12,   11,  7,  6,  0 }, {     14,   13,   10,  7,  6,  0 }, {     14,   14,   10,  6,  6,  0 },
    {     14,   15,    9,  6,  6,  0 }, {     13,   16,    9,  6,  6,  0 }, {     13,   17,    8,  6,  6,  0 }, {     13,   18,    8,  6,  6,  0 }, {     12,   19,    7,  6,  6,  0 },
    {     12,   20,    7,  6,  6,  0 }, {     11,   21,    6,  6,  6,  0 }, {     11,   22,    6,  6,  6,  0 }, {     10,   23,    5,  6,  6,  0 }, {     10,   24,    5,  5,  6,  0 },
    {      9,   25,    4,  5,  6,  0 }, {      9,   26,    4,  5,  6,  0 }, {      8,   27,    4,  5,  6,  0 }, {      7,   28,    3,  5,  6,  0 }, {      7,   29,    2,  5,  6,  0 },
    {      6,   30,    2,  5,  6,  0 }, {      5,   31,    1,  5,  6,  0 }, {      4,   32,    1,  5,  6,  0 }, {      3,   33,    0,  4,  6,  0 }, {      3,   35,    0,  4,  6,  0 },
    {      2,   36,   -1,  4,  6,  0 }, {      1,   37,   -1,  4,  6,  0 }, {      0,   38,   -2,  4,  6,  0 }, {     -1,   39,   -2,  3,  6,  0 }, {     -2,   39,   -3,  3,  6,  0 },
    {     -3,   40,   -3,  3,  6,  0 }, {     -4,   41,   -4,  3,  6,  0 }, {     -5,   41,   -5,  3,  6,  0 }, {     -6,   42,   -5,  3,  6,  0 }, {     -7,   42,   -5,  3,  6,  0 },
    {     -8,   43,   -6,  3,  6,  0 }, {     -9,   43,   -6,  3,  6,  0 }, {    -10,   44,   -7,  2,  6,  0 }, {    -11,   44,   -7,  2,  6,  0 }, {    -12,   45,   -8,  2,  6,  0 },
    {    -13,   45,   -8,  2,  6,  0 }, {    -14,   45,   -9,  2,  6,  0 }, {    -15,   46,   -9,  2,  6,  0 }, {    -16,   46,  -10,  2,  6,  0 }, {    -17,   46,  -10,  2,  6,  0 },
    {    -18,   47,  -11,  2,  6,  0 }, {    -19,   47,  -11,  2,  6,  0 }, {    -20,   47,  -12,  1,  6,  0 }, {    -21,   47,  -12,  1,  6,  0 }, {    -22,   47,  -12,  1,  6,  0 },
    {    -23,   47,  -13,  1,  6,  0 }, {    -24,   48,  -13,  1,  6,  0 }, {    -25,   48,  -14,  1,  6,  0 }, {    -26,   48,  -14,  1,  6,  0 }, {    -27,   48,  -14,  1,  6,  0 },
    {    -28,   48,  -15,  0,  6,  0 }, {    -29,   48,  -15,  0,  6,  0 }, {    -30,   48,  -16,  0,  6,  0 }, {    -31,   48,  -17,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1863, {
    {      0,   16,   15, 16,  6,  0 }, {      1,   16,   15, 16,  6,  0 }, {      2,   16,   15, 16,  6,  0 }, {      3,   16,   14, 16,  6,  0 }, {      4,   16,   14, 16,  6,  0 },
    {      5,   16,   13, 15,  6,  0 }, {      6,   16,   13, 15,  6,  0 }, {      7,   17,   13, 15,  6,  0 }, {      8,   17,   12, 15,  6,  0 }, {      9,   17,   12, 15,  6,  0 },
    {     10,   17,   11, 15,  6,  0 }, {     11,   17,   11, 15,  6,  0 }, {     12,   17,   10, 15,  6,  0 }, {     13,   18,   10, 15,  6,  0 }, {     14,   18,    9, 14,  6,  0 },
    {     15,   18,    9, 14,  6,  0 }, {     16,   19,    9, 14,  6,  0 }, {     17,   19,    8, 14,  6,  0 }, {     18,   19,    8, 14,  6,  0 }, {     19,   20,    7, 14,  6,  0 },
    {     20,   20,    7, 14,  6,  0 }, {     21,   21,    6, 14,  6,  0 }, {     22,   21,    6, 14,  6,  0 }, {     23,   22,    5, 14,  6,  0 }, {     24,   22,    5, 13,  6,  0 },
    {     25,   23,    4, 13,  6,  0 }, {     26,   23,    4, 13,  6,  0 }, {     27,   24,    3, 13,  6,  0 }, {     28,   25,    3, 13,  6,  0 }, {     29,   25,    2, 13,  6,  0 },
    {     30,   26,    2, 13,  6,  0 }, {     31,   27,    1, 13,  6,  0 }, {     32,   28,    1, 13,  6,  0 }, {     33,   29,    0, 12,  6,  0 }, {     35,   29,   -1, 12,  6,  0 },
    {     36,   30,   -1, 12,  6,  0 }, {     37,   31,   -1, 12,  6,  0 }, {     38,   32,   -2, 12,  6,  0 }, {     39,   33,   -3, 11,  6,  0 }, {     39,   34,   -3, 11,  6,  0 },
    {     40,   35,   -4, 11,  6,  0 }, {     41,   36,   -4, 11,  6,  0 }, {     41,   37,   -5, 11,  6,  0 }, {     42,   38,   -5, 11,  6,  0 }, {     42,   39,   -6, 11,  6,  0 },
    {     43,   40,   -6, 11,  6,  0 }, {     43,   41,   -7, 11,  6,  0 }, {     44,   42,   -7, 10,  6,  0 }, {     44,   43,   -8, 10,  6,  0 }, {     45,   44,   -8, 10,  6,  0 },
    {     45,   45,   -9, 10,  6,  0 }, {     45,   46,   -9, 10,  6,  0 }, {     46,   47,   -9, 10,  6,  0 }, {     46,   48,  -10, 10,  6,  0 }, {     46,   49,  -10, 10,  6,  0 },
    {     47,   50,  -11, 10,  6,  0 }, {     47,   51,  -11, 10,  6,  0 }, {     47,   52,  -12,  9,  6,  0 }, {     47,   53,  -12,  9,  6,  0 }, {     47,   54,  -13,  9,  6,  0 },
    {     47,   55,  -13,  9,  6,  0 }, {     48,   56,  -13,  9,  6,  0 }, {     48,   57,  -14,  9,  6,  0 }, {     48,   58,  -14,  9,  6,  0 }, {     48,   59,  -15,  9,  6,  0 },
    {     48,   60,  -15,  8,  6,  0 }, {     48,   61,  -16,  8,  6,  0 }, {     48,   62,  -16,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1AC9, {
    {     16,   31,   15, 24,  6,  0 }, {     16,   30,   15, 24,  6,  0 }, {     16,   29,   14, 24,  6,  0 }, {     16,   28,   14, 24,  6,  0 }, {     16,   27,   13, 23,  6,  0 },
    {     16,   26,   13, 23,  6,  0 }, {     17,   25,   13, 23,  6,  0 }, {     17,   24,   12, 23,  6,  0 }, {     17,   23,   12, 23,  6,  0 }, {     17,   22,   11, 23,  6,  0 },
    {     17,   21,   11, 23,  6,  0 }, {     17,   20,   10, 23,  6,  0 }, {     18,   19,   10, 23,  6,  0 }, {     18,   18,    9, 22,  6,  0 }, {     18,   17,    9, 22,  6,  0 },
    {     19,   16,    9, 22,  6,  0 }, {     19,   15,    8, 22,  6,  0 }, {     19,   14,    8, 22,  6,  0 }, {     20,   13,    7, 22,  6,  0 }, {     20,   12,    7, 22,  6,  0 },
    {     21,   11,    6, 22,  6,  0 }, {     21,   10,    6, 22,  6,  0 }, {     22,    9,    5, 22,  6,  0 }, {     22,    8,    5, 21,  6,  0 }, {     23,    7,    4, 21,  6,  0 },
    {     23,    6,    4, 21,  6,  0 }, {     24,    5,    3, 21,  6,  0 }, {     25,    4,    3, 21,  6,  0 }, {     25,    3,    2, 21,  6,  0 }, {     26,    2,    2, 21,  6,  0 },
    {     27,    1,    1, 21,  6,  0 }, {     28,    0,    1, 21,  6,  0 }, {     29,   -1,    0, 20,  6,  0 }, {     29,   -3,   -1, 20,  6,  0 }, {     30,   -4,   -1, 20,  6,  0 },
    {     31,   -5,   -1, 20,  6,  0 }, {     32,   -6,   -2, 20,  6,  0 }, {     33,   -7,   -3, 19,  6,  0 }, {     34,   -7,   -3, 19,  6,  0 }, {     35,   -8,   -4, 19,  6,  0 },
    {     36,   -9,   -4, 19,  6,  0 }, {     37,   -9,   -5, 19,  6,  0 }, {     38,  -10,   -5, 19,  6,  0 }, {     39,  -10,   -6, 19,  6,  0 }, {     40,  -11,   -6, 19,  6,  0 },
    {     41,  -11,   -7, 19,  6,  0 }, {     42,  -12,   -7, 18,  6,  0 }, {     43,  -12,   -8, 18,  6,  0 }, {     44,  -13,   -8, 18,  6,  0 }, {     45,  -13,   -9, 18,  6,  0 },
    {     46,  -13,   -9, 18,  6,  0 }, {     47,  -14,   -9, 18,  6,  0 }, {     48,  -14,  -10, 18,  6,  0 }, {     49,  -14,  -10, 18,  6,  0 }, {     50,  -15,  -11, 18,  6,  0 },
    {     51,  -15,  -11, 18,  6,  0 }, {     52,  -15,  -12, 17,  6,  0 }, {     53,  -15,  -12, 17,  6,  0 }, {     54,  -15,  -13, 17,  6,  0 }, {     55,  -15,  -13, 17,  6,  0 },
    {     56,  -16,  -13, 17,  6,  0 }, {     57,  -16,  -14, 17,  6,  0 }, {     58,  -16,  -14, 17,  6,  0 }, {     59,  -16,  -15, 17,  6,  0 }, {     60,  -16,  -15, 16,  6,  0 },
    {     61,  -16,  -16, 16,  6,  0 }, {     62,  -16,  -16, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1D26, {
    {     31,   16,   15,  0,  6,  0 }, {     30,   16,   15,  0,  6,  0 }, {     29,   16,   14,  0,  6,  0 }, {     28,   16,   14,  0,  6,  0 }, {     27,   16,   13,  1,  6,  0 },
    {     26,   16,   13,  1,  6,  0 }, {     25,   17,   13,  1,  6,  0 }, {     24,   17,   12,  1,  6,  0 }, {     23,   17,   12,  1,  6,  0 }, {     22,   17,   11,  1,  6,  0 },
    {     21,   17,   11,  1,  6,  0 }, {     20,   17,   10,  1,  6,  0 }, {     19,   18,   10,  1,  6,  0 }, {     18,   18,    9,  2,  6,  0 }, {     17,   18,    9,  2,  6,  0 },
    {     16,   19,    9,  2,  6,  0 }, {     15,   19,    8,  2,  6,  0 }, {     14,   19,    8,  2,  6,  0 }, {     13,   20,    7,  2,  6,  0 }, {     12,   20,    7,  2,  6,  0 },
    {     11,   21,    6,  2,  6,  0 }, {     10,   21,    6,  2,  6,  0 }, {      9,   22,    5,  2,  6,  0 }, {      8,   22,    5,  3,  6,  0 }, {      7,   23,    4,  3,  6,  0 },
    {      6,   23,    4,  3,  6,  0 }, {      5,   24,    3,  3,  6,  0 }, {      4,   25,    3,  3,  6,  0 }, {      3,   25,    2,  3,  6,  0 }, {      2,   26,    2,  3,  6,  0 },
    {      1,   27,    1,  3,  6,  0 }, {      0,   28,    1,  3,  6,  0 }, {     -1,   29,    0,  4,  6,  0 }, {     -3,   29,   -1,  4,  6,  0 }, {     -4,   30,   -1,  4,  6,  0 },
    {     -5,   31,   -1,  4,  6,  0 }, {     -6,   32,   -2,  4,  6,  0 }, {     -7,   33,   -3,  5,  6,  0 }, {     -7,   34,   -3,  5,  6,  0 }, {     -8,   35,   -4,  5,  6,  0 },
    {     -9,   36,   -4,  5,  6,  0 }, {     -9,   37,   -5,  5,  6,  0 }, {    -10,   38,   -5,  5,  6,  0 }, {    -10,   39,   -6,  5,  6,  0 }, {    -11,   40,   -6,  5,  6,  0 },
    {    -11,   41,   -7,  5,  6,  0 }, {    -12,   42,   -7,  6,  6,  0 }, {    -12,   43,   -8,  6,  6,  0 }, {    -13,   44,   -8,  6,  6,  0 }, {    -13,   45,   -9,  6,  6,  0 },
    {    -13,   46,   -9,  6,  6,  0 }, {    -14,   47,   -9,  6,  6,  0 }, {    -14,   48,  -10,  6,  6,  0 }, {    -14,   49,  -10,  6,  6,  0 }, {    -15,   50,  -11,  6,  6,  0 },
    {    -15,   51,  -11,  6,  6,  0 }, {    -15,   52,  -12,  7,  6,  0 }, {    -15,   53,  -12,  7,  6,  0 }, {    -15,   54,  -13,  7,  6,  0 }, {    -15,   55,  -13,  7,  6,  0 },
    {    -16,   56,  -13,  7,  6,  0 }, {    -16,   57,  -14,  7,  6,  0 }, {    -16,   58,  -14,  7,  6,  0 }, {    -16,   59,  -15,  7,  6,  0 }, {    -16,   60,  -15,  8,  6,  0 },
    {    -16,   61,  -16,  8,  6,  0 }, {    -16,   62,  -16,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E1F83, {
    {     16,    0,   15,  8,  6,  0 }, {     16,    1,   15,  8,  6,  0 }, {     16,    2,   15,  8,  6,  0 }, {     16,    3,   14,  8,  6,  0 }, {     16,    4,   14,  8,  6,  0 },
    {     16,    5,   13,  9,  6,  0 }, {     16,    6,   13,  9,  6,  0 }, {     17,    7,   13,  9,  6,  0 }, {     17,    8,   12,  9,  6,  0 }, {     17,    9,   12,  9,  6,  0 },
    {     17,   10,   11,  9,  6,  0 }, {     17,   11,   11,  9,  6,  0 }, {     17,   12,   10,  9,  6,  0 }, {     18,   13,   10,  9,  6,  0 }, {     18,   14,    9, 10,  6,  0 },
    {     18,   15,    9, 10,  6,  0 }, {     19,   16,    9, 10,  6,  0 }, {     19,   17,    8, 10,  6,  0 }, {     19,   18,    8, 10,  6,  0 }, {     20,   19,    7, 10,  6,  0 },
    {     20,   20,    7, 10,  6,  0 }, {     21,   21,    6, 10,  6,  0 }, {     21,   22,    6, 10,  6,  0 }, {     22,   23,    5, 10,  6,  0 }, {     22,   24,    5, 11,  6,  0 },
    {     23,   25,    4, 11,  6,  0 }, {     23,   26,    4, 11,  6,  0 }, {     24,   27,    3, 11,  6,  0 }, {     25,   28,    3, 11,  6,  0 }, {     25,   29,    2, 11,  6,  0 },
    {     26,   30,    2, 11,  6,  0 }, {     27,   31,    1, 11,  6,  0 }, {     28,   32,    1, 11,  6,  0 }, {     29,   33,    0, 12,  6,  0 }, {     29,   35,   -1, 12,  6,  0 },
    {     30,   36,   -1, 12,  6,  0 }, {     31,   37,   -1, 12,  6,  0 }, {     32,   38,   -2, 12,  6,  0 }, {     33,   39,   -3, 13,  6,  0 }, {     34,   39,   -3, 13,  6,  0 },
    {     35,   40,   -4, 13,  6,  0 }, {     36,   41,   -4, 13,  6,  0 }, {     37,   41,   -5, 13,  6,  0 }, {     38,   42,   -5, 13,  6,  0 }, {     39,   42,   -6, 13,  6,  0 },
    {     40,   43,   -6, 13,  6,  0 }, {     41,   43,   -7, 13,  6,  0 }, {     42,   44,   -7, 14,  6,  0 }, {     43,   44,   -8, 14,  6,  0 }, {     44,   45,   -8, 14,  6,  0 },
    {     45,   45,   -9, 14,  6,  0 }, {     46,   45,   -9, 14,  6,  0 }, {     47,   46,   -9, 14,  6,  0 }, {     48,   46,  -10, 14,  6,  0 }, {     49,   46,  -10, 14,  6,  0 },
    {     50,   47,  -11, 14,  6,  0 }, {     51,   47,  -11, 14,  6,  0 }, {     52,   47,  -12, 15,  6,  0 }, {     53,   47,  -12, 15,  6,  0 }, {     54,   47,  -13, 15,  6,  0 },
    {     55,   47,  -13, 15,  6,  0 }, {     56,   48,  -13, 15,  6,  0 }, {     57,   48,  -14, 15,  6,  0 }, {     58,   48,  -14, 15,  6,  0 }, {     59,   48,  -15, 15,  6,  0 },
    {     60,   48,  -15, 16,  6,  0 }, {     61,   48,  -16, 16,  6,  0 }, {     62,   48,  -16, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E21E9, {
    {      0,   16,   15, 16,  6,  0 }, {      1,   16,   15, 16,  6,  0 }, {      2,   16,   15, 16,  6,  0 }, {      3,   16,   14, 16,  6,  0 }, {      4,   16,   14, 16,  6,  0 },
    {      5,   16,   13, 17,  6,  0 }, {      6,   16,   13, 17,  6,  0 }, {      7,   15,   13, 17,  6,  0 }, {      8,   15,   12, 17,  6,  0 }, {      9,   15,   12, 17,  6,  0 },
    {     10,   15,   11, 17,  6,  0 }, {     11,   15,   11, 17,  6,  0 }, {     12,   15,   11, 17,  6,  0 }, {     13,   14,   10, 17,  6,  0 }, {     14,   14,   10, 18,  6,  0 },
    {     15,   14,    9, 18,  6,  0 }, {     16,   13,    9, 18,  6,  0 }, {     17,   13,    8, 18,  6,  0 }, {     18,   13,    8, 18,  6,  0 }, {     19,   12,    7, 18,  6,  0 },
    {     20,   12,    7, 18,  6,  0 }, {     21,   11,    6, 18,  6,  0 }, {     22,   11,    6, 18,  6,  0 }, {     23,   10,    5, 18,  6,  0 }, {     24,   10,    5, 19,  6,  0 },
    {     25,    9,    4, 19,  6,  0 }, {     26,    9,    4, 19,  6,  0 }, {     27,    8,    4, 19,  6,  0 }, {     28,    7,    3, 19,  6,  0 }, {     29,    7,    2, 19,  6,  0 },
    {     30,    6,    2, 19,  6,  0 }, {     31,    5,    1, 19,  6,  0 }, {     32,    4,    1, 19,  6,  0 }, {     33,    3,    0, 20,  6,  0 }, {     35,    3,    0, 20,  6,  0 },
    {     36,    2,   -1, 20,  6,  0 }, {     37,    1,   -1, 20,  6,  0 }, {     38,    0,   -2, 20,  6,  0 }, {     39,   -1,   -2, 21,  6,  0 }, {     39,   -2,   -3, 21,  6,  0 },
    {     40,   -3,   -3, 21,  6,  0 }, {     41,   -4,   -4, 21,  6,  0 }, {     41,   -5,   -4, 21,  6,  0 }, {     42,   -6,   -5, 21,  6,  0 }, {     42,   -7,   -5, 21,  6,  0 },
    {     43,   -8,   -6, 21,  6,  0 }, {     43,   -9,   -6, 21,  6,  0 }, {     44,  -10,   -7, 22,  6,  0 }, {     44,  -11,   -7, 22,  6,  0 }, {     45,  -12,   -8, 22,  6,  0 },
    {     45,  -13,   -8, 22,  6,  0 }, {     45,  -14,   -9, 22,  6,  0 }, {     46,  -15,   -9, 22,  6,  0 }, {     46,  -16,  -10, 22,  6,  0 }, {     46,  -17,  -10, 22,  6,  0 },
    {     47,  -18,  -10, 22,  6,  0 }, {     47,  -19,  -11, 22,  6,  0 }, {     47,  -20,  -11, 23,  6,  0 }, {     47,  -21,  -12, 23,  6,  0 }, {     47,  -22,  -12, 23,  6,  0 },
    {     47,  -23,  -13, 23,  6,  0 }, {     48,  -24,  -13, 23,  6,  0 }, {     48,  -25,  -14, 23,  6,  0 }, {     48,  -26,  -14, 23,  6,  0 }, {     48,  -27,  -14, 23,  6,  0 },
    {     48,  -28,  -15, 24,  6,  0 }, {     48,  -29,  -15, 24,  6,  0 }, {     48,  -30,  -16, 24,  6,  0 }, {     48,  -31,  -16, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E2458, {
    {     16,   31,   15, 24,  6,  0 }, {     16,   30,   15, 24,  6,  0 }, {     16,   29,   14, 24,  6,  0 }, {     16,   28,   14, 24,  6,  0 }, {     16,   27,   13, 25,  6,  0 },
    {     16,   26,   13, 25,  6,  0 }, {     15,   25,   13, 25,  6,  0 }, {     15,   24,   12, 25,  6,  0 }, {     15,   23,   12, 25,  6,  0 }, {     15,   22,   11, 25,  6,  0 },
    {     15,   21,   11, 25,  6,  0 }, {     15,   20,   11, 25,  6,  0 }, {     14,   19,   10, 25,  6,  0 }, {     14,   18,   10, 26,  6,  0 }, {     14,   17,    9, 26,  6,  0 },
    {     13,   16,    9, 26,  6,  0 }, {     13,   15,    8, 26,  6,  0 }, {     13,   14,    8, 26,  6,  0 }, {     12,   13,    7, 26,  6,  0 }, {     12,   12,    7, 26,  6,  0 },
    {     11,   11,    6, 26,  6,  0 }, {     11,   10,    6, 26,  6,  0 }, {     10,    9,    5, 26,  6,  0 }, {     10,    8,    5, 27,  6,  0 }, {      9,    7,    4, 27,  6,  0 },
    {      9,    6,    4, 27,  6,  0 }, {      8,    5,    4, 27,  6,  0 }, {      7,    4,    3, 27,  6,  0 }, {      7,    3,    2, 27,  6,  0 }, {      6,    2,    2, 27,  6,  0 },
    {      5,    1,    1, 27,  6,  0 }, {      4,    0,    1, 27,  6,  0 }, {      3,   -1,    0, 28,  6,  0 }, {      3,   -3,    0, 28,  6,  0 }, {      2,   -4,   -1, 28,  6,  0 },
    {      1,   -5,   -1, 28,  6,  0 }, {      0,   -6,   -2, 28,  6,  0 }, {     -1,   -7,   -2, 29,  6,  0 }, {     -2,   -7,   -3, 29,  6,  0 }, {     -3,   -8,   -3, 29,  6,  0 },
    {     -4,   -9,   -4, 29,  6,  0 }, {     -5,   -9,   -4, 29,  6,  0 }, {     -6,  -10,   -5, 29,  6,  0 }, {     -7,  -10,   -5, 29,  6,  0 }, {     -8,  -11,   -6, 29,  6,  0 },
    {     -9,  -11,   -6, 29,  6,  0 }, {    -10,  -12,   -7, 30,  6,  0 }, {    -11,  -12,   -7, 30,  6,  0 }, {    -12,  -13,   -8, 30,  6,  0 }, {    -13,  -13,   -8, 30,  6,  0 },
    {    -14,  -13,   -9, 30,  6,  0 }, {    -15,  -14,   -9, 30,  6,  0 }, {    -16,  -14,  -10, 30,  6,  0 }, {    -17,  -14,  -10, 30,  6,  0 }, {    -18,  -15,  -10, 30,  6,  0 },
    {    -19,  -15,  -11, 30,  6,  0 }, {    -20,  -15,  -11, 31,  6,  0 }, {    -21,  -15,  -12, 31,  6,  0 }, {    -22,  -15,  -12, 31,  6,  0 }, {    -23,  -15,  -13, 31,  6,  0 },
    {    -24,  -16,  -13, 31,  6,  0 }, {    -25,  -16,  -14, 31,  6,  0 }, {    -26,  -16,  -14, 31,  6,  0 }, {    -27,  -16,  -14, 31,  6,  0 }, {    -28,  -16,  -15,  0,  6,  0 },
    {    -29,  -16,  -15,  0,  6,  0 }, {    -30,  -16,  -16,  0,  6,  0 }, {    -31,  -16,  -16,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E39EE, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0, 31,  0,  0 }, {     28,   15,    0, 31,  0,  0 }, {     27,   15,    0, 30,  0,  0 },
    {     26,   15,    0, 30,  0,  0 }, {     25,   14,    0, 30,  0,  0 }, {     24,   14,    0, 29,  0,  0 }, {     23,   13,    0, 29,  0,  0 }, {     22,   12,    0, 28,  0,  0 },
    {     21,   11,    0, 28,  0,  0 }, {     20,   10,    0, 28,  0,  0 }, {     19,    9,    0, 27,  0,  0 }, {     18,    8,    0, 27,  0,  0 }, {     18,    7,    0, 26,  0,  0 },
    {     17,    6,    0, 26,  0,  0 }, {     17,    5,    0, 26,  0,  0 }, {     17,    4,    0, 25,  0,  0 }, {     16,    3,    0, 25,  0,  0 }, {     16,    2,    0, 24,  0,  0 },
    {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3AB6, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  7,  0,  0 }, {     15,    4,    0,  7,  0,  0 },
    {     15,    5,    0,  6,  0,  0 }, {     15,    6,    0,  6,  0,  0 }, {     14,    7,    0,  6,  0,  0 }, {     14,    8,    0,  5,  0,  0 }, {     13,    9,    0,  5,  0,  0 },
    {     12,   10,    0,  4,  0,  0 }, {     11,   11,    0,  4,  0,  0 }, {     10,   12,    0,  4,  0,  0 }, {      9,   13,    0,  3,  0,  0 }, {      8,   14,    0,  3,  0,  0 },
    {      7,   14,    0,  2,  0,  0 }, {      6,   15,    0,  2,  0,  0 }, {      5,   15,    0,  2,  0,  0 }, {      4,   15,    0,  1,  0,  0 }, {      3,   16,    0,  1,  0,  0 },
    {      2,   16,    0,  0,  0,  0 }, {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3B87, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 15,  0,  0 }, {      4,   17,    0, 15,  0,  0 },
    {      5,   17,    0, 14,  0,  0 }, {      6,   17,    0, 14,  0,  0 }, {      7,   18,    0, 14,  0,  0 }, {      8,   18,    0, 13,  0,  0 }, {      9,   19,    0, 13,  0,  0 },
    {     10,   20,    0, 12,  0,  0 }, {     11,   21,    0, 12,  0,  0 }, {     12,   22,    0, 12,  0,  0 }, {     13,   23,    0, 11,  0,  0 }, {     14,   24,    0, 11,  0,  0 },
    {     14,   25,    0, 10,  0,  0 }, {     15,   26,    0, 10,  0,  0 }, {     15,   27,    0, 10,  0,  0 }, {     15,   28,    0,  9,  0,  0 }, {     16,   29,    0,  9,  0,  0 },
    {     16,   30,    0,  8,  0,  0 }, {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3C4F, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 23,  0,  0 }, {     17,   28,    0, 23,  0,  0 }, {     17,   27,    0, 22,  0,  0 },
    {     17,   26,    0, 22,  0,  0 }, {     18,   25,    0, 22,  0,  0 }, {     18,   24,    0, 21,  0,  0 }, {     19,   23,    0, 21,  0,  0 }, {     20,   22,    0, 20,  0,  0 },
    {     21,   21,    0, 20,  0,  0 }, {     22,   20,    0, 20,  0,  0 }, {     23,   19,    0, 19,  0,  0 }, {     24,   18,    0, 19,  0,  0 }, {     25,   18,    0, 18,  0,  0 },
    {     26,   17,    0, 18,  0,  0 }, {     27,   17,    0, 18,  0,  0 }, {     28,   17,    0, 17,  0,  0 }, {     29,   16,    0, 17,  0,  0 }, {     30,   16,    0, 16,  0,  0 },
    {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3D0E, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  1,  0,  0 }, {     28,   17,    0,  1,  0,  0 }, {     27,   17,    0,  2,  0,  0 },
    {     26,   17,    0,  2,  0,  0 }, {     25,   18,    0,  2,  0,  0 }, {     24,   18,    0,  3,  0,  0 }, {     23,   19,    0,  3,  0,  0 }, {     22,   20,    0,  4,  0,  0 },
    {     21,   21,    0,  4,  0,  0 }, {     20,   22,    0,  4,  0,  0 }, {     19,   23,    0,  5,  0,  0 }, {     18,   24,    0,  5,  0,  0 }, {     18,   25,    0,  6,  0,  0 },
    {     17,   26,    0,  6,  0,  0 }, {     17,   27,    0,  6,  0,  0 }, {     17,   28,    0,  7,  0,  0 }, {     16,   29,    0,  7,  0,  0 }, {     16,   30,    0,  8,  0,  0 },
    {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3DCD, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  9,  0,  0 }, {     17,    4,    0,  9,  0,  0 },
    {     17,    5,    0, 10,  0,  0 }, {     17,    6,    0, 10,  0,  0 }, {     18,    7,    0, 10,  0,  0 }, {     18,    8,    0, 11,  0,  0 }, {     19,    9,    0, 11,  0,  0 },
    {     20,   10,    0, 12,  0,  0 }, {     21,   11,    0, 12,  0,  0 }, {     22,   12,    0, 12,  0,  0 }, {     23,   13,    0, 13,  0,  0 }, {     24,   14,    0, 13,  0,  0 },
    {     25,   14,    0, 14,  0,  0 }, {     26,   15,    0, 14,  0,  0 }, {     27,   15,    0, 14,  0,  0 }, {     28,   15,    0, 15,  0,  0 }, {     29,   16,    0, 15,  0,  0 },
    {     30,   16,    0, 16,  0,  0 }, {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3E95, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 17,  0,  0 }, {      4,   15,    0, 17,  0,  0 },
    {      5,   15,    0, 18,  0,  0 }, {      6,   15,    0, 18,  0,  0 }, {      7,   14,    0, 18,  0,  0 }, {      8,   14,    0, 19,  0,  0 }, {      9,   13,    0, 19,  0,  0 },
    {     10,   12,    0, 20,  0,  0 }, {     11,   11,    0, 20,  0,  0 }, {     12,   10,    0, 20,  0,  0 }, {     13,    9,    0, 21,  0,  0 }, {     14,    8,    0, 21,  0,  0 },
    {     14,    7,    0, 22,  0,  0 }, {     15,    6,    0, 22,  0,  0 }, {     15,    5,    0, 22,  0,  0 }, {     15,    4,    0, 23,  0,  0 }, {     16,    3,    0, 23,  0,  0 },
    {     16,    2,    0, 24,  0,  0 }, {     16,    1,    0, 24,  0,  0 }, {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E3F66, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 25,  0,  0 }, {     15,   28,    0, 25,  0,  0 }, {     15,   27,    0, 26,  0,  0 },
    {     15,   26,    0, 26,  0,  0 }, {     14,   25,    0, 26,  0,  0 }, {     14,   24,    0, 27,  0,  0 }, {     13,   23,    0, 27,  0,  0 }, {     12,   22,    0, 28,  0,  0 },
    {     11,   21,    0, 28,  0,  0 }, {     10,   20,    0, 28,  0,  0 }, {      9,   19,    0, 29,  0,  0 }, {      8,   18,    0, 29,  0,  0 }, {      7,   18,    0, 30,  0,  0 },
    {      6,   17,    0, 30,  0,  0 }, {      5,   17,    0, 30,  0,  0 }, {      4,   17,    0, 31,  0,  0 }, {      3,   16,    0, 31,  0,  0 }, {      2,   16,    0,  0,  0,  0 },
    {      1,   16,    0,  0,  0,  0 }, {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9BFE, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  1 }, {     25,   16,    0,  0,  0,  1 }, {     24,   16,    0,  0,  0,  1 }, {     23,   16,    0,  0,  0,  1 }, {     22,   16,    0,  0,  0,  1 },
    {     21,   16,    0,  0,  0,  1 }, {     20,   16,    0,  0,  0,  1 }, {     19,   16,    0,  0,  0,  1 }, {     18,   16,    0,  0,  0,  1 }, {     17,   16,    0,  0,  0,  1 },
    {     16,   16,    0,  0,  0,  1 }, {     15,   16,    0,  0,  0,  1 }, {     14,   16,    0,  0,  0,  1 }, {     13,   16,    0,  0,  0,  2 }, {     12,   16,    0,  0,  0,  2 },
    {     11,   16,    0,  0,  0,  2 }, {     10,   16,    0,  0,  0,  2 }, {      9,   16,    0,  0,  0,  2 }, {      8,   16,    0,  0,  0,  2 }, {      7,   16,    0,  0,  0,  2 },
    {      6,   16,    0,  0,  0,  2 }, {      5,   16,    0,  0,  0,  2 }, {      4,   16,    0,  0,  0,  2 }, {      3,   16,    0,  0,  0,  2 }, {      2,   16,    0,  0,  0,  5 },
    {      1,   16,    0,  0,  0,  5 }, {      0,   16,    0,  0,  0,  5 }, {     -1,   16,    0,  0,  0,  5 }, {     -2,   16,    0,  0,  0,  5 }, {     -3,   16,    0,  0,  0,  5 },
    {     -4,   16,    0,  0,  0,  5 }, {     -5,   16,    0,  0,  0,  5 }, {     -6,   16,    0,  0,  0,  5 }, {     -7,   16,    0,  0,  0,  5 }, {     -8,   16,    0,  0,  0,  5 },
    {     -9,   16,    0,  0,  0,  5 }, {    -10,   16,    0,  0,  0,  5 }, {    -11,   16,    0,  0,  0,  6 }, {    -12,   16,    0,  0,  0,  6 }, {    -13,   16,    0,  0,  0,  6 },
    {    -14,   16,    0,  0,  0,  6 }, {    -15,   16,    0,  0,  0,  6 }, {    -16,   16,    0,  0,  0,  6 }, {    -17,   16,    0,  0,  0,  6 }, {    -18,   16,    0,  0,  0,  6 },
    {    -19,   16,    0,  0,  0,  6 }, {    -20,   16,    0,  0,  0,  6 }, {    -21,   16,    0,  0,  0,  6 }, {    -22,   16,    0,  0,  0,  7 }, {    -23,   16,    0,  0,  0,  7 },
    {    -24,   16,    0,  0,  0,  7 }, {    -25,   16,    0,  0,  0,  7 }, {    -26,   16,    0,  0,  0,  7 }, {    -27,   16,    0,  0,  0,  7 }, {    -28,   16,    0,  0,  0,  7 },
    {    -29,   16,    0,  0,  0,  7 }, {    -30,   16,    0,  0,  0,  7 }, {    -31,   16,    0,  0,  0,  7 }, {    -32,   16,    0,  0,  0,  7 }, {    -33,   16,    0,  0,  0,  7 },
    {    -34,   16,    0,  0,  0,  7 }, {    -35,   16,    0,  0,  0,  8 }, {    -36,   16,    0,  0,  0,  8 }, {    -37,   16,    0,  0,  0,  8 }, {    -38,   16,    0,  0,  0,  8 },
    {    -39,   16,    0,  0,  0,  8 }, {    -40,   16,    0,  0,  0,  8 }, {    -41,   16,    0,  0,  0,  8 }, {    -42,   16,    0,  0,  0,  8 }, {    -43,   16,    0,  0,  0,  8 },
    {    -44,   16,    0,  0,  0,  8 }, {    -45,   16,    0,  0,  0,  8 }, {    -46,   16,    0,  0,  0,  9 }, {    -47,   16,    0,  0,  0,  9 }, {    -48,   16,    0,  0,  0,  9 },
    {    -49,   16,    0,  0,  0,  9 }, {    -50,   16,    0,  0,  0,  9 }, {    -51,   16,    0,  0,  0,  9 }, {    -52,   16,    0,  0,  0,  9 }, {    -53,   16,    0,  0,  0,  9 },
    {    -54,   16,    0,  0,  0,  9 }, {    -55,   16,    0,  0,  0,  9 }, {    -56,   16,    0,  0,  0,  9 }, {    -57,   16,    0,  0,  0,  9 }, {    -58,   16,    0,  0,  0,  9 },
    {    -59,   16,    0, 16, 16,  0 }, {    -60,   16,    0, 16, 16,  0 }, {    -61,   16,    0, 16, 16,  0 }, {    -62,   16,    0, 16, 16,  0 }, {    -63,   16,    0, 16, 16,  0 },
    {    -64,   16,    0, 16, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8D9F60, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  1 }, {     16,    6,    0,  8,  0,  1 }, {     16,    7,    0,  8,  0,  1 }, {     16,    8,    0,  8,  0,  1 }, {     16,    9,    0,  8,  0,  1 },
    {     16,   10,    0,  8,  0,  1 }, {     16,   11,    0,  8,  0,  1 }, {     16,   12,    0,  8,  0,  1 }, {     16,   13,    0,  8,  0,  1 }, {     16,   14,    0,  8,  0,  1 },
    {     16,   15,    0,  8,  0,  1 }, {     16,   16,    0,  8,  0,  1 }, {     16,   17,    0,  8,  0,  1 }, {     16,   18,    0,  8,  0,  2 }, {     16,   19,    0,  8,  0,  2 },
    {     16,   20,    0,  8,  0,  2 }, {     16,   21,    0,  8,  0,  2 }, {     16,   22,    0,  8,  0,  2 }, {     16,   23,    0,  8,  0,  2 }, {     16,   24,    0,  8,  0,  2 },
    {     16,   25,    0,  8,  0,  2 }, {     16,   26,    0,  8,  0,  2 }, {     16,   27,    0,  8,  0,  2 }, {     16,   28,    0,  8,  0,  2 }, {     16,   29,    0,  8,  0,  5 },
    {     16,   30,    0,  8,  0,  5 }, {     16,   31,    0,  8,  0,  5 }, {     16,   32,    0,  8,  0,  5 }, {     16,   33,    0,  8,  0,  5 }, {     16,   34,    0,  8,  0,  5 },
    {     16,   35,    0,  8,  0,  5 }, {     16,   36,    0,  8,  0,  5 }, {     16,   37,    0,  8,  0,  5 }, {     16,   38,    0,  8,  0,  5 }, {     16,   39,    0,  8,  0,  5 },
    {     16,   40,    0,  8,  0,  5 }, {     16,   41,    0,  8,  0,  5 }, {     16,   42,    0,  8,  0,  6 }, {     16,   43,    0,  8,  0,  6 }, {     16,   44,    0,  8,  0,  6 },
    {     16,   45,    0,  8,  0,  6 }, {     16,   46,    0,  8,  0,  6 }, {     16,   47,    0,  8,  0,  6 }, {     16,   48,    0,  8,  0,  6 }, {     16,   49,    0,  8,  0,  6 },
    {     16,   50,    0,  8,  0,  6 }, {     16,   51,    0,  8,  0,  6 }, {     16,   52,    0,  8,  0,  6 }, {     16,   53,    0,  8,  0,  7 }, {     16,   54,    0,  8,  0,  7 },
    {     16,   55,    0,  8,  0,  7 }, {     16,   56,    0,  8,  0,  7 }, {     16,   57,    0,  8,  0,  7 }, {     16,   58,    0,  8,  0,  7 }, {     16,   59,    0,  8,  0,  7 },
    {     16,   60,    0,  8,  0,  7 }, {     16,   61,    0,  8,  0,  7 }, {     16,   62,    0,  8,  0,  7 }, {     16,   63,    0,  8,  0,  7 }, {     16,   64,    0,  8,  0,  7 },
    {     16,   65,    0,  8,  0,  7 }, {     16,   66,    0,  8,  0,  8 }, {     16,   67,    0,  8,  0,  8 }, {     16,   68,    0,  8,  0,  8 }, {     16,   69,    0,  8,  0,  8 },
    {     16,   70,    0,  8,  0,  8 }, {     16,   71,    0,  8,  0,  8 }, {     16,   72,    0,  8,  0,  8 }, {     16,   73,    0,  8,  0,  8 }, {     16,   74,    0,  8,  0,  8 },
    {     16,   75,    0,  8,  0,  8 }, {     16,   76,    0,  8,  0,  8 }, {     16,   77,    0,  8,  0,  9 }, {     16,   78,    0,  8,  0,  9 }, {     16,   79,    0,  8,  0,  9 },
    {     16,   80,    0,  8,  0,  9 }, {     16,   81,    0,  8,  0,  9 }, {     16,   82,    0,  8,  0,  9 }, {     16,   83,    0,  8,  0,  9 }, {     16,   84,    0,  8,  0,  9 },
    {     16,   85,    0,  8,  0,  9 }, {     16,   86,    0,  8,  0,  9 }, {     16,   87,    0,  8,  0,  9 }, {     16,   88,    0,  8,  0,  9 }, {     16,   89,    0,  8,  0,  9 },
    {     16,   90,    0, 24, 16,  0 }, {     16,   91,    0, 24, 16,  0 }, {     16,   92,    0, 24, 16,  0 }, {     16,   93,    0, 24, 16,  0 }, {     16,   94,    0, 24, 16,  0 },
    {     16,   95,    0, 24, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA2C2, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  1 }, {      6,   16,    0, 16,  0,  1 }, {      7,   16,    0, 16,  0,  1 }, {      8,   16,    0, 16,  0,  1 }, {      9,   16,    0, 16,  0,  1 },
    {     10,   16,    0, 16,  0,  1 }, {     11,   16,    0, 16,  0,  1 }, {     12,   16,    0, 16,  0,  1 }, {     13,   16,    0, 16,  0,  1 }, {     14,   16,    0, 16,  0,  1 },
    {     15,   16,    0, 16,  0,  1 }, {     16,   16,    0, 16,  0,  1 }, {     17,   16,    0, 16,  0,  1 }, {     18,   16,    0, 16,  0,  2 }, {     19,   16,    0, 16,  0,  2 },
    {     20,   16,    0, 16,  0,  2 }, {     21,   16,    0, 16,  0,  2 }, {     22,   16,    0, 16,  0,  2 }, {     23,   16,    0, 16,  0,  2 }, {     24,   16,    0, 16,  0,  2 },
    {     25,   16,    0, 16,  0,  2 }, {     26,   16,    0, 16,  0,  2 }, {     27,   16,    0, 16,  0,  2 }, {     28,   16,    0, 16,  0,  2 }, {     29,   16,    0, 16,  0,  5 },
    {     30,   16,    0, 16,  0,  5 }, {     31,   16,    0, 16,  0,  5 }, {     32,   16,    0, 16,  0,  5 }, {     33,   16,    0, 16,  0,  5 }, {     34,   16,    0, 16,  0,  5 },
    {     35,   16,    0, 16,  0,  5 }, {     36,   16,    0, 16,  0,  5 }, {     37,   16,    0, 16,  0,  5 }, {     38,   16,    0, 16,  0,  5 }, {     39,   16,    0, 16,  0,  5 },
    {     40,   16,    0, 16,  0,  5 }, {     41,   16,    0, 16,  0,  5 }, {     42,   16,    0, 16,  0,  6 }, {     43,   16,    0, 16,  0,  6 }, {     44,   16,    0, 16,  0,  6 },
    {     45,   16,    0, 16,  0,  6 }, {     46,   16,    0, 16,  0,  6 }, {     47,   16,    0, 16,  0,  6 }, {     48,   16,    0, 16,  0,  6 }, {     49,   16,    0, 16,  0,  6 },
    {     50,   16,    0, 16,  0,  6 }, {     51,   16,    0, 16,  0,  6 }, {     52,   16,    0, 16,  0,  6 }, {     53,   16,    0, 16,  0,  7 }, {     54,   16,    0, 16,  0,  7 },
    {     55,   16,    0, 16,  0,  7 }, {     56,   16,    0, 16,  0,  7 }, {     57,   16,    0, 16,  0,  7 }, {     58,   16,    0, 16,  0,  7 }, {     59,   16,    0, 16,  0,  7 },
    {     60,   16,    0, 16,  0,  7 }, {     61,   16,    0, 16,  0,  7 }, {     62,   16,    0, 16,  0,  7 }, {     63,   16,    0, 16,  0,  7 }, {     64,   16,    0, 16,  0,  7 },
    {     65,   16,    0, 16,  0,  7 }, {     66,   16,    0, 16,  0,  8 }, {     67,   16,    0, 16,  0,  8 }, {     68,   16,    0, 16,  0,  8 }, {     69,   16,    0, 16,  0,  8 },
    {     70,   16,    0, 16,  0,  8 }, {     71,   16,    0, 16,  0,  8 }, {     72,   16,    0, 16,  0,  8 }, {     73,   16,    0, 16,  0,  8 }, {     74,   16,    0, 16,  0,  8 },
    {     75,   16,    0, 16,  0,  8 }, {     76,   16,    0, 16,  0,  8 }, {     77,   16,    0, 16,  0,  9 }, {     78,   16,    0, 16,  0,  9 }, {     79,   16,    0, 16,  0,  9 },
    {     80,   16,    0, 16,  0,  9 }, {     81,   16,    0, 16,  0,  9 }, {     82,   16,    0, 16,  0,  9 }, {     83,   16,    0, 16,  0,  9 }, {     84,   16,    0, 16,  0,  9 },
    {     85,   16,    0, 16,  0,  9 }, {     86,   16,    0, 16,  0,  9 }, {     87,   16,    0, 16,  0,  9 }, {     88,   16,    0, 16,  0,  9 }, {     89,   16,    0, 16,  0,  9 },
    {     90,   16,    0,  0, 16,  0 }, {     91,   16,    0,  0, 16,  0 }, {     92,   16,    0,  0, 16,  0 }, {     93,   16,    0,  0, 16,  0 }, {     94,   16,    0,  0, 16,  0 },
    {     95,   16,    0,  0, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA624, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  1 }, {     16,   25,    0, 24,  0,  1 }, {     16,   24,    0, 24,  0,  1 }, {     16,   23,    0, 24,  0,  1 }, {     16,   22,    0, 24,  0,  1 },
    {     16,   21,    0, 24,  0,  1 }, {     16,   20,    0, 24,  0,  1 }, {     16,   19,    0, 24,  0,  1 }, {     16,   18,    0, 24,  0,  1 }, {     16,   17,    0, 24,  0,  1 },
    {     16,   16,    0, 24,  0,  1 }, {     16,   15,    0, 24,  0,  1 }, {     16,   14,    0, 24,  0,  1 }, {     16,   13,    0, 24,  0,  2 }, {     16,   12,    0, 24,  0,  2 },
    {     16,   11,    0, 24,  0,  2 }, {     16,   10,    0, 24,  0,  2 }, {     16,    9,    0, 24,  0,  2 }, {     16,    8,    0, 24,  0,  2 }, {     16,    7,    0, 24,  0,  2 },
    {     16,    6,    0, 24,  0,  2 }, {     16,    5,    0, 24,  0,  2 }, {     16,    4,    0, 24,  0,  2 }, {     16,    3,    0, 24,  0,  2 }, {     16,    2,    0, 24,  0,  5 },
    {     16,    1,    0, 24,  0,  5 }, {     16,    0,    0, 24,  0,  5 }, {     16,   -1,    0, 24,  0,  5 }, {     16,   -2,    0, 24,  0,  5 }, {     16,   -3,    0, 24,  0,  5 },
    {     16,   -4,    0, 24,  0,  5 }, {     16,   -5,    0, 24,  0,  5 }, {     16,   -6,    0, 24,  0,  5 }, {     16,   -7,    0, 24,  0,  5 }, {     16,   -8,    0, 24,  0,  5 },
    {     16,   -9,    0, 24,  0,  5 }, {     16,  -10,    0, 24,  0,  5 }, {     16,  -11,    0, 24,  0,  6 }, {     16,  -12,    0, 24,  0,  6 }, {     16,  -13,    0, 24,  0,  6 },
    {     16,  -14,    0, 24,  0,  6 }, {     16,  -15,    0, 24,  0,  6 }, {     16,  -16,    0, 24,  0,  6 }, {     16,  -17,    0, 24,  0,  6 }, {     16,  -18,    0, 24,  0,  6 },
    {     16,  -19,    0, 24,  0,  6 }, {     16,  -20,    0, 24,  0,  6 }, {     16,  -21,    0, 24,  0,  6 }, {     16,  -22,    0, 24,  0,  7 }, {     16,  -23,    0, 24,  0,  7 },
    {     16,  -24,    0, 24,  0,  7 }, {     16,  -25,    0, 24,  0,  7 }, {     16,  -26,    0, 24,  0,  7 }, {     16,  -27,    0, 24,  0,  7 }, {     16,  -28,    0, 24,  0,  7 },
    {     16,  -29,    0, 24,  0,  7 }, {     16,  -30,    0, 24,  0,  7 }, {     16,  -31,    0, 24,  0,  7 }, {     16,  -32,    0, 24,  0,  7 }, {     16,  -33,    0, 24,  0,  7 },
    {     16,  -34,    0, 24,  0,  7 }, {     16,  -35,    0, 24,  0,  8 }, {     16,  -36,    0, 24,  0,  8 }, {     16,  -37,    0, 24,  0,  8 }, {     16,  -38,    0, 24,  0,  8 },
    {     16,  -39,    0, 24,  0,  8 }, {     16,  -40,    0, 24,  0,  8 }, {     16,  -41,    0, 24,  0,  8 }, {     16,  -42,    0, 24,  0,  8 }, {     16,  -43,    0, 24,  0,  8 },
    {     16,  -44,    0, 24,  0,  8 }, {     16,  -45,    0, 24,  0,  8 }, {     16,  -46,    0, 24,  0,  9 }, {     16,  -47,    0, 24,  0,  9 }, {     16,  -48,    0, 24,  0,  9 },
    {     16,  -49,    0, 24,  0,  9 }, {     16,  -50,    0, 24,  0,  9 }, {     16,  -51,    0, 24,  0,  9 }, {     16,  -52,    0, 24,  0,  9 }, {     16,  -53,    0, 24,  0,  9 },
    {     16,  -54,    0, 24,  0,  9 }, {     16,  -55,    0, 24,  0,  9 }, {     16,  -56,    0, 24,  0,  9 }, {     16,  -57,    0, 24,  0,  9 }, {     16,  -58,    0, 24,  0,  9 },
    {     16,  -59,    0,  8, 16,  0 }, {     16,  -60,    0,  8, 16,  0 }, {     16,  -61,    0,  8, 16,  0 }, {     16,  -62,    0,  8, 16,  0 }, {     16,  -63,    0,  8, 16,  0 },
    {     16,  -64,    0,  8, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DA986, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  3 }, {     25,   16,    0,  0,  0,  3 }, {     24,   16,    0,  0,  0,  3 }, {     23,   16,    0,  0,  0,  3 }, {     22,   16,    0,  0,  0,  3 },
    {     21,   16,    0,  0,  0,  3 }, {     20,   16,    0,  0,  0,  3 }, {     19,   16,    0,  0,  0,  3 }, {     18,   16,    0,  0,  0,  3 }, {     17,   16,    0,  0,  0,  3 },
    {     16,   16,    0,  0,  0,  3 }, {     15,   16,    0,  0,  0,  3 }, {     14,   16,    0,  0,  0,  3 }, {     13,   16,    0,  0,  0,  4 }, {     12,   16,    0,  0,  0,  4 },
    {     11,   16,    0,  0,  0,  4 }, {     10,   16,    0,  0,  0,  4 }, {      9,   16,    0,  0,  0,  4 }, {      8,   16,    0,  0,  0,  4 }, {      7,   16,    0,  0,  0,  4 },
    {      6,   16,    0,  0,  0,  4 }, {      5,   16,    0,  0,  0,  4 }, {      4,   16,    0,  0,  0,  4 }, {      3,   16,    0,  0,  0,  4 }, {      2,   16,    0,  0,  0, 10 },
    {      1,   16,    0,  0,  0, 10 }, {      0,   16,    0,  0,  0, 10 }, {     -1,   16,    0,  0,  0, 10 }, {     -2,   16,    0,  0,  0, 10 }, {     -3,   16,    0,  0,  0, 10 },
    {     -4,   16,    0,  0,  0, 10 }, {     -5,   16,    0,  0,  0, 10 }, {     -6,   16,    0,  0,  0, 10 }, {     -7,   16,    0,  0,  0, 10 }, {     -8,   16,    0,  0,  0, 10 },
    {     -9,   16,    0,  0,  0, 10 }, {    -10,   16,    0,  0,  0, 10 }, {    -11,   16,    0,  0,  0, 11 }, {    -12,   16,    0,  0,  0, 11 }, {    -13,   16,    0,  0,  0, 11 },
    {    -14,   16,    0,  0,  0, 11 }, {    -15,   16,    0,  0,  0, 11 }, {    -16,   16,    0,  0,  0, 11 }, {    -17,   16,    0,  0,  0, 11 }, {    -18,   16,    0,  0,  0, 11 },
    {    -19,   16,    0,  0,  0, 11 }, {    -20,   16,    0,  0,  0, 11 }, {    -21,   16,    0,  0,  0, 11 }, {    -22,   16,    0,  0,  0, 12 }, {    -23,   16,    0,  0,  0, 12 },
    {    -24,   16,    0,  0,  0, 12 }, {    -25,   16,    0,  0,  0, 12 }, {    -26,   16,    0,  0,  0, 12 }, {    -27,   16,    0,  0,  0, 12 }, {    -28,   16,    0,  0,  0, 12 },
    {    -29,   16,    0,  0,  0, 12 }, {    -30,   16,    0,  0,  0, 12 }, {    -31,   16,    0,  0,  0, 12 }, {    -32,   16,    0,  0,  0, 12 }, {    -33,   16,    0,  0,  0, 12 },
    {    -34,   16,    0,  0,  0, 12 }, {    -35,   16,    0,  0,  0, 13 }, {    -36,   16,    0,  0,  0, 13 }, {    -37,   16,    0,  0,  0, 13 }, {    -38,   16,    0,  0,  0, 13 },
    {    -39,   16,    0,  0,  0, 13 }, {    -40,   16,    0,  0,  0, 13 }, {    -41,   16,    0,  0,  0, 13 }, {    -42,   16,    0,  0,  0, 13 }, {    -43,   16,    0,  0,  0, 13 },
    {    -44,   16,    0,  0,  0, 13 }, {    -45,   16,    0,  0,  0, 13 }, {    -46,   16,    0,  0,  0, 14 }, {    -47,   16,    0,  0,  0, 14 }, {    -48,   16,    0,  0,  0, 14 },
    {    -49,   16,    0,  0,  0, 14 }, {    -50,   16,    0,  0,  0, 14 }, {    -51,   16,    0,  0,  0, 14 }, {    -52,   16,    0,  0,  0, 14 }, {    -53,   16,    0,  0,  0, 14 },
    {    -54,   16,    0,  0,  0, 14 }, {    -55,   16,    0,  0,  0, 14 }, {    -56,   16,    0,  0,  0, 14 }, {    -57,   16,    0,  0,  0, 14 }, {    -58,   16,    0,  0,  0, 14 },
    {    -59,   16,    0, 16, 16,  0 }, {    -60,   16,    0, 16, 16,  0 }, {    -61,   16,    0, 16, 16,  0 }, {    -62,   16,    0, 16, 16,  0 }, {    -63,   16,    0, 16, 16,  0 },
    {    -64,   16,    0, 16, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DACE8, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  3 }, {     16,    6,    0,  8,  0,  3 }, {     16,    7,    0,  8,  0,  3 }, {     16,    8,    0,  8,  0,  3 }, {     16,    9,    0,  8,  0,  3 },
    {     16,   10,    0,  8,  0,  3 }, {     16,   11,    0,  8,  0,  3 }, {     16,   12,    0,  8,  0,  3 }, {     16,   13,    0,  8,  0,  3 }, {     16,   14,    0,  8,  0,  3 },
    {     16,   15,    0,  8,  0,  3 }, {     16,   16,    0,  8,  0,  3 }, {     16,   17,    0,  8,  0,  3 }, {     16,   18,    0,  8,  0,  4 }, {     16,   19,    0,  8,  0,  4 },
    {     16,   20,    0,  8,  0,  4 }, {     16,   21,    0,  8,  0,  4 }, {     16,   22,    0,  8,  0,  4 }, {     16,   23,    0,  8,  0,  4 }, {     16,   24,    0,  8,  0,  4 },
    {     16,   25,    0,  8,  0,  4 }, {     16,   26,    0,  8,  0,  4 }, {     16,   27,    0,  8,  0,  4 }, {     16,   28,    0,  8,  0,  4 }, {     16,   29,    0,  8,  0, 10 },
    {     16,   30,    0,  8,  0, 10 }, {     16,   31,    0,  8,  0, 10 }, {     16,   32,    0,  8,  0, 10 }, {     16,   33,    0,  8,  0, 10 }, {     16,   34,    0,  8,  0, 10 },
    {     16,   35,    0,  8,  0, 10 }, {     16,   36,    0,  8,  0, 10 }, {     16,   37,    0,  8,  0, 10 }, {     16,   38,    0,  8,  0, 10 }, {     16,   39,    0,  8,  0, 10 },
    {     16,   40,    0,  8,  0, 10 }, {     16,   41,    0,  8,  0, 10 }, {     16,   42,    0,  8,  0, 11 }, {     16,   43,    0,  8,  0, 11 }, {     16,   44,    0,  8,  0, 11 },
    {     16,   45,    0,  8,  0, 11 }, {     16,   46,    0,  8,  0, 11 }, {     16,   47,    0,  8,  0, 11 }, {     16,   48,    0,  8,  0, 11 }, {     16,   49,    0,  8,  0, 11 },
    {     16,   50,    0,  8,  0, 11 }, {     16,   51,    0,  8,  0, 11 }, {     16,   52,    0,  8,  0, 11 }, {     16,   53,    0,  8,  0, 12 }, {     16,   54,    0,  8,  0, 12 },
    {     16,   55,    0,  8,  0, 12 }, {     16,   56,    0,  8,  0, 12 }, {     16,   57,    0,  8,  0, 12 }, {     16,   58,    0,  8,  0, 12 }, {     16,   59,    0,  8,  0, 12 },
    {     16,   60,    0,  8,  0, 12 }, {     16,   61,    0,  8,  0, 12 }, {     16,   62,    0,  8,  0, 12 }, {     16,   63,    0,  8,  0, 12 }, {     16,   64,    0,  8,  0, 12 },
    {     16,   65,    0,  8,  0, 12 }, {     16,   66,    0,  8,  0, 13 }, {     16,   67,    0,  8,  0, 13 }, {     16,   68,    0,  8,  0, 13 }, {     16,   69,    0,  8,  0, 13 },
    {     16,   70,    0,  8,  0, 13 }, {     16,   71,    0,  8,  0, 13 }, {     16,   72,    0,  8,  0, 13 }, {     16,   73,    0,  8,  0, 13 }, {     16,   74,    0,  8,  0, 13 },
    {     16,   75,    0,  8,  0, 13 }, {     16,   76,    0,  8,  0, 13 }, {     16,   77,    0,  8,  0, 14 }, {     16,   78,    0,  8,  0, 14 }, {     16,   79,    0,  8,  0, 14 },
    {     16,   80,    0,  8,  0, 14 }, {     16,   81,    0,  8,  0, 14 }, {     16,   82,    0,  8,  0, 14 }, {     16,   83,    0,  8,  0, 14 }, {     16,   84,    0,  8,  0, 14 },
    {     16,   85,    0,  8,  0, 14 }, {     16,   86,    0,  8,  0, 14 }, {     16,   87,    0,  8,  0, 14 }, {     16,   88,    0,  8,  0, 14 }, {     16,   89,    0,  8,  0, 14 },
    {     16,   90,    0, 24, 16,  0 }, {     16,   91,    0, 24, 16,  0 }, {     16,   92,    0, 24, 16,  0 }, {     16,   93,    0, 24, 16,  0 }, {     16,   94,    0, 24, 16,  0 },
    {     16,   95,    0, 24, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB04A, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  3 }, {      6,   16,    0, 16,  0,  3 }, {      7,   16,    0, 16,  0,  3 }, {      8,   16,    0, 16,  0,  3 }, {      9,   16,    0, 16,  0,  3 },
    {     10,   16,    0, 16,  0,  3 }, {     11,   16,    0, 16,  0,  3 }, {     12,   16,    0, 16,  0,  3 }, {     13,   16,    0, 16,  0,  3 }, {     14,   16,    0, 16,  0,  3 },
    {     15,   16,    0, 16,  0,  3 }, {     16,   16,    0, 16,  0,  3 }, {     17,   16,    0, 16,  0,  3 }, {     18,   16,    0, 16,  0,  4 }, {     19,   16,    0, 16,  0,  4 },
    {     20,   16,    0, 16,  0,  4 }, {     21,   16,    0, 16,  0,  4 }, {     22,   16,    0, 16,  0,  4 }, {     23,   16,    0, 16,  0,  4 }, {     24,   16,    0, 16,  0,  4 },
    {     25,   16,    0, 16,  0,  4 }, {     26,   16,    0, 16,  0,  4 }, {     27,   16,    0, 16,  0,  4 }, {     28,   16,    0, 16,  0,  4 }, {     29,   16,    0, 16,  0, 10 },
    {     30,   16,    0, 16,  0, 10 }, {     31,   16,    0, 16,  0, 10 }, {     32,   16,    0, 16,  0, 10 }, {     33,   16,    0, 16,  0, 10 }, {     34,   16,    0, 16,  0, 10 },
    {     35,   16,    0, 16,  0, 10 }, {     36,   16,    0, 16,  0, 10 }, {     37,   16,    0, 16,  0, 10 }, {     38,   16,    0, 16,  0, 10 }, {     39,   16,    0, 16,  0, 10 },
    {     40,   16,    0, 16,  0, 10 }, {     41,   16,    0, 16,  0, 10 }, {     42,   16,    0, 16,  0, 11 }, {     43,   16,    0, 16,  0, 11 }, {     44,   16,    0, 16,  0, 11 },
    {     45,   16,    0, 16,  0, 11 }, {     46,   16,    0, 16,  0, 11 }, {     47,   16,    0, 16,  0, 11 }, {     48,   16,    0, 16,  0, 11 }, {     49,   16,    0, 16,  0, 11 },
    {     50,   16,    0, 16,  0, 11 }, {     51,   16,    0, 16,  0, 11 }, {     52,   16,    0, 16,  0, 11 }, {     53,   16,    0, 16,  0, 12 }, {     54,   16,    0, 16,  0, 12 },
    {     55,   16,    0, 16,  0, 12 }, {     56,   16,    0, 16,  0, 12 }, {     57,   16,    0, 16,  0, 12 }, {     58,   16,    0, 16,  0, 12 }, {     59,   16,    0, 16,  0, 12 },
    {     60,   16,    0, 16,  0, 12 }, {     61,   16,    0, 16,  0, 12 }, {     62,   16,    0, 16,  0, 12 }, {     63,   16,    0, 16,  0, 12 }, {     64,   16,    0, 16,  0, 12 },
    {     65,   16,    0, 16,  0, 12 }, {     66,   16,    0, 16,  0, 13 }, {     67,   16,    0, 16,  0, 13 }, {     68,   16,    0, 16,  0, 13 }, {     69,   16,    0, 16,  0, 13 },
    {     70,   16,    0, 16,  0, 13 }, {     71,   16,    0, 16,  0, 13 }, {     72,   16,    0, 16,  0, 13 }, {     73,   16,    0, 16,  0, 13 }, {     74,   16,    0, 16,  0, 13 },
    {     75,   16,    0, 16,  0, 13 }, {     76,   16,    0, 16,  0, 13 }, {     77,   16,    0, 16,  0, 14 }, {     78,   16,    0, 16,  0, 14 }, {     79,   16,    0, 16,  0, 14 },
    {     80,   16,    0, 16,  0, 14 }, {     81,   16,    0, 16,  0, 14 }, {     82,   16,    0, 16,  0, 14 }, {     83,   16,    0, 16,  0, 14 }, {     84,   16,    0, 16,  0, 14 },
    {     85,   16,    0, 16,  0, 14 }, {     86,   16,    0, 16,  0, 14 }, {     87,   16,    0, 16,  0, 14 }, {     88,   16,    0, 16,  0, 14 }, {     89,   16,    0, 16,  0, 14 },
    {     90,   16,    0,  0, 16,  0 }, {     91,   16,    0,  0, 16,  0 }, {     92,   16,    0,  0, 16,  0 }, {     93,   16,    0,  0, 16,  0 }, {     94,   16,    0,  0, 16,  0 },
    {     95,   16,    0,  0, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB3AC, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  3 }, {     16,   25,    0, 24,  0,  3 }, {     16,   24,    0, 24,  0,  3 }, {     16,   23,    0, 24,  0,  3 }, {     16,   22,    0, 24,  0,  3 },
    {     16,   21,    0, 24,  0,  3 }, {     16,   20,    0, 24,  0,  3 }, {     16,   19,    0, 24,  0,  3 }, {     16,   18,    0, 24,  0,  3 }, {     16,   17,    0, 24,  0,  3 },
    {     16,   16,    0, 24,  0,  3 }, {     16,   15,    0, 24,  0,  3 }, {     16,   14,    0, 24,  0,  3 }, {     16,   13,    0, 24,  0,  4 }, {     16,   12,    0, 24,  0,  4 },
    {     16,   11,    0, 24,  0,  4 }, {     16,   10,    0, 24,  0,  4 }, {     16,    9,    0, 24,  0,  4 }, {     16,    8,    0, 24,  0,  4 }, {     16,    7,    0, 24,  0,  4 },
    {     16,    6,    0, 24,  0,  4 }, {     16,    5,    0, 24,  0,  4 }, {     16,    4,    0, 24,  0,  4 }, {     16,    3,    0, 24,  0,  4 }, {     16,    2,    0, 24,  0, 10 },
    {     16,    1,    0, 24,  0, 10 }, {     16,    0,    0, 24,  0, 10 }, {     16,   -1,    0, 24,  0, 10 }, {     16,   -2,    0, 24,  0, 10 }, {     16,   -3,    0, 24,  0, 10 },
    {     16,   -4,    0, 24,  0, 10 }, {     16,   -5,    0, 24,  0, 10 }, {     16,   -6,    0, 24,  0, 10 }, {     16,   -7,    0, 24,  0, 10 }, {     16,   -8,    0, 24,  0, 10 },
    {     16,   -9,    0, 24,  0, 10 }, {     16,  -10,    0, 24,  0, 10 }, {     16,  -11,    0, 24,  0, 11 }, {     16,  -12,    0, 24,  0, 11 }, {     16,  -13,    0, 24,  0, 11 },
    {     16,  -14,    0, 24,  0, 11 }, {     16,  -15,    0, 24,  0, 11 }, {     16,  -16,    0, 24,  0, 11 }, {     16,  -17,    0, 24,  0, 11 }, {     16,  -18,    0, 24,  0, 11 },
    {     16,  -19,    0, 24,  0, 11 }, {     16,  -20,    0, 24,  0, 11 }, {     16,  -21,    0, 24,  0, 11 }, {     16,  -22,    0, 24,  0, 12 }, {     16,  -23,    0, 24,  0, 12 },
    {     16,  -24,    0, 24,  0, 12 }, {     16,  -25,    0, 24,  0, 12 }, {     16,  -26,    0, 24,  0, 12 }, {     16,  -27,    0, 24,  0, 12 }, {     16,  -28,    0, 24,  0, 12 },
    {     16,  -29,    0, 24,  0, 12 }, {     16,  -30,    0, 24,  0, 12 }, {     16,  -31,    0, 24,  0, 12 }, {     16,  -32,    0, 24,  0, 12 }, {     16,  -33,    0, 24,  0, 12 },
    {     16,  -34,    0, 24,  0, 12 }, {     16,  -35,    0, 24,  0, 13 }, {     16,  -36,    0, 24,  0, 13 }, {     16,  -37,    0, 24,  0, 13 }, {     16,  -38,    0, 24,  0, 13 },
    {     16,  -39,    0, 24,  0, 13 }, {     16,  -40,    0, 24,  0, 13 }, {     16,  -41,    0, 24,  0, 13 }, {     16,  -42,    0, 24,  0, 13 }, {     16,  -43,    0, 24,  0, 13 },
    {     16,  -44,    0, 24,  0, 13 }, {     16,  -45,    0, 24,  0, 13 }, {     16,  -46,    0, 24,  0, 14 }, {     16,  -47,    0, 24,  0, 14 }, {     16,  -48,    0, 24,  0, 14 },
    {     16,  -49,    0, 24,  0, 14 }, {     16,  -50,    0, 24,  0, 14 }, {     16,  -51,    0, 24,  0, 14 }, {     16,  -52,    0, 24,  0, 14 }, {     16,  -53,    0, 24,  0, 14 },
    {     16,  -54,    0, 24,  0, 14 }, {     16,  -55,    0, 24,  0, 14 }, {     16,  -56,    0, 24,  0, 14 }, {     16,  -57,    0, 24,  0, 14 }, {     16,  -58,    0, 24,  0, 14 },
    {     16,  -59,    0,  8, 16,  0 }, {     16,  -60,    0,  8, 16,  0 }, {     16,  -61,    0,  8, 16,  0 }, {     16,  -62,    0,  8, 16,  0 }, {     16,  -63,    0,  8, 16,  0 },
    {     16,  -64,    0,  8, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DB70E, {
    {     31,   16,  -16, 16, 16,  0 }, {     30,   16,  -16, 16, 16,  0 }, {     29,   16,  -16, 16, 16,  0 }, {     28,   16,  -16, 16, 16,  0 }, {     27,   16,  -16, 16, 16,  0 },
    {     26,   16,  -16,  0,  0, 14 }, {     25,   16,  -16,  0,  0, 14 }, {     24,   16,  -16,  0,  0, 14 }, {     23,   16,  -16,  0,  0, 14 }, {     22,   16,  -16,  0,  0, 14 },
    {     21,   16,  -16,  0,  0, 14 }, {     20,   16,  -16,  0,  0, 14 }, {     19,   16,  -16,  0,  0, 14 }, {     18,   16,  -16,  0,  0, 14 }, {     17,   16,  -16,  0,  0, 14 },
    {     16,   16,  -16,  0,  0, 14 }, {     15,   16,  -16,  0,  0, 14 }, {     14,   16,  -16,  0,  0, 14 }, {     13,   16,  -16,  0,  0, 13 }, {     12,   16,  -16,  0,  0, 13 },
    {     11,   16,  -16,  0,  0, 13 }, {     10,   16,  -16,  0,  0, 13 }, {      9,   16,  -16,  0,  0, 13 }, {      8,   16,  -16,  0,  0, 13 }, {      7,   16,  -16,  0,  0, 13 },
    {      6,   16,  -16,  0,  0, 13 }, {      5,   16,  -16,  0,  0, 13 }, {      4,   16,  -16,  0,  0, 13 }, {      3,   16,  -16,  0,  0, 13 }, {      2,   16,  -16,  0,  0, 12 },
    {      1,   16,  -16,  0,  0, 12 }, {      0,   16,  -16,  0,  0, 12 }, {     -1,   16,  -16,  0,  0, 12 }, {     -2,   16,  -16,  0,  0, 12 }, {     -3,   16,  -16,  0,  0, 12 },
    {     -4,   16,  -16,  0,  0, 12 }, {     -5,   16,  -16,  0,  0, 12 }, {     -6,   16,  -16,  0,  0, 12 }, {     -7,   16,  -16,  0,  0, 12 }, {     -8,   16,  -16,  0,  0, 12 },
    {     -9,   16,  -16,  0,  0, 12 }, {    -10,   16,  -16,  0,  0, 12 }, {    -11,   16,  -16,  0,  0, 11 }, {    -12,   16,  -16,  0,  0, 11 }, {    -13,   16,  -16,  0,  0, 11 },
    {    -14,   16,  -16,  0,  0, 11 }, {    -15,   16,  -16,  0,  0, 11 }, {    -16,   16,  -16,  0,  0, 11 }, {    -17,   16,  -16,  0,  0, 11 }, {    -18,   16,  -16,  0,  0, 11 },
    {    -19,   16,  -16,  0,  0, 11 }, {    -20,   16,  -16,  0,  0, 11 }, {    -21,   16,  -16,  0,  0, 11 }, {    -22,   16,  -16,  0,  0, 10 }, {    -23,   16,  -16,  0,  0, 10 },
    {    -24,   16,  -16,  0,  0, 10 }, {    -25,   16,  -16,  0,  0, 10 }, {    -26,   16,  -16,  0,  0, 10 }, {    -27,   16,  -16,  0,  0, 10 }, {    -28,   16,  -16,  0,  0, 10 },
    {    -29,   16,  -16,  0,  0, 10 }, {    -30,   16,  -16,  0,  0, 10 }, {    -31,   16,  -16,  0,  0, 10 }, {    -32,   16,  -16,  0,  0, 10 }, {    -33,   16,  -16,  0,  0, 10 },
    {    -34,   16,  -16,  0,  0, 10 }, {    -35,   16,  -16,  0,  0,  4 }, {    -36,   16,  -16,  0,  0,  4 }, {    -37,   16,  -16,  0,  0,  4 }, {    -38,   16,  -16,  0,  0,  4 },
    {    -39,   16,  -16,  0,  0,  4 }, {    -40,   16,  -16,  0,  0,  4 }, {    -41,   16,  -16,  0,  0,  4 }, {    -42,   16,  -16,  0,  0,  4 }, {    -43,   16,  -16,  0,  0,  4 },
    {    -44,   16,  -16,  0,  0,  4 }, {    -45,   16,  -16,  0,  0,  4 }, {    -46,   16,  -16,  0,  0,  3 }, {    -47,   16,  -16,  0,  0,  3 }, {    -48,   16,  -16,  0,  0,  3 },
    {    -49,   16,  -16,  0,  0,  3 }, {    -50,   16,  -16,  0,  0,  3 }, {    -51,   16,  -16,  0,  0,  3 }, {    -52,   16,  -16,  0,  0,  3 }, {    -53,   16,  -16,  0,  0,  3 },
    {    -54,   16,  -16,  0,  0,  3 }, {    -55,   16,  -16,  0,  0,  3 }, {    -56,   16,  -16,  0,  0,  3 }, {    -57,   16,  -16,  0,  0,  3 }, {    -58,   16,  -16,  0,  0,  3 },
    {    -59,   16,  -16,  0,  0,  0 }, {    -60,   16,  -16,  0,  0,  0 }, {    -61,   16,  -16,  0,  0,  0 }, {    -62,   16,  -16,  0,  0,  0 }, {    -63,   16,  -16,  0,  0,  0 },
    {    -64,   16,  -16,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DBA70, {
    {     16,    0,  -16, 24, 16,  0 }, {     16,    1,  -16, 24, 16,  0 }, {     16,    2,  -16, 24, 16,  0 }, {     16,    3,  -16, 24, 16,  0 }, {     16,    4,  -16, 24, 16,  0 },
    {     16,    5,  -16,  8,  0, 14 }, {     16,    6,  -16,  8,  0, 14 }, {     16,    7,  -16,  8,  0, 14 }, {     16,    8,  -16,  8,  0, 14 }, {     16,    9,  -16,  8,  0, 14 },
    {     16,   10,  -16,  8,  0, 14 }, {     16,   11,  -16,  8,  0, 14 }, {     16,   12,  -16,  8,  0, 14 }, {     16,   13,  -16,  8,  0, 14 }, {     16,   14,  -16,  8,  0, 14 },
    {     16,   15,  -16,  8,  0, 14 }, {     16,   16,  -16,  8,  0, 14 }, {     16,   17,  -16,  8,  0, 14 }, {     16,   18,  -16,  8,  0, 13 }, {     16,   19,  -16,  8,  0, 13 },
    {     16,   20,  -16,  8,  0, 13 }, {     16,   21,  -16,  8,  0, 13 }, {     16,   22,  -16,  8,  0, 13 }, {     16,   23,  -16,  8,  0, 13 }, {     16,   24,  -16,  8,  0, 13 },
    {     16,   25,  -16,  8,  0, 13 }, {     16,   26,  -16,  8,  0, 13 }, {     16,   27,  -16,  8,  0, 13 }, {     16,   28,  -16,  8,  0, 13 }, {     16,   29,  -16,  8,  0, 12 },
    {     16,   30,  -16,  8,  0, 12 }, {     16,   31,  -16,  8,  0, 12 }, {     16,   32,  -16,  8,  0, 12 }, {     16,   33,  -16,  8,  0, 12 }, {     16,   34,  -16,  8,  0, 12 },
    {     16,   35,  -16,  8,  0, 12 }, {     16,   36,  -16,  8,  0, 12 }, {     16,   37,  -16,  8,  0, 12 }, {     16,   38,  -16,  8,  0, 12 }, {     16,   39,  -16,  8,  0, 12 },
    {     16,   40,  -16,  8,  0, 12 }, {     16,   41,  -16,  8,  0, 12 }, {     16,   42,  -16,  8,  0, 11 }, {     16,   43,  -16,  8,  0, 11 }, {     16,   44,  -16,  8,  0, 11 },
    {     16,   45,  -16,  8,  0, 11 }, {     16,   46,  -16,  8,  0, 11 }, {     16,   47,  -16,  8,  0, 11 }, {     16,   48,  -16,  8,  0, 11 }, {     16,   49,  -16,  8,  0, 11 },
    {     16,   50,  -16,  8,  0, 11 }, {     16,   51,  -16,  8,  0, 11 }, {     16,   52,  -16,  8,  0, 11 }, {     16,   53,  -16,  8,  0, 10 }, {     16,   54,  -16,  8,  0, 10 },
    {     16,   55,  -16,  8,  0, 10 }, {     16,   56,  -16,  8,  0, 10 }, {     16,   57,  -16,  8,  0, 10 }, {     16,   58,  -16,  8,  0, 10 }, {     16,   59,  -16,  8,  0, 10 },
    {     16,   60,  -16,  8,  0, 10 }, {     16,   61,  -16,  8,  0, 10 }, {     16,   62,  -16,  8,  0, 10 }, {     16,   63,  -16,  8,  0, 10 }, {     16,   64,  -16,  8,  0, 10 },
    {     16,   65,  -16,  8,  0, 10 }, {     16,   66,  -16,  8,  0,  4 }, {     16,   67,  -16,  8,  0,  4 }, {     16,   68,  -16,  8,  0,  4 }, {     16,   69,  -16,  8,  0,  4 },
    {     16,   70,  -16,  8,  0,  4 }, {     16,   71,  -16,  8,  0,  4 }, {     16,   72,  -16,  8,  0,  4 }, {     16,   73,  -16,  8,  0,  4 }, {     16,   74,  -16,  8,  0,  4 },
    {     16,   75,  -16,  8,  0,  4 }, {     16,   76,  -16,  8,  0,  4 }, {     16,   77,  -16,  8,  0,  3 }, {     16,   78,  -16,  8,  0,  3 }, {     16,   79,  -16,  8,  0,  3 },
    {     16,   80,  -16,  8,  0,  3 }, {     16,   81,  -16,  8,  0,  3 }, {     16,   82,  -16,  8,  0,  3 }, {     16,   83,  -16,  8,  0,  3 }, {     16,   84,  -16,  8,  0,  3 },
    {     16,   85,  -16,  8,  0,  3 }, {     16,   86,  -16,  8,  0,  3 }, {     16,   87,  -16,  8,  0,  3 }, {     16,   88,  -16,  8,  0,  3 }, {     16,   89,  -16,  8,  0,  3 },
    {     16,   90,  -16,  8,  0,  0 }, {     16,   91,  -16,  8,  0,  0 }, {     16,   92,  -16,  8,  0,  0 }, {     16,   93,  -16,  8,  0,  0 }, {     16,   94,  -16,  8,  0,  0 },
    {     16,   95,  -16,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DBDD2, {
    {      0,   16,  -16,  0, 16,  0 }, {      1,   16,  -16,  0, 16,  0 }, {      2,   16,  -16,  0, 16,  0 }, {      3,   16,  -16,  0, 16,  0 }, {      4,   16,  -16,  0, 16,  0 },
    {      5,   16,  -16, 16,  0, 14 }, {      6,   16,  -16, 16,  0, 14 }, {      7,   16,  -16, 16,  0, 14 }, {      8,   16,  -16, 16,  0, 14 }, {      9,   16,  -16, 16,  0, 14 },
    {     10,   16,  -16, 16,  0, 14 }, {     11,   16,  -16, 16,  0, 14 }, {     12,   16,  -16, 16,  0, 14 }, {     13,   16,  -16, 16,  0, 14 }, {     14,   16,  -16, 16,  0, 14 },
    {     15,   16,  -16, 16,  0, 14 }, {     16,   16,  -16, 16,  0, 14 }, {     17,   16,  -16, 16,  0, 14 }, {     18,   16,  -16, 16,  0, 13 }, {     19,   16,  -16, 16,  0, 13 },
    {     20,   16,  -16, 16,  0, 13 }, {     21,   16,  -16, 16,  0, 13 }, {     22,   16,  -16, 16,  0, 13 }, {     23,   16,  -16, 16,  0, 13 }, {     24,   16,  -16, 16,  0, 13 },
    {     25,   16,  -16, 16,  0, 13 }, {     26,   16,  -16, 16,  0, 13 }, {     27,   16,  -16, 16,  0, 13 }, {     28,   16,  -16, 16,  0, 13 }, {     29,   16,  -16, 16,  0, 12 },
    {     30,   16,  -16, 16,  0, 12 }, {     31,   16,  -16, 16,  0, 12 }, {     32,   16,  -16, 16,  0, 12 }, {     33,   16,  -16, 16,  0, 12 }, {     34,   16,  -16, 16,  0, 12 },
    {     35,   16,  -16, 16,  0, 12 }, {     36,   16,  -16, 16,  0, 12 }, {     37,   16,  -16, 16,  0, 12 }, {     38,   16,  -16, 16,  0, 12 }, {     39,   16,  -16, 16,  0, 12 },
    {     40,   16,  -16, 16,  0, 12 }, {     41,   16,  -16, 16,  0, 12 }, {     42,   16,  -16, 16,  0, 11 }, {     43,   16,  -16, 16,  0, 11 }, {     44,   16,  -16, 16,  0, 11 },
    {     45,   16,  -16, 16,  0, 11 }, {     46,   16,  -16, 16,  0, 11 }, {     47,   16,  -16, 16,  0, 11 }, {     48,   16,  -16, 16,  0, 11 }, {     49,   16,  -16, 16,  0, 11 },
    {     50,   16,  -16, 16,  0, 11 }, {     51,   16,  -16, 16,  0, 11 }, {     52,   16,  -16, 16,  0, 11 }, {     53,   16,  -16, 16,  0, 10 }, {     54,   16,  -16, 16,  0, 10 },
    {     55,   16,  -16, 16,  0, 10 }, {     56,   16,  -16, 16,  0, 10 }, {     57,   16,  -16, 16,  0, 10 }, {     58,   16,  -16, 16,  0, 10 }, {     59,   16,  -16, 16,  0, 10 },
    {     60,   16,  -16, 16,  0, 10 }, {     61,   16,  -16, 16,  0, 10 }, {     62,   16,  -16, 16,  0, 10 }, {     63,   16,  -16, 16,  0, 10 }, {     64,   16,  -16, 16,  0, 10 },
    {     65,   16,  -16, 16,  0, 10 }, {     66,   16,  -16, 16,  0,  4 }, {     67,   16,  -16, 16,  0,  4 }, {     68,   16,  -16, 16,  0,  4 }, {     69,   16,  -16, 16,  0,  4 },
    {     70,   16,  -16, 16,  0,  4 }, {     71,   16,  -16, 16,  0,  4 }, {     72,   16,  -16, 16,  0,  4 }, {     73,   16,  -16, 16,  0,  4 }, {     74,   16,  -16, 16,  0,  4 },
    {     75,   16,  -16, 16,  0,  4 }, {     76,   16,  -16, 16,  0,  4 }, {     77,   16,  -16, 16,  0,  3 }, {     78,   16,  -16, 16,  0,  3 }, {     79,   16,  -16, 16,  0,  3 },
    {     80,   16,  -16, 16,  0,  3 }, {     81,   16,  -16, 16,  0,  3 }, {     82,   16,  -16, 16,  0,  3 }, {     83,   16,  -16, 16,  0,  3 }, {     84,   16,  -16, 16,  0,  3 },
    {     85,   16,  -16, 16,  0,  3 }, {     86,   16,  -16, 16,  0,  3 }, {     87,   16,  -16, 16,  0,  3 }, {     88,   16,  -16, 16,  0,  3 }, {     89,   16,  -16, 16,  0,  3 },
    {     90,   16,  -16, 16,  0,  0 }, {     91,   16,  -16, 16,  0,  0 }, {     92,   16,  -16, 16,  0,  0 }, {     93,   16,  -16, 16,  0,  0 }, {     94,   16,  -16, 16,  0,  0 },
    {     95,   16,  -16, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC134, {
    {     16,   31,  -16,  8, 16,  0 }, {     16,   30,  -16,  8, 16,  0 }, {     16,   29,  -16,  8, 16,  0 }, {     16,   28,  -16,  8, 16,  0 }, {     16,   27,  -16,  8, 16,  0 },
    {     16,   26,  -16, 24,  0, 14 }, {     16,   25,  -16, 24,  0, 14 }, {     16,   24,  -16, 24,  0, 14 }, {     16,   23,  -16, 24,  0, 14 }, {     16,   22,  -16, 24,  0, 14 },
    {     16,   21,  -16, 24,  0, 14 }, {     16,   20,  -16, 24,  0, 14 }, {     16,   19,  -16, 24,  0, 14 }, {     16,   18,  -16, 24,  0, 14 }, {     16,   17,  -16, 24,  0, 14 },
    {     16,   16,  -16, 24,  0, 14 }, {     16,   15,  -16, 24,  0, 14 }, {     16,   14,  -16, 24,  0, 14 }, {     16,   13,  -16, 24,  0, 13 }, {     16,   12,  -16, 24,  0, 13 },
    {     16,   11,  -16, 24,  0, 13 }, {     16,   10,  -16, 24,  0, 13 }, {     16,    9,  -16, 24,  0, 13 }, {     16,    8,  -16, 24,  0, 13 }, {     16,    7,  -16, 24,  0, 13 },
    {     16,    6,  -16, 24,  0, 13 }, {     16,    5,  -16, 24,  0, 13 }, {     16,    4,  -16, 24,  0, 13 }, {     16,    3,  -16, 24,  0, 13 }, {     16,    2,  -16, 24,  0, 12 },
    {     16,    1,  -16, 24,  0, 12 }, {     16,    0,  -16, 24,  0, 12 }, {     16,   -1,  -16, 24,  0, 12 }, {     16,   -2,  -16, 24,  0, 12 }, {     16,   -3,  -16, 24,  0, 12 },
    {     16,   -4,  -16, 24,  0, 12 }, {     16,   -5,  -16, 24,  0, 12 }, {     16,   -6,  -16, 24,  0, 12 }, {     16,   -7,  -16, 24,  0, 12 }, {     16,   -8,  -16, 24,  0, 12 },
    {     16,   -9,  -16, 24,  0, 12 }, {     16,  -10,  -16, 24,  0, 12 }, {     16,  -11,  -16, 24,  0, 11 }, {     16,  -12,  -16, 24,  0, 11 }, {     16,  -13,  -16, 24,  0, 11 },
    {     16,  -14,  -16, 24,  0, 11 }, {     16,  -15,  -16, 24,  0, 11 }, {     16,  -16,  -16, 24,  0, 11 }, {     16,  -17,  -16, 24,  0, 11 }, {     16,  -18,  -16, 24,  0, 11 },
    {     16,  -19,  -16, 24,  0, 11 }, {     16,  -20,  -16, 24,  0, 11 }, {     16,  -21,  -16, 24,  0, 11 }, {     16,  -22,  -16, 24,  0, 10 }, {     16,  -23,  -16, 24,  0, 10 },
    {     16,  -24,  -16, 24,  0, 10 }, {     16,  -25,  -16, 24,  0, 10 }, {     16,  -26,  -16, 24,  0, 10 }, {     16,  -27,  -16, 24,  0, 10 }, {     16,  -28,  -16, 24,  0, 10 },
    {     16,  -29,  -16, 24,  0, 10 }, {     16,  -30,  -16, 24,  0, 10 }, {     16,  -31,  -16, 24,  0, 10 }, {     16,  -32,  -16, 24,  0, 10 }, {     16,  -33,  -16, 24,  0, 10 },
    {     16,  -34,  -16, 24,  0, 10 }, {     16,  -35,  -16, 24,  0,  4 }, {     16,  -36,  -16, 24,  0,  4 }, {     16,  -37,  -16, 24,  0,  4 }, {     16,  -38,  -16, 24,  0,  4 },
    {     16,  -39,  -16, 24,  0,  4 }, {     16,  -40,  -16, 24,  0,  4 }, {     16,  -41,  -16, 24,  0,  4 }, {     16,  -42,  -16, 24,  0,  4 }, {     16,  -43,  -16, 24,  0,  4 },
    {     16,  -44,  -16, 24,  0,  4 }, {     16,  -45,  -16, 24,  0,  4 }, {     16,  -46,  -16, 24,  0,  3 }, {     16,  -47,  -16, 24,  0,  3 }, {     16,  -48,  -16, 24,  0,  3 },
    {     16,  -49,  -16, 24,  0,  3 }, {     16,  -50,  -16, 24,  0,  3 }, {     16,  -51,  -16, 24,  0,  3 }, {     16,  -52,  -16, 24,  0,  3 }, {     16,  -53,  -16, 24,  0,  3 },
    {     16,  -54,  -16, 24,  0,  3 }, {     16,  -55,  -16, 24,  0,  3 }, {     16,  -56,  -16, 24,  0,  3 }, {     16,  -57,  -16, 24,  0,  3 }, {     16,  -58,  -16, 24,  0,  3 },
    {     16,  -59,  -16, 24,  0,  0 }, {     16,  -60,  -16, 24,  0,  0 }, {     16,  -61,  -16, 24,  0,  0 }, {     16,  -62,  -16, 24,  0,  0 }, {     16,  -63,  -16, 24,  0,  0 },
    {     16,  -64,  -16, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC496, {
    {     31,   16,  -16, 16, 16,  0 }, {     30,   16,  -16, 16, 16,  0 }, {     29,   16,  -16, 16, 16,  0 }, {     28,   16,  -16, 16, 16,  0 }, {     27,   16,  -16, 16, 16,  0 },
    {     26,   16,  -16,  0,  0,  9 }, {     25,   16,  -16,  0,  0,  9 }, {     24,   16,  -16,  0,  0,  9 }, {     23,   16,  -16,  0,  0,  9 }, {     22,   16,  -16,  0,  0,  9 },
    {     21,   16,  -16,  0,  0,  9 }, {     20,   16,  -16,  0,  0,  9 }, {     19,   16,  -16,  0,  0,  9 }, {     18,   16,  -16,  0,  0,  9 }, {     17,   16,  -16,  0,  0,  9 },
    {     16,   16,  -16,  0,  0,  9 }, {     15,   16,  -16,  0,  0,  9 }, {     14,   16,  -16,  0,  0,  9 }, {     13,   16,  -16,  0,  0,  8 }, {     12,   16,  -16,  0,  0,  8 },
    {     11,   16,  -16,  0,  0,  8 }, {     10,   16,  -16,  0,  0,  8 }, {      9,   16,  -16,  0,  0,  8 }, {      8,   16,  -16,  0,  0,  8 }, {      7,   16,  -16,  0,  0,  8 },
    {      6,   16,  -16,  0,  0,  8 }, {      5,   16,  -16,  0,  0,  8 }, {      4,   16,  -16,  0,  0,  8 }, {      3,   16,  -16,  0,  0,  8 }, {      2,   16,  -16,  0,  0,  7 },
    {      1,   16,  -16,  0,  0,  7 }, {      0,   16,  -16,  0,  0,  7 }, {     -1,   16,  -16,  0,  0,  7 }, {     -2,   16,  -16,  0,  0,  7 }, {     -3,   16,  -16,  0,  0,  7 },
    {     -4,   16,  -16,  0,  0,  7 }, {     -5,   16,  -16,  0,  0,  7 }, {     -6,   16,  -16,  0,  0,  7 }, {     -7,   16,  -16,  0,  0,  7 }, {     -8,   16,  -16,  0,  0,  7 },
    {     -9,   16,  -16,  0,  0,  7 }, {    -10,   16,  -16,  0,  0,  7 }, {    -11,   16,  -16,  0,  0,  6 }, {    -12,   16,  -16,  0,  0,  6 }, {    -13,   16,  -16,  0,  0,  6 },
    {    -14,   16,  -16,  0,  0,  6 }, {    -15,   16,  -16,  0,  0,  6 }, {    -16,   16,  -16,  0,  0,  6 }, {    -17,   16,  -16,  0,  0,  6 }, {    -18,   16,  -16,  0,  0,  6 },
    {    -19,   16,  -16,  0,  0,  6 }, {    -20,   16,  -16,  0,  0,  6 }, {    -21,   16,  -16,  0,  0,  6 }, {    -22,   16,  -16,  0,  0,  5 }, {    -23,   16,  -16,  0,  0,  5 },
    {    -24,   16,  -16,  0,  0,  5 }, {    -25,   16,  -16,  0,  0,  5 }, {    -26,   16,  -16,  0,  0,  5 }, {    -27,   16,  -16,  0,  0,  5 }, {    -28,   16,  -16,  0,  0,  5 },
    {    -29,   16,  -16,  0,  0,  5 }, {    -30,   16,  -16,  0,  0,  5 }, {    -31,   16,  -16,  0,  0,  5 }, {    -32,   16,  -16,  0,  0,  5 }, {    -33,   16,  -16,  0,  0,  5 },
    {    -34,   16,  -16,  0,  0,  5 }, {    -35,   16,  -16,  0,  0,  2 }, {    -36,   16,  -16,  0,  0,  2 }, {    -37,   16,  -16,  0,  0,  2 }, {    -38,   16,  -16,  0,  0,  2 },
    {    -39,   16,  -16,  0,  0,  2 }, {    -40,   16,  -16,  0,  0,  2 }, {    -41,   16,  -16,  0,  0,  2 }, {    -42,   16,  -16,  0,  0,  2 }, {    -43,   16,  -16,  0,  0,  2 },
    {    -44,   16,  -16,  0,  0,  2 }, {    -45,   16,  -16,  0,  0,  2 }, {    -46,   16,  -16,  0,  0,  1 }, {    -47,   16,  -16,  0,  0,  1 }, {    -48,   16,  -16,  0,  0,  1 },
    {    -49,   16,  -16,  0,  0,  1 }, {    -50,   16,  -16,  0,  0,  1 }, {    -51,   16,  -16,  0,  0,  1 }, {    -52,   16,  -16,  0,  0,  1 }, {    -53,   16,  -16,  0,  0,  1 },
    {    -54,   16,  -16,  0,  0,  1 }, {    -55,   16,  -16,  0,  0,  1 }, {    -56,   16,  -16,  0,  0,  1 }, {    -57,   16,  -16,  0,  0,  1 }, {    -58,   16,  -16,  0,  0,  1 },
    {    -59,   16,  -16,  0,  0,  0 }, {    -60,   16,  -16,  0,  0,  0 }, {    -61,   16,  -16,  0,  0,  0 }, {    -62,   16,  -16,  0,  0,  0 }, {    -63,   16,  -16,  0,  0,  0 },
    {    -64,   16,  -16,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DC7F8, {
    {     16,    0,  -16, 24, 16,  0 }, {     16,    1,  -16, 24, 16,  0 }, {     16,    2,  -16, 24, 16,  0 }, {     16,    3,  -16, 24, 16,  0 }, {     16,    4,  -16, 24, 16,  0 },
    {     16,    5,  -16,  8,  0,  9 }, {     16,    6,  -16,  8,  0,  9 }, {     16,    7,  -16,  8,  0,  9 }, {     16,    8,  -16,  8,  0,  9 }, {     16,    9,  -16,  8,  0,  9 },
    {     16,   10,  -16,  8,  0,  9 }, {     16,   11,  -16,  8,  0,  9 }, {     16,   12,  -16,  8,  0,  9 }, {     16,   13,  -16,  8,  0,  9 }, {     16,   14,  -16,  8,  0,  9 },
    {     16,   15,  -16,  8,  0,  9 }, {     16,   16,  -16,  8,  0,  9 }, {     16,   17,  -16,  8,  0,  9 }, {     16,   18,  -16,  8,  0,  8 }, {     16,   19,  -16,  8,  0,  8 },
    {     16,   20,  -16,  8,  0,  8 }, {     16,   21,  -16,  8,  0,  8 }, {     16,   22,  -16,  8,  0,  8 }, {     16,   23,  -16,  8,  0,  8 }, {     16,   24,  -16,  8,  0,  8 },
    {     16,   25,  -16,  8,  0,  8 }, {     16,   26,  -16,  8,  0,  8 }, {     16,   27,  -16,  8,  0,  8 }, {     16,   28,  -16,  8,  0,  8 }, {     16,   29,  -16,  8,  0,  7 },
    {     16,   30,  -16,  8,  0,  7 }, {     16,   31,  -16,  8,  0,  7 }, {     16,   32,  -16,  8,  0,  7 }, {     16,   33,  -16,  8,  0,  7 }, {     16,   34,  -16,  8,  0,  7 },
    {     16,   35,  -16,  8,  0,  7 }, {     16,   36,  -16,  8,  0,  7 }, {     16,   37,  -16,  8,  0,  7 }, {     16,   38,  -16,  8,  0,  7 }, {     16,   39,  -16,  8,  0,  7 },
    {     16,   40,  -16,  8,  0,  7 }, {     16,   41,  -16,  8,  0,  7 }, {     16,   42,  -16,  8,  0,  6 }, {     16,   43,  -16,  8,  0,  6 }, {     16,   44,  -16,  8,  0,  6 },
    {     16,   45,  -16,  8,  0,  6 }, {     16,   46,  -16,  8,  0,  6 }, {     16,   47,  -16,  8,  0,  6 }, {     16,   48,  -16,  8,  0,  6 }, {     16,   49,  -16,  8,  0,  6 },
    {     16,   50,  -16,  8,  0,  6 }, {     16,   51,  -16,  8,  0,  6 }, {     16,   52,  -16,  8,  0,  6 }, {     16,   53,  -16,  8,  0,  5 }, {     16,   54,  -16,  8,  0,  5 },
    {     16,   55,  -16,  8,  0,  5 }, {     16,   56,  -16,  8,  0,  5 }, {     16,   57,  -16,  8,  0,  5 }, {     16,   58,  -16,  8,  0,  5 }, {     16,   59,  -16,  8,  0,  5 },
    {     16,   60,  -16,  8,  0,  5 }, {     16,   61,  -16,  8,  0,  5 }, {     16,   62,  -16,  8,  0,  5 }, {     16,   63,  -16,  8,  0,  5 }, {     16,   64,  -16,  8,  0,  5 },
    {     16,   65,  -16,  8,  0,  5 }, {     16,   66,  -16,  8,  0,  2 }, {     16,   67,  -16,  8,  0,  2 }, {     16,   68,  -16,  8,  0,  2 }, {     16,   69,  -16,  8,  0,  2 },
    {     16,   70,  -16,  8,  0,  2 }, {     16,   71,  -16,  8,  0,  2 }, {     16,   72,  -16,  8,  0,  2 }, {     16,   73,  -16,  8,  0,  2 }, {     16,   74,  -16,  8,  0,  2 },
    {     16,   75,  -16,  8,  0,  2 }, {     16,   76,  -16,  8,  0,  2 }, {     16,   77,  -16,  8,  0,  1 }, {     16,   78,  -16,  8,  0,  1 }, {     16,   79,  -16,  8,  0,  1 },
    {     16,   80,  -16,  8,  0,  1 }, {     16,   81,  -16,  8,  0,  1 }, {     16,   82,  -16,  8,  0,  1 }, {     16,   83,  -16,  8,  0,  1 }, {     16,   84,  -16,  8,  0,  1 },
    {     16,   85,  -16,  8,  0,  1 }, {     16,   86,  -16,  8,  0,  1 }, {     16,   87,  -16,  8,  0,  1 }, {     16,   88,  -16,  8,  0,  1 }, {     16,   89,  -16,  8,  0,  1 },
    {     16,   90,  -16,  8,  0,  0 }, {     16,   91,  -16,  8,  0,  0 }, {     16,   92,  -16,  8,  0,  0 }, {     16,   93,  -16,  8,  0,  0 }, {     16,   94,  -16,  8,  0,  0 },
    {     16,   95,  -16,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DCB5A, {
    {      0,   16,  -16,  0, 16,  0 }, {      1,   16,  -16,  0, 16,  0 }, {      2,   16,  -16,  0, 16,  0 }, {      3,   16,  -16,  0, 16,  0 }, {      4,   16,  -16,  0, 16,  0 },
    {      5,   16,  -16, 16,  0,  9 }, {      6,   16,  -16, 16,  0,  9 }, {      7,   16,  -16, 16,  0,  9 }, {      8,   16,  -16, 16,  0,  9 }, {      9,   16,  -16, 16,  0,  9 },
    {     10,   16,  -16, 16,  0,  9 }, {     11,   16,  -16, 16,  0,  9 }, {     12,   16,  -16, 16,  0,  9 }, {     13,   16,  -16, 16,  0,  9 }, {     14,   16,  -16, 16,  0,  9 },
    {     15,   16,  -16, 16,  0,  9 }, {     16,   16,  -16, 16,  0,  9 }, {     17,   16,  -16, 16,  0,  9 }, {     18,   16,  -16, 16,  0,  8 }, {     19,   16,  -16, 16,  0,  8 },
    {     20,   16,  -16, 16,  0,  8 }, {     21,   16,  -16, 16,  0,  8 }, {     22,   16,  -16, 16,  0,  8 }, {     23,   16,  -16, 16,  0,  8 }, {     24,   16,  -16, 16,  0,  8 },
    {     25,   16,  -16, 16,  0,  8 }, {     26,   16,  -16, 16,  0,  8 }, {     27,   16,  -16, 16,  0,  8 }, {     28,   16,  -16, 16,  0,  8 }, {     29,   16,  -16, 16,  0,  7 },
    {     30,   16,  -16, 16,  0,  7 }, {     31,   16,  -16, 16,  0,  7 }, {     32,   16,  -16, 16,  0,  7 }, {     33,   16,  -16, 16,  0,  7 }, {     34,   16,  -16, 16,  0,  7 },
    {     35,   16,  -16, 16,  0,  7 }, {     36,   16,  -16, 16,  0,  7 }, {     37,   16,  -16, 16,  0,  7 }, {     38,   16,  -16, 16,  0,  7 }, {     39,   16,  -16, 16,  0,  7 },
    {     40,   16,  -16, 16,  0,  7 }, {     41,   16,  -16, 16,  0,  7 }, {     42,   16,  -16, 16,  0,  6 }, {     43,   16,  -16, 16,  0,  6 }, {     44,   16,  -16, 16,  0,  6 },
    {     45,   16,  -16, 16,  0,  6 }, {     46,   16,  -16, 16,  0,  6 }, {     47,   16,  -16, 16,  0,  6 }, {     48,   16,  -16, 16,  0,  6 }, {     49,   16,  -16, 16,  0,  6 },
    {     50,   16,  -16, 16,  0,  6 }, {     51,   16,  -16, 16,  0,  6 }, {     52,   16,  -16, 16,  0,  6 }, {     53,   16,  -16, 16,  0,  5 }, {     54,   16,  -16, 16,  0,  5 },
    {     55,   16,  -16, 16,  0,  5 }, {     56,   16,  -16, 16,  0,  5 }, {     57,   16,  -16, 16,  0,  5 }, {     58,   16,  -16, 16,  0,  5 }, {     59,   16,  -16, 16,  0,  5 },
    {     60,   16,  -16, 16,  0,  5 }, {     61,   16,  -16, 16,  0,  5 }, {     62,   16,  -16, 16,  0,  5 }, {     63,   16,  -16, 16,  0,  5 }, {     64,   16,  -16, 16,  0,  5 },
    {     65,   16,  -16, 16,  0,  5 }, {     66,   16,  -16, 16,  0,  2 }, {     67,   16,  -16, 16,  0,  2 }, {     68,   16,  -16, 16,  0,  2 }, {     69,   16,  -16, 16,  0,  2 },
    {     70,   16,  -16, 16,  0,  2 }, {     71,   16,  -16, 16,  0,  2 }, {     72,   16,  -16, 16,  0,  2 }, {     73,   16,  -16, 16,  0,  2 }, {     74,   16,  -16, 16,  0,  2 },
    {     75,   16,  -16, 16,  0,  2 }, {     76,   16,  -16, 16,  0,  2 }, {     77,   16,  -16, 16,  0,  1 }, {     78,   16,  -16, 16,  0,  1 }, {     79,   16,  -16, 16,  0,  1 },
    {     80,   16,  -16, 16,  0,  1 }, {     81,   16,  -16, 16,  0,  1 }, {     82,   16,  -16, 16,  0,  1 }, {     83,   16,  -16, 16,  0,  1 }, {     84,   16,  -16, 16,  0,  1 },
    {     85,   16,  -16, 16,  0,  1 }, {     86,   16,  -16, 16,  0,  1 }, {     87,   16,  -16, 16,  0,  1 }, {     88,   16,  -16, 16,  0,  1 }, {     89,   16,  -16, 16,  0,  1 },
    {     90,   16,  -16, 16,  0,  0 }, {     91,   16,  -16, 16,  0,  0 }, {     92,   16,  -16, 16,  0,  0 }, {     93,   16,  -16, 16,  0,  0 }, {     94,   16,  -16, 16,  0,  0 },
    {     95,   16,  -16, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8DCEBC, {
    {     16,   31,  -16,  8, 16,  0 }, {     16,   30,  -16,  8, 16,  0 }, {     16,   29,  -16,  8, 16,  0 }, {     16,   28,  -16,  8, 16,  0 }, {     16,   27,  -16,  8, 16,  0 },
    {     16,   26,  -16, 24,  0,  9 }, {     16,   25,  -16, 24,  0,  9 }, {     16,   24,  -16, 24,  0,  9 }, {     16,   23,  -16, 24,  0,  9 }, {     16,   22,  -16, 24,  0,  9 },
    {     16,   21,  -16, 24,  0,  9 }, {     16,   20,  -16, 24,  0,  9 }, {     16,   19,  -16, 24,  0,  9 }, {     16,   18,  -16, 24,  0,  9 }, {     16,   17,  -16, 24,  0,  9 },
    {     16,   16,  -16, 24,  0,  9 }, {     16,   15,  -16, 24,  0,  9 }, {     16,   14,  -16, 24,  0,  9 }, {     16,   13,  -16, 24,  0,  8 }, {     16,   12,  -16, 24,  0,  8 },
    {     16,   11,  -16, 24,  0,  8 }, {     16,   10,  -16, 24,  0,  8 }, {     16,    9,  -16, 24,  0,  8 }, {     16,    8,  -16, 24,  0,  8 }, {     16,    7,  -16, 24,  0,  8 },
    {     16,    6,  -16, 24,  0,  8 }, {     16,    5,  -16, 24,  0,  8 }, {     16,    4,  -16, 24,  0,  8 }, {     16,    3,  -16, 24,  0,  8 }, {     16,    2,  -16, 24,  0,  7 },
    {     16,    1,  -16, 24,  0,  7 }, {     16,    0,  -16, 24,  0,  7 }, {     16,   -1,  -16, 24,  0,  7 }, {     16,   -2,  -16, 24,  0,  7 }, {     16,   -3,  -16, 24,  0,  7 },
    {     16,   -4,  -16, 24,  0,  7 }, {     16,   -5,  -16, 24,  0,  7 }, {     16,   -6,  -16, 24,  0,  7 }, {     16,   -7,  -16, 24,  0,  7 }, {     16,   -8,  -16, 24,  0,  7 },
    {     16,   -9,  -16, 24,  0,  7 }, {     16,  -10,  -16, 24,  0,  7 }, {     16,  -11,  -16, 24,  0,  6 }, {     16,  -12,  -16, 24,  0,  6 }, {     16,  -13,  -16, 24,  0,  6 },
    {     16,  -14,  -16, 24,  0,  6 }, {     16,  -15,  -16, 24,  0,  6 }, {     16,  -16,  -16, 24,  0,  6 }, {     16,  -17,  -16, 24,  0,  6 }, {     16,  -18,  -16, 24,  0,  6 },
    {     16,  -19,  -16, 24,  0,  6 }, {     16,  -20,  -16, 24,  0,  6 }, {     16,  -21,  -16, 24,  0,  6 }, {     16,  -22,  -16, 24,  0,  5 }, {     16,  -23,  -16, 24,  0,  5 },
    {     16,  -24,  -16, 24,  0,  5 }, {     16,  -25,  -16, 24,  0,  5 }, {     16,  -26,  -16, 24,  0,  5 }, {     16,  -27,  -16, 24,  0,  5 }, {     16,  -28,  -16, 24,  0,  5 },
    {     16,  -29,  -16, 24,  0,  5 }, {     16,  -30,  -16, 24,  0,  5 }, {     16,  -31,  -16, 24,  0,  5 }, {     16,  -32,  -16, 24,  0,  5 }, {     16,  -33,  -16, 24,  0,  5 },
    {     16,  -34,  -16, 24,  0,  5 }, {     16,  -35,  -16, 24,  0,  2 }, {     16,  -36,  -16, 24,  0,  2 }, {     16,  -37,  -16, 24,  0,  2 }, {     16,  -38,  -16, 24,  0,  2 },
    {     16,  -39,  -16, 24,  0,  2 }, {     16,  -40,  -16, 24,  0,  2 }, {     16,  -41,  -16, 24,  0,  2 }, {     16,  -42,  -16, 24,  0,  2 }, {     16,  -43,  -16, 24,  0,  2 },
    {     16,  -44,  -16, 24,  0,  2 }, {     16,  -45,  -16, 24,  0,  2 }, {     16,  -46,  -16, 24,  0,  1 }, {     16,  -47,  -16, 24,  0,  1 }, {     16,  -48,  -16, 24,  0,  1 },
    {     16,  -49,  -16, 24,  0,  1 }, {     16,  -50,  -16, 24,  0,  1 }, {     16,  -51,  -16, 24,  0,  1 }, {     16,  -52,  -16, 24,  0,  1 }, {     16,  -53,  -16, 24,  0,  1 },
    {     16,  -54,  -16, 24,  0,  1 }, {     16,  -55,  -16, 24,  0,  1 }, {     16,  -56,  -16, 24,  0,  1 }, {     16,  -57,  -16, 24,  0,  1 }, {     16,  -58,  -16, 24,  0,  1 },
    {     16,  -59,  -16, 24,  0,  0 }, {     16,  -60,  -16, 24,  0,  0 }, {     16,  -61,  -16, 24,  0,  0 }, {     16,  -62,  -16, 24,  0,  0 }, {     16,  -63,  -16, 24,  0,  0 },
    {     16,  -64,  -16, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E644E, {
    {     31,   16,    0,  0,  2,  0 }, {     30,   16,    0,  0,  2,  0 }, {     29,   16,    1,  0,  2,  0 }, {     28,   16,    1,  0,  2,  0 }, {     27,   16,    2,  0,  2,  0 },
    {     26,   16,    2,  0,  2,  0 }, {     25,   16,    3,  0,  2,  0 }, {     24,   16,    3,  0,  2,  0 }, {     23,   16,    3,  0,  2,  0 }, {     22,   16,    4,  0,  2,  0 },
    {     21,   16,    4,  0,  2,  0 }, {     20,   16,    5,  0,  2,  0 }, {     19,   16,    5,  0,  2,  0 }, {     18,   16,    6,  0,  2,  0 }, {     17,   16,    6,  0,  2,  0 },
    {     16,   16,    7,  0,  2,  0 }, {     15,   16,    7,  0,  2,  0 }, {     14,   16,    8,  0,  2,  0 }, {     13,   16,    8,  0,  2,  0 }, {     12,   16,    9,  0,  3,  0 },
    {     11,   16,    9,  0,  3,  0 }, {     10,   16,   10,  0,  3,  0 }, {      9,   16,   10,  0,  3,  0 }, {      8,   16,   11,  0,  3,  0 }, {      7,   16,   11,  0,  3,  0 },
    {      6,   16,   12,  0,  3,  0 }, {      5,   16,   13,  0,  3,  0 }, {      4,   16,   14,  0,  3,  0 }, {      3,   16,   15,  0,  3,  0 }, {      2,   16,   15,  0,  3,  0 },
    {      1,   16,   16,  0,  3,  0 }, {      0,   16,   17,  0,  3,  0 }, {     -1,   16,   18,  0,  3,  0 }, {     -2,   16,   18,  0,  3,  0 }, {     -3,   16,   19,  0,  3,  0 },
    {     -4,   16,   20,  0,  3,  0 }, {     -5,   16,   21,  0,  3,  0 }, {     -6,   16,   22,  0,  3,  0 }, {     -7,   16,   23,  0,  3,  0 }, {     -8,   16,   24,  0,  3,  0 },
    {     -9,   16,   25,  0,  3,  0 }, {    -10,   16,   26,  0,  3,  0 }, {    -11,   16,   27,  0,  4,  0 }, {    -12,   16,   28,  0,  4,  0 }, {    -13,   16,   29,  0,  4,  0 },
    {    -13,   16,   30,  0,  4,  0 }, {    -14,   16,   31,  0,  4,  0 }, {    -15,   16,   32,  0,  4,  0 }, {    -16,   16,   33,  0,  4,  0 }, {    -16,   16,   34,  0,  4,  0 },
    {    -17,   16,   35,  0,  4,  0 }, {    -18,   16,   36,  0,  4,  0 }, {    -19,   16,   37,  0,  4,  0 }, {    -19,   16,   38,  0,  4,  0 }, {    -20,   16,   39,  0,  4,  0 },
    {    -20,   16,   40,  0,  4,  0 }, {    -21,   16,   41,  0,  4,  0 }, {    -22,   16,   42,  0,  4,  0 }, {    -22,   16,   43,  0,  9,  0 }, {    -23,   16,   44,  0,  9,  0 },
    {    -24,   16,   45,  0,  9,  0 }, {    -24,   16,   46,  0,  9,  0 }, {    -25,   16,   47,  0,  9,  0 }, {    -25,   16,   48,  0,  9,  0 }, {    -25,   16,   49,  0,  9,  0 },
    {    -26,   16,   50,  0,  9,  0 }, {    -26,   16,   51,  0,  9,  0 }, {    -26,   16,   52,  0,  9,  0 }, {    -27,   16,   53,  0,  9,  0 }, {    -27,   16,   54,  0,  9,  0 },
    {    -27,   16,   55,  0,  9,  0 }, {    -28,   16,   56,  0,  9,  0 }, {    -28,   16,   57,  0,  9,  0 }, {    -28,   16,   58,  0,  9,  0 }, {    -29,   16,   59,  0,  9,  0 },
    {    -29,   16,   60,  0,  9,  0 }, {    -29,   16,   61,  0,  9,  0 }, {    -30,   16,   62,  0,  9,  0 }, {    -30,   16,   63,  0,  9,  0 }, {    -30,   16,   64,  0, 10,  0 },
    {    -30,   16,   65,  0, 10,  0 }, {    -31,   16,   66,  0, 10,  0 }, {    -31,   16,   67,  0, 10,  0 }, {    -31,   16,   68,  0, 10,  0 }, {    -31,   16,   69,  0, 10,  0 },
    {    -31,   16,   70,  0, 10,  0 }, {    -32,   16,   71,  0, 10,  0 }, {    -32,   16,   72,  0, 10,  0 }, {    -32,   16,   73,  0, 10,  0 }, {    -32,   16,   74,  0, 10,  0 },
    {    -32,   16,   75,  0, 10,  0 }, {    -32,   16,   76,  0, 10,  0 }, {    -32,   16,   77,  0, 10,  0 }, {    -32,   16,   78,  0, 10,  0 }, {    -32,   16,   79,  0, 10,  0 },
    {    -32,   16,   80,  0, 10,  0 }, {    -32,   16,   81,  0, 10,  0 }, {    -32,   16,   82,  0, 10,  0 }, {    -32,   16,   83,  0, 10,  0 }, {    -32,   16,   84,  0, 10,  0 },
    {    -32,   16,   85,  0, 10,  0 }, {    -32,   16,   86,  0, 10,  0 }, {    -32,   16,   87,  0, 10,  0 }, {    -32,   16,   88,  0, 10,  0 }, {    -32,   16,   89,  0, 10,  0 },
    {    -32,   16,   90,  0, 10,  0 }, {    -32,   16,   91,  0, 10,  0 }, {    -32,   16,   92,  0, 10,  0 }, {    -32,   16,   93,  0, 10,  0 }, {    -32,   16,   94,  0, 10,  0 },
    {    -32,   16,   95,  0, 10,  0 }, {    -32,   16,   96,  0, 10,  0 }, {    -32,   16,   97,  0, 11,  0 }, {    -32,   16,   98,  0, 11,  0 }, {    -31,   16,   99,  0, 11,  0 },
    {    -31,   16,  100,  0, 11,  0 }, {    -31,   16,  101,  0, 11,  0 }, {    -31,   16,  102,  0, 11,  0 }, {    -31,   16,  103,  0, 11,  0 }, {    -30,   16,  104,  0, 11,  0 },
    {    -30,   16,  105,  0, 11,  0 }, {    -30,   16,  106,  0, 11,  0 }, {    -30,   16,  107,  0, 11,  0 }, {    -29,   16,  108,  0, 11,  0 }, {    -29,   16,  109,  0, 11,  0 },
    {    -29,   16,  110,  0, 11,  0 }, {    -28,   16,  111,  0, 12,  0 }, {    -28,   16,  112,  0, 12,  0 }, {    -27,   16,  113,  0, 12,  0 }, {    -27,   16,  114,  0, 12,  0 },
    {    -26,   16,  115,  0, 12,  0 }, {    -26,   16,  116,  0, 12,  0 }, {    -26,   16,  117,  0, 12,  0 }, {    -25,   16,  118,  0, 12,  0 }, {    -25,   16,  119,  0, 12,  0 },
    {    -24,   16,  120,  0, 13,  0 }, {    -24,   16,  121,  0, 13,  0 }, {    -23,   16,  122,  0, 13,  0 }, {    -22,   16,  123,  0, 13,  0 }, {    -22,   16,  124,  0, 13,  0 },
    {    -21,   16,  125,  0, 13,  0 }, {    -20,   16,  126,  0, 13,  0 }, {    -19,   16,  127,  0, 13,  0 }, {    -18,   16,  128,  0, 14,  0 }, {    -17,   16,  129,  0, 14,  0 },
    {    -16,   16,  130,  0, 14,  0 }, {    -15,   16,  130,  0, 14,  0 }, {    -14,   16,  131,  0, 14,  0 }, {    -13,   16,  132,  0, 15,  0 }, {    -12,   16,  133,  0, 15,  0 },
    {    -11,   16,  134,  0, 15,  0 }, {    -10,   16,  134,  0, 15,  0 }, {     -9,   16,  135,  0, 15,  0 }, {     -8,   16,  135,  0, 16,  0 }, {     -7,   16,  135,  0, 16,  0 },
    {     -6,   16,  136,  0, 16,  0 }, {     -5,   16,  136,  0, 16,  0 }, {     -4,   16,  136,  0, 16,  0 }, {     -3,   16,  136,  0, 16,  0 }, {     -2,   16,  136,  0, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E69F9, {
    {     16,    0,    0,  8,  2,  0 }, {     16,    1,    0,  8,  2,  0 }, {     16,    2,    1,  8,  2,  0 }, {     16,    3,    1,  8,  2,  0 }, {     16,    4,    2,  8,  2,  0 },
    {     16,    5,    2,  8,  2,  0 }, {     16,    6,    3,  8,  2,  0 }, {     16,    7,    3,  8,  2,  0 }, {     16,    8,    3,  8,  2,  0 }, {     16,    9,    4,  8,  2,  0 },
    {     16,   10,    4,  8,  2,  0 }, {     16,   11,    5,  8,  2,  0 }, {     16,   12,    5,  8,  2,  0 }, {     16,   13,    6,  8,  2,  0 }, {     16,   14,    6,  8,  2,  0 },
    {     16,   15,    7,  8,  2,  0 }, {     16,   16,    7,  8,  2,  0 }, {     16,   17,    8,  8,  2,  0 }, {     16,   18,    8,  8,  2,  0 }, {     16,   19,    9,  8,  3,  0 },
    {     16,   20,    9,  8,  3,  0 }, {     16,   21,   10,  8,  3,  0 }, {     16,   22,   10,  8,  3,  0 }, {     16,   23,   11,  8,  3,  0 }, {     16,   24,   11,  8,  3,  0 },
    {     16,   25,   12,  8,  3,  0 }, {     16,   26,   13,  8,  3,  0 }, {     16,   27,   14,  8,  3,  0 }, {     16,   28,   15,  8,  3,  0 }, {     16,   29,   15,  8,  3,  0 },
    {     16,   30,   16,  8,  3,  0 }, {     16,   31,   17,  8,  3,  0 }, {     16,   32,   18,  8,  3,  0 }, {     16,   33,   18,  8,  3,  0 }, {     16,   34,   19,  8,  3,  0 },
    {     16,   35,   20,  8,  3,  0 }, {     16,   36,   21,  8,  3,  0 }, {     16,   37,   22,  8,  3,  0 }, {     16,   38,   23,  8,  3,  0 }, {     16,   39,   24,  8,  3,  0 },
    {     16,   40,   25,  8,  3,  0 }, {     16,   41,   26,  8,  3,  0 }, {     16,   42,   27,  8,  4,  0 }, {     16,   43,   28,  8,  4,  0 }, {     16,   44,   29,  8,  4,  0 },
    {     16,   44,   30,  8,  4,  0 }, {     16,   45,   31,  8,  4,  0 }, {     16,   46,   32,  8,  4,  0 }, {     16,   47,   33,  8,  4,  0 }, {     16,   47,   34,  8,  4,  0 },
    {     16,   48,   35,  8,  4,  0 }, {     16,   49,   36,  8,  4,  0 }, {     16,   50,   37,  8,  4,  0 }, {     16,   50,   38,  8,  4,  0 }, {     16,   51,   39,  8,  4,  0 },
    {     16,   51,   40,  8,  4,  0 }, {     16,   52,   41,  8,  4,  0 }, {     16,   53,   42,  8,  4,  0 }, {     16,   53,   43,  8,  9,  0 }, {     16,   54,   44,  8,  9,  0 },
    {     16,   55,   45,  8,  9,  0 }, {     16,   55,   46,  8,  9,  0 }, {     16,   56,   47,  8,  9,  0 }, {     16,   56,   48,  8,  9,  0 }, {     16,   56,   49,  8,  9,  0 },
    {     16,   57,   50,  8,  9,  0 }, {     16,   57,   51,  8,  9,  0 }, {     16,   57,   52,  8,  9,  0 }, {     16,   58,   53,  8,  9,  0 }, {     16,   58,   54,  8,  9,  0 },
    {     16,   58,   55,  8,  9,  0 }, {     16,   59,   56,  8,  9,  0 }, {     16,   59,   57,  8,  9,  0 }, {     16,   59,   58,  8,  9,  0 }, {     16,   60,   59,  8,  9,  0 },
    {     16,   60,   60,  8,  9,  0 }, {     16,   60,   61,  8,  9,  0 }, {     16,   61,   62,  8,  9,  0 }, {     16,   61,   63,  8,  9,  0 }, {     16,   61,   64,  8, 10,  0 },
    {     16,   61,   65,  8, 10,  0 }, {     16,   62,   66,  8, 10,  0 }, {     16,   62,   67,  8, 10,  0 }, {     16,   62,   68,  8, 10,  0 }, {     16,   62,   69,  8, 10,  0 },
    {     16,   62,   70,  8, 10,  0 }, {     16,   63,   71,  8, 10,  0 }, {     16,   63,   72,  8, 10,  0 }, {     16,   63,   73,  8, 10,  0 }, {     16,   63,   74,  8, 10,  0 },
    {     16,   63,   75,  8, 10,  0 }, {     16,   63,   76,  8, 10,  0 }, {     16,   63,   77,  8, 10,  0 }, {     16,   63,   78,  8, 10,  0 }, {     16,   63,   79,  8, 10,  0 },
    {     16,   63,   80,  8, 10,  0 }, {     16,   63,   81,  8, 10,  0 }, {     16,   63,   82,  8, 10,  0 }, {     16,   63,   83,  8, 10,  0 }, {     16,   63,   84,  8, 10,  0 },
    {     16,   63,   85,  8, 10,  0 }, {     16,   63,   86,  8, 10,  0 }, {     16,   63,   87,  8, 10,  0 }, {     16,   63,   88,  8, 10,  0 }, {     16,   63,   89,  8, 10,  0 },
    {     16,   63,   90,  8, 10,  0 }, {     16,   63,   91,  8, 10,  0 }, {     16,   63,   92,  8, 10,  0 }, {     16,   63,   93,  8, 10,  0 }, {     16,   63,   94,  8, 10,  0 },
    {     16,   63,   95,  8, 10,  0 }, {     16,   63,   96,  8, 10,  0 }, {     16,   63,   97,  8, 11,  0 }, {     16,   63,   98,  8, 11,  0 }, {     16,   62,   99,  8, 11,  0 },
    {     16,   62,  100,  8, 11,  0 }, {     16,   62,  101,  8, 11,  0 }, {     16,   62,  102,  8, 11,  0 }, {     16,   62,  103,  8, 11,  0 }, {     16,   61,  104,  8, 11,  0 },
    {     16,   61,  105,  8, 11,  0 }, {     16,   61,  106,  8, 11,  0 }, {     16,   61,  107,  8, 11,  0 }, {     16,   60,  108,  8, 11,  0 }, {     16,   60,  109,  8, 11,  0 },
    {     16,   60,  110,  8, 11,  0 }, {     16,   59,  111,  8, 12,  0 }, {     16,   59,  112,  8, 12,  0 }, {     16,   58,  113,  8, 12,  0 }, {     16,   58,  114,  8, 12,  0 },
    {     16,   57,  115,  8, 12,  0 }, {     16,   57,  116,  8, 12,  0 }, {     16,   57,  117,  8, 12,  0 }, {     16,   56,  118,  8, 12,  0 }, {     16,   56,  119,  8, 12,  0 },
    {     16,   55,  120,  8, 13,  0 }, {     16,   55,  121,  8, 13,  0 }, {     16,   54,  122,  8, 13,  0 }, {     16,   53,  123,  8, 13,  0 }, {     16,   53,  124,  8, 13,  0 },
    {     16,   52,  125,  8, 13,  0 }, {     16,   51,  126,  8, 13,  0 }, {     16,   50,  127,  8, 13,  0 }, {     16,   49,  128,  8, 14,  0 }, {     16,   48,  129,  8, 14,  0 },
    {     16,   47,  130,  8, 14,  0 }, {     16,   46,  130,  8, 14,  0 }, {     16,   45,  131,  8, 14,  0 }, {     16,   44,  132,  8, 15,  0 }, {     16,   43,  133,  8, 15,  0 },
    {     16,   42,  134,  8, 15,  0 }, {     16,   41,  134,  8, 15,  0 }, {     16,   40,  135,  8, 15,  0 }, {     16,   39,  135,  8, 16,  0 }, {     16,   38,  135,  8, 16,  0 },
    {     16,   37,  136,  8, 16,  0 }, {     16,   36,  136,  8, 16,  0 }, {     16,   35,  136,  8, 16,  0 }, {     16,   34,  136,  8, 16,  0 }, {     16,   33,  136,  8, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E6FA4, {
    {      0,   16,    0, 16,  2,  0 }, {      1,   16,    0, 16,  2,  0 }, {      2,   16,    1, 16,  2,  0 }, {      3,   16,    1, 16,  2,  0 }, {      4,   16,    2, 16,  2,  0 },
    {      5,   16,    2, 16,  2,  0 }, {      6,   16,    3, 16,  2,  0 }, {      7,   16,    3, 16,  2,  0 }, {      8,   16,    3, 16,  2,  0 }, {      9,   16,    4, 16,  2,  0 },
    {     10,   16,    4, 16,  2,  0 }, {     11,   16,    5, 16,  2,  0 }, {     12,   16,    5, 16,  2,  0 }, {     13,   16,    6, 16,  2,  0 }, {     14,   16,    6, 16,  2,  0 },
    {     15,   16,    7, 16,  2,  0 }, {     16,   16,    7, 16,  2,  0 }, {     17,   16,    8, 16,  2,  0 }, {     18,   16,    8, 16,  2,  0 }, {     19,   16,    9, 16,  3,  0 },
    {     20,   16,    9, 16,  3,  0 }, {     21,   16,   10, 16,  3,  0 }, {     22,   16,   10, 16,  3,  0 }, {     23,   16,   11, 16,  3,  0 }, {     24,   16,   11, 16,  3,  0 },
    {     25,   16,   12, 16,  3,  0 }, {     26,   16,   13, 16,  3,  0 }, {     27,   16,   14, 16,  3,  0 }, {     28,   16,   15, 16,  3,  0 }, {     29,   16,   15, 16,  3,  0 },
    {     30,   16,   16, 16,  3,  0 }, {     31,   16,   17, 16,  3,  0 }, {     32,   16,   18, 16,  3,  0 }, {     33,   16,   18, 16,  3,  0 }, {     34,   16,   19, 16,  3,  0 },
    {     35,   16,   20, 16,  3,  0 }, {     36,   16,   21, 16,  3,  0 }, {     37,   16,   22, 16,  3,  0 }, {     38,   16,   23, 16,  3,  0 }, {     39,   16,   24, 16,  3,  0 },
    {     40,   16,   25, 16,  3,  0 }, {     41,   16,   26, 16,  3,  0 }, {     42,   16,   27, 16,  4,  0 }, {     43,   16,   28, 16,  4,  0 }, {     44,   16,   29, 16,  4,  0 },
    {     44,   16,   30, 16,  4,  0 }, {     45,   16,   31, 16,  4,  0 }, {     46,   16,   32, 16,  4,  0 }, {     47,   16,   33, 16,  4,  0 }, {     47,   16,   34, 16,  4,  0 },
    {     48,   16,   35, 16,  4,  0 }, {     49,   16,   36, 16,  4,  0 }, {     50,   16,   37, 16,  4,  0 }, {     50,   16,   38, 16,  4,  0 }, {     51,   16,   39, 16,  4,  0 },
    {     51,   16,   40, 16,  4,  0 }, {     52,   16,   41, 16,  4,  0 }, {     53,   16,   42, 16,  4,  0 }, {     53,   16,   43, 16,  9,  0 }, {     54,   16,   44, 16,  9,  0 },
    {     55,   16,   45, 16,  9,  0 }, {     55,   16,   46, 16,  9,  0 }, {     56,   16,   47, 16,  9,  0 }, {     56,   16,   48, 16,  9,  0 }, {     56,   16,   49, 16,  9,  0 },
    {     57,   16,   50, 16,  9,  0 }, {     57,   16,   51, 16,  9,  0 }, {     57,   16,   52, 16,  9,  0 }, {     58,   16,   53, 16,  9,  0 }, {     58,   16,   54, 16,  9,  0 },
    {     58,   16,   55, 16,  9,  0 }, {     59,   16,   56, 16,  9,  0 }, {     59,   16,   57, 16,  9,  0 }, {     59,   16,   58, 16,  9,  0 }, {     60,   16,   59, 16,  9,  0 },
    {     60,   16,   60, 16,  9,  0 }, {     60,   16,   61, 16,  9,  0 }, {     61,   16,   62, 16,  9,  0 }, {     61,   16,   63, 16,  9,  0 }, {     61,   16,   64, 16, 10,  0 },
    {     61,   16,   65, 16, 10,  0 }, {     62,   16,   66, 16, 10,  0 }, {     62,   16,   67, 16, 10,  0 }, {     62,   16,   68, 16, 10,  0 }, {     62,   16,   69, 16, 10,  0 },
    {     62,   16,   70, 16, 10,  0 }, {     63,   16,   71, 16, 10,  0 }, {     63,   16,   72, 16, 10,  0 }, {     63,   16,   73, 16, 10,  0 }, {     63,   16,   74, 16, 10,  0 },
    {     63,   16,   75, 16, 10,  0 }, {     63,   16,   76, 16, 10,  0 }, {     63,   16,   77, 16, 10,  0 }, {     63,   16,   78, 16, 10,  0 }, {     63,   16,   79, 16, 10,  0 },
    {     63,   16,   80, 16, 10,  0 }, {     63,   16,   81, 16, 10,  0 }, {     63,   16,   82, 16, 10,  0 }, {     63,   16,   83, 16, 10,  0 }, {     63,   16,   84, 16, 10,  0 },
    {     63,   16,   85, 16, 10,  0 }, {     63,   16,   86, 16, 10,  0 }, {     63,   16,   87, 16, 10,  0 }, {     63,   16,   88, 16, 10,  0 }, {     63,   16,   89, 16, 10,  0 },
    {     63,   16,   90, 16, 10,  0 }, {     63,   16,   91, 16, 10,  0 }, {     63,   16,   92, 16, 10,  0 }, {     63,   16,   93, 16, 10,  0 }, {     63,   16,   94, 16, 10,  0 },
    {     63,   16,   95, 16, 10,  0 }, {     63,   16,   96, 16, 10,  0 }, {     63,   16,   97, 16, 11,  0 }, {     63,   16,   98, 16, 11,  0 }, {     62,   16,   99, 16, 11,  0 },
    {     62,   16,  100, 16, 11,  0 }, {     62,   16,  101, 16, 11,  0 }, {     62,   16,  102, 16, 11,  0 }, {     62,   16,  103, 16, 11,  0 }, {     61,   16,  104, 16, 11,  0 },
    {     61,   16,  105, 16, 11,  0 }, {     61,   16,  106, 16, 11,  0 }, {     61,   16,  107, 16, 11,  0 }, {     60,   16,  108, 16, 11,  0 }, {     60,   16,  109, 16, 11,  0 },
    {     60,   16,  110, 16, 11,  0 }, {     59,   16,  111, 16, 12,  0 }, {     59,   16,  112, 16, 12,  0 }, {     58,   16,  113, 16, 12,  0 }, {     58,   16,  114, 16, 12,  0 },
    {     57,   16,  115, 16, 12,  0 }, {     57,   16,  116, 16, 12,  0 }, {     57,   16,  117, 16, 12,  0 }, {     56,   16,  118, 16, 12,  0 }, {     56,   16,  119, 16, 12,  0 },
    {     55,   16,  120, 16, 13,  0 }, {     55,   16,  121, 16, 13,  0 }, {     54,   16,  122, 16, 13,  0 }, {     53,   16,  123, 16, 13,  0 }, {     53,   16,  124, 16, 13,  0 },
    {     52,   16,  125, 16, 13,  0 }, {     51,   16,  126, 16, 13,  0 }, {     50,   16,  127, 16, 13,  0 }, {     49,   16,  128, 16, 14,  0 }, {     48,   16,  129, 16, 14,  0 },
    {     47,   16,  130, 16, 14,  0 }, {     46,   16,  130, 16, 14,  0 }, {     45,   16,  131, 16, 14,  0 }, {     44,   16,  132, 16, 15,  0 }, {     43,   16,  133, 16, 15,  0 },
    {     42,   16,  134, 16, 15,  0 }, {     41,   16,  134, 16, 15,  0 }, {     40,   16,  135, 16, 15,  0 }, {     39,   16,  135, 16, 16,  0 }, {     38,   16,  135, 16, 16,  0 },
    {     37,   16,  136, 16, 16,  0 }, {     36,   16,  136, 16, 16,  0 }, {     35,   16,  136, 16, 16,  0 }, {     34,   16,  136, 16, 16,  0 }, {     33,   16,  136, 16, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E754F, {
    {     16,   31,    0, 24,  2,  0 }, {     16,   30,    0, 24,  2,  0 }, {     16,   29,    1, 24,  2,  0 }, {     16,   28,    1, 24,  2,  0 }, {     16,   27,    2, 24,  2,  0 },
    {     16,   26,    2, 24,  2,  0 }, {     16,   25,    3, 24,  2,  0 }, {     16,   24,    3, 24,  2,  0 }, {     16,   23,    3, 24,  2,  0 }, {     16,   22,    4, 24,  2,  0 },
    {     16,   21,    4, 24,  2,  0 }, {     16,   20,    5, 24,  2,  0 }, {     16,   19,    5, 24,  2,  0 }, {     16,   18,    6, 24,  2,  0 }, {     16,   17,    6, 24,  2,  0 },
    {     16,   16,    7, 24,  2,  0 }, {     16,   15,    7, 24,  2,  0 }, {     16,   14,    8, 24,  2,  0 }, {     16,   13,    8, 24,  2,  0 }, {     16,   12,    9, 24,  3,  0 },
    {     16,   11,    9, 24,  3,  0 }, {     16,   10,   10, 24,  3,  0 }, {     16,    9,   10, 24,  3,  0 }, {     16,    8,   11, 24,  3,  0 }, {     16,    7,   11, 24,  3,  0 },
    {     16,    6,   12, 24,  3,  0 }, {     16,    5,   13, 24,  3,  0 }, {     16,    4,   14, 24,  3,  0 }, {     16,    3,   15, 24,  3,  0 }, {     16,    2,   15, 24,  3,  0 },
    {     16,    1,   16, 24,  3,  0 }, {     16,    0,   17, 24,  3,  0 }, {     16,   -1,   18, 24,  3,  0 }, {     16,   -2,   18, 24,  3,  0 }, {     16,   -3,   19, 24,  3,  0 },
    {     16,   -4,   20, 24,  3,  0 }, {     16,   -5,   21, 24,  3,  0 }, {     16,   -6,   22, 24,  3,  0 }, {     16,   -7,   23, 24,  3,  0 }, {     16,   -8,   24, 24,  3,  0 },
    {     16,   -9,   25, 24,  3,  0 }, {     16,  -10,   26, 24,  3,  0 }, {     16,  -11,   27, 24,  4,  0 }, {     16,  -12,   28, 24,  4,  0 }, {     16,  -13,   29, 24,  4,  0 },
    {     16,  -13,   30, 24,  4,  0 }, {     16,  -14,   31, 24,  4,  0 }, {     16,  -15,   32, 24,  4,  0 }, {     16,  -16,   33, 24,  4,  0 }, {     16,  -16,   34, 24,  4,  0 },
    {     16,  -17,   35, 24,  4,  0 }, {     16,  -18,   36, 24,  4,  0 }, {     16,  -19,   37, 24,  4,  0 }, {     16,  -19,   38, 24,  4,  0 }, {     16,  -20,   39, 24,  4,  0 },
    {     16,  -20,   40, 24,  4,  0 }, {     16,  -21,   41, 24,  4,  0 }, {     16,  -22,   42, 24,  4,  0 }, {     16,  -22,   43, 24,  9,  0 }, {     16,  -23,   44, 24,  9,  0 },
    {     16,  -24,   45, 24,  9,  0 }, {     16,  -24,   46, 24,  9,  0 }, {     16,  -25,   47, 24,  9,  0 }, {     16,  -25,   48, 24,  9,  0 }, {     16,  -25,   49, 24,  9,  0 },
    {     16,  -26,   50, 24,  9,  0 }, {     16,  -26,   51, 24,  9,  0 }, {     16,  -26,   52, 24,  9,  0 }, {     16,  -27,   53, 24,  9,  0 }, {     16,  -27,   54, 24,  9,  0 },
    {     16,  -27,   55, 24,  9,  0 }, {     16,  -28,   56, 24,  9,  0 }, {     16,  -28,   57, 24,  9,  0 }, {     16,  -28,   58, 24,  9,  0 }, {     16,  -29,   59, 24,  9,  0 },
    {     16,  -29,   60, 24,  9,  0 }, {     16,  -29,   61, 24,  9,  0 }, {     16,  -30,   62, 24,  9,  0 }, {     16,  -30,   63, 24,  9,  0 }, {     16,  -30,   64, 24, 10,  0 },
    {     16,  -30,   65, 24, 10,  0 }, {     16,  -31,   66, 24, 10,  0 }, {     16,  -31,   67, 24, 10,  0 }, {     16,  -31,   68, 24, 10,  0 }, {     16,  -31,   69, 24, 10,  0 },
    {     16,  -31,   70, 24, 10,  0 }, {     16,  -32,   71, 24, 10,  0 }, {     16,  -32,   72, 24, 10,  0 }, {     16,  -32,   73, 24, 10,  0 }, {     16,  -32,   74, 24, 10,  0 },
    {     16,  -32,   75, 24, 10,  0 }, {     16,  -32,   76, 24, 10,  0 }, {     16,  -32,   77, 24, 10,  0 }, {     16,  -32,   78, 24, 10,  0 }, {     16,  -32,   79, 24, 10,  0 },
    {     16,  -32,   80, 24, 10,  0 }, {     16,  -32,   81, 24, 10,  0 }, {     16,  -32,   82, 24, 10,  0 }, {     16,  -32,   83, 24, 10,  0 }, {     16,  -32,   84, 24, 10,  0 },
    {     16,  -32,   85, 24, 10,  0 }, {     16,  -32,   86, 24, 10,  0 }, {     16,  -32,   87, 24, 10,  0 }, {     16,  -32,   88, 24, 10,  0 }, {     16,  -32,   89, 24, 10,  0 },
    {     16,  -32,   90, 24, 10,  0 }, {     16,  -32,   91, 24, 10,  0 }, {     16,  -32,   92, 24, 10,  0 }, {     16,  -32,   93, 24, 10,  0 }, {     16,  -32,   94, 24, 10,  0 },
    {     16,  -32,   95, 24, 10,  0 }, {     16,  -32,   96, 24, 10,  0 }, {     16,  -32,   97, 24, 11,  0 }, {     16,  -32,   98, 24, 11,  0 }, {     16,  -31,   99, 24, 11,  0 },
    {     16,  -31,  100, 24, 11,  0 }, {     16,  -31,  101, 24, 11,  0 }, {     16,  -31,  102, 24, 11,  0 }, {     16,  -31,  103, 24, 11,  0 }, {     16,  -30,  104, 24, 11,  0 },
    {     16,  -30,  105, 24, 11,  0 }, {     16,  -30,  106, 24, 11,  0 }, {     16,  -30,  107, 24, 11,  0 }, {     16,  -29,  108, 24, 11,  0 }, {     16,  -29,  109, 24, 11,  0 },
    {     16,  -29,  110, 24, 11,  0 }, {     16,  -28,  111, 24, 12,  0 }, {     16,  -28,  112, 24, 12,  0 }, {     16,  -27,  113, 24, 12,  0 }, {     16,  -27,  114, 24, 12,  0 },
    {     16,  -26,  115, 24, 12,  0 }, {     16,  -26,  116, 24, 12,  0 }, {     16,  -26,  117, 24, 12,  0 }, {     16,  -25,  118, 24, 12,  0 }, {     16,  -25,  119, 24, 12,  0 },
    {     16,  -24,  120, 24, 13,  0 }, {     16,  -24,  121, 24, 13,  0 }, {     16,  -23,  122, 24, 13,  0 }, {     16,  -22,  123, 24, 13,  0 }, {     16,  -22,  124, 24, 13,  0 },
    {     16,  -21,  125, 24, 13,  0 }, {     16,  -20,  126, 24, 13,  0 }, {     16,  -19,  127, 24, 13,  0 }, {     16,  -18,  128, 24, 14,  0 }, {     16,  -17,  129, 24, 14,  0 },
    {     16,  -16,  130, 24, 14,  0 }, {     16,  -15,  130, 24, 14,  0 }, {     16,  -14,  131, 24, 14,  0 }, {     16,  -13,  132, 24, 15,  0 }, {     16,  -12,  133, 24, 15,  0 },
    {     16,  -11,  134, 24, 15,  0 }, {     16,  -10,  134, 24, 15,  0 }, {     16,   -9,  135, 24, 15,  0 }, {     16,   -8,  135, 24, 16,  0 }, {     16,   -7,  135, 24, 16,  0 },
    {     16,   -6,  136, 24, 16,  0 }, {     16,   -5,  136, 24, 16,  0 }, {     16,   -4,  136, 24, 16,  0 }, {     16,   -3,  136, 24, 16,  0 }, {     16,   -2,  136, 24, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E7AFA, {
    {     31,   16,   16, 16, 16,  0 }, {     30,   16,   16, 16, 16,  0 }, {     29,   16,   16, 16, 16,  0 }, {     28,   16,   16, 16, 16,  0 }, {     27,   16,   16, 16, 16,  0 },
    {     26,   16,   16, 16, 23,  0 }, {     25,   16,   15, 16, 23,  0 }, {     24,   16,   15, 16, 23,  0 }, {     23,   16,   15, 16, 23,  0 }, {     22,   16,   14, 16, 23,  0 },
    {     21,   16,   14, 16, 22,  0 }, {     20,   16,   13, 16, 22,  0 }, {     19,   16,   12, 16, 22,  0 }, {     18,   16,   11, 16, 22,  0 }, {     17,   16,   10, 16, 22,  0 },
    {     16,   16,   10, 16, 21,  0 }, {     15,   16,    9, 16, 21,  0 }, {     14,   16,    8, 16, 21,  0 }, {     13,   16,    7, 16, 21,  0 }, {     12,   16,    6, 16, 21,  0 },
    {     11,   16,    5, 16, 21,  0 }, {     10,   16,    4, 16, 21,  0 }, {     10,   16,    3, 16, 21,  0 }, {      9,   16,    2, 16, 20,  0 }, {      8,   16,    1, 16, 20,  0 },
    {      8,   16,    0, 16, 20,  0 }, {      7,   16,   -1, 16, 20,  0 }, {      7,   16,   -2, 16, 20,  0 }, {      6,   16,   -3, 16, 20,  0 }, {      6,   16,   -4, 16, 20,  0 },
    {      6,   16,   -5, 16, 20,  0 }, {      5,   16,   -6, 16, 20,  0 }, {      5,   16,   -7, 16, 19,  0 }, {      4,   16,   -8, 16, 19,  0 }, {      4,   16,   -9, 16, 19,  0 },
    {      3,   16,  -10, 16, 19,  0 }, {      3,   16,  -11, 16, 19,  0 }, {      3,   16,  -12, 16, 19,  0 }, {      2,   16,  -13, 16, 19,  0 }, {      2,   16,  -14, 16, 19,  0 },
    {      2,   16,  -15, 16, 19,  0 }, {      2,   16,  -16, 16, 19,  0 }, {      1,   16,  -17, 16, 19,  0 }, {      1,   16,  -18, 16, 19,  0 }, {      1,   16,  -19, 16, 19,  0 },
    {      1,   16,  -20, 16, 19,  0 }, {      1,   16,  -21, 16, 18,  0 }, {      0,   16,  -22, 16, 18,  0 }, {      0,   16,  -23, 16, 18,  0 }, {      0,   16,  -24, 16, 18,  0 },
    {      0,   16,  -25, 16, 18,  0 }, {      0,   16,  -26, 16, 18,  0 }, {      0,   16,  -27, 16, 18,  0 }, {      0,   16,  -28, 16, 18,  0 }, {      0,   16,  -29, 16, 18,  0 },
    {      0,   16,  -30, 16, 18,  0 }, {      0,   16,  -31, 16, 18,  0 }, {      0,   16,  -32, 16, 18,  0 }, {      0,   16,  -33, 16, 18,  0 }, {      0,   16,  -34, 16, 18,  0 },
    {      0,   16,  -35, 16, 18,  0 }, {      0,   16,  -36, 16, 18,  0 }, {      0,   16,  -37, 16, 18,  0 }, {      0,   16,  -38, 16, 18,  0 }, {      0,   16,  -39, 16, 18,  0 },
    {      0,   16,  -40, 16, 18,  0 }, {      0,   16,  -41, 16, 18,  0 }, {      0,   16,  -42, 16, 18,  0 }, {      0,   16,  -43, 16, 18,  0 }, {      0,   16,  -44, 16, 18,  0 },
    {      0,   16,  -45, 16, 18,  0 }, {      0,   16,  -46, 16, 18,  0 }, {      0,   16,  -47, 16, 18,  0 }, {      0,   16,  -48, 16, 18,  0 }, {      0,   16,  -49, 16, 18,  0 },
    {      1,   16,  -50, 16, 18,  0 }, {      1,   16,  -51, 16, 18,  0 }, {      1,   16,  -52, 16, 18,  0 }, {      1,   16,  -53, 16, 18,  0 }, {      1,   16,  -54, 16, 17,  0 },
    {      2,   16,  -55, 16, 17,  0 }, {      2,   16,  -56, 16, 17,  0 }, {      2,   16,  -57, 16, 17,  0 }, {      2,   16,  -58, 16, 17,  0 }, {      3,   16,  -59, 16, 17,  0 },
    {      3,   16,  -60, 16, 17,  0 }, {      3,   16,  -61, 16, 17,  0 }, {      4,   16,  -62, 16, 17,  0 }, {      4,   16,  -63, 16, 17,  0 }, {      4,   16,  -64, 16, 17,  0 },
    {      5,   16,  -65, 16, 17,  0 }, {      5,   16,  -66, 16, 17,  0 }, {      5,   16,  -67, 16, 17,  0 }, {      6,   16,  -68, 16, 17,  0 }, {      6,   16,  -69, 16, 17,  0 },
    {      6,   16,  -70, 16, 17,  0 }, {      7,   16,  -71, 16, 17,  0 }, {      7,   16,  -72, 16, 17,  0 }, {      7,   16,  -73, 16, 17,  0 }, {      8,   16,  -74, 16, 17,  0 },
    {      8,   16,  -75, 16,  8,  0 }, {      9,   16,  -76, 16,  8,  0 }, {     10,   16,  -77, 16,  8,  0 }, {     10,   16,  -78, 16,  8,  0 }, {     11,   16,  -79, 16,  8,  0 },
    {     12,   16,  -80, 16,  8,  0 }, {     12,   16,  -81, 16,  8,  0 }, {     13,   16,  -82, 16,  8,  0 }, {     13,   16,  -83, 16,  8,  0 }, {     14,   16,  -84, 16,  8,  0 },
    {     15,   16,  -85, 16,  8,  0 }, {     16,   16,  -86, 16,  8,  0 }, {     16,   16,  -87, 16,  8,  0 }, {     17,   16,  -88, 16,  8,  0 }, {     18,   16,  -89, 16,  8,  0 },
    {     19,   16,  -90, 16,  8,  0 }, {     19,   16,  -91, 16,  7,  0 }, {     20,   16,  -92, 16,  7,  0 }, {     21,   16,  -93, 16,  7,  0 }, {     22,   16,  -94, 16,  7,  0 },
    {     23,   16,  -95, 16,  7,  0 }, {     24,   16,  -96, 16,  7,  0 }, {     25,   16,  -97, 16,  7,  0 }, {     26,   16,  -98, 16,  7,  0 }, {     27,   16,  -99, 16,  7,  0 },
    {     28,   16, -100, 16,  7,  0 }, {     29,   16, -101, 16,  7,  0 }, {     30,   16, -102, 16,  7,  0 }, {     31,   16, -102, 16,  7,  0 }, {     32,   16, -103, 16,  7,  0 },
    {     33,   16, -104, 16,  7,  0 }, {     34,   16, -105, 16,  7,  0 }, {     35,   16, -105, 16,  7,  0 }, {     36,   16, -106, 16,  7,  0 }, {     37,   16, -107, 16,  7,  0 },
    {     38,   16, -108, 16,  7,  0 }, {     39,   16, -109, 16,  7,  0 }, {     40,   16, -109, 16,  7,  0 }, {     41,   16, -110, 16,  7,  0 }, {     42,   16, -110, 16,  6,  0 },
    {     43,   16, -111, 16,  6,  0 }, {     44,   16, -111, 16,  6,  0 }, {     45,   16, -112, 16,  6,  0 }, {     46,   16, -112, 16,  6,  0 }, {     47,   16, -113, 16,  6,  0 },
    {     48,   16, -113, 16,  6,  0 }, {     49,   16, -114, 16,  6,  0 }, {     50,   16, -114, 16,  6,  0 }, {     51,   16, -115, 16,  6,  0 }, {     52,   16, -115, 16,  6,  0 },
    {     53,   16, -116, 16,  6,  0 }, {     54,   16, -116, 16,  6,  0 }, {     55,   16, -117, 16,  6,  0 }, {     56,   16, -117, 16,  6,  0 }, {     57,   16, -117, 16,  6,  0 },
    {     58,   16, -118, 16,  6,  0 }, {     59,   16, -118, 16,  6,  0 }, {     60,   16, -119, 16,  6,  0 }, {     61,   16, -119, 16,  6,  0 }, {     62,   16, -120, 16,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E80A5, {
    {     16,    0,   16, 24, 16,  0 }, {     16,    1,   16, 24, 16,  0 }, {     16,    2,   16, 24, 16,  0 }, {     16,    3,   16, 24, 16,  0 }, {     16,    4,   16, 24, 16,  0 },
    {     16,    5,   16, 24, 23,  0 }, {     16,    6,   15, 24, 23,  0 }, {     16,    7,   15, 24, 23,  0 }, {     16,    8,   15, 24, 23,  0 }, {     16,    9,   14, 24, 23,  0 },
    {     16,   10,   14, 24, 22,  0 }, {     16,   11,   13, 24, 22,  0 }, {     16,   12,   12, 24, 22,  0 }, {     16,   13,   11, 24, 22,  0 }, {     16,   14,   10, 24, 22,  0 },
    {     16,   15,   10, 24, 21,  0 }, {     16,   16,    9, 24, 21,  0 }, {     16,   17,    8, 24, 21,  0 }, {     16,   18,    7, 24, 21,  0 }, {     16,   19,    6, 24, 21,  0 },
    {     16,   20,    5, 24, 21,  0 }, {     16,   21,    4, 24, 21,  0 }, {     16,   21,    3, 24, 21,  0 }, {     16,   22,    2, 24, 20,  0 }, {     16,   23,    1, 24, 20,  0 },
    {     16,   23,    0, 24, 20,  0 }, {     16,   24,   -1, 24, 20,  0 }, {     16,   24,   -2, 24, 20,  0 }, {     16,   25,   -3, 24, 20,  0 }, {     16,   25,   -4, 24, 20,  0 },
    {     16,   25,   -5, 24, 20,  0 }, {     16,   26,   -6, 24, 20,  0 }, {     16,   26,   -7, 24, 19,  0 }, {     16,   27,   -8, 24, 19,  0 }, {     16,   27,   -9, 24, 19,  0 },
    {     16,   28,  -10, 24, 19,  0 }, {     16,   28,  -11, 24, 19,  0 }, {     16,   28,  -12, 24, 19,  0 }, {     16,   29,  -13, 24, 19,  0 }, {     16,   29,  -14, 24, 19,  0 },
    {     16,   29,  -15, 24, 19,  0 }, {     16,   29,  -16, 24, 19,  0 }, {     16,   30,  -17, 24, 19,  0 }, {     16,   30,  -18, 24, 19,  0 }, {     16,   30,  -19, 24, 19,  0 },
    {     16,   30,  -20, 24, 19,  0 }, {     16,   30,  -21, 24, 18,  0 }, {     16,   31,  -22, 24, 18,  0 }, {     16,   31,  -23, 24, 18,  0 }, {     16,   31,  -24, 24, 18,  0 },
    {     16,   31,  -25, 24, 18,  0 }, {     16,   31,  -26, 24, 18,  0 }, {     16,   31,  -27, 24, 18,  0 }, {     16,   31,  -28, 24, 18,  0 }, {     16,   31,  -29, 24, 18,  0 },
    {     16,   31,  -30, 24, 18,  0 }, {     16,   31,  -31, 24, 18,  0 }, {     16,   31,  -32, 24, 18,  0 }, {     16,   31,  -33, 24, 18,  0 }, {     16,   31,  -34, 24, 18,  0 },
    {     16,   31,  -35, 24, 18,  0 }, {     16,   31,  -36, 24, 18,  0 }, {     16,   31,  -37, 24, 18,  0 }, {     16,   31,  -38, 24, 18,  0 }, {     16,   31,  -39, 24, 18,  0 },
    {     16,   31,  -40, 24, 18,  0 }, {     16,   31,  -41, 24, 18,  0 }, {     16,   31,  -42, 24, 18,  0 }, {     16,   31,  -43, 24, 18,  0 }, {     16,   31,  -44, 24, 18,  0 },
    {     16,   31,  -45, 24, 18,  0 }, {     16,   31,  -46, 24, 18,  0 }, {     16,   31,  -47, 24, 18,  0 }, {     16,   31,  -48, 24, 18,  0 }, {     16,   31,  -49, 24, 18,  0 },
    {     16,   30,  -50, 24, 18,  0 }, {     16,   30,  -51, 24, 18,  0 }, {     16,   30,  -52, 24, 18,  0 }, {     16,   30,  -53, 24, 18,  0 }, {     16,   30,  -54, 24, 17,  0 },
    {     16,   29,  -55, 24, 17,  0 }, {     16,   29,  -56, 24, 17,  0 }, {     16,   29,  -57, 24, 17,  0 }, {     16,   29,  -58, 24, 17,  0 }, {     16,   28,  -59, 24, 17,  0 },
    {     16,   28,  -60, 24, 17,  0 }, {     16,   28,  -61, 24, 17,  0 }, {     16,   27,  -62, 24, 17,  0 }, {     16,   27,  -63, 24, 17,  0 }, {     16,   27,  -64, 24, 17,  0 },
    {     16,   26,  -65, 24, 17,  0 }, {     16,   26,  -66, 24, 17,  0 }, {     16,   26,  -67, 24, 17,  0 }, {     16,   25,  -68, 24, 17,  0 }, {     16,   25,  -69, 24, 17,  0 },
    {     16,   25,  -70, 24, 17,  0 }, {     16,   24,  -71, 24, 17,  0 }, {     16,   24,  -72, 24, 17,  0 }, {     16,   24,  -73, 24, 17,  0 }, {     16,   23,  -74, 24, 17,  0 },
    {     16,   23,  -75, 24,  8,  0 }, {     16,   22,  -76, 24,  8,  0 }, {     16,   21,  -77, 24,  8,  0 }, {     16,   21,  -78, 24,  8,  0 }, {     16,   20,  -79, 24,  8,  0 },
    {     16,   19,  -80, 24,  8,  0 }, {     16,   19,  -81, 24,  8,  0 }, {     16,   18,  -82, 24,  8,  0 }, {     16,   18,  -83, 24,  8,  0 }, {     16,   17,  -84, 24,  8,  0 },
    {     16,   16,  -85, 24,  8,  0 }, {     16,   15,  -86, 24,  8,  0 }, {     16,   15,  -87, 24,  8,  0 }, {     16,   14,  -88, 24,  8,  0 }, {     16,   13,  -89, 24,  8,  0 },
    {     16,   12,  -90, 24,  8,  0 }, {     16,   12,  -91, 24,  7,  0 }, {     16,   11,  -92, 24,  7,  0 }, {     16,   10,  -93, 24,  7,  0 }, {     16,    9,  -94, 24,  7,  0 },
    {     16,    8,  -95, 24,  7,  0 }, {     16,    7,  -96, 24,  7,  0 }, {     16,    6,  -97, 24,  7,  0 }, {     16,    5,  -98, 24,  7,  0 }, {     16,    4,  -99, 24,  7,  0 },
    {     16,    3, -100, 24,  7,  0 }, {     16,    2, -101, 24,  7,  0 }, {     16,    1, -102, 24,  7,  0 }, {     16,    0, -102, 24,  7,  0 }, {     16,   -1, -103, 24,  7,  0 },
    {     16,   -2, -104, 24,  7,  0 }, {     16,   -3, -105, 24,  7,  0 }, {     16,   -4, -105, 24,  7,  0 }, {     16,   -5, -106, 24,  7,  0 }, {     16,   -6, -107, 24,  7,  0 },
    {     16,   -7, -108, 24,  7,  0 }, {     16,   -8, -109, 24,  7,  0 }, {     16,   -9, -109, 24,  7,  0 }, {     16,  -10, -110, 24,  7,  0 }, {     16,  -11, -110, 24,  6,  0 },
    {     16,  -12, -111, 24,  6,  0 }, {     16,  -13, -111, 24,  6,  0 }, {     16,  -14, -112, 24,  6,  0 }, {     16,  -15, -112, 24,  6,  0 }, {     16,  -16, -113, 24,  6,  0 },
    {     16,  -17, -113, 24,  6,  0 }, {     16,  -18, -114, 24,  6,  0 }, {     16,  -19, -114, 24,  6,  0 }, {     16,  -20, -115, 24,  6,  0 }, {     16,  -21, -115, 24,  6,  0 },
    {     16,  -22, -116, 24,  6,  0 }, {     16,  -23, -116, 24,  6,  0 }, {     16,  -24, -117, 24,  6,  0 }, {     16,  -25, -117, 24,  6,  0 }, {     16,  -26, -117, 24,  6,  0 },
    {     16,  -27, -118, 24,  6,  0 }, {     16,  -28, -118, 24,  6,  0 }, {     16,  -29, -119, 24,  6,  0 }, {     16,  -30, -119, 24,  6,  0 }, {     16,  -31, -120, 24,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E8650, {
    {      0,   16,   16,  0, 16,  0 }, {      1,   16,   16,  0, 16,  0 }, {      2,   16,   16,  0, 16,  0 }, {      3,   16,   16,  0, 16,  0 }, {      4,   16,   16,  0, 16,  0 },
    {      5,   16,   16,  0, 23,  0 }, {      6,   16,   15,  0, 23,  0 }, {      7,   16,   15,  0, 23,  0 }, {      8,   16,   15,  0, 23,  0 }, {      9,   16,   14,  0, 23,  0 },
    {     10,   16,   14,  0, 22,  0 }, {     11,   16,   13,  0, 22,  0 }, {     12,   16,   12,  0, 22,  0 }, {     13,   16,   11,  0, 22,  0 }, {     14,   16,   10,  0, 22,  0 },
    {     15,   16,   10,  0, 21,  0 }, {     16,   16,    9,  0, 21,  0 }, {     17,   16,    8,  0, 21,  0 }, {     18,   16,    7,  0, 21,  0 }, {     19,   16,    6,  0, 21,  0 },
    {     20,   16,    5,  0, 21,  0 }, {     21,   16,    4,  0, 21,  0 }, {     21,   16,    3,  0, 21,  0 }, {     22,   16,    2,  0, 20,  0 }, {     23,   16,    1,  0, 20,  0 },
    {     23,   16,    0,  0, 20,  0 }, {     24,   16,   -1,  0, 20,  0 }, {     24,   16,   -2,  0, 20,  0 }, {     25,   16,   -3,  0, 20,  0 }, {     25,   16,   -4,  0, 20,  0 },
    {     25,   16,   -5,  0, 20,  0 }, {     26,   16,   -6,  0, 20,  0 }, {     26,   16,   -7,  0, 19,  0 }, {     27,   16,   -8,  0, 19,  0 }, {     27,   16,   -9,  0, 19,  0 },
    {     28,   16,  -10,  0, 19,  0 }, {     28,   16,  -11,  0, 19,  0 }, {     28,   16,  -12,  0, 19,  0 }, {     29,   16,  -13,  0, 19,  0 }, {     29,   16,  -14,  0, 19,  0 },
    {     29,   16,  -15,  0, 19,  0 }, {     29,   16,  -16,  0, 19,  0 }, {     30,   16,  -17,  0, 19,  0 }, {     30,   16,  -18,  0, 19,  0 }, {     30,   16,  -19,  0, 19,  0 },
    {     30,   16,  -20,  0, 19,  0 }, {     30,   16,  -21,  0, 18,  0 }, {     31,   16,  -22,  0, 18,  0 }, {     31,   16,  -23,  0, 18,  0 }, {     31,   16,  -24,  0, 18,  0 },
    {     31,   16,  -25,  0, 18,  0 }, {     31,   16,  -26,  0, 18,  0 }, {     31,   16,  -27,  0, 18,  0 }, {     31,   16,  -28,  0, 18,  0 }, {     31,   16,  -29,  0, 18,  0 },
    {     31,   16,  -30,  0, 18,  0 }, {     31,   16,  -31,  0, 18,  0 }, {     31,   16,  -32,  0, 18,  0 }, {     31,   16,  -33,  0, 18,  0 }, {     31,   16,  -34,  0, 18,  0 },
    {     31,   16,  -35,  0, 18,  0 }, {     31,   16,  -36,  0, 18,  0 }, {     31,   16,  -37,  0, 18,  0 }, {     31,   16,  -38,  0, 18,  0 }, {     31,   16,  -39,  0, 18,  0 },
    {     31,   16,  -40,  0, 18,  0 }, {     31,   16,  -41,  0, 18,  0 }, {     31,   16,  -42,  0, 18,  0 }, {     31,   16,  -43,  0, 18,  0 }, {     31,   16,  -44,  0, 18,  0 },
    {     31,   16,  -45,  0, 18,  0 }, {     31,   16,  -46,  0, 18,  0 }, {     31,   16,  -47,  0, 18,  0 }, {     31,   16,  -48,  0, 18,  0 }, {     31,   16,  -49,  0, 18,  0 },
    {     30,   16,  -50,  0, 18,  0 }, {     30,   16,  -51,  0, 18,  0 }, {     30,   16,  -52,  0, 18,  0 }, {     30,   16,  -53,  0, 18,  0 }, {     30,   16,  -54,  0, 17,  0 },
    {     29,   16,  -55,  0, 17,  0 }, {     29,   16,  -56,  0, 17,  0 }, {     29,   16,  -57,  0, 17,  0 }, {     29,   16,  -58,  0, 17,  0 }, {     28,   16,  -59,  0, 17,  0 },
    {     28,   16,  -60,  0, 17,  0 }, {     28,   16,  -61,  0, 17,  0 }, {     27,   16,  -62,  0, 17,  0 }, {     27,   16,  -63,  0, 17,  0 }, {     27,   16,  -64,  0, 17,  0 },
    {     26,   16,  -65,  0, 17,  0 }, {     26,   16,  -66,  0, 17,  0 }, {     26,   16,  -67,  0, 17,  0 }, {     25,   16,  -68,  0, 17,  0 }, {     25,   16,  -69,  0, 17,  0 },
    {     25,   16,  -70,  0, 17,  0 }, {     24,   16,  -71,  0, 17,  0 }, {     24,   16,  -72,  0, 17,  0 }, {     24,   16,  -73,  0, 17,  0 }, {     23,   16,  -74,  0, 17,  0 },
    {     23,   16,  -75,  0,  8,  0 }, {     22,   16,  -76,  0,  8,  0 }, {     21,   16,  -77,  0,  8,  0 }, {     21,   16,  -78,  0,  8,  0 }, {     20,   16,  -79,  0,  8,  0 },
    {     19,   16,  -80,  0,  8,  0 }, {     19,   16,  -81,  0,  8,  0 }, {     18,   16,  -82,  0,  8,  0 }, {     18,   16,  -83,  0,  8,  0 }, {     17,   16,  -84,  0,  8,  0 },
    {     16,   16,  -85,  0,  8,  0 }, {     15,   16,  -86,  0,  8,  0 }, {     15,   16,  -87,  0,  8,  0 }, {     14,   16,  -88,  0,  8,  0 }, {     13,   16,  -89,  0,  8,  0 },
    {     12,   16,  -90,  0,  8,  0 }, {     12,   16,  -91,  0,  7,  0 }, {     11,   16,  -92,  0,  7,  0 }, {     10,   16,  -93,  0,  7,  0 }, {      9,   16,  -94,  0,  7,  0 },
    {      8,   16,  -95,  0,  7,  0 }, {      7,   16,  -96,  0,  7,  0 }, {      6,   16,  -97,  0,  7,  0 }, {      5,   16,  -98,  0,  7,  0 }, {      4,   16,  -99,  0,  7,  0 },
    {      3,   16, -100,  0,  7,  0 }, {      2,   16, -101,  0,  7,  0 }, {      1,   16, -102,  0,  7,  0 }, {      0,   16, -102,  0,  7,  0 }, {     -1,   16, -103,  0,  7,  0 },
    {     -2,   16, -104,  0,  7,  0 }, {     -3,   16, -105,  0,  7,  0 }, {     -4,   16, -105,  0,  7,  0 }, {     -5,   16, -106,  0,  7,  0 }, {     -6,   16, -107,  0,  7,  0 },
    {     -7,   16, -108,  0,  7,  0 }, {     -8,   16, -109,  0,  7,  0 }, {     -9,   16, -109,  0,  7,  0 }, {    -10,   16, -110,  0,  7,  0 }, {    -11,   16, -110,  0,  6,  0 },
    {    -12,   16, -111,  0,  6,  0 }, {    -13,   16, -111,  0,  6,  0 }, {    -14,   16, -112,  0,  6,  0 }, {    -15,   16, -112,  0,  6,  0 }, {    -16,   16, -113,  0,  6,  0 },
    {    -17,   16, -113,  0,  6,  0 }, {    -18,   16, -114,  0,  6,  0 }, {    -19,   16, -114,  0,  6,  0 }, {    -20,   16, -115,  0,  6,  0 }, {    -21,   16, -115,  0,  6,  0 },
    {    -22,   16, -116,  0,  6,  0 }, {    -23,   16, -116,  0,  6,  0 }, {    -24,   16, -117,  0,  6,  0 }, {    -25,   16, -117,  0,  6,  0 }, {    -26,   16, -117,  0,  6,  0 },
    {    -27,   16, -118,  0,  6,  0 }, {    -28,   16, -118,  0,  6,  0 }, {    -29,   16, -119,  0,  6,  0 }, {    -30,   16, -119,  0,  6,  0 }, {    -31,   16, -120,  0,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E8BFB, {
    {     16,   31,   16,  8, 16,  0 }, {     16,   30,   16,  8, 16,  0 }, {     16,   29,   16,  8, 16,  0 }, {     16,   28,   16,  8, 16,  0 }, {     16,   27,   16,  8, 16,  0 },
    {     16,   26,   16,  8, 23,  0 }, {     16,   25,   15,  8, 23,  0 }, {     16,   24,   15,  8, 23,  0 }, {     16,   23,   15,  8, 23,  0 }, {     16,   22,   14,  8, 23,  0 },
    {     16,   21,   14,  8, 22,  0 }, {     16,   20,   13,  8, 22,  0 }, {     16,   19,   12,  8, 22,  0 }, {     16,   18,   11,  8, 22,  0 }, {     16,   17,   10,  8, 22,  0 },
    {     16,   16,   10,  8, 21,  0 }, {     16,   15,    9,  8, 21,  0 }, {     16,   14,    8,  8, 21,  0 }, {     16,   13,    7,  8, 21,  0 }, {     16,   12,    6,  8, 21,  0 },
    {     16,   11,    5,  8, 21,  0 }, {     16,   10,    4,  8, 21,  0 }, {     16,   10,    3,  8, 21,  0 }, {     16,    9,    2,  8, 20,  0 }, {     16,    8,    1,  8, 20,  0 },
    {     16,    8,    0,  8, 20,  0 }, {     16,    7,   -1,  8, 20,  0 }, {     16,    7,   -2,  8, 20,  0 }, {     16,    6,   -3,  8, 20,  0 }, {     16,    6,   -4,  8, 20,  0 },
    {     16,    6,   -5,  8, 20,  0 }, {     16,    5,   -6,  8, 20,  0 }, {     16,    5,   -7,  8, 19,  0 }, {     16,    4,   -8,  8, 19,  0 }, {     16,    4,   -9,  8, 19,  0 },
    {     16,    3,  -10,  8, 19,  0 }, {     16,    3,  -11,  8, 19,  0 }, {     16,    3,  -12,  8, 19,  0 }, {     16,    2,  -13,  8, 19,  0 }, {     16,    2,  -14,  8, 19,  0 },
    {     16,    2,  -15,  8, 19,  0 }, {     16,    2,  -16,  8, 19,  0 }, {     16,    1,  -17,  8, 19,  0 }, {     16,    1,  -18,  8, 19,  0 }, {     16,    1,  -19,  8, 19,  0 },
    {     16,    1,  -20,  8, 19,  0 }, {     16,    1,  -21,  8, 18,  0 }, {     16,    0,  -22,  8, 18,  0 }, {     16,    0,  -23,  8, 18,  0 }, {     16,    0,  -24,  8, 18,  0 },
    {     16,    0,  -25,  8, 18,  0 }, {     16,    0,  -26,  8, 18,  0 }, {     16,    0,  -27,  8, 18,  0 }, {     16,    0,  -28,  8, 18,  0 }, {     16,    0,  -29,  8, 18,  0 },
    {     16,    0,  -30,  8, 18,  0 }, {     16,    0,  -31,  8, 18,  0 }, {     16,    0,  -32,  8, 18,  0 }, {     16,    0,  -33,  8, 18,  0 }, {     16,    0,  -34,  8, 18,  0 },
    {     16,    0,  -35,  8, 18,  0 }, {     16,    0,  -36,  8, 18,  0 }, {     16,    0,  -37,  8, 18,  0 }, {     16,    0,  -38,  8, 18,  0 }, {     16,    0,  -39,  8, 18,  0 },
    {     16,    0,  -40,  8, 18,  0 }, {     16,    0,  -41,  8, 18,  0 }, {     16,    0,  -42,  8, 18,  0 }, {     16,    0,  -43,  8, 18,  0 }, {     16,    0,  -44,  8, 18,  0 },
    {     16,    0,  -45,  8, 18,  0 }, {     16,    0,  -46,  8, 18,  0 }, {     16,    0,  -47,  8, 18,  0 }, {     16,    0,  -48,  8, 18,  0 }, {     16,    0,  -49,  8, 18,  0 },
    {     16,    1,  -50,  8, 18,  0 }, {     16,    1,  -51,  8, 18,  0 }, {     16,    1,  -52,  8, 18,  0 }, {     16,    1,  -53,  8, 18,  0 }, {     16,    1,  -54,  8, 17,  0 },
    {     16,    2,  -55,  8, 17,  0 }, {     16,    2,  -56,  8, 17,  0 }, {     16,    2,  -57,  8, 17,  0 }, {     16,    2,  -58,  8, 17,  0 }, {     16,    3,  -59,  8, 17,  0 },
    {     16,    3,  -60,  8, 17,  0 }, {     16,    3,  -61,  8, 17,  0 }, {     16,    4,  -62,  8, 17,  0 }, {     16,    4,  -63,  8, 17,  0 }, {     16,    4,  -64,  8, 17,  0 },
    {     16,    5,  -65,  8, 17,  0 }, {     16,    5,  -66,  8, 17,  0 }, {     16,    5,  -67,  8, 17,  0 }, {     16,    6,  -68,  8, 17,  0 }, {     16,    6,  -69,  8, 17,  0 },
    {     16,    6,  -70,  8, 17,  0 }, {     16,    7,  -71,  8, 17,  0 }, {     16,    7,  -72,  8, 17,  0 }, {     16,    7,  -73,  8, 17,  0 }, {     16,    8,  -74,  8, 17,  0 },
    {     16,    8,  -75,  8,  8,  0 }, {     16,    9,  -76,  8,  8,  0 }, {     16,   10,  -77,  8,  8,  0 }, {     16,   10,  -78,  8,  8,  0 }, {     16,   11,  -79,  8,  8,  0 },
    {     16,   12,  -80,  8,  8,  0 }, {     16,   12,  -81,  8,  8,  0 }, {     16,   13,  -82,  8,  8,  0 }, {     16,   13,  -83,  8,  8,  0 }, {     16,   14,  -84,  8,  8,  0 },
    {     16,   15,  -85,  8,  8,  0 }, {     16,   16,  -86,  8,  8,  0 }, {     16,   16,  -87,  8,  8,  0 }, {     16,   17,  -88,  8,  8,  0 }, {     16,   18,  -89,  8,  8,  0 },
    {     16,   19,  -90,  8,  8,  0 }, {     16,   19,  -91,  8,  7,  0 }, {     16,   20,  -92,  8,  7,  0 }, {     16,   21,  -93,  8,  7,  0 }, {     16,   22,  -94,  8,  7,  0 },
    {     16,   23,  -95,  8,  7,  0 }, {     16,   24,  -96,  8,  7,  0 }, {     16,   25,  -97,  8,  7,  0 }, {     16,   26,  -98,  8,  7,  0 }, {     16,   27,  -99,  8,  7,  0 },
    {     16,   28, -100,  8,  7,  0 }, {     16,   29, -101,  8,  7,  0 }, {     16,   30, -102,  8,  7,  0 }, {     16,   31, -102,  8,  7,  0 }, {     16,   32, -103,  8,  7,  0 },
    {     16,   33, -104,  8,  7,  0 }, {     16,   34, -105,  8,  7,  0 }, {     16,   35, -105,  8,  7,  0 }, {     16,   36, -106,  8,  7,  0 }, {     16,   37, -107,  8,  7,  0 },
    {     16,   38, -108,  8,  7,  0 }, {     16,   39, -109,  8,  7,  0 }, {     16,   40, -109,  8,  7,  0 }, {     16,   41, -110,  8,  7,  0 }, {     16,   42, -110,  8,  6,  0 },
    {     16,   43, -111,  8,  6,  0 }, {     16,   44, -111,  8,  6,  0 }, {     16,   45, -112,  8,  6,  0 }, {     16,   46, -112,  8,  6,  0 }, {     16,   47, -113,  8,  6,  0 },
    {     16,   48, -113,  8,  6,  0 }, {     16,   49, -114,  8,  6,  0 }, {     16,   50, -114,  8,  6,  0 }, {     16,   51, -115,  8,  6,  0 }, {     16,   52, -115,  8,  6,  0 },
    {     16,   53, -116,  8,  6,  0 }, {     16,   54, -116,  8,  6,  0 }, {     16,   55, -117,  8,  6,  0 }, {     16,   56, -117,  8,  6,  0 }, {     16,   57, -117,  8,  6,  0 },
    {     16,   58, -118,  8,  6,  0 }, {     16,   59, -118,  8,  6,  0 }, {     16,   60, -119,  8,  6,  0 }, {     16,   61, -119,  8,  6,  0 }, {     16,   62, -120,  8,  6,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EA852, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    1,  0,  0,  0 }, {     24,   16,    1,  0,  0,  0 }, {     23,   16,    1,  0, 34,  0 }, {     22,   16,    1,  0, 34,  0 },
    {     21,   16,    1,  0, 34,  0 }, {     20,   16,    2,  0, 34,  0 }, {     19,   16,    2,  0, 34,  0 }, {     18,   16,    2,  0, 34,  0 }, {     17,   16,    3,  0, 34,  0 },
    {     16,   16,    3,  0, 34,  0 }, {     15,   16,    4,  0, 34,  0 }, {     14,   16,    4,  0, 34,  0 }, {     13,   16,    5,  0, 34,  0 }, {     12,   16,    5,  0, 34,  0 },
    {     11,   16,    6,  0, 34,  0 }, {     10,   16,    6,  0, 34,  0 }, {      9,   16,    7,  0, 34,  0 }, {      8,   16,    8,  0, 34,  0 }, {      7,   16,    9,  0, 35,  0 },
    {      6,   16,    9,  0, 35,  0 }, {      5,   15,   10,  0, 35,  0 }, {      4,   15,   11,  0, 35,  0 }, {      3,   15,   12,  0, 35,  0 }, {      2,   15,   13,  0, 35,  0 },
    {      1,   15,   14,  0, 35,  0 }, {      0,   15,   15,  0, 35,  0 }, {     -1,   14,   16,  0, 35,  0 }, {     -2,   14,   17,  0, 35,  0 }, {     -2,   14,   18,  0, 35,  0 },
    {     -3,   14,   19,  0, 35,  0 }, {     -4,   14,   20,  0, 35,  0 }, {     -5,   13,   21,  0, 35,  0 }, {     -5,   13,   22,  0, 35,  0 }, {     -6,   13,   23,  0, 35,  0 },
    {     -6,   12,   24,  0, 36,  0 }, {     -7,   12,   25,  0, 36,  0 }, {     -8,   12,   26,  0, 36,  0 }, {     -8,   12,   27,  0, 36,  0 }, {     -9,   11,   28,  0, 36,  0 },
    {     -9,   11,   29,  0, 36,  0 }, {    -10,   10,   30,  0, 36,  0 }, {    -10,   10,   31,  0, 36,  0 }, {    -11,   10,   32,  0, 36,  0 }, {    -11,    9,   33,  0, 36,  0 },
    {    -11,    9,   34,  0, 36,  0 }, {    -12,    8,   35,  0, 36,  0 }, {    -12,    8,   36,  0, 36,  0 }, {    -13,    7,   37,  0, 36,  0 }, {    -13,    7,   38,  0, 36,  0 },
    {    -13,    6,   39,  0, 36,  0 }, {    -13,    5,   40,  0, 36,  0 }, {    -14,    5,   41,  0, 37,  0 }, {    -14,    4,   42,  0, 37,  0 }, {    -14,    4,   43,  0, 37,  0 },
    {    -15,    3,   44,  0, 37,  0 }, {    -15,    2,   45,  0, 37,  0 }, {    -15,    1,   46,  0, 37,  0 }, {    -15,    1,   47,  0, 37,  0 }, {    -15,    0,   48,  0, 37,  0 },
    {    -16,   -1,   49,  0, 37,  0 }, {    -16,   -2,   50,  0, 37,  0 }, {    -16,   -3,   51,  0, 37,  0 }, {    -16,   -4,   52,  0, 37,  0 }, {    -16,   -5,   53,  0, 37,  0 },
    {    -16,   -6,   54,  0, 37,  0 }, {    -17,   -7,   55,  0, 37,  0 }, {    -17,   -8,   55,  0, 37,  0 }, {    -17,   -9,   56,  0, 38,  0 }, {    -17,  -10,   57,  0, 38,  0 },
    {    -17,  -11,   58,  0, 38,  0 }, {    -17,  -12,   58,  0, 38,  0 }, {    -17,  -13,   59,  0, 38,  0 }, {    -17,  -14,   59,  0, 38,  0 }, {    -17,  -15,   60,  0, 38,  0 },
    {    -17,  -16,   60,  0, 38,  0 }, {    -17,  -17,   61,  0, 38,  0 }, {    -17,  -18,   61,  0, 38,  0 }, {    -17,  -19,   62,  0, 38,  0 }, {    -17,  -20,   62,  0, 38,  0 },
    {    -17,  -21,   62,  0, 38,  0 }, {    -17,  -22,   63,  0, 38,  0 }, {    -17,  -23,   63,  0, 38,  0 }, {    -17,  -24,   63,  0, 38,  0 }, {    -17,  -25,   63,  0, 38,  0 },
    {    -17,  -26,   63,  8, 16,  0 }, {    -17,  -27,   64,  8, 16,  0 }, {    -17,  -28,   64,  8, 16,  0 }, {    -17,  -29,   64,  8, 16,  0 }, {    -17,  -30,   64,  8, 16,  0 },
    {    -17,  -31,   64,  8, 16,  0 }, {    -17,  -32,   64,  8, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EABBD, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    1,  8,  0,  0 }, {     16,    7,    1,  8,  0,  0 }, {     16,    8,    1,  8, 34,  0 }, {     16,    9,    1,  8, 34,  0 },
    {     16,   10,    1,  8, 34,  0 }, {     16,   11,    2,  8, 34,  0 }, {     16,   12,    2,  8, 34,  0 }, {     16,   13,    2,  8, 34,  0 }, {     16,   14,    3,  8, 34,  0 },
    {     16,   15,    3,  8, 34,  0 }, {     16,   16,    4,  8, 34,  0 }, {     16,   17,    4,  8, 34,  0 }, {     16,   18,    5,  8, 34,  0 }, {     16,   19,    5,  8, 34,  0 },
    {     16,   20,    6,  8, 34,  0 }, {     16,   21,    6,  8, 34,  0 }, {     16,   22,    7,  8, 34,  0 }, {     16,   23,    8,  8, 34,  0 }, {     16,   24,    9,  8, 35,  0 },
    {     16,   25,    9,  8, 35,  0 }, {     15,   26,   10,  8, 35,  0 }, {     15,   27,   11,  8, 35,  0 }, {     15,   28,   12,  8, 35,  0 }, {     15,   29,   13,  8, 35,  0 },
    {     15,   30,   14,  8, 35,  0 }, {     15,   31,   15,  8, 35,  0 }, {     14,   32,   16,  8, 35,  0 }, {     14,   33,   17,  8, 35,  0 }, {     14,   33,   18,  8, 35,  0 },
    {     14,   34,   19,  8, 35,  0 }, {     14,   35,   20,  8, 35,  0 }, {     13,   36,   21,  8, 35,  0 }, {     13,   36,   22,  8, 35,  0 }, {     13,   37,   23,  8, 35,  0 },
    {     12,   37,   24,  8, 36,  0 }, {     12,   38,   25,  8, 36,  0 }, {     12,   39,   26,  8, 36,  0 }, {     12,   39,   27,  8, 36,  0 }, {     11,   40,   28,  8, 36,  0 },
    {     11,   40,   29,  8, 36,  0 }, {     10,   41,   30,  8, 36,  0 }, {     10,   41,   31,  8, 36,  0 }, {     10,   42,   32,  8, 36,  0 }, {      9,   42,   33,  8, 36,  0 },
    {      9,   42,   34,  8, 36,  0 }, {      8,   43,   35,  8, 36,  0 }, {      8,   43,   36,  8, 36,  0 }, {      7,   44,   37,  8, 36,  0 }, {      7,   44,   38,  8, 36,  0 },
    {      6,   44,   39,  8, 36,  0 }, {      5,   44,   40,  8, 36,  0 }, {      5,   45,   41,  8, 37,  0 }, {      4,   45,   42,  8, 37,  0 }, {      4,   45,   43,  8, 37,  0 },
    {      3,   46,   44,  8, 37,  0 }, {      2,   46,   45,  8, 37,  0 }, {      1,   46,   46,  8, 37,  0 }, {      1,   46,   47,  8, 37,  0 }, {      0,   46,   48,  8, 37,  0 },
    {     -1,   47,   49,  8, 37,  0 }, {     -2,   47,   50,  8, 37,  0 }, {     -3,   47,   51,  8, 37,  0 }, {     -4,   47,   52,  8, 37,  0 }, {     -5,   47,   53,  8, 37,  0 },
    {     -6,   47,   54,  8, 37,  0 }, {     -7,   48,   55,  8, 37,  0 }, {     -8,   48,   55,  8, 37,  0 }, {     -9,   48,   56,  8, 38,  0 }, {    -10,   48,   57,  8, 38,  0 },
    {    -11,   48,   58,  8, 38,  0 }, {    -12,   48,   58,  8, 38,  0 }, {    -13,   48,   59,  8, 38,  0 }, {    -14,   48,   59,  8, 38,  0 }, {    -15,   48,   60,  8, 38,  0 },
    {    -16,   48,   60,  8, 38,  0 }, {    -17,   48,   61,  8, 38,  0 }, {    -18,   48,   61,  8, 38,  0 }, {    -19,   48,   62,  8, 38,  0 }, {    -20,   48,   62,  8, 38,  0 },
    {    -21,   48,   62,  8, 38,  0 }, {    -22,   48,   63,  8, 38,  0 }, {    -23,   48,   63,  8, 38,  0 }, {    -24,   48,   63,  8, 38,  0 }, {    -25,   48,   63,  8, 38,  0 },
    {    -26,   48,   63, 16, 16,  0 }, {    -27,   48,   64, 16, 16,  0 }, {    -28,   48,   64, 16, 16,  0 }, {    -29,   48,   64, 16, 16,  0 }, {    -30,   48,   64, 16, 16,  0 },
    {    -31,   48,   64, 16, 16,  0 }, {    -32,   48,   64, 16, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EAF28, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    1, 16,  0,  0 }, {      7,   16,    1, 16,  0,  0 }, {      8,   16,    1, 16, 34,  0 }, {      9,   16,    1, 16, 34,  0 },
    {     10,   16,    1, 16, 34,  0 }, {     11,   16,    2, 16, 34,  0 }, {     12,   16,    2, 16, 34,  0 }, {     13,   16,    2, 16, 34,  0 }, {     14,   16,    3, 16, 34,  0 },
    {     15,   16,    3, 16, 34,  0 }, {     16,   16,    4, 16, 34,  0 }, {     17,   16,    4, 16, 34,  0 }, {     18,   16,    5, 16, 34,  0 }, {     19,   16,    5, 16, 34,  0 },
    {     20,   16,    6, 16, 34,  0 }, {     21,   16,    6, 16, 34,  0 }, {     22,   16,    7, 16, 34,  0 }, {     23,   16,    8, 16, 34,  0 }, {     24,   16,    9, 16, 35,  0 },
    {     25,   16,    9, 16, 35,  0 }, {     26,   17,   10, 16, 35,  0 }, {     27,   17,   11, 16, 35,  0 }, {     28,   17,   12, 16, 35,  0 }, {     29,   17,   13, 16, 35,  0 },
    {     30,   17,   14, 16, 35,  0 }, {     31,   17,   15, 16, 35,  0 }, {     32,   18,   16, 16, 35,  0 }, {     33,   18,   17, 16, 35,  0 }, {     33,   18,   18, 16, 35,  0 },
    {     34,   18,   19, 16, 35,  0 }, {     35,   18,   20, 16, 35,  0 }, {     36,   19,   21, 16, 35,  0 }, {     36,   19,   22, 16, 35,  0 }, {     37,   19,   23, 16, 35,  0 },
    {     37,   20,   24, 16, 36,  0 }, {     38,   20,   25, 16, 36,  0 }, {     39,   20,   26, 16, 36,  0 }, {     39,   20,   27, 16, 36,  0 }, {     40,   21,   28, 16, 36,  0 },
    {     40,   21,   29, 16, 36,  0 }, {     41,   22,   30, 16, 36,  0 }, {     41,   22,   31, 16, 36,  0 }, {     42,   22,   32, 16, 36,  0 }, {     42,   23,   33, 16, 36,  0 },
    {     42,   23,   34, 16, 36,  0 }, {     43,   24,   35, 16, 36,  0 }, {     43,   24,   36, 16, 36,  0 }, {     44,   25,   37, 16, 36,  0 }, {     44,   25,   38, 16, 36,  0 },
    {     44,   26,   39, 16, 36,  0 }, {     44,   27,   40, 16, 36,  0 }, {     45,   27,   41, 16, 37,  0 }, {     45,   28,   42, 16, 37,  0 }, {     45,   28,   43, 16, 37,  0 },
    {     46,   29,   44, 16, 37,  0 }, {     46,   30,   45, 16, 37,  0 }, {     46,   31,   46, 16, 37,  0 }, {     46,   31,   47, 16, 37,  0 }, {     46,   32,   48, 16, 37,  0 },
    {     47,   33,   49, 16, 37,  0 }, {     47,   34,   50, 16, 37,  0 }, {     47,   35,   51, 16, 37,  0 }, {     47,   36,   52, 16, 37,  0 }, {     47,   37,   53, 16, 37,  0 },
    {     47,   38,   54, 16, 37,  0 }, {     48,   39,   55, 16, 37,  0 }, {     48,   40,   55, 16, 37,  0 }, {     48,   41,   56, 16, 38,  0 }, {     48,   42,   57, 16, 38,  0 },
    {     48,   43,   58, 16, 38,  0 }, {     48,   44,   58, 16, 38,  0 }, {     48,   45,   59, 16, 38,  0 }, {     48,   46,   59, 16, 38,  0 }, {     48,   47,   60, 16, 38,  0 },
    {     48,   48,   60, 16, 38,  0 }, {     48,   49,   61, 16, 38,  0 }, {     48,   50,   61, 16, 38,  0 }, {     48,   51,   62, 16, 38,  0 }, {     48,   52,   62, 16, 38,  0 },
    {     48,   53,   62, 16, 38,  0 }, {     48,   54,   63, 16, 38,  0 }, {     48,   55,   63, 16, 38,  0 }, {     48,   56,   63, 16, 38,  0 }, {     48,   57,   63, 16, 38,  0 },
    {     48,   58,   63, 24, 16,  0 }, {     48,   59,   64, 24, 16,  0 }, {     48,   60,   64, 24, 16,  0 }, {     48,   61,   64, 24, 16,  0 }, {     48,   62,   64, 24, 16,  0 },
    {     48,   63,   64, 24, 16,  0 }, {     48,   64,   64, 24, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB293, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    1, 24,  0,  0 }, {     16,   24,    1, 24,  0,  0 }, {     16,   23,    1, 24, 34,  0 }, {     16,   22,    1, 24, 34,  0 },
    {     16,   21,    1, 24, 34,  0 }, {     16,   20,    2, 24, 34,  0 }, {     16,   19,    2, 24, 34,  0 }, {     16,   18,    2, 24, 34,  0 }, {     16,   17,    3, 24, 34,  0 },
    {     16,   16,    3, 24, 34,  0 }, {     16,   15,    4, 24, 34,  0 }, {     16,   14,    4, 24, 34,  0 }, {     16,   13,    5, 24, 34,  0 }, {     16,   12,    5, 24, 34,  0 },
    {     16,   11,    6, 24, 34,  0 }, {     16,   10,    6, 24, 34,  0 }, {     16,    9,    7, 24, 34,  0 }, {     16,    8,    8, 24, 34,  0 }, {     16,    7,    9, 24, 35,  0 },
    {     16,    6,    9, 24, 35,  0 }, {     17,    5,   10, 24, 35,  0 }, {     17,    4,   11, 24, 35,  0 }, {     17,    3,   12, 24, 35,  0 }, {     17,    2,   13, 24, 35,  0 },
    {     17,    1,   14, 24, 35,  0 }, {     17,    0,   15, 24, 35,  0 }, {     18,   -1,   16, 24, 35,  0 }, {     18,   -2,   17, 24, 35,  0 }, {     18,   -2,   18, 24, 35,  0 },
    {     18,   -3,   19, 24, 35,  0 }, {     18,   -4,   20, 24, 35,  0 }, {     19,   -5,   21, 24, 35,  0 }, {     19,   -5,   22, 24, 35,  0 }, {     19,   -6,   23, 24, 35,  0 },
    {     20,   -6,   24, 24, 36,  0 }, {     20,   -7,   25, 24, 36,  0 }, {     20,   -8,   26, 24, 36,  0 }, {     20,   -8,   27, 24, 36,  0 }, {     21,   -9,   28, 24, 36,  0 },
    {     21,   -9,   29, 24, 36,  0 }, {     22,  -10,   30, 24, 36,  0 }, {     22,  -10,   31, 24, 36,  0 }, {     22,  -11,   32, 24, 36,  0 }, {     23,  -11,   33, 24, 36,  0 },
    {     23,  -11,   34, 24, 36,  0 }, {     24,  -12,   35, 24, 36,  0 }, {     24,  -12,   36, 24, 36,  0 }, {     25,  -13,   37, 24, 36,  0 }, {     25,  -13,   38, 24, 36,  0 },
    {     26,  -13,   39, 24, 36,  0 }, {     27,  -13,   40, 24, 36,  0 }, {     27,  -14,   41, 24, 37,  0 }, {     28,  -14,   42, 24, 37,  0 }, {     28,  -14,   43, 24, 37,  0 },
    {     29,  -15,   44, 24, 37,  0 }, {     30,  -15,   45, 24, 37,  0 }, {     31,  -15,   46, 24, 37,  0 }, {     31,  -15,   47, 24, 37,  0 }, {     32,  -15,   48, 24, 37,  0 },
    {     33,  -16,   49, 24, 37,  0 }, {     34,  -16,   50, 24, 37,  0 }, {     35,  -16,   51, 24, 37,  0 }, {     36,  -16,   52, 24, 37,  0 }, {     37,  -16,   53, 24, 37,  0 },
    {     38,  -16,   54, 24, 37,  0 }, {     39,  -17,   55, 24, 37,  0 }, {     40,  -17,   55, 24, 37,  0 }, {     41,  -17,   56, 24, 38,  0 }, {     42,  -17,   57, 24, 38,  0 },
    {     43,  -17,   58, 24, 38,  0 }, {     44,  -17,   58, 24, 38,  0 }, {     45,  -17,   59, 24, 38,  0 }, {     46,  -17,   59, 24, 38,  0 }, {     47,  -17,   60, 24, 38,  0 },
    {     48,  -17,   60, 24, 38,  0 }, {     49,  -17,   61, 24, 38,  0 }, {     50,  -17,   61, 24, 38,  0 }, {     51,  -17,   62, 24, 38,  0 }, {     52,  -17,   62, 24, 38,  0 },
    {     53,  -17,   62, 24, 38,  0 }, {     54,  -17,   63, 24, 38,  0 }, {     55,  -17,   63, 24, 38,  0 }, {     56,  -17,   63, 24, 38,  0 }, {     57,  -17,   63, 24, 38,  0 },
    {     58,  -17,   63,  0, 16,  0 }, {     59,  -17,   64,  0, 16,  0 }, {     60,  -17,   64,  0, 16,  0 }, {     61,  -17,   64,  0, 16,  0 }, {     62,  -17,   64,  0, 16,  0 },
    {     63,  -17,   64,  0, 16,  0 }, {     64,  -17,   64,  0, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB5FE, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    0,  0,  0,  0 },
    {     26,   16,    0,  0,  0,  0 }, {     25,   16,    1,  0,  0,  0 }, {     24,   16,    1,  0,  0,  0 }, {     23,   16,    1,  0, 24,  0 }, {     22,   16,    1,  0, 24,  0 },
    {     21,   16,    1,  0, 24,  0 }, {     20,   16,    2,  0, 24,  0 }, {     19,   16,    2,  0, 24,  0 }, {     18,   16,    2,  0, 24,  0 }, {     17,   16,    3,  0, 24,  0 },
    {     16,   16,    3,  0, 24,  0 }, {     15,   16,    4,  0, 24,  0 }, {     14,   16,    4,  0, 24,  0 }, {     13,   16,    5,  0, 24,  0 }, {     12,   16,    5,  0, 24,  0 },
    {     11,   16,    6,  0, 24,  0 }, {     10,   16,    6,  0, 24,  0 }, {      9,   16,    7,  0, 24,  0 }, {      8,   16,    8,  0, 24,  0 }, {      7,   16,    9,  0, 25,  0 },
    {      6,   16,    9,  0, 25,  0 }, {      5,   17,   10,  0, 25,  0 }, {      4,   17,   11,  0, 25,  0 }, {      3,   17,   12,  0, 25,  0 }, {      2,   17,   13,  0, 25,  0 },
    {      1,   17,   14,  0, 25,  0 }, {      0,   17,   15,  0, 25,  0 }, {     -1,   18,   16,  0, 25,  0 }, {     -2,   18,   17,  0, 25,  0 }, {     -2,   18,   18,  0, 25,  0 },
    {     -3,   18,   19,  0, 25,  0 }, {     -4,   18,   20,  0, 25,  0 }, {     -5,   19,   21,  0, 25,  0 }, {     -5,   19,   22,  0, 25,  0 }, {     -6,   19,   23,  0, 25,  0 },
    {     -6,   20,   24,  0, 26,  0 }, {     -7,   20,   25,  0, 26,  0 }, {     -8,   20,   26,  0, 26,  0 }, {     -8,   20,   27,  0, 26,  0 }, {     -9,   21,   28,  0, 26,  0 },
    {     -9,   21,   29,  0, 26,  0 }, {    -10,   22,   30,  0, 26,  0 }, {    -10,   22,   31,  0, 26,  0 }, {    -11,   22,   32,  0, 26,  0 }, {    -11,   23,   33,  0, 26,  0 },
    {    -11,   23,   34,  0, 26,  0 }, {    -12,   24,   35,  0, 26,  0 }, {    -12,   24,   36,  0, 26,  0 }, {    -13,   25,   37,  0, 26,  0 }, {    -13,   25,   38,  0, 26,  0 },
    {    -13,   26,   39,  0, 26,  0 }, {    -13,   27,   40,  0, 26,  0 }, {    -14,   27,   41,  0, 27,  0 }, {    -14,   28,   42,  0, 27,  0 }, {    -14,   28,   43,  0, 27,  0 },
    {    -15,   29,   44,  0, 27,  0 }, {    -15,   30,   45,  0, 27,  0 }, {    -15,   31,   46,  0, 27,  0 }, {    -15,   31,   47,  0, 27,  0 }, {    -15,   32,   48,  0, 27,  0 },
    {    -16,   33,   49,  0, 27,  0 }, {    -16,   34,   50,  0, 27,  0 }, {    -16,   35,   51,  0, 27,  0 }, {    -16,   36,   52,  0, 27,  0 }, {    -16,   37,   53,  0, 27,  0 },
    {    -16,   38,   54,  0, 27,  0 }, {    -17,   39,   55,  0, 27,  0 }, {    -17,   40,   55,  0, 27,  0 }, {    -17,   41,   56,  0, 28,  0 }, {    -17,   42,   57,  0, 28,  0 },
    {    -17,   43,   58,  0, 28,  0 }, {    -17,   44,   58,  0, 28,  0 }, {    -17,   45,   59,  0, 28,  0 }, {    -17,   46,   59,  0, 28,  0 }, {    -17,   47,   60,  0, 28,  0 },
    {    -17,   48,   60,  0, 28,  0 }, {    -17,   49,   61,  0, 28,  0 }, {    -17,   50,   61,  0, 28,  0 }, {    -17,   51,   62,  0, 28,  0 }, {    -17,   52,   62,  0, 28,  0 },
    {    -17,   53,   62,  0, 28,  0 }, {    -17,   54,   63,  0, 28,  0 }, {    -17,   55,   63,  0, 28,  0 }, {    -17,   56,   63,  0, 28,  0 }, {    -17,   57,   63,  0, 28,  0 },
    {    -17,   58,   63, 24, 16,  0 }, {    -17,   59,   64, 24, 16,  0 }, {    -17,   60,   64, 24, 16,  0 }, {    -17,   61,   64, 24, 16,  0 }, {    -17,   62,   64, 24, 16,  0 },
    {    -17,   63,   64, 24, 16,  0 }, {    -17,   64,   64, 24, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EB969, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    0,  8,  0,  0 },
    {     16,    5,    0,  8,  0,  0 }, {     16,    6,    1,  8,  0,  0 }, {     16,    7,    1,  8,  0,  0 }, {     16,    8,    1,  8, 24,  0 }, {     16,    9,    1,  8, 24,  0 },
    {     16,   10,    1,  8, 24,  0 }, {     16,   11,    2,  8, 24,  0 }, {     16,   12,    2,  8, 24,  0 }, {     16,   13,    2,  8, 24,  0 }, {     16,   14,    3,  8, 24,  0 },
    {     16,   15,    3,  8, 24,  0 }, {     16,   16,    4,  8, 24,  0 }, {     16,   17,    4,  8, 24,  0 }, {     16,   18,    5,  8, 24,  0 }, {     16,   19,    5,  8, 24,  0 },
    {     16,   20,    6,  8, 24,  0 }, {     16,   21,    6,  8, 24,  0 }, {     16,   22,    7,  8, 24,  0 }, {     16,   23,    8,  8, 24,  0 }, {     16,   24,    9,  8, 25,  0 },
    {     16,   25,    9,  8, 25,  0 }, {     17,   26,   10,  8, 25,  0 }, {     17,   27,   11,  8, 25,  0 }, {     17,   28,   12,  8, 25,  0 }, {     17,   29,   13,  8, 25,  0 },
    {     17,   30,   14,  8, 25,  0 }, {     17,   31,   15,  8, 25,  0 }, {     18,   32,   16,  8, 25,  0 }, {     18,   33,   17,  8, 25,  0 }, {     18,   33,   18,  8, 25,  0 },
    {     18,   34,   19,  8, 25,  0 }, {     18,   35,   20,  8, 25,  0 }, {     19,   36,   21,  8, 25,  0 }, {     19,   36,   22,  8, 25,  0 }, {     19,   37,   23,  8, 25,  0 },
    {     20,   37,   24,  8, 26,  0 }, {     20,   38,   25,  8, 26,  0 }, {     20,   39,   26,  8, 26,  0 }, {     20,   39,   27,  8, 26,  0 }, {     21,   40,   28,  8, 26,  0 },
    {     21,   40,   29,  8, 26,  0 }, {     22,   41,   30,  8, 26,  0 }, {     22,   41,   31,  8, 26,  0 }, {     22,   42,   32,  8, 26,  0 }, {     23,   42,   33,  8, 26,  0 },
    {     23,   42,   34,  8, 26,  0 }, {     24,   43,   35,  8, 26,  0 }, {     24,   43,   36,  8, 26,  0 }, {     25,   44,   37,  8, 26,  0 }, {     25,   44,   38,  8, 26,  0 },
    {     26,   44,   39,  8, 26,  0 }, {     27,   44,   40,  8, 26,  0 }, {     27,   45,   41,  8, 27,  0 }, {     28,   45,   42,  8, 27,  0 }, {     28,   45,   43,  8, 27,  0 },
    {     29,   46,   44,  8, 27,  0 }, {     30,   46,   45,  8, 27,  0 }, {     31,   46,   46,  8, 27,  0 }, {     31,   46,   47,  8, 27,  0 }, {     32,   46,   48,  8, 27,  0 },
    {     33,   47,   49,  8, 27,  0 }, {     34,   47,   50,  8, 27,  0 }, {     35,   47,   51,  8, 27,  0 }, {     36,   47,   52,  8, 27,  0 }, {     37,   47,   53,  8, 27,  0 },
    {     38,   47,   54,  8, 27,  0 }, {     39,   48,   55,  8, 27,  0 }, {     40,   48,   55,  8, 27,  0 }, {     41,   48,   56,  8, 28,  0 }, {     42,   48,   57,  8, 28,  0 },
    {     43,   48,   58,  8, 28,  0 }, {     44,   48,   58,  8, 28,  0 }, {     45,   48,   59,  8, 28,  0 }, {     46,   48,   59,  8, 28,  0 }, {     47,   48,   60,  8, 28,  0 },
    {     48,   48,   60,  8, 28,  0 }, {     49,   48,   61,  8, 28,  0 }, {     50,   48,   61,  8, 28,  0 }, {     51,   48,   62,  8, 28,  0 }, {     52,   48,   62,  8, 28,  0 },
    {     53,   48,   62,  8, 28,  0 }, {     54,   48,   63,  8, 28,  0 }, {     55,   48,   63,  8, 28,  0 }, {     56,   48,   63,  8, 28,  0 }, {     57,   48,   63,  8, 28,  0 },
    {     58,   48,   63,  0, 16,  0 }, {     59,   48,   64,  0, 16,  0 }, {     60,   48,   64,  0, 16,  0 }, {     61,   48,   64,  0, 16,  0 }, {     62,   48,   64,  0, 16,  0 },
    {     63,   48,   64,  0, 16,  0 }, {     64,   48,   64,  0, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EBCD4, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    0, 16,  0,  0 },
    {      5,   16,    0, 16,  0,  0 }, {      6,   16,    1, 16,  0,  0 }, {      7,   16,    1, 16,  0,  0 }, {      8,   16,    1, 16, 24,  0 }, {      9,   16,    1, 16, 24,  0 },
    {     10,   16,    1, 16, 24,  0 }, {     11,   16,    2, 16, 24,  0 }, {     12,   16,    2, 16, 24,  0 }, {     13,   16,    2, 16, 24,  0 }, {     14,   16,    3, 16, 24,  0 },
    {     15,   16,    3, 16, 24,  0 }, {     16,   16,    4, 16, 24,  0 }, {     17,   16,    4, 16, 24,  0 }, {     18,   16,    5, 16, 24,  0 }, {     19,   16,    5, 16, 24,  0 },
    {     20,   16,    6, 16, 24,  0 }, {     21,   16,    6, 16, 24,  0 }, {     22,   16,    7, 16, 24,  0 }, {     23,   16,    8, 16, 24,  0 }, {     24,   16,    9, 16, 25,  0 },
    {     25,   16,    9, 16, 25,  0 }, {     26,   15,   10, 16, 25,  0 }, {     27,   15,   11, 16, 25,  0 }, {     28,   15,   12, 16, 25,  0 }, {     29,   15,   13, 16, 25,  0 },
    {     30,   15,   14, 16, 25,  0 }, {     31,   15,   15, 16, 25,  0 }, {     32,   14,   16, 16, 25,  0 }, {     33,   14,   17, 16, 25,  0 }, {     33,   14,   18, 16, 25,  0 },
    {     34,   14,   19, 16, 25,  0 }, {     35,   14,   20, 16, 25,  0 }, {     36,   13,   21, 16, 25,  0 }, {     36,   13,   22, 16, 25,  0 }, {     37,   13,   23, 16, 25,  0 },
    {     37,   12,   24, 16, 26,  0 }, {     38,   12,   25, 16, 26,  0 }, {     39,   12,   26, 16, 26,  0 }, {     39,   12,   27, 16, 26,  0 }, {     40,   11,   28, 16, 26,  0 },
    {     40,   11,   29, 16, 26,  0 }, {     41,   10,   30, 16, 26,  0 }, {     41,   10,   31, 16, 26,  0 }, {     42,   10,   32, 16, 26,  0 }, {     42,    9,   33, 16, 26,  0 },
    {     42,    9,   34, 16, 26,  0 }, {     43,    8,   35, 16, 26,  0 }, {     43,    8,   36, 16, 26,  0 }, {     44,    7,   37, 16, 26,  0 }, {     44,    7,   38, 16, 26,  0 },
    {     44,    6,   39, 16, 26,  0 }, {     44,    5,   40, 16, 26,  0 }, {     45,    5,   41, 16, 27,  0 }, {     45,    4,   42, 16, 27,  0 }, {     45,    4,   43, 16, 27,  0 },
    {     46,    3,   44, 16, 27,  0 }, {     46,    2,   45, 16, 27,  0 }, {     46,    1,   46, 16, 27,  0 }, {     46,    1,   47, 16, 27,  0 }, {     46,    0,   48, 16, 27,  0 },
    {     47,   -1,   49, 16, 27,  0 }, {     47,   -2,   50, 16, 27,  0 }, {     47,   -3,   51, 16, 27,  0 }, {     47,   -4,   52, 16, 27,  0 }, {     47,   -5,   53, 16, 27,  0 },
    {     47,   -6,   54, 16, 27,  0 }, {     48,   -7,   55, 16, 27,  0 }, {     48,   -8,   55, 16, 27,  0 }, {     48,   -9,   56, 16, 28,  0 }, {     48,  -10,   57, 16, 28,  0 },
    {     48,  -11,   58, 16, 28,  0 }, {     48,  -12,   58, 16, 28,  0 }, {     48,  -13,   59, 16, 28,  0 }, {     48,  -14,   59, 16, 28,  0 }, {     48,  -15,   60, 16, 28,  0 },
    {     48,  -16,   60, 16, 28,  0 }, {     48,  -17,   61, 16, 28,  0 }, {     48,  -18,   61, 16, 28,  0 }, {     48,  -19,   62, 16, 28,  0 }, {     48,  -20,   62, 16, 28,  0 },
    {     48,  -21,   62, 16, 28,  0 }, {     48,  -22,   63, 16, 28,  0 }, {     48,  -23,   63, 16, 28,  0 }, {     48,  -24,   63, 16, 28,  0 }, {     48,  -25,   63, 16, 28,  0 },
    {     48,  -26,   63,  8, 16,  0 }, {     48,  -27,   64,  8, 16,  0 }, {     48,  -28,   64,  8, 16,  0 }, {     48,  -29,   64,  8, 16,  0 }, {     48,  -30,   64,  8, 16,  0 },
    {     48,  -31,   64,  8, 16,  0 }, {     48,  -32,   64,  8, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC03F, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    0, 24,  0,  0 },
    {     16,   26,    0, 24,  0,  0 }, {     16,   25,    1, 24,  0,  0 }, {     16,   24,    1, 24,  0,  0 }, {     16,   23,    1, 24, 24,  0 }, {     16,   22,    1, 24, 24,  0 },
    {     16,   21,    1, 24, 24,  0 }, {     16,   20,    2, 24, 24,  0 }, {     16,   19,    2, 24, 24,  0 }, {     16,   18,    2, 24, 24,  0 }, {     16,   17,    3, 24, 24,  0 },
    {     16,   16,    3, 24, 24,  0 }, {     16,   15,    4, 24, 24,  0 }, {     16,   14,    4, 24, 24,  0 }, {     16,   13,    5, 24, 24,  0 }, {     16,   12,    5, 24, 24,  0 },
    {     16,   11,    6, 24, 24,  0 }, {     16,   10,    6, 24, 24,  0 }, {     16,    9,    7, 24, 24,  0 }, {     16,    8,    8, 24, 24,  0 }, {     16,    7,    9, 24, 25,  0 },
    {     16,    6,    9, 24, 25,  0 }, {     15,    5,   10, 24, 25,  0 }, {     15,    4,   11, 24, 25,  0 }, {     15,    3,   12, 24, 25,  0 }, {     15,    2,   13, 24, 25,  0 },
    {     15,    1,   14, 24, 25,  0 }, {     15,    0,   15, 24, 25,  0 }, {     14,   -1,   16, 24, 25,  0 }, {     14,   -2,   17, 24, 25,  0 }, {     14,   -2,   18, 24, 25,  0 },
    {     14,   -3,   19, 24, 25,  0 }, {     14,   -4,   20, 24, 25,  0 }, {     13,   -5,   21, 24, 25,  0 }, {     13,   -5,   22, 24, 25,  0 }, {     13,   -6,   23, 24, 25,  0 },
    {     12,   -6,   24, 24, 26,  0 }, {     12,   -7,   25, 24, 26,  0 }, {     12,   -8,   26, 24, 26,  0 }, {     12,   -8,   27, 24, 26,  0 }, {     11,   -9,   28, 24, 26,  0 },
    {     11,   -9,   29, 24, 26,  0 }, {     10,  -10,   30, 24, 26,  0 }, {     10,  -10,   31, 24, 26,  0 }, {     10,  -11,   32, 24, 26,  0 }, {      9,  -11,   33, 24, 26,  0 },
    {      9,  -11,   34, 24, 26,  0 }, {      8,  -12,   35, 24, 26,  0 }, {      8,  -12,   36, 24, 26,  0 }, {      7,  -13,   37, 24, 26,  0 }, {      7,  -13,   38, 24, 26,  0 },
    {      6,  -13,   39, 24, 26,  0 }, {      5,  -13,   40, 24, 26,  0 }, {      5,  -14,   41, 24, 27,  0 }, {      4,  -14,   42, 24, 27,  0 }, {      4,  -14,   43, 24, 27,  0 },
    {      3,  -15,   44, 24, 27,  0 }, {      2,  -15,   45, 24, 27,  0 }, {      1,  -15,   46, 24, 27,  0 }, {      1,  -15,   47, 24, 27,  0 }, {      0,  -15,   48, 24, 27,  0 },
    {     -1,  -16,   49, 24, 27,  0 }, {     -2,  -16,   50, 24, 27,  0 }, {     -3,  -16,   51, 24, 27,  0 }, {     -4,  -16,   52, 24, 27,  0 }, {     -5,  -16,   53, 24, 27,  0 },
    {     -6,  -16,   54, 24, 27,  0 }, {     -7,  -17,   55, 24, 27,  0 }, {     -8,  -17,   55, 24, 27,  0 }, {     -9,  -17,   56, 24, 28,  0 }, {    -10,  -17,   57, 24, 28,  0 },
    {    -11,  -17,   58, 24, 28,  0 }, {    -12,  -17,   58, 24, 28,  0 }, {    -13,  -17,   59, 24, 28,  0 }, {    -14,  -17,   59, 24, 28,  0 }, {    -15,  -17,   60, 24, 28,  0 },
    {    -16,  -17,   60, 24, 28,  0 }, {    -17,  -17,   61, 24, 28,  0 }, {    -18,  -17,   61, 24, 28,  0 }, {    -19,  -17,   62, 24, 28,  0 }, {    -20,  -17,   62, 24, 28,  0 },
    {    -21,  -17,   62, 24, 28,  0 }, {    -22,  -17,   63, 24, 28,  0 }, {    -23,  -17,   63, 24, 28,  0 }, {    -24,  -17,   63, 24, 28,  0 }, {    -25,  -17,   63, 24, 28,  0 },
    {    -26,  -17,   63, 16, 16,  0 }, {    -27,  -17,   64, 16, 16,  0 }, {    -28,  -17,   64, 16, 16,  0 }, {    -29,  -17,   64, 16, 16,  0 }, {    -30,  -17,   64, 16, 16,  0 },
    {    -31,  -17,   64, 16, 16,  0 }, {    -32,  -17,   64, 16, 16,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC3AA, {
    {     31,   16,   16, 16, 16,  0 }, {     30,   16,   16, 16, 16,  0 }, {     29,   16,   16, 16, 16,  0 }, {     28,   16,   16, 16, 16,  0 }, {     27,   16,   16, 16, 16,  0 },
    {     26,   16,   16, 16, 16,  0 }, {     25,   16,   15, 16, 16,  0 }, {     24,   16,   15, 16, 16,  0 }, {     23,   16,   15, 24, 33,  0 }, {     22,   16,   15, 24, 33,  0 },
    {     21,   16,   15, 24, 33,  0 }, {     20,   16,   14, 24, 33,  0 }, {     19,   16,   14, 24, 33,  0 }, {     18,   16,   14, 24, 33,  0 }, {     17,   16,   13, 24, 33,  0 },
    {     16,   16,   13, 24, 33,  0 }, {     15,   16,   12, 24, 33,  0 }, {     14,   16,   12, 24, 33,  0 }, {     13,   16,   11, 24, 33,  0 }, {     12,   16,   11, 24, 33,  0 },
    {     11,   16,   10, 24, 33,  0 }, {     10,   16,   10, 24, 33,  0 }, {      9,   16,    9, 24, 33,  0 }, {      8,   16,    8, 24, 33,  0 }, {      7,   16,    7, 24, 32,  0 },
    {      6,   16,    7, 24, 32,  0 }, {      5,   15,    6, 24, 32,  0 }, {      4,   15,    5, 24, 32,  0 }, {      3,   15,    4, 24, 32,  0 }, {      2,   15,    3, 24, 32,  0 },
    {      1,   15,    2, 24, 32,  0 }, {      0,   15,    1, 24, 32,  0 }, {     -1,   14,    0, 24, 32,  0 }, {     -2,   14,   -1, 24, 32,  0 }, {     -2,   14,   -2, 24, 32,  0 },
    {     -3,   14,   -3, 24, 32,  0 }, {     -4,   14,   -4, 24, 32,  0 }, {     -5,   13,   -5, 24, 32,  0 }, {     -5,   13,   -6, 24, 32,  0 }, {     -6,   13,   -7, 24, 32,  0 },
    {     -6,   12,   -8, 24, 31,  0 }, {     -7,   12,   -9, 24, 31,  0 }, {     -8,   12,  -10, 24, 31,  0 }, {     -8,   12,  -11, 24, 31,  0 }, {     -9,   11,  -12, 24, 31,  0 },
    {     -9,   11,  -13, 24, 31,  0 }, {    -10,   10,  -14, 24, 31,  0 }, {    -10,   10,  -15, 24, 31,  0 }, {    -11,   10,  -16, 24, 31,  0 }, {    -11,    9,  -17, 24, 31,  0 },
    {    -11,    9,  -18, 24, 31,  0 }, {    -12,    8,  -19, 24, 31,  0 }, {    -12,    8,  -20, 24, 31,  0 }, {    -13,    7,  -21, 24, 31,  0 }, {    -13,    7,  -22, 24, 31,  0 },
    {    -13,    6,  -23, 24, 31,  0 }, {    -13,    5,  -24, 24, 31,  0 }, {    -14,    5,  -25, 24, 30,  0 }, {    -14,    4,  -26, 24, 30,  0 }, {    -14,    4,  -27, 24, 30,  0 },
    {    -15,    3,  -28, 24, 30,  0 }, {    -15,    2,  -29, 24, 30,  0 }, {    -15,    1,  -30, 24, 30,  0 }, {    -15,    1,  -31, 24, 30,  0 }, {    -15,    0,  -32, 24, 30,  0 },
    {    -16,   -1,  -33, 24, 30,  0 }, {    -16,   -2,  -34, 24, 30,  0 }, {    -16,   -3,  -35, 24, 30,  0 }, {    -16,   -4,  -36, 24, 30,  0 }, {    -16,   -5,  -37, 24, 30,  0 },
    {    -16,   -6,  -38, 24, 30,  0 }, {    -17,   -7,  -39, 24, 30,  0 }, {    -17,   -8,  -39, 24, 30,  0 }, {    -17,   -9,  -40, 24, 29,  0 }, {    -17,  -10,  -41, 24, 29,  0 },
    {    -17,  -11,  -42, 24, 29,  0 }, {    -17,  -12,  -42, 24, 29,  0 }, {    -17,  -13,  -43, 24, 29,  0 }, {    -17,  -14,  -43, 24, 29,  0 }, {    -17,  -15,  -44, 24, 29,  0 },
    {    -17,  -16,  -44, 24, 29,  0 }, {    -17,  -17,  -45, 24, 29,  0 }, {    -17,  -18,  -45, 24, 29,  0 }, {    -17,  -19,  -46, 24, 29,  0 }, {    -17,  -20,  -46, 24, 29,  0 },
    {    -17,  -21,  -46, 24, 29,  0 }, {    -17,  -22,  -47, 24, 29,  0 }, {    -17,  -23,  -47, 24, 29,  0 }, {    -17,  -24,  -47, 24, 29,  0 }, {    -17,  -25,  -47, 24, 29,  0 },
    {    -17,  -26,  -47, 24,  0,  0 }, {    -17,  -27,  -48, 24,  0,  0 }, {    -17,  -28,  -48, 24,  0,  0 }, {    -17,  -29,  -48, 24,  0,  0 }, {    -17,  -30,  -48, 24,  0,  0 },
    {    -17,  -31,  -48, 24,  0,  0 }, {    -17,  -32,  -48, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EC715, {
    {     16,    0,   16, 24, 16,  0 }, {     16,    1,   16, 24, 16,  0 }, {     16,    2,   16, 24, 16,  0 }, {     16,    3,   16, 24, 16,  0 }, {     16,    4,   16, 24, 16,  0 },
    {     16,    5,   16, 24, 16,  0 }, {     16,    6,   15, 24, 16,  0 }, {     16,    7,   15, 24, 16,  0 }, {     16,    8,   15,  0, 33,  0 }, {     16,    9,   15,  0, 33,  0 },
    {     16,   10,   15,  0, 33,  0 }, {     16,   11,   14,  0, 33,  0 }, {     16,   12,   14,  0, 33,  0 }, {     16,   13,   14,  0, 33,  0 }, {     16,   14,   13,  0, 33,  0 },
    {     16,   15,   13,  0, 33,  0 }, {     16,   16,   12,  0, 33,  0 }, {     16,   17,   12,  0, 33,  0 }, {     16,   18,   11,  0, 33,  0 }, {     16,   19,   11,  0, 33,  0 },
    {     16,   20,   10,  0, 33,  0 }, {     16,   21,   10,  0, 33,  0 }, {     16,   22,    9,  0, 33,  0 }, {     16,   23,    8,  0, 33,  0 }, {     16,   24,    7,  0, 32,  0 },
    {     16,   25,    7,  0, 32,  0 }, {     15,   26,    6,  0, 32,  0 }, {     15,   27,    5,  0, 32,  0 }, {     15,   28,    4,  0, 32,  0 }, {     15,   29,    3,  0, 32,  0 },
    {     15,   30,    2,  0, 32,  0 }, {     15,   31,    1,  0, 32,  0 }, {     14,   32,    0,  0, 32,  0 }, {     14,   33,   -1,  0, 32,  0 }, {     14,   33,   -2,  0, 32,  0 },
    {     14,   34,   -3,  0, 32,  0 }, {     14,   35,   -4,  0, 32,  0 }, {     13,   36,   -5,  0, 32,  0 }, {     13,   36,   -6,  0, 32,  0 }, {     13,   37,   -7,  0, 32,  0 },
    {     12,   37,   -8,  0, 31,  0 }, {     12,   38,   -9,  0, 31,  0 }, {     12,   39,  -10,  0, 31,  0 }, {     12,   39,  -11,  0, 31,  0 }, {     11,   40,  -12,  0, 31,  0 },
    {     11,   40,  -13,  0, 31,  0 }, {     10,   41,  -14,  0, 31,  0 }, {     10,   41,  -15,  0, 31,  0 }, {     10,   42,  -16,  0, 31,  0 }, {      9,   42,  -17,  0, 31,  0 },
    {      9,   42,  -18,  0, 31,  0 }, {      8,   43,  -19,  0, 31,  0 }, {      8,   43,  -20,  0, 31,  0 }, {      7,   44,  -21,  0, 31,  0 }, {      7,   44,  -22,  0, 31,  0 },
    {      6,   44,  -23,  0, 31,  0 }, {      5,   44,  -24,  0, 31,  0 }, {      5,   45,  -25,  0, 30,  0 }, {      4,   45,  -26,  0, 30,  0 }, {      4,   45,  -27,  0, 30,  0 },
    {      3,   46,  -28,  0, 30,  0 }, {      2,   46,  -29,  0, 30,  0 }, {      1,   46,  -30,  0, 30,  0 }, {      1,   46,  -31,  0, 30,  0 }, {      0,   46,  -32,  0, 30,  0 },
    {     -1,   47,  -33,  0, 30,  0 }, {     -2,   47,  -34,  0, 30,  0 }, {     -3,   47,  -35,  0, 30,  0 }, {     -4,   47,  -36,  0, 30,  0 }, {     -5,   47,  -37,  0, 30,  0 },
    {     -6,   47,  -38,  0, 30,  0 }, {     -7,   48,  -39,  0, 30,  0 }, {     -8,   48,  -39,  0, 30,  0 }, {     -9,   48,  -40,  0, 29,  0 }, {    -10,   48,  -41,  0, 29,  0 },
    {    -11,   48,  -42,  0, 29,  0 }, {    -12,   48,  -42,  0, 29,  0 }, {    -13,   48,  -43,  0, 29,  0 }, {    -14,   48,  -43,  0, 29,  0 }, {    -15,   48,  -44,  0, 29,  0 },
    {    -16,   48,  -44,  0, 29,  0 }, {    -17,   48,  -45,  0, 29,  0 }, {    -18,   48,  -45,  0, 29,  0 }, {    -19,   48,  -46,  0, 29,  0 }, {    -20,   48,  -46,  0, 29,  0 },
    {    -21,   48,  -46,  0, 29,  0 }, {    -22,   48,  -47,  0, 29,  0 }, {    -23,   48,  -47,  0, 29,  0 }, {    -24,   48,  -47,  0, 29,  0 }, {    -25,   48,  -47,  0, 29,  0 },
    {    -26,   48,  -47,  0,  0,  0 }, {    -27,   48,  -48,  0,  0,  0 }, {    -28,   48,  -48,  0,  0,  0 }, {    -29,   48,  -48,  0,  0,  0 }, {    -30,   48,  -48,  0,  0,  0 },
    {    -31,   48,  -48,  0,  0,  0 }, {    -32,   48,  -48,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ECA80, {
    {      0,   16,   16,  0, 16,  0 }, {      1,   16,   16,  0, 16,  0 }, {      2,   16,   16,  0, 16,  0 }, {      3,   16,   16,  0, 16,  0 }, {      4,   16,   16,  0, 16,  0 },
    {      5,   16,   16,  0, 16,  0 }, {      6,   16,   15,  0, 16,  0 }, {      7,   16,   15,  0, 16,  0 }, {      8,   16,   15,  8, 33,  0 }, {      9,   16,   15,  8, 33,  0 },
    {     10,   16,   15,  8, 33,  0 }, {     11,   16,   14,  8, 33,  0 }, {     12,   16,   14,  8, 33,  0 }, {     13,   16,   14,  8, 33,  0 }, {     14,   16,   13,  8, 33,  0 },
    {     15,   16,   13,  8, 33,  0 }, {     16,   16,   12,  8, 33,  0 }, {     17,   16,   12,  8, 33,  0 }, {     18,   16,   11,  8, 33,  0 }, {     19,   16,   11,  8, 33,  0 },
    {     20,   16,   10,  8, 33,  0 }, {     21,   16,   10,  8, 33,  0 }, {     22,   16,    9,  8, 33,  0 }, {     23,   16,    8,  8, 33,  0 }, {     24,   16,    7,  8, 32,  0 },
    {     25,   16,    7,  8, 32,  0 }, {     26,   17,    6,  8, 32,  0 }, {     27,   17,    5,  8, 32,  0 }, {     28,   17,    4,  8, 32,  0 }, {     29,   17,    3,  8, 32,  0 },
    {     30,   17,    2,  8, 32,  0 }, {     31,   17,    1,  8, 32,  0 }, {     32,   18,    0,  8, 32,  0 }, {     33,   18,   -1,  8, 32,  0 }, {     33,   18,   -2,  8, 32,  0 },
    {     34,   18,   -3,  8, 32,  0 }, {     35,   18,   -4,  8, 32,  0 }, {     36,   19,   -5,  8, 32,  0 }, {     36,   19,   -6,  8, 32,  0 }, {     37,   19,   -7,  8, 32,  0 },
    {     37,   20,   -8,  8, 31,  0 }, {     38,   20,   -9,  8, 31,  0 }, {     39,   20,  -10,  8, 31,  0 }, {     39,   20,  -11,  8, 31,  0 }, {     40,   21,  -12,  8, 31,  0 },
    {     40,   21,  -13,  8, 31,  0 }, {     41,   22,  -14,  8, 31,  0 }, {     41,   22,  -15,  8, 31,  0 }, {     42,   22,  -16,  8, 31,  0 }, {     42,   23,  -17,  8, 31,  0 },
    {     42,   23,  -18,  8, 31,  0 }, {     43,   24,  -19,  8, 31,  0 }, {     43,   24,  -20,  8, 31,  0 }, {     44,   25,  -21,  8, 31,  0 }, {     44,   25,  -22,  8, 31,  0 },
    {     44,   26,  -23,  8, 31,  0 }, {     44,   27,  -24,  8, 31,  0 }, {     45,   27,  -25,  8, 30,  0 }, {     45,   28,  -26,  8, 30,  0 }, {     45,   28,  -27,  8, 30,  0 },
    {     46,   29,  -28,  8, 30,  0 }, {     46,   30,  -29,  8, 30,  0 }, {     46,   31,  -30,  8, 30,  0 }, {     46,   31,  -31,  8, 30,  0 }, {     46,   32,  -32,  8, 30,  0 },
    {     47,   33,  -33,  8, 30,  0 }, {     47,   34,  -34,  8, 30,  0 }, {     47,   35,  -35,  8, 30,  0 }, {     47,   36,  -36,  8, 30,  0 }, {     47,   37,  -37,  8, 30,  0 },
    {     47,   38,  -38,  8, 30,  0 }, {     48,   39,  -39,  8, 30,  0 }, {     48,   40,  -39,  8, 30,  0 }, {     48,   41,  -40,  8, 29,  0 }, {     48,   42,  -41,  8, 29,  0 },
    {     48,   43,  -42,  8, 29,  0 }, {     48,   44,  -42,  8, 29,  0 }, {     48,   45,  -43,  8, 29,  0 }, {     48,   46,  -43,  8, 29,  0 }, {     48,   47,  -44,  8, 29,  0 },
    {     48,   48,  -44,  8, 29,  0 }, {     48,   49,  -45,  8, 29,  0 }, {     48,   50,  -45,  8, 29,  0 }, {     48,   51,  -46,  8, 29,  0 }, {     48,   52,  -46,  8, 29,  0 },
    {     48,   53,  -46,  8, 29,  0 }, {     48,   54,  -47,  8, 29,  0 }, {     48,   55,  -47,  8, 29,  0 }, {     48,   56,  -47,  8, 29,  0 }, {     48,   57,  -47,  8, 29,  0 },
    {     48,   58,  -47,  8,  0,  0 }, {     48,   59,  -48,  8,  0,  0 }, {     48,   60,  -48,  8,  0,  0 }, {     48,   61,  -48,  8,  0,  0 }, {     48,   62,  -48,  8,  0,  0 },
    {     48,   63,  -48,  8,  0,  0 }, {     48,   64,  -48,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ECDEB, {
    {     16,   31,   16,  8, 16,  0 }, {     16,   30,   16,  8, 16,  0 }, {     16,   29,   16,  8, 16,  0 }, {     16,   28,   16,  8, 16,  0 }, {     16,   27,   16,  8, 16,  0 },
    {     16,   26,   16,  8, 16,  0 }, {     16,   25,   15,  8, 16,  0 }, {     16,   24,   15,  8, 16,  0 }, {     16,   23,   15, 16, 33,  0 }, {     16,   22,   15, 16, 33,  0 },
    {     16,   21,   15, 16, 33,  0 }, {     16,   20,   14, 16, 33,  0 }, {     16,   19,   14, 16, 33,  0 }, {     16,   18,   14, 16, 33,  0 }, {     16,   17,   13, 16, 33,  0 },
    {     16,   16,   13, 16, 33,  0 }, {     16,   15,   12, 16, 33,  0 }, {     16,   14,   12, 16, 33,  0 }, {     16,   13,   11, 16, 33,  0 }, {     16,   12,   11, 16, 33,  0 },
    {     16,   11,   10, 16, 33,  0 }, {     16,   10,   10, 16, 33,  0 }, {     16,    9,    9, 16, 33,  0 }, {     16,    8,    8, 16, 33,  0 }, {     16,    7,    7, 16, 32,  0 },
    {     16,    6,    7, 16, 32,  0 }, {     17,    5,    6, 16, 32,  0 }, {     17,    4,    5, 16, 32,  0 }, {     17,    3,    4, 16, 32,  0 }, {     17,    2,    3, 16, 32,  0 },
    {     17,    1,    2, 16, 32,  0 }, {     17,    0,    1, 16, 32,  0 }, {     18,   -1,    0, 16, 32,  0 }, {     18,   -2,   -1, 16, 32,  0 }, {     18,   -2,   -2, 16, 32,  0 },
    {     18,   -3,   -3, 16, 32,  0 }, {     18,   -4,   -4, 16, 32,  0 }, {     19,   -5,   -5, 16, 32,  0 }, {     19,   -5,   -6, 16, 32,  0 }, {     19,   -6,   -7, 16, 32,  0 },
    {     20,   -6,   -8, 16, 31,  0 }, {     20,   -7,   -9, 16, 31,  0 }, {     20,   -8,  -10, 16, 31,  0 }, {     20,   -8,  -11, 16, 31,  0 }, {     21,   -9,  -12, 16, 31,  0 },
    {     21,   -9,  -13, 16, 31,  0 }, {     22,  -10,  -14, 16, 31,  0 }, {     22,  -10,  -15, 16, 31,  0 }, {     22,  -11,  -16, 16, 31,  0 }, {     23,  -11,  -17, 16, 31,  0 },
    {     23,  -11,  -18, 16, 31,  0 }, {     24,  -12,  -19, 16, 31,  0 }, {     24,  -12,  -20, 16, 31,  0 }, {     25,  -13,  -21, 16, 31,  0 }, {     25,  -13,  -22, 16, 31,  0 },
    {     26,  -13,  -23, 16, 31,  0 }, {     27,  -13,  -24, 16, 31,  0 }, {     27,  -14,  -25, 16, 30,  0 }, {     28,  -14,  -26, 16, 30,  0 }, {     28,  -14,  -27, 16, 30,  0 },
    {     29,  -15,  -28, 16, 30,  0 }, {     30,  -15,  -29, 16, 30,  0 }, {     31,  -15,  -30, 16, 30,  0 }, {     31,  -15,  -31, 16, 30,  0 }, {     32,  -15,  -32, 16, 30,  0 },
    {     33,  -16,  -33, 16, 30,  0 }, {     34,  -16,  -34, 16, 30,  0 }, {     35,  -16,  -35, 16, 30,  0 }, {     36,  -16,  -36, 16, 30,  0 }, {     37,  -16,  -37, 16, 30,  0 },
    {     38,  -16,  -38, 16, 30,  0 }, {     39,  -17,  -39, 16, 30,  0 }, {     40,  -17,  -39, 16, 30,  0 }, {     41,  -17,  -40, 16, 29,  0 }, {     42,  -17,  -41, 16, 29,  0 },
    {     43,  -17,  -42, 16, 29,  0 }, {     44,  -17,  -42, 16, 29,  0 }, {     45,  -17,  -43, 16, 29,  0 }, {     46,  -17,  -43, 16, 29,  0 }, {     47,  -17,  -44, 16, 29,  0 },
    {     48,  -17,  -44, 16, 29,  0 }, {     49,  -17,  -45, 16, 29,  0 }, {     50,  -17,  -45, 16, 29,  0 }, {     51,  -17,  -46, 16, 29,  0 }, {     52,  -17,  -46, 16, 29,  0 },
    {     53,  -17,  -46, 16, 29,  0 }, {     54,  -17,  -47, 16, 29,  0 }, {     55,  -17,  -47, 16, 29,  0 }, {     56,  -17,  -47, 16, 29,  0 }, {     57,  -17,  -47, 16, 29,  0 },
    {     58,  -17,  -47, 16,  0,  0 }, {     59,  -17,  -48, 16,  0,  0 }, {     60,  -17,  -48, 16,  0,  0 }, {     61,  -17,  -48, 16,  0,  0 }, {     62,  -17,  -48, 16,  0,  0 },
    {     63,  -17,  -48, 16,  0,  0 }, {     64,  -17,  -48, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED156, {
    {     31,   16,   16, 16, 16,  0 }, {     30,   16,   16, 16, 16,  0 }, {     29,   16,   16, 16, 16,  0 }, {     28,   16,   16, 16, 16,  0 }, {     27,   16,   16, 16, 16,  0 },
    {     26,   16,   16, 16, 16,  0 }, {     25,   16,   15, 16, 16,  0 }, {     24,   16,   15, 16, 16,  0 }, {     23,   16,   15,  8, 43,  0 }, {     22,   16,   15,  8, 43,  0 },
    {     21,   16,   15,  8, 43,  0 }, {     20,   16,   14,  8, 43,  0 }, {     19,   16,   14,  8, 43,  0 }, {     18,   16,   14,  8, 43,  0 }, {     17,   16,   13,  8, 43,  0 },
    {     16,   16,   13,  8, 43,  0 }, {     15,   16,   12,  8, 43,  0 }, {     14,   16,   12,  8, 43,  0 }, {     13,   16,   11,  8, 43,  0 }, {     12,   16,   11,  8, 43,  0 },
    {     11,   16,   10,  8, 43,  0 }, {     10,   16,   10,  8, 43,  0 }, {      9,   16,    9,  8, 43,  0 }, {      8,   16,    8,  8, 43,  0 }, {      7,   16,    7,  8, 42,  0 },
    {      6,   16,    7,  8, 42,  0 }, {      5,   17,    6,  8, 42,  0 }, {      4,   17,    5,  8, 42,  0 }, {      3,   17,    4,  8, 42,  0 }, {      2,   17,    3,  8, 42,  0 },
    {      1,   17,    2,  8, 42,  0 }, {      0,   17,    1,  8, 42,  0 }, {     -1,   18,    0,  8, 42,  0 }, {     -2,   18,   -1,  8, 42,  0 }, {     -2,   18,   -2,  8, 42,  0 },
    {     -3,   18,   -3,  8, 42,  0 }, {     -4,   18,   -4,  8, 42,  0 }, {     -5,   19,   -5,  8, 42,  0 }, {     -5,   19,   -6,  8, 42,  0 }, {     -6,   19,   -7,  8, 42,  0 },
    {     -6,   20,   -8,  8, 41,  0 }, {     -7,   20,   -9,  8, 41,  0 }, {     -8,   20,  -10,  8, 41,  0 }, {     -8,   20,  -11,  8, 41,  0 }, {     -9,   21,  -12,  8, 41,  0 },
    {     -9,   21,  -13,  8, 41,  0 }, {    -10,   22,  -14,  8, 41,  0 }, {    -10,   22,  -15,  8, 41,  0 }, {    -11,   22,  -16,  8, 41,  0 }, {    -11,   23,  -17,  8, 41,  0 },
    {    -11,   23,  -18,  8, 41,  0 }, {    -12,   24,  -19,  8, 41,  0 }, {    -12,   24,  -20,  8, 41,  0 }, {    -13,   25,  -21,  8, 41,  0 }, {    -13,   25,  -22,  8, 41,  0 },
    {    -13,   26,  -23,  8, 41,  0 }, {    -13,   27,  -24,  8, 41,  0 }, {    -14,   27,  -25,  8, 40,  0 }, {    -14,   28,  -26,  8, 40,  0 }, {    -14,   28,  -27,  8, 40,  0 },
    {    -15,   29,  -28,  8, 40,  0 }, {    -15,   30,  -29,  8, 40,  0 }, {    -15,   31,  -30,  8, 40,  0 }, {    -15,   31,  -31,  8, 40,  0 }, {    -15,   32,  -32,  8, 40,  0 },
    {    -16,   33,  -33,  8, 40,  0 }, {    -16,   34,  -34,  8, 40,  0 }, {    -16,   35,  -35,  8, 40,  0 }, {    -16,   36,  -36,  8, 40,  0 }, {    -16,   37,  -37,  8, 40,  0 },
    {    -16,   38,  -38,  8, 40,  0 }, {    -17,   39,  -39,  8, 40,  0 }, {    -17,   40,  -39,  8, 40,  0 }, {    -17,   41,  -40,  8, 39,  0 }, {    -17,   42,  -41,  8, 39,  0 },
    {    -17,   43,  -42,  8, 39,  0 }, {    -17,   44,  -42,  8, 39,  0 }, {    -17,   45,  -43,  8, 39,  0 }, {    -17,   46,  -43,  8, 39,  0 }, {    -17,   47,  -44,  8, 39,  0 },
    {    -17,   48,  -44,  8, 39,  0 }, {    -17,   49,  -45,  8, 39,  0 }, {    -17,   50,  -45,  8, 39,  0 }, {    -17,   51,  -46,  8, 39,  0 }, {    -17,   52,  -46,  8, 39,  0 },
    {    -17,   53,  -46,  8, 39,  0 }, {    -17,   54,  -47,  8, 39,  0 }, {    -17,   55,  -47,  8, 39,  0 }, {    -17,   56,  -47,  8, 39,  0 }, {    -17,   57,  -47,  8, 39,  0 },
    {    -17,   58,  -47,  8,  0,  0 }, {    -17,   59,  -48,  8,  0,  0 }, {    -17,   60,  -48,  8,  0,  0 }, {    -17,   61,  -48,  8,  0,  0 }, {    -17,   62,  -48,  8,  0,  0 },
    {    -17,   63,  -48,  8,  0,  0 }, {    -17,   64,  -48,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED4C1, {
    {     16,    0,   16, 24, 16,  0 }, {     16,    1,   16, 24, 16,  0 }, {     16,    2,   16, 24, 16,  0 }, {     16,    3,   16, 24, 16,  0 }, {     16,    4,   16, 24, 16,  0 },
    {     16,    5,   16, 24, 16,  0 }, {     16,    6,   15, 24, 16,  0 }, {     16,    7,   15, 24, 16,  0 }, {     16,    8,   15, 16, 43,  0 }, {     16,    9,   15, 16, 43,  0 },
    {     16,   10,   15, 16, 43,  0 }, {     16,   11,   14, 16, 43,  0 }, {     16,   12,   14, 16, 43,  0 }, {     16,   13,   14, 16, 43,  0 }, {     16,   14,   13, 16, 43,  0 },
    {     16,   15,   13, 16, 43,  0 }, {     16,   16,   12, 16, 43,  0 }, {     16,   17,   12, 16, 43,  0 }, {     16,   18,   11, 16, 43,  0 }, {     16,   19,   11, 16, 43,  0 },
    {     16,   20,   10, 16, 43,  0 }, {     16,   21,   10, 16, 43,  0 }, {     16,   22,    9, 16, 43,  0 }, {     16,   23,    8, 16, 43,  0 }, {     16,   24,    7, 16, 42,  0 },
    {     16,   25,    7, 16, 42,  0 }, {     17,   26,    6, 16, 42,  0 }, {     17,   27,    5, 16, 42,  0 }, {     17,   28,    4, 16, 42,  0 }, {     17,   29,    3, 16, 42,  0 },
    {     17,   30,    2, 16, 42,  0 }, {     17,   31,    1, 16, 42,  0 }, {     18,   32,    0, 16, 42,  0 }, {     18,   33,   -1, 16, 42,  0 }, {     18,   33,   -2, 16, 42,  0 },
    {     18,   34,   -3, 16, 42,  0 }, {     18,   35,   -4, 16, 42,  0 }, {     19,   36,   -5, 16, 42,  0 }, {     19,   36,   -6, 16, 42,  0 }, {     19,   37,   -7, 16, 42,  0 },
    {     20,   37,   -8, 16, 41,  0 }, {     20,   38,   -9, 16, 41,  0 }, {     20,   39,  -10, 16, 41,  0 }, {     20,   39,  -11, 16, 41,  0 }, {     21,   40,  -12, 16, 41,  0 },
    {     21,   40,  -13, 16, 41,  0 }, {     22,   41,  -14, 16, 41,  0 }, {     22,   41,  -15, 16, 41,  0 }, {     22,   42,  -16, 16, 41,  0 }, {     23,   42,  -17, 16, 41,  0 },
    {     23,   42,  -18, 16, 41,  0 }, {     24,   43,  -19, 16, 41,  0 }, {     24,   43,  -20, 16, 41,  0 }, {     25,   44,  -21, 16, 41,  0 }, {     25,   44,  -22, 16, 41,  0 },
    {     26,   44,  -23, 16, 41,  0 }, {     27,   44,  -24, 16, 41,  0 }, {     27,   45,  -25, 16, 40,  0 }, {     28,   45,  -26, 16, 40,  0 }, {     28,   45,  -27, 16, 40,  0 },
    {     29,   46,  -28, 16, 40,  0 }, {     30,   46,  -29, 16, 40,  0 }, {     31,   46,  -30, 16, 40,  0 }, {     31,   46,  -31, 16, 40,  0 }, {     32,   46,  -32, 16, 40,  0 },
    {     33,   47,  -33, 16, 40,  0 }, {     34,   47,  -34, 16, 40,  0 }, {     35,   47,  -35, 16, 40,  0 }, {     36,   47,  -36, 16, 40,  0 }, {     37,   47,  -37, 16, 40,  0 },
    {     38,   47,  -38, 16, 40,  0 }, {     39,   48,  -39, 16, 40,  0 }, {     40,   48,  -39, 16, 40,  0 }, {     41,   48,  -40, 16, 39,  0 }, {     42,   48,  -41, 16, 39,  0 },
    {     43,   48,  -42, 16, 39,  0 }, {     44,   48,  -42, 16, 39,  0 }, {     45,   48,  -43, 16, 39,  0 }, {     46,   48,  -43, 16, 39,  0 }, {     47,   48,  -44, 16, 39,  0 },
    {     48,   48,  -44, 16, 39,  0 }, {     49,   48,  -45, 16, 39,  0 }, {     50,   48,  -45, 16, 39,  0 }, {     51,   48,  -46, 16, 39,  0 }, {     52,   48,  -46, 16, 39,  0 },
    {     53,   48,  -46, 16, 39,  0 }, {     54,   48,  -47, 16, 39,  0 }, {     55,   48,  -47, 16, 39,  0 }, {     56,   48,  -47, 16, 39,  0 }, {     57,   48,  -47, 16, 39,  0 },
    {     58,   48,  -47, 16,  0,  0 }, {     59,   48,  -48, 16,  0,  0 }, {     60,   48,  -48, 16,  0,  0 }, {     61,   48,  -48, 16,  0,  0 }, {     62,   48,  -48, 16,  0,  0 },
    {     63,   48,  -48, 16,  0,  0 }, {     64,   48,  -48, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8ED82C, {
    {      0,   16,   16,  0, 16,  0 }, {      1,   16,   16,  0, 16,  0 }, {      2,   16,   16,  0, 16,  0 }, {      3,   16,   16,  0, 16,  0 }, {      4,   16,   16,  0, 16,  0 },
    {      5,   16,   16,  0, 16,  0 }, {      6,   16,   15,  0, 16,  0 }, {      7,   16,   15,  0, 16,  0 }, {      8,   16,   15, 24, 43,  0 }, {      9,   16,   15, 24, 43,  0 },
    {     10,   16,   15, 24, 43,  0 }, {     11,   16,   14, 24, 43,  0 }, {     12,   16,   14, 24, 43,  0 }, {     13,   16,   14, 24, 43,  0 }, {     14,   16,   13, 24, 43,  0 },
    {     15,   16,   13, 24, 43,  0 }, {     16,   16,   12, 24, 43,  0 }, {     17,   16,   12, 24, 43,  0 }, {     18,   16,   11, 24, 43,  0 }, {     19,   16,   11, 24, 43,  0 },
    {     20,   16,   10, 24, 43,  0 }, {     21,   16,   10, 24, 43,  0 }, {     22,   16,    9, 24, 43,  0 }, {     23,   16,    8, 24, 43,  0 }, {     24,   16,    7, 24, 42,  0 },
    {     25,   16,    7, 24, 42,  0 }, {     26,   15,    6, 24, 42,  0 }, {     27,   15,    5, 24, 42,  0 }, {     28,   15,    4, 24, 42,  0 }, {     29,   15,    3, 24, 42,  0 },
    {     30,   15,    2, 24, 42,  0 }, {     31,   15,    1, 24, 42,  0 }, {     32,   14,    0, 24, 42,  0 }, {     33,   14,   -1, 24, 42,  0 }, {     33,   14,   -2, 24, 42,  0 },
    {     34,   14,   -3, 24, 42,  0 }, {     35,   14,   -4, 24, 42,  0 }, {     36,   13,   -5, 24, 42,  0 }, {     36,   13,   -6, 24, 42,  0 }, {     37,   13,   -7, 24, 42,  0 },
    {     37,   12,   -8, 24, 41,  0 }, {     38,   12,   -9, 24, 41,  0 }, {     39,   12,  -10, 24, 41,  0 }, {     39,   12,  -11, 24, 41,  0 }, {     40,   11,  -12, 24, 41,  0 },
    {     40,   11,  -13, 24, 41,  0 }, {     41,   10,  -14, 24, 41,  0 }, {     41,   10,  -15, 24, 41,  0 }, {     42,   10,  -16, 24, 41,  0 }, {     42,    9,  -17, 24, 41,  0 },
    {     42,    9,  -18, 24, 41,  0 }, {     43,    8,  -19, 24, 41,  0 }, {     43,    8,  -20, 24, 41,  0 }, {     44,    7,  -21, 24, 41,  0 }, {     44,    7,  -22, 24, 41,  0 },
    {     44,    6,  -23, 24, 41,  0 }, {     44,    5,  -24, 24, 41,  0 }, {     45,    5,  -25, 24, 40,  0 }, {     45,    4,  -26, 24, 40,  0 }, {     45,    4,  -27, 24, 40,  0 },
    {     46,    3,  -28, 24, 40,  0 }, {     46,    2,  -29, 24, 40,  0 }, {     46,    1,  -30, 24, 40,  0 }, {     46,    1,  -31, 24, 40,  0 }, {     46,    0,  -32, 24, 40,  0 },
    {     47,   -1,  -33, 24, 40,  0 }, {     47,   -2,  -34, 24, 40,  0 }, {     47,   -3,  -35, 24, 40,  0 }, {     47,   -4,  -36, 24, 40,  0 }, {     47,   -5,  -37, 24, 40,  0 },
    {     47,   -6,  -38, 24, 40,  0 }, {     48,   -7,  -39, 24, 40,  0 }, {     48,   -8,  -39, 24, 40,  0 }, {     48,   -9,  -40, 24, 39,  0 }, {     48,  -10,  -41, 24, 39,  0 },
    {     48,  -11,  -42, 24, 39,  0 }, {     48,  -12,  -42, 24, 39,  0 }, {     48,  -13,  -43, 24, 39,  0 }, {     48,  -14,  -43, 24, 39,  0 }, {     48,  -15,  -44, 24, 39,  0 },
    {     48,  -16,  -44, 24, 39,  0 }, {     48,  -17,  -45, 24, 39,  0 }, {     48,  -18,  -45, 24, 39,  0 }, {     48,  -19,  -46, 24, 39,  0 }, {     48,  -20,  -46, 24, 39,  0 },
    {     48,  -21,  -46, 24, 39,  0 }, {     48,  -22,  -47, 24, 39,  0 }, {     48,  -23,  -47, 24, 39,  0 }, {     48,  -24,  -47, 24, 39,  0 }, {     48,  -25,  -47, 24, 39,  0 },
    {     48,  -26,  -47, 24,  0,  0 }, {     48,  -27,  -48, 24,  0,  0 }, {     48,  -28,  -48, 24,  0,  0 }, {     48,  -29,  -48, 24,  0,  0 }, {     48,  -30,  -48, 24,  0,  0 },
    {     48,  -31,  -48, 24,  0,  0 }, {     48,  -32,  -48, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EDB97, {
    {     16,   31,   16,  8, 16,  0 }, {     16,   30,   16,  8, 16,  0 }, {     16,   29,   16,  8, 16,  0 }, {     16,   28,   16,  8, 16,  0 }, {     16,   27,   16,  8, 16,  0 },
    {     16,   26,   16,  8, 16,  0 }, {     16,   25,   15,  8, 16,  0 }, {     16,   24,   15,  8, 16,  0 }, {     16,   23,   15,  0, 43,  0 }, {     16,   22,   15,  0, 43,  0 },
    {     16,   21,   15,  0, 43,  0 }, {     16,   20,   14,  0, 43,  0 }, {     16,   19,   14,  0, 43,  0 }, {     16,   18,   14,  0, 43,  0 }, {     16,   17,   13,  0, 43,  0 },
    {     16,   16,   13,  0, 43,  0 }, {     16,   15,   12,  0, 43,  0 }, {     16,   14,   12,  0, 43,  0 }, {     16,   13,   11,  0, 43,  0 }, {     16,   12,   11,  0, 43,  0 },
    {     16,   11,   10,  0, 43,  0 }, {     16,   10,   10,  0, 43,  0 }, {     16,    9,    9,  0, 43,  0 }, {     16,    8,    8,  0, 43,  0 }, {     16,    7,    7,  0, 42,  0 },
    {     16,    6,    7,  0, 42,  0 }, {     15,    5,    6,  0, 42,  0 }, {     15,    4,    5,  0, 42,  0 }, {     15,    3,    4,  0, 42,  0 }, {     15,    2,    3,  0, 42,  0 },
    {     15,    1,    2,  0, 42,  0 }, {     15,    0,    1,  0, 42,  0 }, {     14,   -1,    0,  0, 42,  0 }, {     14,   -2,   -1,  0, 42,  0 }, {     14,   -2,   -2,  0, 42,  0 },
    {     14,   -3,   -3,  0, 42,  0 }, {     14,   -4,   -4,  0, 42,  0 }, {     13,   -5,   -5,  0, 42,  0 }, {     13,   -5,   -6,  0, 42,  0 }, {     13,   -6,   -7,  0, 42,  0 },
    {     12,   -6,   -8,  0, 41,  0 }, {     12,   -7,   -9,  0, 41,  0 }, {     12,   -8,  -10,  0, 41,  0 }, {     12,   -8,  -11,  0, 41,  0 }, {     11,   -9,  -12,  0, 41,  0 },
    {     11,   -9,  -13,  0, 41,  0 }, {     10,  -10,  -14,  0, 41,  0 }, {     10,  -10,  -15,  0, 41,  0 }, {     10,  -11,  -16,  0, 41,  0 }, {      9,  -11,  -17,  0, 41,  0 },
    {      9,  -11,  -18,  0, 41,  0 }, {      8,  -12,  -19,  0, 41,  0 }, {      8,  -12,  -20,  0, 41,  0 }, {      7,  -13,  -21,  0, 41,  0 }, {      7,  -13,  -22,  0, 41,  0 },
    {      6,  -13,  -23,  0, 41,  0 }, {      5,  -13,  -24,  0, 41,  0 }, {      5,  -14,  -25,  0, 40,  0 }, {      4,  -14,  -26,  0, 40,  0 }, {      4,  -14,  -27,  0, 40,  0 },
    {      3,  -15,  -28,  0, 40,  0 }, {      2,  -15,  -29,  0, 40,  0 }, {      1,  -15,  -30,  0, 40,  0 }, {      1,  -15,  -31,  0, 40,  0 }, {      0,  -15,  -32,  0, 40,  0 },
    {     -1,  -16,  -33,  0, 40,  0 }, {     -2,  -16,  -34,  0, 40,  0 }, {     -3,  -16,  -35,  0, 40,  0 }, {     -4,  -16,  -36,  0, 40,  0 }, {     -5,  -16,  -37,  0, 40,  0 },
    {     -6,  -16,  -38,  0, 40,  0 }, {     -7,  -17,  -39,  0, 40,  0 }, {     -8,  -17,  -39,  0, 40,  0 }, {     -9,  -17,  -40,  0, 39,  0 }, {    -10,  -17,  -41,  0, 39,  0 },
    {    -11,  -17,  -42,  0, 39,  0 }, {    -12,  -17,  -42,  0, 39,  0 }, {    -13,  -17,  -43,  0, 39,  0 }, {    -14,  -17,  -43,  0, 39,  0 }, {    -15,  -17,  -44,  0, 39,  0 },
    {    -16,  -17,  -44,  0, 39,  0 }, {    -17,  -17,  -45,  0, 39,  0 }, {    -18,  -17,  -45,  0, 39,  0 }, {    -19,  -17,  -46,  0, 39,  0 }, {    -20,  -17,  -46,  0, 39,  0 },
    {    -21,  -17,  -46,  0, 39,  0 }, {    -22,  -17,  -47,  0, 39,  0 }, {    -23,  -17,  -47,  0, 39,  0 }, {    -24,  -17,  -47,  0, 39,  0 }, {    -25,  -17,  -47,  0, 39,  0 },
    {    -26,  -17,  -47,  0,  0,  0 }, {    -27,  -17,  -48,  0,  0,  0 }, {    -28,  -17,  -48,  0,  0,  0 }, {    -29,  -17,  -48,  0,  0,  0 }, {    -30,  -17,  -48,  0,  0,  0 },
    {    -31,  -17,  -48,  0,  0,  0 }, {    -32,  -17,  -48,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6C32, {
    {     31,   16,    0,  0,  0,  0 }, {     30,   16,    0,  0,  0,  0 }, {     29,   16,    0,  0,  0,  0 }, {     28,   16,    0,  0,  0,  0 }, {     27,   16,    1,  0,  0,  0 },
    {     26,   16,    1,  0,  1,  0 }, {     25,   16,    1,  0,  1,  0 }, {     24,   16,    2,  0,  1,  0 }, {     23,   16,    2,  0,  1,  0 }, {     22,   16,    2,  0,  1,  0 },
    {     21,   16,    3,  0,  1,  0 }, {     20,   16,    3,  0,  1,  0 }, {     19,   16,    4,  0,  1,  0 }, {     18,   16,    4,  0,  2,  0 }, {     17,   16,    5,  0,  2,  0 },
    {     16,   16,    5,  0,  2,  0 }, {     15,   16,    6,  0,  2,  0 }, {     14,   16,    6,  0,  2,  0 }, {     13,   16,    7,  0,  2,  0 }, {     12,   16,    8,  0,  2,  0 },
    {     11,   16,    8,  0,  2,  0 }, {     10,   16,    9,  0,  2,  0 }, {      9,   16,   10,  0,  3,  0 }, {      8,   16,   11,  0,  3,  0 }, {      7,   16,   12,  0,  3,  0 },
    {      6,   16,   13,  0,  3,  0 }, {      5,   16,   14,  0,  3,  0 }, {      4,   16,   15,  0,  3,  0 }, {      4,   16,   16,  0,  3,  0 }, {      3,   16,   17,  0,  4,  0 },
    {      2,   16,   18,  0,  4,  0 }, {      2,   16,   19,  0,  4,  0 }, {      1,   16,   20,  0,  4,  0 }, {      1,   16,   21,  0,  4,  0 }, {      0,   16,   22,  0,  4,  0 },
    {      0,   16,   23,  0,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6D78, {
    {     16,    0,    0,  8,  0,  0 }, {     16,    1,    0,  8,  0,  0 }, {     16,    2,    0,  8,  0,  0 }, {     16,    3,    0,  8,  0,  0 }, {     16,    4,    1,  8,  0,  0 },
    {     16,    5,    1,  8,  1,  0 }, {     16,    6,    1,  8,  1,  0 }, {     16,    7,    2,  8,  1,  0 }, {     16,    8,    2,  8,  1,  0 }, {     16,    9,    2,  8,  1,  0 },
    {     16,   10,    3,  8,  1,  0 }, {     16,   11,    3,  8,  1,  0 }, {     16,   12,    4,  8,  1,  0 }, {     16,   13,    4,  8,  2,  0 }, {     16,   14,    5,  8,  2,  0 },
    {     16,   15,    5,  8,  2,  0 }, {     16,   16,    6,  8,  2,  0 }, {     16,   17,    6,  8,  2,  0 }, {     16,   18,    7,  8,  2,  0 }, {     16,   19,    8,  8,  2,  0 },
    {     16,   20,    8,  8,  2,  0 }, {     16,   21,    9,  8,  2,  0 }, {     16,   22,   10,  8,  3,  0 }, {     16,   23,   11,  8,  3,  0 }, {     16,   24,   12,  8,  3,  0 },
    {     16,   25,   13,  8,  3,  0 }, {     16,   26,   14,  8,  3,  0 }, {     16,   27,   15,  8,  3,  0 }, {     16,   27,   16,  8,  3,  0 }, {     16,   28,   17,  8,  4,  0 },
    {     16,   29,   18,  8,  4,  0 }, {     16,   29,   19,  8,  4,  0 }, {     16,   30,   20,  8,  4,  0 }, {     16,   30,   21,  8,  4,  0 }, {     16,   31,   22,  8,  4,  0 },
    {     16,   31,   23,  8,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C6EBE, {
    {      0,   16,    0, 16,  0,  0 }, {      1,   16,    0, 16,  0,  0 }, {      2,   16,    0, 16,  0,  0 }, {      3,   16,    0, 16,  0,  0 }, {      4,   16,    1, 16,  0,  0 },
    {      5,   16,    1, 16,  1,  0 }, {      6,   16,    1, 16,  1,  0 }, {      7,   16,    2, 16,  1,  0 }, {      8,   16,    2, 16,  1,  0 }, {      9,   16,    2, 16,  1,  0 },
    {     10,   16,    3, 16,  1,  0 }, {     11,   16,    3, 16,  1,  0 }, {     12,   16,    4, 16,  1,  0 }, {     13,   16,    4, 16,  2,  0 }, {     14,   16,    5, 16,  2,  0 },
    {     15,   16,    5, 16,  2,  0 }, {     16,   16,    6, 16,  2,  0 }, {     17,   16,    6, 16,  2,  0 }, {     18,   16,    7, 16,  2,  0 }, {     19,   16,    8, 16,  2,  0 },
    {     20,   16,    8, 16,  2,  0 }, {     21,   16,    9, 16,  2,  0 }, {     22,   16,   10, 16,  3,  0 }, {     23,   16,   11, 16,  3,  0 }, {     24,   16,   12, 16,  3,  0 },
    {     25,   16,   13, 16,  3,  0 }, {     26,   16,   14, 16,  3,  0 }, {     27,   16,   15, 16,  3,  0 }, {     27,   16,   16, 16,  3,  0 }, {     28,   16,   17, 16,  4,  0 },
    {     29,   16,   18, 16,  4,  0 }, {     29,   16,   19, 16,  4,  0 }, {     30,   16,   20, 16,  4,  0 }, {     30,   16,   21, 16,  4,  0 }, {     31,   16,   22, 16,  4,  0 },
    {     31,   16,   23, 16,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7004, {
    {     16,   31,    0, 24,  0,  0 }, {     16,   30,    0, 24,  0,  0 }, {     16,   29,    0, 24,  0,  0 }, {     16,   28,    0, 24,  0,  0 }, {     16,   27,    1, 24,  0,  0 },
    {     16,   26,    1, 24,  1,  0 }, {     16,   25,    1, 24,  1,  0 }, {     16,   24,    2, 24,  1,  0 }, {     16,   23,    2, 24,  1,  0 }, {     16,   22,    2, 24,  1,  0 },
    {     16,   21,    3, 24,  1,  0 }, {     16,   20,    3, 24,  1,  0 }, {     16,   19,    4, 24,  1,  0 }, {     16,   18,    4, 24,  2,  0 }, {     16,   17,    5, 24,  2,  0 },
    {     16,   16,    5, 24,  2,  0 }, {     16,   15,    6, 24,  2,  0 }, {     16,   14,    6, 24,  2,  0 }, {     16,   13,    7, 24,  2,  0 }, {     16,   12,    8, 24,  2,  0 },
    {     16,   11,    8, 24,  2,  0 }, {     16,   10,    9, 24,  2,  0 }, {     16,    9,   10, 24,  3,  0 }, {     16,    8,   11, 24,  3,  0 }, {     16,    7,   12, 24,  3,  0 },
    {     16,    6,   13, 24,  3,  0 }, {     16,    5,   14, 24,  3,  0 }, {     16,    4,   15, 24,  3,  0 }, {     16,    4,   16, 24,  3,  0 }, {     16,    3,   17, 24,  4,  0 },
    {     16,    2,   18, 24,  4,  0 }, {     16,    2,   19, 24,  4,  0 }, {     16,    1,   20, 24,  4,  0 }, {     16,    1,   21, 24,  4,  0 }, {     16,    0,   22, 24,  4,  0 },
    {     16,    0,   23, 24,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C714A, {
    {     31,   16,    0,  0,  4,  0 }, {     31,   16,    1,  0,  4,  0 }, {     30,   16,    2,  0,  4,  0 }, {     30,   16,    3,  0,  4,  0 }, {     29,   16,    4,  0,  4,  0 },
    {     29,   16,    5,  0,  4,  0 }, {     28,   16,    6,  0,  4,  0 }, {     27,   16,    7,  0,  3,  0 }, {     27,   16,    8,  0,  3,  0 }, {     26,   16,    9,  0,  3,  0 },
    {     25,   16,   10,  0,  3,  0 }, {     24,   16,   11,  0,  3,  0 }, {     23,   16,   12,  0,  3,  0 }, {     22,   16,   13,  0,  3,  0 }, {     21,   16,   14,  0,  2,  0 },
    {     20,   16,   15,  0,  2,  0 }, {     19,   16,   15,  0,  2,  0 }, {     18,   16,   16,  0,  2,  0 }, {     17,   16,   17,  0,  2,  0 }, {     16,   16,   17,  0,  2,  0 },
    {     15,   16,   18,  0,  2,  0 }, {     14,   16,   18,  0,  2,  0 }, {     13,   16,   19,  0,  2,  0 }, {     12,   16,   19,  0,  1,  0 }, {     11,   16,   20,  0,  1,  0 },
    {     10,   16,   20,  0,  1,  0 }, {      9,   16,   21,  0,  1,  0 }, {      8,   16,   21,  0,  1,  0 }, {      7,   16,   21,  0,  1,  0 }, {      6,   16,   22,  0,  1,  0 },
    {      5,   16,   22,  0,  1,  0 }, {      4,   16,   22,  0,  0,  0 }, {      3,   16,   23,  0,  0,  0 }, {      2,   16,   23,  0,  0,  0 }, {      1,   16,   23,  0,  0,  0 },
    {      0,   16,   23,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7290, {
    {     16,    0,    0,  8,  4,  0 }, {     16,    0,    1,  8,  4,  0 }, {     16,    1,    2,  8,  4,  0 }, {     16,    1,    3,  8,  4,  0 }, {     16,    2,    4,  8,  4,  0 },
    {     16,    2,    5,  8,  4,  0 }, {     16,    3,    6,  8,  4,  0 }, {     16,    4,    7,  8,  3,  0 }, {     16,    4,    8,  8,  3,  0 }, {     16,    5,    9,  8,  3,  0 },
    {     16,    6,   10,  8,  3,  0 }, {     16,    7,   11,  8,  3,  0 }, {     16,    8,   12,  8,  3,  0 }, {     16,    9,   13,  8,  3,  0 }, {     16,   10,   14,  8,  2,  0 },
    {     16,   11,   15,  8,  2,  0 }, {     16,   12,   15,  8,  2,  0 }, {     16,   13,   16,  8,  2,  0 }, {     16,   14,   17,  8,  2,  0 }, {     16,   15,   17,  8,  2,  0 },
    {     16,   16,   18,  8,  2,  0 }, {     16,   17,   18,  8,  2,  0 }, {     16,   18,   19,  8,  2,  0 }, {     16,   19,   19,  8,  1,  0 }, {     16,   20,   20,  8,  1,  0 },
    {     16,   21,   20,  8,  1,  0 }, {     16,   22,   21,  8,  1,  0 }, {     16,   23,   21,  8,  1,  0 }, {     16,   24,   21,  8,  1,  0 }, {     16,   25,   22,  8,  1,  0 },
    {     16,   26,   22,  8,  1,  0 }, {     16,   27,   22,  8,  0,  0 }, {     16,   28,   23,  8,  0,  0 }, {     16,   29,   23,  8,  0,  0 }, {     16,   30,   23,  8,  0,  0 },
    {     16,   31,   23,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C73D6, {
    {      0,   16,    0, 16,  4,  0 }, {      0,   16,    1, 16,  4,  0 }, {      1,   16,    2, 16,  4,  0 }, {      1,   16,    3, 16,  4,  0 }, {      2,   16,    4, 16,  4,  0 },
    {      2,   16,    5, 16,  4,  0 }, {      3,   16,    6, 16,  4,  0 }, {      4,   16,    7, 16,  3,  0 }, {      4,   16,    8, 16,  3,  0 }, {      5,   16,    9, 16,  3,  0 },
    {      6,   16,   10, 16,  3,  0 }, {      7,   16,   11, 16,  3,  0 }, {      8,   16,   12, 16,  3,  0 }, {      9,   16,   13, 16,  3,  0 }, {     10,   16,   14, 16,  2,  0 },
    {     11,   16,   15, 16,  2,  0 }, {     12,   16,   15, 16,  2,  0 }, {     13,   16,   16, 16,  2,  0 }, {     14,   16,   17, 16,  2,  0 }, {     15,   16,   17, 16,  2,  0 },
    {     16,   16,   18, 16,  2,  0 }, {     17,   16,   18, 16,  2,  0 }, {     18,   16,   19, 16,  2,  0 }, {     19,   16,   19, 16,  1,  0 }, {     20,   16,   20, 16,  1,  0 },
    {     21,   16,   20, 16,  1,  0 }, {     22,   16,   21, 16,  1,  0 }, {     23,   16,   21, 16,  1,  0 }, {     24,   16,   21, 16,  1,  0 }, {     25,   16,   22, 16,  1,  0 },
    {     26,   16,   22, 16,  1,  0 }, {     27,   16,   22, 16,  0,  0 }, {     28,   16,   23, 16,  0,  0 }, {     29,   16,   23, 16,  0,  0 }, {     30,   16,   23, 16,  0,  0 },
    {     31,   16,   23, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C751C, {
    {     16,   31,    0, 24,  4,  0 }, {     16,   31,    1, 24,  4,  0 }, {     16,   30,    2, 24,  4,  0 }, {     16,   30,    3, 24,  4,  0 }, {     16,   29,    4, 24,  4,  0 },
    {     16,   29,    5, 24,  4,  0 }, {     16,   28,    6, 24,  4,  0 }, {     16,   27,    7, 24,  3,  0 }, {     16,   27,    8, 24,  3,  0 }, {     16,   26,    9, 24,  3,  0 },
    {     16,   25,   10, 24,  3,  0 }, {     16,   24,   11, 24,  3,  0 }, {     16,   23,   12, 24,  3,  0 }, {     16,   22,   13, 24,  3,  0 }, {     16,   21,   14, 24,  2,  0 },
    {     16,   20,   15, 24,  2,  0 }, {     16,   19,   15, 24,  2,  0 }, {     16,   18,   16, 24,  2,  0 }, {     16,   17,   17, 24,  2,  0 }, {     16,   16,   17, 24,  2,  0 },
    {     16,   15,   18, 24,  2,  0 }, {     16,   14,   18, 24,  2,  0 }, {     16,   13,   19, 24,  2,  0 }, {     16,   12,   19, 24,  1,  0 }, {     16,   11,   20, 24,  1,  0 },
    {     16,   10,   20, 24,  1,  0 }, {     16,    9,   21, 24,  1,  0 }, {     16,    8,   21, 24,  1,  0 }, {     16,    7,   21, 24,  1,  0 }, {     16,    6,   22, 24,  1,  0 },
    {     16,    5,   22, 24,  1,  0 }, {     16,    4,   22, 24,  0,  0 }, {     16,    3,   23, 24,  0,  0 }, {     16,    2,   23, 24,  0,  0 }, {     16,    1,   23, 24,  0,  0 },
    {     16,    0,   23, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7662, {
    {     31,   16,   23,  0,  0,  0 }, {     30,   16,   23,  0,  0,  0 }, {     29,   16,   23,  0,  0,  0 }, {     28,   16,   23,  0,  0,  0 }, {     27,   16,   22,  0,  0,  0 },
    {     26,   16,   22,  0,  5,  0 }, {     25,   16,   22,  0,  5,  0 }, {     24,   16,   21,  0,  5,  0 }, {     23,   16,   21,  0,  5,  0 }, {     22,   16,   21,  0,  5,  0 },
    {     21,   16,   20,  0,  5,  0 }, {     20,   16,   20,  0,  5,  0 }, {     19,   16,   19,  0,  5,  0 }, {     18,   16,   19,  0,  6,  0 }, {     17,   16,   18,  0,  6,  0 },
    {     16,   16,   18,  0,  6,  0 }, {     15,   16,   17,  0,  6,  0 }, {     14,   16,   17,  0,  6,  0 }, {     13,   16,   16,  0,  6,  0 }, {     12,   16,   15,  0,  6,  0 },
    {     11,   16,   15,  0,  6,  0 }, {     10,   16,   14,  0,  6,  0 }, {      9,   16,   13,  0,  7,  0 }, {      8,   16,   12,  0,  7,  0 }, {      7,   16,   11,  0,  7,  0 },
    {      6,   16,   10,  0,  7,  0 }, {      5,   16,    9,  0,  7,  0 }, {      4,   16,    8,  0,  7,  0 }, {      4,   16,    7,  0,  7,  0 }, {      3,   16,    6,  0,  8,  0 },
    {      2,   16,    5,  0,  8,  0 }, {      2,   16,    4,  0,  8,  0 }, {      1,   16,    3,  0,  8,  0 }, {      1,   16,    2,  0,  8,  0 }, {      0,   16,    1,  0,  8,  0 },
    {      0,   16,    0,  0,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C77A8, {
    {     16,    0,   23,  8,  0,  0 }, {     16,    1,   23,  8,  0,  0 }, {     16,    2,   23,  8,  0,  0 }, {     16,    3,   23,  8,  0,  0 }, {     16,    4,   22,  8,  0,  0 },
    {     16,    5,   22,  8,  5,  0 }, {     16,    6,   22,  8,  5,  0 }, {     16,    7,   21,  8,  5,  0 }, {     16,    8,   21,  8,  5,  0 }, {     16,    9,   21,  8,  5,  0 },
    {     16,   10,   20,  8,  5,  0 }, {     16,   11,   20,  8,  5,  0 }, {     16,   12,   19,  8,  5,  0 }, {     16,   13,   19,  8,  6,  0 }, {     16,   14,   18,  8,  6,  0 },
    {     16,   15,   18,  8,  6,  0 }, {     16,   16,   17,  8,  6,  0 }, {     16,   17,   17,  8,  6,  0 }, {     16,   18,   16,  8,  6,  0 }, {     16,   19,   15,  8,  6,  0 },
    {     16,   20,   15,  8,  6,  0 }, {     16,   21,   14,  8,  6,  0 }, {     16,   22,   13,  8,  7,  0 }, {     16,   23,   12,  8,  7,  0 }, {     16,   24,   11,  8,  7,  0 },
    {     16,   25,   10,  8,  7,  0 }, {     16,   26,    9,  8,  7,  0 }, {     16,   27,    8,  8,  7,  0 }, {     16,   27,    7,  8,  7,  0 }, {     16,   28,    6,  8,  8,  0 },
    {     16,   29,    5,  8,  8,  0 }, {     16,   29,    4,  8,  8,  0 }, {     16,   30,    3,  8,  8,  0 }, {     16,   30,    2,  8,  8,  0 }, {     16,   31,    1,  8,  8,  0 },
    {     16,   31,    0,  8,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C78EE, {
    {      0,   16,   23, 16,  0,  0 }, {      1,   16,   23, 16,  0,  0 }, {      2,   16,   23, 16,  0,  0 }, {      3,   16,   23, 16,  0,  0 }, {      4,   16,   22, 16,  0,  0 },
    {      5,   16,   22, 16,  5,  0 }, {      6,   16,   22, 16,  5,  0 }, {      7,   16,   21, 16,  5,  0 }, {      8,   16,   21, 16,  5,  0 }, {      9,   16,   21, 16,  5,  0 },
    {     10,   16,   20, 16,  5,  0 }, {     11,   16,   20, 16,  5,  0 }, {     12,   16,   19, 16,  5,  0 }, {     13,   16,   19, 16,  6,  0 }, {     14,   16,   18, 16,  6,  0 },
    {     15,   16,   18, 16,  6,  0 }, {     16,   16,   17, 16,  6,  0 }, {     17,   16,   17, 16,  6,  0 }, {     18,   16,   16, 16,  6,  0 }, {     19,   16,   15, 16,  6,  0 },
    {     20,   16,   15, 16,  6,  0 }, {     21,   16,   14, 16,  6,  0 }, {     22,   16,   13, 16,  7,  0 }, {     23,   16,   12, 16,  7,  0 }, {     24,   16,   11, 16,  7,  0 },
    {     25,   16,   10, 16,  7,  0 }, {     26,   16,    9, 16,  7,  0 }, {     27,   16,    8, 16,  7,  0 }, {     27,   16,    7, 16,  7,  0 }, {     28,   16,    6, 16,  8,  0 },
    {     29,   16,    5, 16,  8,  0 }, {     29,   16,    4, 16,  8,  0 }, {     30,   16,    3, 16,  8,  0 }, {     30,   16,    2, 16,  8,  0 }, {     31,   16,    1, 16,  8,  0 },
    {     31,   16,    0, 16,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7A34, {
    {     16,   31,   23, 24,  0,  0 }, {     16,   30,   23, 24,  0,  0 }, {     16,   29,   23, 24,  0,  0 }, {     16,   28,   23, 24,  0,  0 }, {     16,   27,   22, 24,  0,  0 },
    {     16,   26,   22, 24,  5,  0 }, {     16,   25,   22, 24,  5,  0 }, {     16,   24,   21, 24,  5,  0 }, {     16,   23,   21, 24,  5,  0 }, {     16,   22,   21, 24,  5,  0 },
    {     16,   21,   20, 24,  5,  0 }, {     16,   20,   20, 24,  5,  0 }, {     16,   19,   19, 24,  5,  0 }, {     16,   18,   19, 24,  6,  0 }, {     16,   17,   18, 24,  6,  0 },
    {     16,   16,   18, 24,  6,  0 }, {     16,   15,   17, 24,  6,  0 }, {     16,   14,   17, 24,  6,  0 }, {     16,   13,   16, 24,  6,  0 }, {     16,   12,   15, 24,  6,  0 },
    {     16,   11,   15, 24,  6,  0 }, {     16,   10,   14, 24,  6,  0 }, {     16,    9,   13, 24,  7,  0 }, {     16,    8,   12, 24,  7,  0 }, {     16,    7,   11, 24,  7,  0 },
    {     16,    6,   10, 24,  7,  0 }, {     16,    5,    9, 24,  7,  0 }, {     16,    4,    8, 24,  7,  0 }, {     16,    4,    7, 24,  7,  0 }, {     16,    3,    6, 24,  8,  0 },
    {     16,    2,    5, 24,  8,  0 }, {     16,    2,    4, 24,  8,  0 }, {     16,    1,    3, 24,  8,  0 }, {     16,    1,    2, 24,  8,  0 }, {     16,    0,    1, 24,  8,  0 },
    {     16,    0,    0, 24,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7B7A, {
    {     31,   16,   23,  0,  8,  0 }, {     31,   16,   22,  0,  8,  0 }, {     30,   16,   21,  0,  8,  0 }, {     30,   16,   20,  0,  8,  0 }, {     29,   16,   19,  0,  8,  0 },
    {     29,   16,   18,  0,  8,  0 }, {     28,   16,   17,  0,  8,  0 }, {     27,   16,   16,  0,  7,  0 }, {     27,   16,   15,  0,  7,  0 }, {     26,   16,   14,  0,  7,  0 },
    {     25,   16,   13,  0,  7,  0 }, {     24,   16,   12,  0,  7,  0 }, {     23,   16,   11,  0,  7,  0 }, {     22,   16,   10,  0,  7,  0 }, {     21,   16,    9,  0,  6,  0 },
    {     20,   16,    8,  0,  6,  0 }, {     19,   16,    8,  0,  6,  0 }, {     18,   16,    7,  0,  6,  0 }, {     17,   16,    6,  0,  6,  0 }, {     16,   16,    6,  0,  6,  0 },
    {     15,   16,    5,  0,  6,  0 }, {     14,   16,    5,  0,  6,  0 }, {     13,   16,    4,  0,  6,  0 }, {     12,   16,    4,  0,  5,  0 }, {     11,   16,    3,  0,  5,  0 },
    {     10,   16,    3,  0,  5,  0 }, {      9,   16,    2,  0,  5,  0 }, {      8,   16,    2,  0,  5,  0 }, {      7,   16,    2,  0,  5,  0 }, {      6,   16,    1,  0,  5,  0 },
    {      5,   16,    1,  0,  5,  0 }, {      4,   16,    1,  0,  0,  0 }, {      3,   16,    0,  0,  0,  0 }, {      2,   16,    0,  0,  0,  0 }, {      1,   16,    0,  0,  0,  0 },
    {      0,   16,    0,  0,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7CC0, {
    {     16,    0,   23,  8,  8,  0 }, {     16,    0,   22,  8,  8,  0 }, {     16,    1,   21,  8,  8,  0 }, {     16,    1,   20,  8,  8,  0 }, {     16,    2,   19,  8,  8,  0 },
    {     16,    2,   18,  8,  8,  0 }, {     16,    3,   17,  8,  8,  0 }, {     16,    4,   16,  8,  7,  0 }, {     16,    4,   15,  8,  7,  0 }, {     16,    5,   14,  8,  7,  0 },
    {     16,    6,   13,  8,  7,  0 }, {     16,    7,   12,  8,  7,  0 }, {     16,    8,   11,  8,  7,  0 }, {     16,    9,   10,  8,  7,  0 }, {     16,   10,    9,  8,  6,  0 },
    {     16,   11,    8,  8,  6,  0 }, {     16,   12,    8,  8,  6,  0 }, {     16,   13,    7,  8,  6,  0 }, {     16,   14,    6,  8,  6,  0 }, {     16,   15,    6,  8,  6,  0 },
    {     16,   16,    5,  8,  6,  0 }, {     16,   17,    5,  8,  6,  0 }, {     16,   18,    4,  8,  6,  0 }, {     16,   19,    4,  8,  5,  0 }, {     16,   20,    3,  8,  5,  0 },
    {     16,   21,    3,  8,  5,  0 }, {     16,   22,    2,  8,  5,  0 }, {     16,   23,    2,  8,  5,  0 }, {     16,   24,    2,  8,  5,  0 }, {     16,   25,    1,  8,  5,  0 },
    {     16,   26,    1,  8,  5,  0 }, {     16,   27,    1,  8,  0,  0 }, {     16,   28,    0,  8,  0,  0 }, {     16,   29,    0,  8,  0,  0 }, {     16,   30,    0,  8,  0,  0 },
    {     16,   31,    0,  8,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7E06, {
    {      0,   16,   23, 16,  8,  0 }, {      0,   16,   22, 16,  8,  0 }, {      1,   16,   21, 16,  8,  0 }, {      1,   16,   20, 16,  8,  0 }, {      2,   16,   19, 16,  8,  0 },
    {      2,   16,   18, 16,  8,  0 }, {      3,   16,   17, 16,  8,  0 }, {      4,   16,   16, 16,  7,  0 }, {      4,   16,   15, 16,  7,  0 }, {      5,   16,   14, 16,  7,  0 },
    {      6,   16,   13, 16,  7,  0 }, {      7,   16,   12, 16,  7,  0 }, {      8,   16,   11, 16,  7,  0 }, {      9,   16,   10, 16,  7,  0 }, {     10,   16,    9, 16,  6,  0 },
    {     11,   16,    8, 16,  6,  0 }, {     12,   16,    8, 16,  6,  0 }, {     13,   16,    7, 16,  6,  0 }, {     14,   16,    6, 16,  6,  0 }, {     15,   16,    6, 16,  6,  0 },
    {     16,   16,    5, 16,  6,  0 }, {     17,   16,    5, 16,  6,  0 }, {     18,   16,    4, 16,  6,  0 }, {     19,   16,    4, 16,  5,  0 }, {     20,   16,    3, 16,  5,  0 },
    {     21,   16,    3, 16,  5,  0 }, {     22,   16,    2, 16,  5,  0 }, {     23,   16,    2, 16,  5,  0 }, {     24,   16,    2, 16,  5,  0 }, {     25,   16,    1, 16,  5,  0 },
    {     26,   16,    1, 16,  5,  0 }, {     27,   16,    1, 16,  0,  0 }, {     28,   16,    0, 16,  0,  0 }, {     29,   16,    0, 16,  0,  0 }, {     30,   16,    0, 16,  0,  0 },
    {     31,   16,    0, 16,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8C7F4C, {
    {     16,   31,   23, 24,  8,  0 }, {     16,   31,   22, 24,  8,  0 }, {     16,   30,   21, 24,  8,  0 }, {     16,   30,   20, 24,  8,  0 }, {     16,   29,   19, 24,  8,  0 },
    {     16,   29,   18, 24,  8,  0 }, {     16,   28,   17, 24,  8,  0 }, {     16,   27,   16, 24,  7,  0 }, {     16,   27,   15, 24,  7,  0 }, {     16,   26,   14, 24,  7,  0 },
    {     16,   25,   13, 24,  7,  0 }, {     16,   24,   12, 24,  7,  0 }, {     16,   23,   11, 24,  7,  0 }, {     16,   22,   10, 24,  7,  0 }, {     16,   21,    9, 24,  6,  0 },
    {     16,   20,    8, 24,  6,  0 }, {     16,   19,    8, 24,  6,  0 }, {     16,   18,    7, 24,  6,  0 }, {     16,   17,    6, 24,  6,  0 }, {     16,   16,    6, 24,  6,  0 },
    {     16,   15,    5, 24,  6,  0 }, {     16,   14,    5, 24,  6,  0 }, {     16,   13,    4, 24,  6,  0 }, {     16,   12,    4, 24,  5,  0 }, {     16,   11,    3, 24,  5,  0 },
    {     16,   10,    3, 24,  5,  0 }, {     16,    9,    2, 24,  5,  0 }, {     16,    8,    2, 24,  5,  0 }, {     16,    7,    2, 24,  5,  0 }, {     16,    6,    1, 24,  5,  0 },
    {     16,    5,    1, 24,  5,  0 }, {     16,    4,    1, 24,  0,  0 }, {     16,    3,    0, 24,  0,  0 }, {     16,    2,    0, 24,  0,  0 }, {     16,    1,    0, 24,  0,  0 },
    {     16,    0,    0, 24,  0,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EFA5A, {
    {     16,   16,    2,  0, 10,  0 }, {     16,   16,    3,  0, 10,  0 }, {     16,   16,    4,  0, 10,  0 }, {     16,   16,    5,  0, 10,  0 }, {     16,   16,    6,  0, 10,  0 },
    {     16,   16,    7,  0, 10,  0 }, {     16,   16,    8,  0, 10,  0 }, {     16,   16,    9,  0, 10,  0 }, {     16,   16,   10,  0, 10,  0 }, {     16,   16,   11,  0, 10,  0 },
    {     16,   16,   12,  0, 10,  0 }, {     16,   16,   13,  0, 10,  0 }, {     16,   16,   14,  0, 10,  0 }, {     16,   16,   15,  0, 10,  0 }, {     16,   16,   16,  0, 10,  0 },
    {     16,   16,   17,  0, 10,  0 }, {     16,   16,   18,  0, 10,  0 }, {     16,   16,   19,  0, 10,  0 }, {     16,   16,   20,  0, 10,  0 }, {     16,   16,   21,  0, 10,  0 },
    {     16,   16,   22,  0, 10,  0 }, {     16,   16,   23,  0, 10,  0 }, {     16,   16,   24,  0, 10,  0 }, {     16,   16,   25,  0, 10,  0 }, {     16,   16,   26,  0, 10,  0 },
    {     16,   16,   27,  0, 10,  0 }, {     16,   16,   28,  0, 10,  0 }, {     16,   16,   29,  0, 10,  0 }, {     16,   16,   30,  0, 10,  0 }, {     16,   16,   31,  0, 10,  0 },
    {     16,   16,   32,  0, 10,  0 }, {     16,   16,   33,  0, 10,  0 }, {     16,   16,   34,  0, 10,  0 }, {     16,   16,   35,  0, 10,  0 }, {     16,   16,   36,  0, 10,  0 },
    {     16,   16,   37,  0, 10,  0 }, {     16,   16,   38,  0, 10,  0 }, {     16,   16,   39,  0, 10,  0 }, {     16,   16,   40,  0, 10,  0 }, {     16,   16,   41,  0, 10,  0 },
    {     16,   16,   42,  0, 10,  0 }, {     16,   16,   43,  0, 10,  0 }, {     16,   16,   44,  0, 10,  0 }, {     16,   16,   45,  0, 10,  0 }, {     16,   16,   46,  0, 10,  0 },
    {     16,   16,   47,  0, 10,  0 }, {     16,   16,   48,  0, 10,  0 }, {     16,   16,   49,  0, 10,  0 }, {     16,   16,   50,  0, 10,  0 }, {     16,   16,   51,  0, 10,  0 },
    {     16,   16,   52,  0, 10,  0 }, {     16,   16,   53,  0, 10,  0 }, {     16,   16,   54,  0, 10,  0 }, {     16,   16,   55,  0, 10,  0 }, {     16,   16,   56,  0, 10,  0 },
    {     16,   16,   57,  0, 10,  0 }, {     16,   16,   58,  0, 10,  0 }, {     16,   16,   59,  0, 10,  0 }, {     16,   16,   60,  0, 10,  0 }, {     16,   16,   61,  0, 10,  0 },
    {     16,   16,   62,  0, 10,  0 }, {     16,   16,   63,  0, 10,  0 }, {     16,   16,   64,  0, 10,  0 }, {     16,   16,   65,  0, 10,  0 }, {     16,   16,   66,  0, 10,  0 },
    {     16,   16,   67,  0, 10,  0 }, {     16,   16,   68,  0, 10,  0 }, {     16,   16,   69,  0, 10,  0 }, {     16,   16,   70,  0, 10,  0 }, {     16,   16,   71,  0, 10,  0 },
    {     16,   16,   72,  0, 10,  0 }, {     16,   16,   73,  0, 10,  0 }, {     16,   16,   74,  0, 10,  0 }, {     16,   16,   75,  0, 10,  0 }, {     16,   16,   76,  0, 10,  0 },
    {     16,   16,   77,  0, 10,  0 }, {     16,   16,   78,  0, 10,  0 }, {     16,   16,   79,  0, 10,  0 }, {     16,   16,   80,  0, 10,  0 }, {     16,   16,   81,  0, 10,  0 },
    {     16,   16,   82,  0, 10,  0 }, {     16,   16,   83,  0, 10,  0 }, {     16,   16,   84,  0, 10,  0 }, {     16,   16,   85,  0, 10,  0 }, {     16,   16,   86,  0, 10,  0 },
    {     16,   16,   87,  0, 10,  0 }, {     16,   16,   88,  0, 10,  0 }, {     16,   16,   89,  0, 10,  0 }, {     16,   16,   90,  0, 10,  0 }, {     16,   16,   91,  0, 10,  0 },
    {     16,   16,   92,  0, 10,  0 }, {     16,   16,   93,  0, 10,  0 }, {     16,   16,   94,  0, 10,  0 }, {     16,   16,   95,  0, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8EFDAA, {
    {     16,   16,    2,  8, 10,  0 }, {     16,   16,    3,  8, 10,  0 }, {     16,   16,    4,  8, 10,  0 }, {     16,   16,    5,  8, 10,  0 }, {     16,   16,    6,  8, 10,  0 },
    {     16,   16,    7,  8, 10,  0 }, {     16,   16,    8,  8, 10,  0 }, {     16,   16,    9,  8, 10,  0 }, {     16,   16,   10,  8, 10,  0 }, {     16,   16,   11,  8, 10,  0 },
    {     16,   16,   12,  8, 10,  0 }, {     16,   16,   13,  8, 10,  0 }, {     16,   16,   14,  8, 10,  0 }, {     16,   16,   15,  8, 10,  0 }, {     16,   16,   16,  8, 10,  0 },
    {     16,   16,   17,  8, 10,  0 }, {     16,   16,   18,  8, 10,  0 }, {     16,   16,   19,  8, 10,  0 }, {     16,   16,   20,  8, 10,  0 }, {     16,   16,   21,  8, 10,  0 },
    {     16,   16,   22,  8, 10,  0 }, {     16,   16,   23,  8, 10,  0 }, {     16,   16,   24,  8, 10,  0 }, {     16,   16,   25,  8, 10,  0 }, {     16,   16,   26,  8, 10,  0 },
    {     16,   16,   27,  8, 10,  0 }, {     16,   16,   28,  8, 10,  0 }, {     16,   16,   29,  8, 10,  0 }, {     16,   16,   30,  8, 10,  0 }, {     16,   16,   31,  8, 10,  0 },
    {     16,   16,   32,  8, 10,  0 }, {     16,   16,   33,  8, 10,  0 }, {     16,   16,   34,  8, 10,  0 }, {     16,   16,   35,  8, 10,  0 }, {     16,   16,   36,  8, 10,  0 },
    {     16,   16,   37,  8, 10,  0 }, {     16,   16,   38,  8, 10,  0 }, {     16,   16,   39,  8, 10,  0 }, {     16,   16,   40,  8, 10,  0 }, {     16,   16,   41,  8, 10,  0 },
    {     16,   16,   42,  8, 10,  0 }, {     16,   16,   43,  8, 10,  0 }, {     16,   16,   44,  8, 10,  0 }, {     16,   16,   45,  8, 10,  0 }, {     16,   16,   46,  8, 10,  0 },
    {     16,   16,   47,  8, 10,  0 }, {     16,   16,   48,  8, 10,  0 }, {     16,   16,   49,  8, 10,  0 }, {     16,   16,   50,  8, 10,  0 }, {     16,   16,   51,  8, 10,  0 },
    {     16,   16,   52,  8, 10,  0 }, {     16,   16,   53,  8, 10,  0 }, {     16,   16,   54,  8, 10,  0 }, {     16,   16,   55,  8, 10,  0 }, {     16,   16,   56,  8, 10,  0 },
    {     16,   16,   57,  8, 10,  0 }, {     16,   16,   58,  8, 10,  0 }, {     16,   16,   59,  8, 10,  0 }, {     16,   16,   60,  8, 10,  0 }, {     16,   16,   61,  8, 10,  0 },
    {     16,   16,   62,  8, 10,  0 }, {     16,   16,   63,  8, 10,  0 }, {     16,   16,   64,  8, 10,  0 }, {     16,   16,   65,  8, 10,  0 }, {     16,   16,   66,  8, 10,  0 },
    {     16,   16,   67,  8, 10,  0 }, {     16,   16,   68,  8, 10,  0 }, {     16,   16,   69,  8, 10,  0 }, {     16,   16,   70,  8, 10,  0 }, {     16,   16,   71,  8, 10,  0 },
    {     16,   16,   72,  8, 10,  0 }, {     16,   16,   73,  8, 10,  0 }, {     16,   16,   74,  8, 10,  0 }, {     16,   16,   75,  8, 10,  0 }, {     16,   16,   76,  8, 10,  0 },
    {     16,   16,   77,  8, 10,  0 }, {     16,   16,   78,  8, 10,  0 }, {     16,   16,   79,  8, 10,  0 }, {     16,   16,   80,  8, 10,  0 }, {     16,   16,   81,  8, 10,  0 },
    {     16,   16,   82,  8, 10,  0 }, {     16,   16,   83,  8, 10,  0 }, {     16,   16,   84,  8, 10,  0 }, {     16,   16,   85,  8, 10,  0 }, {     16,   16,   86,  8, 10,  0 },
    {     16,   16,   87,  8, 10,  0 }, {     16,   16,   88,  8, 10,  0 }, {     16,   16,   89,  8, 10,  0 }, {     16,   16,   90,  8, 10,  0 }, {     16,   16,   91,  8, 10,  0 },
    {     16,   16,   92,  8, 10,  0 }, {     16,   16,   93,  8, 10,  0 }, {     16,   16,   94,  8, 10,  0 }, {     16,   16,   95,  8, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F00FA, {
    {     16,   16,    2, 16, 10,  0 }, {     16,   16,    3, 16, 10,  0 }, {     16,   16,    4, 16, 10,  0 }, {     16,   16,    5, 16, 10,  0 }, {     16,   16,    6, 16, 10,  0 },
    {     16,   16,    7, 16, 10,  0 }, {     16,   16,    8, 16, 10,  0 }, {     16,   16,    9, 16, 10,  0 }, {     16,   16,   10, 16, 10,  0 }, {     16,   16,   11, 16, 10,  0 },
    {     16,   16,   12, 16, 10,  0 }, {     16,   16,   13, 16, 10,  0 }, {     16,   16,   14, 16, 10,  0 }, {     16,   16,   15, 16, 10,  0 }, {     16,   16,   16, 16, 10,  0 },
    {     16,   16,   17, 16, 10,  0 }, {     16,   16,   18, 16, 10,  0 }, {     16,   16,   19, 16, 10,  0 }, {     16,   16,   20, 16, 10,  0 }, {     16,   16,   21, 16, 10,  0 },
    {     16,   16,   22, 16, 10,  0 }, {     16,   16,   23, 16, 10,  0 }, {     16,   16,   24, 16, 10,  0 }, {     16,   16,   25, 16, 10,  0 }, {     16,   16,   26, 16, 10,  0 },
    {     16,   16,   27, 16, 10,  0 }, {     16,   16,   28, 16, 10,  0 }, {     16,   16,   29, 16, 10,  0 }, {     16,   16,   30, 16, 10,  0 }, {     16,   16,   31, 16, 10,  0 },
    {     16,   16,   32, 16, 10,  0 }, {     16,   16,   33, 16, 10,  0 }, {     16,   16,   34, 16, 10,  0 }, {     16,   16,   35, 16, 10,  0 }, {     16,   16,   36, 16, 10,  0 },
    {     16,   16,   37, 16, 10,  0 }, {     16,   16,   38, 16, 10,  0 }, {     16,   16,   39, 16, 10,  0 }, {     16,   16,   40, 16, 10,  0 }, {     16,   16,   41, 16, 10,  0 },
    {     16,   16,   42, 16, 10,  0 }, {     16,   16,   43, 16, 10,  0 }, {     16,   16,   44, 16, 10,  0 }, {     16,   16,   45, 16, 10,  0 }, {     16,   16,   46, 16, 10,  0 },
    {     16,   16,   47, 16, 10,  0 }, {     16,   16,   48, 16, 10,  0 }, {     16,   16,   49, 16, 10,  0 }, {     16,   16,   50, 16, 10,  0 }, {     16,   16,   51, 16, 10,  0 },
    {     16,   16,   52, 16, 10,  0 }, {     16,   16,   53, 16, 10,  0 }, {     16,   16,   54, 16, 10,  0 }, {     16,   16,   55, 16, 10,  0 }, {     16,   16,   56, 16, 10,  0 },
    {     16,   16,   57, 16, 10,  0 }, {     16,   16,   58, 16, 10,  0 }, {     16,   16,   59, 16, 10,  0 }, {     16,   16,   60, 16, 10,  0 }, {     16,   16,   61, 16, 10,  0 },
    {     16,   16,   62, 16, 10,  0 }, {     16,   16,   63, 16, 10,  0 }, {     16,   16,   64, 16, 10,  0 }, {     16,   16,   65, 16, 10,  0 }, {     16,   16,   66, 16, 10,  0 },
    {     16,   16,   67, 16, 10,  0 }, {     16,   16,   68, 16, 10,  0 }, {     16,   16,   69, 16, 10,  0 }, {     16,   16,   70, 16, 10,  0 }, {     16,   16,   71, 16, 10,  0 },
    {     16,   16,   72, 16, 10,  0 }, {     16,   16,   73, 16, 10,  0 }, {     16,   16,   74, 16, 10,  0 }, {     16,   16,   75, 16, 10,  0 }, {     16,   16,   76, 16, 10,  0 },
    {     16,   16,   77, 16, 10,  0 }, {     16,   16,   78, 16, 10,  0 }, {     16,   16,   79, 16, 10,  0 }, {     16,   16,   80, 16, 10,  0 }, {     16,   16,   81, 16, 10,  0 },
    {     16,   16,   82, 16, 10,  0 }, {     16,   16,   83, 16, 10,  0 }, {     16,   16,   84, 16, 10,  0 }, {     16,   16,   85, 16, 10,  0 }, {     16,   16,   86, 16, 10,  0 },
    {     16,   16,   87, 16, 10,  0 }, {     16,   16,   88, 16, 10,  0 }, {     16,   16,   89, 16, 10,  0 }, {     16,   16,   90, 16, 10,  0 }, {     16,   16,   91, 16, 10,  0 },
    {     16,   16,   92, 16, 10,  0 }, {     16,   16,   93, 16, 10,  0 }, {     16,   16,   94, 16, 10,  0 }, {     16,   16,   95, 16, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F044A, {
    {     16,   16,    2, 24, 10,  0 }, {     16,   16,    3, 24, 10,  0 }, {     16,   16,    4, 24, 10,  0 }, {     16,   16,    5, 24, 10,  0 }, {     16,   16,    6, 24, 10,  0 },
    {     16,   16,    7, 24, 10,  0 }, {     16,   16,    8, 24, 10,  0 }, {     16,   16,    9, 24, 10,  0 }, {     16,   16,   10, 24, 10,  0 }, {     16,   16,   11, 24, 10,  0 },
    {     16,   16,   12, 24, 10,  0 }, {     16,   16,   13, 24, 10,  0 }, {     16,   16,   14, 24, 10,  0 }, {     16,   16,   15, 24, 10,  0 }, {     16,   16,   16, 24, 10,  0 },
    {     16,   16,   17, 24, 10,  0 }, {     16,   16,   18, 24, 10,  0 }, {     16,   16,   19, 24, 10,  0 }, {     16,   16,   20, 24, 10,  0 }, {     16,   16,   21, 24, 10,  0 },
    {     16,   16,   22, 24, 10,  0 }, {     16,   16,   23, 24, 10,  0 }, {     16,   16,   24, 24, 10,  0 }, {     16,   16,   25, 24, 10,  0 }, {     16,   16,   26, 24, 10,  0 },
    {     16,   16,   27, 24, 10,  0 }, {     16,   16,   28, 24, 10,  0 }, {     16,   16,   29, 24, 10,  0 }, {     16,   16,   30, 24, 10,  0 }, {     16,   16,   31, 24, 10,  0 },
    {     16,   16,   32, 24, 10,  0 }, {     16,   16,   33, 24, 10,  0 }, {     16,   16,   34, 24, 10,  0 }, {     16,   16,   35, 24, 10,  0 }, {     16,   16,   36, 24, 10,  0 },
    {     16,   16,   37, 24, 10,  0 }, {     16,   16,   38, 24, 10,  0 }, {     16,   16,   39, 24, 10,  0 }, {     16,   16,   40, 24, 10,  0 }, {     16,   16,   41, 24, 10,  0 },
    {     16,   16,   42, 24, 10,  0 }, {     16,   16,   43, 24, 10,  0 }, {     16,   16,   44, 24, 10,  0 }, {     16,   16,   45, 24, 10,  0 }, {     16,   16,   46, 24, 10,  0 },
    {     16,   16,   47, 24, 10,  0 }, {     16,   16,   48, 24, 10,  0 }, {     16,   16,   49, 24, 10,  0 }, {     16,   16,   50, 24, 10,  0 }, {     16,   16,   51, 24, 10,  0 },
    {     16,   16,   52, 24, 10,  0 }, {     16,   16,   53, 24, 10,  0 }, {     16,   16,   54, 24, 10,  0 }, {     16,   16,   55, 24, 10,  0 }, {     16,   16,   56, 24, 10,  0 },
    {     16,   16,   57, 24, 10,  0 }, {     16,   16,   58, 24, 10,  0 }, {     16,   16,   59, 24, 10,  0 }, {     16,   16,   60, 24, 10,  0 }, {     16,   16,   61, 24, 10,  0 },
    {     16,   16,   62, 24, 10,  0 }, {     16,   16,   63, 24, 10,  0 }, {     16,   16,   64, 24, 10,  0 }, {     16,   16,   65, 24, 10,  0 }, {     16,   16,   66, 24, 10,  0 },
    {     16,   16,   67, 24, 10,  0 }, {     16,   16,   68, 24, 10,  0 }, {     16,   16,   69, 24, 10,  0 }, {     16,   16,   70, 24, 10,  0 }, {     16,   16,   71, 24, 10,  0 },
    {     16,   16,   72, 24, 10,  0 }, {     16,   16,   73, 24, 10,  0 }, {     16,   16,   74, 24, 10,  0 }, {     16,   16,   75, 24, 10,  0 }, {     16,   16,   76, 24, 10,  0 },
    {     16,   16,   77, 24, 10,  0 }, {     16,   16,   78, 24, 10,  0 }, {     16,   16,   79, 24, 10,  0 }, {     16,   16,   80, 24, 10,  0 }, {     16,   16,   81, 24, 10,  0 },
    {     16,   16,   82, 24, 10,  0 }, {     16,   16,   83, 24, 10,  0 }, {     16,   16,   84, 24, 10,  0 }, {     16,   16,   85, 24, 10,  0 }, {     16,   16,   86, 24, 10,  0 },
    {     16,   16,   87, 24, 10,  0 }, {     16,   16,   88, 24, 10,  0 }, {     16,   16,   89, 24, 10,  0 }, {     16,   16,   90, 24, 10,  0 }, {     16,   16,   91, 24, 10,  0 },
    {     16,   16,   92, 24, 10,  0 }, {     16,   16,   93, 24, 10,  0 }, {     16,   16,   94, 24, 10,  0 }, {     16,   16,   95, 24, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F079A, {
    {     16,   16,    0,  0, 10,  0 }, {     16,   16,    1,  0, 10,  0 }, {     16,   16,    2,  0, 10,  0 }, {     16,   16,    3,  0, 10,  0 }, {     16,   16,    4,  0, 10,  0 },
    {     16,   16,    5,  0, 10,  0 }, {     16,   16,    6,  0, 10,  0 }, {     16,   16,    7,  0, 10,  0 }, {     16,   16,    8,  0, 10,  0 }, {     16,   16,    9,  0, 10,  0 },
    {     16,   16,   10,  0, 10,  0 }, {     16,   16,   11,  0, 10,  0 }, {     16,   16,   12,  0, 10,  0 }, {     16,   16,   13,  0, 10,  0 }, {     16,   16,   14,  0, 10,  0 },
    {     16,   16,   15,  0, 10,  0 }, {     16,   16,   16,  0, 10,  0 }, {     16,   16,   17,  0, 10,  0 }, {     16,   16,   18,  0, 10,  0 }, {     16,   16,   19,  0, 10,  0 },
    {     16,   16,   20,  0, 10,  0 }, {     16,   16,   21,  0, 10,  0 }, {     16,   16,   22,  0, 10,  0 }, {     16,   16,   23,  0, 10,  0 }, {     16,   16,   24,  0, 10,  0 },
    {     16,   16,   25,  0, 10,  0 }, {     16,   16,   26,  0, 10,  0 }, {     16,   16,   27,  0, 10,  0 }, {     16,   16,   28,  0, 10,  0 }, {     16,   16,   29,  0, 10,  0 },
    {     16,   16,   30,  0, 10,  0 }, {     16,   16,   31,  0, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F08BC, {
    {     16,   16,    0,  8, 10,  0 }, {     16,   16,    1,  8, 10,  0 }, {     16,   16,    2,  8, 10,  0 }, {     16,   16,    3,  8, 10,  0 }, {     16,   16,    4,  8, 10,  0 },
    {     16,   16,    5,  8, 10,  0 }, {     16,   16,    6,  8, 10,  0 }, {     16,   16,    7,  8, 10,  0 }, {     16,   16,    8,  8, 10,  0 }, {     16,   16,    9,  8, 10,  0 },
    {     16,   16,   10,  8, 10,  0 }, {     16,   16,   11,  8, 10,  0 }, {     16,   16,   12,  8, 10,  0 }, {     16,   16,   13,  8, 10,  0 }, {     16,   16,   14,  8, 10,  0 },
    {     16,   16,   15,  8, 10,  0 }, {     16,   16,   16,  8, 10,  0 }, {     16,   16,   17,  8, 10,  0 }, {     16,   16,   18,  8, 10,  0 }, {     16,   16,   19,  8, 10,  0 },
    {     16,   16,   20,  8, 10,  0 }, {     16,   16,   21,  8, 10,  0 }, {     16,   16,   22,  8, 10,  0 }, {     16,   16,   23,  8, 10,  0 }, {     16,   16,   24,  8, 10,  0 },
    {     16,   16,   25,  8, 10,  0 }, {     16,   16,   26,  8, 10,  0 }, {     16,   16,   27,  8, 10,  0 }, {     16,   16,   28,  8, 10,  0 }, {     16,   16,   29,  8, 10,  0 },
    {     16,   16,   30,  8, 10,  0 }, {     16,   16,   31,  8, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F09DE, {
    {     16,   16,    0, 16, 10,  0 }, {     16,   16,    1, 16, 10,  0 }, {     16,   16,    2, 16, 10,  0 }, {     16,   16,    3, 16, 10,  0 }, {     16,   16,    4, 16, 10,  0 },
    {     16,   16,    5, 16, 10,  0 }, {     16,   16,    6, 16, 10,  0 }, {     16,   16,    7, 16, 10,  0 }, {     16,   16,    8, 16, 10,  0 }, {     16,   16,    9, 16, 10,  0 },
    {     16,   16,   10, 16, 10,  0 }, {     16,   16,   11, 16, 10,  0 }, {     16,   16,   12, 16, 10,  0 }, {     16,   16,   13, 16, 10,  0 }, {     16,   16,   14, 16, 10,  0 },
    {     16,   16,   15, 16, 10,  0 }, {     16,   16,   16, 16, 10,  0 }, {     16,   16,   17, 16, 10,  0 }, {     16,   16,   18, 16, 10,  0 }, {     16,   16,   19, 16, 10,  0 },
    {     16,   16,   20, 16, 10,  0 }, {     16,   16,   21, 16, 10,  0 }, {     16,   16,   22, 16, 10,  0 }, {     16,   16,   23, 16, 10,  0 }, {     16,   16,   24, 16, 10,  0 },
    {     16,   16,   25, 16, 10,  0 }, {     16,   16,   26, 16, 10,  0 }, {     16,   16,   27, 16, 10,  0 }, {     16,   16,   28, 16, 10,  0 }, {     16,   16,   29, 16, 10,  0 },
    {     16,   16,   30, 16, 10,  0 }, {     16,   16,   31, 16, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F0B00, {
    {     16,   16,    0, 24, 10,  0 }, {     16,   16,    1, 24, 10,  0 }, {     16,   16,    2, 24, 10,  0 }, {     16,   16,    3, 24, 10,  0 }, {     16,   16,    4, 24, 10,  0 },
    {     16,   16,    5, 24, 10,  0 }, {     16,   16,    6, 24, 10,  0 }, {     16,   16,    7, 24, 10,  0 }, {     16,   16,    8, 24, 10,  0 }, {     16,   16,    9, 24, 10,  0 },
    {     16,   16,   10, 24, 10,  0 }, {     16,   16,   11, 24, 10,  0 }, {     16,   16,   12, 24, 10,  0 }, {     16,   16,   13, 24, 10,  0 }, {     16,   16,   14, 24, 10,  0 },
    {     16,   16,   15, 24, 10,  0 }, {     16,   16,   16, 24, 10,  0 }, {     16,   16,   17, 24, 10,  0 }, {     16,   16,   18, 24, 10,  0 }, {     16,   16,   19, 24, 10,  0 },
    {     16,   16,   20, 24, 10,  0 }, {     16,   16,   21, 24, 10,  0 }, {     16,   16,   22, 24, 10,  0 }, {     16,   16,   23, 24, 10,  0 }, {     16,   16,   24, 24, 10,  0 },
    {     16,   16,   25, 24, 10,  0 }, {     16,   16,   26, 24, 10,  0 }, {     16,   16,   27, 24, 10,  0 }, {     16,   16,   28, 24, 10,  0 }, {     16,   16,   29, 24, 10,  0 },
    {     16,   16,   30, 24, 10,  0 }, {     16,   16,   31, 24, 10,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F8C82, {
    {     31,   16,    0,  0, 45,  2 }, {     30,   16,    0,  0, 45,  2 }, {     29,   16,    0,  0, 45,  2 }, {     28,   16,    0,  0, 45,  2 }, {     27,   16,    0, 31, 45,  2 },
    {     26,   16,    0, 31, 45,  2 }, {     25,   15,    0, 31, 45,  2 }, {     24,   15,    0, 31, 45,  2 }, {     23,   15,    1, 31, 45,  2 }, {     22,   15,    1, 31, 45,  2 },
    {     21,   15,    1, 31, 45,  2 }, {     20,   15,    1, 31, 45,  2 }, {     19,   14,    1, 31, 45,  2 }, {     18,   14,    1, 30, 45,  2 }, {     17,   14,    1, 30, 45,  2 },
    {     16,   13,    1, 30, 45,  2 }, {     15,   13,    2, 30, 45,  2 }, {     14,   13,    2, 30, 45,  2 }, {     13,   12,    2, 30, 45,  2 }, {     12,   12,    2, 30, 45,  2 },
    {     11,   11,    2, 30, 45,  2 }, {     10,   11,    2, 30, 45,  2 }, {      9,   10,    2, 30, 45,  2 }, {      8,   10,    2, 29, 45,  2 }, {      7,    9,    2, 29, 45,  2 },
    {      6,    9,    3, 29, 45,  2 }, {      5,    8,    3, 29, 45,  2 }, {      4,    7,    3, 29, 45,  2 }, {      3,    7,    3, 29, 45,  2 }, {      2,    6,    3, 29, 45,  2 },
    {      1,    5,    3, 29, 45,  2 }, {      0,    4,    3, 29, 45,  2 }, {     -1,    3,    3, 28, 45,  2 }, {     -3,    3,    4, 28, 45,  2 }, {     -4,    2,    4, 28, 45,  2 },
    {     -5,    1,    4, 28, 45,  2 }, {     -6,    0,    4, 28, 45,  2 }, {     -7,   -1,    4, 27, 45,  2 }, {     -7,   -2,    4, 27, 45,  2 }, {     -8,   -3,    4, 27, 45,  2 },
    {     -9,   -4,    4, 27, 45,  2 }, {     -9,   -5,    4, 27, 45,  2 }, {    -10,   -6,    5, 27, 45,  2 }, {    -10,   -7,    5, 27, 45,  2 }, {    -11,   -8,    5, 27, 45,  2 },
    {    -11,   -9,    5, 27, 45,  2 }, {    -12,  -10,    5, 26, 45,  2 }, {    -12,  -11,    5, 26, 45,  2 }, {    -13,  -12,    5, 26, 45,  2 }, {    -13,  -13,    5, 26, 45,  2 },
    {    -13,  -14,    6, 26, 45,  2 }, {    -14,  -15,    6, 26, 45,  2 }, {    -14,  -16,    6, 26, 45,  2 }, {    -14,  -17,    6, 26, 45,  2 }, {    -15,  -18,    6, 26, 45,  2 },
    {    -15,  -19,    6, 26, 45,  2 }, {    -15,  -20,    6, 25, 45,  2 }, {    -15,  -21,    6, 25, 45,  2 }, {    -15,  -22,    6, 25, 45,  2 }, {    -15,  -23,    7, 25, 45,  2 },
    {    -16,  -24,    7, 25, 45,  2 }, {    -16,  -25,    7, 25, 45,  2 }, {    -16,  -26,    7, 25, 45,  2 }, {    -16,  -27,    7, 25, 45,  2 }, {    -16,  -28,    7, 24, 45,  2 },
    {    -16,  -29,    7, 24, 45,  2 }, {    -16,  -30,    7, 24, 45,  2 }, {    -16,  -31,    8, 24, 45,  2 }, {    -16,  -33,    8, 24, 45,  2 }, {    -16,  -34,    8, 24, 45,  2 },
    {    -16,  -35,    8, 24, 45,  2 }, {    -16,  -36,    8, 24, 45,  2 }, {    -16,  -37,    8, 23, 45,  2 }, {    -16,  -38,    8, 23, 45,  2 }, {    -15,  -39,    8, 23, 45,  2 },
    {    -15,  -40,    8, 23, 45,  2 }, {    -15,  -41,    9, 23, 45,  2 }, {    -15,  -42,    9, 23, 45,  2 }, {    -15,  -43,    9, 23, 45,  2 }, {    -15,  -44,    9, 23, 45,  2 },
    {    -14,  -45,    9, 23, 45,  2 }, {    -14,  -46,    9, 22, 45,  2 }, {    -14,  -47,    9, 22, 45,  2 }, {    -13,  -48,    9, 22, 45,  2 }, {    -13,  -49,   10, 22, 45,  2 },
    {    -13,  -50,   10, 22, 45,  2 }, {    -12,  -51,   10, 22, 45,  2 }, {    -12,  -52,   10, 22, 45,  2 }, {    -11,  -53,   10, 22, 45,  2 }, {    -11,  -54,   10, 22, 45,  2 },
    {    -10,  -55,   10, 22, 45,  2 }, {    -10,  -56,   10, 21, 45,  2 }, {     -9,  -57,   10, 21, 45,  2 }, {     -9,  -58,   11, 21, 45,  2 }, {     -8,  -59,   11, 21, 45,  2 },
    {     -7,  -60,   11, 21, 45,  2 }, {     -7,  -61,   11, 21, 45,  2 }, {     -6,  -62,   11, 21, 45,  2 }, {     -5,  -63,   11, 21, 45,  2 }, {     -4,  -64,   11, 21, 45,  2 },
    {     -3,  -65,   11, 20, 45,  2 }, {     -3,  -67,   12, 20, 45,  2 }, {     -2,  -68,   12, 20, 45,  2 }, {     -1,  -69,   12, 20, 45,  2 }, {      0,  -70,   12, 20, 45,  2 },
    {      1,  -71,   12, 19, 45,  2 }, {      2,  -71,   12, 19, 45,  2 }, {      3,  -72,   12, 19, 45,  2 }, {      4,  -73,   12, 19, 45,  2 }, {      5,  -73,   13, 19, 45,  2 },
    {      6,  -74,   13, 19, 45,  2 }, {      7,  -74,   13, 19, 45,  2 }, {      8,  -75,   13, 19, 45,  2 }, {      9,  -75,   13, 19, 45,  2 }, {     10,  -76,   13, 18, 45,  2 },
    {     11,  -76,   13, 18, 45,  2 }, {     12,  -77,   13, 18, 45,  2 }, {     13,  -77,   13, 18, 45,  2 }, {     14,  -77,   14, 18, 45,  2 }, {     15,  -78,   14, 18, 45,  2 },
    {     16,  -78,   14, 18, 45,  2 }, {     17,  -78,   14, 18, 45,  2 }, {     18,  -79,   14, 18, 45,  2 }, {     19,  -79,   14, 18, 45,  2 }, {     20,  -79,   14, 17, 45,  2 },
    {     21,  -79,   14, 17, 45,  2 }, {     22,  -79,   15, 17, 45,  2 }, {     23,  -79,   15, 17, 45,  2 }, {     24,  -80,   15, 17, 45,  2 }, {     25,  -80,   15, 17, 45,  2 },
    {     26,  -80,   15, 17, 45,  2 }, {     27,  -80,   15, 17, 45,  2 }, {     28,  -80,   15, 16, 45,  2 }, {     29,  -80,   15, 16, 45,  2 }, {     30,  -80,   16, 16, 45,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9143, {
    {     16,    0,    0,  8, 45,  2 }, {     16,    1,    0,  8, 45,  2 }, {     16,    2,    0,  8, 45,  2 }, {     16,    3,    0,  8, 45,  2 }, {     16,    4,    0,  8, 45,  2 },
    {     16,    5,    0,  7, 45,  2 }, {     16,    6,    0,  7, 45,  2 }, {     15,    7,    0,  7, 45,  2 }, {     15,    8,    0,  7, 45,  2 }, {     15,    9,    1,  7, 45,  2 },
    {     15,   10,    1,  7, 45,  2 }, {     15,   11,    1,  7, 45,  2 }, {     15,   12,    1,  7, 45,  2 }, {     14,   13,    1,  7, 45,  2 }, {     14,   14,    1,  6, 45,  2 },
    {     14,   15,    1,  6, 45,  2 }, {     13,   16,    1,  6, 45,  2 }, {     13,   17,    1,  6, 45,  2 }, {     13,   18,    2,  6, 45,  2 }, {     12,   19,    2,  6, 45,  2 },
    {     12,   20,    2,  6, 45,  2 }, {     11,   21,    2,  6, 45,  2 }, {     11,   22,    2,  6, 45,  2 }, {     10,   23,    2,  6, 45,  2 }, {     10,   24,    2,  5, 45,  2 },
    {      9,   25,    2,  5, 45,  2 }, {      9,   26,    3,  5, 45,  2 }, {      8,   27,    3,  5, 45,  2 }, {      7,   28,    3,  5, 45,  2 }, {      7,   29,    3,  5, 45,  2 },
    {      6,   30,    3,  5, 45,  2 }, {      5,   31,    3,  5, 45,  2 }, {      4,   32,    3,  5, 45,  2 }, {      3,   33,    3,  4, 45,  2 }, {      3,   35,    3,  4, 45,  2 },
    {      2,   36,    4,  4, 45,  2 }, {      1,   37,    4,  4, 45,  2 }, {      0,   38,    4,  4, 45,  2 }, {     -1,   39,    4,  3, 45,  2 }, {     -2,   39,    4,  3, 45,  2 },
    {     -3,   40,    4,  3, 45,  2 }, {     -4,   41,    4,  3, 45,  2 }, {     -5,   41,    4,  3, 45,  2 }, {     -6,   42,    4,  3, 45,  2 }, {     -7,   42,    5,  3, 45,  2 },
    {     -8,   43,    5,  3, 45,  2 }, {     -9,   43,    5,  3, 45,  2 }, {    -10,   44,    5,  2, 45,  2 }, {    -11,   44,    5,  2, 45,  2 }, {    -12,   45,    5,  2, 45,  2 },
    {    -13,   45,    5,  2, 45,  2 }, {    -14,   45,    5,  2, 45,  2 }, {    -15,   46,    6,  2, 45,  2 }, {    -16,   46,    6,  2, 45,  2 }, {    -17,   46,    6,  2, 45,  2 },
    {    -18,   47,    6,  2, 45,  2 }, {    -19,   47,    6,  2, 45,  2 }, {    -20,   47,    6,  1, 45,  2 }, {    -21,   47,    6,  1, 45,  2 }, {    -22,   47,    6,  1, 45,  2 },
    {    -23,   47,    6,  1, 45,  2 }, {    -24,   48,    7,  1, 45,  2 }, {    -25,   48,    7,  1, 45,  2 }, {    -26,   48,    7,  1, 45,  2 }, {    -27,   48,    7,  1, 45,  2 },
    {    -28,   48,    7,  0, 45,  2 }, {    -29,   48,    7,  0, 45,  2 }, {    -30,   48,    7,  0, 45,  2 }, {    -31,   48,    7,  0, 45,  2 }, {    -33,   48,    8,  0, 45,  2 },
    {    -34,   48,    8,  0, 45,  2 }, {    -35,   48,    8,  0, 45,  2 }, {    -36,   48,    8,  0, 45,  2 }, {    -37,   48,    8, 31, 45,  2 }, {    -38,   48,    8, 31, 45,  2 },
    {    -39,   47,    8, 31, 45,  2 }, {    -40,   47,    8, 31, 45,  2 }, {    -41,   47,    9, 31, 45,  2 }, {    -42,   47,    9, 31, 45,  2 }, {    -43,   47,    9, 31, 45,  2 },
    {    -44,   47,    9, 31, 45,  2 }, {    -45,   46,    9, 31, 45,  2 }, {    -46,   46,    9, 30, 45,  2 }, {    -47,   46,    9, 30, 45,  2 }, {    -48,   45,    9, 30, 45,  2 },
    {    -49,   45,   10, 30, 45,  2 }, {    -50,   45,   10, 30, 45,  2 }, {    -51,   44,   10, 30, 45,  2 }, {    -52,   44,   10, 30, 45,  2 }, {    -53,   43,   10, 30, 45,  2 },
    {    -54,   43,   10, 30, 45,  2 }, {    -55,   42,   10, 30, 45,  2 }, {    -56,   42,   10, 29, 45,  2 }, {    -57,   41,   10, 29, 45,  2 }, {    -58,   41,   11, 29, 45,  2 },
    {    -59,   40,   11, 29, 45,  2 }, {    -60,   39,   11, 29, 45,  2 }, {    -61,   39,   11, 29, 45,  2 }, {    -62,   38,   11, 29, 45,  2 }, {    -63,   37,   11, 29, 45,  2 },
    {    -64,   36,   11, 29, 45,  2 }, {    -65,   35,   11, 28, 45,  2 }, {    -67,   35,   12, 28, 45,  2 }, {    -68,   34,   12, 28, 45,  2 }, {    -69,   33,   12, 28, 45,  2 },
    {    -70,   32,   12, 28, 45,  2 }, {    -71,   31,   12, 27, 45,  2 }, {    -71,   30,   12, 27, 45,  2 }, {    -72,   29,   12, 27, 45,  2 }, {    -73,   28,   12, 27, 45,  2 },
    {    -73,   27,   12, 27, 45,  2 }, {    -74,   26,   13, 27, 45,  2 }, {    -74,   25,   13, 27, 45,  2 }, {    -75,   24,   13, 27, 45,  2 }, {    -75,   23,   13, 27, 45,  2 },
    {    -76,   22,   13, 26, 45,  2 }, {    -76,   21,   13, 26, 45,  2 }, {    -77,   20,   13, 26, 45,  2 }, {    -77,   19,   13, 26, 45,  2 }, {    -77,   18,   14, 26, 45,  2 },
    {    -78,   17,   14, 26, 45,  2 }, {    -78,   16,   14, 26, 45,  2 }, {    -78,   15,   14, 26, 45,  2 }, {    -79,   14,   14, 26, 45,  2 }, {    -79,   13,   14, 26, 45,  2 },
    {    -79,   12,   14, 25, 45,  2 }, {    -79,   11,   14, 25, 45,  2 }, {    -79,   10,   14, 25, 45,  2 }, {    -79,    9,   15, 25, 45,  2 }, {    -80,    8,   15, 25, 45,  2 },
    {    -80,    7,   15, 25, 45,  2 }, {    -80,    6,   15, 25, 45,  2 }, {    -80,    5,   15, 25, 45,  2 }, {    -80,    4,   15, 24, 45,  2 }, {    -80,    3,   15, 24, 45,  2 },
    {    -80,    2,   15, 24, 45,  2 }, {    -80,    1,   16, 24, 45,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9616, {
    {      0,   16,    0, 16, 45,  2 }, {      1,   16,    0, 16, 45,  2 }, {      2,   16,    0, 16, 45,  2 }, {      3,   16,    0, 16, 45,  2 }, {      4,   16,    0, 16, 45,  2 },
    {      5,   16,    0, 15, 45,  2 }, {      6,   16,    0, 15, 45,  2 }, {      7,   17,    0, 15, 45,  2 }, {      8,   17,    0, 15, 45,  2 }, {      9,   17,    1, 15, 45,  2 },
    {     10,   17,    1, 15, 45,  2 }, {     11,   17,    1, 15, 45,  2 }, {     12,   17,    1, 15, 45,  2 }, {     13,   18,    1, 15, 45,  2 }, {     14,   18,    1, 14, 45,  2 },
    {     15,   18,    1, 14, 45,  2 }, {     16,   19,    1, 14, 45,  2 }, {     17,   19,    2, 14, 45,  2 }, {     18,   19,    2, 14, 45,  2 }, {     19,   20,    2, 14, 45,  2 },
    {     20,   20,    2, 14, 45,  2 }, {     21,   21,    2, 14, 45,  2 }, {     22,   21,    2, 14, 45,  2 }, {     23,   22,    2, 14, 45,  2 }, {     24,   22,    2, 13, 45,  2 },
    {     25,   23,    2, 13, 45,  2 }, {     26,   23,    3, 13, 45,  2 }, {     27,   24,    3, 13, 45,  2 }, {     28,   25,    3, 13, 45,  2 }, {     29,   25,    3, 13, 45,  2 },
    {     30,   26,    3, 13, 45,  2 }, {     31,   27,    3, 13, 45,  2 }, {     32,   28,    3, 13, 45,  2 }, {     33,   29,    3, 12, 45,  2 }, {     35,   29,    4, 12, 45,  2 },
    {     36,   30,    4, 12, 45,  2 }, {     37,   31,    4, 12, 45,  2 }, {     38,   32,    4, 12, 45,  2 }, {     39,   33,    4, 11, 45,  2 }, {     39,   34,    4, 11, 45,  2 },
    {     40,   35,    4, 11, 45,  2 }, {     41,   36,    4, 11, 45,  2 }, {     41,   37,    4, 11, 45,  2 }, {     42,   38,    5, 11, 45,  2 }, {     42,   39,    5, 11, 45,  2 },
    {     43,   40,    5, 11, 45,  2 }, {     43,   41,    5, 11, 45,  2 }, {     44,   42,    5, 10, 45,  2 }, {     44,   43,    5, 10, 45,  2 }, {     45,   44,    5, 10, 45,  2 },
    {     45,   45,    5, 10, 45,  2 }, {     45,   46,    6, 10, 45,  2 }, {     46,   47,    6, 10, 45,  2 }, {     46,   48,    6, 10, 45,  2 }, {     46,   49,    6, 10, 45,  2 },
    {     47,   50,    6, 10, 45,  2 }, {     47,   51,    6, 10, 45,  2 }, {     47,   52,    6,  9, 45,  2 }, {     47,   53,    6,  9, 45,  2 }, {     47,   54,    6,  9, 45,  2 },
    {     47,   55,    7,  9, 45,  2 }, {     48,   56,    7,  9, 45,  2 }, {     48,   57,    7,  9, 45,  2 }, {     48,   58,    7,  9, 45,  2 }, {     48,   59,    7,  9, 45,  2 },
    {     48,   60,    7,  8, 45,  2 }, {     48,   61,    7,  8, 45,  2 }, {     48,   62,    7,  8, 45,  2 }, {     48,   64,    8,  8, 45,  2 }, {     48,   65,    8,  8, 45,  2 },
    {     48,   66,    8,  8, 45,  2 }, {     48,   67,    8,  8, 45,  2 }, {     48,   68,    8,  8, 45,  2 }, {     48,   69,    8,  7, 45,  2 }, {     48,   70,    8,  7, 45,  2 },
    {     47,   71,    8,  7, 45,  2 }, {     47,   72,    8,  7, 45,  2 }, {     47,   73,    9,  7, 45,  2 }, {     47,   74,    9,  7, 45,  2 }, {     47,   75,    9,  7, 45,  2 },
    {     47,   76,    9,  7, 45,  2 }, {     46,   77,    9,  7, 45,  2 }, {     46,   78,    9,  6, 45,  2 }, {     46,   79,    9,  6, 45,  2 }, {     45,   80,    9,  6, 45,  2 },
    {     45,   81,    9,  6, 45,  2 }, {     45,   82,   10,  6, 45,  2 }, {     44,   83,   10,  6, 45,  2 }, {     44,   84,   10,  6, 45,  2 }, {     43,   85,   10,  6, 45,  2 },
    {     43,   86,   10,  6, 45,  2 }, {     42,   87,   10,  6, 45,  2 }, {     42,   88,   10,  5, 45,  2 }, {     41,   89,   10,  5, 45,  2 }, {     41,   90,   11,  5, 45,  2 },
    {     40,   91,   11,  5, 45,  2 }, {     39,   92,   11,  5, 45,  2 }, {     39,   93,   11,  5, 45,  2 }, {     38,   94,   11,  5, 45,  2 }, {     37,   95,   11,  5, 45,  2 },
    {     36,   96,   11,  5, 45,  2 }, {     35,   97,   11,  4, 45,  2 }, {     35,   99,   11,  4, 45,  2 }, {     34,  100,   12,  4, 45,  2 }, {     33,  101,   12,  4, 45,  2 },
    {     32,  102,   12,  4, 45,  2 }, {     31,  103,   12,  3, 45,  2 }, {     30,  103,   12,  3, 45,  2 }, {     29,  104,   12,  3, 45,  2 }, {     28,  105,   12,  3, 45,  2 },
    {     27,  105,   12,  3, 45,  2 }, {     26,  106,   12,  3, 45,  2 }, {     25,  106,   13,  3, 45,  2 }, {     24,  107,   13,  3, 45,  2 }, {     23,  107,   13,  3, 45,  2 },
    {     22,  108,   13,  2, 45,  2 }, {     21,  108,   13,  2, 45,  2 }, {     20,  109,   13,  2, 45,  2 }, {     19,  109,   13,  2, 45,  2 }, {     18,  109,   13,  2, 45,  2 },
    {     17,  110,   14,  2, 45,  2 }, {     16,  110,   14,  2, 45,  2 }, {     15,  110,   14,  2, 45,  2 }, {     14,  111,   14,  2, 45,  2 }, {     13,  111,   14,  2, 45,  2 },
    {     12,  111,   14,  1, 45,  2 }, {     11,  111,   14,  1, 45,  2 }, {     10,  111,   14,  1, 45,  2 }, {      9,  111,   14,  1, 45,  2 }, {      8,  112,   15,  1, 45,  2 },
    {      7,  112,   15,  1, 45,  2 }, {      6,  112,   15,  1, 45,  2 }, {      5,  112,   15,  1, 45,  2 }, {      4,  112,   15,  0, 45,  2 }, {      3,  112,   15,  0, 45,  2 },
    {      2,  112,   15,  0, 45,  2 }, {      1,  112,   15,  0, 45,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9AE9, {
    {     16,   31,    0, 24, 45,  2 }, {     16,   30,    0, 24, 45,  2 }, {     16,   29,    0, 24, 45,  2 }, {     16,   28,    0, 24, 45,  2 }, {     16,   27,    0, 23, 45,  2 },
    {     16,   26,    0, 23, 45,  2 }, {     17,   25,    0, 23, 45,  2 }, {     17,   24,    0, 23, 45,  2 }, {     17,   23,    1, 23, 45,  2 }, {     17,   22,    1, 23, 45,  2 },
    {     17,   21,    1, 23, 45,  2 }, {     17,   20,    1, 23, 45,  2 }, {     18,   19,    1, 23, 45,  2 }, {     18,   18,    1, 22, 45,  2 }, {     18,   17,    1, 22, 45,  2 },
    {     19,   16,    1, 22, 45,  2 }, {     19,   15,    2, 22, 45,  2 }, {     19,   14,    2, 22, 45,  2 }, {     20,   13,    2, 22, 45,  2 }, {     20,   12,    2, 22, 45,  2 },
    {     21,   11,    2, 22, 45,  2 }, {     21,   10,    2, 22, 45,  2 }, {     22,    9,    2, 22, 45,  2 }, {     22,    8,    2, 21, 45,  2 }, {     23,    7,    2, 21, 45,  2 },
    {     23,    6,    3, 21, 45,  2 }, {     24,    5,    3, 21, 45,  2 }, {     25,    4,    3, 21, 45,  2 }, {     25,    3,    3, 21, 45,  2 }, {     26,    2,    3, 21, 45,  2 },
    {     27,    1,    3, 21, 45,  2 }, {     28,    0,    3, 21, 45,  2 }, {     29,   -1,    3, 20, 45,  2 }, {     29,   -3,    4, 20, 45,  2 }, {     30,   -4,    4, 20, 45,  2 },
    {     31,   -5,    4, 20, 45,  2 }, {     32,   -6,    4, 20, 45,  2 }, {     33,   -7,    4, 19, 45,  2 }, {     34,   -7,    4, 19, 45,  2 }, {     35,   -8,    4, 19, 45,  2 },
    {     36,   -9,    4, 19, 45,  2 }, {     37,   -9,    5, 19, 45,  2 }, {     38,  -10,    5, 19, 45,  2 }, {     39,  -10,    5, 19, 45,  2 }, {     40,  -11,    5, 19, 45,  2 },
    {     41,  -11,    5, 19, 45,  2 }, {     42,  -12,    5, 18, 45,  2 }, {     43,  -12,    5, 18, 45,  2 }, {     44,  -13,    5, 18, 45,  2 }, {     45,  -13,    5, 18, 45,  2 },
    {     46,  -13,    6, 18, 45,  2 }, {     47,  -14,    6, 18, 45,  2 }, {     48,  -14,    6, 18, 45,  2 }, {     49,  -14,    6, 18, 45,  2 }, {     50,  -15,    6, 18, 45,  2 },
    {     51,  -15,    6, 18, 45,  2 }, {     52,  -15,    6, 17, 45,  2 }, {     53,  -15,    6, 17, 45,  2 }, {     54,  -15,    7, 17, 45,  2 }, {     55,  -15,    7, 17, 45,  2 },
    {     56,  -16,    7, 17, 45,  2 }, {     57,  -16,    7, 17, 45,  2 }, {     58,  -16,    7, 17, 45,  2 }, {     59,  -16,    7, 17, 45,  2 }, {     60,  -16,    7, 16, 45,  2 },
    {     61,  -16,    7, 16, 45,  2 }, {     62,  -16,    8, 16, 45,  2 }, {     64,  -16,    8, 16, 45,  2 }, {     65,  -16,    8, 16, 45,  2 }, {     66,  -16,    8, 16, 45,  2 },
    {     67,  -16,    8, 16, 45,  2 }, {     68,  -16,    8, 16, 45,  2 }, {     69,  -16,    8, 15, 45,  2 }, {     70,  -16,    8, 15, 45,  2 }, {     71,  -15,    8, 15, 45,  2 },
    {     72,  -15,    8, 15, 45,  2 }, {     73,  -15,    9, 15, 45,  2 }, {     74,  -15,    9, 15, 45,  2 }, {     75,  -15,    9, 15, 45,  2 }, {     76,  -15,    9, 15, 45,  2 },
    {     77,  -14,    9, 15, 45,  2 }, {     78,  -14,    9, 14, 45,  2 }, {     79,  -14,    9, 14, 45,  2 }, {     80,  -13,    9, 14, 45,  2 }, {     81,  -13,   10, 14, 45,  2 },
    {     82,  -13,   10, 14, 45,  2 }, {     83,  -12,   10, 14, 45,  2 }, {     84,  -12,   10, 14, 45,  2 }, {     85,  -11,   10, 14, 45,  2 }, {     86,  -11,   10, 14, 45,  2 },
    {     87,  -10,   10, 14, 45,  2 }, {     88,  -10,   10, 13, 45,  2 }, {     89,   -9,   10, 13, 45,  2 }, {     90,   -9,   11, 13, 45,  2 }, {     91,   -8,   11, 13, 45,  2 },
    {     92,   -7,   11, 13, 45,  2 }, {     93,   -7,   11, 13, 45,  2 }, {     94,   -6,   11, 13, 45,  2 }, {     95,   -5,   11, 13, 45,  2 }, {     96,   -4,   11, 13, 45,  2 },
    {     97,   -3,   11, 12, 45,  2 }, {     99,   -3,   12, 12, 45,  2 }, {    100,   -2,   12, 12, 45,  2 }, {    101,   -1,   12, 12, 45,  2 }, {    102,    0,   12, 12, 45,  2 },
    {    103,    1,   12, 11, 45,  2 }, {    103,    2,   12, 11, 45,  2 }, {    104,    3,   12, 11, 45,  2 }, {    105,    4,   12, 11, 45,  2 }, {    105,    5,   12, 11, 45,  2 },
    {    106,    6,   13, 11, 45,  2 }, {    106,    7,   13, 11, 45,  2 }, {    107,    8,   13, 11, 45,  2 }, {    107,    9,   13, 11, 45,  2 }, {    108,   10,   13, 10, 45,  2 },
    {    108,   11,   13, 10, 45,  2 }, {    109,   12,   13, 10, 45,  2 }, {    109,   13,   13, 10, 45,  2 }, {    109,   14,   14, 10, 45,  2 }, {    110,   15,   14, 10, 45,  2 },
    {    110,   16,   14, 10, 45,  2 }, {    110,   17,   14, 10, 45,  2 }, {    111,   18,   14, 10, 45,  2 }, {    111,   19,   14, 10, 45,  2 }, {    111,   20,   14,  9, 45,  2 },
    {    111,   21,   14,  9, 45,  2 }, {    111,   22,   14,  9, 45,  2 }, {    111,   23,   15,  9, 45,  2 }, {    112,   24,   15,  9, 45,  2 }, {    112,   25,   15,  9, 45,  2 },
    {    112,   26,   15,  9, 45,  2 }, {    112,   27,   15,  9, 45,  2 }, {    112,   28,   15,  8, 45,  2 }, {    112,   29,   15,  8, 45,  2 }, {    112,   30,   15,  8, 45,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F9FAA, {
    {     31,   16,    0,  0, 45,  4 }, {     30,   16,    0,  0, 45,  4 }, {     29,   16,    0,  0, 45,  4 }, {     28,   16,    0,  0, 45,  4 }, {     27,   16,    0,  1, 45,  4 },
    {     26,   16,    0,  1, 45,  4 }, {     25,   17,    0,  1, 45,  4 }, {     24,   17,    0,  1, 45,  4 }, {     23,   17,    1,  1, 45,  4 }, {     22,   17,    1,  1, 45,  4 },
    {     21,   17,    1,  1, 45,  4 }, {     20,   17,    1,  1, 45,  4 }, {     19,   18,    1,  1, 45,  4 }, {     18,   18,    1,  2, 45,  4 }, {     17,   18,    1,  2, 45,  4 },
    {     16,   19,    1,  2, 45,  4 }, {     15,   19,    2,  2, 45,  4 }, {     14,   19,    2,  2, 45,  4 }, {     13,   20,    2,  2, 45,  4 }, {     12,   20,    2,  2, 45,  4 },
    {     11,   21,    2,  2, 45,  4 }, {     10,   21,    2,  2, 45,  4 }, {      9,   22,    2,  2, 45,  4 }, {      8,   22,    2,  3, 45,  4 }, {      7,   23,    2,  3, 45,  4 },
    {      6,   23,    3,  3, 45,  4 }, {      5,   24,    3,  3, 45,  4 }, {      4,   25,    3,  3, 45,  4 }, {      3,   25,    3,  3, 45,  4 }, {      2,   26,    3,  3, 45,  4 },
    {      1,   27,    3,  3, 45,  4 }, {      0,   28,    3,  3, 45,  4 }, {     -1,   29,    3,  4, 45,  4 }, {     -3,   29,    4,  4, 45,  4 }, {     -4,   30,    4,  4, 45,  4 },
    {     -5,   31,    4,  4, 45,  4 }, {     -6,   32,    4,  4, 45,  4 }, {     -7,   33,    4,  5, 45,  4 }, {     -7,   34,    4,  5, 45,  4 }, {     -8,   35,    4,  5, 45,  4 },
    {     -9,   36,    4,  5, 45,  4 }, {     -9,   37,    5,  5, 45,  4 }, {    -10,   38,    5,  5, 45,  4 }, {    -10,   39,    5,  5, 45,  4 }, {    -11,   40,    5,  5, 45,  4 },
    {    -11,   41,    5,  5, 45,  4 }, {    -12,   42,    5,  6, 45,  4 }, {    -12,   43,    5,  6, 45,  4 }, {    -13,   44,    5,  6, 45,  4 }, {    -13,   45,    5,  6, 45,  4 },
    {    -13,   46,    6,  6, 45,  4 }, {    -14,   47,    6,  6, 45,  4 }, {    -14,   48,    6,  6, 45,  4 }, {    -14,   49,    6,  6, 45,  4 }, {    -15,   50,    6,  6, 45,  4 },
    {    -15,   51,    6,  6, 45,  4 }, {    -15,   52,    6,  7, 45,  4 }, {    -15,   53,    6,  7, 45,  4 }, {    -15,   54,    7,  7, 45,  4 }, {    -15,   55,    7,  7, 45,  4 },
    {    -16,   56,    7,  7, 45,  4 }, {    -16,   57,    7,  7, 45,  4 }, {    -16,   58,    7,  7, 45,  4 }, {    -16,   59,    7,  7, 45,  4 }, {    -16,   60,    7,  8, 45,  4 },
    {    -16,   61,    7,  8, 45,  4 }, {    -16,   62,    8,  8, 45,  4 }, {    -16,   64,    8,  8, 45,  4 }, {    -16,   65,    8,  8, 45,  4 }, {    -16,   66,    8,  8, 45,  4 },
    {    -16,   67,    8,  8, 45,  4 }, {    -16,   68,    8,  8, 45,  4 }, {    -16,   69,    8,  9, 45,  4 }, {    -16,   70,    8,  9, 45,  4 }, {    -15,   71,    8,  9, 45,  4 },
    {    -15,   72,    8,  9, 45,  4 }, {    -15,   73,    9,  9, 45,  4 }, {    -15,   74,    9,  9, 45,  4 }, {    -15,   75,    9,  9, 45,  4 }, {    -15,   76,    9,  9, 45,  4 },
    {    -14,   77,    9,  9, 45,  4 }, {    -14,   78,    9, 10, 45,  4 }, {    -14,   79,    9, 10, 45,  4 }, {    -13,   80,    9, 10, 45,  4 }, {    -13,   81,   10, 10, 45,  4 },
    {    -13,   82,   10, 10, 45,  4 }, {    -12,   83,   10, 10, 45,  4 }, {    -12,   84,   10, 10, 45,  4 }, {    -11,   85,   10, 10, 45,  4 }, {    -11,   86,   10, 10, 45,  4 },
    {    -10,   87,   10, 10, 45,  4 }, {    -10,   88,   10, 11, 45,  4 }, {     -9,   89,   10, 11, 45,  4 }, {     -9,   90,   11, 11, 45,  4 }, {     -8,   91,   11, 11, 45,  4 },
    {     -7,   92,   11, 11, 45,  4 }, {     -7,   93,   11, 11, 45,  4 }, {     -6,   94,   11, 11, 45,  4 }, {     -5,   95,   11, 11, 45,  4 }, {     -4,   96,   11, 11, 45,  4 },
    {     -3,   97,   11, 12, 45,  4 }, {     -3,   99,   12, 12, 45,  4 }, {     -2,  100,   12, 12, 45,  4 }, {     -1,  101,   12, 12, 45,  4 }, {      0,  102,   12, 12, 45,  4 },
    {      1,  103,   12, 13, 45,  4 }, {      2,  103,   12, 13, 45,  4 }, {      3,  104,   12, 13, 45,  4 }, {      4,  105,   12, 13, 45,  4 }, {      5,  105,   12, 13, 45,  4 },
    {      6,  106,   13, 13, 45,  4 }, {      7,  106,   13, 13, 45,  4 }, {      8,  107,   13, 13, 45,  4 }, {      9,  107,   13, 13, 45,  4 }, {     10,  108,   13, 14, 45,  4 },
    {     11,  108,   13, 14, 45,  4 }, {     12,  109,   13, 14, 45,  4 }, {     13,  109,   13, 14, 45,  4 }, {     14,  109,   14, 14, 45,  4 }, {     15,  110,   14, 14, 45,  4 },
    {     16,  110,   14, 14, 45,  4 }, {     17,  110,   14, 14, 45,  4 }, {     18,  111,   14, 14, 45,  4 }, {     19,  111,   14, 14, 45,  4 }, {     20,  111,   14, 15, 45,  4 },
    {     21,  111,   14, 15, 45,  4 }, {     22,  111,   14, 15, 45,  4 }, {     23,  111,   15, 15, 45,  4 }, {     24,  112,   15, 15, 45,  4 }, {     25,  112,   15, 15, 45,  4 },
    {     26,  112,   15, 15, 45,  4 }, {     27,  112,   15, 15, 45,  4 }, {     28,  112,   15, 16, 45,  4 }, {     29,  112,   15, 16, 45,  4 }, {     30,  112,   15, 16, 45,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FA46B, {
    {     16,    0,    0,  8, 45,  4 }, {     16,    1,    0,  8, 45,  4 }, {     16,    2,    0,  8, 45,  4 }, {     16,    3,    0,  8, 45,  4 }, {     16,    4,    0,  8, 45,  4 },
    {     16,    5,    0,  9, 45,  4 }, {     16,    6,    0,  9, 45,  4 }, {     17,    7,    0,  9, 45,  4 }, {     17,    8,    0,  9, 45,  4 }, {     17,    9,    1,  9, 45,  4 },
    {     17,   10,    1,  9, 45,  4 }, {     17,   11,    1,  9, 45,  4 }, {     17,   12,    1,  9, 45,  4 }, {     18,   13,    1,  9, 45,  4 }, {     18,   14,    1, 10, 45,  4 },
    {     18,   15,    1, 10, 45,  4 }, {     19,   16,    1, 10, 45,  4 }, {     19,   17,    2, 10, 45,  4 }, {     19,   18,    2, 10, 45,  4 }, {     20,   19,    2, 10, 45,  4 },
    {     20,   20,    2, 10, 45,  4 }, {     21,   21,    2, 10, 45,  4 }, {     21,   22,    2, 10, 45,  4 }, {     22,   23,    2, 10, 45,  4 }, {     22,   24,    2, 11, 45,  4 },
    {     23,   25,    2, 11, 45,  4 }, {     23,   26,    3, 11, 45,  4 }, {     24,   27,    3, 11, 45,  4 }, {     25,   28,    3, 11, 45,  4 }, {     25,   29,    3, 11, 45,  4 },
    {     26,   30,    3, 11, 45,  4 }, {     27,   31,    3, 11, 45,  4 }, {     28,   32,    3, 11, 45,  4 }, {     29,   33,    3, 12, 45,  4 }, {     29,   35,    4, 12, 45,  4 },
    {     30,   36,    4, 12, 45,  4 }, {     31,   37,    4, 12, 45,  4 }, {     32,   38,    4, 12, 45,  4 }, {     33,   39,    4, 13, 45,  4 }, {     34,   39,    4, 13, 45,  4 },
    {     35,   40,    4, 13, 45,  4 }, {     36,   41,    4, 13, 45,  4 }, {     37,   41,    4, 13, 45,  4 }, {     38,   42,    5, 13, 45,  4 }, {     39,   42,    5, 13, 45,  4 },
    {     40,   43,    5, 13, 45,  4 }, {     41,   43,    5, 13, 45,  4 }, {     42,   44,    5, 14, 45,  4 }, {     43,   44,    5, 14, 45,  4 }, {     44,   45,    5, 14, 45,  4 },
    {     45,   45,    5, 14, 45,  4 }, {     46,   45,    6, 14, 45,  4 }, {     47,   46,    6, 14, 45,  4 }, {     48,   46,    6, 14, 45,  4 }, {     49,   46,    6, 14, 45,  4 },
    {     50,   47,    6, 14, 45,  4 }, {     51,   47,    6, 14, 45,  4 }, {     52,   47,    6, 15, 45,  4 }, {     53,   47,    6, 15, 45,  4 }, {     54,   47,    6, 15, 45,  4 },
    {     55,   47,    7, 15, 45,  4 }, {     56,   48,    7, 15, 45,  4 }, {     57,   48,    7, 15, 45,  4 }, {     58,   48,    7, 15, 45,  4 }, {     59,   48,    7, 15, 45,  4 },
    {     60,   48,    7, 16, 45,  4 }, {     61,   48,    7, 16, 45,  4 }, {     62,   48,    7, 16, 45,  4 }, {     64,   48,    8, 16, 45,  4 }, {     65,   48,    8, 16, 45,  4 },
    {     66,   48,    8, 16, 45,  4 }, {     67,   48,    8, 16, 45,  4 }, {     68,   48,    8, 16, 45,  4 }, {     69,   48,    8, 17, 45,  4 }, {     70,   48,    8, 17, 45,  4 },
    {     71,   47,    8, 17, 45,  4 }, {     72,   47,    8, 17, 45,  4 }, {     73,   47,    9, 17, 45,  4 }, {     74,   47,    9, 17, 45,  4 }, {     75,   47,    9, 17, 45,  4 },
    {     76,   47,    9, 17, 45,  4 }, {     77,   46,    9, 17, 45,  4 }, {     78,   46,    9, 18, 45,  4 }, {     79,   46,    9, 18, 45,  4 }, {     80,   45,    9, 18, 45,  4 },
    {     81,   45,    9, 18, 45,  4 }, {     82,   45,   10, 18, 45,  4 }, {     83,   44,   10, 18, 45,  4 }, {     84,   44,   10, 18, 45,  4 }, {     85,   43,   10, 18, 45,  4 },
    {     86,   43,   10, 18, 45,  4 }, {     87,   42,   10, 18, 45,  4 }, {     88,   42,   10, 19, 45,  4 }, {     89,   41,   10, 19, 45,  4 }, {     90,   41,   11, 19, 45,  4 },
    {     91,   40,   11, 19, 45,  4 }, {     92,   39,   11, 19, 45,  4 }, {     93,   39,   11, 19, 45,  4 }, {     94,   38,   11, 19, 45,  4 }, {     95,   37,   11, 19, 45,  4 },
    {     96,   36,   11, 19, 45,  4 }, {     97,   35,   11, 20, 45,  4 }, {     99,   35,   11, 20, 45,  4 }, {    100,   34,   12, 20, 45,  4 }, {    101,   33,   12, 20, 45,  4 },
    {    102,   32,   12, 20, 45,  4 }, {    103,   31,   12, 21, 45,  4 }, {    103,   30,   12, 21, 45,  4 }, {    104,   29,   12, 21, 45,  4 }, {    105,   28,   12, 21, 45,  4 },
    {    105,   27,   12, 21, 45,  4 }, {    106,   26,   12, 21, 45,  4 }, {    106,   25,   13, 21, 45,  4 }, {    107,   24,   13, 21, 45,  4 }, {    107,   23,   13, 21, 45,  4 },
    {    108,   22,   13, 22, 45,  4 }, {    108,   21,   13, 22, 45,  4 }, {    109,   20,   13, 22, 45,  4 }, {    109,   19,   13, 22, 45,  4 }, {    109,   18,   13, 22, 45,  4 },
    {    110,   17,   14, 22, 45,  4 }, {    110,   16,   14, 22, 45,  4 }, {    110,   15,   14, 22, 45,  4 }, {    111,   14,   14, 22, 45,  4 }, {    111,   13,   14, 22, 45,  4 },
    {    111,   12,   14, 23, 45,  4 }, {    111,   11,   14, 23, 45,  4 }, {    111,   10,   14, 23, 45,  4 }, {    111,    9,   14, 23, 45,  4 }, {    112,    8,   15, 23, 45,  4 },
    {    112,    7,   15, 23, 45,  4 }, {    112,    6,   15, 23, 45,  4 }, {    112,    5,   15, 23, 45,  4 }, {    112,    4,   15, 24, 45,  4 }, {    112,    3,   15, 24, 45,  4 },
    {    112,    2,   15, 24, 45,  4 }, {    112,    1,   15, 24, 45,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FA93E, {
    {      0,   16,    0, 16, 45,  4 }, {      1,   16,    0, 16, 45,  4 }, {      2,   16,    0, 16, 45,  4 }, {      3,   16,    0, 16, 45,  4 }, {      4,   16,    0, 16, 45,  4 },
    {      5,   16,    0, 17, 45,  4 }, {      6,   16,    0, 17, 45,  4 }, {      7,   15,    0, 17, 45,  4 }, {      8,   15,    0, 17, 45,  4 }, {      9,   15,    1, 17, 45,  4 },
    {     10,   15,    1, 17, 45,  4 }, {     11,   15,    1, 17, 45,  4 }, {     12,   15,    1, 17, 45,  4 }, {     13,   14,    1, 17, 45,  4 }, {     14,   14,    1, 18, 45,  4 },
    {     15,   14,    1, 18, 45,  4 }, {     16,   13,    1, 18, 45,  4 }, {     17,   13,    1, 18, 45,  4 }, {     18,   13,    2, 18, 45,  4 }, {     19,   12,    2, 18, 45,  4 },
    {     20,   12,    2, 18, 45,  4 }, {     21,   11,    2, 18, 45,  4 }, {     22,   11,    2, 18, 45,  4 }, {     23,   10,    2, 18, 45,  4 }, {     24,   10,    2, 19, 45,  4 },
    {     25,    9,    2, 19, 45,  4 }, {     26,    9,    3, 19, 45,  4 }, {     27,    8,    3, 19, 45,  4 }, {     28,    7,    3, 19, 45,  4 }, {     29,    7,    3, 19, 45,  4 },
    {     30,    6,    3, 19, 45,  4 }, {     31,    5,    3, 19, 45,  4 }, {     32,    4,    3, 19, 45,  4 }, {     33,    3,    3, 20, 45,  4 }, {     35,    3,    3, 20, 45,  4 },
    {     36,    2,    4, 20, 45,  4 }, {     37,    1,    4, 20, 45,  4 }, {     38,    0,    4, 20, 45,  4 }, {     39,   -1,    4, 21, 45,  4 }, {     39,   -2,    4, 21, 45,  4 },
    {     40,   -3,    4, 21, 45,  4 }, {     41,   -4,    4, 21, 45,  4 }, {     41,   -5,    4, 21, 45,  4 }, {     42,   -6,    4, 21, 45,  4 }, {     42,   -7,    5, 21, 45,  4 },
    {     43,   -8,    5, 21, 45,  4 }, {     43,   -9,    5, 21, 45,  4 }, {     44,  -10,    5, 22, 45,  4 }, {     44,  -11,    5, 22, 45,  4 }, {     45,  -12,    5, 22, 45,  4 },
    {     45,  -13,    5, 22, 45,  4 }, {     45,  -14,    5, 22, 45,  4 }, {     46,  -15,    6, 22, 45,  4 }, {     46,  -16,    6, 22, 45,  4 }, {     46,  -17,    6, 22, 45,  4 },
    {     47,  -18,    6, 22, 45,  4 }, {     47,  -19,    6, 22, 45,  4 }, {     47,  -20,    6, 23, 45,  4 }, {     47,  -21,    6, 23, 45,  4 }, {     47,  -22,    6, 23, 45,  4 },
    {     47,  -23,    6, 23, 45,  4 }, {     48,  -24,    7, 23, 45,  4 }, {     48,  -25,    7, 23, 45,  4 }, {     48,  -26,    7, 23, 45,  4 }, {     48,  -27,    7, 23, 45,  4 },
    {     48,  -28,    7, 24, 45,  4 }, {     48,  -29,    7, 24, 45,  4 }, {     48,  -30,    7, 24, 45,  4 }, {     48,  -31,    7, 24, 45,  4 }, {     48,  -33,    8, 24, 45,  4 },
    {     48,  -34,    8, 24, 45,  4 }, {     48,  -35,    8, 24, 45,  4 }, {     48,  -36,    8, 24, 45,  4 }, {     48,  -37,    8, 25, 45,  4 }, {     48,  -38,    8, 25, 45,  4 },
    {     47,  -39,    8, 25, 45,  4 }, {     47,  -40,    8, 25, 45,  4 }, {     47,  -41,    9, 25, 45,  4 }, {     47,  -42,    9, 25, 45,  4 }, {     47,  -43,    9, 25, 45,  4 },
    {     47,  -44,    9, 25, 45,  4 }, {     46,  -45,    9, 25, 45,  4 }, {     46,  -46,    9, 26, 45,  4 }, {     46,  -47,    9, 26, 45,  4 }, {     45,  -48,    9, 26, 45,  4 },
    {     45,  -49,   10, 26, 45,  4 }, {     45,  -50,   10, 26, 45,  4 }, {     44,  -51,   10, 26, 45,  4 }, {     44,  -52,   10, 26, 45,  4 }, {     43,  -53,   10, 26, 45,  4 },
    {     43,  -54,   10, 26, 45,  4 }, {     42,  -55,   10, 26, 45,  4 }, {     42,  -56,   10, 27, 45,  4 }, {     41,  -57,   10, 27, 45,  4 }, {     41,  -58,   11, 27, 45,  4 },
    {     40,  -59,   11, 27, 45,  4 }, {     39,  -60,   11, 27, 45,  4 }, {     39,  -61,   11, 27, 45,  4 }, {     38,  -62,   11, 27, 45,  4 }, {     37,  -63,   11, 27, 45,  4 },
    {     36,  -64,   11, 27, 45,  4 }, {     35,  -65,   11, 28, 45,  4 }, {     35,  -67,   12, 28, 45,  4 }, {     34,  -68,   12, 28, 45,  4 }, {     33,  -69,   12, 28, 45,  4 },
    {     32,  -70,   12, 28, 45,  4 }, {     31,  -71,   12, 29, 45,  4 }, {     30,  -71,   12, 29, 45,  4 }, {     29,  -72,   12, 29, 45,  4 }, {     28,  -73,   12, 29, 45,  4 },
    {     27,  -73,   12, 29, 45,  4 }, {     26,  -74,   13, 29, 45,  4 }, {     25,  -74,   13, 29, 45,  4 }, {     24,  -75,   13, 29, 45,  4 }, {     23,  -75,   13, 29, 45,  4 },
    {     22,  -76,   13, 30, 45,  4 }, {     21,  -76,   13, 30, 45,  4 }, {     20,  -77,   13, 30, 45,  4 }, {     19,  -77,   13, 30, 45,  4 }, {     18,  -77,   14, 30, 45,  4 },
    {     17,  -78,   14, 30, 45,  4 }, {     16,  -78,   14, 30, 45,  4 }, {     15,  -78,   14, 30, 45,  4 }, {     14,  -79,   14, 30, 45,  4 }, {     13,  -79,   14, 30, 45,  4 },
    {     12,  -79,   14, 31, 45,  4 }, {     11,  -79,   14, 31, 45,  4 }, {     10,  -79,   14, 31, 45,  4 }, {      9,  -79,   15, 31, 45,  4 }, {      8,  -80,   15, 31, 45,  4 },
    {      7,  -80,   15, 31, 45,  4 }, {      6,  -80,   15, 31, 45,  4 }, {      5,  -80,   15, 31, 45,  4 }, {      4,  -80,   15,  0, 45,  4 }, {      3,  -80,   15,  0, 45,  4 },
    {      2,  -80,   15,  0, 45,  4 }, {      1,  -80,   16,  0, 45,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FAE11, {
    {     16,   31,    0, 24, 45,  4 }, {     16,   30,    0, 24, 45,  4 }, {     16,   29,    0, 24, 45,  4 }, {     16,   28,    0, 24, 45,  4 }, {     16,   27,    0, 25, 45,  4 },
    {     16,   26,    0, 25, 45,  4 }, {     15,   25,    0, 25, 45,  4 }, {     15,   24,    0, 25, 45,  4 }, {     15,   23,    1, 25, 45,  4 }, {     15,   22,    1, 25, 45,  4 },
    {     15,   21,    1, 25, 45,  4 }, {     15,   20,    1, 25, 45,  4 }, {     14,   19,    1, 25, 45,  4 }, {     14,   18,    1, 26, 45,  4 }, {     14,   17,    1, 26, 45,  4 },
    {     13,   16,    1, 26, 45,  4 }, {     13,   15,    2, 26, 45,  4 }, {     13,   14,    2, 26, 45,  4 }, {     12,   13,    2, 26, 45,  4 }, {     12,   12,    2, 26, 45,  4 },
    {     11,   11,    2, 26, 45,  4 }, {     11,   10,    2, 26, 45,  4 }, {     10,    9,    2, 26, 45,  4 }, {     10,    8,    2, 27, 45,  4 }, {      9,    7,    2, 27, 45,  4 },
    {      9,    6,    3, 27, 45,  4 }, {      8,    5,    3, 27, 45,  4 }, {      7,    4,    3, 27, 45,  4 }, {      7,    3,    3, 27, 45,  4 }, {      6,    2,    3, 27, 45,  4 },
    {      5,    1,    3, 27, 45,  4 }, {      4,    0,    3, 27, 45,  4 }, {      3,   -1,    3, 28, 45,  4 }, {      3,   -3,    4, 28, 45,  4 }, {      2,   -4,    4, 28, 45,  4 },
    {      1,   -5,    4, 28, 45,  4 }, {      0,   -6,    4, 28, 45,  4 }, {     -1,   -7,    4, 29, 45,  4 }, {     -2,   -7,    4, 29, 45,  4 }, {     -3,   -8,    4, 29, 45,  4 },
    {     -4,   -9,    4, 29, 45,  4 }, {     -5,   -9,    4, 29, 45,  4 }, {     -6,  -10,    5, 29, 45,  4 }, {     -7,  -10,    5, 29, 45,  4 }, {     -8,  -11,    5, 29, 45,  4 },
    {     -9,  -11,    5, 29, 45,  4 }, {    -10,  -12,    5, 30, 45,  4 }, {    -11,  -12,    5, 30, 45,  4 }, {    -12,  -13,    5, 30, 45,  4 }, {    -13,  -13,    5, 30, 45,  4 },
    {    -14,  -13,    6, 30, 45,  4 }, {    -15,  -14,    6, 30, 45,  4 }, {    -16,  -14,    6, 30, 45,  4 }, {    -17,  -14,    6, 30, 45,  4 }, {    -18,  -15,    6, 30, 45,  4 },
    {    -19,  -15,    6, 30, 45,  4 }, {    -20,  -15,    6, 31, 45,  4 }, {    -21,  -15,    6, 31, 45,  4 }, {    -22,  -15,    6, 31, 45,  4 }, {    -23,  -15,    7, 31, 45,  4 },
    {    -24,  -16,    7, 31, 45,  4 }, {    -25,  -16,    7, 31, 45,  4 }, {    -26,  -16,    7, 31, 45,  4 }, {    -27,  -16,    7, 31, 45,  4 }, {    -28,  -16,    7,  0, 45,  4 },
    {    -29,  -16,    7,  0, 45,  4 }, {    -30,  -16,    7,  0, 45,  4 }, {    -31,  -16,    8,  0, 45,  4 }, {    -33,  -16,    8,  0, 45,  4 }, {    -34,  -16,    8,  0, 45,  4 },
    {    -35,  -16,    8,  0, 45,  4 }, {    -36,  -16,    8,  0, 45,  4 }, {    -37,  -16,    8,  1, 45,  4 }, {    -38,  -16,    8,  1, 45,  4 }, {    -39,  -15,    8,  1, 45,  4 },
    {    -40,  -15,    8,  1, 45,  4 }, {    -41,  -15,    9,  1, 45,  4 }, {    -42,  -15,    9,  1, 45,  4 }, {    -43,  -15,    9,  1, 45,  4 }, {    -44,  -15,    9,  1, 45,  4 },
    {    -45,  -14,    9,  1, 45,  4 }, {    -46,  -14,    9,  2, 45,  4 }, {    -47,  -14,    9,  2, 45,  4 }, {    -48,  -13,    9,  2, 45,  4 }, {    -49,  -13,   10,  2, 45,  4 },
    {    -50,  -13,   10,  2, 45,  4 }, {    -51,  -12,   10,  2, 45,  4 }, {    -52,  -12,   10,  2, 45,  4 }, {    -53,  -11,   10,  2, 45,  4 }, {    -54,  -11,   10,  2, 45,  4 },
    {    -55,  -10,   10,  2, 45,  4 }, {    -56,  -10,   10,  3, 45,  4 }, {    -57,   -9,   10,  3, 45,  4 }, {    -58,   -9,   11,  3, 45,  4 }, {    -59,   -8,   11,  3, 45,  4 },
    {    -60,   -7,   11,  3, 45,  4 }, {    -61,   -7,   11,  3, 45,  4 }, {    -62,   -6,   11,  3, 45,  4 }, {    -63,   -5,   11,  3, 45,  4 }, {    -64,   -4,   11,  3, 45,  4 },
    {    -65,   -3,   11,  4, 45,  4 }, {    -67,   -3,   12,  4, 45,  4 }, {    -68,   -2,   12,  4, 45,  4 }, {    -69,   -1,   12,  4, 45,  4 }, {    -70,    0,   12,  4, 45,  4 },
    {    -71,    1,   12,  5, 45,  4 }, {    -71,    2,   12,  5, 45,  4 }, {    -72,    3,   12,  5, 45,  4 }, {    -73,    4,   12,  5, 45,  4 }, {    -73,    5,   13,  5, 45,  4 },
    {    -74,    6,   13,  5, 45,  4 }, {    -74,    7,   13,  5, 45,  4 }, {    -75,    8,   13,  5, 45,  4 }, {    -75,    9,   13,  5, 45,  4 }, {    -76,   10,   13,  6, 45,  4 },
    {    -76,   11,   13,  6, 45,  4 }, {    -77,   12,   13,  6, 45,  4 }, {    -77,   13,   13,  6, 45,  4 }, {    -77,   14,   14,  6, 45,  4 }, {    -78,   15,   14,  6, 45,  4 },
    {    -78,   16,   14,  6, 45,  4 }, {    -78,   17,   14,  6, 45,  4 }, {    -79,   18,   14,  6, 45,  4 }, {    -79,   19,   14,  6, 45,  4 }, {    -79,   20,   14,  7, 45,  4 },
    {    -79,   21,   14,  7, 45,  4 }, {    -79,   22,   15,  7, 45,  4 }, {    -79,   23,   15,  7, 45,  4 }, {    -80,   24,   15,  7, 45,  4 }, {    -80,   25,   15,  7, 45,  4 },
    {    -80,   26,   15,  7, 45,  4 }, {    -80,   27,   15,  7, 45,  4 }, {    -80,   28,   15,  8, 45,  4 }, {    -80,   29,   15,  8, 45,  4 }, {    -80,   30,   16,  8, 45,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FB2D2, {
    {     31,   16,    8,  0, 47,  2 }, {     30,   16,    8,  0, 47,  2 }, {     29,   16,    8,  0, 47,  2 }, {     28,   16,    8,  0, 47,  2 }, {     27,   16,    8, 31, 47,  2 },
    {     26,   16,    8, 31, 47,  2 }, {     25,   15,    8, 31, 47,  2 }, {     24,   15,    8, 31, 47,  2 }, {     23,   15,    7, 31, 47,  2 }, {     22,   15,    7, 31, 47,  2 },
    {     21,   15,    7, 31, 47,  2 }, {     20,   15,    7, 31, 47,  2 }, {     19,   14,    7, 31, 47,  2 }, {     18,   14,    7, 30, 47,  2 }, {     17,   14,    7, 30, 47,  2 },
    {     16,   13,    7, 30, 47,  2 }, {     15,   13,    6, 30, 47,  2 }, {     14,   13,    6, 30, 47,  2 }, {     13,   12,    6, 30, 47,  2 }, {     12,   12,    6, 30, 47,  2 },
    {     11,   11,    6, 30, 47,  2 }, {     10,   11,    6, 30, 47,  2 }, {      9,   10,    6, 30, 47,  2 }, {      8,   10,    6, 29, 47,  2 }, {      7,    9,    6, 29, 47,  2 },
    {      6,    9,    5, 29, 47,  2 }, {      5,    8,    5, 29, 47,  2 }, {      4,    7,    5, 29, 47,  2 }, {      3,    7,    5, 29, 47,  2 }, {      2,    6,    5, 29, 47,  2 },
    {      1,    5,    5, 29, 47,  2 }, {      0,    4,    5, 29, 47,  2 }, {     -1,    3,    5, 28, 47,  2 }, {     -3,    3,    4, 28, 47,  2 }, {     -4,    2,    4, 28, 47,  2 },
    {     -5,    1,    4, 28, 47,  2 }, {     -6,    0,    4, 28, 47,  2 }, {     -7,   -1,    4, 27, 47,  2 }, {     -7,   -2,    4, 27, 47,  2 }, {     -8,   -3,    4, 27, 47,  2 },
    {     -9,   -4,    4, 27, 47,  2 }, {     -9,   -5,    4, 27, 47,  2 }, {    -10,   -6,    3, 27, 47,  2 }, {    -10,   -7,    3, 27, 47,  2 }, {    -11,   -8,    3, 27, 47,  2 },
    {    -11,   -9,    3, 27, 47,  2 }, {    -12,  -10,    3, 26, 47,  2 }, {    -12,  -11,    3, 26, 47,  2 }, {    -13,  -12,    3, 26, 47,  2 }, {    -13,  -13,    3, 26, 47,  2 },
    {    -13,  -14,    2, 26, 47,  2 }, {    -14,  -15,    2, 26, 47,  2 }, {    -14,  -16,    2, 26, 47,  2 }, {    -14,  -17,    2, 26, 47,  2 }, {    -15,  -18,    2, 26, 47,  2 },
    {    -15,  -19,    2, 26, 47,  2 }, {    -15,  -20,    2, 25, 47,  2 }, {    -15,  -21,    2, 25, 47,  2 }, {    -15,  -22,    2, 25, 47,  2 }, {    -15,  -23,    1, 25, 47,  2 },
    {    -16,  -24,    1, 25, 47,  2 }, {    -16,  -25,    1, 25, 47,  2 }, {    -16,  -26,    1, 25, 47,  2 }, {    -16,  -27,    1, 25, 47,  2 }, {    -16,  -28,    1, 24, 47,  2 },
    {    -16,  -29,    1, 24, 47,  2 }, {    -16,  -30,    1, 24, 47,  2 }, {    -16,  -31,    0, 24, 47,  2 }, {    -16,  -33,    0, 24, 47,  2 }, {    -16,  -34,    0, 24, 47,  2 },
    {    -16,  -35,    0, 24, 47,  2 }, {    -16,  -36,    0, 24, 47,  2 }, {    -16,  -37,    0, 23, 47,  2 }, {    -16,  -38,    0, 23, 47,  2 }, {    -15,  -39,    0, 23, 47,  2 },
    {    -15,  -40,    0, 23, 47,  2 }, {    -15,  -41,   -1, 23, 47,  2 }, {    -15,  -42,   -1, 23, 47,  2 }, {    -15,  -43,   -1, 23, 47,  2 }, {    -15,  -44,   -1, 23, 47,  2 },
    {    -14,  -45,   -1, 23, 47,  2 }, {    -14,  -46,   -1, 22, 47,  2 }, {    -14,  -47,   -1, 22, 47,  2 }, {    -13,  -48,   -1, 22, 47,  2 }, {    -13,  -49,   -2, 22, 47,  2 },
    {    -13,  -50,   -2, 22, 47,  2 }, {    -12,  -51,   -2, 22, 47,  2 }, {    -12,  -52,   -2, 22, 47,  2 }, {    -11,  -53,   -2, 22, 47,  2 }, {    -11,  -54,   -2, 22, 47,  2 },
    {    -10,  -55,   -2, 22, 47,  2 }, {    -10,  -56,   -2, 21, 47,  2 }, {     -9,  -57,   -2, 21, 47,  2 }, {     -9,  -58,   -3, 21, 47,  2 }, {     -8,  -59,   -3, 21, 47,  2 },
    {     -7,  -60,   -3, 21, 47,  2 }, {     -7,  -61,   -3, 21, 47,  2 }, {     -6,  -62,   -3, 21, 47,  2 }, {     -5,  -63,   -3, 21, 47,  2 }, {     -4,  -64,   -3, 21, 47,  2 },
    {     -3,  -65,   -3, 20, 47,  2 }, {     -3,  -67,   -4, 20, 47,  2 }, {     -2,  -68,   -4, 20, 47,  2 }, {     -1,  -69,   -4, 20, 47,  2 }, {      0,  -70,   -4, 20, 47,  2 },
    {      1,  -71,   -4, 19, 47,  2 }, {      2,  -71,   -4, 19, 47,  2 }, {      3,  -72,   -4, 19, 47,  2 }, {      4,  -73,   -4, 19, 47,  2 }, {      5,  -73,   -5, 19, 47,  2 },
    {      6,  -74,   -5, 19, 47,  2 }, {      7,  -74,   -5, 19, 47,  2 }, {      8,  -75,   -5, 19, 47,  2 }, {      9,  -75,   -5, 19, 47,  2 }, {     10,  -76,   -5, 18, 47,  2 },
    {     11,  -76,   -5, 18, 47,  2 }, {     12,  -77,   -5, 18, 47,  2 }, {     13,  -77,   -5, 18, 47,  2 }, {     14,  -77,   -6, 18, 47,  2 }, {     15,  -78,   -6, 18, 47,  2 },
    {     16,  -78,   -6, 18, 47,  2 }, {     17,  -78,   -6, 18, 47,  2 }, {     18,  -79,   -6, 18, 47,  2 }, {     19,  -79,   -6, 18, 47,  2 }, {     20,  -79,   -6, 17, 47,  2 },
    {     21,  -79,   -6, 17, 47,  2 }, {     22,  -79,   -7, 17, 47,  2 }, {     23,  -79,   -7, 17, 47,  2 }, {     24,  -80,   -7, 17, 47,  2 }, {     25,  -80,   -7, 17, 47,  2 },
    {     26,  -80,   -7, 17, 47,  2 }, {     27,  -80,   -7, 17, 47,  2 }, {     28,  -80,   -7, 16, 47,  2 }, {     29,  -80,   -7, 16, 47,  2 }, {     30,  -80,   -8, 16, 47,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FB793, {
    {     16,    0,    8,  8, 47,  2 }, {     16,    1,    8,  8, 47,  2 }, {     16,    2,    8,  8, 47,  2 }, {     16,    3,    8,  8, 47,  2 }, {     16,    4,    8,  8, 47,  2 },
    {     16,    5,    8,  7, 47,  2 }, {     16,    6,    8,  7, 47,  2 }, {     15,    7,    8,  7, 47,  2 }, {     15,    8,    8,  7, 47,  2 }, {     15,    9,    7,  7, 47,  2 },
    {     15,   10,    7,  7, 47,  2 }, {     15,   11,    7,  7, 47,  2 }, {     15,   12,    7,  7, 47,  2 }, {     14,   13,    7,  7, 47,  2 }, {     14,   14,    7,  6, 47,  2 },
    {     14,   15,    7,  6, 47,  2 }, {     13,   16,    7,  6, 47,  2 }, {     13,   17,    7,  6, 47,  2 }, {     13,   18,    6,  6, 47,  2 }, {     12,   19,    6,  6, 47,  2 },
    {     12,   20,    6,  6, 47,  2 }, {     11,   21,    6,  6, 47,  2 }, {     11,   22,    6,  6, 47,  2 }, {     10,   23,    6,  6, 47,  2 }, {     10,   24,    6,  5, 47,  2 },
    {      9,   25,    6,  5, 47,  2 }, {      9,   26,    5,  5, 47,  2 }, {      8,   27,    5,  5, 47,  2 }, {      7,   28,    5,  5, 47,  2 }, {      7,   29,    5,  5, 47,  2 },
    {      6,   30,    5,  5, 47,  2 }, {      5,   31,    5,  5, 47,  2 }, {      4,   32,    5,  5, 47,  2 }, {      3,   33,    5,  4, 47,  2 }, {      3,   35,    5,  4, 47,  2 },
    {      2,   36,    4,  4, 47,  2 }, {      1,   37,    4,  4, 47,  2 }, {      0,   38,    4,  4, 47,  2 }, {     -1,   39,    4,  3, 47,  2 }, {     -2,   39,    4,  3, 47,  2 },
    {     -3,   40,    4,  3, 47,  2 }, {     -4,   41,    4,  3, 47,  2 }, {     -5,   41,    4,  3, 47,  2 }, {     -6,   42,    4,  3, 47,  2 }, {     -7,   42,    3,  3, 47,  2 },
    {     -8,   43,    3,  3, 47,  2 }, {     -9,   43,    3,  3, 47,  2 }, {    -10,   44,    3,  2, 47,  2 }, {    -11,   44,    3,  2, 47,  2 }, {    -12,   45,    3,  2, 47,  2 },
    {    -13,   45,    3,  2, 47,  2 }, {    -14,   45,    3,  2, 47,  2 }, {    -15,   46,    2,  2, 47,  2 }, {    -16,   46,    2,  2, 47,  2 }, {    -17,   46,    2,  2, 47,  2 },
    {    -18,   47,    2,  2, 47,  2 }, {    -19,   47,    2,  2, 47,  2 }, {    -20,   47,    2,  1, 47,  2 }, {    -21,   47,    2,  1, 47,  2 }, {    -22,   47,    2,  1, 47,  2 },
    {    -23,   47,    2,  1, 47,  2 }, {    -24,   48,    1,  1, 47,  2 }, {    -25,   48,    1,  1, 47,  2 }, {    -26,   48,    1,  1, 47,  2 }, {    -27,   48,    1,  1, 47,  2 },
    {    -28,   48,    1,  0, 47,  2 }, {    -29,   48,    1,  0, 47,  2 }, {    -30,   48,    1,  0, 47,  2 }, {    -31,   48,    1,  0, 47,  2 }, {    -33,   48,    0,  0, 47,  2 },
    {    -34,   48,    0,  0, 47,  2 }, {    -35,   48,    0,  0, 47,  2 }, {    -36,   48,    0,  0, 47,  2 }, {    -37,   48,    0, 31, 47,  2 }, {    -38,   48,    0, 31, 47,  2 },
    {    -39,   47,    0, 31, 47,  2 }, {    -40,   47,    0, 31, 47,  2 }, {    -41,   47,   -1, 31, 47,  2 }, {    -42,   47,   -1, 31, 47,  2 }, {    -43,   47,   -1, 31, 47,  2 },
    {    -44,   47,   -1, 31, 47,  2 }, {    -45,   46,   -1, 31, 47,  2 }, {    -46,   46,   -1, 30, 47,  2 }, {    -47,   46,   -1, 30, 47,  2 }, {    -48,   45,   -1, 30, 47,  2 },
    {    -49,   45,   -2, 30, 47,  2 }, {    -50,   45,   -2, 30, 47,  2 }, {    -51,   44,   -2, 30, 47,  2 }, {    -52,   44,   -2, 30, 47,  2 }, {    -53,   43,   -2, 30, 47,  2 },
    {    -54,   43,   -2, 30, 47,  2 }, {    -55,   42,   -2, 30, 47,  2 }, {    -56,   42,   -2, 29, 47,  2 }, {    -57,   41,   -2, 29, 47,  2 }, {    -58,   41,   -3, 29, 47,  2 },
    {    -59,   40,   -3, 29, 47,  2 }, {    -60,   39,   -3, 29, 47,  2 }, {    -61,   39,   -3, 29, 47,  2 }, {    -62,   38,   -3, 29, 47,  2 }, {    -63,   37,   -3, 29, 47,  2 },
    {    -64,   36,   -3, 29, 47,  2 }, {    -65,   35,   -3, 28, 47,  2 }, {    -67,   35,   -4, 28, 47,  2 }, {    -68,   34,   -4, 28, 47,  2 }, {    -69,   33,   -4, 28, 47,  2 },
    {    -70,   32,   -4, 28, 47,  2 }, {    -71,   31,   -4, 27, 47,  2 }, {    -71,   30,   -4, 27, 47,  2 }, {    -72,   29,   -4, 27, 47,  2 }, {    -73,   28,   -4, 27, 47,  2 },
    {    -73,   27,   -4, 27, 47,  2 }, {    -74,   26,   -5, 27, 47,  2 }, {    -74,   25,   -5, 27, 47,  2 }, {    -75,   24,   -5, 27, 47,  2 }, {    -75,   23,   -5, 27, 47,  2 },
    {    -76,   22,   -5, 26, 47,  2 }, {    -76,   21,   -5, 26, 47,  2 }, {    -77,   20,   -5, 26, 47,  2 }, {    -77,   19,   -5, 26, 47,  2 }, {    -77,   18,   -6, 26, 47,  2 },
    {    -78,   17,   -6, 26, 47,  2 }, {    -78,   16,   -6, 26, 47,  2 }, {    -78,   15,   -6, 26, 47,  2 }, {    -79,   14,   -6, 26, 47,  2 }, {    -79,   13,   -6, 26, 47,  2 },
    {    -79,   12,   -6, 25, 47,  2 }, {    -79,   11,   -6, 25, 47,  2 }, {    -79,   10,   -6, 25, 47,  2 }, {    -79,    9,   -7, 25, 47,  2 }, {    -80,    8,   -7, 25, 47,  2 },
    {    -80,    7,   -7, 25, 47,  2 }, {    -80,    6,   -7, 25, 47,  2 }, {    -80,    5,   -7, 25, 47,  2 }, {    -80,    4,   -7, 24, 47,  2 }, {    -80,    3,   -7, 24, 47,  2 },
    {    -80,    2,   -7, 24, 47,  2 }, {    -80,    1,   -8, 24, 47,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FBC66, {
    {      0,   16,    8, 16, 47,  2 }, {      1,   16,    8, 16, 47,  2 }, {      2,   16,    8, 16, 47,  2 }, {      3,   16,    8, 16, 47,  2 }, {      4,   16,    8, 16, 47,  2 },
    {      5,   16,    8, 15, 47,  2 }, {      6,   16,    8, 15, 47,  2 }, {      7,   17,    8, 15, 47,  2 }, {      8,   17,    8, 15, 47,  2 }, {      9,   17,    7, 15, 47,  2 },
    {     10,   17,    7, 15, 47,  2 }, {     11,   17,    7, 15, 47,  2 }, {     12,   17,    7, 15, 47,  2 }, {     13,   18,    7, 15, 47,  2 }, {     14,   18,    7, 14, 47,  2 },
    {     15,   18,    7, 14, 47,  2 }, {     16,   19,    7, 14, 47,  2 }, {     17,   19,    6, 14, 47,  2 }, {     18,   19,    6, 14, 47,  2 }, {     19,   20,    6, 14, 47,  2 },
    {     20,   20,    6, 14, 47,  2 }, {     21,   21,    6, 14, 47,  2 }, {     22,   21,    6, 14, 47,  2 }, {     23,   22,    6, 14, 47,  2 }, {     24,   22,    6, 13, 47,  2 },
    {     25,   23,    6, 13, 47,  2 }, {     26,   23,    5, 13, 47,  2 }, {     27,   24,    5, 13, 47,  2 }, {     28,   25,    5, 13, 47,  2 }, {     29,   25,    5, 13, 47,  2 },
    {     30,   26,    5, 13, 47,  2 }, {     31,   27,    5, 13, 47,  2 }, {     32,   28,    5, 13, 47,  2 }, {     33,   29,    5, 12, 47,  2 }, {     35,   29,    4, 12, 47,  2 },
    {     36,   30,    4, 12, 47,  2 }, {     37,   31,    4, 12, 47,  2 }, {     38,   32,    4, 12, 47,  2 }, {     39,   33,    4, 11, 47,  2 }, {     39,   34,    4, 11, 47,  2 },
    {     40,   35,    4, 11, 47,  2 }, {     41,   36,    4, 11, 47,  2 }, {     41,   37,    4, 11, 47,  2 }, {     42,   38,    3, 11, 47,  2 }, {     42,   39,    3, 11, 47,  2 },
    {     43,   40,    3, 11, 47,  2 }, {     43,   41,    3, 11, 47,  2 }, {     44,   42,    3, 10, 47,  2 }, {     44,   43,    3, 10, 47,  2 }, {     45,   44,    3, 10, 47,  2 },
    {     45,   45,    3, 10, 47,  2 }, {     45,   46,    2, 10, 47,  2 }, {     46,   47,    2, 10, 47,  2 }, {     46,   48,    2, 10, 47,  2 }, {     46,   49,    2, 10, 47,  2 },
    {     47,   50,    2, 10, 47,  2 }, {     47,   51,    2, 10, 47,  2 }, {     47,   52,    2,  9, 47,  2 }, {     47,   53,    2,  9, 47,  2 }, {     47,   54,    2,  9, 47,  2 },
    {     47,   55,    1,  9, 47,  2 }, {     48,   56,    1,  9, 47,  2 }, {     48,   57,    1,  9, 47,  2 }, {     48,   58,    1,  9, 47,  2 }, {     48,   59,    1,  9, 47,  2 },
    {     48,   60,    1,  8, 47,  2 }, {     48,   61,    1,  8, 47,  2 }, {     48,   62,    1,  8, 47,  2 }, {     48,   64,    0,  8, 47,  2 }, {     48,   65,    0,  8, 47,  2 },
    {     48,   66,    0,  8, 47,  2 }, {     48,   67,    0,  8, 47,  2 }, {     48,   68,    0,  8, 47,  2 }, {     48,   69,    0,  7, 47,  2 }, {     48,   70,    0,  7, 47,  2 },
    {     47,   71,    0,  7, 47,  2 }, {     47,   72,    0,  7, 47,  2 }, {     47,   73,   -1,  7, 47,  2 }, {     47,   74,   -1,  7, 47,  2 }, {     47,   75,   -1,  7, 47,  2 },
    {     47,   76,   -1,  7, 47,  2 }, {     46,   77,   -1,  7, 47,  2 }, {     46,   78,   -1,  6, 47,  2 }, {     46,   79,   -1,  6, 47,  2 }, {     45,   80,   -1,  6, 47,  2 },
    {     45,   81,   -1,  6, 47,  2 }, {     45,   82,   -2,  6, 47,  2 }, {     44,   83,   -2,  6, 47,  2 }, {     44,   84,   -2,  6, 47,  2 }, {     43,   85,   -2,  6, 47,  2 },
    {     43,   86,   -2,  6, 47,  2 }, {     42,   87,   -2,  6, 47,  2 }, {     42,   88,   -2,  5, 47,  2 }, {     41,   89,   -2,  5, 47,  2 }, {     41,   90,   -3,  5, 47,  2 },
    {     40,   91,   -3,  5, 47,  2 }, {     39,   92,   -3,  5, 47,  2 }, {     39,   93,   -3,  5, 47,  2 }, {     38,   94,   -3,  5, 47,  2 }, {     37,   95,   -3,  5, 47,  2 },
    {     36,   96,   -3,  5, 47,  2 }, {     35,   97,   -3,  4, 47,  2 }, {     35,   99,   -3,  4, 47,  2 }, {     34,  100,   -4,  4, 47,  2 }, {     33,  101,   -4,  4, 47,  2 },
    {     32,  102,   -4,  4, 47,  2 }, {     31,  103,   -4,  3, 47,  2 }, {     30,  103,   -4,  3, 47,  2 }, {     29,  104,   -4,  3, 47,  2 }, {     28,  105,   -4,  3, 47,  2 },
    {     27,  105,   -4,  3, 47,  2 }, {     26,  106,   -4,  3, 47,  2 }, {     25,  106,   -5,  3, 47,  2 }, {     24,  107,   -5,  3, 47,  2 }, {     23,  107,   -5,  3, 47,  2 },
    {     22,  108,   -5,  2, 47,  2 }, {     21,  108,   -5,  2, 47,  2 }, {     20,  109,   -5,  2, 47,  2 }, {     19,  109,   -5,  2, 47,  2 }, {     18,  109,   -5,  2, 47,  2 },
    {     17,  110,   -6,  2, 47,  2 }, {     16,  110,   -6,  2, 47,  2 }, {     15,  110,   -6,  2, 47,  2 }, {     14,  111,   -6,  2, 47,  2 }, {     13,  111,   -6,  2, 47,  2 },
    {     12,  111,   -6,  1, 47,  2 }, {     11,  111,   -6,  1, 47,  2 }, {     10,  111,   -6,  1, 47,  2 }, {      9,  111,   -6,  1, 47,  2 }, {      8,  112,   -7,  1, 47,  2 },
    {      7,  112,   -7,  1, 47,  2 }, {      6,  112,   -7,  1, 47,  2 }, {      5,  112,   -7,  1, 47,  2 }, {      4,  112,   -7,  0, 47,  2 }, {      3,  112,   -7,  0, 47,  2 },
    {      2,  112,   -7,  0, 47,  2 }, {      1,  112,   -7,  0, 47,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FC139, {
    {     16,   31,    8, 24, 47,  2 }, {     16,   30,    8, 24, 47,  2 }, {     16,   29,    8, 24, 47,  2 }, {     16,   28,    8, 24, 47,  2 }, {     16,   27,    8, 23, 47,  2 },
    {     16,   26,    8, 23, 47,  2 }, {     17,   25,    8, 23, 47,  2 }, {     17,   24,    8, 23, 47,  2 }, {     17,   23,    7, 23, 47,  2 }, {     17,   22,    7, 23, 47,  2 },
    {     17,   21,    7, 23, 47,  2 }, {     17,   20,    7, 23, 47,  2 }, {     18,   19,    7, 23, 47,  2 }, {     18,   18,    7, 22, 47,  2 }, {     18,   17,    7, 22, 47,  2 },
    {     19,   16,    7, 22, 47,  2 }, {     19,   15,    6, 22, 47,  2 }, {     19,   14,    6, 22, 47,  2 }, {     20,   13,    6, 22, 47,  2 }, {     20,   12,    6, 22, 47,  2 },
    {     21,   11,    6, 22, 47,  2 }, {     21,   10,    6, 22, 47,  2 }, {     22,    9,    6, 22, 47,  2 }, {     22,    8,    6, 21, 47,  2 }, {     23,    7,    6, 21, 47,  2 },
    {     23,    6,    5, 21, 47,  2 }, {     24,    5,    5, 21, 47,  2 }, {     25,    4,    5, 21, 47,  2 }, {     25,    3,    5, 21, 47,  2 }, {     26,    2,    5, 21, 47,  2 },
    {     27,    1,    5, 21, 47,  2 }, {     28,    0,    5, 21, 47,  2 }, {     29,   -1,    5, 20, 47,  2 }, {     29,   -3,    4, 20, 47,  2 }, {     30,   -4,    4, 20, 47,  2 },
    {     31,   -5,    4, 20, 47,  2 }, {     32,   -6,    4, 20, 47,  2 }, {     33,   -7,    4, 19, 47,  2 }, {     34,   -7,    4, 19, 47,  2 }, {     35,   -8,    4, 19, 47,  2 },
    {     36,   -9,    4, 19, 47,  2 }, {     37,   -9,    3, 19, 47,  2 }, {     38,  -10,    3, 19, 47,  2 }, {     39,  -10,    3, 19, 47,  2 }, {     40,  -11,    3, 19, 47,  2 },
    {     41,  -11,    3, 19, 47,  2 }, {     42,  -12,    3, 18, 47,  2 }, {     43,  -12,    3, 18, 47,  2 }, {     44,  -13,    3, 18, 47,  2 }, {     45,  -13,    3, 18, 47,  2 },
    {     46,  -13,    2, 18, 47,  2 }, {     47,  -14,    2, 18, 47,  2 }, {     48,  -14,    2, 18, 47,  2 }, {     49,  -14,    2, 18, 47,  2 }, {     50,  -15,    2, 18, 47,  2 },
    {     51,  -15,    2, 18, 47,  2 }, {     52,  -15,    2, 17, 47,  2 }, {     53,  -15,    2, 17, 47,  2 }, {     54,  -15,    1, 17, 47,  2 }, {     55,  -15,    1, 17, 47,  2 },
    {     56,  -16,    1, 17, 47,  2 }, {     57,  -16,    1, 17, 47,  2 }, {     58,  -16,    1, 17, 47,  2 }, {     59,  -16,    1, 17, 47,  2 }, {     60,  -16,    1, 16, 47,  2 },
    {     61,  -16,    1, 16, 47,  2 }, {     62,  -16,    0, 16, 47,  2 }, {     64,  -16,    0, 16, 47,  2 }, {     65,  -16,    0, 16, 47,  2 }, {     66,  -16,    0, 16, 47,  2 },
    {     67,  -16,    0, 16, 47,  2 }, {     68,  -16,    0, 16, 47,  2 }, {     69,  -16,    0, 15, 47,  2 }, {     70,  -16,    0, 15, 47,  2 }, {     71,  -15,    0, 15, 47,  2 },
    {     72,  -15,    0, 15, 47,  2 }, {     73,  -15,   -1, 15, 47,  2 }, {     74,  -15,   -1, 15, 47,  2 }, {     75,  -15,   -1, 15, 47,  2 }, {     76,  -15,   -1, 15, 47,  2 },
    {     77,  -14,   -1, 15, 47,  2 }, {     78,  -14,   -1, 14, 47,  2 }, {     79,  -14,   -1, 14, 47,  2 }, {     80,  -13,   -1, 14, 47,  2 }, {     81,  -13,   -2, 14, 47,  2 },
    {     82,  -13,   -2, 14, 47,  2 }, {     83,  -12,   -2, 14, 47,  2 }, {     84,  -12,   -2, 14, 47,  2 }, {     85,  -11,   -2, 14, 47,  2 }, {     86,  -11,   -2, 14, 47,  2 },
    {     87,  -10,   -2, 14, 47,  2 }, {     88,  -10,   -2, 13, 47,  2 }, {     89,   -9,   -2, 13, 47,  2 }, {     90,   -9,   -3, 13, 47,  2 }, {     91,   -8,   -3, 13, 47,  2 },
    {     92,   -7,   -3, 13, 47,  2 }, {     93,   -7,   -3, 13, 47,  2 }, {     94,   -6,   -3, 13, 47,  2 }, {     95,   -5,   -3, 13, 47,  2 }, {     96,   -4,   -3, 13, 47,  2 },
    {     97,   -3,   -3, 12, 47,  2 }, {     99,   -3,   -4, 12, 47,  2 }, {    100,   -2,   -4, 12, 47,  2 }, {    101,   -1,   -4, 12, 47,  2 }, {    102,    0,   -4, 12, 47,  2 },
    {    103,    1,   -4, 11, 47,  2 }, {    103,    2,   -4, 11, 47,  2 }, {    104,    3,   -4, 11, 47,  2 }, {    105,    4,   -4, 11, 47,  2 }, {    105,    5,   -4, 11, 47,  2 },
    {    106,    6,   -5, 11, 47,  2 }, {    106,    7,   -5, 11, 47,  2 }, {    107,    8,   -5, 11, 47,  2 }, {    107,    9,   -5, 11, 47,  2 }, {    108,   10,   -5, 10, 47,  2 },
    {    108,   11,   -5, 10, 47,  2 }, {    109,   12,   -5, 10, 47,  2 }, {    109,   13,   -5, 10, 47,  2 }, {    109,   14,   -6, 10, 47,  2 }, {    110,   15,   -6, 10, 47,  2 },
    {    110,   16,   -6, 10, 47,  2 }, {    110,   17,   -6, 10, 47,  2 }, {    111,   18,   -6, 10, 47,  2 }, {    111,   19,   -6, 10, 47,  2 }, {    111,   20,   -6,  9, 47,  2 },
    {    111,   21,   -6,  9, 47,  2 }, {    111,   22,   -6,  9, 47,  2 }, {    111,   23,   -7,  9, 47,  2 }, {    112,   24,   -7,  9, 47,  2 }, {    112,   25,   -7,  9, 47,  2 },
    {    112,   26,   -7,  9, 47,  2 }, {    112,   27,   -7,  9, 47,  2 }, {    112,   28,   -7,  8, 47,  2 }, {    112,   29,   -7,  8, 47,  2 }, {    112,   30,   -7,  8, 47,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FC5FA, {
    {     31,   16,    8,  0, 47,  4 }, {     30,   16,    8,  0, 47,  4 }, {     29,   16,    8,  0, 47,  4 }, {     28,   16,    8,  0, 47,  4 }, {     27,   16,    8,  1, 47,  4 },
    {     26,   16,    8,  1, 47,  4 }, {     25,   17,    8,  1, 47,  4 }, {     24,   17,    8,  1, 47,  4 }, {     23,   17,    7,  1, 47,  4 }, {     22,   17,    7,  1, 47,  4 },
    {     21,   17,    7,  1, 47,  4 }, {     20,   17,    7,  1, 47,  4 }, {     19,   18,    7,  1, 47,  4 }, {     18,   18,    7,  2, 47,  4 }, {     17,   18,    7,  2, 47,  4 },
    {     16,   19,    7,  2, 47,  4 }, {     15,   19,    6,  2, 47,  4 }, {     14,   19,    6,  2, 47,  4 }, {     13,   20,    6,  2, 47,  4 }, {     12,   20,    6,  2, 47,  4 },
    {     11,   21,    6,  2, 47,  4 }, {     10,   21,    6,  2, 47,  4 }, {      9,   22,    6,  2, 47,  4 }, {      8,   22,    6,  3, 47,  4 }, {      7,   23,    6,  3, 47,  4 },
    {      6,   23,    5,  3, 47,  4 }, {      5,   24,    5,  3, 47,  4 }, {      4,   25,    5,  3, 47,  4 }, {      3,   25,    5,  3, 47,  4 }, {      2,   26,    5,  3, 47,  4 },
    {      1,   27,    5,  3, 47,  4 }, {      0,   28,    5,  3, 47,  4 }, {     -1,   29,    5,  4, 47,  4 }, {     -3,   29,    4,  4, 47,  4 }, {     -4,   30,    4,  4, 47,  4 },
    {     -5,   31,    4,  4, 47,  4 }, {     -6,   32,    4,  4, 47,  4 }, {     -7,   33,    4,  5, 47,  4 }, {     -7,   34,    4,  5, 47,  4 }, {     -8,   35,    4,  5, 47,  4 },
    {     -9,   36,    4,  5, 47,  4 }, {     -9,   37,    3,  5, 47,  4 }, {    -10,   38,    3,  5, 47,  4 }, {    -10,   39,    3,  5, 47,  4 }, {    -11,   40,    3,  5, 47,  4 },
    {    -11,   41,    3,  5, 47,  4 }, {    -12,   42,    3,  6, 47,  4 }, {    -12,   43,    3,  6, 47,  4 }, {    -13,   44,    3,  6, 47,  4 }, {    -13,   45,    3,  6, 47,  4 },
    {    -13,   46,    2,  6, 47,  4 }, {    -14,   47,    2,  6, 47,  4 }, {    -14,   48,    2,  6, 47,  4 }, {    -14,   49,    2,  6, 47,  4 }, {    -15,   50,    2,  6, 47,  4 },
    {    -15,   51,    2,  6, 47,  4 }, {    -15,   52,    2,  7, 47,  4 }, {    -15,   53,    2,  7, 47,  4 }, {    -15,   54,    1,  7, 47,  4 }, {    -15,   55,    1,  7, 47,  4 },
    {    -16,   56,    1,  7, 47,  4 }, {    -16,   57,    1,  7, 47,  4 }, {    -16,   58,    1,  7, 47,  4 }, {    -16,   59,    1,  7, 47,  4 }, {    -16,   60,    1,  8, 47,  4 },
    {    -16,   61,    1,  8, 47,  4 }, {    -16,   62,    0,  8, 47,  4 }, {    -16,   64,    0,  8, 47,  4 }, {    -16,   65,    0,  8, 47,  4 }, {    -16,   66,    0,  8, 47,  4 },
    {    -16,   67,    0,  8, 47,  4 }, {    -16,   68,    0,  8, 47,  4 }, {    -16,   69,    0,  9, 47,  4 }, {    -16,   70,    0,  9, 47,  4 }, {    -15,   71,    0,  9, 47,  4 },
    {    -15,   72,    0,  9, 47,  4 }, {    -15,   73,   -1,  9, 47,  4 }, {    -15,   74,   -1,  9, 47,  4 }, {    -15,   75,   -1,  9, 47,  4 }, {    -15,   76,   -1,  9, 47,  4 },
    {    -14,   77,   -1,  9, 47,  4 }, {    -14,   78,   -1, 10, 47,  4 }, {    -14,   79,   -1, 10, 47,  4 }, {    -13,   80,   -1, 10, 47,  4 }, {    -13,   81,   -2, 10, 47,  4 },
    {    -13,   82,   -2, 10, 47,  4 }, {    -12,   83,   -2, 10, 47,  4 }, {    -12,   84,   -2, 10, 47,  4 }, {    -11,   85,   -2, 10, 47,  4 }, {    -11,   86,   -2, 10, 47,  4 },
    {    -10,   87,   -2, 10, 47,  4 }, {    -10,   88,   -2, 11, 47,  4 }, {     -9,   89,   -2, 11, 47,  4 }, {     -9,   90,   -3, 11, 47,  4 }, {     -8,   91,   -3, 11, 47,  4 },
    {     -7,   92,   -3, 11, 47,  4 }, {     -7,   93,   -3, 11, 47,  4 }, {     -6,   94,   -3, 11, 47,  4 }, {     -5,   95,   -3, 11, 47,  4 }, {     -4,   96,   -3, 11, 47,  4 },
    {     -3,   97,   -3, 12, 47,  4 }, {     -3,   99,   -4, 12, 47,  4 }, {     -2,  100,   -4, 12, 47,  4 }, {     -1,  101,   -4, 12, 47,  4 }, {      0,  102,   -4, 12, 47,  4 },
    {      1,  103,   -4, 13, 47,  4 }, {      2,  103,   -4, 13, 47,  4 }, {      3,  104,   -4, 13, 47,  4 }, {      4,  105,   -4, 13, 47,  4 }, {      5,  105,   -4, 13, 47,  4 },
    {      6,  106,   -5, 13, 47,  4 }, {      7,  106,   -5, 13, 47,  4 }, {      8,  107,   -5, 13, 47,  4 }, {      9,  107,   -5, 13, 47,  4 }, {     10,  108,   -5, 14, 47,  4 },
    {     11,  108,   -5, 14, 47,  4 }, {     12,  109,   -5, 14, 47,  4 }, {     13,  109,   -5, 14, 47,  4 }, {     14,  109,   -6, 14, 47,  4 }, {     15,  110,   -6, 14, 47,  4 },
    {     16,  110,   -6, 14, 47,  4 }, {     17,  110,   -6, 14, 47,  4 }, {     18,  111,   -6, 14, 47,  4 }, {     19,  111,   -6, 14, 47,  4 }, {     20,  111,   -6, 15, 47,  4 },
    {     21,  111,   -6, 15, 47,  4 }, {     22,  111,   -6, 15, 47,  4 }, {     23,  111,   -7, 15, 47,  4 }, {     24,  112,   -7, 15, 47,  4 }, {     25,  112,   -7, 15, 47,  4 },
    {     26,  112,   -7, 15, 47,  4 }, {     27,  112,   -7, 15, 47,  4 }, {     28,  112,   -7, 16, 47,  4 }, {     29,  112,   -7, 16, 47,  4 }, {     30,  112,   -7, 16, 47,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FCABB, {
    {     16,    0,    8,  8, 47,  4 }, {     16,    1,    8,  8, 47,  4 }, {     16,    2,    8,  8, 47,  4 }, {     16,    3,    8,  8, 47,  4 }, {     16,    4,    8,  8, 47,  4 },
    {     16,    5,    8,  9, 47,  4 }, {     16,    6,    8,  9, 47,  4 }, {     17,    7,    8,  9, 47,  4 }, {     17,    8,    8,  9, 47,  4 }, {     17,    9,    7,  9, 47,  4 },
    {     17,   10,    7,  9, 47,  4 }, {     17,   11,    7,  9, 47,  4 }, {     17,   12,    7,  9, 47,  4 }, {     18,   13,    7,  9, 47,  4 }, {     18,   14,    7, 10, 47,  4 },
    {     18,   15,    7, 10, 47,  4 }, {     19,   16,    7, 10, 47,  4 }, {     19,   17,    6, 10, 47,  4 }, {     19,   18,    6, 10, 47,  4 }, {     20,   19,    6, 10, 47,  4 },
    {     20,   20,    6, 10, 47,  4 }, {     21,   21,    6, 10, 47,  4 }, {     21,   22,    6, 10, 47,  4 }, {     22,   23,    6, 10, 47,  4 }, {     22,   24,    6, 11, 47,  4 },
    {     23,   25,    6, 11, 47,  4 }, {     23,   26,    5, 11, 47,  4 }, {     24,   27,    5, 11, 47,  4 }, {     25,   28,    5, 11, 47,  4 }, {     25,   29,    5, 11, 47,  4 },
    {     26,   30,    5, 11, 47,  4 }, {     27,   31,    5, 11, 47,  4 }, {     28,   32,    5, 11, 47,  4 }, {     29,   33,    5, 12, 47,  4 }, {     29,   35,    4, 12, 47,  4 },
    {     30,   36,    4, 12, 47,  4 }, {     31,   37,    4, 12, 47,  4 }, {     32,   38,    4, 12, 47,  4 }, {     33,   39,    4, 13, 47,  4 }, {     34,   39,    4, 13, 47,  4 },
    {     35,   40,    4, 13, 47,  4 }, {     36,   41,    4, 13, 47,  4 }, {     37,   41,    4, 13, 47,  4 }, {     38,   42,    3, 13, 47,  4 }, {     39,   42,    3, 13, 47,  4 },
    {     40,   43,    3, 13, 47,  4 }, {     41,   43,    3, 13, 47,  4 }, {     42,   44,    3, 14, 47,  4 }, {     43,   44,    3, 14, 47,  4 }, {     44,   45,    3, 14, 47,  4 },
    {     45,   45,    3, 14, 47,  4 }, {     46,   45,    2, 14, 47,  4 }, {     47,   46,    2, 14, 47,  4 }, {     48,   46,    2, 14, 47,  4 }, {     49,   46,    2, 14, 47,  4 },
    {     50,   47,    2, 14, 47,  4 }, {     51,   47,    2, 14, 47,  4 }, {     52,   47,    2, 15, 47,  4 }, {     53,   47,    2, 15, 47,  4 }, {     54,   47,    2, 15, 47,  4 },
    {     55,   47,    1, 15, 47,  4 }, {     56,   48,    1, 15, 47,  4 }, {     57,   48,    1, 15, 47,  4 }, {     58,   48,    1, 15, 47,  4 }, {     59,   48,    1, 15, 47,  4 },
    {     60,   48,    1, 16, 47,  4 }, {     61,   48,    1, 16, 47,  4 }, {     62,   48,    1, 16, 47,  4 }, {     64,   48,    0, 16, 47,  4 }, {     65,   48,    0, 16, 47,  4 },
    {     66,   48,    0, 16, 47,  4 }, {     67,   48,    0, 16, 47,  4 }, {     68,   48,    0, 16, 47,  4 }, {     69,   48,    0, 17, 47,  4 }, {     70,   48,    0, 17, 47,  4 },
    {     71,   47,    0, 17, 47,  4 }, {     72,   47,    0, 17, 47,  4 }, {     73,   47,   -1, 17, 47,  4 }, {     74,   47,   -1, 17, 47,  4 }, {     75,   47,   -1, 17, 47,  4 },
    {     76,   47,   -1, 17, 47,  4 }, {     77,   46,   -1, 17, 47,  4 }, {     78,   46,   -1, 18, 47,  4 }, {     79,   46,   -1, 18, 47,  4 }, {     80,   45,   -1, 18, 47,  4 },
    {     81,   45,   -1, 18, 47,  4 }, {     82,   45,   -2, 18, 47,  4 }, {     83,   44,   -2, 18, 47,  4 }, {     84,   44,   -2, 18, 47,  4 }, {     85,   43,   -2, 18, 47,  4 },
    {     86,   43,   -2, 18, 47,  4 }, {     87,   42,   -2, 18, 47,  4 }, {     88,   42,   -2, 19, 47,  4 }, {     89,   41,   -2, 19, 47,  4 }, {     90,   41,   -3, 19, 47,  4 },
    {     91,   40,   -3, 19, 47,  4 }, {     92,   39,   -3, 19, 47,  4 }, {     93,   39,   -3, 19, 47,  4 }, {     94,   38,   -3, 19, 47,  4 }, {     95,   37,   -3, 19, 47,  4 },
    {     96,   36,   -3, 19, 47,  4 }, {     97,   35,   -3, 20, 47,  4 }, {     99,   35,   -3, 20, 47,  4 }, {    100,   34,   -4, 20, 47,  4 }, {    101,   33,   -4, 20, 47,  4 },
    {    102,   32,   -4, 20, 47,  4 }, {    103,   31,   -4, 21, 47,  4 }, {    103,   30,   -4, 21, 47,  4 }, {    104,   29,   -4, 21, 47,  4 }, {    105,   28,   -4, 21, 47,  4 },
    {    105,   27,   -4, 21, 47,  4 }, {    106,   26,   -4, 21, 47,  4 }, {    106,   25,   -5, 21, 47,  4 }, {    107,   24,   -5, 21, 47,  4 }, {    107,   23,   -5, 21, 47,  4 },
    {    108,   22,   -5, 22, 47,  4 }, {    108,   21,   -5, 22, 47,  4 }, {    109,   20,   -5, 22, 47,  4 }, {    109,   19,   -5, 22, 47,  4 }, {    109,   18,   -5, 22, 47,  4 },
    {    110,   17,   -6, 22, 47,  4 }, {    110,   16,   -6, 22, 47,  4 }, {    110,   15,   -6, 22, 47,  4 }, {    111,   14,   -6, 22, 47,  4 }, {    111,   13,   -6, 22, 47,  4 },
    {    111,   12,   -6, 23, 47,  4 }, {    111,   11,   -6, 23, 47,  4 }, {    111,   10,   -6, 23, 47,  4 }, {    111,    9,   -6, 23, 47,  4 }, {    112,    8,   -7, 23, 47,  4 },
    {    112,    7,   -7, 23, 47,  4 }, {    112,    6,   -7, 23, 47,  4 }, {    112,    5,   -7, 23, 47,  4 }, {    112,    4,   -7, 24, 47,  4 }, {    112,    3,   -7, 24, 47,  4 },
    {    112,    2,   -7, 24, 47,  4 }, {    112,    1,   -7, 24, 47,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FCF8E, {
    {      0,   16,    8, 16, 47,  4 }, {      1,   16,    8, 16, 47,  4 }, {      2,   16,    8, 16, 47,  4 }, {      3,   16,    8, 16, 47,  4 }, {      4,   16,    8, 16, 47,  4 },
    {      5,   16,    8, 17, 47,  4 }, {      6,   16,    8, 17, 47,  4 }, {      7,   15,    8, 17, 47,  4 }, {      8,   15,    8, 17, 47,  4 }, {      9,   15,    7, 17, 47,  4 },
    {     10,   15,    7, 17, 47,  4 }, {     11,   15,    7, 17, 47,  4 }, {     12,   15,    7, 17, 47,  4 }, {     13,   14,    7, 17, 47,  4 }, {     14,   14,    7, 18, 47,  4 },
    {     15,   14,    7, 18, 47,  4 }, {     16,   13,    7, 18, 47,  4 }, {     17,   13,    7, 18, 47,  4 }, {     18,   13,    6, 18, 47,  4 }, {     19,   12,    6, 18, 47,  4 },
    {     20,   12,    6, 18, 47,  4 }, {     21,   11,    6, 18, 47,  4 }, {     22,   11,    6, 18, 47,  4 }, {     23,   10,    6, 18, 47,  4 }, {     24,   10,    6, 19, 47,  4 },
    {     25,    9,    6, 19, 47,  4 }, {     26,    9,    5, 19, 47,  4 }, {     27,    8,    5, 19, 47,  4 }, {     28,    7,    5, 19, 47,  4 }, {     29,    7,    5, 19, 47,  4 },
    {     30,    6,    5, 19, 47,  4 }, {     31,    5,    5, 19, 47,  4 }, {     32,    4,    5, 19, 47,  4 }, {     33,    3,    5, 20, 47,  4 }, {     35,    3,    5, 20, 47,  4 },
    {     36,    2,    4, 20, 47,  4 }, {     37,    1,    4, 20, 47,  4 }, {     38,    0,    4, 20, 47,  4 }, {     39,   -1,    4, 21, 47,  4 }, {     39,   -2,    4, 21, 47,  4 },
    {     40,   -3,    4, 21, 47,  4 }, {     41,   -4,    4, 21, 47,  4 }, {     41,   -5,    4, 21, 47,  4 }, {     42,   -6,    4, 21, 47,  4 }, {     42,   -7,    3, 21, 47,  4 },
    {     43,   -8,    3, 21, 47,  4 }, {     43,   -9,    3, 21, 47,  4 }, {     44,  -10,    3, 22, 47,  4 }, {     44,  -11,    3, 22, 47,  4 }, {     45,  -12,    3, 22, 47,  4 },
    {     45,  -13,    3, 22, 47,  4 }, {     45,  -14,    3, 22, 47,  4 }, {     46,  -15,    2, 22, 47,  4 }, {     46,  -16,    2, 22, 47,  4 }, {     46,  -17,    2, 22, 47,  4 },
    {     47,  -18,    2, 22, 47,  4 }, {     47,  -19,    2, 22, 47,  4 }, {     47,  -20,    2, 23, 47,  4 }, {     47,  -21,    2, 23, 47,  4 }, {     47,  -22,    2, 23, 47,  4 },
    {     47,  -23,    2, 23, 47,  4 }, {     48,  -24,    1, 23, 47,  4 }, {     48,  -25,    1, 23, 47,  4 }, {     48,  -26,    1, 23, 47,  4 }, {     48,  -27,    1, 23, 47,  4 },
    {     48,  -28,    1, 24, 47,  4 }, {     48,  -29,    1, 24, 47,  4 }, {     48,  -30,    1, 24, 47,  4 }, {     48,  -31,    1, 24, 47,  4 }, {     48,  -33,    0, 24, 47,  4 },
    {     48,  -34,    0, 24, 47,  4 }, {     48,  -35,    0, 24, 47,  4 }, {     48,  -36,    0, 24, 47,  4 }, {     48,  -37,    0, 25, 47,  4 }, {     48,  -38,    0, 25, 47,  4 },
    {     47,  -39,    0, 25, 47,  4 }, {     47,  -40,    0, 25, 47,  4 }, {     47,  -41,   -1, 25, 47,  4 }, {     47,  -42,   -1, 25, 47,  4 }, {     47,  -43,   -1, 25, 47,  4 },
    {     47,  -44,   -1, 25, 47,  4 }, {     46,  -45,   -1, 25, 47,  4 }, {     46,  -46,   -1, 26, 47,  4 }, {     46,  -47,   -1, 26, 47,  4 }, {     45,  -48,   -1, 26, 47,  4 },
    {     45,  -49,   -2, 26, 47,  4 }, {     45,  -50,   -2, 26, 47,  4 }, {     44,  -51,   -2, 26, 47,  4 }, {     44,  -52,   -2, 26, 47,  4 }, {     43,  -53,   -2, 26, 47,  4 },
    {     43,  -54,   -2, 26, 47,  4 }, {     42,  -55,   -2, 26, 47,  4 }, {     42,  -56,   -2, 27, 47,  4 }, {     41,  -57,   -2, 27, 47,  4 }, {     41,  -58,   -3, 27, 47,  4 },
    {     40,  -59,   -3, 27, 47,  4 }, {     39,  -60,   -3, 27, 47,  4 }, {     39,  -61,   -3, 27, 47,  4 }, {     38,  -62,   -3, 27, 47,  4 }, {     37,  -63,   -3, 27, 47,  4 },
    {     36,  -64,   -3, 27, 47,  4 }, {     35,  -65,   -3, 28, 47,  4 }, {     35,  -67,   -4, 28, 47,  4 }, {     34,  -68,   -4, 28, 47,  4 }, {     33,  -69,   -4, 28, 47,  4 },
    {     32,  -70,   -4, 28, 47,  4 }, {     31,  -71,   -4, 29, 47,  4 }, {     30,  -71,   -4, 29, 47,  4 }, {     29,  -72,   -4, 29, 47,  4 }, {     28,  -73,   -4, 29, 47,  4 },
    {     27,  -73,   -4, 29, 47,  4 }, {     26,  -74,   -5, 29, 47,  4 }, {     25,  -74,   -5, 29, 47,  4 }, {     24,  -75,   -5, 29, 47,  4 }, {     23,  -75,   -5, 29, 47,  4 },
    {     22,  -76,   -5, 30, 47,  4 }, {     21,  -76,   -5, 30, 47,  4 }, {     20,  -77,   -5, 30, 47,  4 }, {     19,  -77,   -5, 30, 47,  4 }, {     18,  -77,   -6, 30, 47,  4 },
    {     17,  -78,   -6, 30, 47,  4 }, {     16,  -78,   -6, 30, 47,  4 }, {     15,  -78,   -6, 30, 47,  4 }, {     14,  -79,   -6, 30, 47,  4 }, {     13,  -79,   -6, 30, 47,  4 },
    {     12,  -79,   -6, 31, 47,  4 }, {     11,  -79,   -6, 31, 47,  4 }, {     10,  -79,   -6, 31, 47,  4 }, {      9,  -79,   -7, 31, 47,  4 }, {      8,  -80,   -7, 31, 47,  4 },
    {      7,  -80,   -7, 31, 47,  4 }, {      6,  -80,   -7, 31, 47,  4 }, {      5,  -80,   -7, 31, 47,  4 }, {      4,  -80,   -7,  0, 47,  4 }, {      3,  -80,   -7,  0, 47,  4 },
    {      2,  -80,   -7,  0, 47,  4 }, {      1,  -80,   -8,  0, 47,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8FD461, {
    {     16,   31,    8, 24, 47,  4 }, {     16,   30,    8, 24, 47,  4 }, {     16,   29,    8, 24, 47,  4 }, {     16,   28,    8, 24, 47,  4 }, {     16,   27,    8, 25, 47,  4 },
    {     16,   26,    8, 25, 47,  4 }, {     15,   25,    8, 25, 47,  4 }, {     15,   24,    8, 25, 47,  4 }, {     15,   23,    7, 25, 47,  4 }, {     15,   22,    7, 25, 47,  4 },
    {     15,   21,    7, 25, 47,  4 }, {     15,   20,    7, 25, 47,  4 }, {     14,   19,    7, 25, 47,  4 }, {     14,   18,    7, 26, 47,  4 }, {     14,   17,    7, 26, 47,  4 },
    {     13,   16,    7, 26, 47,  4 }, {     13,   15,    6, 26, 47,  4 }, {     13,   14,    6, 26, 47,  4 }, {     12,   13,    6, 26, 47,  4 }, {     12,   12,    6, 26, 47,  4 },
    {     11,   11,    6, 26, 47,  4 }, {     11,   10,    6, 26, 47,  4 }, {     10,    9,    6, 26, 47,  4 }, {     10,    8,    6, 27, 47,  4 }, {      9,    7,    6, 27, 47,  4 },
    {      9,    6,    5, 27, 47,  4 }, {      8,    5,    5, 27, 47,  4 }, {      7,    4,    5, 27, 47,  4 }, {      7,    3,    5, 27, 47,  4 }, {      6,    2,    5, 27, 47,  4 },
    {      5,    1,    5, 27, 47,  4 }, {      4,    0,    5, 27, 47,  4 }, {      3,   -1,    5, 28, 47,  4 }, {      3,   -3,    4, 28, 47,  4 }, {      2,   -4,    4, 28, 47,  4 },
    {      1,   -5,    4, 28, 47,  4 }, {      0,   -6,    4, 28, 47,  4 }, {     -1,   -7,    4, 29, 47,  4 }, {     -2,   -7,    4, 29, 47,  4 }, {     -3,   -8,    4, 29, 47,  4 },
    {     -4,   -9,    4, 29, 47,  4 }, {     -5,   -9,    4, 29, 47,  4 }, {     -6,  -10,    3, 29, 47,  4 }, {     -7,  -10,    3, 29, 47,  4 }, {     -8,  -11,    3, 29, 47,  4 },
    {     -9,  -11,    3, 29, 47,  4 }, {    -10,  -12,    3, 30, 47,  4 }, {    -11,  -12,    3, 30, 47,  4 }, {    -12,  -13,    3, 30, 47,  4 }, {    -13,  -13,    3, 30, 47,  4 },
    {    -14,  -13,    2, 30, 47,  4 }, {    -15,  -14,    2, 30, 47,  4 }, {    -16,  -14,    2, 30, 47,  4 }, {    -17,  -14,    2, 30, 47,  4 }, {    -18,  -15,    2, 30, 47,  4 },
    {    -19,  -15,    2, 30, 47,  4 }, {    -20,  -15,    2, 31, 47,  4 }, {    -21,  -15,    2, 31, 47,  4 }, {    -22,  -15,    2, 31, 47,  4 }, {    -23,  -15,    1, 31, 47,  4 },
    {    -24,  -16,    1, 31, 47,  4 }, {    -25,  -16,    1, 31, 47,  4 }, {    -26,  -16,    1, 31, 47,  4 }, {    -27,  -16,    1, 31, 47,  4 }, {    -28,  -16,    1,  0, 47,  4 },
    {    -29,  -16,    1,  0, 47,  4 }, {    -30,  -16,    1,  0, 47,  4 }, {    -31,  -16,    0,  0, 47,  4 }, {    -33,  -16,    0,  0, 47,  4 }, {    -34,  -16,    0,  0, 47,  4 },
    {    -35,  -16,    0,  0, 47,  4 }, {    -36,  -16,    0,  0, 47,  4 }, {    -37,  -16,    0,  1, 47,  4 }, {    -38,  -16,    0,  1, 47,  4 }, {    -39,  -15,    0,  1, 47,  4 },
    {    -40,  -15,    0,  1, 47,  4 }, {    -41,  -15,   -1,  1, 47,  4 }, {    -42,  -15,   -1,  1, 47,  4 }, {    -43,  -15,   -1,  1, 47,  4 }, {    -44,  -15,   -1,  1, 47,  4 },
    {    -45,  -14,   -1,  1, 47,  4 }, {    -46,  -14,   -1,  2, 47,  4 }, {    -47,  -14,   -1,  2, 47,  4 }, {    -48,  -13,   -1,  2, 47,  4 }, {    -49,  -13,   -2,  2, 47,  4 },
    {    -50,  -13,   -2,  2, 47,  4 }, {    -51,  -12,   -2,  2, 47,  4 }, {    -52,  -12,   -2,  2, 47,  4 }, {    -53,  -11,   -2,  2, 47,  4 }, {    -54,  -11,   -2,  2, 47,  4 },
    {    -55,  -10,   -2,  2, 47,  4 }, {    -56,  -10,   -2,  3, 47,  4 }, {    -57,   -9,   -2,  3, 47,  4 }, {    -58,   -9,   -3,  3, 47,  4 }, {    -59,   -8,   -3,  3, 47,  4 },
    {    -60,   -7,   -3,  3, 47,  4 }, {    -61,   -7,   -3,  3, 47,  4 }, {    -62,   -6,   -3,  3, 47,  4 }, {    -63,   -5,   -3,  3, 47,  4 }, {    -64,   -4,   -3,  3, 47,  4 },
    {    -65,   -3,   -3,  4, 47,  4 }, {    -67,   -3,   -4,  4, 47,  4 }, {    -68,   -2,   -4,  4, 47,  4 }, {    -69,   -1,   -4,  4, 47,  4 }, {    -70,    0,   -4,  4, 47,  4 },
    {    -71,    1,   -4,  5, 47,  4 }, {    -71,    2,   -4,  5, 47,  4 }, {    -72,    3,   -4,  5, 47,  4 }, {    -73,    4,   -4,  5, 47,  4 }, {    -73,    5,   -5,  5, 47,  4 },
    {    -74,    6,   -5,  5, 47,  4 }, {    -74,    7,   -5,  5, 47,  4 }, {    -75,    8,   -5,  5, 47,  4 }, {    -75,    9,   -5,  5, 47,  4 }, {    -76,   10,   -5,  6, 47,  4 },
    {    -76,   11,   -5,  6, 47,  4 }, {    -77,   12,   -5,  6, 47,  4 }, {    -77,   13,   -5,  6, 47,  4 }, {    -77,   14,   -6,  6, 47,  4 }, {    -78,   15,   -6,  6, 47,  4 },
    {    -78,   16,   -6,  6, 47,  4 }, {    -78,   17,   -6,  6, 47,  4 }, {    -79,   18,   -6,  6, 47,  4 }, {    -79,   19,   -6,  6, 47,  4 }, {    -79,   20,   -6,  7, 47,  4 },
    {    -79,   21,   -6,  7, 47,  4 }, {    -79,   22,   -7,  7, 47,  4 }, {    -79,   23,   -7,  7, 47,  4 }, {    -80,   24,   -7,  7, 47,  4 }, {    -80,   25,   -7,  7, 47,  4 },
    {    -80,   26,   -7,  7, 47,  4 }, {    -80,   27,   -7,  7, 47,  4 }, {    -80,   28,   -7,  8, 47,  4 }, {    -80,   29,   -7,  8, 47,  4 }, {    -80,   30,   -8,  8, 47,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F0C22, {
    {     31,   16,    0,  0, 44,  2 }, {     30,   16,    0,  0, 44,  2 }, {     29,   16,    0,  0, 44,  2 }, {     28,   16,    0,  0, 44,  2 }, {     27,   16,    0,  0, 44,  2 },
    {     26,   16,    0,  0, 44,  2 }, {     25,   16,    0,  0, 44,  2 }, {     24,   16,    0, 31, 44,  2 }, {     23,   15,    0, 31, 44,  2 }, {     22,   15,    0, 31, 44,  2 },
    {     21,   15,    0, 31, 44,  2 }, {     20,   15,    0, 31, 44,  2 }, {     19,   15,    0, 31, 44,  2 }, {     18,   15,    0, 31, 44,  2 }, {     17,   14,    1, 31, 44,  2 },
    {     16,   14,    1, 31, 44,  2 }, {     15,   14,    1, 31, 44,  2 }, {     14,   14,    1, 31, 44,  2 }, {     13,   14,    1, 31, 44,  2 }, {     12,   13,    1, 31, 44,  2 },
    {     11,   13,    1, 31, 44,  2 }, {     10,   13,    1, 30, 44,  2 }, {      9,   13,    1, 30, 44,  2 }, {      8,   12,    1, 30, 44,  2 }, {      7,   12,    1, 30, 44,  2 },
    {      6,   12,    1, 30, 44,  2 }, {      5,   11,    1, 30, 44,  2 }, {      4,   11,    1, 30, 44,  2 }, {      3,   11,    2, 30, 44,  2 }, {      2,   10,    2, 30, 44,  2 },
    {      1,   10,    2, 30, 44,  2 }, {      0,    9,    2, 30, 44,  2 }, {     -1,    9,    2, 30, 44,  2 }, {     -2,    8,    2, 30, 44,  2 }, {     -3,    8,    2, 30, 44,  2 },
    {     -4,    7,    2, 30, 44,  2 }, {     -5,    7,    2, 29, 44,  2 }, {     -6,    6,    2, 29, 44,  2 }, {     -7,    6,    2, 29, 44,  2 }, {     -8,    5,    2, 29, 44,  2 },
    {     -9,    4,    2, 29, 44,  2 }, {    -10,    4,    2, 29, 44,  2 }, {    -11,    3,    3, 29, 44,  2 }, {    -12,    2,    3, 29, 44,  2 }, {    -13,    2,    3, 29, 44,  2 },
    {    -14,    1,    3, 29, 44,  2 }, {    -15,    0,    3, 29, 44,  2 }, {    -16,    0,    3, 29, 44,  2 }, {    -17,   -1,    3, 29, 44,  2 }, {    -18,   -2,    3, 28, 44,  2 },
    {    -19,   -3,    3, 28, 44,  2 }, {    -20,   -3,    3, 28, 44,  2 }, {    -21,   -4,    3, 28, 44,  2 }, {    -22,   -5,    3, 28, 44,  2 }, {    -23,   -6,    3, 28, 44,  2 },
    {    -24,   -7,    3, 28, 44,  2 }, {    -25,   -7,    4, 28, 44,  2 }, {    -26,   -8,    4, 28, 44,  2 }, {    -27,   -9,    4, 28, 44,  2 }, {    -28,  -10,    4, 28, 44,  2 },
    {    -29,  -11,    4, 28, 44,  2 }, {    -29,  -12,    4, 28, 44,  2 }, {    -30,  -13,    4, 27, 44,  2 }, {    -31,  -14,    4, 27, 44,  2 }, {    -32,  -15,    4, 27, 44,  2 },
    {    -32,  -16,    4, 27, 44,  2 }, {    -33,  -17,    4, 27, 44,  2 }, {    -34,  -18,    4, 27, 44,  2 }, {    -34,  -19,    4, 27, 44,  2 }, {    -35,  -20,    4, 27, 44,  2 },
    {    -36,  -21,    4, 27, 44,  2 }, {    -36,  -22,    5, 27, 44,  2 }, {    -37,  -23,    5, 27, 44,  2 }, {    -38,  -24,    5, 27, 44,  2 }, {    -38,  -25,    5, 27, 44,  2 },
    {    -39,  -26,    5, 26, 44,  2 }, {    -39,  -27,    5, 26, 44,  2 }, {    -40,  -28,    5, 26, 44,  2 }, {    -40,  -29,    5, 26, 44,  2 }, {    -41,  -30,    5, 26, 44,  2 },
    {    -41,  -31,    5, 26, 44,  2 }, {    -42,  -32,    5, 26, 44,  2 }, {    -42,  -33,    5, 26, 44,  2 }, {    -43,  -34,    5, 26, 44,  2 }, {    -43,  -35,    5, 26, 44,  2 },
    {    -43,  -36,    6, 26, 44,  2 }, {    -44,  -37,    6, 26, 44,  2 }, {    -44,  -38,    6, 26, 44,  2 }, {    -44,  -39,    6, 26, 44,  2 }, {    -45,  -40,    6, 25, 44,  2 },
    {    -45,  -41,    6, 25, 44,  2 }, {    -45,  -42,    6, 25, 44,  2 }, {    -45,  -43,    6, 25, 44,  2 }, {    -46,  -44,    6, 25, 44,  2 }, {    -46,  -45,    6, 25, 44,  2 },
    {    -46,  -46,    6, 25, 44,  2 }, {    -46,  -47,    6, 25, 44,  2 }, {    -46,  -48,    6, 25, 44,  2 }, {    -47,  -49,    6, 25, 44,  2 }, {    -47,  -50,    7, 25, 44,  2 },
    {    -47,  -51,    7, 25, 44,  2 }, {    -47,  -52,    7, 25, 44,  2 }, {    -47,  -53,    7, 25, 44,  2 }, {    -47,  -54,    7, 25, 44,  2 }, {    -48,  -55,    7, 25, 44,  2 },
    {    -48,  -56,    7, 24, 44,  2 }, {    -48,  -57,    7, 24, 44,  2 }, {    -48,  -58,    7, 24, 44,  2 }, {    -48,  -59,    7, 24, 44,  2 }, {    -48,  -60,    7, 24, 44,  2 },
    {    -48,  -61,    7, 24, 44,  2 }, {    -48,  -62,    7, 24, 44,  2 }, {    -48,  -63,    7, 24, 44,  2 }, {    -48,  -64,    8, 24, 44,  2 }, {    -48,  -65,    8, 24, 44,  2 },
    {    -48,  -66,    8, 24, 44,  2 }, {    -48,  -67,    8, 24, 44,  2 }, {    -48,  -68,    8, 24, 44,  2 }, {    -48,  -69,    8, 24, 44,  2 }, {    -48,  -70,    8, 24, 44,  2 },
    {    -48,  -71,    8, 24, 44,  2 }, {    -48,  -72,    8, 23, 44,  2 }, {    -47,  -73,    8, 23, 44,  2 }, {    -47,  -74,    8, 23, 44,  2 }, {    -47,  -75,    8, 23, 44,  2 },
    {    -47,  -76,    8, 23, 44,  2 }, {    -47,  -77,    8, 23, 44,  2 }, {    -47,  -78,    8, 23, 44,  2 }, {    -46,  -79,    9, 23, 44,  2 }, {    -46,  -80,    9, 23, 44,  2 },
    {    -46,  -81,    9, 23, 44,  2 }, {    -46,  -82,    9, 23, 44,  2 }, {    -46,  -83,    9, 23, 44,  2 }, {    -45,  -84,    9, 23, 44,  2 }, {    -45,  -85,    9, 23, 44,  2 },
    {    -45,  -86,    9, 22, 44,  2 }, {    -45,  -87,    9, 22, 44,  2 }, {    -44,  -88,    9, 22, 44,  2 }, {    -44,  -89,    9, 22, 44,  2 }, {    -44,  -90,    9, 22, 44,  2 },
    {    -43,  -91,    9, 22, 44,  2 }, {    -43,  -92,    9, 22, 44,  2 }, {    -43,  -93,   10, 22, 44,  2 }, {    -42,  -94,   10, 22, 44,  2 }, {    -42,  -95,   10, 22, 44,  2 },
    {    -41,  -96,   10, 22, 44,  2 }, {    -41,  -97,   10, 22, 44,  2 }, {    -40,  -98,   10, 22, 44,  2 }, {    -40,  -99,   10, 22, 44,  2 }, {    -39, -100,   10, 22, 44,  2 },
    {    -39, -101,   10, 21, 44,  2 }, {    -38, -102,   10, 21, 44,  2 }, {    -38, -103,   10, 21, 44,  2 }, {    -37, -104,   10, 21, 44,  2 }, {    -36, -105,   10, 21, 44,  2 },
    {    -36, -106,   10, 21, 44,  2 }, {    -35, -107,   11, 21, 44,  2 }, {    -34, -108,   11, 21, 44,  2 }, {    -34, -109,   11, 21, 44,  2 }, {    -33, -110,   11, 21, 44,  2 },
    {    -32, -111,   11, 21, 44,  2 }, {    -32, -112,   11, 21, 44,  2 }, {    -31, -113,   11, 21, 44,  2 }, {    -30, -114,   11, 20, 44,  2 }, {    -29, -115,   11, 20, 44,  2 },
    {    -29, -116,   11, 20, 44,  2 }, {    -28, -117,   11, 20, 44,  2 }, {    -27, -118,   11, 20, 44,  2 }, {    -26, -119,   11, 20, 44,  2 }, {    -25, -120,   11, 20, 44,  2 },
    {    -25, -121,   12, 20, 44,  2 }, {    -24, -122,   12, 20, 44,  2 }, {    -23, -123,   12, 20, 44,  2 }, {    -22, -124,   12, 20, 44,  2 }, {    -21, -125,   12, 20, 44,  2 },
    {    -20, -125,   12, 20, 44,  2 }, {    -19, -126,   12, 19, 44,  2 }, {    -18, -127,   12, 19, 44,  2 }, {    -17, -128,   12, 19, 44,  2 }, {    -16, -128,   12, 19, 44,  2 },
    {    -15, -129,   12, 19, 44,  2 }, {    -14, -130,   12, 19, 44,  2 }, {    -13, -130,   12, 19, 44,  2 }, {    -12, -131,   12, 19, 44,  2 }, {    -11, -132,   13, 19, 44,  2 },
    {    -10, -132,   13, 19, 44,  2 }, {     -9, -133,   13, 19, 44,  2 }, {     -8, -134,   13, 19, 44,  2 }, {     -7, -134,   13, 19, 44,  2 }, {     -6, -135,   13, 18, 44,  2 },
    {     -5, -135,   13, 18, 44,  2 }, {     -4, -136,   13, 18, 44,  2 }, {     -3, -136,   13, 18, 44,  2 }, {     -2, -137,   13, 18, 44,  2 }, {     -1, -137,   13, 18, 44,  2 },
    {      0, -138,   13, 18, 44,  2 }, {      1, -138,   13, 18, 44,  2 }, {      2, -139,   13, 18, 44,  2 }, {      3, -139,   14, 18, 44,  2 }, {      4, -139,   14, 18, 44,  2 },
    {      5, -140,   14, 18, 44,  2 }, {      6, -140,   14, 18, 44,  2 }, {      7, -140,   14, 18, 44,  2 }, {      8, -141,   14, 17, 44,  2 }, {      9, -141,   14, 17, 44,  2 },
    {     10, -141,   14, 17, 44,  2 }, {     11, -141,   14, 17, 44,  2 }, {     12, -142,   14, 17, 44,  2 }, {     13, -142,   14, 17, 44,  2 }, {     14, -142,   14, 17, 44,  2 },
    {     15, -142,   14, 17, 44,  2 }, {     16, -142,   14, 17, 44,  2 }, {     17, -143,   15, 17, 44,  2 }, {     18, -143,   15, 17, 44,  2 }, {     19, -143,   15, 17, 44,  2 },
    {     20, -143,   15, 17, 44,  2 }, {     21, -143,   15, 17, 44,  2 }, {     22, -143,   15, 17, 44,  2 }, {     23, -144,   15, 17, 44,  2 }, {     24, -144,   15, 16, 44,  2 },
    {     25, -144,   15, 16, 44,  2 }, {     26, -144,   15, 16, 44,  2 }, {     27, -144,   15, 16, 44,  2 }, {     28, -144,   15, 16, 44,  2 }, {     29, -144,   15, 16, 44,  2 },
    {     30, -144,   15, 16, 44,  2 }, {     31, -144,   16, 16, 44,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F141F, {
    {     16,    0,    0,  8, 44,  2 }, {     16,    1,    0,  8, 44,  2 }, {     16,    2,    0,  8, 44,  2 }, {     16,    3,    0,  8, 44,  2 }, {     16,    4,    0,  8, 44,  2 },
    {     16,    5,    0,  8, 44,  2 }, {     16,    6,    0,  8, 44,  2 }, {     16,    7,    0,  8, 44,  2 }, {     16,    8,    0,  7, 44,  2 }, {     15,    9,    0,  7, 44,  2 },
    {     15,   10,    0,  7, 44,  2 }, {     15,   11,    0,  7, 44,  2 }, {     15,   12,    0,  7, 44,  2 }, {     15,   13,    0,  7, 44,  2 }, {     15,   14,    0,  7, 44,  2 },
    {     14,   15,    1,  7, 44,  2 }, {     14,   16,    1,  7, 44,  2 }, {     14,   17,    1,  7, 44,  2 }, {     14,   18,    1,  7, 44,  2 }, {     14,   19,    1,  7, 44,  2 },
    {     13,   20,    1,  7, 44,  2 }, {     13,   21,    1,  7, 44,  2 }, {     13,   22,    1,  6, 44,  2 }, {     13,   23,    1,  6, 44,  2 }, {     12,   24,    1,  6, 44,  2 },
    {     12,   25,    1,  6, 44,  2 }, {     12,   26,    1,  6, 44,  2 }, {     11,   27,    1,  6, 44,  2 }, {     11,   28,    1,  6, 44,  2 }, {     11,   29,    2,  6, 44,  2 },
    {     10,   30,    2,  6, 44,  2 }, {     10,   31,    2,  6, 44,  2 }, {      9,   32,    2,  6, 44,  2 }, {      9,   33,    2,  6, 44,  2 }, {      8,   34,    2,  6, 44,  2 },
    {      8,   35,    2,  6, 44,  2 }, {      7,   36,    2,  6, 44,  2 }, {      7,   37,    2,  5, 44,  2 }, {      6,   38,    2,  5, 44,  2 }, {      6,   39,    2,  5, 44,  2 },
    {      5,   40,    2,  5, 44,  2 }, {      4,   41,    2,  5, 44,  2 }, {      4,   42,    2,  5, 44,  2 }, {      3,   43,    2,  5, 44,  2 }, {      2,   44,    3,  5, 44,  2 },
    {      2,   45,    3,  5, 44,  2 }, {      1,   46,    3,  5, 44,  2 }, {      0,   47,    3,  5, 44,  2 }, {      0,   48,    3,  5, 44,  2 }, {     -1,   49,    3,  5, 44,  2 },
    {     -2,   50,    3,  4, 44,  2 }, {     -3,   51,    3,  4, 44,  2 }, {     -3,   52,    3,  4, 44,  2 }, {     -4,   53,    3,  4, 44,  2 }, {     -5,   54,    3,  4, 44,  2 },
    {     -6,   55,    3,  4, 44,  2 }, {     -7,   56,    3,  4, 44,  2 }, {     -7,   57,    3,  4, 44,  2 }, {     -8,   58,    4,  4, 44,  2 }, {     -9,   59,    4,  4, 44,  2 },
    {    -10,   60,    4,  4, 44,  2 }, {    -11,   61,    4,  4, 44,  2 }, {    -12,   61,    4,  4, 44,  2 }, {    -13,   62,    4,  3, 44,  2 }, {    -14,   63,    4,  3, 44,  2 },
    {    -15,   64,    4,  3, 44,  2 }, {    -16,   64,    4,  3, 44,  2 }, {    -17,   65,    4,  3, 44,  2 }, {    -18,   66,    4,  3, 44,  2 }, {    -19,   66,    4,  3, 44,  2 },
    {    -20,   67,    4,  3, 44,  2 }, {    -21,   68,    4,  3, 44,  2 }, {    -22,   68,    5,  3, 44,  2 }, {    -23,   69,    5,  3, 44,  2 }, {    -24,   70,    5,  3, 44,  2 },
    {    -25,   70,    5,  3, 44,  2 }, {    -26,   71,    5,  2, 44,  2 }, {    -27,   71,    5,  2, 44,  2 }, {    -28,   72,    5,  2, 44,  2 }, {    -29,   72,    5,  2, 44,  2 },
    {    -30,   73,    5,  2, 44,  2 }, {    -31,   73,    5,  2, 44,  2 }, {    -32,   74,    5,  2, 44,  2 }, {    -33,   74,    5,  2, 44,  2 }, {    -34,   75,    5,  2, 44,  2 },
    {    -35,   75,    5,  2, 44,  2 }, {    -36,   75,    5,  2, 44,  2 }, {    -37,   76,    6,  2, 44,  2 }, {    -38,   76,    6,  2, 44,  2 }, {    -39,   76,    6,  2, 44,  2 },
    {    -40,   77,    6,  1, 44,  2 }, {    -41,   77,    6,  1, 44,  2 }, {    -42,   77,    6,  1, 44,  2 }, {    -43,   77,    6,  1, 44,  2 }, {    -44,   78,    6,  1, 44,  2 },
    {    -45,   78,    6,  1, 44,  2 }, {    -46,   78,    6,  1, 44,  2 }, {    -47,   78,    6,  1, 44,  2 }, {    -48,   78,    6,  1, 44,  2 }, {    -49,   79,    6,  1, 44,  2 },
    {    -50,   79,    6,  1, 44,  2 }, {    -51,   79,    7,  1, 44,  2 }, {    -52,   79,    7,  1, 44,  2 }, {    -53,   79,    7,  1, 44,  2 }, {    -54,   79,    7,  1, 44,  2 },
    {    -55,   80,    7,  1, 44,  2 }, {    -56,   80,    7,  0, 44,  2 }, {    -57,   80,    7,  0, 44,  2 }, {    -58,   80,    7,  0, 44,  2 }, {    -59,   80,    7,  0, 44,  2 },
    {    -60,   80,    7,  0, 44,  2 }, {    -61,   80,    7,  0, 44,  2 }, {    -62,   80,    7,  0, 44,  2 }, {    -63,   80,    7,  0, 44,  2 }, {    -64,   80,    7,  0, 44,  2 },
    {    -65,   80,    8,  0, 44,  2 }, {    -66,   80,    8,  0, 44,  2 }, {    -67,   80,    8,  0, 44,  2 }, {    -68,   80,    8,  0, 44,  2 }, {    -69,   80,    8,  0, 44,  2 },
    {    -70,   80,    8,  0, 44,  2 }, {    -71,   80,    8,  0, 44,  2 }, {    -72,   80,    8, 31, 44,  2 }, {    -73,   79,    8, 31, 44,  2 }, {    -74,   79,    8, 31, 44,  2 },
    {    -75,   79,    8, 31, 44,  2 }, {    -76,   79,    8, 31, 44,  2 }, {    -77,   79,    8, 31, 44,  2 }, {    -78,   79,    8, 31, 44,  2 }, {    -79,   78,    9, 31, 44,  2 },
    {    -80,   78,    9, 31, 44,  2 }, {    -81,   78,    9, 31, 44,  2 }, {    -82,   78,    9, 31, 44,  2 }, {    -83,   78,    9, 31, 44,  2 }, {    -84,   77,    9, 31, 44,  2 },
    {    -85,   77,    9, 31, 44,  2 }, {    -86,   77,    9, 30, 44,  2 }, {    -87,   77,    9, 30, 44,  2 }, {    -88,   76,    9, 30, 44,  2 }, {    -89,   76,    9, 30, 44,  2 },
    {    -90,   76,    9, 30, 44,  2 }, {    -91,   75,    9, 30, 44,  2 }, {    -92,   75,    9, 30, 44,  2 }, {    -93,   75,   10, 30, 44,  2 }, {    -94,   74,   10, 30, 44,  2 },
    {    -95,   74,   10, 30, 44,  2 }, {    -96,   73,   10, 30, 44,  2 }, {    -97,   73,   10, 30, 44,  2 }, {    -98,   72,   10, 30, 44,  2 }, {    -99,   72,   10, 30, 44,  2 },
    {   -100,   71,   10, 30, 44,  2 }, {   -101,   71,   10, 29, 44,  2 }, {   -102,   70,   10, 29, 44,  2 }, {   -103,   70,   10, 29, 44,  2 }, {   -104,   69,   10, 29, 44,  2 },
    {   -105,   68,   10, 29, 44,  2 }, {   -106,   68,   10, 29, 44,  2 }, {   -107,   67,   11, 29, 44,  2 }, {   -108,   66,   11, 29, 44,  2 }, {   -109,   66,   11, 29, 44,  2 },
    {   -110,   65,   11, 29, 44,  2 }, {   -111,   64,   11, 29, 44,  2 }, {   -112,   64,   11, 29, 44,  2 }, {   -113,   63,   11, 29, 44,  2 }, {   -114,   62,   11, 28, 44,  2 },
    {   -115,   61,   11, 28, 44,  2 }, {   -116,   61,   11, 28, 44,  2 }, {   -117,   60,   11, 28, 44,  2 }, {   -118,   59,   11, 28, 44,  2 }, {   -119,   58,   11, 28, 44,  2 },
    {   -120,   57,   11, 28, 44,  2 }, {   -121,   57,   12, 28, 44,  2 }, {   -122,   56,   12, 28, 44,  2 }, {   -123,   55,   12, 28, 44,  2 }, {   -124,   54,   12, 28, 44,  2 },
    {   -125,   53,   12, 28, 44,  2 }, {   -125,   52,   12, 28, 44,  2 }, {   -126,   51,   12, 27, 44,  2 }, {   -127,   50,   12, 27, 44,  2 }, {   -128,   49,   12, 27, 44,  2 },
    {   -128,   48,   12, 27, 44,  2 }, {   -129,   47,   12, 27, 44,  2 }, {   -130,   46,   12, 27, 44,  2 }, {   -130,   45,   12, 27, 44,  2 }, {   -131,   44,   12, 27, 44,  2 },
    {   -132,   43,   12, 27, 44,  2 }, {   -132,   42,   13, 27, 44,  2 }, {   -133,   41,   13, 27, 44,  2 }, {   -134,   40,   13, 27, 44,  2 }, {   -134,   39,   13, 27, 44,  2 },
    {   -135,   38,   13, 26, 44,  2 }, {   -135,   37,   13, 26, 44,  2 }, {   -136,   36,   13, 26, 44,  2 }, {   -136,   35,   13, 26, 44,  2 }, {   -137,   34,   13, 26, 44,  2 },
    {   -137,   33,   13, 26, 44,  2 }, {   -138,   32,   13, 26, 44,  2 }, {   -138,   31,   13, 26, 44,  2 }, {   -139,   30,   13, 26, 44,  2 }, {   -139,   29,   13, 26, 44,  2 },
    {   -139,   28,   14, 26, 44,  2 }, {   -140,   27,   14, 26, 44,  2 }, {   -140,   26,   14, 26, 44,  2 }, {   -140,   25,   14, 26, 44,  2 }, {   -141,   24,   14, 25, 44,  2 },
    {   -141,   23,   14, 25, 44,  2 }, {   -141,   22,   14, 25, 44,  2 }, {   -141,   21,   14, 25, 44,  2 }, {   -142,   20,   14, 25, 44,  2 }, {   -142,   19,   14, 25, 44,  2 },
    {   -142,   18,   14, 25, 44,  2 }, {   -142,   17,   14, 25, 44,  2 }, {   -142,   16,   14, 25, 44,  2 }, {   -143,   15,   14, 25, 44,  2 }, {   -143,   14,   15, 25, 44,  2 },
    {   -143,   13,   15, 25, 44,  2 }, {   -143,   12,   15, 25, 44,  2 }, {   -143,   11,   15, 25, 44,  2 }, {   -143,   10,   15, 25, 44,  2 }, {   -144,    9,   15, 25, 44,  2 },
    {   -144,    8,   15, 24, 44,  2 }, {   -144,    7,   15, 24, 44,  2 }, {   -144,    6,   15, 24, 44,  2 }, {   -144,    5,   15, 24, 44,  2 }, {   -144,    4,   15, 24, 44,  2 },
    {   -144,    3,   15, 24, 44,  2 }, {   -144,    2,   15, 24, 44,  2 }, {   -144,    1,   15, 24, 44,  2 }, {   -144,    0,   16, 24, 44,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F1C2E, {
    {      0,   16,    0, 16, 44,  2 }, {      1,   16,    0, 16, 44,  2 }, {      2,   16,    0, 16, 44,  2 }, {      3,   16,    0, 16, 44,  2 }, {      4,   16,    0, 16, 44,  2 },
    {      5,   16,    0, 16, 44,  2 }, {      6,   16,    0, 16, 44,  2 }, {      7,   16,    0, 16, 44,  2 }, {      8,   16,    0, 15, 44,  2 }, {      9,   17,    0, 15, 44,  2 },
    {     10,   17,    0, 15, 44,  2 }, {     11,   17,    0, 15, 44,  2 }, {     12,   17,    0, 15, 44,  2 }, {     13,   17,    0, 15, 44,  2 }, {     14,   17,    0, 15, 44,  2 },
    {     15,   18,    1, 15, 44,  2 }, {     16,   18,    1, 15, 44,  2 }, {     17,   18,    1, 15, 44,  2 }, {     18,   18,    1, 15, 44,  2 }, {     19,   18,    1, 15, 44,  2 },
    {     20,   19,    1, 15, 44,  2 }, {     21,   19,    1, 15, 44,  2 }, {     22,   19,    1, 14, 44,  2 }, {     23,   19,    1, 14, 44,  2 }, {     24,   20,    1, 14, 44,  2 },
    {     25,   20,    1, 14, 44,  2 }, {     26,   20,    1, 14, 44,  2 }, {     27,   21,    1, 14, 44,  2 }, {     28,   21,    1, 14, 44,  2 }, {     29,   21,    2, 14, 44,  2 },
    {     30,   22,    2, 14, 44,  2 }, {     31,   22,    2, 14, 44,  2 }, {     32,   23,    2, 14, 44,  2 }, {     33,   23,    2, 14, 44,  2 }, {     34,   24,    2, 14, 44,  2 },
    {     35,   24,    2, 14, 44,  2 }, {     36,   25,    2, 14, 44,  2 }, {     37,   25,    2, 13, 44,  2 }, {     38,   26,    2, 13, 44,  2 }, {     39,   26,    2, 13, 44,  2 },
    {     40,   27,    2, 13, 44,  2 }, {     41,   28,    2, 13, 44,  2 }, {     42,   28,    2, 13, 44,  2 }, {     43,   29,    3, 13, 44,  2 }, {     44,   30,    3, 13, 44,  2 },
    {     45,   30,    3, 13, 44,  2 }, {     46,   31,    3, 13, 44,  2 }, {     47,   32,    3, 13, 44,  2 }, {     48,   32,    3, 13, 44,  2 }, {     49,   33,    3, 13, 44,  2 },
    {     50,   34,    3, 12, 44,  2 }, {     51,   35,    3, 12, 44,  2 }, {     52,   35,    3, 12, 44,  2 }, {     53,   36,    3, 12, 44,  2 }, {     54,   37,    3, 12, 44,  2 },
    {     55,   38,    3, 12, 44,  2 }, {     56,   39,    3, 12, 44,  2 }, {     57,   39,    4, 12, 44,  2 }, {     58,   40,    4, 12, 44,  2 }, {     59,   41,    4, 12, 44,  2 },
    {     60,   42,    4, 12, 44,  2 }, {     61,   43,    4, 12, 44,  2 }, {     61,   44,    4, 12, 44,  2 }, {     62,   45,    4, 11, 44,  2 }, {     63,   46,    4, 11, 44,  2 },
    {     64,   47,    4, 11, 44,  2 }, {     64,   48,    4, 11, 44,  2 }, {     65,   49,    4, 11, 44,  2 }, {     66,   50,    4, 11, 44,  2 }, {     66,   51,    4, 11, 44,  2 },
    {     67,   52,    4, 11, 44,  2 }, {     68,   53,    4, 11, 44,  2 }, {     68,   54,    5, 11, 44,  2 }, {     69,   55,    5, 11, 44,  2 }, {     70,   56,    5, 11, 44,  2 },
    {     70,   57,    5, 11, 44,  2 }, {     71,   58,    5, 10, 44,  2 }, {     71,   59,    5, 10, 44,  2 }, {     72,   60,    5, 10, 44,  2 }, {     72,   61,    5, 10, 44,  2 },
    {     73,   62,    5, 10, 44,  2 }, {     73,   63,    5, 10, 44,  2 }, {     74,   64,    5, 10, 44,  2 }, {     74,   65,    5, 10, 44,  2 }, {     75,   66,    5, 10, 44,  2 },
    {     75,   67,    5, 10, 44,  2 }, {     75,   68,    6, 10, 44,  2 }, {     76,   69,    6, 10, 44,  2 }, {     76,   70,    6, 10, 44,  2 }, {     76,   71,    6, 10, 44,  2 },
    {     77,   72,    6,  9, 44,  2 }, {     77,   73,    6,  9, 44,  2 }, {     77,   74,    6,  9, 44,  2 }, {     77,   75,    6,  9, 44,  2 }, {     78,   76,    6,  9, 44,  2 },
    {     78,   77,    6,  9, 44,  2 }, {     78,   78,    6,  9, 44,  2 }, {     78,   79,    6,  9, 44,  2 }, {     78,   80,    6,  9, 44,  2 }, {     79,   81,    6,  9, 44,  2 },
    {     79,   82,    7,  9, 44,  2 }, {     79,   83,    7,  9, 44,  2 }, {     79,   84,    7,  9, 44,  2 }, {     79,   85,    7,  9, 44,  2 }, {     79,   86,    7,  9, 44,  2 },
    {     80,   87,    7,  9, 44,  2 }, {     80,   88,    7,  8, 44,  2 }, {     80,   89,    7,  8, 44,  2 }, {     80,   90,    7,  8, 44,  2 }, {     80,   91,    7,  8, 44,  2 },
    {     80,   92,    7,  8, 44,  2 }, {     80,   93,    7,  8, 44,  2 }, {     80,   94,    7,  8, 44,  2 }, {     80,   95,    7,  8, 44,  2 }, {     80,   96,    8,  8, 44,  2 },
    {     80,   97,    8,  8, 44,  2 }, {     80,   98,    8,  8, 44,  2 }, {     80,   99,    8,  8, 44,  2 }, {     80,  100,    8,  8, 44,  2 }, {     80,  101,    8,  8, 44,  2 },
    {     80,  102,    8,  8, 44,  2 }, {     80,  103,    8,  8, 44,  2 }, {     80,  104,    8,  7, 44,  2 }, {     79,  105,    8,  7, 44,  2 }, {     79,  106,    8,  7, 44,  2 },
    {     79,  107,    8,  7, 44,  2 }, {     79,  108,    8,  7, 44,  2 }, {     79,  109,    8,  7, 44,  2 }, {     79,  110,    8,  7, 44,  2 }, {     78,  111,    9,  7, 44,  2 },
    {     78,  112,    9,  7, 44,  2 }, {     78,  113,    9,  7, 44,  2 }, {     78,  114,    9,  7, 44,  2 }, {     78,  115,    9,  7, 44,  2 }, {     77,  116,    9,  7, 44,  2 },
    {     77,  117,    9,  7, 44,  2 }, {     77,  118,    9,  6, 44,  2 }, {     77,  119,    9,  6, 44,  2 }, {     76,  120,    9,  6, 44,  2 }, {     76,  121,    9,  6, 44,  2 },
    {     76,  122,    9,  6, 44,  2 }, {     75,  123,    9,  6, 44,  2 }, {     75,  124,    9,  6, 44,  2 }, {     75,  125,   10,  6, 44,  2 }, {     74,  126,   10,  6, 44,  2 },
    {     74,  127,   10,  6, 44,  2 }, {     73,  128,   10,  6, 44,  2 }, {     73,  129,   10,  6, 44,  2 }, {     72,  130,   10,  6, 44,  2 }, {     72,  131,   10,  6, 44,  2 },
    {     71,  132,   10,  6, 44,  2 }, {     71,  133,   10,  5, 44,  2 }, {     70,  134,   10,  5, 44,  2 }, {     70,  135,   10,  5, 44,  2 }, {     69,  136,   10,  5, 44,  2 },
    {     68,  137,   10,  5, 44,  2 }, {     68,  138,   10,  5, 44,  2 }, {     67,  139,   10,  5, 44,  2 }, {     66,  140,   11,  5, 44,  2 }, {     66,  141,   11,  5, 44,  2 },
    {     65,  142,   11,  5, 44,  2 }, {     64,  143,   11,  5, 44,  2 }, {     64,  144,   11,  5, 44,  2 }, {     63,  145,   11,  5, 44,  2 }, {     62,  146,   11,  4, 44,  2 },
    {     61,  147,   11,  4, 44,  2 }, {     61,  148,   11,  4, 44,  2 }, {     60,  149,   11,  4, 44,  2 }, {     59,  150,   11,  4, 44,  2 }, {     58,  151,   11,  4, 44,  2 },
    {     57,  152,   11,  4, 44,  2 }, {     57,  153,   11,  4, 44,  2 }, {     56,  154,   12,  4, 44,  2 }, {     55,  155,   12,  4, 44,  2 }, {     54,  156,   12,  4, 44,  2 },
    {     53,  157,   12,  4, 44,  2 }, {     52,  157,   12,  4, 44,  2 }, {     51,  158,   12,  3, 44,  2 }, {     50,  159,   12,  3, 44,  2 }, {     49,  160,   12,  3, 44,  2 },
    {     48,  160,   12,  3, 44,  2 }, {     47,  161,   12,  3, 44,  2 }, {     46,  162,   12,  3, 44,  2 }, {     45,  162,   12,  3, 44,  2 }, {     44,  163,   12,  3, 44,  2 },
    {     43,  164,   12,  3, 44,  2 }, {     42,  164,   13,  3, 44,  2 }, {     41,  165,   13,  3, 44,  2 }, {     40,  166,   13,  3, 44,  2 }, {     39,  166,   13,  3, 44,  2 },
    {     38,  167,   13,  2, 44,  2 }, {     37,  167,   13,  2, 44,  2 }, {     36,  168,   13,  2, 44,  2 }, {     35,  168,   13,  2, 44,  2 }, {     34,  169,   13,  2, 44,  2 },
    {     33,  169,   13,  2, 44,  2 }, {     32,  170,   13,  2, 44,  2 }, {     31,  170,   13,  2, 44,  2 }, {     30,  171,   13,  2, 44,  2 }, {     29,  171,   13,  2, 44,  2 },
    {     28,  171,   13,  2, 44,  2 }, {     27,  172,   14,  2, 44,  2 }, {     26,  172,   14,  2, 44,  2 }, {     25,  172,   14,  2, 44,  2 }, {     24,  173,   14,  1, 44,  2 },
    {     23,  173,   14,  1, 44,  2 }, {     22,  173,   14,  1, 44,  2 }, {     21,  173,   14,  1, 44,  2 }, {     20,  174,   14,  1, 44,  2 }, {     19,  174,   14,  1, 44,  2 },
    {     18,  174,   14,  1, 44,  2 }, {     17,  174,   14,  1, 44,  2 }, {     16,  174,   14,  1, 44,  2 }, {     15,  175,   14,  1, 44,  2 }, {     14,  175,   14,  1, 44,  2 },
    {     13,  175,   15,  1, 44,  2 }, {     12,  175,   15,  1, 44,  2 }, {     11,  175,   15,  1, 44,  2 }, {     10,  175,   15,  1, 44,  2 }, {      9,  176,   15,  1, 44,  2 },
    {      8,  176,   15,  0, 44,  2 }, {      7,  176,   15,  0, 44,  2 }, {      6,  176,   15,  0, 44,  2 }, {      5,  176,   15,  0, 44,  2 }, {      4,  176,   15,  0, 44,  2 },
    {      3,  176,   15,  0, 44,  2 }, {      2,  176,   15,  0, 44,  2 }, {      1,  176,   15,  0, 44,  2 }, {      0,  176,   15,  0, 44,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F243D, {
    {     16,   31,    0, 24, 44,  2 }, {     16,   30,    0, 24, 44,  2 }, {     16,   29,    0, 24, 44,  2 }, {     16,   28,    0, 24, 44,  2 }, {     16,   27,    0, 24, 44,  2 },
    {     16,   26,    0, 24, 44,  2 }, {     16,   25,    0, 24, 44,  2 }, {     16,   24,    0, 23, 44,  2 }, {     17,   23,    0, 23, 44,  2 }, {     17,   22,    0, 23, 44,  2 },
    {     17,   21,    0, 23, 44,  2 }, {     17,   20,    0, 23, 44,  2 }, {     17,   19,    0, 23, 44,  2 }, {     17,   18,    0, 23, 44,  2 }, {     18,   17,    1, 23, 44,  2 },
    {     18,   16,    1, 23, 44,  2 }, {     18,   15,    1, 23, 44,  2 }, {     18,   14,    1, 23, 44,  2 }, {     18,   13,    1, 23, 44,  2 }, {     19,   12,    1, 23, 44,  2 },
    {     19,   11,    1, 23, 44,  2 }, {     19,   10,    1, 22, 44,  2 }, {     19,    9,    1, 22, 44,  2 }, {     20,    8,    1, 22, 44,  2 }, {     20,    7,    1, 22, 44,  2 },
    {     20,    6,    1, 22, 44,  2 }, {     21,    5,    1, 22, 44,  2 }, {     21,    4,    1, 22, 44,  2 }, {     21,    3,    2, 22, 44,  2 }, {     22,    2,    2, 22, 44,  2 },
    {     22,    1,    2, 22, 44,  2 }, {     23,    0,    2, 22, 44,  2 }, {     23,   -1,    2, 22, 44,  2 }, {     24,   -2,    2, 22, 44,  2 }, {     24,   -3,    2, 22, 44,  2 },
    {     25,   -4,    2, 22, 44,  2 }, {     25,   -5,    2, 21, 44,  2 }, {     26,   -6,    2, 21, 44,  2 }, {     26,   -7,    2, 21, 44,  2 }, {     27,   -8,    2, 21, 44,  2 },
    {     28,   -9,    2, 21, 44,  2 }, {     28,  -10,    2, 21, 44,  2 }, {     29,  -11,    3, 21, 44,  2 }, {     30,  -12,    3, 21, 44,  2 }, {     30,  -13,    3, 21, 44,  2 },
    {     31,  -14,    3, 21, 44,  2 }, {     32,  -15,    3, 21, 44,  2 }, {     32,  -16,    3, 21, 44,  2 }, {     33,  -17,    3, 21, 44,  2 }, {     34,  -18,    3, 20, 44,  2 },
    {     35,  -19,    3, 20, 44,  2 }, {     35,  -20,    3, 20, 44,  2 }, {     36,  -21,    3, 20, 44,  2 }, {     37,  -22,    3, 20, 44,  2 }, {     38,  -23,    3, 20, 44,  2 },
    {     39,  -24,    3, 20, 44,  2 }, {     39,  -25,    4, 20, 44,  2 }, {     40,  -26,    4, 20, 44,  2 }, {     41,  -27,    4, 20, 44,  2 }, {     42,  -28,    4, 20, 44,  2 },
    {     43,  -29,    4, 20, 44,  2 }, {     44,  -29,    4, 20, 44,  2 }, {     45,  -30,    4, 19, 44,  2 }, {     46,  -31,    4, 19, 44,  2 }, {     47,  -32,    4, 19, 44,  2 },
    {     48,  -32,    4, 19, 44,  2 }, {     49,  -33,    4, 19, 44,  2 }, {     50,  -34,    4, 19, 44,  2 }, {     51,  -34,    4, 19, 44,  2 }, {     52,  -35,    4, 19, 44,  2 },
    {     53,  -36,    5, 19, 44,  2 }, {     54,  -36,    5, 19, 44,  2 }, {     55,  -37,    5, 19, 44,  2 }, {     56,  -38,    5, 19, 44,  2 }, {     57,  -38,    5, 19, 44,  2 },
    {     58,  -39,    5, 18, 44,  2 }, {     59,  -39,    5, 18, 44,  2 }, {     60,  -40,    5, 18, 44,  2 }, {     61,  -40,    5, 18, 44,  2 }, {     62,  -41,    5, 18, 44,  2 },
    {     63,  -41,    5, 18, 44,  2 }, {     64,  -42,    5, 18, 44,  2 }, {     65,  -42,    5, 18, 44,  2 }, {     66,  -43,    5, 18, 44,  2 }, {     67,  -43,    6, 18, 44,  2 },
    {     68,  -43,    6, 18, 44,  2 }, {     69,  -44,    6, 18, 44,  2 }, {     70,  -44,    6, 18, 44,  2 }, {     71,  -44,    6, 18, 44,  2 }, {     72,  -45,    6, 17, 44,  2 },
    {     73,  -45,    6, 17, 44,  2 }, {     74,  -45,    6, 17, 44,  2 }, {     75,  -45,    6, 17, 44,  2 }, {     76,  -46,    6, 17, 44,  2 }, {     77,  -46,    6, 17, 44,  2 },
    {     78,  -46,    6, 17, 44,  2 }, {     79,  -46,    6, 17, 44,  2 }, {     80,  -46,    6, 17, 44,  2 }, {     81,  -47,    7, 17, 44,  2 }, {     82,  -47,    7, 17, 44,  2 },
    {     83,  -47,    7, 17, 44,  2 }, {     84,  -47,    7, 17, 44,  2 }, {     85,  -47,    7, 17, 44,  2 }, {     86,  -47,    7, 17, 44,  2 }, {     87,  -48,    7, 17, 44,  2 },
    {     88,  -48,    7, 16, 44,  2 }, {     89,  -48,    7, 16, 44,  2 }, {     90,  -48,    7, 16, 44,  2 }, {     91,  -48,    7, 16, 44,  2 }, {     92,  -48,    7, 16, 44,  2 },
    {     93,  -48,    7, 16, 44,  2 }, {     94,  -48,    7, 16, 44,  2 }, {     95,  -48,    8, 16, 44,  2 }, {     96,  -48,    8, 16, 44,  2 }, {     97,  -48,    8, 16, 44,  2 },
    {     98,  -48,    8, 16, 44,  2 }, {     99,  -48,    8, 16, 44,  2 }, {    100,  -48,    8, 16, 44,  2 }, {    101,  -48,    8, 16, 44,  2 }, {    102,  -48,    8, 16, 44,  2 },
    {    103,  -48,    8, 16, 44,  2 }, {    104,  -48,    8, 15, 44,  2 }, {    105,  -47,    8, 15, 44,  2 }, {    106,  -47,    8, 15, 44,  2 }, {    107,  -47,    8, 15, 44,  2 },
    {    108,  -47,    8, 15, 44,  2 }, {    109,  -47,    8, 15, 44,  2 }, {    110,  -47,    8, 15, 44,  2 }, {    111,  -46,    9, 15, 44,  2 }, {    112,  -46,    9, 15, 44,  2 },
    {    113,  -46,    9, 15, 44,  2 }, {    114,  -46,    9, 15, 44,  2 }, {    115,  -46,    9, 15, 44,  2 }, {    116,  -45,    9, 15, 44,  2 }, {    117,  -45,    9, 15, 44,  2 },
    {    118,  -45,    9, 14, 44,  2 }, {    119,  -45,    9, 14, 44,  2 }, {    120,  -44,    9, 14, 44,  2 }, {    121,  -44,    9, 14, 44,  2 }, {    122,  -44,    9, 14, 44,  2 },
    {    123,  -43,    9, 14, 44,  2 }, {    124,  -43,    9, 14, 44,  2 }, {    125,  -43,   10, 14, 44,  2 }, {    126,  -42,   10, 14, 44,  2 }, {    127,  -42,   10, 14, 44,  2 },
    {    128,  -41,   10, 14, 44,  2 }, {    129,  -41,   10, 14, 44,  2 }, {    130,  -40,   10, 14, 44,  2 }, {    131,  -40,   10, 14, 44,  2 }, {    132,  -39,   10, 14, 44,  2 },
    {    133,  -39,   10, 13, 44,  2 }, {    134,  -38,   10, 13, 44,  2 }, {    135,  -38,   10, 13, 44,  2 }, {    136,  -37,   10, 13, 44,  2 }, {    137,  -36,   10, 13, 44,  2 },
    {    138,  -36,   10, 13, 44,  2 }, {    139,  -35,   11, 13, 44,  2 }, {    140,  -34,   11, 13, 44,  2 }, {    141,  -34,   11, 13, 44,  2 }, {    142,  -33,   11, 13, 44,  2 },
    {    143,  -32,   11, 13, 44,  2 }, {    144,  -32,   11, 13, 44,  2 }, {    145,  -31,   11, 13, 44,  2 }, {    146,  -30,   11, 12, 44,  2 }, {    147,  -29,   11, 12, 44,  2 },
    {    148,  -29,   11, 12, 44,  2 }, {    149,  -28,   11, 12, 44,  2 }, {    150,  -27,   11, 12, 44,  2 }, {    151,  -26,   11, 12, 44,  2 }, {    152,  -25,   11, 12, 44,  2 },
    {    153,  -25,   12, 12, 44,  2 }, {    154,  -24,   12, 12, 44,  2 }, {    155,  -23,   12, 12, 44,  2 }, {    156,  -22,   12, 12, 44,  2 }, {    157,  -21,   12, 12, 44,  2 },
    {    157,  -20,   12, 12, 44,  2 }, {    158,  -19,   12, 11, 44,  2 }, {    159,  -18,   12, 11, 44,  2 }, {    160,  -17,   12, 11, 44,  2 }, {    160,  -16,   12, 11, 44,  2 },
    {    161,  -15,   12, 11, 44,  2 }, {    162,  -14,   12, 11, 44,  2 }, {    162,  -13,   12, 11, 44,  2 }, {    163,  -12,   12, 11, 44,  2 }, {    164,  -11,   12, 11, 44,  2 },
    {    164,  -10,   13, 11, 44,  2 }, {    165,   -9,   13, 11, 44,  2 }, {    166,   -8,   13, 11, 44,  2 }, {    166,   -7,   13, 11, 44,  2 }, {    167,   -6,   13, 10, 44,  2 },
    {    167,   -5,   13, 10, 44,  2 }, {    168,   -4,   13, 10, 44,  2 }, {    168,   -3,   13, 10, 44,  2 }, {    169,   -2,   13, 10, 44,  2 }, {    169,   -1,   13, 10, 44,  2 },
    {    170,    0,   13, 10, 44,  2 }, {    170,    1,   13, 10, 44,  2 }, {    171,    2,   13, 10, 44,  2 }, {    171,    3,   13, 10, 44,  2 }, {    171,    4,   14, 10, 44,  2 },
    {    172,    5,   14, 10, 44,  2 }, {    172,    6,   14, 10, 44,  2 }, {    172,    7,   14, 10, 44,  2 }, {    173,    8,   14,  9, 44,  2 }, {    173,    9,   14,  9, 44,  2 },
    {    173,   10,   14,  9, 44,  2 }, {    173,   11,   14,  9, 44,  2 }, {    174,   12,   14,  9, 44,  2 }, {    174,   13,   14,  9, 44,  2 }, {    174,   14,   14,  9, 44,  2 },
    {    174,   15,   14,  9, 44,  2 }, {    174,   16,   14,  9, 44,  2 }, {    175,   17,   14,  9, 44,  2 }, {    175,   18,   15,  9, 44,  2 }, {    175,   19,   15,  9, 44,  2 },
    {    175,   20,   15,  9, 44,  2 }, {    175,   21,   15,  9, 44,  2 }, {    175,   22,   15,  9, 44,  2 }, {    176,   23,   15,  9, 44,  2 }, {    176,   24,   15,  8, 44,  2 },
    {    176,   25,   15,  8, 44,  2 }, {    176,   26,   15,  8, 44,  2 }, {    176,   27,   15,  8, 44,  2 }, {    176,   28,   15,  8, 44,  2 }, {    176,   29,   15,  8, 44,  2 },
    {    176,   30,   15,  8, 44,  2 }, {    176,   31,   15,  8, 44,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F2C3A, {
    {     31,   16,    0,  0, 44,  4 }, {     30,   16,    0,  0, 44,  4 }, {     29,   16,    0,  0, 44,  4 }, {     28,   16,    0,  0, 44,  4 }, {     27,   16,    0,  0, 44,  4 },
    {     26,   16,    0,  0, 44,  4 }, {     25,   16,    0,  0, 44,  4 }, {     24,   16,    0,  1, 44,  4 }, {     23,   17,    0,  1, 44,  4 }, {     22,   17,    0,  1, 44,  4 },
    {     21,   17,    0,  1, 44,  4 }, {     20,   17,    0,  1, 44,  4 }, {     19,   17,    0,  1, 44,  4 }, {     18,   17,    0,  1, 44,  4 }, {     17,   18,    1,  1, 44,  4 },
    {     16,   18,    1,  1, 44,  4 }, {     15,   18,    1,  1, 44,  4 }, {     14,   18,    1,  1, 44,  4 }, {     13,   18,    1,  1, 44,  4 }, {     12,   19,    1,  1, 44,  4 },
    {     11,   19,    1,  1, 44,  4 }, {     10,   19,    1,  2, 44,  4 }, {      9,   19,    1,  2, 44,  4 }, {      8,   20,    1,  2, 44,  4 }, {      7,   20,    1,  2, 44,  4 },
    {      6,   20,    1,  2, 44,  4 }, {      5,   21,    1,  2, 44,  4 }, {      4,   21,    1,  2, 44,  4 }, {      3,   21,    2,  2, 44,  4 }, {      2,   22,    2,  2, 44,  4 },
    {      1,   22,    2,  2, 44,  4 }, {      0,   23,    2,  2, 44,  4 }, {     -1,   23,    2,  2, 44,  4 }, {     -2,   24,    2,  2, 44,  4 }, {     -3,   24,    2,  2, 44,  4 },
    {     -4,   25,    2,  2, 44,  4 }, {     -5,   25,    2,  3, 44,  4 }, {     -6,   26,    2,  3, 44,  4 }, {     -7,   26,    2,  3, 44,  4 }, {     -8,   27,    2,  3, 44,  4 },
    {     -9,   28,    2,  3, 44,  4 }, {    -10,   28,    2,  3, 44,  4 }, {    -11,   29,    3,  3, 44,  4 }, {    -12,   30,    3,  3, 44,  4 }, {    -13,   30,    3,  3, 44,  4 },
    {    -14,   31,    3,  3, 44,  4 }, {    -15,   32,    3,  3, 44,  4 }, {    -16,   32,    3,  3, 44,  4 }, {    -17,   33,    3,  3, 44,  4 }, {    -18,   34,    3,  4, 44,  4 },
    {    -19,   35,    3,  4, 44,  4 }, {    -20,   35,    3,  4, 44,  4 }, {    -21,   36,    3,  4, 44,  4 }, {    -22,   37,    3,  4, 44,  4 }, {    -23,   38,    3,  4, 44,  4 },
    {    -24,   39,    3,  4, 44,  4 }, {    -25,   39,    4,  4, 44,  4 }, {    -26,   40,    4,  4, 44,  4 }, {    -27,   41,    4,  4, 44,  4 }, {    -28,   42,    4,  4, 44,  4 },
    {    -29,   43,    4,  4, 44,  4 }, {    -29,   44,    4,  4, 44,  4 }, {    -30,   45,    4,  5, 44,  4 }, {    -31,   46,    4,  5, 44,  4 }, {    -32,   47,    4,  5, 44,  4 },
    {    -32,   48,    4,  5, 44,  4 }, {    -33,   49,    4,  5, 44,  4 }, {    -34,   50,    4,  5, 44,  4 }, {    -34,   51,    4,  5, 44,  4 }, {    -35,   52,    4,  5, 44,  4 },
    {    -36,   53,    5,  5, 44,  4 }, {    -36,   54,    5,  5, 44,  4 }, {    -37,   55,    5,  5, 44,  4 }, {    -38,   56,    5,  5, 44,  4 }, {    -38,   57,    5,  5, 44,  4 },
    {    -39,   58,    5,  6, 44,  4 }, {    -39,   59,    5,  6, 44,  4 }, {    -40,   60,    5,  6, 44,  4 }, {    -40,   61,    5,  6, 44,  4 }, {    -41,   62,    5,  6, 44,  4 },
    {    -41,   63,    5,  6, 44,  4 }, {    -42,   64,    5,  6, 44,  4 }, {    -42,   65,    5,  6, 44,  4 }, {    -43,   66,    5,  6, 44,  4 }, {    -43,   67,    6,  6, 44,  4 },
    {    -43,   68,    6,  6, 44,  4 }, {    -44,   69,    6,  6, 44,  4 }, {    -44,   70,    6,  6, 44,  4 }, {    -44,   71,    6,  6, 44,  4 }, {    -45,   72,    6,  7, 44,  4 },
    {    -45,   73,    6,  7, 44,  4 }, {    -45,   74,    6,  7, 44,  4 }, {    -45,   75,    6,  7, 44,  4 }, {    -46,   76,    6,  7, 44,  4 }, {    -46,   77,    6,  7, 44,  4 },
    {    -46,   78,    6,  7, 44,  4 }, {    -46,   79,    6,  7, 44,  4 }, {    -46,   80,    6,  7, 44,  4 }, {    -47,   81,    7,  7, 44,  4 }, {    -47,   82,    7,  7, 44,  4 },
    {    -47,   83,    7,  7, 44,  4 }, {    -47,   84,    7,  7, 44,  4 }, {    -47,   85,    7,  7, 44,  4 }, {    -47,   86,    7,  7, 44,  4 }, {    -48,   87,    7,  7, 44,  4 },
    {    -48,   88,    7,  8, 44,  4 }, {    -48,   89,    7,  8, 44,  4 }, {    -48,   90,    7,  8, 44,  4 }, {    -48,   91,    7,  8, 44,  4 }, {    -48,   92,    7,  8, 44,  4 },
    {    -48,   93,    7,  8, 44,  4 }, {    -48,   94,    7,  8, 44,  4 }, {    -48,   95,    8,  8, 44,  4 }, {    -48,   96,    8,  8, 44,  4 }, {    -48,   97,    8,  8, 44,  4 },
    {    -48,   98,    8,  8, 44,  4 }, {    -48,   99,    8,  8, 44,  4 }, {    -48,  100,    8,  8, 44,  4 }, {    -48,  101,    8,  8, 44,  4 }, {    -48,  102,    8,  8, 44,  4 },
    {    -48,  103,    8,  8, 44,  4 }, {    -48,  104,    8,  9, 44,  4 }, {    -47,  105,    8,  9, 44,  4 }, {    -47,  106,    8,  9, 44,  4 }, {    -47,  107,    8,  9, 44,  4 },
    {    -47,  108,    8,  9, 44,  4 }, {    -47,  109,    8,  9, 44,  4 }, {    -47,  110,    8,  9, 44,  4 }, {    -46,  111,    9,  9, 44,  4 }, {    -46,  112,    9,  9, 44,  4 },
    {    -46,  113,    9,  9, 44,  4 }, {    -46,  114,    9,  9, 44,  4 }, {    -46,  115,    9,  9, 44,  4 }, {    -45,  116,    9,  9, 44,  4 }, {    -45,  117,    9,  9, 44,  4 },
    {    -45,  118,    9, 10, 44,  4 }, {    -45,  119,    9, 10, 44,  4 }, {    -44,  120,    9, 10, 44,  4 }, {    -44,  121,    9, 10, 44,  4 }, {    -44,  122,    9, 10, 44,  4 },
    {    -43,  123,    9, 10, 44,  4 }, {    -43,  124,    9, 10, 44,  4 }, {    -43,  125,   10, 10, 44,  4 }, {    -42,  126,   10, 10, 44,  4 }, {    -42,  127,   10, 10, 44,  4 },
    {    -41,  128,   10, 10, 44,  4 }, {    -41,  129,   10, 10, 44,  4 }, {    -40,  130,   10, 10, 44,  4 }, {    -40,  131,   10, 10, 44,  4 }, {    -39,  132,   10, 10, 44,  4 },
    {    -39,  133,   10, 11, 44,  4 }, {    -38,  134,   10, 11, 44,  4 }, {    -38,  135,   10, 11, 44,  4 }, {    -37,  136,   10, 11, 44,  4 }, {    -36,  137,   10, 11, 44,  4 },
    {    -36,  138,   10, 11, 44,  4 }, {    -35,  139,   11, 11, 44,  4 }, {    -34,  140,   11, 11, 44,  4 }, {    -34,  141,   11, 11, 44,  4 }, {    -33,  142,   11, 11, 44,  4 },
    {    -32,  143,   11, 11, 44,  4 }, {    -32,  144,   11, 11, 44,  4 }, {    -31,  145,   11, 11, 44,  4 }, {    -30,  146,   11, 12, 44,  4 }, {    -29,  147,   11, 12, 44,  4 },
    {    -29,  148,   11, 12, 44,  4 }, {    -28,  149,   11, 12, 44,  4 }, {    -27,  150,   11, 12, 44,  4 }, {    -26,  151,   11, 12, 44,  4 }, {    -25,  152,   11, 12, 44,  4 },
    {    -25,  153,   12, 12, 44,  4 }, {    -24,  154,   12, 12, 44,  4 }, {    -23,  155,   12, 12, 44,  4 }, {    -22,  156,   12, 12, 44,  4 }, {    -21,  157,   12, 12, 44,  4 },
    {    -20,  157,   12, 12, 44,  4 }, {    -19,  158,   12, 13, 44,  4 }, {    -18,  159,   12, 13, 44,  4 }, {    -17,  160,   12, 13, 44,  4 }, {    -16,  160,   12, 13, 44,  4 },
    {    -15,  161,   12, 13, 44,  4 }, {    -14,  162,   12, 13, 44,  4 }, {    -13,  162,   12, 13, 44,  4 }, {    -12,  163,   12, 13, 44,  4 }, {    -11,  164,   12, 13, 44,  4 },
    {    -10,  164,   13, 13, 44,  4 }, {     -9,  165,   13, 13, 44,  4 }, {     -8,  166,   13, 13, 44,  4 }, {     -7,  166,   13, 13, 44,  4 }, {     -6,  167,   13, 14, 44,  4 },
    {     -5,  167,   13, 14, 44,  4 }, {     -4,  168,   13, 14, 44,  4 }, {     -3,  168,   13, 14, 44,  4 }, {     -2,  169,   13, 14, 44,  4 }, {     -1,  169,   13, 14, 44,  4 },
    {      0,  170,   13, 14, 44,  4 }, {      1,  170,   13, 14, 44,  4 }, {      2,  171,   13, 14, 44,  4 }, {      3,  171,   13, 14, 44,  4 }, {      4,  171,   14, 14, 44,  4 },
    {      5,  172,   14, 14, 44,  4 }, {      6,  172,   14, 14, 44,  4 }, {      7,  172,   14, 14, 44,  4 }, {      8,  173,   14, 15, 44,  4 }, {      9,  173,   14, 15, 44,  4 },
    {     10,  173,   14, 15, 44,  4 }, {     11,  173,   14, 15, 44,  4 }, {     12,  174,   14, 15, 44,  4 }, {     13,  174,   14, 15, 44,  4 }, {     14,  174,   14, 15, 44,  4 },
    {     15,  174,   14, 15, 44,  4 }, {     16,  174,   14, 15, 44,  4 }, {     17,  175,   14, 15, 44,  4 }, {     18,  175,   15, 15, 44,  4 }, {     19,  175,   15, 15, 44,  4 },
    {     20,  175,   15, 15, 44,  4 }, {     21,  175,   15, 15, 44,  4 }, {     22,  175,   15, 15, 44,  4 }, {     23,  176,   15, 15, 44,  4 }, {     24,  176,   15, 16, 44,  4 },
    {     25,  176,   15, 16, 44,  4 }, {     26,  176,   15, 16, 44,  4 }, {     27,  176,   15, 16, 44,  4 }, {     28,  176,   15, 16, 44,  4 }, {     29,  176,   15, 16, 44,  4 },
    {     30,  176,   15, 16, 44,  4 }, {     31,  176,   15, 16, 44,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F3437, {
    {     16,    0,    0,  8, 44,  4 }, {     16,    1,    0,  8, 44,  4 }, {     16,    2,    0,  8, 44,  4 }, {     16,    3,    0,  8, 44,  4 }, {     16,    4,    0,  8, 44,  4 },
    {     16,    5,    0,  8, 44,  4 }, {     16,    6,    0,  8, 44,  4 }, {     16,    7,    0,  8, 44,  4 }, {     16,    8,    0,  9, 44,  4 }, {     17,    9,    0,  9, 44,  4 },
    {     17,   10,    0,  9, 44,  4 }, {     17,   11,    0,  9, 44,  4 }, {     17,   12,    0,  9, 44,  4 }, {     17,   13,    0,  9, 44,  4 }, {     17,   14,    0,  9, 44,  4 },
    {     18,   15,    1,  9, 44,  4 }, {     18,   16,    1,  9, 44,  4 }, {     18,   17,    1,  9, 44,  4 }, {     18,   18,    1,  9, 44,  4 }, {     18,   19,    1,  9, 44,  4 },
    {     19,   20,    1,  9, 44,  4 }, {     19,   21,    1,  9, 44,  4 }, {     19,   22,    1, 10, 44,  4 }, {     19,   23,    1, 10, 44,  4 }, {     20,   24,    1, 10, 44,  4 },
    {     20,   25,    1, 10, 44,  4 }, {     20,   26,    1, 10, 44,  4 }, {     21,   27,    1, 10, 44,  4 }, {     21,   28,    1, 10, 44,  4 }, {     21,   29,    2, 10, 44,  4 },
    {     22,   30,    2, 10, 44,  4 }, {     22,   31,    2, 10, 44,  4 }, {     23,   32,    2, 10, 44,  4 }, {     23,   33,    2, 10, 44,  4 }, {     24,   34,    2, 10, 44,  4 },
    {     24,   35,    2, 10, 44,  4 }, {     25,   36,    2, 10, 44,  4 }, {     25,   37,    2, 11, 44,  4 }, {     26,   38,    2, 11, 44,  4 }, {     26,   39,    2, 11, 44,  4 },
    {     27,   40,    2, 11, 44,  4 }, {     28,   41,    2, 11, 44,  4 }, {     28,   42,    2, 11, 44,  4 }, {     29,   43,    3, 11, 44,  4 }, {     30,   44,    3, 11, 44,  4 },
    {     30,   45,    3, 11, 44,  4 }, {     31,   46,    3, 11, 44,  4 }, {     32,   47,    3, 11, 44,  4 }, {     32,   48,    3, 11, 44,  4 }, {     33,   49,    3, 11, 44,  4 },
    {     34,   50,    3, 12, 44,  4 }, {     35,   51,    3, 12, 44,  4 }, {     35,   52,    3, 12, 44,  4 }, {     36,   53,    3, 12, 44,  4 }, {     37,   54,    3, 12, 44,  4 },
    {     38,   55,    3, 12, 44,  4 }, {     39,   56,    3, 12, 44,  4 }, {     39,   57,    4, 12, 44,  4 }, {     40,   58,    4, 12, 44,  4 }, {     41,   59,    4, 12, 44,  4 },
    {     42,   60,    4, 12, 44,  4 }, {     43,   61,    4, 12, 44,  4 }, {     44,   61,    4, 12, 44,  4 }, {     45,   62,    4, 13, 44,  4 }, {     46,   63,    4, 13, 44,  4 },
    {     47,   64,    4, 13, 44,  4 }, {     48,   64,    4, 13, 44,  4 }, {     49,   65,    4, 13, 44,  4 }, {     50,   66,    4, 13, 44,  4 }, {     51,   66,    4, 13, 44,  4 },
    {     52,   67,    4, 13, 44,  4 }, {     53,   68,    4, 13, 44,  4 }, {     54,   68,    5, 13, 44,  4 }, {     55,   69,    5, 13, 44,  4 }, {     56,   70,    5, 13, 44,  4 },
    {     57,   70,    5, 13, 44,  4 }, {     58,   71,    5, 14, 44,  4 }, {     59,   71,    5, 14, 44,  4 }, {     60,   72,    5, 14, 44,  4 }, {     61,   72,    5, 14, 44,  4 },
    {     62,   73,    5, 14, 44,  4 }, {     63,   73,    5, 14, 44,  4 }, {     64,   74,    5, 14, 44,  4 }, {     65,   74,    5, 14, 44,  4 }, {     66,   75,    5, 14, 44,  4 },
    {     67,   75,    5, 14, 44,  4 }, {     68,   75,    6, 14, 44,  4 }, {     69,   76,    6, 14, 44,  4 }, {     70,   76,    6, 14, 44,  4 }, {     71,   76,    6, 14, 44,  4 },
    {     72,   77,    6, 15, 44,  4 }, {     73,   77,    6, 15, 44,  4 }, {     74,   77,    6, 15, 44,  4 }, {     75,   77,    6, 15, 44,  4 }, {     76,   78,    6, 15, 44,  4 },
    {     77,   78,    6, 15, 44,  4 }, {     78,   78,    6, 15, 44,  4 }, {     79,   78,    6, 15, 44,  4 }, {     80,   78,    6, 15, 44,  4 }, {     81,   79,    6, 15, 44,  4 },
    {     82,   79,    7, 15, 44,  4 }, {     83,   79,    7, 15, 44,  4 }, {     84,   79,    7, 15, 44,  4 }, {     85,   79,    7, 15, 44,  4 }, {     86,   79,    7, 15, 44,  4 },
    {     87,   80,    7, 15, 44,  4 }, {     88,   80,    7, 16, 44,  4 }, {     89,   80,    7, 16, 44,  4 }, {     90,   80,    7, 16, 44,  4 }, {     91,   80,    7, 16, 44,  4 },
    {     92,   80,    7, 16, 44,  4 }, {     93,   80,    7, 16, 44,  4 }, {     94,   80,    7, 16, 44,  4 }, {     95,   80,    7, 16, 44,  4 }, {     96,   80,    8, 16, 44,  4 },
    {     97,   80,    8, 16, 44,  4 }, {     98,   80,    8, 16, 44,  4 }, {     99,   80,    8, 16, 44,  4 }, {    100,   80,    8, 16, 44,  4 }, {    101,   80,    8, 16, 44,  4 },
    {    102,   80,    8, 16, 44,  4 }, {    103,   80,    8, 16, 44,  4 }, {    104,   80,    8, 17, 44,  4 }, {    105,   79,    8, 17, 44,  4 }, {    106,   79,    8, 17, 44,  4 },
    {    107,   79,    8, 17, 44,  4 }, {    108,   79,    8, 17, 44,  4 }, {    109,   79,    8, 17, 44,  4 }, {    110,   79,    8, 17, 44,  4 }, {    111,   78,    9, 17, 44,  4 },
    {    112,   78,    9, 17, 44,  4 }, {    113,   78,    9, 17, 44,  4 }, {    114,   78,    9, 17, 44,  4 }, {    115,   78,    9, 17, 44,  4 }, {    116,   77,    9, 17, 44,  4 },
    {    117,   77,    9, 17, 44,  4 }, {    118,   77,    9, 18, 44,  4 }, {    119,   77,    9, 18, 44,  4 }, {    120,   76,    9, 18, 44,  4 }, {    121,   76,    9, 18, 44,  4 },
    {    122,   76,    9, 18, 44,  4 }, {    123,   75,    9, 18, 44,  4 }, {    124,   75,    9, 18, 44,  4 }, {    125,   75,   10, 18, 44,  4 }, {    126,   74,   10, 18, 44,  4 },
    {    127,   74,   10, 18, 44,  4 }, {    128,   73,   10, 18, 44,  4 }, {    129,   73,   10, 18, 44,  4 }, {    130,   72,   10, 18, 44,  4 }, {    131,   72,   10, 18, 44,  4 },
    {    132,   71,   10, 18, 44,  4 }, {    133,   71,   10, 19, 44,  4 }, {    134,   70,   10, 19, 44,  4 }, {    135,   70,   10, 19, 44,  4 }, {    136,   69,   10, 19, 44,  4 },
    {    137,   68,   10, 19, 44,  4 }, {    138,   68,   10, 19, 44,  4 }, {    139,   67,   10, 19, 44,  4 }, {    140,   66,   11, 19, 44,  4 }, {    141,   66,   11, 19, 44,  4 },
    {    142,   65,   11, 19, 44,  4 }, {    143,   64,   11, 19, 44,  4 }, {    144,   64,   11, 19, 44,  4 }, {    145,   63,   11, 19, 44,  4 }, {    146,   62,   11, 20, 44,  4 },
    {    147,   61,   11, 20, 44,  4 }, {    148,   61,   11, 20, 44,  4 }, {    149,   60,   11, 20, 44,  4 }, {    150,   59,   11, 20, 44,  4 }, {    151,   58,   11, 20, 44,  4 },
    {    152,   57,   11, 20, 44,  4 }, {    153,   57,   11, 20, 44,  4 }, {    154,   56,   12, 20, 44,  4 }, {    155,   55,   12, 20, 44,  4 }, {    156,   54,   12, 20, 44,  4 },
    {    157,   53,   12, 20, 44,  4 }, {    157,   52,   12, 20, 44,  4 }, {    158,   51,   12, 21, 44,  4 }, {    159,   50,   12, 21, 44,  4 }, {    160,   49,   12, 21, 44,  4 },
    {    160,   48,   12, 21, 44,  4 }, {    161,   47,   12, 21, 44,  4 }, {    162,   46,   12, 21, 44,  4 }, {    162,   45,   12, 21, 44,  4 }, {    163,   44,   12, 21, 44,  4 },
    {    164,   43,   12, 21, 44,  4 }, {    164,   42,   13, 21, 44,  4 }, {    165,   41,   13, 21, 44,  4 }, {    166,   40,   13, 21, 44,  4 }, {    166,   39,   13, 21, 44,  4 },
    {    167,   38,   13, 22, 44,  4 }, {    167,   37,   13, 22, 44,  4 }, {    168,   36,   13, 22, 44,  4 }, {    168,   35,   13, 22, 44,  4 }, {    169,   34,   13, 22, 44,  4 },
    {    169,   33,   13, 22, 44,  4 }, {    170,   32,   13, 22, 44,  4 }, {    170,   31,   13, 22, 44,  4 }, {    171,   30,   13, 22, 44,  4 }, {    171,   29,   13, 22, 44,  4 },
    {    171,   28,   13, 22, 44,  4 }, {    172,   27,   14, 22, 44,  4 }, {    172,   26,   14, 22, 44,  4 }, {    172,   25,   14, 22, 44,  4 }, {    173,   24,   14, 23, 44,  4 },
    {    173,   23,   14, 23, 44,  4 }, {    173,   22,   14, 23, 44,  4 }, {    173,   21,   14, 23, 44,  4 }, {    174,   20,   14, 23, 44,  4 }, {    174,   19,   14, 23, 44,  4 },
    {    174,   18,   14, 23, 44,  4 }, {    174,   17,   14, 23, 44,  4 }, {    174,   16,   14, 23, 44,  4 }, {    175,   15,   14, 23, 44,  4 }, {    175,   14,   14, 23, 44,  4 },
    {    175,   13,   15, 23, 44,  4 }, {    175,   12,   15, 23, 44,  4 }, {    175,   11,   15, 23, 44,  4 }, {    175,   10,   15, 23, 44,  4 }, {    176,    9,   15, 23, 44,  4 },
    {    176,    8,   15, 24, 44,  4 }, {    176,    7,   15, 24, 44,  4 }, {    176,    6,   15, 24, 44,  4 }, {    176,    5,   15, 24, 44,  4 }, {    176,    4,   15, 24, 44,  4 },
    {    176,    3,   15, 24, 44,  4 }, {    176,    2,   15, 24, 44,  4 }, {    176,    1,   15, 24, 44,  4 }, {    176,    0,   15, 24, 44,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F3C46, {
    {      0,   16,    0, 16, 44,  4 }, {      1,   16,    0, 16, 44,  4 }, {      2,   16,    0, 16, 44,  4 }, {      3,   16,    0, 16, 44,  4 }, {      4,   16,    0, 16, 44,  4 },
    {      5,   16,    0, 16, 44,  4 }, {      6,   16,    0, 16, 44,  4 }, {      7,   16,    0, 16, 44,  4 }, {      8,   16,    0, 17, 44,  4 }, {      9,   15,    0, 17, 44,  4 },
    {     10,   15,    0, 17, 44,  4 }, {     11,   15,    0, 17, 44,  4 }, {     12,   15,    0, 17, 44,  4 }, {     13,   15,    0, 17, 44,  4 }, {     14,   15,    0, 17, 44,  4 },
    {     15,   14,    1, 17, 44,  4 }, {     16,   14,    1, 17, 44,  4 }, {     17,   14,    1, 17, 44,  4 }, {     18,   14,    1, 17, 44,  4 }, {     19,   14,    1, 17, 44,  4 },
    {     20,   13,    1, 17, 44,  4 }, {     21,   13,    1, 17, 44,  4 }, {     22,   13,    1, 18, 44,  4 }, {     23,   13,    1, 18, 44,  4 }, {     24,   12,    1, 18, 44,  4 },
    {     25,   12,    1, 18, 44,  4 }, {     26,   12,    1, 18, 44,  4 }, {     27,   11,    1, 18, 44,  4 }, {     28,   11,    1, 18, 44,  4 }, {     29,   11,    2, 18, 44,  4 },
    {     30,   10,    2, 18, 44,  4 }, {     31,   10,    2, 18, 44,  4 }, {     32,    9,    2, 18, 44,  4 }, {     33,    9,    2, 18, 44,  4 }, {     34,    8,    2, 18, 44,  4 },
    {     35,    8,    2, 18, 44,  4 }, {     36,    7,    2, 18, 44,  4 }, {     37,    7,    2, 19, 44,  4 }, {     38,    6,    2, 19, 44,  4 }, {     39,    6,    2, 19, 44,  4 },
    {     40,    5,    2, 19, 44,  4 }, {     41,    4,    2, 19, 44,  4 }, {     42,    4,    2, 19, 44,  4 }, {     43,    3,    2, 19, 44,  4 }, {     44,    2,    3, 19, 44,  4 },
    {     45,    2,    3, 19, 44,  4 }, {     46,    1,    3, 19, 44,  4 }, {     47,    0,    3, 19, 44,  4 }, {     48,    0,    3, 19, 44,  4 }, {     49,   -1,    3, 19, 44,  4 },
    {     50,   -2,    3, 20, 44,  4 }, {     51,   -3,    3, 20, 44,  4 }, {     52,   -3,    3, 20, 44,  4 }, {     53,   -4,    3, 20, 44,  4 }, {     54,   -5,    3, 20, 44,  4 },
    {     55,   -6,    3, 20, 44,  4 }, {     56,   -7,    3, 20, 44,  4 }, {     57,   -7,    3, 20, 44,  4 }, {     58,   -8,    4, 20, 44,  4 }, {     59,   -9,    4, 20, 44,  4 },
    {     60,  -10,    4, 20, 44,  4 }, {     61,  -11,    4, 20, 44,  4 }, {     61,  -12,    4, 20, 44,  4 }, {     62,  -13,    4, 21, 44,  4 }, {     63,  -14,    4, 21, 44,  4 },
    {     64,  -15,    4, 21, 44,  4 }, {     64,  -16,    4, 21, 44,  4 }, {     65,  -17,    4, 21, 44,  4 }, {     66,  -18,    4, 21, 44,  4 }, {     66,  -19,    4, 21, 44,  4 },
    {     67,  -20,    4, 21, 44,  4 }, {     68,  -21,    4, 21, 44,  4 }, {     68,  -22,    5, 21, 44,  4 }, {     69,  -23,    5, 21, 44,  4 }, {     70,  -24,    5, 21, 44,  4 },
    {     70,  -25,    5, 21, 44,  4 }, {     71,  -26,    5, 22, 44,  4 }, {     71,  -27,    5, 22, 44,  4 }, {     72,  -28,    5, 22, 44,  4 }, {     72,  -29,    5, 22, 44,  4 },
    {     73,  -30,    5, 22, 44,  4 }, {     73,  -31,    5, 22, 44,  4 }, {     74,  -32,    5, 22, 44,  4 }, {     74,  -33,    5, 22, 44,  4 }, {     75,  -34,    5, 22, 44,  4 },
    {     75,  -35,    5, 22, 44,  4 }, {     75,  -36,    5, 22, 44,  4 }, {     76,  -37,    6, 22, 44,  4 }, {     76,  -38,    6, 22, 44,  4 }, {     76,  -39,    6, 22, 44,  4 },
    {     77,  -40,    6, 23, 44,  4 }, {     77,  -41,    6, 23, 44,  4 }, {     77,  -42,    6, 23, 44,  4 }, {     77,  -43,    6, 23, 44,  4 }, {     78,  -44,    6, 23, 44,  4 },
    {     78,  -45,    6, 23, 44,  4 }, {     78,  -46,    6, 23, 44,  4 }, {     78,  -47,    6, 23, 44,  4 }, {     78,  -48,    6, 23, 44,  4 }, {     79,  -49,    6, 23, 44,  4 },
    {     79,  -50,    6, 23, 44,  4 }, {     79,  -51,    7, 23, 44,  4 }, {     79,  -52,    7, 23, 44,  4 }, {     79,  -53,    7, 23, 44,  4 }, {     79,  -54,    7, 23, 44,  4 },
    {     80,  -55,    7, 23, 44,  4 }, {     80,  -56,    7, 24, 44,  4 }, {     80,  -57,    7, 24, 44,  4 }, {     80,  -58,    7, 24, 44,  4 }, {     80,  -59,    7, 24, 44,  4 },
    {     80,  -60,    7, 24, 44,  4 }, {     80,  -61,    7, 24, 44,  4 }, {     80,  -62,    7, 24, 44,  4 }, {     80,  -63,    7, 24, 44,  4 }, {     80,  -64,    7, 24, 44,  4 },
    {     80,  -65,    8, 24, 44,  4 }, {     80,  -66,    8, 24, 44,  4 }, {     80,  -67,    8, 24, 44,  4 }, {     80,  -68,    8, 24, 44,  4 }, {     80,  -69,    8, 24, 44,  4 },
    {     80,  -70,    8, 24, 44,  4 }, {     80,  -71,    8, 24, 44,  4 }, {     80,  -72,    8, 25, 44,  4 }, {     79,  -73,    8, 25, 44,  4 }, {     79,  -74,    8, 25, 44,  4 },
    {     79,  -75,    8, 25, 44,  4 }, {     79,  -76,    8, 25, 44,  4 }, {     79,  -77,    8, 25, 44,  4 }, {     79,  -78,    8, 25, 44,  4 }, {     78,  -79,    9, 25, 44,  4 },
    {     78,  -80,    9, 25, 44,  4 }, {     78,  -81,    9, 25, 44,  4 }, {     78,  -82,    9, 25, 44,  4 }, {     78,  -83,    9, 25, 44,  4 }, {     77,  -84,    9, 25, 44,  4 },
    {     77,  -85,    9, 25, 44,  4 }, {     77,  -86,    9, 26, 44,  4 }, {     77,  -87,    9, 26, 44,  4 }, {     76,  -88,    9, 26, 44,  4 }, {     76,  -89,    9, 26, 44,  4 },
    {     76,  -90,    9, 26, 44,  4 }, {     75,  -91,    9, 26, 44,  4 }, {     75,  -92,    9, 26, 44,  4 }, {     75,  -93,   10, 26, 44,  4 }, {     74,  -94,   10, 26, 44,  4 },
    {     74,  -95,   10, 26, 44,  4 }, {     73,  -96,   10, 26, 44,  4 }, {     73,  -97,   10, 26, 44,  4 }, {     72,  -98,   10, 26, 44,  4 }, {     72,  -99,   10, 26, 44,  4 },
    {     71, -100,   10, 26, 44,  4 }, {     71, -101,   10, 27, 44,  4 }, {     70, -102,   10, 27, 44,  4 }, {     70, -103,   10, 27, 44,  4 }, {     69, -104,   10, 27, 44,  4 },
    {     68, -105,   10, 27, 44,  4 }, {     68, -106,   10, 27, 44,  4 }, {     67, -107,   11, 27, 44,  4 }, {     66, -108,   11, 27, 44,  4 }, {     66, -109,   11, 27, 44,  4 },
    {     65, -110,   11, 27, 44,  4 }, {     64, -111,   11, 27, 44,  4 }, {     64, -112,   11, 27, 44,  4 }, {     63, -113,   11, 27, 44,  4 }, {     62, -114,   11, 28, 44,  4 },
    {     61, -115,   11, 28, 44,  4 }, {     61, -116,   11, 28, 44,  4 }, {     60, -117,   11, 28, 44,  4 }, {     59, -118,   11, 28, 44,  4 }, {     58, -119,   11, 28, 44,  4 },
    {     57, -120,   11, 28, 44,  4 }, {     57, -121,   12, 28, 44,  4 }, {     56, -122,   12, 28, 44,  4 }, {     55, -123,   12, 28, 44,  4 }, {     54, -124,   12, 28, 44,  4 },
    {     53, -125,   12, 28, 44,  4 }, {     52, -125,   12, 28, 44,  4 }, {     51, -126,   12, 29, 44,  4 }, {     50, -127,   12, 29, 44,  4 }, {     49, -128,   12, 29, 44,  4 },
    {     48, -128,   12, 29, 44,  4 }, {     47, -129,   12, 29, 44,  4 }, {     46, -130,   12, 29, 44,  4 }, {     45, -130,   12, 29, 44,  4 }, {     44, -131,   12, 29, 44,  4 },
    {     43, -132,   12, 29, 44,  4 }, {     42, -132,   13, 29, 44,  4 }, {     41, -133,   13, 29, 44,  4 }, {     40, -134,   13, 29, 44,  4 }, {     39, -134,   13, 29, 44,  4 },
    {     38, -135,   13, 30, 44,  4 }, {     37, -135,   13, 30, 44,  4 }, {     36, -136,   13, 30, 44,  4 }, {     35, -136,   13, 30, 44,  4 }, {     34, -137,   13, 30, 44,  4 },
    {     33, -137,   13, 30, 44,  4 }, {     32, -138,   13, 30, 44,  4 }, {     31, -138,   13, 30, 44,  4 }, {     30, -139,   13, 30, 44,  4 }, {     29, -139,   13, 30, 44,  4 },
    {     28, -139,   14, 30, 44,  4 }, {     27, -140,   14, 30, 44,  4 }, {     26, -140,   14, 30, 44,  4 }, {     25, -140,   14, 30, 44,  4 }, {     24, -141,   14, 31, 44,  4 },
    {     23, -141,   14, 31, 44,  4 }, {     22, -141,   14, 31, 44,  4 }, {     21, -141,   14, 31, 44,  4 }, {     20, -142,   14, 31, 44,  4 }, {     19, -142,   14, 31, 44,  4 },
    {     18, -142,   14, 31, 44,  4 }, {     17, -142,   14, 31, 44,  4 }, {     16, -142,   14, 31, 44,  4 }, {     15, -143,   14, 31, 44,  4 }, {     14, -143,   15, 31, 44,  4 },
    {     13, -143,   15, 31, 44,  4 }, {     12, -143,   15, 31, 44,  4 }, {     11, -143,   15, 31, 44,  4 }, {     10, -143,   15, 31, 44,  4 }, {      9, -144,   15, 31, 44,  4 },
    {      8, -144,   15,  0, 44,  4 }, {      7, -144,   15,  0, 44,  4 }, {      6, -144,   15,  0, 44,  4 }, {      5, -144,   15,  0, 44,  4 }, {      4, -144,   15,  0, 44,  4 },
    {      3, -144,   15,  0, 44,  4 }, {      2, -144,   15,  0, 44,  4 }, {      1, -144,   15,  0, 44,  4 }, {      0, -144,   16,  0, 44,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F4455, {
    {     16,   31,    0, 24, 44,  4 }, {     16,   30,    0, 24, 44,  4 }, {     16,   29,    0, 24, 44,  4 }, {     16,   28,    0, 24, 44,  4 }, {     16,   27,    0, 24, 44,  4 },
    {     16,   26,    0, 24, 44,  4 }, {     16,   25,    0, 24, 44,  4 }, {     16,   24,    0, 25, 44,  4 }, {     15,   23,    0, 25, 44,  4 }, {     15,   22,    0, 25, 44,  4 },
    {     15,   21,    0, 25, 44,  4 }, {     15,   20,    0, 25, 44,  4 }, {     15,   19,    0, 25, 44,  4 }, {     15,   18,    0, 25, 44,  4 }, {     14,   17,    1, 25, 44,  4 },
    {     14,   16,    1, 25, 44,  4 }, {     14,   15,    1, 25, 44,  4 }, {     14,   14,    1, 25, 44,  4 }, {     14,   13,    1, 25, 44,  4 }, {     13,   12,    1, 25, 44,  4 },
    {     13,   11,    1, 25, 44,  4 }, {     13,   10,    1, 26, 44,  4 }, {     13,    9,    1, 26, 44,  4 }, {     12,    8,    1, 26, 44,  4 }, {     12,    7,    1, 26, 44,  4 },
    {     12,    6,    1, 26, 44,  4 }, {     11,    5,    1, 26, 44,  4 }, {     11,    4,    1, 26, 44,  4 }, {     11,    3,    2, 26, 44,  4 }, {     10,    2,    2, 26, 44,  4 },
    {     10,    1,    2, 26, 44,  4 }, {      9,    0,    2, 26, 44,  4 }, {      9,   -1,    2, 26, 44,  4 }, {      8,   -2,    2, 26, 44,  4 }, {      8,   -3,    2, 26, 44,  4 },
    {      7,   -4,    2, 26, 44,  4 }, {      7,   -5,    2, 27, 44,  4 }, {      6,   -6,    2, 27, 44,  4 }, {      6,   -7,    2, 27, 44,  4 }, {      5,   -8,    2, 27, 44,  4 },
    {      4,   -9,    2, 27, 44,  4 }, {      4,  -10,    2, 27, 44,  4 }, {      3,  -11,    3, 27, 44,  4 }, {      2,  -12,    3, 27, 44,  4 }, {      2,  -13,    3, 27, 44,  4 },
    {      1,  -14,    3, 27, 44,  4 }, {      0,  -15,    3, 27, 44,  4 }, {      0,  -16,    3, 27, 44,  4 }, {     -1,  -17,    3, 27, 44,  4 }, {     -2,  -18,    3, 28, 44,  4 },
    {     -3,  -19,    3, 28, 44,  4 }, {     -3,  -20,    3, 28, 44,  4 }, {     -4,  -21,    3, 28, 44,  4 }, {     -5,  -22,    3, 28, 44,  4 }, {     -6,  -23,    3, 28, 44,  4 },
    {     -7,  -24,    3, 28, 44,  4 }, {     -7,  -25,    4, 28, 44,  4 }, {     -8,  -26,    4, 28, 44,  4 }, {     -9,  -27,    4, 28, 44,  4 }, {    -10,  -28,    4, 28, 44,  4 },
    {    -11,  -29,    4, 28, 44,  4 }, {    -12,  -29,    4, 28, 44,  4 }, {    -13,  -30,    4, 29, 44,  4 }, {    -14,  -31,    4, 29, 44,  4 }, {    -15,  -32,    4, 29, 44,  4 },
    {    -16,  -32,    4, 29, 44,  4 }, {    -17,  -33,    4, 29, 44,  4 }, {    -18,  -34,    4, 29, 44,  4 }, {    -19,  -34,    4, 29, 44,  4 }, {    -20,  -35,    4, 29, 44,  4 },
    {    -21,  -36,    4, 29, 44,  4 }, {    -22,  -36,    5, 29, 44,  4 }, {    -23,  -37,    5, 29, 44,  4 }, {    -24,  -38,    5, 29, 44,  4 }, {    -25,  -38,    5, 29, 44,  4 },
    {    -26,  -39,    5, 30, 44,  4 }, {    -27,  -39,    5, 30, 44,  4 }, {    -28,  -40,    5, 30, 44,  4 }, {    -29,  -40,    5, 30, 44,  4 }, {    -30,  -41,    5, 30, 44,  4 },
    {    -31,  -41,    5, 30, 44,  4 }, {    -32,  -42,    5, 30, 44,  4 }, {    -33,  -42,    5, 30, 44,  4 }, {    -34,  -43,    5, 30, 44,  4 }, {    -35,  -43,    5, 30, 44,  4 },
    {    -36,  -43,    6, 30, 44,  4 }, {    -37,  -44,    6, 30, 44,  4 }, {    -38,  -44,    6, 30, 44,  4 }, {    -39,  -44,    6, 30, 44,  4 }, {    -40,  -45,    6, 31, 44,  4 },
    {    -41,  -45,    6, 31, 44,  4 }, {    -42,  -45,    6, 31, 44,  4 }, {    -43,  -45,    6, 31, 44,  4 }, {    -44,  -46,    6, 31, 44,  4 }, {    -45,  -46,    6, 31, 44,  4 },
    {    -46,  -46,    6, 31, 44,  4 }, {    -47,  -46,    6, 31, 44,  4 }, {    -48,  -46,    6, 31, 44,  4 }, {    -49,  -47,    6, 31, 44,  4 }, {    -50,  -47,    7, 31, 44,  4 },
    {    -51,  -47,    7, 31, 44,  4 }, {    -52,  -47,    7, 31, 44,  4 }, {    -53,  -47,    7, 31, 44,  4 }, {    -54,  -47,    7, 31, 44,  4 }, {    -55,  -48,    7, 31, 44,  4 },
    {    -56,  -48,    7,  0, 44,  4 }, {    -57,  -48,    7,  0, 44,  4 }, {    -58,  -48,    7,  0, 44,  4 }, {    -59,  -48,    7,  0, 44,  4 }, {    -60,  -48,    7,  0, 44,  4 },
    {    -61,  -48,    7,  0, 44,  4 }, {    -62,  -48,    7,  0, 44,  4 }, {    -63,  -48,    7,  0, 44,  4 }, {    -64,  -48,    8,  0, 44,  4 }, {    -65,  -48,    8,  0, 44,  4 },
    {    -66,  -48,    8,  0, 44,  4 }, {    -67,  -48,    8,  0, 44,  4 }, {    -68,  -48,    8,  0, 44,  4 }, {    -69,  -48,    8,  0, 44,  4 }, {    -70,  -48,    8,  0, 44,  4 },
    {    -71,  -48,    8,  0, 44,  4 }, {    -72,  -48,    8,  1, 44,  4 }, {    -73,  -47,    8,  1, 44,  4 }, {    -74,  -47,    8,  1, 44,  4 }, {    -75,  -47,    8,  1, 44,  4 },
    {    -76,  -47,    8,  1, 44,  4 }, {    -77,  -47,    8,  1, 44,  4 }, {    -78,  -47,    8,  1, 44,  4 }, {    -79,  -46,    9,  1, 44,  4 }, {    -80,  -46,    9,  1, 44,  4 },
    {    -81,  -46,    9,  1, 44,  4 }, {    -82,  -46,    9,  1, 44,  4 }, {    -83,  -46,    9,  1, 44,  4 }, {    -84,  -45,    9,  1, 44,  4 }, {    -85,  -45,    9,  1, 44,  4 },
    {    -86,  -45,    9,  2, 44,  4 }, {    -87,  -45,    9,  2, 44,  4 }, {    -88,  -44,    9,  2, 44,  4 }, {    -89,  -44,    9,  2, 44,  4 }, {    -90,  -44,    9,  2, 44,  4 },
    {    -91,  -43,    9,  2, 44,  4 }, {    -92,  -43,    9,  2, 44,  4 }, {    -93,  -43,   10,  2, 44,  4 }, {    -94,  -42,   10,  2, 44,  4 }, {    -95,  -42,   10,  2, 44,  4 },
    {    -96,  -41,   10,  2, 44,  4 }, {    -97,  -41,   10,  2, 44,  4 }, {    -98,  -40,   10,  2, 44,  4 }, {    -99,  -40,   10,  2, 44,  4 }, {   -100,  -39,   10,  2, 44,  4 },
    {   -101,  -39,   10,  3, 44,  4 }, {   -102,  -38,   10,  3, 44,  4 }, {   -103,  -38,   10,  3, 44,  4 }, {   -104,  -37,   10,  3, 44,  4 }, {   -105,  -36,   10,  3, 44,  4 },
    {   -106,  -36,   10,  3, 44,  4 }, {   -107,  -35,   11,  3, 44,  4 }, {   -108,  -34,   11,  3, 44,  4 }, {   -109,  -34,   11,  3, 44,  4 }, {   -110,  -33,   11,  3, 44,  4 },
    {   -111,  -32,   11,  3, 44,  4 }, {   -112,  -32,   11,  3, 44,  4 }, {   -113,  -31,   11,  3, 44,  4 }, {   -114,  -30,   11,  4, 44,  4 }, {   -115,  -29,   11,  4, 44,  4 },
    {   -116,  -29,   11,  4, 44,  4 }, {   -117,  -28,   11,  4, 44,  4 }, {   -118,  -27,   11,  4, 44,  4 }, {   -119,  -26,   11,  4, 44,  4 }, {   -120,  -25,   11,  4, 44,  4 },
    {   -121,  -25,   12,  4, 44,  4 }, {   -122,  -24,   12,  4, 44,  4 }, {   -123,  -23,   12,  4, 44,  4 }, {   -124,  -22,   12,  4, 44,  4 }, {   -125,  -21,   12,  4, 44,  4 },
    {   -125,  -20,   12,  4, 44,  4 }, {   -126,  -19,   12,  5, 44,  4 }, {   -127,  -18,   12,  5, 44,  4 }, {   -128,  -17,   12,  5, 44,  4 }, {   -128,  -16,   12,  5, 44,  4 },
    {   -129,  -15,   12,  5, 44,  4 }, {   -130,  -14,   12,  5, 44,  4 }, {   -130,  -13,   12,  5, 44,  4 }, {   -131,  -12,   12,  5, 44,  4 }, {   -132,  -11,   13,  5, 44,  4 },
    {   -132,  -10,   13,  5, 44,  4 }, {   -133,   -9,   13,  5, 44,  4 }, {   -134,   -8,   13,  5, 44,  4 }, {   -134,   -7,   13,  5, 44,  4 }, {   -135,   -6,   13,  6, 44,  4 },
    {   -135,   -5,   13,  6, 44,  4 }, {   -136,   -4,   13,  6, 44,  4 }, {   -136,   -3,   13,  6, 44,  4 }, {   -137,   -2,   13,  6, 44,  4 }, {   -137,   -1,   13,  6, 44,  4 },
    {   -138,    0,   13,  6, 44,  4 }, {   -138,    1,   13,  6, 44,  4 }, {   -139,    2,   13,  6, 44,  4 }, {   -139,    3,   14,  6, 44,  4 }, {   -139,    4,   14,  6, 44,  4 },
    {   -140,    5,   14,  6, 44,  4 }, {   -140,    6,   14,  6, 44,  4 }, {   -140,    7,   14,  6, 44,  4 }, {   -141,    8,   14,  7, 44,  4 }, {   -141,    9,   14,  7, 44,  4 },
    {   -141,   10,   14,  7, 44,  4 }, {   -141,   11,   14,  7, 44,  4 }, {   -142,   12,   14,  7, 44,  4 }, {   -142,   13,   14,  7, 44,  4 }, {   -142,   14,   14,  7, 44,  4 },
    {   -142,   15,   14,  7, 44,  4 }, {   -142,   16,   14,  7, 44,  4 }, {   -143,   17,   15,  7, 44,  4 }, {   -143,   18,   15,  7, 44,  4 }, {   -143,   19,   15,  7, 44,  4 },
    {   -143,   20,   15,  7, 44,  4 }, {   -143,   21,   15,  7, 44,  4 }, {   -143,   22,   15,  7, 44,  4 }, {   -144,   23,   15,  7, 44,  4 }, {   -144,   24,   15,  8, 44,  4 },
    {   -144,   25,   15,  8, 44,  4 }, {   -144,   26,   15,  8, 44,  4 }, {   -144,   27,   15,  8, 44,  4 }, {   -144,   28,   15,  8, 44,  4 }, {   -144,   29,   15,  8, 44,  4 },
    {   -144,   30,   15,  8, 44,  4 }, {   -144,   31,   16,  8, 44,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F4C52, {
    {     31,   16,    8,  0, 46,  2 }, {     30,   16,    8,  0, 46,  2 }, {     29,   16,    8,  0, 46,  2 }, {     28,   16,    8,  0, 46,  2 }, {     27,   16,    8,  0, 46,  2 },
    {     26,   16,    8,  0, 46,  2 }, {     25,   16,    8,  0, 46,  2 }, {     24,   16,    8, 31, 46,  2 }, {     23,   15,    8, 31, 46,  2 }, {     22,   15,    8, 31, 46,  2 },
    {     21,   15,    8, 31, 46,  2 }, {     20,   15,    8, 31, 46,  2 }, {     19,   15,    8, 31, 46,  2 }, {     18,   15,    8, 31, 46,  2 }, {     17,   14,    7, 31, 46,  2 },
    {     16,   14,    7, 31, 46,  2 }, {     15,   14,    7, 31, 46,  2 }, {     14,   14,    7, 31, 46,  2 }, {     13,   14,    7, 31, 46,  2 }, {     12,   13,    7, 31, 46,  2 },
    {     11,   13,    7, 31, 46,  2 }, {     10,   13,    7, 30, 46,  2 }, {      9,   13,    7, 30, 46,  2 }, {      8,   12,    7, 30, 46,  2 }, {      7,   12,    7, 30, 46,  2 },
    {      6,   12,    7, 30, 46,  2 }, {      5,   11,    7, 30, 46,  2 }, {      4,   11,    7, 30, 46,  2 }, {      3,   11,    6, 30, 46,  2 }, {      2,   10,    6, 30, 46,  2 },
    {      1,   10,    6, 30, 46,  2 }, {      0,    9,    6, 30, 46,  2 }, {     -1,    9,    6, 30, 46,  2 }, {     -2,    8,    6, 30, 46,  2 }, {     -3,    8,    6, 30, 46,  2 },
    {     -4,    7,    6, 30, 46,  2 }, {     -5,    7,    6, 29, 46,  2 }, {     -6,    6,    6, 29, 46,  2 }, {     -7,    6,    6, 29, 46,  2 }, {     -8,    5,    6, 29, 46,  2 },
    {     -9,    4,    6, 29, 46,  2 }, {    -10,    4,    6, 29, 46,  2 }, {    -11,    3,    5, 29, 46,  2 }, {    -12,    2,    5, 29, 46,  2 }, {    -13,    2,    5, 29, 46,  2 },
    {    -14,    1,    5, 29, 46,  2 }, {    -15,    0,    5, 29, 46,  2 }, {    -16,    0,    5, 29, 46,  2 }, {    -17,   -1,    5, 29, 46,  2 }, {    -18,   -2,    5, 28, 46,  2 },
    {    -19,   -3,    5, 28, 46,  2 }, {    -20,   -3,    5, 28, 46,  2 }, {    -21,   -4,    5, 28, 46,  2 }, {    -22,   -5,    5, 28, 46,  2 }, {    -23,   -6,    5, 28, 46,  2 },
    {    -24,   -7,    5, 28, 46,  2 }, {    -25,   -7,    4, 28, 46,  2 }, {    -26,   -8,    4, 28, 46,  2 }, {    -27,   -9,    4, 28, 46,  2 }, {    -28,  -10,    4, 28, 46,  2 },
    {    -29,  -11,    4, 28, 46,  2 }, {    -29,  -12,    4, 28, 46,  2 }, {    -30,  -13,    4, 27, 46,  2 }, {    -31,  -14,    4, 27, 46,  2 }, {    -32,  -15,    4, 27, 46,  2 },
    {    -32,  -16,    4, 27, 46,  2 }, {    -33,  -17,    4, 27, 46,  2 }, {    -34,  -18,    4, 27, 46,  2 }, {    -34,  -19,    4, 27, 46,  2 }, {    -35,  -20,    4, 27, 46,  2 },
    {    -36,  -21,    4, 27, 46,  2 }, {    -36,  -22,    3, 27, 46,  2 }, {    -37,  -23,    3, 27, 46,  2 }, {    -38,  -24,    3, 27, 46,  2 }, {    -38,  -25,    3, 27, 46,  2 },
    {    -39,  -26,    3, 26, 46,  2 }, {    -39,  -27,    3, 26, 46,  2 }, {    -40,  -28,    3, 26, 46,  2 }, {    -40,  -29,    3, 26, 46,  2 }, {    -41,  -30,    3, 26, 46,  2 },
    {    -41,  -31,    3, 26, 46,  2 }, {    -42,  -32,    3, 26, 46,  2 }, {    -42,  -33,    3, 26, 46,  2 }, {    -43,  -34,    3, 26, 46,  2 }, {    -43,  -35,    3, 26, 46,  2 },
    {    -43,  -36,    2, 26, 46,  2 }, {    -44,  -37,    2, 26, 46,  2 }, {    -44,  -38,    2, 26, 46,  2 }, {    -44,  -39,    2, 26, 46,  2 }, {    -45,  -40,    2, 25, 46,  2 },
    {    -45,  -41,    2, 25, 46,  2 }, {    -45,  -42,    2, 25, 46,  2 }, {    -45,  -43,    2, 25, 46,  2 }, {    -46,  -44,    2, 25, 46,  2 }, {    -46,  -45,    2, 25, 46,  2 },
    {    -46,  -46,    2, 25, 46,  2 }, {    -46,  -47,    2, 25, 46,  2 }, {    -46,  -48,    2, 25, 46,  2 }, {    -47,  -49,    2, 25, 46,  2 }, {    -47,  -50,    1, 25, 46,  2 },
    {    -47,  -51,    1, 25, 46,  2 }, {    -47,  -52,    1, 25, 46,  2 }, {    -47,  -53,    1, 25, 46,  2 }, {    -47,  -54,    1, 25, 46,  2 }, {    -48,  -55,    1, 25, 46,  2 },
    {    -48,  -56,    1, 24, 46,  2 }, {    -48,  -57,    1, 24, 46,  2 }, {    -48,  -58,    1, 24, 46,  2 }, {    -48,  -59,    1, 24, 46,  2 }, {    -48,  -60,    1, 24, 46,  2 },
    {    -48,  -61,    1, 24, 46,  2 }, {    -48,  -62,    1, 24, 46,  2 }, {    -48,  -63,    1, 24, 46,  2 }, {    -48,  -64,    0, 24, 46,  2 }, {    -48,  -65,    0, 24, 46,  2 },
    {    -48,  -66,    0, 24, 46,  2 }, {    -48,  -67,    0, 24, 46,  2 }, {    -48,  -68,    0, 24, 46,  2 }, {    -48,  -69,    0, 24, 46,  2 }, {    -48,  -70,    0, 24, 46,  2 },
    {    -48,  -71,    0, 24, 46,  2 }, {    -48,  -72,    0, 23, 46,  2 }, {    -47,  -73,    0, 23, 46,  2 }, {    -47,  -74,    0, 23, 46,  2 }, {    -47,  -75,    0, 23, 46,  2 },
    {    -47,  -76,    0, 23, 46,  2 }, {    -47,  -77,    0, 23, 46,  2 }, {    -47,  -78,    0, 23, 46,  2 }, {    -46,  -79,   -1, 23, 46,  2 }, {    -46,  -80,   -1, 23, 46,  2 },
    {    -46,  -81,   -1, 23, 46,  2 }, {    -46,  -82,   -1, 23, 46,  2 }, {    -46,  -83,   -1, 23, 46,  2 }, {    -45,  -84,   -1, 23, 46,  2 }, {    -45,  -85,   -1, 23, 46,  2 },
    {    -45,  -86,   -1, 22, 46,  2 }, {    -45,  -87,   -1, 22, 46,  2 }, {    -44,  -88,   -1, 22, 46,  2 }, {    -44,  -89,   -1, 22, 46,  2 }, {    -44,  -90,   -1, 22, 46,  2 },
    {    -43,  -91,   -1, 22, 46,  2 }, {    -43,  -92,   -1, 22, 46,  2 }, {    -43,  -93,   -2, 22, 46,  2 }, {    -42,  -94,   -2, 22, 46,  2 }, {    -42,  -95,   -2, 22, 46,  2 },
    {    -41,  -96,   -2, 22, 46,  2 }, {    -41,  -97,   -2, 22, 46,  2 }, {    -40,  -98,   -2, 22, 46,  2 }, {    -40,  -99,   -2, 22, 46,  2 }, {    -39, -100,   -2, 22, 46,  2 },
    {    -39, -101,   -2, 21, 46,  2 }, {    -38, -102,   -2, 21, 46,  2 }, {    -38, -103,   -2, 21, 46,  2 }, {    -37, -104,   -2, 21, 46,  2 }, {    -36, -105,   -2, 21, 46,  2 },
    {    -36, -106,   -2, 21, 46,  2 }, {    -35, -107,   -3, 21, 46,  2 }, {    -34, -108,   -3, 21, 46,  2 }, {    -34, -109,   -3, 21, 46,  2 }, {    -33, -110,   -3, 21, 46,  2 },
    {    -32, -111,   -3, 21, 46,  2 }, {    -32, -112,   -3, 21, 46,  2 }, {    -31, -113,   -3, 21, 46,  2 }, {    -30, -114,   -3, 20, 46,  2 }, {    -29, -115,   -3, 20, 46,  2 },
    {    -29, -116,   -3, 20, 46,  2 }, {    -28, -117,   -3, 20, 46,  2 }, {    -27, -118,   -3, 20, 46,  2 }, {    -26, -119,   -3, 20, 46,  2 }, {    -25, -120,   -3, 20, 46,  2 },
    {    -25, -121,   -4, 20, 46,  2 }, {    -24, -122,   -4, 20, 46,  2 }, {    -23, -123,   -4, 20, 46,  2 }, {    -22, -124,   -4, 20, 46,  2 }, {    -21, -125,   -4, 20, 46,  2 },
    {    -20, -125,   -4, 20, 46,  2 }, {    -19, -126,   -4, 19, 46,  2 }, {    -18, -127,   -4, 19, 46,  2 }, {    -17, -128,   -4, 19, 46,  2 }, {    -16, -128,   -4, 19, 46,  2 },
    {    -15, -129,   -4, 19, 46,  2 }, {    -14, -130,   -4, 19, 46,  2 }, {    -13, -130,   -4, 19, 46,  2 }, {    -12, -131,   -4, 19, 46,  2 }, {    -11, -132,   -5, 19, 46,  2 },
    {    -10, -132,   -5, 19, 46,  2 }, {     -9, -133,   -5, 19, 46,  2 }, {     -8, -134,   -5, 19, 46,  2 }, {     -7, -134,   -5, 19, 46,  2 }, {     -6, -135,   -5, 18, 46,  2 },
    {     -5, -135,   -5, 18, 46,  2 }, {     -4, -136,   -5, 18, 46,  2 }, {     -3, -136,   -5, 18, 46,  2 }, {     -2, -137,   -5, 18, 46,  2 }, {     -1, -137,   -5, 18, 46,  2 },
    {      0, -138,   -5, 18, 46,  2 }, {      1, -138,   -5, 18, 46,  2 }, {      2, -139,   -5, 18, 46,  2 }, {      3, -139,   -6, 18, 46,  2 }, {      4, -139,   -6, 18, 46,  2 },
    {      5, -140,   -6, 18, 46,  2 }, {      6, -140,   -6, 18, 46,  2 }, {      7, -140,   -6, 18, 46,  2 }, {      8, -141,   -6, 17, 46,  2 }, {      9, -141,   -6, 17, 46,  2 },
    {     10, -141,   -6, 17, 46,  2 }, {     11, -141,   -6, 17, 46,  2 }, {     12, -142,   -6, 17, 46,  2 }, {     13, -142,   -6, 17, 46,  2 }, {     14, -142,   -6, 17, 46,  2 },
    {     15, -142,   -6, 17, 46,  2 }, {     16, -142,   -6, 17, 46,  2 }, {     17, -143,   -7, 17, 46,  2 }, {     18, -143,   -7, 17, 46,  2 }, {     19, -143,   -7, 17, 46,  2 },
    {     20, -143,   -7, 17, 46,  2 }, {     21, -143,   -7, 17, 46,  2 }, {     22, -143,   -7, 17, 46,  2 }, {     23, -144,   -7, 17, 46,  2 }, {     24, -144,   -7, 16, 46,  2 },
    {     25, -144,   -7, 16, 46,  2 }, {     26, -144,   -7, 16, 46,  2 }, {     27, -144,   -7, 16, 46,  2 }, {     28, -144,   -7, 16, 46,  2 }, {     29, -144,   -7, 16, 46,  2 },
    {     30, -144,   -7, 16, 46,  2 }, {     31, -144,   -8, 16, 46,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F544F, {
    {     16,    0,    8,  8, 46,  2 }, {     16,    1,    8,  8, 46,  2 }, {     16,    2,    8,  8, 46,  2 }, {     16,    3,    8,  8, 46,  2 }, {     16,    4,    8,  8, 46,  2 },
    {     16,    5,    8,  8, 46,  2 }, {     16,    6,    8,  8, 46,  2 }, {     16,    7,    8,  8, 46,  2 }, {     16,    8,    8,  7, 46,  2 }, {     15,    9,    8,  7, 46,  2 },
    {     15,   10,    8,  7, 46,  2 }, {     15,   11,    8,  7, 46,  2 }, {     15,   12,    8,  7, 46,  2 }, {     15,   13,    8,  7, 46,  2 }, {     15,   14,    8,  7, 46,  2 },
    {     14,   15,    7,  7, 46,  2 }, {     14,   16,    7,  7, 46,  2 }, {     14,   17,    7,  7, 46,  2 }, {     14,   18,    7,  7, 46,  2 }, {     14,   19,    7,  7, 46,  2 },
    {     13,   20,    7,  7, 46,  2 }, {     13,   21,    7,  7, 46,  2 }, {     13,   22,    7,  6, 46,  2 }, {     13,   23,    7,  6, 46,  2 }, {     12,   24,    7,  6, 46,  2 },
    {     12,   25,    7,  6, 46,  2 }, {     12,   26,    7,  6, 46,  2 }, {     11,   27,    7,  6, 46,  2 }, {     11,   28,    7,  6, 46,  2 }, {     11,   29,    6,  6, 46,  2 },
    {     10,   30,    6,  6, 46,  2 }, {     10,   31,    6,  6, 46,  2 }, {      9,   32,    6,  6, 46,  2 }, {      9,   33,    6,  6, 46,  2 }, {      8,   34,    6,  6, 46,  2 },
    {      8,   35,    6,  6, 46,  2 }, {      7,   36,    6,  6, 46,  2 }, {      7,   37,    6,  5, 46,  2 }, {      6,   38,    6,  5, 46,  2 }, {      6,   39,    6,  5, 46,  2 },
    {      5,   40,    6,  5, 46,  2 }, {      4,   41,    6,  5, 46,  2 }, {      4,   42,    6,  5, 46,  2 }, {      3,   43,    6,  5, 46,  2 }, {      2,   44,    5,  5, 46,  2 },
    {      2,   45,    5,  5, 46,  2 }, {      1,   46,    5,  5, 46,  2 }, {      0,   47,    5,  5, 46,  2 }, {      0,   48,    5,  5, 46,  2 }, {     -1,   49,    5,  5, 46,  2 },
    {     -2,   50,    5,  4, 46,  2 }, {     -3,   51,    5,  4, 46,  2 }, {     -3,   52,    5,  4, 46,  2 }, {     -4,   53,    5,  4, 46,  2 }, {     -5,   54,    5,  4, 46,  2 },
    {     -6,   55,    5,  4, 46,  2 }, {     -7,   56,    5,  4, 46,  2 }, {     -7,   57,    5,  4, 46,  2 }, {     -8,   58,    4,  4, 46,  2 }, {     -9,   59,    4,  4, 46,  2 },
    {    -10,   60,    4,  4, 46,  2 }, {    -11,   61,    4,  4, 46,  2 }, {    -12,   61,    4,  4, 46,  2 }, {    -13,   62,    4,  3, 46,  2 }, {    -14,   63,    4,  3, 46,  2 },
    {    -15,   64,    4,  3, 46,  2 }, {    -16,   64,    4,  3, 46,  2 }, {    -17,   65,    4,  3, 46,  2 }, {    -18,   66,    4,  3, 46,  2 }, {    -19,   66,    4,  3, 46,  2 },
    {    -20,   67,    4,  3, 46,  2 }, {    -21,   68,    4,  3, 46,  2 }, {    -22,   68,    3,  3, 46,  2 }, {    -23,   69,    3,  3, 46,  2 }, {    -24,   70,    3,  3, 46,  2 },
    {    -25,   70,    3,  3, 46,  2 }, {    -26,   71,    3,  2, 46,  2 }, {    -27,   71,    3,  2, 46,  2 }, {    -28,   72,    3,  2, 46,  2 }, {    -29,   72,    3,  2, 46,  2 },
    {    -30,   73,    3,  2, 46,  2 }, {    -31,   73,    3,  2, 46,  2 }, {    -32,   74,    3,  2, 46,  2 }, {    -33,   74,    3,  2, 46,  2 }, {    -34,   75,    3,  2, 46,  2 },
    {    -35,   75,    3,  2, 46,  2 }, {    -36,   75,    3,  2, 46,  2 }, {    -37,   76,    2,  2, 46,  2 }, {    -38,   76,    2,  2, 46,  2 }, {    -39,   76,    2,  2, 46,  2 },
    {    -40,   77,    2,  1, 46,  2 }, {    -41,   77,    2,  1, 46,  2 }, {    -42,   77,    2,  1, 46,  2 }, {    -43,   77,    2,  1, 46,  2 }, {    -44,   78,    2,  1, 46,  2 },
    {    -45,   78,    2,  1, 46,  2 }, {    -46,   78,    2,  1, 46,  2 }, {    -47,   78,    2,  1, 46,  2 }, {    -48,   78,    2,  1, 46,  2 }, {    -49,   79,    2,  1, 46,  2 },
    {    -50,   79,    2,  1, 46,  2 }, {    -51,   79,    1,  1, 46,  2 }, {    -52,   79,    1,  1, 46,  2 }, {    -53,   79,    1,  1, 46,  2 }, {    -54,   79,    1,  1, 46,  2 },
    {    -55,   80,    1,  1, 46,  2 }, {    -56,   80,    1,  0, 46,  2 }, {    -57,   80,    1,  0, 46,  2 }, {    -58,   80,    1,  0, 46,  2 }, {    -59,   80,    1,  0, 46,  2 },
    {    -60,   80,    1,  0, 46,  2 }, {    -61,   80,    1,  0, 46,  2 }, {    -62,   80,    1,  0, 46,  2 }, {    -63,   80,    1,  0, 46,  2 }, {    -64,   80,    1,  0, 46,  2 },
    {    -65,   80,    0,  0, 46,  2 }, {    -66,   80,    0,  0, 46,  2 }, {    -67,   80,    0,  0, 46,  2 }, {    -68,   80,    0,  0, 46,  2 }, {    -69,   80,    0,  0, 46,  2 },
    {    -70,   80,    0,  0, 46,  2 }, {    -71,   80,    0,  0, 46,  2 }, {    -72,   80,    0, 31, 46,  2 }, {    -73,   79,    0, 31, 46,  2 }, {    -74,   79,    0, 31, 46,  2 },
    {    -75,   79,    0, 31, 46,  2 }, {    -76,   79,    0, 31, 46,  2 }, {    -77,   79,    0, 31, 46,  2 }, {    -78,   79,    0, 31, 46,  2 }, {    -79,   78,   -1, 31, 46,  2 },
    {    -80,   78,   -1, 31, 46,  2 }, {    -81,   78,   -1, 31, 46,  2 }, {    -82,   78,   -1, 31, 46,  2 }, {    -83,   78,   -1, 31, 46,  2 }, {    -84,   77,   -1, 31, 46,  2 },
    {    -85,   77,   -1, 31, 46,  2 }, {    -86,   77,   -1, 30, 46,  2 }, {    -87,   77,   -1, 30, 46,  2 }, {    -88,   76,   -1, 30, 46,  2 }, {    -89,   76,   -1, 30, 46,  2 },
    {    -90,   76,   -1, 30, 46,  2 }, {    -91,   75,   -1, 30, 46,  2 }, {    -92,   75,   -1, 30, 46,  2 }, {    -93,   75,   -2, 30, 46,  2 }, {    -94,   74,   -2, 30, 46,  2 },
    {    -95,   74,   -2, 30, 46,  2 }, {    -96,   73,   -2, 30, 46,  2 }, {    -97,   73,   -2, 30, 46,  2 }, {    -98,   72,   -2, 30, 46,  2 }, {    -99,   72,   -2, 30, 46,  2 },
    {   -100,   71,   -2, 30, 46,  2 }, {   -101,   71,   -2, 29, 46,  2 }, {   -102,   70,   -2, 29, 46,  2 }, {   -103,   70,   -2, 29, 46,  2 }, {   -104,   69,   -2, 29, 46,  2 },
    {   -105,   68,   -2, 29, 46,  2 }, {   -106,   68,   -2, 29, 46,  2 }, {   -107,   67,   -3, 29, 46,  2 }, {   -108,   66,   -3, 29, 46,  2 }, {   -109,   66,   -3, 29, 46,  2 },
    {   -110,   65,   -3, 29, 46,  2 }, {   -111,   64,   -3, 29, 46,  2 }, {   -112,   64,   -3, 29, 46,  2 }, {   -113,   63,   -3, 29, 46,  2 }, {   -114,   62,   -3, 28, 46,  2 },
    {   -115,   61,   -3, 28, 46,  2 }, {   -116,   61,   -3, 28, 46,  2 }, {   -117,   60,   -3, 28, 46,  2 }, {   -118,   59,   -3, 28, 46,  2 }, {   -119,   58,   -3, 28, 46,  2 },
    {   -120,   57,   -3, 28, 46,  2 }, {   -121,   57,   -4, 28, 46,  2 }, {   -122,   56,   -4, 28, 46,  2 }, {   -123,   55,   -4, 28, 46,  2 }, {   -124,   54,   -4, 28, 46,  2 },
    {   -125,   53,   -4, 28, 46,  2 }, {   -125,   52,   -4, 28, 46,  2 }, {   -126,   51,   -4, 27, 46,  2 }, {   -127,   50,   -4, 27, 46,  2 }, {   -128,   49,   -4, 27, 46,  2 },
    {   -128,   48,   -4, 27, 46,  2 }, {   -129,   47,   -4, 27, 46,  2 }, {   -130,   46,   -4, 27, 46,  2 }, {   -130,   45,   -4, 27, 46,  2 }, {   -131,   44,   -4, 27, 46,  2 },
    {   -132,   43,   -4, 27, 46,  2 }, {   -132,   42,   -5, 27, 46,  2 }, {   -133,   41,   -5, 27, 46,  2 }, {   -134,   40,   -5, 27, 46,  2 }, {   -134,   39,   -5, 27, 46,  2 },
    {   -135,   38,   -5, 26, 46,  2 }, {   -135,   37,   -5, 26, 46,  2 }, {   -136,   36,   -5, 26, 46,  2 }, {   -136,   35,   -5, 26, 46,  2 }, {   -137,   34,   -5, 26, 46,  2 },
    {   -137,   33,   -5, 26, 46,  2 }, {   -138,   32,   -5, 26, 46,  2 }, {   -138,   31,   -5, 26, 46,  2 }, {   -139,   30,   -5, 26, 46,  2 }, {   -139,   29,   -5, 26, 46,  2 },
    {   -139,   28,   -6, 26, 46,  2 }, {   -140,   27,   -6, 26, 46,  2 }, {   -140,   26,   -6, 26, 46,  2 }, {   -140,   25,   -6, 26, 46,  2 }, {   -141,   24,   -6, 25, 46,  2 },
    {   -141,   23,   -6, 25, 46,  2 }, {   -141,   22,   -6, 25, 46,  2 }, {   -141,   21,   -6, 25, 46,  2 }, {   -142,   20,   -6, 25, 46,  2 }, {   -142,   19,   -6, 25, 46,  2 },
    {   -142,   18,   -6, 25, 46,  2 }, {   -142,   17,   -6, 25, 46,  2 }, {   -142,   16,   -6, 25, 46,  2 }, {   -143,   15,   -6, 25, 46,  2 }, {   -143,   14,   -7, 25, 46,  2 },
    {   -143,   13,   -7, 25, 46,  2 }, {   -143,   12,   -7, 25, 46,  2 }, {   -143,   11,   -7, 25, 46,  2 }, {   -143,   10,   -7, 25, 46,  2 }, {   -144,    9,   -7, 25, 46,  2 },
    {   -144,    8,   -7, 24, 46,  2 }, {   -144,    7,   -7, 24, 46,  2 }, {   -144,    6,   -7, 24, 46,  2 }, {   -144,    5,   -7, 24, 46,  2 }, {   -144,    4,   -7, 24, 46,  2 },
    {   -144,    3,   -7, 24, 46,  2 }, {   -144,    2,   -7, 24, 46,  2 }, {   -144,    1,   -7, 24, 46,  2 }, {   -144,    0,   -8, 24, 46,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F5C5E, {
    {      0,   16,    8, 16, 46,  2 }, {      1,   16,    8, 16, 46,  2 }, {      2,   16,    8, 16, 46,  2 }, {      3,   16,    8, 16, 46,  2 }, {      4,   16,    8, 16, 46,  2 },
    {      5,   16,    8, 16, 46,  2 }, {      6,   16,    8, 16, 46,  2 }, {      7,   16,    8, 16, 46,  2 }, {      8,   16,    8, 15, 46,  2 }, {      9,   17,    8, 15, 46,  2 },
    {     10,   17,    8, 15, 46,  2 }, {     11,   17,    8, 15, 46,  2 }, {     12,   17,    8, 15, 46,  2 }, {     13,   17,    8, 15, 46,  2 }, {     14,   17,    8, 15, 46,  2 },
    {     15,   18,    7, 15, 46,  2 }, {     16,   18,    7, 15, 46,  2 }, {     17,   18,    7, 15, 46,  2 }, {     18,   18,    7, 15, 46,  2 }, {     19,   18,    7, 15, 46,  2 },
    {     20,   19,    7, 15, 46,  2 }, {     21,   19,    7, 15, 46,  2 }, {     22,   19,    7, 14, 46,  2 }, {     23,   19,    7, 14, 46,  2 }, {     24,   20,    7, 14, 46,  2 },
    {     25,   20,    7, 14, 46,  2 }, {     26,   20,    7, 14, 46,  2 }, {     27,   21,    7, 14, 46,  2 }, {     28,   21,    7, 14, 46,  2 }, {     29,   21,    6, 14, 46,  2 },
    {     30,   22,    6, 14, 46,  2 }, {     31,   22,    6, 14, 46,  2 }, {     32,   23,    6, 14, 46,  2 }, {     33,   23,    6, 14, 46,  2 }, {     34,   24,    6, 14, 46,  2 },
    {     35,   24,    6, 14, 46,  2 }, {     36,   25,    6, 14, 46,  2 }, {     37,   25,    6, 13, 46,  2 }, {     38,   26,    6, 13, 46,  2 }, {     39,   26,    6, 13, 46,  2 },
    {     40,   27,    6, 13, 46,  2 }, {     41,   28,    6, 13, 46,  2 }, {     42,   28,    6, 13, 46,  2 }, {     43,   29,    5, 13, 46,  2 }, {     44,   30,    5, 13, 46,  2 },
    {     45,   30,    5, 13, 46,  2 }, {     46,   31,    5, 13, 46,  2 }, {     47,   32,    5, 13, 46,  2 }, {     48,   32,    5, 13, 46,  2 }, {     49,   33,    5, 13, 46,  2 },
    {     50,   34,    5, 12, 46,  2 }, {     51,   35,    5, 12, 46,  2 }, {     52,   35,    5, 12, 46,  2 }, {     53,   36,    5, 12, 46,  2 }, {     54,   37,    5, 12, 46,  2 },
    {     55,   38,    5, 12, 46,  2 }, {     56,   39,    5, 12, 46,  2 }, {     57,   39,    4, 12, 46,  2 }, {     58,   40,    4, 12, 46,  2 }, {     59,   41,    4, 12, 46,  2 },
    {     60,   42,    4, 12, 46,  2 }, {     61,   43,    4, 12, 46,  2 }, {     61,   44,    4, 12, 46,  2 }, {     62,   45,    4, 11, 46,  2 }, {     63,   46,    4, 11, 46,  2 },
    {     64,   47,    4, 11, 46,  2 }, {     64,   48,    4, 11, 46,  2 }, {     65,   49,    4, 11, 46,  2 }, {     66,   50,    4, 11, 46,  2 }, {     66,   51,    4, 11, 46,  2 },
    {     67,   52,    4, 11, 46,  2 }, {     68,   53,    4, 11, 46,  2 }, {     68,   54,    3, 11, 46,  2 }, {     69,   55,    3, 11, 46,  2 }, {     70,   56,    3, 11, 46,  2 },
    {     70,   57,    3, 11, 46,  2 }, {     71,   58,    3, 10, 46,  2 }, {     71,   59,    3, 10, 46,  2 }, {     72,   60,    3, 10, 46,  2 }, {     72,   61,    3, 10, 46,  2 },
    {     73,   62,    3, 10, 46,  2 }, {     73,   63,    3, 10, 46,  2 }, {     74,   64,    3, 10, 46,  2 }, {     74,   65,    3, 10, 46,  2 }, {     75,   66,    3, 10, 46,  2 },
    {     75,   67,    3, 10, 46,  2 }, {     75,   68,    2, 10, 46,  2 }, {     76,   69,    2, 10, 46,  2 }, {     76,   70,    2, 10, 46,  2 }, {     76,   71,    2, 10, 46,  2 },
    {     77,   72,    2,  9, 46,  2 }, {     77,   73,    2,  9, 46,  2 }, {     77,   74,    2,  9, 46,  2 }, {     77,   75,    2,  9, 46,  2 }, {     78,   76,    2,  9, 46,  2 },
    {     78,   77,    2,  9, 46,  2 }, {     78,   78,    2,  9, 46,  2 }, {     78,   79,    2,  9, 46,  2 }, {     78,   80,    2,  9, 46,  2 }, {     79,   81,    2,  9, 46,  2 },
    {     79,   82,    1,  9, 46,  2 }, {     79,   83,    1,  9, 46,  2 }, {     79,   84,    1,  9, 46,  2 }, {     79,   85,    1,  9, 46,  2 }, {     79,   86,    1,  9, 46,  2 },
    {     80,   87,    1,  9, 46,  2 }, {     80,   88,    1,  8, 46,  2 }, {     80,   89,    1,  8, 46,  2 }, {     80,   90,    1,  8, 46,  2 }, {     80,   91,    1,  8, 46,  2 },
    {     80,   92,    1,  8, 46,  2 }, {     80,   93,    1,  8, 46,  2 }, {     80,   94,    1,  8, 46,  2 }, {     80,   95,    1,  8, 46,  2 }, {     80,   96,    0,  8, 46,  2 },
    {     80,   97,    0,  8, 46,  2 }, {     80,   98,    0,  8, 46,  2 }, {     80,   99,    0,  8, 46,  2 }, {     80,  100,    0,  8, 46,  2 }, {     80,  101,    0,  8, 46,  2 },
    {     80,  102,    0,  8, 46,  2 }, {     80,  103,    0,  8, 46,  2 }, {     80,  104,    0,  7, 46,  2 }, {     79,  105,    0,  7, 46,  2 }, {     79,  106,    0,  7, 46,  2 },
    {     79,  107,    0,  7, 46,  2 }, {     79,  108,    0,  7, 46,  2 }, {     79,  109,    0,  7, 46,  2 }, {     79,  110,    0,  7, 46,  2 }, {     78,  111,   -1,  7, 46,  2 },
    {     78,  112,   -1,  7, 46,  2 }, {     78,  113,   -1,  7, 46,  2 }, {     78,  114,   -1,  7, 46,  2 }, {     78,  115,   -1,  7, 46,  2 }, {     77,  116,   -1,  7, 46,  2 },
    {     77,  117,   -1,  7, 46,  2 }, {     77,  118,   -1,  6, 46,  2 }, {     77,  119,   -1,  6, 46,  2 }, {     76,  120,   -1,  6, 46,  2 }, {     76,  121,   -1,  6, 46,  2 },
    {     76,  122,   -1,  6, 46,  2 }, {     75,  123,   -1,  6, 46,  2 }, {     75,  124,   -1,  6, 46,  2 }, {     75,  125,   -2,  6, 46,  2 }, {     74,  126,   -2,  6, 46,  2 },
    {     74,  127,   -2,  6, 46,  2 }, {     73,  128,   -2,  6, 46,  2 }, {     73,  129,   -2,  6, 46,  2 }, {     72,  130,   -2,  6, 46,  2 }, {     72,  131,   -2,  6, 46,  2 },
    {     71,  132,   -2,  6, 46,  2 }, {     71,  133,   -2,  5, 46,  2 }, {     70,  134,   -2,  5, 46,  2 }, {     70,  135,   -2,  5, 46,  2 }, {     69,  136,   -2,  5, 46,  2 },
    {     68,  137,   -2,  5, 46,  2 }, {     68,  138,   -2,  5, 46,  2 }, {     67,  139,   -2,  5, 46,  2 }, {     66,  140,   -3,  5, 46,  2 }, {     66,  141,   -3,  5, 46,  2 },
    {     65,  142,   -3,  5, 46,  2 }, {     64,  143,   -3,  5, 46,  2 }, {     64,  144,   -3,  5, 46,  2 }, {     63,  145,   -3,  5, 46,  2 }, {     62,  146,   -3,  4, 46,  2 },
    {     61,  147,   -3,  4, 46,  2 }, {     61,  148,   -3,  4, 46,  2 }, {     60,  149,   -3,  4, 46,  2 }, {     59,  150,   -3,  4, 46,  2 }, {     58,  151,   -3,  4, 46,  2 },
    {     57,  152,   -3,  4, 46,  2 }, {     57,  153,   -3,  4, 46,  2 }, {     56,  154,   -4,  4, 46,  2 }, {     55,  155,   -4,  4, 46,  2 }, {     54,  156,   -4,  4, 46,  2 },
    {     53,  157,   -4,  4, 46,  2 }, {     52,  157,   -4,  4, 46,  2 }, {     51,  158,   -4,  3, 46,  2 }, {     50,  159,   -4,  3, 46,  2 }, {     49,  160,   -4,  3, 46,  2 },
    {     48,  160,   -4,  3, 46,  2 }, {     47,  161,   -4,  3, 46,  2 }, {     46,  162,   -4,  3, 46,  2 }, {     45,  162,   -4,  3, 46,  2 }, {     44,  163,   -4,  3, 46,  2 },
    {     43,  164,   -4,  3, 46,  2 }, {     42,  164,   -5,  3, 46,  2 }, {     41,  165,   -5,  3, 46,  2 }, {     40,  166,   -5,  3, 46,  2 }, {     39,  166,   -5,  3, 46,  2 },
    {     38,  167,   -5,  2, 46,  2 }, {     37,  167,   -5,  2, 46,  2 }, {     36,  168,   -5,  2, 46,  2 }, {     35,  168,   -5,  2, 46,  2 }, {     34,  169,   -5,  2, 46,  2 },
    {     33,  169,   -5,  2, 46,  2 }, {     32,  170,   -5,  2, 46,  2 }, {     31,  170,   -5,  2, 46,  2 }, {     30,  171,   -5,  2, 46,  2 }, {     29,  171,   -5,  2, 46,  2 },
    {     28,  171,   -5,  2, 46,  2 }, {     27,  172,   -6,  2, 46,  2 }, {     26,  172,   -6,  2, 46,  2 }, {     25,  172,   -6,  2, 46,  2 }, {     24,  173,   -6,  1, 46,  2 },
    {     23,  173,   -6,  1, 46,  2 }, {     22,  173,   -6,  1, 46,  2 }, {     21,  173,   -6,  1, 46,  2 }, {     20,  174,   -6,  1, 46,  2 }, {     19,  174,   -6,  1, 46,  2 },
    {     18,  174,   -6,  1, 46,  2 }, {     17,  174,   -6,  1, 46,  2 }, {     16,  174,   -6,  1, 46,  2 }, {     15,  175,   -6,  1, 46,  2 }, {     14,  175,   -6,  1, 46,  2 },
    {     13,  175,   -7,  1, 46,  2 }, {     12,  175,   -7,  1, 46,  2 }, {     11,  175,   -7,  1, 46,  2 }, {     10,  175,   -7,  1, 46,  2 }, {      9,  176,   -7,  1, 46,  2 },
    {      8,  176,   -7,  0, 46,  2 }, {      7,  176,   -7,  0, 46,  2 }, {      6,  176,   -7,  0, 46,  2 }, {      5,  176,   -7,  0, 46,  2 }, {      4,  176,   -7,  0, 46,  2 },
    {      3,  176,   -7,  0, 46,  2 }, {      2,  176,   -7,  0, 46,  2 }, {      1,  176,   -7,  0, 46,  2 }, {      0,  176,   -7,  0, 46,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F646D, {
    {     16,   31,    8, 24, 46,  2 }, {     16,   30,    8, 24, 46,  2 }, {     16,   29,    8, 24, 46,  2 }, {     16,   28,    8, 24, 46,  2 }, {     16,   27,    8, 24, 46,  2 },
    {     16,   26,    8, 24, 46,  2 }, {     16,   25,    8, 24, 46,  2 }, {     16,   24,    8, 23, 46,  2 }, {     17,   23,    8, 23, 46,  2 }, {     17,   22,    8, 23, 46,  2 },
    {     17,   21,    8, 23, 46,  2 }, {     17,   20,    8, 23, 46,  2 }, {     17,   19,    8, 23, 46,  2 }, {     17,   18,    8, 23, 46,  2 }, {     18,   17,    7, 23, 46,  2 },
    {     18,   16,    7, 23, 46,  2 }, {     18,   15,    7, 23, 46,  2 }, {     18,   14,    7, 23, 46,  2 }, {     18,   13,    7, 23, 46,  2 }, {     19,   12,    7, 23, 46,  2 },
    {     19,   11,    7, 23, 46,  2 }, {     19,   10,    7, 22, 46,  2 }, {     19,    9,    7, 22, 46,  2 }, {     20,    8,    7, 22, 46,  2 }, {     20,    7,    7, 22, 46,  2 },
    {     20,    6,    7, 22, 46,  2 }, {     21,    5,    7, 22, 46,  2 }, {     21,    4,    7, 22, 46,  2 }, {     21,    3,    6, 22, 46,  2 }, {     22,    2,    6, 22, 46,  2 },
    {     22,    1,    6, 22, 46,  2 }, {     23,    0,    6, 22, 46,  2 }, {     23,   -1,    6, 22, 46,  2 }, {     24,   -2,    6, 22, 46,  2 }, {     24,   -3,    6, 22, 46,  2 },
    {     25,   -4,    6, 22, 46,  2 }, {     25,   -5,    6, 21, 46,  2 }, {     26,   -6,    6, 21, 46,  2 }, {     26,   -7,    6, 21, 46,  2 }, {     27,   -8,    6, 21, 46,  2 },
    {     28,   -9,    6, 21, 46,  2 }, {     28,  -10,    6, 21, 46,  2 }, {     29,  -11,    5, 21, 46,  2 }, {     30,  -12,    5, 21, 46,  2 }, {     30,  -13,    5, 21, 46,  2 },
    {     31,  -14,    5, 21, 46,  2 }, {     32,  -15,    5, 21, 46,  2 }, {     32,  -16,    5, 21, 46,  2 }, {     33,  -17,    5, 21, 46,  2 }, {     34,  -18,    5, 20, 46,  2 },
    {     35,  -19,    5, 20, 46,  2 }, {     35,  -20,    5, 20, 46,  2 }, {     36,  -21,    5, 20, 46,  2 }, {     37,  -22,    5, 20, 46,  2 }, {     38,  -23,    5, 20, 46,  2 },
    {     39,  -24,    5, 20, 46,  2 }, {     39,  -25,    4, 20, 46,  2 }, {     40,  -26,    4, 20, 46,  2 }, {     41,  -27,    4, 20, 46,  2 }, {     42,  -28,    4, 20, 46,  2 },
    {     43,  -29,    4, 20, 46,  2 }, {     44,  -29,    4, 20, 46,  2 }, {     45,  -30,    4, 19, 46,  2 }, {     46,  -31,    4, 19, 46,  2 }, {     47,  -32,    4, 19, 46,  2 },
    {     48,  -32,    4, 19, 46,  2 }, {     49,  -33,    4, 19, 46,  2 }, {     50,  -34,    4, 19, 46,  2 }, {     51,  -34,    4, 19, 46,  2 }, {     52,  -35,    4, 19, 46,  2 },
    {     53,  -36,    3, 19, 46,  2 }, {     54,  -36,    3, 19, 46,  2 }, {     55,  -37,    3, 19, 46,  2 }, {     56,  -38,    3, 19, 46,  2 }, {     57,  -38,    3, 19, 46,  2 },
    {     58,  -39,    3, 18, 46,  2 }, {     59,  -39,    3, 18, 46,  2 }, {     60,  -40,    3, 18, 46,  2 }, {     61,  -40,    3, 18, 46,  2 }, {     62,  -41,    3, 18, 46,  2 },
    {     63,  -41,    3, 18, 46,  2 }, {     64,  -42,    3, 18, 46,  2 }, {     65,  -42,    3, 18, 46,  2 }, {     66,  -43,    3, 18, 46,  2 }, {     67,  -43,    2, 18, 46,  2 },
    {     68,  -43,    2, 18, 46,  2 }, {     69,  -44,    2, 18, 46,  2 }, {     70,  -44,    2, 18, 46,  2 }, {     71,  -44,    2, 18, 46,  2 }, {     72,  -45,    2, 17, 46,  2 },
    {     73,  -45,    2, 17, 46,  2 }, {     74,  -45,    2, 17, 46,  2 }, {     75,  -45,    2, 17, 46,  2 }, {     76,  -46,    2, 17, 46,  2 }, {     77,  -46,    2, 17, 46,  2 },
    {     78,  -46,    2, 17, 46,  2 }, {     79,  -46,    2, 17, 46,  2 }, {     80,  -46,    2, 17, 46,  2 }, {     81,  -47,    1, 17, 46,  2 }, {     82,  -47,    1, 17, 46,  2 },
    {     83,  -47,    1, 17, 46,  2 }, {     84,  -47,    1, 17, 46,  2 }, {     85,  -47,    1, 17, 46,  2 }, {     86,  -47,    1, 17, 46,  2 }, {     87,  -48,    1, 17, 46,  2 },
    {     88,  -48,    1, 16, 46,  2 }, {     89,  -48,    1, 16, 46,  2 }, {     90,  -48,    1, 16, 46,  2 }, {     91,  -48,    1, 16, 46,  2 }, {     92,  -48,    1, 16, 46,  2 },
    {     93,  -48,    1, 16, 46,  2 }, {     94,  -48,    1, 16, 46,  2 }, {     95,  -48,    0, 16, 46,  2 }, {     96,  -48,    0, 16, 46,  2 }, {     97,  -48,    0, 16, 46,  2 },
    {     98,  -48,    0, 16, 46,  2 }, {     99,  -48,    0, 16, 46,  2 }, {    100,  -48,    0, 16, 46,  2 }, {    101,  -48,    0, 16, 46,  2 }, {    102,  -48,    0, 16, 46,  2 },
    {    103,  -48,    0, 16, 46,  2 }, {    104,  -48,    0, 15, 46,  2 }, {    105,  -47,    0, 15, 46,  2 }, {    106,  -47,    0, 15, 46,  2 }, {    107,  -47,    0, 15, 46,  2 },
    {    108,  -47,    0, 15, 46,  2 }, {    109,  -47,    0, 15, 46,  2 }, {    110,  -47,    0, 15, 46,  2 }, {    111,  -46,   -1, 15, 46,  2 }, {    112,  -46,   -1, 15, 46,  2 },
    {    113,  -46,   -1, 15, 46,  2 }, {    114,  -46,   -1, 15, 46,  2 }, {    115,  -46,   -1, 15, 46,  2 }, {    116,  -45,   -1, 15, 46,  2 }, {    117,  -45,   -1, 15, 46,  2 },
    {    118,  -45,   -1, 14, 46,  2 }, {    119,  -45,   -1, 14, 46,  2 }, {    120,  -44,   -1, 14, 46,  2 }, {    121,  -44,   -1, 14, 46,  2 }, {    122,  -44,   -1, 14, 46,  2 },
    {    123,  -43,   -1, 14, 46,  2 }, {    124,  -43,   -1, 14, 46,  2 }, {    125,  -43,   -2, 14, 46,  2 }, {    126,  -42,   -2, 14, 46,  2 }, {    127,  -42,   -2, 14, 46,  2 },
    {    128,  -41,   -2, 14, 46,  2 }, {    129,  -41,   -2, 14, 46,  2 }, {    130,  -40,   -2, 14, 46,  2 }, {    131,  -40,   -2, 14, 46,  2 }, {    132,  -39,   -2, 14, 46,  2 },
    {    133,  -39,   -2, 13, 46,  2 }, {    134,  -38,   -2, 13, 46,  2 }, {    135,  -38,   -2, 13, 46,  2 }, {    136,  -37,   -2, 13, 46,  2 }, {    137,  -36,   -2, 13, 46,  2 },
    {    138,  -36,   -2, 13, 46,  2 }, {    139,  -35,   -3, 13, 46,  2 }, {    140,  -34,   -3, 13, 46,  2 }, {    141,  -34,   -3, 13, 46,  2 }, {    142,  -33,   -3, 13, 46,  2 },
    {    143,  -32,   -3, 13, 46,  2 }, {    144,  -32,   -3, 13, 46,  2 }, {    145,  -31,   -3, 13, 46,  2 }, {    146,  -30,   -3, 12, 46,  2 }, {    147,  -29,   -3, 12, 46,  2 },
    {    148,  -29,   -3, 12, 46,  2 }, {    149,  -28,   -3, 12, 46,  2 }, {    150,  -27,   -3, 12, 46,  2 }, {    151,  -26,   -3, 12, 46,  2 }, {    152,  -25,   -3, 12, 46,  2 },
    {    153,  -25,   -4, 12, 46,  2 }, {    154,  -24,   -4, 12, 46,  2 }, {    155,  -23,   -4, 12, 46,  2 }, {    156,  -22,   -4, 12, 46,  2 }, {    157,  -21,   -4, 12, 46,  2 },
    {    157,  -20,   -4, 12, 46,  2 }, {    158,  -19,   -4, 11, 46,  2 }, {    159,  -18,   -4, 11, 46,  2 }, {    160,  -17,   -4, 11, 46,  2 }, {    160,  -16,   -4, 11, 46,  2 },
    {    161,  -15,   -4, 11, 46,  2 }, {    162,  -14,   -4, 11, 46,  2 }, {    162,  -13,   -4, 11, 46,  2 }, {    163,  -12,   -4, 11, 46,  2 }, {    164,  -11,   -4, 11, 46,  2 },
    {    164,  -10,   -5, 11, 46,  2 }, {    165,   -9,   -5, 11, 46,  2 }, {    166,   -8,   -5, 11, 46,  2 }, {    166,   -7,   -5, 11, 46,  2 }, {    167,   -6,   -5, 10, 46,  2 },
    {    167,   -5,   -5, 10, 46,  2 }, {    168,   -4,   -5, 10, 46,  2 }, {    168,   -3,   -5, 10, 46,  2 }, {    169,   -2,   -5, 10, 46,  2 }, {    169,   -1,   -5, 10, 46,  2 },
    {    170,    0,   -5, 10, 46,  2 }, {    170,    1,   -5, 10, 46,  2 }, {    171,    2,   -5, 10, 46,  2 }, {    171,    3,   -5, 10, 46,  2 }, {    171,    4,   -6, 10, 46,  2 },
    {    172,    5,   -6, 10, 46,  2 }, {    172,    6,   -6, 10, 46,  2 }, {    172,    7,   -6, 10, 46,  2 }, {    173,    8,   -6,  9, 46,  2 }, {    173,    9,   -6,  9, 46,  2 },
    {    173,   10,   -6,  9, 46,  2 }, {    173,   11,   -6,  9, 46,  2 }, {    174,   12,   -6,  9, 46,  2 }, {    174,   13,   -6,  9, 46,  2 }, {    174,   14,   -6,  9, 46,  2 },
    {    174,   15,   -6,  9, 46,  2 }, {    174,   16,   -6,  9, 46,  2 }, {    175,   17,   -6,  9, 46,  2 }, {    175,   18,   -7,  9, 46,  2 }, {    175,   19,   -7,  9, 46,  2 },
    {    175,   20,   -7,  9, 46,  2 }, {    175,   21,   -7,  9, 46,  2 }, {    175,   22,   -7,  9, 46,  2 }, {    176,   23,   -7,  9, 46,  2 }, {    176,   24,   -7,  8, 46,  2 },
    {    176,   25,   -7,  8, 46,  2 }, {    176,   26,   -7,  8, 46,  2 }, {    176,   27,   -7,  8, 46,  2 }, {    176,   28,   -7,  8, 46,  2 }, {    176,   29,   -7,  8, 46,  2 },
    {    176,   30,   -7,  8, 46,  2 }, {    176,   31,   -7,  8, 46,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F6C6A, {
    {     31,   16,    8,  0, 46,  4 }, {     30,   16,    8,  0, 46,  4 }, {     29,   16,    8,  0, 46,  4 }, {     28,   16,    8,  0, 46,  4 }, {     27,   16,    8,  0, 46,  4 },
    {     26,   16,    8,  0, 46,  4 }, {     25,   16,    8,  0, 46,  4 }, {     24,   16,    8,  1, 46,  4 }, {     23,   17,    8,  1, 46,  4 }, {     22,   17,    8,  1, 46,  4 },
    {     21,   17,    8,  1, 46,  4 }, {     20,   17,    8,  1, 46,  4 }, {     19,   17,    8,  1, 46,  4 }, {     18,   17,    8,  1, 46,  4 }, {     17,   18,    7,  1, 46,  4 },
    {     16,   18,    7,  1, 46,  4 }, {     15,   18,    7,  1, 46,  4 }, {     14,   18,    7,  1, 46,  4 }, {     13,   18,    7,  1, 46,  4 }, {     12,   19,    7,  1, 46,  4 },
    {     11,   19,    7,  1, 46,  4 }, {     10,   19,    7,  2, 46,  4 }, {      9,   19,    7,  2, 46,  4 }, {      8,   20,    7,  2, 46,  4 }, {      7,   20,    7,  2, 46,  4 },
    {      6,   20,    7,  2, 46,  4 }, {      5,   21,    7,  2, 46,  4 }, {      4,   21,    7,  2, 46,  4 }, {      3,   21,    6,  2, 46,  4 }, {      2,   22,    6,  2, 46,  4 },
    {      1,   22,    6,  2, 46,  4 }, {      0,   23,    6,  2, 46,  4 }, {     -1,   23,    6,  2, 46,  4 }, {     -2,   24,    6,  2, 46,  4 }, {     -3,   24,    6,  2, 46,  4 },
    {     -4,   25,    6,  2, 46,  4 }, {     -5,   25,    6,  3, 46,  4 }, {     -6,   26,    6,  3, 46,  4 }, {     -7,   26,    6,  3, 46,  4 }, {     -8,   27,    6,  3, 46,  4 },
    {     -9,   28,    6,  3, 46,  4 }, {    -10,   28,    6,  3, 46,  4 }, {    -11,   29,    5,  3, 46,  4 }, {    -12,   30,    5,  3, 46,  4 }, {    -13,   30,    5,  3, 46,  4 },
    {    -14,   31,    5,  3, 46,  4 }, {    -15,   32,    5,  3, 46,  4 }, {    -16,   32,    5,  3, 46,  4 }, {    -17,   33,    5,  3, 46,  4 }, {    -18,   34,    5,  4, 46,  4 },
    {    -19,   35,    5,  4, 46,  4 }, {    -20,   35,    5,  4, 46,  4 }, {    -21,   36,    5,  4, 46,  4 }, {    -22,   37,    5,  4, 46,  4 }, {    -23,   38,    5,  4, 46,  4 },
    {    -24,   39,    5,  4, 46,  4 }, {    -25,   39,    4,  4, 46,  4 }, {    -26,   40,    4,  4, 46,  4 }, {    -27,   41,    4,  4, 46,  4 }, {    -28,   42,    4,  4, 46,  4 },
    {    -29,   43,    4,  4, 46,  4 }, {    -29,   44,    4,  4, 46,  4 }, {    -30,   45,    4,  5, 46,  4 }, {    -31,   46,    4,  5, 46,  4 }, {    -32,   47,    4,  5, 46,  4 },
    {    -32,   48,    4,  5, 46,  4 }, {    -33,   49,    4,  5, 46,  4 }, {    -34,   50,    4,  5, 46,  4 }, {    -34,   51,    4,  5, 46,  4 }, {    -35,   52,    4,  5, 46,  4 },
    {    -36,   53,    3,  5, 46,  4 }, {    -36,   54,    3,  5, 46,  4 }, {    -37,   55,    3,  5, 46,  4 }, {    -38,   56,    3,  5, 46,  4 }, {    -38,   57,    3,  5, 46,  4 },
    {    -39,   58,    3,  6, 46,  4 }, {    -39,   59,    3,  6, 46,  4 }, {    -40,   60,    3,  6, 46,  4 }, {    -40,   61,    3,  6, 46,  4 }, {    -41,   62,    3,  6, 46,  4 },
    {    -41,   63,    3,  6, 46,  4 }, {    -42,   64,    3,  6, 46,  4 }, {    -42,   65,    3,  6, 46,  4 }, {    -43,   66,    3,  6, 46,  4 }, {    -43,   67,    2,  6, 46,  4 },
    {    -43,   68,    2,  6, 46,  4 }, {    -44,   69,    2,  6, 46,  4 }, {    -44,   70,    2,  6, 46,  4 }, {    -44,   71,    2,  6, 46,  4 }, {    -45,   72,    2,  7, 46,  4 },
    {    -45,   73,    2,  7, 46,  4 }, {    -45,   74,    2,  7, 46,  4 }, {    -45,   75,    2,  7, 46,  4 }, {    -46,   76,    2,  7, 46,  4 }, {    -46,   77,    2,  7, 46,  4 },
    {    -46,   78,    2,  7, 46,  4 }, {    -46,   79,    2,  7, 46,  4 }, {    -46,   80,    2,  7, 46,  4 }, {    -47,   81,    1,  7, 46,  4 }, {    -47,   82,    1,  7, 46,  4 },
    {    -47,   83,    1,  7, 46,  4 }, {    -47,   84,    1,  7, 46,  4 }, {    -47,   85,    1,  7, 46,  4 }, {    -47,   86,    1,  7, 46,  4 }, {    -48,   87,    1,  7, 46,  4 },
    {    -48,   88,    1,  8, 46,  4 }, {    -48,   89,    1,  8, 46,  4 }, {    -48,   90,    1,  8, 46,  4 }, {    -48,   91,    1,  8, 46,  4 }, {    -48,   92,    1,  8, 46,  4 },
    {    -48,   93,    1,  8, 46,  4 }, {    -48,   94,    1,  8, 46,  4 }, {    -48,   95,    0,  8, 46,  4 }, {    -48,   96,    0,  8, 46,  4 }, {    -48,   97,    0,  8, 46,  4 },
    {    -48,   98,    0,  8, 46,  4 }, {    -48,   99,    0,  8, 46,  4 }, {    -48,  100,    0,  8, 46,  4 }, {    -48,  101,    0,  8, 46,  4 }, {    -48,  102,    0,  8, 46,  4 },
    {    -48,  103,    0,  8, 46,  4 }, {    -48,  104,    0,  9, 46,  4 }, {    -47,  105,    0,  9, 46,  4 }, {    -47,  106,    0,  9, 46,  4 }, {    -47,  107,    0,  9, 46,  4 },
    {    -47,  108,    0,  9, 46,  4 }, {    -47,  109,    0,  9, 46,  4 }, {    -47,  110,    0,  9, 46,  4 }, {    -46,  111,   -1,  9, 46,  4 }, {    -46,  112,   -1,  9, 46,  4 },
    {    -46,  113,   -1,  9, 46,  4 }, {    -46,  114,   -1,  9, 46,  4 }, {    -46,  115,   -1,  9, 46,  4 }, {    -45,  116,   -1,  9, 46,  4 }, {    -45,  117,   -1,  9, 46,  4 },
    {    -45,  118,   -1, 10, 46,  4 }, {    -45,  119,   -1, 10, 46,  4 }, {    -44,  120,   -1, 10, 46,  4 }, {    -44,  121,   -1, 10, 46,  4 }, {    -44,  122,   -1, 10, 46,  4 },
    {    -43,  123,   -1, 10, 46,  4 }, {    -43,  124,   -1, 10, 46,  4 }, {    -43,  125,   -2, 10, 46,  4 }, {    -42,  126,   -2, 10, 46,  4 }, {    -42,  127,   -2, 10, 46,  4 },
    {    -41,  128,   -2, 10, 46,  4 }, {    -41,  129,   -2, 10, 46,  4 }, {    -40,  130,   -2, 10, 46,  4 }, {    -40,  131,   -2, 10, 46,  4 }, {    -39,  132,   -2, 10, 46,  4 },
    {    -39,  133,   -2, 11, 46,  4 }, {    -38,  134,   -2, 11, 46,  4 }, {    -38,  135,   -2, 11, 46,  4 }, {    -37,  136,   -2, 11, 46,  4 }, {    -36,  137,   -2, 11, 46,  4 },
    {    -36,  138,   -2, 11, 46,  4 }, {    -35,  139,   -3, 11, 46,  4 }, {    -34,  140,   -3, 11, 46,  4 }, {    -34,  141,   -3, 11, 46,  4 }, {    -33,  142,   -3, 11, 46,  4 },
    {    -32,  143,   -3, 11, 46,  4 }, {    -32,  144,   -3, 11, 46,  4 }, {    -31,  145,   -3, 11, 46,  4 }, {    -30,  146,   -3, 12, 46,  4 }, {    -29,  147,   -3, 12, 46,  4 },
    {    -29,  148,   -3, 12, 46,  4 }, {    -28,  149,   -3, 12, 46,  4 }, {    -27,  150,   -3, 12, 46,  4 }, {    -26,  151,   -3, 12, 46,  4 }, {    -25,  152,   -3, 12, 46,  4 },
    {    -25,  153,   -4, 12, 46,  4 }, {    -24,  154,   -4, 12, 46,  4 }, {    -23,  155,   -4, 12, 46,  4 }, {    -22,  156,   -4, 12, 46,  4 }, {    -21,  157,   -4, 12, 46,  4 },
    {    -20,  157,   -4, 12, 46,  4 }, {    -19,  158,   -4, 13, 46,  4 }, {    -18,  159,   -4, 13, 46,  4 }, {    -17,  160,   -4, 13, 46,  4 }, {    -16,  160,   -4, 13, 46,  4 },
    {    -15,  161,   -4, 13, 46,  4 }, {    -14,  162,   -4, 13, 46,  4 }, {    -13,  162,   -4, 13, 46,  4 }, {    -12,  163,   -4, 13, 46,  4 }, {    -11,  164,   -4, 13, 46,  4 },
    {    -10,  164,   -5, 13, 46,  4 }, {     -9,  165,   -5, 13, 46,  4 }, {     -8,  166,   -5, 13, 46,  4 }, {     -7,  166,   -5, 13, 46,  4 }, {     -6,  167,   -5, 14, 46,  4 },
    {     -5,  167,   -5, 14, 46,  4 }, {     -4,  168,   -5, 14, 46,  4 }, {     -3,  168,   -5, 14, 46,  4 }, {     -2,  169,   -5, 14, 46,  4 }, {     -1,  169,   -5, 14, 46,  4 },
    {      0,  170,   -5, 14, 46,  4 }, {      1,  170,   -5, 14, 46,  4 }, {      2,  171,   -5, 14, 46,  4 }, {      3,  171,   -5, 14, 46,  4 }, {      4,  171,   -6, 14, 46,  4 },
    {      5,  172,   -6, 14, 46,  4 }, {      6,  172,   -6, 14, 46,  4 }, {      7,  172,   -6, 14, 46,  4 }, {      8,  173,   -6, 15, 46,  4 }, {      9,  173,   -6, 15, 46,  4 },
    {     10,  173,   -6, 15, 46,  4 }, {     11,  173,   -6, 15, 46,  4 }, {     12,  174,   -6, 15, 46,  4 }, {     13,  174,   -6, 15, 46,  4 }, {     14,  174,   -6, 15, 46,  4 },
    {     15,  174,   -6, 15, 46,  4 }, {     16,  174,   -6, 15, 46,  4 }, {     17,  175,   -6, 15, 46,  4 }, {     18,  175,   -7, 15, 46,  4 }, {     19,  175,   -7, 15, 46,  4 },
    {     20,  175,   -7, 15, 46,  4 }, {     21,  175,   -7, 15, 46,  4 }, {     22,  175,   -7, 15, 46,  4 }, {     23,  176,   -7, 15, 46,  4 }, {     24,  176,   -7, 16, 46,  4 },
    {     25,  176,   -7, 16, 46,  4 }, {     26,  176,   -7, 16, 46,  4 }, {     27,  176,   -7, 16, 46,  4 }, {     28,  176,   -7, 16, 46,  4 }, {     29,  176,   -7, 16, 46,  4 },
    {     30,  176,   -7, 16, 46,  4 }, {     31,  176,   -7, 16, 46,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F7467, {
    {     16,    0,    8,  8, 46,  4 }, {     16,    1,    8,  8, 46,  4 }, {     16,    2,    8,  8, 46,  4 }, {     16,    3,    8,  8, 46,  4 }, {     16,    4,    8,  8, 46,  4 },
    {     16,    5,    8,  8, 46,  4 }, {     16,    6,    8,  8, 46,  4 }, {     16,    7,    8,  8, 46,  4 }, {     16,    8,    8,  9, 46,  4 }, {     17,    9,    8,  9, 46,  4 },
    {     17,   10,    8,  9, 46,  4 }, {     17,   11,    8,  9, 46,  4 }, {     17,   12,    8,  9, 46,  4 }, {     17,   13,    8,  9, 46,  4 }, {     17,   14,    8,  9, 46,  4 },
    {     18,   15,    7,  9, 46,  4 }, {     18,   16,    7,  9, 46,  4 }, {     18,   17,    7,  9, 46,  4 }, {     18,   18,    7,  9, 46,  4 }, {     18,   19,    7,  9, 46,  4 },
    {     19,   20,    7,  9, 46,  4 }, {     19,   21,    7,  9, 46,  4 }, {     19,   22,    7, 10, 46,  4 }, {     19,   23,    7, 10, 46,  4 }, {     20,   24,    7, 10, 46,  4 },
    {     20,   25,    7, 10, 46,  4 }, {     20,   26,    7, 10, 46,  4 }, {     21,   27,    7, 10, 46,  4 }, {     21,   28,    7, 10, 46,  4 }, {     21,   29,    6, 10, 46,  4 },
    {     22,   30,    6, 10, 46,  4 }, {     22,   31,    6, 10, 46,  4 }, {     23,   32,    6, 10, 46,  4 }, {     23,   33,    6, 10, 46,  4 }, {     24,   34,    6, 10, 46,  4 },
    {     24,   35,    6, 10, 46,  4 }, {     25,   36,    6, 10, 46,  4 }, {     25,   37,    6, 11, 46,  4 }, {     26,   38,    6, 11, 46,  4 }, {     26,   39,    6, 11, 46,  4 },
    {     27,   40,    6, 11, 46,  4 }, {     28,   41,    6, 11, 46,  4 }, {     28,   42,    6, 11, 46,  4 }, {     29,   43,    5, 11, 46,  4 }, {     30,   44,    5, 11, 46,  4 },
    {     30,   45,    5, 11, 46,  4 }, {     31,   46,    5, 11, 46,  4 }, {     32,   47,    5, 11, 46,  4 }, {     32,   48,    5, 11, 46,  4 }, {     33,   49,    5, 11, 46,  4 },
    {     34,   50,    5, 12, 46,  4 }, {     35,   51,    5, 12, 46,  4 }, {     35,   52,    5, 12, 46,  4 }, {     36,   53,    5, 12, 46,  4 }, {     37,   54,    5, 12, 46,  4 },
    {     38,   55,    5, 12, 46,  4 }, {     39,   56,    5, 12, 46,  4 }, {     39,   57,    4, 12, 46,  4 }, {     40,   58,    4, 12, 46,  4 }, {     41,   59,    4, 12, 46,  4 },
    {     42,   60,    4, 12, 46,  4 }, {     43,   61,    4, 12, 46,  4 }, {     44,   61,    4, 12, 46,  4 }, {     45,   62,    4, 13, 46,  4 }, {     46,   63,    4, 13, 46,  4 },
    {     47,   64,    4, 13, 46,  4 }, {     48,   64,    4, 13, 46,  4 }, {     49,   65,    4, 13, 46,  4 }, {     50,   66,    4, 13, 46,  4 }, {     51,   66,    4, 13, 46,  4 },
    {     52,   67,    4, 13, 46,  4 }, {     53,   68,    4, 13, 46,  4 }, {     54,   68,    3, 13, 46,  4 }, {     55,   69,    3, 13, 46,  4 }, {     56,   70,    3, 13, 46,  4 },
    {     57,   70,    3, 13, 46,  4 }, {     58,   71,    3, 14, 46,  4 }, {     59,   71,    3, 14, 46,  4 }, {     60,   72,    3, 14, 46,  4 }, {     61,   72,    3, 14, 46,  4 },
    {     62,   73,    3, 14, 46,  4 }, {     63,   73,    3, 14, 46,  4 }, {     64,   74,    3, 14, 46,  4 }, {     65,   74,    3, 14, 46,  4 }, {     66,   75,    3, 14, 46,  4 },
    {     67,   75,    3, 14, 46,  4 }, {     68,   75,    2, 14, 46,  4 }, {     69,   76,    2, 14, 46,  4 }, {     70,   76,    2, 14, 46,  4 }, {     71,   76,    2, 14, 46,  4 },
    {     72,   77,    2, 15, 46,  4 }, {     73,   77,    2, 15, 46,  4 }, {     74,   77,    2, 15, 46,  4 }, {     75,   77,    2, 15, 46,  4 }, {     76,   78,    2, 15, 46,  4 },
    {     77,   78,    2, 15, 46,  4 }, {     78,   78,    2, 15, 46,  4 }, {     79,   78,    2, 15, 46,  4 }, {     80,   78,    2, 15, 46,  4 }, {     81,   79,    2, 15, 46,  4 },
    {     82,   79,    1, 15, 46,  4 }, {     83,   79,    1, 15, 46,  4 }, {     84,   79,    1, 15, 46,  4 }, {     85,   79,    1, 15, 46,  4 }, {     86,   79,    1, 15, 46,  4 },
    {     87,   80,    1, 15, 46,  4 }, {     88,   80,    1, 16, 46,  4 }, {     89,   80,    1, 16, 46,  4 }, {     90,   80,    1, 16, 46,  4 }, {     91,   80,    1, 16, 46,  4 },
    {     92,   80,    1, 16, 46,  4 }, {     93,   80,    1, 16, 46,  4 }, {     94,   80,    1, 16, 46,  4 }, {     95,   80,    1, 16, 46,  4 }, {     96,   80,    0, 16, 46,  4 },
    {     97,   80,    0, 16, 46,  4 }, {     98,   80,    0, 16, 46,  4 }, {     99,   80,    0, 16, 46,  4 }, {    100,   80,    0, 16, 46,  4 }, {    101,   80,    0, 16, 46,  4 },
    {    102,   80,    0, 16, 46,  4 }, {    103,   80,    0, 16, 46,  4 }, {    104,   80,    0, 17, 46,  4 }, {    105,   79,    0, 17, 46,  4 }, {    106,   79,    0, 17, 46,  4 },
    {    107,   79,    0, 17, 46,  4 }, {    108,   79,    0, 17, 46,  4 }, {    109,   79,    0, 17, 46,  4 }, {    110,   79,    0, 17, 46,  4 }, {    111,   78,   -1, 17, 46,  4 },
    {    112,   78,   -1, 17, 46,  4 }, {    113,   78,   -1, 17, 46,  4 }, {    114,   78,   -1, 17, 46,  4 }, {    115,   78,   -1, 17, 46,  4 }, {    116,   77,   -1, 17, 46,  4 },
    {    117,   77,   -1, 17, 46,  4 }, {    118,   77,   -1, 18, 46,  4 }, {    119,   77,   -1, 18, 46,  4 }, {    120,   76,   -1, 18, 46,  4 }, {    121,   76,   -1, 18, 46,  4 },
    {    122,   76,   -1, 18, 46,  4 }, {    123,   75,   -1, 18, 46,  4 }, {    124,   75,   -1, 18, 46,  4 }, {    125,   75,   -2, 18, 46,  4 }, {    126,   74,   -2, 18, 46,  4 },
    {    127,   74,   -2, 18, 46,  4 }, {    128,   73,   -2, 18, 46,  4 }, {    129,   73,   -2, 18, 46,  4 }, {    130,   72,   -2, 18, 46,  4 }, {    131,   72,   -2, 18, 46,  4 },
    {    132,   71,   -2, 18, 46,  4 }, {    133,   71,   -2, 19, 46,  4 }, {    134,   70,   -2, 19, 46,  4 }, {    135,   70,   -2, 19, 46,  4 }, {    136,   69,   -2, 19, 46,  4 },
    {    137,   68,   -2, 19, 46,  4 }, {    138,   68,   -2, 19, 46,  4 }, {    139,   67,   -2, 19, 46,  4 }, {    140,   66,   -3, 19, 46,  4 }, {    141,   66,   -3, 19, 46,  4 },
    {    142,   65,   -3, 19, 46,  4 }, {    143,   64,   -3, 19, 46,  4 }, {    144,   64,   -3, 19, 46,  4 }, {    145,   63,   -3, 19, 46,  4 }, {    146,   62,   -3, 20, 46,  4 },
    {    147,   61,   -3, 20, 46,  4 }, {    148,   61,   -3, 20, 46,  4 }, {    149,   60,   -3, 20, 46,  4 }, {    150,   59,   -3, 20, 46,  4 }, {    151,   58,   -3, 20, 46,  4 },
    {    152,   57,   -3, 20, 46,  4 }, {    153,   57,   -3, 20, 46,  4 }, {    154,   56,   -4, 20, 46,  4 }, {    155,   55,   -4, 20, 46,  4 }, {    156,   54,   -4, 20, 46,  4 },
    {    157,   53,   -4, 20, 46,  4 }, {    157,   52,   -4, 20, 46,  4 }, {    158,   51,   -4, 21, 46,  4 }, {    159,   50,   -4, 21, 46,  4 }, {    160,   49,   -4, 21, 46,  4 },
    {    160,   48,   -4, 21, 46,  4 }, {    161,   47,   -4, 21, 46,  4 }, {    162,   46,   -4, 21, 46,  4 }, {    162,   45,   -4, 21, 46,  4 }, {    163,   44,   -4, 21, 46,  4 },
    {    164,   43,   -4, 21, 46,  4 }, {    164,   42,   -5, 21, 46,  4 }, {    165,   41,   -5, 21, 46,  4 }, {    166,   40,   -5, 21, 46,  4 }, {    166,   39,   -5, 21, 46,  4 },
    {    167,   38,   -5, 22, 46,  4 }, {    167,   37,   -5, 22, 46,  4 }, {    168,   36,   -5, 22, 46,  4 }, {    168,   35,   -5, 22, 46,  4 }, {    169,   34,   -5, 22, 46,  4 },
    {    169,   33,   -5, 22, 46,  4 }, {    170,   32,   -5, 22, 46,  4 }, {    170,   31,   -5, 22, 46,  4 }, {    171,   30,   -5, 22, 46,  4 }, {    171,   29,   -5, 22, 46,  4 },
    {    171,   28,   -5, 22, 46,  4 }, {    172,   27,   -6, 22, 46,  4 }, {    172,   26,   -6, 22, 46,  4 }, {    172,   25,   -6, 22, 46,  4 }, {    173,   24,   -6, 23, 46,  4 },
    {    173,   23,   -6, 23, 46,  4 }, {    173,   22,   -6, 23, 46,  4 }, {    173,   21,   -6, 23, 46,  4 }, {    174,   20,   -6, 23, 46,  4 }, {    174,   19,   -6, 23, 46,  4 },
    {    174,   18,   -6, 23, 46,  4 }, {    174,   17,   -6, 23, 46,  4 }, {    174,   16,   -6, 23, 46,  4 }, {    175,   15,   -6, 23, 46,  4 }, {    175,   14,   -6, 23, 46,  4 },
    {    175,   13,   -7, 23, 46,  4 }, {    175,   12,   -7, 23, 46,  4 }, {    175,   11,   -7, 23, 46,  4 }, {    175,   10,   -7, 23, 46,  4 }, {    176,    9,   -7, 23, 46,  4 },
    {    176,    8,   -7, 24, 46,  4 }, {    176,    7,   -7, 24, 46,  4 }, {    176,    6,   -7, 24, 46,  4 }, {    176,    5,   -7, 24, 46,  4 }, {    176,    4,   -7, 24, 46,  4 },
    {    176,    3,   -7, 24, 46,  4 }, {    176,    2,   -7, 24, 46,  4 }, {    176,    1,   -7, 24, 46,  4 }, {    176,    0,   -7, 24, 46,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F7C76, {
    {      0,   16,    8, 16, 46,  4 }, {      1,   16,    8, 16, 46,  4 }, {      2,   16,    8, 16, 46,  4 }, {      3,   16,    8, 16, 46,  4 }, {      4,   16,    8, 16, 46,  4 },
    {      5,   16,    8, 16, 46,  4 }, {      6,   16,    8, 16, 46,  4 }, {      7,   16,    8, 16, 46,  4 }, {      8,   16,    8, 17, 46,  4 }, {      9,   15,    8, 17, 46,  4 },
    {     10,   15,    8, 17, 46,  4 }, {     11,   15,    8, 17, 46,  4 }, {     12,   15,    8, 17, 46,  4 }, {     13,   15,    8, 17, 46,  4 }, {     14,   15,    8, 17, 46,  4 },
    {     15,   14,    7, 17, 46,  4 }, {     16,   14,    7, 17, 46,  4 }, {     17,   14,    7, 17, 46,  4 }, {     18,   14,    7, 17, 46,  4 }, {     19,   14,    7, 17, 46,  4 },
    {     20,   13,    7, 17, 46,  4 }, {     21,   13,    7, 17, 46,  4 }, {     22,   13,    7, 18, 46,  4 }, {     23,   13,    7, 18, 46,  4 }, {     24,   12,    7, 18, 46,  4 },
    {     25,   12,    7, 18, 46,  4 }, {     26,   12,    7, 18, 46,  4 }, {     27,   11,    7, 18, 46,  4 }, {     28,   11,    7, 18, 46,  4 }, {     29,   11,    6, 18, 46,  4 },
    {     30,   10,    6, 18, 46,  4 }, {     31,   10,    6, 18, 46,  4 }, {     32,    9,    6, 18, 46,  4 }, {     33,    9,    6, 18, 46,  4 }, {     34,    8,    6, 18, 46,  4 },
    {     35,    8,    6, 18, 46,  4 }, {     36,    7,    6, 18, 46,  4 }, {     37,    7,    6, 19, 46,  4 }, {     38,    6,    6, 19, 46,  4 }, {     39,    6,    6, 19, 46,  4 },
    {     40,    5,    6, 19, 46,  4 }, {     41,    4,    6, 19, 46,  4 }, {     42,    4,    6, 19, 46,  4 }, {     43,    3,    6, 19, 46,  4 }, {     44,    2,    5, 19, 46,  4 },
    {     45,    2,    5, 19, 46,  4 }, {     46,    1,    5, 19, 46,  4 }, {     47,    0,    5, 19, 46,  4 }, {     48,    0,    5, 19, 46,  4 }, {     49,   -1,    5, 19, 46,  4 },
    {     50,   -2,    5, 20, 46,  4 }, {     51,   -3,    5, 20, 46,  4 }, {     52,   -3,    5, 20, 46,  4 }, {     53,   -4,    5, 20, 46,  4 }, {     54,   -5,    5, 20, 46,  4 },
    {     55,   -6,    5, 20, 46,  4 }, {     56,   -7,    5, 20, 46,  4 }, {     57,   -7,    5, 20, 46,  4 }, {     58,   -8,    4, 20, 46,  4 }, {     59,   -9,    4, 20, 46,  4 },
    {     60,  -10,    4, 20, 46,  4 }, {     61,  -11,    4, 20, 46,  4 }, {     61,  -12,    4, 20, 46,  4 }, {     62,  -13,    4, 21, 46,  4 }, {     63,  -14,    4, 21, 46,  4 },
    {     64,  -15,    4, 21, 46,  4 }, {     64,  -16,    4, 21, 46,  4 }, {     65,  -17,    4, 21, 46,  4 }, {     66,  -18,    4, 21, 46,  4 }, {     66,  -19,    4, 21, 46,  4 },
    {     67,  -20,    4, 21, 46,  4 }, {     68,  -21,    4, 21, 46,  4 }, {     68,  -22,    3, 21, 46,  4 }, {     69,  -23,    3, 21, 46,  4 }, {     70,  -24,    3, 21, 46,  4 },
    {     70,  -25,    3, 21, 46,  4 }, {     71,  -26,    3, 22, 46,  4 }, {     71,  -27,    3, 22, 46,  4 }, {     72,  -28,    3, 22, 46,  4 }, {     72,  -29,    3, 22, 46,  4 },
    {     73,  -30,    3, 22, 46,  4 }, {     73,  -31,    3, 22, 46,  4 }, {     74,  -32,    3, 22, 46,  4 }, {     74,  -33,    3, 22, 46,  4 }, {     75,  -34,    3, 22, 46,  4 },
    {     75,  -35,    3, 22, 46,  4 }, {     75,  -36,    3, 22, 46,  4 }, {     76,  -37,    2, 22, 46,  4 }, {     76,  -38,    2, 22, 46,  4 }, {     76,  -39,    2, 22, 46,  4 },
    {     77,  -40,    2, 23, 46,  4 }, {     77,  -41,    2, 23, 46,  4 }, {     77,  -42,    2, 23, 46,  4 }, {     77,  -43,    2, 23, 46,  4 }, {     78,  -44,    2, 23, 46,  4 },
    {     78,  -45,    2, 23, 46,  4 }, {     78,  -46,    2, 23, 46,  4 }, {     78,  -47,    2, 23, 46,  4 }, {     78,  -48,    2, 23, 46,  4 }, {     79,  -49,    2, 23, 46,  4 },
    {     79,  -50,    2, 23, 46,  4 }, {     79,  -51,    1, 23, 46,  4 }, {     79,  -52,    1, 23, 46,  4 }, {     79,  -53,    1, 23, 46,  4 }, {     79,  -54,    1, 23, 46,  4 },
    {     80,  -55,    1, 23, 46,  4 }, {     80,  -56,    1, 24, 46,  4 }, {     80,  -57,    1, 24, 46,  4 }, {     80,  -58,    1, 24, 46,  4 }, {     80,  -59,    1, 24, 46,  4 },
    {     80,  -60,    1, 24, 46,  4 }, {     80,  -61,    1, 24, 46,  4 }, {     80,  -62,    1, 24, 46,  4 }, {     80,  -63,    1, 24, 46,  4 }, {     80,  -64,    1, 24, 46,  4 },
    {     80,  -65,    0, 24, 46,  4 }, {     80,  -66,    0, 24, 46,  4 }, {     80,  -67,    0, 24, 46,  4 }, {     80,  -68,    0, 24, 46,  4 }, {     80,  -69,    0, 24, 46,  4 },
    {     80,  -70,    0, 24, 46,  4 }, {     80,  -71,    0, 24, 46,  4 }, {     80,  -72,    0, 25, 46,  4 }, {     79,  -73,    0, 25, 46,  4 }, {     79,  -74,    0, 25, 46,  4 },
    {     79,  -75,    0, 25, 46,  4 }, {     79,  -76,    0, 25, 46,  4 }, {     79,  -77,    0, 25, 46,  4 }, {     79,  -78,    0, 25, 46,  4 }, {     78,  -79,   -1, 25, 46,  4 },
    {     78,  -80,   -1, 25, 46,  4 }, {     78,  -81,   -1, 25, 46,  4 }, {     78,  -82,   -1, 25, 46,  4 }, {     78,  -83,   -1, 25, 46,  4 }, {     77,  -84,   -1, 25, 46,  4 },
    {     77,  -85,   -1, 25, 46,  4 }, {     77,  -86,   -1, 26, 46,  4 }, {     77,  -87,   -1, 26, 46,  4 }, {     76,  -88,   -1, 26, 46,  4 }, {     76,  -89,   -1, 26, 46,  4 },
    {     76,  -90,   -1, 26, 46,  4 }, {     75,  -91,   -1, 26, 46,  4 }, {     75,  -92,   -1, 26, 46,  4 }, {     75,  -93,   -2, 26, 46,  4 }, {     74,  -94,   -2, 26, 46,  4 },
    {     74,  -95,   -2, 26, 46,  4 }, {     73,  -96,   -2, 26, 46,  4 }, {     73,  -97,   -2, 26, 46,  4 }, {     72,  -98,   -2, 26, 46,  4 }, {     72,  -99,   -2, 26, 46,  4 },
    {     71, -100,   -2, 26, 46,  4 }, {     71, -101,   -2, 27, 46,  4 }, {     70, -102,   -2, 27, 46,  4 }, {     70, -103,   -2, 27, 46,  4 }, {     69, -104,   -2, 27, 46,  4 },
    {     68, -105,   -2, 27, 46,  4 }, {     68, -106,   -2, 27, 46,  4 }, {     67, -107,   -3, 27, 46,  4 }, {     66, -108,   -3, 27, 46,  4 }, {     66, -109,   -3, 27, 46,  4 },
    {     65, -110,   -3, 27, 46,  4 }, {     64, -111,   -3, 27, 46,  4 }, {     64, -112,   -3, 27, 46,  4 }, {     63, -113,   -3, 27, 46,  4 }, {     62, -114,   -3, 28, 46,  4 },
    {     61, -115,   -3, 28, 46,  4 }, {     61, -116,   -3, 28, 46,  4 }, {     60, -117,   -3, 28, 46,  4 }, {     59, -118,   -3, 28, 46,  4 }, {     58, -119,   -3, 28, 46,  4 },
    {     57, -120,   -3, 28, 46,  4 }, {     57, -121,   -4, 28, 46,  4 }, {     56, -122,   -4, 28, 46,  4 }, {     55, -123,   -4, 28, 46,  4 }, {     54, -124,   -4, 28, 46,  4 },
    {     53, -125,   -4, 28, 46,  4 }, {     52, -125,   -4, 28, 46,  4 }, {     51, -126,   -4, 29, 46,  4 }, {     50, -127,   -4, 29, 46,  4 }, {     49, -128,   -4, 29, 46,  4 },
    {     48, -128,   -4, 29, 46,  4 }, {     47, -129,   -4, 29, 46,  4 }, {     46, -130,   -4, 29, 46,  4 }, {     45, -130,   -4, 29, 46,  4 }, {     44, -131,   -4, 29, 46,  4 },
    {     43, -132,   -4, 29, 46,  4 }, {     42, -132,   -5, 29, 46,  4 }, {     41, -133,   -5, 29, 46,  4 }, {     40, -134,   -5, 29, 46,  4 }, {     39, -134,   -5, 29, 46,  4 },
    {     38, -135,   -5, 30, 46,  4 }, {     37, -135,   -5, 30, 46,  4 }, {     36, -136,   -5, 30, 46,  4 }, {     35, -136,   -5, 30, 46,  4 }, {     34, -137,   -5, 30, 46,  4 },
    {     33, -137,   -5, 30, 46,  4 }, {     32, -138,   -5, 30, 46,  4 }, {     31, -138,   -5, 30, 46,  4 }, {     30, -139,   -5, 30, 46,  4 }, {     29, -139,   -5, 30, 46,  4 },
    {     28, -139,   -6, 30, 46,  4 }, {     27, -140,   -6, 30, 46,  4 }, {     26, -140,   -6, 30, 46,  4 }, {     25, -140,   -6, 30, 46,  4 }, {     24, -141,   -6, 31, 46,  4 },
    {     23, -141,   -6, 31, 46,  4 }, {     22, -141,   -6, 31, 46,  4 }, {     21, -141,   -6, 31, 46,  4 }, {     20, -142,   -6, 31, 46,  4 }, {     19, -142,   -6, 31, 46,  4 },
    {     18, -142,   -6, 31, 46,  4 }, {     17, -142,   -6, 31, 46,  4 }, {     16, -142,   -6, 31, 46,  4 }, {     15, -143,   -6, 31, 46,  4 }, {     14, -143,   -7, 31, 46,  4 },
    {     13, -143,   -7, 31, 46,  4 }, {     12, -143,   -7, 31, 46,  4 }, {     11, -143,   -7, 31, 46,  4 }, {     10, -143,   -7, 31, 46,  4 }, {      9, -144,   -7, 31, 46,  4 },
    {      8, -144,   -7,  0, 46,  4 }, {      7, -144,   -7,  0, 46,  4 }, {      6, -144,   -7,  0, 46,  4 }, {      5, -144,   -7,  0, 46,  4 }, {      4, -144,   -7,  0, 46,  4 },
    {      3, -144,   -7,  0, 46,  4 }, {      2, -144,   -7,  0, 46,  4 }, {      1, -144,   -7,  0, 46,  4 }, {      0, -144,   -8,  0, 46,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8F8485, {
    {     16,   31,    8, 24, 46,  4 }, {     16,   30,    8, 24, 46,  4 }, {     16,   29,    8, 24, 46,  4 }, {     16,   28,    8, 24, 46,  4 }, {     16,   27,    8, 24, 46,  4 },
    {     16,   26,    8, 24, 46,  4 }, {     16,   25,    8, 24, 46,  4 }, {     16,   24,    8, 25, 46,  4 }, {     15,   23,    8, 25, 46,  4 }, {     15,   22,    8, 25, 46,  4 },
    {     15,   21,    8, 25, 46,  4 }, {     15,   20,    8, 25, 46,  4 }, {     15,   19,    8, 25, 46,  4 }, {     15,   18,    8, 25, 46,  4 }, {     14,   17,    7, 25, 46,  4 },
    {     14,   16,    7, 25, 46,  4 }, {     14,   15,    7, 25, 46,  4 }, {     14,   14,    7, 25, 46,  4 }, {     14,   13,    7, 25, 46,  4 }, {     13,   12,    7, 25, 46,  4 },
    {     13,   11,    7, 25, 46,  4 }, {     13,   10,    7, 26, 46,  4 }, {     13,    9,    7, 26, 46,  4 }, {     12,    8,    7, 26, 46,  4 }, {     12,    7,    7, 26, 46,  4 },
    {     12,    6,    7, 26, 46,  4 }, {     11,    5,    7, 26, 46,  4 }, {     11,    4,    7, 26, 46,  4 }, {     11,    3,    6, 26, 46,  4 }, {     10,    2,    6, 26, 46,  4 },
    {     10,    1,    6, 26, 46,  4 }, {      9,    0,    6, 26, 46,  4 }, {      9,   -1,    6, 26, 46,  4 }, {      8,   -2,    6, 26, 46,  4 }, {      8,   -3,    6, 26, 46,  4 },
    {      7,   -4,    6, 26, 46,  4 }, {      7,   -5,    6, 27, 46,  4 }, {      6,   -6,    6, 27, 46,  4 }, {      6,   -7,    6, 27, 46,  4 }, {      5,   -8,    6, 27, 46,  4 },
    {      4,   -9,    6, 27, 46,  4 }, {      4,  -10,    6, 27, 46,  4 }, {      3,  -11,    5, 27, 46,  4 }, {      2,  -12,    5, 27, 46,  4 }, {      2,  -13,    5, 27, 46,  4 },
    {      1,  -14,    5, 27, 46,  4 }, {      0,  -15,    5, 27, 46,  4 }, {      0,  -16,    5, 27, 46,  4 }, {     -1,  -17,    5, 27, 46,  4 }, {     -2,  -18,    5, 28, 46,  4 },
    {     -3,  -19,    5, 28, 46,  4 }, {     -3,  -20,    5, 28, 46,  4 }, {     -4,  -21,    5, 28, 46,  4 }, {     -5,  -22,    5, 28, 46,  4 }, {     -6,  -23,    5, 28, 46,  4 },
    {     -7,  -24,    5, 28, 46,  4 }, {     -7,  -25,    4, 28, 46,  4 }, {     -8,  -26,    4, 28, 46,  4 }, {     -9,  -27,    4, 28, 46,  4 }, {    -10,  -28,    4, 28, 46,  4 },
    {    -11,  -29,    4, 28, 46,  4 }, {    -12,  -29,    4, 28, 46,  4 }, {    -13,  -30,    4, 29, 46,  4 }, {    -14,  -31,    4, 29, 46,  4 }, {    -15,  -32,    4, 29, 46,  4 },
    {    -16,  -32,    4, 29, 46,  4 }, {    -17,  -33,    4, 29, 46,  4 }, {    -18,  -34,    4, 29, 46,  4 }, {    -19,  -34,    4, 29, 46,  4 }, {    -20,  -35,    4, 29, 46,  4 },
    {    -21,  -36,    4, 29, 46,  4 }, {    -22,  -36,    3, 29, 46,  4 }, {    -23,  -37,    3, 29, 46,  4 }, {    -24,  -38,    3, 29, 46,  4 }, {    -25,  -38,    3, 29, 46,  4 },
    {    -26,  -39,    3, 30, 46,  4 }, {    -27,  -39,    3, 30, 46,  4 }, {    -28,  -40,    3, 30, 46,  4 }, {    -29,  -40,    3, 30, 46,  4 }, {    -30,  -41,    3, 30, 46,  4 },
    {    -31,  -41,    3, 30, 46,  4 }, {    -32,  -42,    3, 30, 46,  4 }, {    -33,  -42,    3, 30, 46,  4 }, {    -34,  -43,    3, 30, 46,  4 }, {    -35,  -43,    3, 30, 46,  4 },
    {    -36,  -43,    2, 30, 46,  4 }, {    -37,  -44,    2, 30, 46,  4 }, {    -38,  -44,    2, 30, 46,  4 }, {    -39,  -44,    2, 30, 46,  4 }, {    -40,  -45,    2, 31, 46,  4 },
    {    -41,  -45,    2, 31, 46,  4 }, {    -42,  -45,    2, 31, 46,  4 }, {    -43,  -45,    2, 31, 46,  4 }, {    -44,  -46,    2, 31, 46,  4 }, {    -45,  -46,    2, 31, 46,  4 },
    {    -46,  -46,    2, 31, 46,  4 }, {    -47,  -46,    2, 31, 46,  4 }, {    -48,  -46,    2, 31, 46,  4 }, {    -49,  -47,    2, 31, 46,  4 }, {    -50,  -47,    1, 31, 46,  4 },
    {    -51,  -47,    1, 31, 46,  4 }, {    -52,  -47,    1, 31, 46,  4 }, {    -53,  -47,    1, 31, 46,  4 }, {    -54,  -47,    1, 31, 46,  4 }, {    -55,  -48,    1, 31, 46,  4 },
    {    -56,  -48,    1,  0, 46,  4 }, {    -57,  -48,    1,  0, 46,  4 }, {    -58,  -48,    1,  0, 46,  4 }, {    -59,  -48,    1,  0, 46,  4 }, {    -60,  -48,    1,  0, 46,  4 },
    {    -61,  -48,    1,  0, 46,  4 }, {    -62,  -48,    1,  0, 46,  4 }, {    -63,  -48,    1,  0, 46,  4 }, {    -64,  -48,    0,  0, 46,  4 }, {    -65,  -48,    0,  0, 46,  4 },
    {    -66,  -48,    0,  0, 46,  4 }, {    -67,  -48,    0,  0, 46,  4 }, {    -68,  -48,    0,  0, 46,  4 }, {    -69,  -48,    0,  0, 46,  4 }, {    -70,  -48,    0,  0, 46,  4 },
    {    -71,  -48,    0,  0, 46,  4 }, {    -72,  -48,    0,  1, 46,  4 }, {    -73,  -47,    0,  1, 46,  4 }, {    -74,  -47,    0,  1, 46,  4 }, {    -75,  -47,    0,  1, 46,  4 },
    {    -76,  -47,    0,  1, 46,  4 }, {    -77,  -47,    0,  1, 46,  4 }, {    -78,  -47,    0,  1, 46,  4 }, {    -79,  -46,   -1,  1, 46,  4 }, {    -80,  -46,   -1,  1, 46,  4 },
    {    -81,  -46,   -1,  1, 46,  4 }, {    -82,  -46,   -1,  1, 46,  4 }, {    -83,  -46,   -1,  1, 46,  4 }, {    -84,  -45,   -1,  1, 46,  4 }, {    -85,  -45,   -1,  1, 46,  4 },
    {    -86,  -45,   -1,  2, 46,  4 }, {    -87,  -45,   -1,  2, 46,  4 }, {    -88,  -44,   -1,  2, 46,  4 }, {    -89,  -44,   -1,  2, 46,  4 }, {    -90,  -44,   -1,  2, 46,  4 },
    {    -91,  -43,   -1,  2, 46,  4 }, {    -92,  -43,   -1,  2, 46,  4 }, {    -93,  -43,   -2,  2, 46,  4 }, {    -94,  -42,   -2,  2, 46,  4 }, {    -95,  -42,   -2,  2, 46,  4 },
    {    -96,  -41,   -2,  2, 46,  4 }, {    -97,  -41,   -2,  2, 46,  4 }, {    -98,  -40,   -2,  2, 46,  4 }, {    -99,  -40,   -2,  2, 46,  4 }, {   -100,  -39,   -2,  2, 46,  4 },
    {   -101,  -39,   -2,  3, 46,  4 }, {   -102,  -38,   -2,  3, 46,  4 }, {   -103,  -38,   -2,  3, 46,  4 }, {   -104,  -37,   -2,  3, 46,  4 }, {   -105,  -36,   -2,  3, 46,  4 },
    {   -106,  -36,   -2,  3, 46,  4 }, {   -107,  -35,   -3,  3, 46,  4 }, {   -108,  -34,   -3,  3, 46,  4 }, {   -109,  -34,   -3,  3, 46,  4 }, {   -110,  -33,   -3,  3, 46,  4 },
    {   -111,  -32,   -3,  3, 46,  4 }, {   -112,  -32,   -3,  3, 46,  4 }, {   -113,  -31,   -3,  3, 46,  4 }, {   -114,  -30,   -3,  4, 46,  4 }, {   -115,  -29,   -3,  4, 46,  4 },
    {   -116,  -29,   -3,  4, 46,  4 }, {   -117,  -28,   -3,  4, 46,  4 }, {   -118,  -27,   -3,  4, 46,  4 }, {   -119,  -26,   -3,  4, 46,  4 }, {   -120,  -25,   -3,  4, 46,  4 },
    {   -121,  -25,   -4,  4, 46,  4 }, {   -122,  -24,   -4,  4, 46,  4 }, {   -123,  -23,   -4,  4, 46,  4 }, {   -124,  -22,   -4,  4, 46,  4 }, {   -125,  -21,   -4,  4, 46,  4 },
    {   -125,  -20,   -4,  4, 46,  4 }, {   -126,  -19,   -4,  5, 46,  4 }, {   -127,  -18,   -4,  5, 46,  4 }, {   -128,  -17,   -4,  5, 46,  4 }, {   -128,  -16,   -4,  5, 46,  4 },
    {   -129,  -15,   -4,  5, 46,  4 }, {   -130,  -14,   -4,  5, 46,  4 }, {   -130,  -13,   -4,  5, 46,  4 }, {   -131,  -12,   -4,  5, 46,  4 }, {   -132,  -11,   -5,  5, 46,  4 },
    {   -132,  -10,   -5,  5, 46,  4 }, {   -133,   -9,   -5,  5, 46,  4 }, {   -134,   -8,   -5,  5, 46,  4 }, {   -134,   -7,   -5,  5, 46,  4 }, {   -135,   -6,   -5,  6, 46,  4 },
    {   -135,   -5,   -5,  6, 46,  4 }, {   -136,   -4,   -5,  6, 46,  4 }, {   -136,   -3,   -5,  6, 46,  4 }, {   -137,   -2,   -5,  6, 46,  4 }, {   -137,   -1,   -5,  6, 46,  4 },
    {   -138,    0,   -5,  6, 46,  4 }, {   -138,    1,   -5,  6, 46,  4 }, {   -139,    2,   -5,  6, 46,  4 }, {   -139,    3,   -6,  6, 46,  4 }, {   -139,    4,   -6,  6, 46,  4 },
    {   -140,    5,   -6,  6, 46,  4 }, {   -140,    6,   -6,  6, 46,  4 }, {   -140,    7,   -6,  6, 46,  4 }, {   -141,    8,   -6,  7, 46,  4 }, {   -141,    9,   -6,  7, 46,  4 },
    {   -141,   10,   -6,  7, 46,  4 }, {   -141,   11,   -6,  7, 46,  4 }, {   -142,   12,   -6,  7, 46,  4 }, {   -142,   13,   -6,  7, 46,  4 }, {   -142,   14,   -6,  7, 46,  4 },
    {   -142,   15,   -6,  7, 46,  4 }, {   -142,   16,   -6,  7, 46,  4 }, {   -143,   17,   -7,  7, 46,  4 }, {   -143,   18,   -7,  7, 46,  4 }, {   -143,   19,   -7,  7, 46,  4 },
    {   -143,   20,   -7,  7, 46,  4 }, {   -143,   21,   -7,  7, 46,  4 }, {   -143,   22,   -7,  7, 46,  4 }, {   -144,   23,   -7,  7, 46,  4 }, {   -144,   24,   -7,  8, 46,  4 },
    {   -144,   25,   -7,  8, 46,  4 }, {   -144,   26,   -7,  8, 46,  4 }, {   -144,   27,   -7,  8, 46,  4 }, {   -144,   28,   -7,  8, 46,  4 }, {   -144,   29,   -7,  8, 46,  4 },
    {   -144,   30,   -7,  8, 46,  4 }, {   -144,   31,   -8,  8, 46,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E402E, {
    {     31,   16,    0,  0,  4,  0 }, {     31,   16,    1,  0,  4,  0 }, {     30,   16,    2,  0,  4,  0 }, {     30,   16,    3,  0,  4,  0 }, {     30,   16,    4,  0,  4,  0 },
    {     29,   16,    5, 31,  4,  0 }, {     29,   16,    6, 31,  4,  0 }, {     28,   15,    7, 31,  4,  0 }, {     28,   15,    8, 31,  4,  0 }, {     28,   15,    9, 31,  4,  0 },
    {     27,   15,   10, 30,  4,  0 }, {     27,   15,   11, 30,  4,  0 }, {     27,   15,   12, 30,  4,  0 }, {     26,   15,   13, 30,  4,  0 }, {     26,   15,   14, 30,  4,  0 },
    {     26,   15,   15, 30,  4,  0 }, {     25,   14,   16, 30,  4,  0 }, {     25,   14,   17, 30,  4,  0 }, {     25,   14,   18, 30,  4,  0 }, {     24,   14,   19, 29,  4,  0 },
    {     24,   14,   20, 29,  4,  0 }, {     24,   14,   21, 29,  4,  0 }, {     23,   13,   22, 29,  4,  0 }, {     23,   13,   23, 29,  4,  0 }, {     23,   13,   24, 29,  4,  0 },
    {     22,   12,   25, 28,  4,  0 }, {     22,   12,   26, 28,  4,  0 }, {     22,   12,   27, 28,  4,  0 }, {     21,   11,   28, 28,  4,  0 }, {     21,   11,   29, 28,  4,  0 },
    {     21,   11,   30, 28,  4,  0 }, {     20,   10,   31, 28,  4,  0 }, {     20,   10,   32, 28,  4,  0 }, {     20,   10,   33, 28,  4,  0 }, {     19,    9,   34, 27,  4,  0 },
    {     19,    9,   35, 27,  4,  0 }, {     19,    9,   36, 27,  4,  0 }, {     18,    8,   37, 27,  4,  0 }, {     18,    8,   38, 27,  4,  0 }, {     18,    8,   39, 27,  4,  0 },
    {     18,    7,   40, 26,  4,  0 }, {     18,    7,   41, 26,  4,  0 }, {     18,    7,   42, 26,  4,  0 }, {     17,    6,   43, 26,  4,  0 }, {     17,    6,   44, 26,  4,  0 },
    {     17,    6,   45, 26,  4,  0 }, {     17,    5,   46, 26,  4,  0 }, {     17,    5,   47, 26,  4,  0 }, {     17,    5,   48, 26,  4,  0 }, {     17,    4,   49, 25,  4,  0 },
    {     17,    4,   50, 25,  4,  0 }, {     17,    4,   51, 25,  4,  0 }, {     16,    3,   52, 25,  4,  0 }, {     16,    3,   53, 25,  4,  0 }, {     16,    3,   54, 25,  4,  0 },
    {     16,    2,   55, 24,  4,  0 }, {     16,    2,   56, 24,  4,  0 }, {     16,    2,   57, 24,  4,  0 }, {     16,    1,   58, 24,  4,  0 }, {     16,    1,   59, 24,  4,  0 },
    {     16,    1,   60, 24,  4,  0 }, {     16,    0,   61, 24,  4,  0 }, {     16,    0,   62, 24,  4,  0 }, {     16,    0,   63, 24,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E4270, {
    {     16,    0,    0,  8,  4,  0 }, {     16,    0,    1,  8,  4,  0 }, {     16,    1,    2,  8,  4,  0 }, {     16,    1,    3,  8,  4,  0 }, {     16,    2,    4,  8,  4,  0 },
    {     16,    2,    5,  8,  4,  0 }, {     16,    3,    6,  7,  4,  0 }, {     16,    3,    7,  7,  4,  0 }, {     15,    4,    8,  7,  4,  0 }, {     15,    4,    9,  7,  4,  0 },
    {     15,    4,   10,  7,  4,  0 }, {     15,    5,   11,  6,  4,  0 }, {     15,    5,   12,  6,  4,  0 }, {     15,    5,   13,  6,  4,  0 }, {     15,    6,   14,  6,  4,  0 },
    {     15,    6,   15,  6,  4,  0 }, {     15,    6,   16,  6,  4,  0 }, {     14,    7,   17,  6,  4,  0 }, {     14,    7,   18,  6,  4,  0 }, {     14,    7,   19,  6,  4,  0 },
    {     14,    8,   20,  5,  4,  0 }, {     14,    8,   21,  5,  4,  0 }, {     13,    9,   22,  5,  4,  0 }, {     13,    9,   23,  5,  4,  0 }, {     13,    9,   24,  5,  4,  0 },
    {     12,   10,   25,  4,  4,  0 }, {     12,   10,   26,  4,  4,  0 }, {     12,   10,   27,  4,  4,  0 }, {     11,   11,   28,  4,  4,  0 }, {     11,   11,   29,  4,  4,  0 },
    {     11,   11,   30,  4,  4,  0 }, {     10,   12,   31,  4,  4,  0 }, {     10,   12,   32,  4,  4,  0 }, {     10,   12,   33,  4,  4,  0 }, {      9,   13,   34,  3,  4,  0 },
    {      9,   13,   35,  3,  4,  0 }, {      9,   13,   36,  3,  4,  0 }, {      8,   14,   37,  3,  4,  0 }, {      8,   14,   38,  3,  4,  0 }, {      8,   14,   39,  3,  4,  0 },
    {      7,   14,   40,  2,  4,  0 }, {      7,   14,   41,  2,  4,  0 }, {      7,   14,   42,  2,  4,  0 }, {      6,   15,   43,  2,  4,  0 }, {      6,   15,   44,  2,  4,  0 },
    {      6,   15,   45,  2,  4,  0 }, {      5,   15,   46,  2,  4,  0 }, {      5,   15,   47,  2,  4,  0 }, {      5,   15,   48,  2,  4,  0 }, {      4,   15,   49,  1,  4,  0 },
    {      4,   15,   50,  1,  4,  0 }, {      4,   15,   51,  1,  4,  0 }, {      3,   16,   52,  1,  4,  0 }, {      3,   16,   53,  1,  4,  0 }, {      3,   16,   54,  1,  4,  0 },
    {      2,   16,   55,  0,  4,  0 }, {      2,   16,   56,  0,  4,  0 }, {      2,   16,   57,  0,  4,  0 }, {      1,   16,   58,  0,  4,  0 }, {      1,   16,   59,  0,  4,  0 },
    {      1,   16,   60,  0,  4,  0 }, {      0,   16,   61,  0,  4,  0 }, {      0,   16,   62,  0,  4,  0 }, {      0,   16,   63,  0,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E44B2, {
    {      0,   16,    0, 16,  4,  0 }, {      0,   16,    1, 16,  4,  0 }, {      1,   16,    2, 16,  4,  0 }, {      1,   16,    3, 16,  4,  0 }, {      1,   16,    4, 16,  4,  0 },
    {      2,   16,    5, 16,  4,  0 }, {      2,   16,    6, 16,  4,  0 }, {      3,   16,    7, 15,  4,  0 }, {      3,   16,    8, 15,  4,  0 }, {      3,   16,    9, 15,  4,  0 },
    {      4,   17,   10, 15,  4,  0 }, {      4,   17,   11, 15,  4,  0 }, {      4,   17,   12, 15,  4,  0 }, {      5,   17,   13, 14,  4,  0 }, {      5,   17,   14, 14,  4,  0 },
    {      5,   17,   15, 14,  4,  0 }, {      6,   17,   16, 14,  4,  0 }, {      6,   17,   17, 14,  4,  0 }, {      6,   17,   18, 14,  4,  0 }, {      7,   18,   19, 14,  4,  0 },
    {      7,   18,   20, 14,  4,  0 }, {      7,   18,   21, 14,  4,  0 }, {      8,   18,   22, 13,  4,  0 }, {      8,   18,   23, 13,  4,  0 }, {      8,   18,   24, 13,  4,  0 },
    {      9,   19,   25, 13,  4,  0 }, {      9,   19,   26, 13,  4,  0 }, {      9,   19,   27, 13,  4,  0 }, {     10,   20,   28, 12,  4,  0 }, {     10,   20,   29, 12,  4,  0 },
    {     10,   20,   30, 12,  4,  0 }, {     11,   21,   31, 12,  4,  0 }, {     11,   21,   32, 12,  4,  0 }, {     11,   21,   33, 12,  4,  0 }, {     12,   22,   34, 12,  4,  0 },
    {     12,   22,   35, 12,  4,  0 }, {     12,   22,   36, 12,  4,  0 }, {     13,   23,   37, 11,  4,  0 }, {     13,   23,   38, 11,  4,  0 }, {     13,   23,   39, 11,  4,  0 },
    {     14,   24,   40, 11,  4,  0 }, {     14,   24,   41, 11,  4,  0 }, {     14,   24,   42, 11,  4,  0 }, {     14,   25,   43, 10,  4,  0 }, {     14,   25,   44, 10,  4,  0 },
    {     14,   25,   45, 10,  4,  0 }, {     15,   26,   46, 10,  4,  0 }, {     15,   26,   47, 10,  4,  0 }, {     15,   26,   48, 10,  4,  0 }, {     15,   27,   49, 10,  4,  0 },
    {     15,   27,   50, 10,  4,  0 }, {     15,   27,   51, 10,  4,  0 }, {     15,   28,   52,  9,  4,  0 }, {     15,   28,   53,  9,  4,  0 }, {     15,   28,   54,  9,  4,  0 },
    {     16,   29,   55,  9,  4,  0 }, {     16,   29,   56,  9,  4,  0 }, {     16,   29,   57,  9,  4,  0 }, {     16,   30,   58,  8,  4,  0 }, {     16,   30,   59,  8,  4,  0 },
    {     16,   30,   60,  8,  4,  0 }, {     16,   31,   61,  8,  4,  0 }, {     16,   31,   62,  8,  4,  0 }, {     16,   31,   63,  8,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E46F4, {
    {     16,   31,    0, 24,  4,  0 }, {     16,   31,    1, 24,  4,  0 }, {     16,   30,    2, 24,  4,  0 }, {     16,   30,    3, 24,  4,  0 }, {     16,   29,    4, 23,  4,  0 },
    {     16,   29,    5, 23,  4,  0 }, {     17,   28,    6, 23,  4,  0 }, {     17,   28,    7, 23,  4,  0 }, {     17,   28,    8, 23,  4,  0 }, {     17,   27,    9, 22,  4,  0 },
    {     17,   27,   10, 22,  4,  0 }, {     17,   27,   11, 22,  4,  0 }, {     17,   27,   12, 22,  4,  0 }, {     17,   26,   13, 22,  4,  0 }, {     17,   26,   14, 22,  4,  0 },
    {     17,   26,   15, 22,  4,  0 }, {     18,   25,   16, 22,  4,  0 }, {     18,   25,   17, 22,  4,  0 }, {     18,   25,   18, 22,  4,  0 }, {     18,   24,   19, 21,  4,  0 },
    {     18,   24,   20, 21,  4,  0 }, {     18,   24,   21, 21,  4,  0 }, {     19,   23,   22, 21,  4,  0 }, {     19,   23,   23, 21,  4,  0 }, {     19,   23,   24, 21,  4,  0 },
    {     20,   22,   25, 20,  4,  0 }, {     20,   22,   26, 20,  4,  0 }, {     20,   22,   27, 20,  4,  0 }, {     20,   22,   28, 20,  4,  0 }, {     21,   21,   29, 20,  4,  0 },
    {     21,   21,   30, 20,  4,  0 }, {     21,   21,   31, 20,  4,  0 }, {     22,   20,   32, 20,  4,  0 }, {     22,   20,   33, 20,  4,  0 }, {     22,   20,   34, 20,  4,  0 },
    {     23,   19,   35, 19,  4,  0 }, {     23,   19,   36, 19,  4,  0 }, {     23,   19,   37, 19,  4,  0 }, {     24,   18,   38, 19,  4,  0 }, {     24,   18,   39, 19,  4,  0 },
    {     24,   18,   40, 19,  4,  0 }, {     25,   18,   41, 18,  4,  0 }, {     25,   18,   42, 18,  4,  0 }, {     25,   18,   43, 18,  4,  0 }, {     26,   17,   44, 18,  4,  0 },
    {     26,   17,   45, 18,  4,  0 }, {     26,   17,   46, 18,  4,  0 }, {     26,   17,   47, 18,  4,  0 }, {     27,   17,   48, 18,  4,  0 }, {     27,   17,   49, 18,  4,  0 },
    {     27,   17,   50, 18,  4,  0 }, {     28,   17,   51, 17,  4,  0 }, {     28,   17,   52, 17,  4,  0 }, {     28,   17,   53, 17,  4,  0 }, {     29,   16,   54, 17,  4,  0 },
    {     29,   16,   55, 17,  4,  0 }, {     29,   16,   56, 17,  4,  0 }, {     30,   16,   57, 16,  4,  0 }, {     30,   16,   58, 16,  4,  0 }, {     30,   16,   59, 16,  4,  0 },
    {     31,   16,   60, 16,  4,  0 }, {     31,   16,   61, 16,  4,  0 }, {     31,   16,   62, 16,  4,  0 }, {     31,   16,   63, 16,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E4936, {
    {     31,   16,    0,  0,  4,  0 }, {     31,   16,    1,  0,  4,  0 }, {     30,   16,    2,  0,  4,  0 }, {     30,   16,    3,  0,  4,  0 }, {     30,   16,    4,  0,  4,  0 },
    {     29,   16,    5,  1,  4,  0 }, {     29,   16,    6,  1,  4,  0 }, {     29,   16,    7,  1,  4,  0 }, {     28,   17,    8,  1,  4,  0 }, {     28,   17,    9,  1,  4,  0 },
    {     28,   17,   10,  1,  4,  0 }, {     27,   17,   11,  2,  4,  0 }, {     27,   17,   12,  2,  4,  0 }, {     27,   17,   13,  2,  4,  0 }, {     26,   17,   14,  2,  4,  0 },
    {     26,   17,   15,  2,  4,  0 }, {     26,   17,   16,  2,  4,  0 }, {     25,   18,   17,  2,  4,  0 }, {     25,   18,   18,  2,  4,  0 }, {     25,   18,   19,  2,  4,  0 },
    {     24,   18,   20,  3,  4,  0 }, {     24,   18,   21,  3,  4,  0 }, {     24,   18,   22,  3,  4,  0 }, {     23,   19,   23,  3,  4,  0 }, {     23,   19,   24,  3,  4,  0 },
    {     23,   19,   25,  3,  4,  0 }, {     22,   20,   26,  4,  4,  0 }, {     22,   20,   27,  4,  4,  0 }, {     22,   20,   28,  4,  4,  0 }, {     22,   20,   29,  4,  4,  0 },
    {     21,   21,   30,  4,  4,  0 }, {     21,   21,   31,  4,  4,  0 }, {     21,   21,   32,  4,  4,  0 }, {     20,   22,   33,  4,  4,  0 }, {     20,   22,   34,  4,  4,  0 },
    {     20,   22,   35,  4,  4,  0 }, {     19,   23,   36,  5,  4,  0 }, {     19,   23,   37,  5,  4,  0 }, {     19,   23,   38,  5,  4,  0 }, {     18,   24,   39,  5,  4,  0 },
    {     18,   24,   40,  5,  4,  0 }, {     18,   24,   41,  5,  4,  0 }, {     18,   25,   42,  6,  4,  0 }, {     18,   25,   43,  6,  4,  0 }, {     18,   25,   44,  6,  4,  0 },
    {     17,   26,   45,  6,  4,  0 }, {     17,   26,   46,  6,  4,  0 }, {     17,   26,   47,  6,  4,  0 }, {     17,   27,   48,  6,  4,  0 }, {     17,   27,   49,  6,  4,  0 },
    {     17,   27,   50,  6,  4,  0 }, {     17,   28,   51,  7,  4,  0 }, {     17,   28,   52,  7,  4,  0 }, {     17,   28,   53,  7,  4,  0 }, {     16,   29,   54,  7,  4,  0 },
    {     16,   29,   55,  7,  4,  0 }, {     16,   29,   56,  7,  4,  0 }, {     16,   30,   57,  8,  4,  0 }, {     16,   30,   58,  8,  4,  0 }, {     16,   30,   59,  8,  4,  0 },
    {     16,   31,   60,  8,  4,  0 }, {     16,   31,   61,  8,  4,  0 }, {     16,   31,   62,  8,  4,  0 }, {     16,   31,   63,  8,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E4B78, {
    {     16,    0,    0,  8,  4,  0 }, {     16,    0,    1,  8,  4,  0 }, {     16,    1,    2,  8,  4,  0 }, {     16,    1,    3,  8,  4,  0 }, {     16,    2,    4,  8,  4,  0 },
    {     16,    2,    5,  8,  4,  0 }, {     16,    3,    6,  9,  4,  0 }, {     16,    3,    7,  9,  4,  0 }, {     17,    4,    8,  9,  4,  0 }, {     17,    4,    9,  9,  4,  0 },
    {     17,    4,   10,  9,  4,  0 }, {     17,    5,   11, 10,  4,  0 }, {     17,    5,   12, 10,  4,  0 }, {     17,    5,   13, 10,  4,  0 }, {     17,    6,   14, 10,  4,  0 },
    {     17,    6,   15, 10,  4,  0 }, {     17,    6,   16, 10,  4,  0 }, {     18,    7,   17, 10,  4,  0 }, {     18,    7,   18, 10,  4,  0 }, {     18,    7,   19, 10,  4,  0 },
    {     18,    8,   20, 11,  4,  0 }, {     18,    8,   21, 11,  4,  0 }, {     18,    8,   22, 11,  4,  0 }, {     18,    8,   23, 11,  4,  0 }, {     19,    9,   24, 11,  4,  0 },
    {     19,    9,   25, 11,  4,  0 }, {     19,    9,   26, 11,  4,  0 }, {     20,   10,   27, 12,  4,  0 }, {     20,   10,   28, 12,  4,  0 }, {     20,   10,   29, 12,  4,  0 },
    {     21,   11,   30, 12,  4,  0 }, {     21,   11,   31, 12,  4,  0 }, {     21,   11,   32, 12,  4,  0 }, {     22,   12,   33, 12,  4,  0 }, {     22,   12,   34, 12,  4,  0 },
    {     22,   12,   35, 12,  4,  0 }, {     23,   13,   36, 13,  4,  0 }, {     23,   13,   37, 13,  4,  0 }, {     23,   13,   38, 13,  4,  0 }, {     24,   14,   39, 13,  4,  0 },
    {     24,   14,   40, 13,  4,  0 }, {     24,   14,   41, 13,  4,  0 }, {     25,   14,   42, 14,  4,  0 }, {     25,   14,   43, 14,  4,  0 }, {     25,   14,   44, 14,  4,  0 },
    {     26,   15,   45, 14,  4,  0 }, {     26,   15,   46, 14,  4,  0 }, {     26,   15,   47, 14,  4,  0 }, {     27,   15,   48, 14,  4,  0 }, {     27,   15,   49, 14,  4,  0 },
    {     27,   15,   50, 14,  4,  0 }, {     28,   15,   51, 15,  4,  0 }, {     28,   15,   52, 15,  4,  0 }, {     28,   15,   53, 15,  4,  0 }, {     29,   16,   54, 15,  4,  0 },
    {     29,   16,   55, 15,  4,  0 }, {     29,   16,   56, 15,  4,  0 }, {     30,   16,   57, 16,  4,  0 }, {     30,   16,   58, 16,  4,  0 }, {     30,   16,   59, 16,  4,  0 },
    {     31,   16,   60, 16,  4,  0 }, {     31,   16,   61, 16,  4,  0 }, {     31,   16,   62, 16,  4,  0 }, {     31,   16,   63, 16,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E4DBA, {
    {      0,   16,    0, 16,  4,  0 }, {      1,   16,    1, 16,  4,  0 }, {      1,   16,    2, 16,  4,  0 }, {      1,   16,    3, 16,  4,  0 }, {      2,   16,    4, 16,  4,  0 },
    {      2,   16,    5, 16,  4,  0 }, {      2,   16,    6, 16,  4,  0 }, {      3,   16,    7, 17,  4,  0 }, {      3,   16,    8, 17,  4,  0 }, {      3,   16,    9, 17,  4,  0 },
    {      4,   15,   10, 17,  4,  0 }, {      4,   15,   11, 17,  4,  0 }, {      4,   15,   12, 17,  4,  0 }, {      5,   15,   13, 18,  4,  0 }, {      5,   15,   14, 18,  4,  0 },
    {      5,   15,   15, 18,  4,  0 }, {      6,   15,   16, 18,  4,  0 }, {      6,   15,   17, 18,  4,  0 }, {      7,   14,   18, 18,  4,  0 }, {      7,   14,   19, 18,  4,  0 },
    {      7,   14,   20, 18,  4,  0 }, {      8,   14,   21, 19,  4,  0 }, {      8,   14,   22, 19,  4,  0 }, {      8,   14,   23, 19,  4,  0 }, {      9,   13,   24, 19,  4,  0 },
    {      9,   13,   25, 19,  4,  0 }, {      9,   13,   26, 19,  4,  0 }, {     10,   12,   27, 20,  4,  0 }, {     10,   12,   28, 20,  4,  0 }, {     10,   12,   29, 20,  4,  0 },
    {     11,   11,   30, 20,  4,  0 }, {     11,   11,   31, 20,  4,  0 }, {     12,   10,   32, 20,  4,  0 }, {     12,   10,   33, 20,  4,  0 }, {     12,   10,   34, 20,  4,  0 },
    {     13,    9,   35, 21,  4,  0 }, {     13,    9,   36, 21,  4,  0 }, {     13,    9,   37, 21,  4,  0 }, {     14,    8,   38, 21,  4,  0 }, {     14,    8,   39, 21,  4,  0 },
    {     14,    8,   40, 21,  4,  0 }, {     14,    7,   41, 22,  4,  0 }, {     14,    7,   42, 22,  4,  0 }, {     14,    7,   43, 22,  4,  0 }, {     15,    6,   44, 22,  4,  0 },
    {     15,    6,   45, 22,  4,  0 }, {     15,    6,   46, 22,  4,  0 }, {     15,    5,   47, 22,  4,  0 }, {     15,    5,   48, 22,  4,  0 }, {     15,    4,   49, 23,  4,  0 },
    {     15,    4,   50, 23,  4,  0 }, {     15,    4,   51, 23,  4,  0 }, {     16,    3,   52, 23,  4,  0 }, {     16,    3,   53, 23,  4,  0 }, {     16,    3,   54, 23,  4,  0 },
    {     16,    2,   55, 24,  4,  0 }, {     16,    2,   56, 24,  4,  0 }, {     16,    2,   57, 24,  4,  0 }, {     16,    1,   58, 24,  4,  0 }, {     16,    1,   59, 24,  4,  0 },
    {     16,    1,   60, 24,  4,  0 }, {     16,    0,   61, 24,  4,  0 }, {     16,    0,   62, 24,  4,  0 }, {     16,    0,   63, 24,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E4FFC, {
    {     16,   31,    0, 24,  4,  0 }, {     16,   31,    1, 24,  4,  0 }, {     16,   30,    2, 24,  4,  0 }, {     16,   30,    3, 24,  4,  0 }, {     16,   29,    4, 25,  4,  0 },
    {     16,   29,    5, 25,  4,  0 }, {     15,   28,    6, 25,  4,  0 }, {     15,   28,    7, 25,  4,  0 }, {     15,   28,    8, 25,  4,  0 }, {     15,   27,    9, 26,  4,  0 },
    {     15,   27,   10, 26,  4,  0 }, {     15,   27,   11, 26,  4,  0 }, {     15,   26,   12, 26,  4,  0 }, {     15,   26,   13, 26,  4,  0 }, {     15,   26,   14, 26,  4,  0 },
    {     14,   25,   15, 26,  4,  0 }, {     14,   25,   16, 26,  4,  0 }, {     14,   25,   17, 26,  4,  0 }, {     14,   24,   18, 27,  4,  0 }, {     14,   24,   19, 27,  4,  0 },
    {     14,   24,   20, 27,  4,  0 }, {     13,   23,   21, 27,  4,  0 }, {     13,   23,   22, 27,  4,  0 }, {     13,   23,   23, 27,  4,  0 }, {     12,   22,   24, 28,  4,  0 },
    {     12,   22,   25, 28,  4,  0 }, {     12,   22,   26, 28,  4,  0 }, {     11,   21,   27, 28,  4,  0 }, {     11,   21,   28, 28,  4,  0 }, {     11,   21,   29, 28,  4,  0 },
    {     10,   20,   30, 28,  4,  0 }, {     10,   20,   31, 28,  4,  0 }, {     10,   20,   32, 28,  4,  0 }, {      9,   19,   33, 29,  4,  0 }, {      9,   19,   34, 29,  4,  0 },
    {      9,   19,   35, 29,  4,  0 }, {      8,   18,   36, 29,  4,  0 }, {      8,   18,   37, 29,  4,  0 }, {      8,   18,   38, 29,  4,  0 }, {      7,   18,   39, 30,  4,  0 },
    {      7,   18,   40, 30,  4,  0 }, {      7,   18,   41, 30,  4,  0 }, {      6,   17,   42, 30,  4,  0 }, {      6,   17,   43, 30,  4,  0 }, {      6,   17,   44, 30,  4,  0 },
    {      5,   17,   45, 30,  4,  0 }, {      5,   17,   46, 30,  4,  0 }, {      5,   17,   47, 30,  4,  0 }, {      4,   17,   48, 31,  4,  0 }, {      4,   17,   49, 31,  4,  0 },
    {      4,   17,   50, 31,  4,  0 }, {      3,   16,   51, 31,  4,  0 }, {      3,   16,   52, 31,  4,  0 }, {      3,   16,   53, 31,  4,  0 }, {      2,   16,   54,  0,  4,  0 },
    {      2,   16,   55,  0,  4,  0 }, {      2,   16,   56,  0,  4,  0 }, {      1,   16,   57,  0,  4,  0 }, {      1,   16,   58,  0,  4,  0 }, {      1,   16,   59,  0,  4,  0 },
    {      0,   16,   60,  0,  4,  0 }, {      0,   16,   61,  0,  4,  0 }, {      0,   16,   62,  0,  4,  0 }, {      0,   16,   63,  0,  4,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E523E, {
    {     31,   16,   63,  0,  8,  0 }, {     31,   16,   62,  0,  8,  0 }, {     30,   16,   61,  0,  8,  0 }, {     30,   16,   60,  0,  8,  0 }, {     30,   16,   59,  0,  8,  0 },
    {     29,   16,   58, 31,  8,  0 }, {     29,   16,   57, 31,  8,  0 }, {     28,   15,   56, 31,  8,  0 }, {     28,   15,   55, 31,  8,  0 }, {     28,   15,   54, 31,  8,  0 },
    {     27,   15,   53, 30,  8,  0 }, {     27,   15,   52, 30,  8,  0 }, {     27,   15,   51, 30,  8,  0 }, {     26,   15,   50, 30,  8,  0 }, {     26,   15,   49, 30,  8,  0 },
    {     26,   15,   48, 30,  8,  0 }, {     25,   14,   47, 30,  8,  0 }, {     25,   14,   46, 30,  8,  0 }, {     25,   14,   45, 30,  8,  0 }, {     24,   14,   44, 29,  8,  0 },
    {     24,   14,   43, 29,  8,  0 }, {     24,   14,   42, 29,  8,  0 }, {     23,   13,   41, 29,  8,  0 }, {     23,   13,   40, 29,  8,  0 }, {     23,   13,   39, 29,  8,  0 },
    {     22,   12,   38, 28,  8,  0 }, {     22,   12,   37, 28,  8,  0 }, {     22,   12,   36, 28,  8,  0 }, {     21,   11,   35, 28,  8,  0 }, {     21,   11,   34, 28,  8,  0 },
    {     21,   11,   33, 28,  8,  0 }, {     20,   10,   32, 28,  8,  0 }, {     20,   10,   31, 28,  8,  0 }, {     20,   10,   30, 28,  8,  0 }, {     19,    9,   29, 27,  8,  0 },
    {     19,    9,   28, 27,  8,  0 }, {     19,    9,   27, 27,  8,  0 }, {     18,    8,   26, 27,  8,  0 }, {     18,    8,   25, 27,  8,  0 }, {     18,    8,   24, 27,  8,  0 },
    {     18,    7,   23, 26,  8,  0 }, {     18,    7,   22, 26,  8,  0 }, {     18,    7,   21, 26,  8,  0 }, {     17,    6,   20, 26,  8,  0 }, {     17,    6,   19, 26,  8,  0 },
    {     17,    6,   18, 26,  8,  0 }, {     17,    5,   17, 26,  8,  0 }, {     17,    5,   16, 26,  8,  0 }, {     17,    5,   15, 26,  8,  0 }, {     17,    4,   14, 25,  8,  0 },
    {     17,    4,   13, 25,  8,  0 }, {     17,    4,   12, 25,  8,  0 }, {     16,    3,   11, 25,  8,  0 }, {     16,    3,   10, 25,  8,  0 }, {     16,    3,    9, 25,  8,  0 },
    {     16,    2,    8, 24,  8,  0 }, {     16,    2,    7, 24,  8,  0 }, {     16,    2,    6, 24,  8,  0 }, {     16,    1,    5, 24,  8,  0 }, {     16,    1,    4, 24,  8,  0 },
    {     16,    1,    3, 24,  8,  0 }, {     16,    0,    2, 24,  8,  0 }, {     16,    0,    1, 24,  8,  0 }, {     16,    0,    0, 24,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E5480, {
    {     16,    0,   63,  8,  8,  0 }, {     16,    0,   62,  8,  8,  0 }, {     16,    1,   61,  8,  8,  0 }, {     16,    1,   60,  8,  8,  0 }, {     16,    2,   59,  8,  8,  0 },
    {     16,    2,   58,  8,  8,  0 }, {     16,    3,   57,  7,  8,  0 }, {     16,    3,   56,  7,  8,  0 }, {     15,    4,   55,  7,  8,  0 }, {     15,    4,   54,  7,  8,  0 },
    {     15,    4,   53,  7,  8,  0 }, {     15,    5,   52,  6,  8,  0 }, {     15,    5,   51,  6,  8,  0 }, {     15,    5,   50,  6,  8,  0 }, {     15,    6,   49,  6,  8,  0 },
    {     15,    6,   48,  6,  8,  0 }, {     15,    6,   47,  6,  8,  0 }, {     14,    7,   46,  6,  8,  0 }, {     14,    7,   45,  6,  8,  0 }, {     14,    7,   44,  6,  8,  0 },
    {     14,    8,   43,  5,  8,  0 }, {     14,    8,   42,  5,  8,  0 }, {     13,    9,   41,  5,  8,  0 }, {     13,    9,   40,  5,  8,  0 }, {     13,    9,   39,  5,  8,  0 },
    {     12,   10,   38,  4,  8,  0 }, {     12,   10,   37,  4,  8,  0 }, {     12,   10,   36,  4,  8,  0 }, {     11,   11,   35,  4,  8,  0 }, {     11,   11,   34,  4,  8,  0 },
    {     11,   11,   33,  4,  8,  0 }, {     10,   12,   32,  4,  8,  0 }, {     10,   12,   31,  4,  8,  0 }, {     10,   12,   30,  4,  8,  0 }, {      9,   13,   29,  3,  8,  0 },
    {      9,   13,   28,  3,  8,  0 }, {      9,   13,   27,  3,  8,  0 }, {      8,   14,   26,  3,  8,  0 }, {      8,   14,   25,  3,  8,  0 }, {      8,   14,   24,  3,  8,  0 },
    {      7,   14,   23,  2,  8,  0 }, {      7,   14,   22,  2,  8,  0 }, {      7,   14,   21,  2,  8,  0 }, {      6,   15,   20,  2,  8,  0 }, {      6,   15,   19,  2,  8,  0 },
    {      6,   15,   18,  2,  8,  0 }, {      5,   15,   17,  2,  8,  0 }, {      5,   15,   16,  2,  8,  0 }, {      5,   15,   15,  2,  8,  0 }, {      4,   15,   14,  1,  8,  0 },
    {      4,   15,   13,  1,  8,  0 }, {      4,   15,   12,  1,  8,  0 }, {      3,   16,   11,  1,  8,  0 }, {      3,   16,   10,  1,  8,  0 }, {      3,   16,    9,  1,  8,  0 },
    {      2,   16,    8,  0,  8,  0 }, {      2,   16,    7,  0,  8,  0 }, {      2,   16,    6,  0,  8,  0 }, {      1,   16,    5,  0,  8,  0 }, {      1,   16,    4,  0,  8,  0 },
    {      1,   16,    3,  0,  8,  0 }, {      0,   16,    2,  0,  8,  0 }, {      0,   16,    1,  0,  8,  0 }, {      0,   16,    0,  0,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E56C2, {
    {      0,   16,   63, 16,  8,  0 }, {      0,   16,   62, 16,  8,  0 }, {      1,   16,   61, 16,  8,  0 }, {      1,   16,   60, 16,  8,  0 }, {      1,   16,   59, 16,  8,  0 },
    {      2,   16,   58, 16,  8,  0 }, {      2,   16,   57, 16,  8,  0 }, {      3,   16,   56, 15,  8,  0 }, {      3,   16,   55, 15,  8,  0 }, {      3,   16,   54, 15,  8,  0 },
    {      4,   17,   53, 15,  8,  0 }, {      4,   17,   52, 15,  8,  0 }, {      4,   17,   51, 15,  8,  0 }, {      5,   17,   50, 14,  8,  0 }, {      5,   17,   49, 14,  8,  0 },
    {      5,   17,   48, 14,  8,  0 }, {      6,   17,   47, 14,  8,  0 }, {      6,   17,   46, 14,  8,  0 }, {      6,   17,   45, 14,  8,  0 }, {      7,   18,   44, 14,  8,  0 },
    {      7,   18,   43, 14,  8,  0 }, {      7,   18,   42, 14,  8,  0 }, {      8,   18,   41, 13,  8,  0 }, {      8,   18,   40, 13,  8,  0 }, {      8,   18,   39, 13,  8,  0 },
    {      9,   19,   38, 13,  8,  0 }, {      9,   19,   37, 13,  8,  0 }, {      9,   19,   36, 13,  8,  0 }, {     10,   20,   35, 12,  8,  0 }, {     10,   20,   34, 12,  8,  0 },
    {     10,   20,   33, 12,  8,  0 }, {     11,   21,   32, 12,  8,  0 }, {     11,   21,   31, 12,  8,  0 }, {     11,   21,   30, 12,  8,  0 }, {     12,   22,   29, 12,  8,  0 },
    {     12,   22,   28, 12,  8,  0 }, {     12,   22,   27, 12,  8,  0 }, {     13,   23,   26, 11,  8,  0 }, {     13,   23,   25, 11,  8,  0 }, {     13,   23,   24, 11,  8,  0 },
    {     14,   24,   23, 11,  8,  0 }, {     14,   24,   22, 11,  8,  0 }, {     14,   24,   21, 11,  8,  0 }, {     14,   25,   20, 10,  8,  0 }, {     14,   25,   19, 10,  8,  0 },
    {     14,   25,   18, 10,  8,  0 }, {     15,   26,   17, 10,  8,  0 }, {     15,   26,   16, 10,  8,  0 }, {     15,   26,   15, 10,  8,  0 }, {     15,   27,   14, 10,  8,  0 },
    {     15,   27,   13, 10,  8,  0 }, {     15,   27,   12, 10,  8,  0 }, {     15,   28,   11,  9,  8,  0 }, {     15,   28,   10,  9,  8,  0 }, {     15,   28,    9,  9,  8,  0 },
    {     16,   29,    8,  9,  8,  0 }, {     16,   29,    7,  9,  8,  0 }, {     16,   29,    6,  9,  8,  0 }, {     16,   30,    5,  8,  8,  0 }, {     16,   30,    4,  8,  8,  0 },
    {     16,   30,    3,  8,  8,  0 }, {     16,   31,    2,  8,  8,  0 }, {     16,   31,    1,  8,  8,  0 }, {     16,   31,    0,  8,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E5904, {
    {     16,   31,   63, 24,  8,  0 }, {     16,   31,   62, 24,  8,  0 }, {     16,   30,   61, 24,  8,  0 }, {     16,   30,   60, 24,  8,  0 }, {     16,   29,   59, 23,  8,  0 },
    {     16,   29,   58, 23,  8,  0 }, {     17,   28,   57, 23,  8,  0 }, {     17,   28,   56, 23,  8,  0 }, {     17,   28,   55, 23,  8,  0 }, {     17,   27,   54, 22,  8,  0 },
    {     17,   27,   53, 22,  8,  0 }, {     17,   27,   52, 22,  8,  0 }, {     17,   27,   51, 22,  8,  0 }, {     17,   26,   50, 22,  8,  0 }, {     17,   26,   49, 22,  8,  0 },
    {     17,   26,   48, 22,  8,  0 }, {     18,   25,   47, 22,  8,  0 }, {     18,   25,   46, 22,  8,  0 }, {     18,   25,   45, 22,  8,  0 }, {     18,   24,   44, 21,  8,  0 },
    {     18,   24,   43, 21,  8,  0 }, {     18,   24,   42, 21,  8,  0 }, {     19,   23,   41, 21,  8,  0 }, {     19,   23,   40, 21,  8,  0 }, {     19,   23,   39, 21,  8,  0 },
    {     20,   22,   38, 20,  8,  0 }, {     20,   22,   37, 20,  8,  0 }, {     20,   22,   36, 20,  8,  0 }, {     20,   22,   35, 20,  8,  0 }, {     21,   21,   34, 20,  8,  0 },
    {     21,   21,   33, 20,  8,  0 }, {     21,   21,   32, 20,  8,  0 }, {     22,   20,   31, 20,  8,  0 }, {     22,   20,   30, 20,  8,  0 }, {     22,   20,   29, 20,  8,  0 },
    {     23,   19,   28, 19,  8,  0 }, {     23,   19,   27, 19,  8,  0 }, {     23,   19,   26, 19,  8,  0 }, {     24,   18,   25, 19,  8,  0 }, {     24,   18,   24, 19,  8,  0 },
    {     24,   18,   23, 19,  8,  0 }, {     25,   18,   22, 18,  8,  0 }, {     25,   18,   21, 18,  8,  0 }, {     25,   18,   20, 18,  8,  0 }, {     26,   17,   19, 18,  8,  0 },
    {     26,   17,   18, 18,  8,  0 }, {     26,   17,   17, 18,  8,  0 }, {     26,   17,   16, 18,  8,  0 }, {     27,   17,   15, 18,  8,  0 }, {     27,   17,   14, 18,  8,  0 },
    {     27,   17,   13, 18,  8,  0 }, {     28,   17,   12, 17,  8,  0 }, {     28,   17,   11, 17,  8,  0 }, {     28,   17,   10, 17,  8,  0 }, {     29,   16,    9, 17,  8,  0 },
    {     29,   16,    8, 17,  8,  0 }, {     29,   16,    7, 17,  8,  0 }, {     30,   16,    6, 16,  8,  0 }, {     30,   16,    5, 16,  8,  0 }, {     30,   16,    4, 16,  8,  0 },
    {     31,   16,    3, 16,  8,  0 }, {     31,   16,    2, 16,  8,  0 }, {     31,   16,    1, 16,  8,  0 }, {     31,   16,    0, 16,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E5B46, {
    {     31,   16,   63,  0,  8,  0 }, {     31,   16,   62,  0,  8,  0 }, {     30,   16,   61,  0,  8,  0 }, {     30,   16,   60,  0,  8,  0 }, {     30,   16,   59,  0,  8,  0 },
    {     29,   16,   58,  1,  8,  0 }, {     29,   16,   57,  1,  8,  0 }, {     29,   16,   56,  1,  8,  0 }, {     28,   17,   55,  1,  8,  0 }, {     28,   17,   54,  1,  8,  0 },
    {     28,   17,   53,  1,  8,  0 }, {     27,   17,   52,  2,  8,  0 }, {     27,   17,   51,  2,  8,  0 }, {     27,   17,   50,  2,  8,  0 }, {     26,   17,   49,  2,  8,  0 },
    {     26,   17,   48,  2,  8,  0 }, {     26,   17,   47,  2,  8,  0 }, {     25,   18,   46,  2,  8,  0 }, {     25,   18,   45,  2,  8,  0 }, {     25,   18,   44,  2,  8,  0 },
    {     24,   18,   43,  3,  8,  0 }, {     24,   18,   42,  3,  8,  0 }, {     24,   18,   41,  3,  8,  0 }, {     23,   19,   40,  3,  8,  0 }, {     23,   19,   39,  3,  8,  0 },
    {     23,   19,   38,  3,  8,  0 }, {     22,   20,   37,  4,  8,  0 }, {     22,   20,   36,  4,  8,  0 }, {     22,   20,   35,  4,  8,  0 }, {     22,   20,   34,  4,  8,  0 },
    {     21,   21,   33,  4,  8,  0 }, {     21,   21,   32,  4,  8,  0 }, {     21,   21,   31,  4,  8,  0 }, {     20,   22,   30,  4,  8,  0 }, {     20,   22,   29,  4,  8,  0 },
    {     20,   22,   28,  4,  8,  0 }, {     19,   23,   27,  5,  8,  0 }, {     19,   23,   26,  5,  8,  0 }, {     19,   23,   25,  5,  8,  0 }, {     18,   24,   24,  5,  8,  0 },
    {     18,   24,   23,  5,  8,  0 }, {     18,   24,   22,  5,  8,  0 }, {     18,   25,   21,  6,  8,  0 }, {     18,   25,   20,  6,  8,  0 }, {     18,   25,   19,  6,  8,  0 },
    {     17,   26,   18,  6,  8,  0 }, {     17,   26,   17,  6,  8,  0 }, {     17,   26,   16,  6,  8,  0 }, {     17,   27,   15,  6,  8,  0 }, {     17,   27,   14,  6,  8,  0 },
    {     17,   27,   13,  6,  8,  0 }, {     17,   28,   12,  7,  8,  0 }, {     17,   28,   11,  7,  8,  0 }, {     17,   28,   10,  7,  8,  0 }, {     16,   29,    9,  7,  8,  0 },
    {     16,   29,    8,  7,  8,  0 }, {     16,   29,    7,  7,  8,  0 }, {     16,   30,    6,  8,  8,  0 }, {     16,   30,    5,  8,  8,  0 }, {     16,   30,    4,  8,  8,  0 },
    {     16,   31,    3,  8,  8,  0 }, {     16,   31,    2,  8,  8,  0 }, {     16,   31,    1,  8,  8,  0 }, {     16,   31,    0,  8,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E5D88, {
    {     16,    0,   63,  8,  8,  0 }, {     16,    0,   62,  8,  8,  0 }, {     16,    1,   61,  8,  8,  0 }, {     16,    1,   60,  8,  8,  0 }, {     16,    2,   59,  8,  8,  0 },
    {     16,    2,   58,  8,  8,  0 }, {     16,    3,   57,  9,  8,  0 }, {     16,    3,   56,  9,  8,  0 }, {     17,    4,   55,  9,  8,  0 }, {     17,    4,   54,  9,  8,  0 },
    {     17,    4,   53,  9,  8,  0 }, {     17,    5,   52, 10,  8,  0 }, {     17,    5,   51, 10,  8,  0 }, {     17,    5,   50, 10,  8,  0 }, {     17,    6,   49, 10,  8,  0 },
    {     17,    6,   48, 10,  8,  0 }, {     17,    6,   47, 10,  8,  0 }, {     18,    7,   46, 10,  8,  0 }, {     18,    7,   45, 10,  8,  0 }, {     18,    7,   44, 10,  8,  0 },
    {     18,    8,   43, 11,  8,  0 }, {     18,    8,   42, 11,  8,  0 }, {     18,    8,   41, 11,  8,  0 }, {     18,    8,   40, 11,  8,  0 }, {     19,    9,   39, 11,  8,  0 },
    {     19,    9,   38, 11,  8,  0 }, {     19,    9,   37, 11,  8,  0 }, {     20,   10,   36, 12,  8,  0 }, {     20,   10,   35, 12,  8,  0 }, {     20,   10,   34, 12,  8,  0 },
    {     21,   11,   33, 12,  8,  0 }, {     21,   11,   32, 12,  8,  0 }, {     21,   11,   31, 12,  8,  0 }, {     22,   12,   30, 12,  8,  0 }, {     22,   12,   29, 12,  8,  0 },
    {     22,   12,   28, 12,  8,  0 }, {     23,   13,   27, 13,  8,  0 }, {     23,   13,   26, 13,  8,  0 }, {     23,   13,   25, 13,  8,  0 }, {     24,   14,   24, 13,  8,  0 },
    {     24,   14,   23, 13,  8,  0 }, {     24,   14,   22, 13,  8,  0 }, {     25,   14,   21, 14,  8,  0 }, {     25,   14,   20, 14,  8,  0 }, {     25,   14,   19, 14,  8,  0 },
    {     26,   15,   18, 14,  8,  0 }, {     26,   15,   17, 14,  8,  0 }, {     26,   15,   16, 14,  8,  0 }, {     27,   15,   15, 14,  8,  0 }, {     27,   15,   14, 14,  8,  0 },
    {     27,   15,   13, 14,  8,  0 }, {     28,   15,   12, 15,  8,  0 }, {     28,   15,   11, 15,  8,  0 }, {     28,   15,   10, 15,  8,  0 }, {     29,   16,    9, 15,  8,  0 },
    {     29,   16,    8, 15,  8,  0 }, {     29,   16,    7, 15,  8,  0 }, {     30,   16,    6, 16,  8,  0 }, {     30,   16,    5, 16,  8,  0 }, {     30,   16,    4, 16,  8,  0 },
    {     31,   16,    3, 16,  8,  0 }, {     31,   16,    2, 16,  8,  0 }, {     31,   16,    1, 16,  8,  0 }, {     31,   16,    0, 16,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E5FCA, {
    {      0,   16,   63, 16,  8,  0 }, {      1,   16,   62, 16,  8,  0 }, {      1,   16,   61, 16,  8,  0 }, {      1,   16,   60, 16,  8,  0 }, {      2,   16,   59, 16,  8,  0 },
    {      2,   16,   58, 16,  8,  0 }, {      2,   16,   57, 16,  8,  0 }, {      3,   16,   56, 17,  8,  0 }, {      3,   16,   55, 17,  8,  0 }, {      3,   16,   54, 17,  8,  0 },
    {      4,   15,   53, 17,  8,  0 }, {      4,   15,   52, 17,  8,  0 }, {      4,   15,   51, 17,  8,  0 }, {      5,   15,   50, 18,  8,  0 }, {      5,   15,   49, 18,  8,  0 },
    {      5,   15,   48, 18,  8,  0 }, {      6,   15,   47, 18,  8,  0 }, {      6,   15,   46, 18,  8,  0 }, {      7,   14,   45, 18,  8,  0 }, {      7,   14,   44, 18,  8,  0 },
    {      7,   14,   43, 18,  8,  0 }, {      8,   14,   42, 19,  8,  0 }, {      8,   14,   41, 19,  8,  0 }, {      8,   14,   40, 19,  8,  0 }, {      9,   13,   39, 19,  8,  0 },
    {      9,   13,   38, 19,  8,  0 }, {      9,   13,   37, 19,  8,  0 }, {     10,   12,   36, 20,  8,  0 }, {     10,   12,   35, 20,  8,  0 }, {     10,   12,   34, 20,  8,  0 },
    {     11,   11,   33, 20,  8,  0 }, {     11,   11,   32, 20,  8,  0 }, {     12,   10,   31, 20,  8,  0 }, {     12,   10,   30, 20,  8,  0 }, {     12,   10,   29, 20,  8,  0 },
    {     13,    9,   28, 21,  8,  0 }, {     13,    9,   27, 21,  8,  0 }, {     13,    9,   26, 21,  8,  0 }, {     14,    8,   25, 21,  8,  0 }, {     14,    8,   24, 21,  8,  0 },
    {     14,    8,   23, 21,  8,  0 }, {     14,    7,   22, 22,  8,  0 }, {     14,    7,   21, 22,  8,  0 }, {     14,    7,   20, 22,  8,  0 }, {     15,    6,   19, 22,  8,  0 },
    {     15,    6,   18, 22,  8,  0 }, {     15,    6,   17, 22,  8,  0 }, {     15,    5,   16, 22,  8,  0 }, {     15,    5,   15, 22,  8,  0 }, {     15,    4,   14, 23,  8,  0 },
    {     15,    4,   13, 23,  8,  0 }, {     15,    4,   12, 23,  8,  0 }, {     16,    3,   11, 23,  8,  0 }, {     16,    3,   10, 23,  8,  0 }, {     16,    3,    9, 23,  8,  0 },
    {     16,    2,    8, 24,  8,  0 }, {     16,    2,    7, 24,  8,  0 }, {     16,    2,    6, 24,  8,  0 }, {     16,    1,    5, 24,  8,  0 }, {     16,    1,    4, 24,  8,  0 },
    {     16,    1,    3, 24,  8,  0 }, {     16,    0,    2, 24,  8,  0 }, {     16,    0,    1, 24,  8,  0 }, {     16,    0,    0, 24,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8E620C, {
    {     16,   31,   63, 24,  8,  0 }, {     16,   31,   62, 24,  8,  0 }, {     16,   30,   61, 24,  8,  0 }, {     16,   30,   60, 24,  8,  0 }, {     16,   29,   59, 25,  8,  0 },
    {     16,   29,   58, 25,  8,  0 }, {     15,   28,   57, 25,  8,  0 }, {     15,   28,   56, 25,  8,  0 }, {     15,   28,   55, 25,  8,  0 }, {     15,   27,   54, 26,  8,  0 },
    {     15,   27,   53, 26,  8,  0 }, {     15,   27,   52, 26,  8,  0 }, {     15,   26,   51, 26,  8,  0 }, {     15,   26,   50, 26,  8,  0 }, {     15,   26,   49, 26,  8,  0 },
    {     14,   25,   48, 26,  8,  0 }, {     14,   25,   47, 26,  8,  0 }, {     14,   25,   46, 26,  8,  0 }, {     14,   24,   45, 27,  8,  0 }, {     14,   24,   44, 27,  8,  0 },
    {     14,   24,   43, 27,  8,  0 }, {     13,   23,   42, 27,  8,  0 }, {     13,   23,   41, 27,  8,  0 }, {     13,   23,   40, 27,  8,  0 }, {     12,   22,   39, 28,  8,  0 },
    {     12,   22,   38, 28,  8,  0 }, {     12,   22,   37, 28,  8,  0 }, {     11,   21,   36, 28,  8,  0 }, {     11,   21,   35, 28,  8,  0 }, {     11,   21,   34, 28,  8,  0 },
    {     10,   20,   33, 28,  8,  0 }, {     10,   20,   32, 28,  8,  0 }, {     10,   20,   31, 28,  8,  0 }, {      9,   19,   30, 29,  8,  0 }, {      9,   19,   29, 29,  8,  0 },
    {      9,   19,   28, 29,  8,  0 }, {      8,   18,   27, 29,  8,  0 }, {      8,   18,   26, 29,  8,  0 }, {      8,   18,   25, 29,  8,  0 }, {      7,   18,   24, 30,  8,  0 },
    {      7,   18,   23, 30,  8,  0 }, {      7,   18,   22, 30,  8,  0 }, {      6,   17,   21, 30,  8,  0 }, {      6,   17,   20, 30,  8,  0 }, {      6,   17,   19, 30,  8,  0 },
    {      5,   17,   18, 30,  8,  0 }, {      5,   17,   17, 30,  8,  0 }, {      5,   17,   16, 30,  8,  0 }, {      4,   17,   15, 31,  8,  0 }, {      4,   17,   14, 31,  8,  0 },
    {      4,   17,   13, 31,  8,  0 }, {      3,   16,   12, 31,  8,  0 }, {      3,   16,   11, 31,  8,  0 }, {      3,   16,   10, 31,  8,  0 }, {      2,   16,    9,  0,  8,  0 },
    {      2,   16,    8,  0,  8,  0 }, {      2,   16,    7,  0,  8,  0 }, {      1,   16,    6,  0,  8,  0 }, {      1,   16,    5,  0,  8,  0 }, {      1,   16,    4,  0,  8,  0 },
    {      0,   16,    3,  0,  8,  0 }, {      0,   16,    2,  0,  8,  0 }, {      0,   16,    1,  0,  8,  0 }, {      0,   16,    0,  0,  8,  0 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B0EB2, {
    {     31,   16,    0,  0, 48,  2 }, {     30,   16,    0,  0, 48,  2 }, {     29,   16,    0,  0, 48,  2 }, {     28,   16,    0,  0, 48,  2 }, {     27,   16,    0,  0, 48,  2 },
    {     26,   16,    0,  0, 48,  2 }, {     25,   16,    0,  0, 48,  2 }, {     24,   16,    1, 31, 48,  2 }, {     23,   15,    1, 31, 48,  2 }, {     22,   15,    1, 31, 48,  2 },
    {     21,   15,    1, 31, 48,  2 }, {     20,   15,    1, 31, 48,  2 }, {     19,   15,    1, 31, 48,  2 }, {     18,   15,    1, 31, 48,  2 }, {     17,   14,    2, 31, 48,  2 },
    {     16,   14,    2, 31, 48,  2 }, {     15,   14,    2, 31, 48,  2 }, {     14,   14,    2, 31, 48,  2 }, {     13,   14,    2, 31, 48,  2 }, {     12,   13,    2, 31, 48,  2 },
    {     11,   13,    2, 31, 48,  2 }, {     10,   13,    3, 30, 48,  2 }, {      9,   13,    3, 30, 48,  2 }, {      8,   12,    3, 30, 48,  2 }, {      7,   12,    3, 30, 48,  2 },
    {      6,   12,    3, 30, 48,  2 }, {      5,   11,    3, 30, 48,  2 }, {      4,   11,    3, 30, 48,  2 }, {      3,   11,    4, 30, 48,  2 }, {      2,   10,    4, 30, 48,  2 },
    {      1,   10,    4, 30, 48,  2 }, {      0,    9,    4, 30, 48,  2 }, {     -1,    9,    4, 30, 48,  2 }, {     -2,    8,    4, 30, 48,  2 }, {     -3,    8,    4, 30, 48,  2 },
    {     -4,    7,    5, 30, 48,  2 }, {     -5,    7,    5, 29, 48,  2 }, {     -6,    6,    5, 29, 48,  2 }, {     -7,    6,    5, 29, 48,  2 }, {     -8,    5,    5, 29, 48,  2 },
    {     -9,    4,    5, 29, 48,  2 }, {    -10,    4,    5, 29, 48,  2 }, {    -11,    3,    6, 29, 48,  2 }, {    -12,    2,    6, 29, 48,  2 }, {    -13,    2,    6, 29, 48,  2 },
    {    -14,    1,    6, 29, 48,  2 }, {    -15,    0,    6, 29, 48,  2 }, {    -16,    0,    6, 29, 48,  2 }, {    -17,   -1,    6, 29, 48,  2 }, {    -18,   -2,    7, 28, 48,  2 },
    {    -19,   -3,    7, 28, 48,  2 }, {    -20,   -3,    7, 28, 48,  2 }, {    -21,   -4,    7, 28, 48,  2 }, {    -22,   -5,    7, 28, 48,  2 }, {    -23,   -6,    7, 28, 48,  2 },
    {    -24,   -7,    7, 28, 48,  2 }, {    -25,   -7,    8, 28, 48,  2 }, {    -26,   -8,    8, 28, 48,  2 }, {    -27,   -9,    8, 28, 48,  2 }, {    -28,  -10,    8, 28, 48,  2 },
    {    -29,  -11,    8, 28, 48,  2 }, {    -29,  -12,    8, 28, 48,  2 }, {    -30,  -13,    8, 27, 48,  2 }, {    -31,  -14,    8, 27, 48,  2 }, {    -32,  -15,    9, 27, 48,  2 },
    {    -32,  -16,    9, 27, 48,  2 }, {    -33,  -17,    9, 27, 48,  2 }, {    -34,  -18,    9, 27, 48,  2 }, {    -34,  -19,    9, 27, 48,  2 }, {    -35,  -20,    9, 27, 48,  2 },
    {    -36,  -21,    9, 27, 48,  2 }, {    -36,  -22,   10, 27, 48,  2 }, {    -37,  -23,   10, 27, 48,  2 }, {    -38,  -24,   10, 27, 48,  2 }, {    -38,  -25,   10, 27, 48,  2 },
    {    -39,  -26,   10, 26, 48,  2 }, {    -39,  -27,   10, 26, 48,  2 }, {    -40,  -28,   10, 26, 48,  2 }, {    -40,  -29,   11, 26, 48,  2 }, {    -41,  -30,   11, 26, 48,  2 },
    {    -41,  -31,   11, 26, 48,  2 }, {    -42,  -32,   11, 26, 48,  2 }, {    -42,  -33,   11, 26, 48,  2 }, {    -43,  -34,   11, 26, 48,  2 }, {    -43,  -35,   11, 26, 48,  2 },
    {    -43,  -36,   12, 26, 48,  2 }, {    -44,  -37,   12, 26, 48,  2 }, {    -44,  -38,   12, 26, 48,  2 }, {    -44,  -39,   12, 26, 48,  2 }, {    -45,  -40,   12, 25, 48,  2 },
    {    -45,  -41,   12, 25, 48,  2 }, {    -45,  -42,   12, 25, 48,  2 }, {    -45,  -43,   13, 25, 48,  2 }, {    -46,  -44,   13, 25, 48,  2 }, {    -46,  -45,   13, 25, 48,  2 },
    {    -46,  -46,   13, 25, 48,  2 }, {    -46,  -47,   13, 25, 48,  2 }, {    -46,  -48,   13, 25, 48,  2 }, {    -47,  -49,   13, 25, 48,  2 }, {    -47,  -50,   14, 25, 48,  2 },
    {    -47,  -51,   14, 25, 48,  2 }, {    -47,  -52,   14, 25, 48,  2 }, {    -47,  -53,   14, 25, 48,  2 }, {    -47,  -54,   14, 25, 48,  2 }, {    -48,  -55,   14, 25, 48,  2 },
    {    -48,  -56,   14, 24, 48,  2 }, {    -48,  -57,   15, 24, 48,  2 }, {    -48,  -58,   15, 24, 48,  2 }, {    -48,  -59,   15, 24, 48,  2 }, {    -48,  -60,   15, 24, 48,  2 },
    {    -48,  -61,   15, 24, 48,  2 }, {    -48,  -62,   15, 24, 48,  2 }, {    -48,  -63,   15, 24, 48,  2 }, {    -48,  -64,   16, 24, 48,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B12B6, {
    {     16,    0,    0,  8, 48,  2 }, {     16,    1,    0,  8, 48,  2 }, {     16,    2,    0,  8, 48,  2 }, {     16,    3,    0,  8, 48,  2 }, {     16,    4,    0,  8, 48,  2 },
    {     16,    5,    0,  8, 48,  2 }, {     16,    6,    0,  8, 48,  2 }, {     16,    7,    0,  8, 48,  2 }, {     16,    8,    1,  7, 48,  2 }, {     15,    9,    1,  7, 48,  2 },
    {     15,   10,    1,  7, 48,  2 }, {     15,   11,    1,  7, 48,  2 }, {     15,   12,    1,  7, 48,  2 }, {     15,   13,    1,  7, 48,  2 }, {     15,   14,    1,  7, 48,  2 },
    {     14,   15,    2,  7, 48,  2 }, {     14,   16,    2,  7, 48,  2 }, {     14,   17,    2,  7, 48,  2 }, {     14,   18,    2,  7, 48,  2 }, {     14,   19,    2,  7, 48,  2 },
    {     13,   20,    2,  7, 48,  2 }, {     13,   21,    2,  7, 48,  2 }, {     13,   22,    3,  6, 48,  2 }, {     13,   23,    3,  6, 48,  2 }, {     12,   24,    3,  6, 48,  2 },
    {     12,   25,    3,  6, 48,  2 }, {     12,   26,    3,  6, 48,  2 }, {     11,   27,    3,  6, 48,  2 }, {     11,   28,    3,  6, 48,  2 }, {     11,   29,    4,  6, 48,  2 },
    {     10,   30,    4,  6, 48,  2 }, {     10,   31,    4,  6, 48,  2 }, {      9,   32,    4,  6, 48,  2 }, {      9,   33,    4,  6, 48,  2 }, {      8,   34,    4,  6, 48,  2 },
    {      8,   35,    4,  6, 48,  2 }, {      7,   36,    5,  6, 48,  2 }, {      7,   37,    5,  5, 48,  2 }, {      6,   38,    5,  5, 48,  2 }, {      6,   39,    5,  5, 48,  2 },
    {      5,   40,    5,  5, 48,  2 }, {      4,   41,    5,  5, 48,  2 }, {      4,   42,    5,  5, 48,  2 }, {      3,   43,    5,  5, 48,  2 }, {      2,   44,    6,  5, 48,  2 },
    {      2,   45,    6,  5, 48,  2 }, {      1,   46,    6,  5, 48,  2 }, {      0,   47,    6,  5, 48,  2 }, {      0,   48,    6,  5, 48,  2 }, {     -1,   49,    6,  5, 48,  2 },
    {     -2,   50,    6,  4, 48,  2 }, {     -3,   51,    7,  4, 48,  2 }, {     -3,   52,    7,  4, 48,  2 }, {     -4,   53,    7,  4, 48,  2 }, {     -5,   54,    7,  4, 48,  2 },
    {     -6,   55,    7,  4, 48,  2 }, {     -7,   56,    7,  4, 48,  2 }, {     -7,   57,    7,  4, 48,  2 }, {     -8,   58,    8,  4, 48,  2 }, {     -9,   59,    8,  4, 48,  2 },
    {    -10,   60,    8,  4, 48,  2 }, {    -11,   61,    8,  4, 48,  2 }, {    -12,   61,    8,  4, 48,  2 }, {    -13,   62,    8,  3, 48,  2 }, {    -14,   63,    8,  3, 48,  2 },
    {    -15,   64,    9,  3, 48,  2 }, {    -16,   64,    9,  3, 48,  2 }, {    -17,   65,    9,  3, 48,  2 }, {    -18,   66,    9,  3, 48,  2 }, {    -19,   66,    9,  3, 48,  2 },
    {    -20,   67,    9,  3, 48,  2 }, {    -21,   68,    9,  3, 48,  2 }, {    -22,   68,   10,  3, 48,  2 }, {    -23,   69,   10,  3, 48,  2 }, {    -24,   70,   10,  3, 48,  2 },
    {    -25,   70,   10,  3, 48,  2 }, {    -26,   71,   10,  2, 48,  2 }, {    -27,   71,   10,  2, 48,  2 }, {    -28,   72,   10,  2, 48,  2 }, {    -29,   72,   10,  2, 48,  2 },
    {    -30,   73,   11,  2, 48,  2 }, {    -31,   73,   11,  2, 48,  2 }, {    -32,   74,   11,  2, 48,  2 }, {    -33,   74,   11,  2, 48,  2 }, {    -34,   75,   11,  2, 48,  2 },
    {    -35,   75,   11,  2, 48,  2 }, {    -36,   75,   11,  2, 48,  2 }, {    -37,   76,   12,  2, 48,  2 }, {    -38,   76,   12,  2, 48,  2 }, {    -39,   76,   12,  2, 48,  2 },
    {    -40,   77,   12,  1, 48,  2 }, {    -41,   77,   12,  1, 48,  2 }, {    -42,   77,   12,  1, 48,  2 }, {    -43,   77,   12,  1, 48,  2 }, {    -44,   78,   13,  1, 48,  2 },
    {    -45,   78,   13,  1, 48,  2 }, {    -46,   78,   13,  1, 48,  2 }, {    -47,   78,   13,  1, 48,  2 }, {    -48,   78,   13,  1, 48,  2 }, {    -49,   79,   13,  1, 48,  2 },
    {    -50,   79,   13,  1, 48,  2 }, {    -51,   79,   14,  1, 48,  2 }, {    -52,   79,   14,  1, 48,  2 }, {    -53,   79,   14,  1, 48,  2 }, {    -54,   79,   14,  1, 48,  2 },
    {    -55,   80,   14,  1, 48,  2 }, {    -56,   80,   14,  0, 48,  2 }, {    -57,   80,   14,  0, 48,  2 }, {    -58,   80,   15,  0, 48,  2 }, {    -59,   80,   15,  0, 48,  2 },
    {    -60,   80,   15,  0, 48,  2 }, {    -61,   80,   15,  0, 48,  2 }, {    -62,   80,   15,  0, 48,  2 }, {    -63,   80,   15,  0, 48,  2 }, {    -64,   80,   15,  0, 48,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B16C3, {
    {      0,   16,    0, 16, 48,  2 }, {      1,   16,    0, 16, 48,  2 }, {      2,   16,    0, 16, 48,  2 }, {      3,   16,    0, 16, 48,  2 }, {      4,   16,    0, 16, 48,  2 },
    {      5,   16,    0, 16, 48,  2 }, {      6,   16,    0, 16, 48,  2 }, {      7,   16,    0, 16, 48,  2 }, {      8,   16,    1, 15, 48,  2 }, {      9,   17,    1, 15, 48,  2 },
    {     10,   17,    1, 15, 48,  2 }, {     11,   17,    1, 15, 48,  2 }, {     12,   17,    1, 15, 48,  2 }, {     13,   17,    1, 15, 48,  2 }, {     14,   17,    1, 15, 48,  2 },
    {     15,   18,    2, 15, 48,  2 }, {     16,   18,    2, 15, 48,  2 }, {     17,   18,    2, 15, 48,  2 }, {     18,   18,    2, 15, 48,  2 }, {     19,   18,    2, 15, 48,  2 },
    {     20,   19,    2, 15, 48,  2 }, {     21,   19,    2, 15, 48,  2 }, {     22,   19,    3, 14, 48,  2 }, {     23,   19,    3, 14, 48,  2 }, {     24,   20,    3, 14, 48,  2 },
    {     25,   20,    3, 14, 48,  2 }, {     26,   20,    3, 14, 48,  2 }, {     27,   21,    3, 14, 48,  2 }, {     28,   21,    3, 14, 48,  2 }, {     29,   21,    4, 14, 48,  2 },
    {     30,   22,    4, 14, 48,  2 }, {     31,   22,    4, 14, 48,  2 }, {     32,   23,    4, 14, 48,  2 }, {     33,   23,    4, 14, 48,  2 }, {     34,   24,    4, 14, 48,  2 },
    {     35,   24,    4, 14, 48,  2 }, {     36,   25,    5, 14, 48,  2 }, {     37,   25,    5, 13, 48,  2 }, {     38,   26,    5, 13, 48,  2 }, {     39,   26,    5, 13, 48,  2 },
    {     40,   27,    5, 13, 48,  2 }, {     41,   28,    5, 13, 48,  2 }, {     42,   28,    5, 13, 48,  2 }, {     43,   29,    6, 13, 48,  2 }, {     44,   30,    6, 13, 48,  2 },
    {     45,   30,    6, 13, 48,  2 }, {     46,   31,    6, 13, 48,  2 }, {     47,   32,    6, 13, 48,  2 }, {     48,   32,    6, 13, 48,  2 }, {     49,   33,    6, 13, 48,  2 },
    {     50,   34,    7, 12, 48,  2 }, {     51,   35,    7, 12, 48,  2 }, {     52,   35,    7, 12, 48,  2 }, {     53,   36,    7, 12, 48,  2 }, {     54,   37,    7, 12, 48,  2 },
    {     55,   38,    7, 12, 48,  2 }, {     56,   39,    7, 12, 48,  2 }, {     57,   39,    8, 12, 48,  2 }, {     58,   40,    8, 12, 48,  2 }, {     59,   41,    8, 12, 48,  2 },
    {     60,   42,    8, 12, 48,  2 }, {     61,   43,    8, 12, 48,  2 }, {     61,   44,    8, 12, 48,  2 }, {     62,   45,    8, 11, 48,  2 }, {     63,   46,    8, 11, 48,  2 },
    {     64,   47,    9, 11, 48,  2 }, {     64,   48,    9, 11, 48,  2 }, {     65,   49,    9, 11, 48,  2 }, {     66,   50,    9, 11, 48,  2 }, {     66,   51,    9, 11, 48,  2 },
    {     67,   52,    9, 11, 48,  2 }, {     68,   53,    9, 11, 48,  2 }, {     68,   54,   10, 11, 48,  2 }, {     69,   55,   10, 11, 48,  2 }, {     70,   56,   10, 11, 48,  2 },
    {     70,   57,   10, 11, 48,  2 }, {     71,   58,   10, 10, 48,  2 }, {     71,   59,   10, 10, 48,  2 }, {     72,   60,   10, 10, 48,  2 }, {     72,   61,   11, 10, 48,  2 },
    {     73,   62,   11, 10, 48,  2 }, {     73,   63,   11, 10, 48,  2 }, {     74,   64,   11, 10, 48,  2 }, {     74,   65,   11, 10, 48,  2 }, {     75,   66,   11, 10, 48,  2 },
    {     75,   67,   11, 10, 48,  2 }, {     75,   68,   12, 10, 48,  2 }, {     76,   69,   12, 10, 48,  2 }, {     76,   70,   12, 10, 48,  2 }, {     76,   71,   12, 10, 48,  2 },
    {     77,   72,   12,  9, 48,  2 }, {     77,   73,   12,  9, 48,  2 }, {     77,   74,   12,  9, 48,  2 }, {     77,   75,   13,  9, 48,  2 }, {     78,   76,   13,  9, 48,  2 },
    {     78,   77,   13,  9, 48,  2 }, {     78,   78,   13,  9, 48,  2 }, {     78,   79,   13,  9, 48,  2 }, {     78,   80,   13,  9, 48,  2 }, {     79,   81,   13,  9, 48,  2 },
    {     79,   82,   14,  9, 48,  2 }, {     79,   83,   14,  9, 48,  2 }, {     79,   84,   14,  9, 48,  2 }, {     79,   85,   14,  9, 48,  2 }, {     79,   86,   14,  9, 48,  2 },
    {     80,   87,   14,  9, 48,  2 }, {     80,   88,   14,  8, 48,  2 }, {     80,   89,   15,  8, 48,  2 }, {     80,   90,   15,  8, 48,  2 }, {     80,   91,   15,  8, 48,  2 },
    {     80,   92,   15,  8, 48,  2 }, {     80,   93,   15,  8, 48,  2 }, {     80,   94,   15,  8, 48,  2 }, {     80,   95,   15,  8, 48,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B1AC7, {
    {     16,   31,    0, 24, 48,  2 }, {     16,   30,    0, 24, 48,  2 }, {     16,   29,    0, 24, 48,  2 }, {     16,   28,    0, 24, 48,  2 }, {     16,   27,    0, 24, 48,  2 },
    {     16,   26,    0, 24, 48,  2 }, {     16,   25,    0, 24, 48,  2 }, {     16,   24,    1, 23, 48,  2 }, {     17,   23,    1, 23, 48,  2 }, {     17,   22,    1, 23, 48,  2 },
    {     17,   21,    1, 23, 48,  2 }, {     17,   20,    1, 23, 48,  2 }, {     17,   19,    1, 23, 48,  2 }, {     17,   18,    1, 23, 48,  2 }, {     18,   17,    2, 23, 48,  2 },
    {     18,   16,    2, 23, 48,  2 }, {     18,   15,    2, 23, 48,  2 }, {     18,   14,    2, 23, 48,  2 }, {     18,   13,    2, 23, 48,  2 }, {     19,   12,    2, 23, 48,  2 },
    {     19,   11,    2, 23, 48,  2 }, {     19,   10,    3, 22, 48,  2 }, {     19,    9,    3, 22, 48,  2 }, {     20,    8,    3, 22, 48,  2 }, {     20,    7,    3, 22, 48,  2 },
    {     20,    6,    3, 22, 48,  2 }, {     21,    5,    3, 22, 48,  2 }, {     21,    4,    3, 22, 48,  2 }, {     21,    3,    4, 22, 48,  2 }, {     22,    2,    4, 22, 48,  2 },
    {     22,    1,    4, 22, 48,  2 }, {     23,    0,    4, 22, 48,  2 }, {     23,   -1,    4, 22, 48,  2 }, {     24,   -2,    4, 22, 48,  2 }, {     24,   -3,    4, 22, 48,  2 },
    {     25,   -4,    5, 22, 48,  2 }, {     25,   -5,    5, 21, 48,  2 }, {     26,   -6,    5, 21, 48,  2 }, {     26,   -7,    5, 21, 48,  2 }, {     27,   -8,    5, 21, 48,  2 },
    {     28,   -9,    5, 21, 48,  2 }, {     28,  -10,    5, 21, 48,  2 }, {     29,  -11,    6, 21, 48,  2 }, {     30,  -12,    6, 21, 48,  2 }, {     30,  -13,    6, 21, 48,  2 },
    {     31,  -14,    6, 21, 48,  2 }, {     32,  -15,    6, 21, 48,  2 }, {     32,  -16,    6, 21, 48,  2 }, {     33,  -17,    6, 21, 48,  2 }, {     34,  -18,    7, 20, 48,  2 },
    {     35,  -19,    7, 20, 48,  2 }, {     35,  -20,    7, 20, 48,  2 }, {     36,  -21,    7, 20, 48,  2 }, {     37,  -22,    7, 20, 48,  2 }, {     38,  -23,    7, 20, 48,  2 },
    {     39,  -24,    7, 20, 48,  2 }, {     39,  -25,    8, 20, 48,  2 }, {     40,  -26,    8, 20, 48,  2 }, {     41,  -27,    8, 20, 48,  2 }, {     42,  -28,    8, 20, 48,  2 },
    {     43,  -29,    8, 20, 48,  2 }, {     44,  -29,    8, 20, 48,  2 }, {     45,  -30,    8, 19, 48,  2 }, {     46,  -31,    9, 19, 48,  2 }, {     47,  -32,    9, 19, 48,  2 },
    {     48,  -32,    9, 19, 48,  2 }, {     49,  -33,    9, 19, 48,  2 }, {     50,  -34,    9, 19, 48,  2 }, {     51,  -34,    9, 19, 48,  2 }, {     52,  -35,    9, 19, 48,  2 },
    {     53,  -36,   10, 19, 48,  2 }, {     54,  -36,   10, 19, 48,  2 }, {     55,  -37,   10, 19, 48,  2 }, {     56,  -38,   10, 19, 48,  2 }, {     57,  -38,   10, 19, 48,  2 },
    {     58,  -39,   10, 18, 48,  2 }, {     59,  -39,   10, 18, 48,  2 }, {     60,  -40,   11, 18, 48,  2 }, {     61,  -40,   11, 18, 48,  2 }, {     62,  -41,   11, 18, 48,  2 },
    {     63,  -41,   11, 18, 48,  2 }, {     64,  -42,   11, 18, 48,  2 }, {     65,  -42,   11, 18, 48,  2 }, {     66,  -43,   11, 18, 48,  2 }, {     67,  -43,   12, 18, 48,  2 },
    {     68,  -43,   12, 18, 48,  2 }, {     69,  -44,   12, 18, 48,  2 }, {     70,  -44,   12, 18, 48,  2 }, {     71,  -44,   12, 18, 48,  2 }, {     72,  -45,   12, 17, 48,  2 },
    {     73,  -45,   12, 17, 48,  2 }, {     74,  -45,   13, 17, 48,  2 }, {     75,  -45,   13, 17, 48,  2 }, {     76,  -46,   13, 17, 48,  2 }, {     77,  -46,   13, 17, 48,  2 },
    {     78,  -46,   13, 17, 48,  2 }, {     79,  -46,   13, 17, 48,  2 }, {     80,  -46,   13, 17, 48,  2 }, {     81,  -47,   14, 17, 48,  2 }, {     82,  -47,   14, 17, 48,  2 },
    {     83,  -47,   14, 17, 48,  2 }, {     84,  -47,   14, 17, 48,  2 }, {     85,  -47,   14, 17, 48,  2 }, {     86,  -47,   14, 17, 48,  2 }, {     87,  -48,   14, 17, 48,  2 },
    {     88,  -48,   15, 16, 48,  2 }, {     89,  -48,   15, 16, 48,  2 }, {     90,  -48,   15, 16, 48,  2 }, {     91,  -48,   15, 16, 48,  2 }, {     92,  -48,   15, 16, 48,  2 },
    {     93,  -48,   15, 16, 48,  2 }, {     94,  -48,   15, 16, 48,  2 }, {     95,  -48,   16, 16, 48,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B1EC2, {
    {     31,   16,    0,  0, 48,  4 }, {     30,   16,    0,  0, 48,  4 }, {     29,   16,    0,  0, 48,  4 }, {     28,   16,    0,  0, 48,  4 }, {     27,   16,    0,  0, 48,  4 },
    {     26,   16,    0,  0, 48,  4 }, {     25,   16,    0,  0, 48,  4 }, {     24,   16,    1,  1, 48,  4 }, {     23,   17,    1,  1, 48,  4 }, {     22,   17,    1,  1, 48,  4 },
    {     21,   17,    1,  1, 48,  4 }, {     20,   17,    1,  1, 48,  4 }, {     19,   17,    1,  1, 48,  4 }, {     18,   17,    1,  1, 48,  4 }, {     17,   18,    2,  1, 48,  4 },
    {     16,   18,    2,  1, 48,  4 }, {     15,   18,    2,  1, 48,  4 }, {     14,   18,    2,  1, 48,  4 }, {     13,   18,    2,  1, 48,  4 }, {     12,   19,    2,  1, 48,  4 },
    {     11,   19,    2,  1, 48,  4 }, {     10,   19,    3,  2, 48,  4 }, {      9,   19,    3,  2, 48,  4 }, {      8,   20,    3,  2, 48,  4 }, {      7,   20,    3,  2, 48,  4 },
    {      6,   20,    3,  2, 48,  4 }, {      5,   21,    3,  2, 48,  4 }, {      4,   21,    3,  2, 48,  4 }, {      3,   21,    4,  2, 48,  4 }, {      2,   22,    4,  2, 48,  4 },
    {      1,   22,    4,  2, 48,  4 }, {      0,   23,    4,  2, 48,  4 }, {     -1,   23,    4,  2, 48,  4 }, {     -2,   24,    4,  2, 48,  4 }, {     -3,   24,    4,  2, 48,  4 },
    {     -4,   25,    5,  2, 48,  4 }, {     -5,   25,    5,  3, 48,  4 }, {     -6,   26,    5,  3, 48,  4 }, {     -7,   26,    5,  3, 48,  4 }, {     -8,   27,    5,  3, 48,  4 },
    {     -9,   28,    5,  3, 48,  4 }, {    -10,   28,    5,  3, 48,  4 }, {    -11,   29,    6,  3, 48,  4 }, {    -12,   30,    6,  3, 48,  4 }, {    -13,   30,    6,  3, 48,  4 },
    {    -14,   31,    6,  3, 48,  4 }, {    -15,   32,    6,  3, 48,  4 }, {    -16,   32,    6,  3, 48,  4 }, {    -17,   33,    6,  3, 48,  4 }, {    -18,   34,    7,  4, 48,  4 },
    {    -19,   35,    7,  4, 48,  4 }, {    -20,   35,    7,  4, 48,  4 }, {    -21,   36,    7,  4, 48,  4 }, {    -22,   37,    7,  4, 48,  4 }, {    -23,   38,    7,  4, 48,  4 },
    {    -24,   39,    7,  4, 48,  4 }, {    -25,   39,    8,  4, 48,  4 }, {    -26,   40,    8,  4, 48,  4 }, {    -27,   41,    8,  4, 48,  4 }, {    -28,   42,    8,  4, 48,  4 },
    {    -29,   43,    8,  4, 48,  4 }, {    -29,   44,    8,  4, 48,  4 }, {    -30,   45,    8,  5, 48,  4 }, {    -31,   46,    9,  5, 48,  4 }, {    -32,   47,    9,  5, 48,  4 },
    {    -32,   48,    9,  5, 48,  4 }, {    -33,   49,    9,  5, 48,  4 }, {    -34,   50,    9,  5, 48,  4 }, {    -34,   51,    9,  5, 48,  4 }, {    -35,   52,    9,  5, 48,  4 },
    {    -36,   53,   10,  5, 48,  4 }, {    -36,   54,   10,  5, 48,  4 }, {    -37,   55,   10,  5, 48,  4 }, {    -38,   56,   10,  5, 48,  4 }, {    -38,   57,   10,  5, 48,  4 },
    {    -39,   58,   10,  6, 48,  4 }, {    -39,   59,   10,  6, 48,  4 }, {    -40,   60,   11,  6, 48,  4 }, {    -40,   61,   11,  6, 48,  4 }, {    -41,   62,   11,  6, 48,  4 },
    {    -41,   63,   11,  6, 48,  4 }, {    -42,   64,   11,  6, 48,  4 }, {    -42,   65,   11,  6, 48,  4 }, {    -43,   66,   11,  6, 48,  4 }, {    -43,   67,   12,  6, 48,  4 },
    {    -43,   68,   12,  6, 48,  4 }, {    -44,   69,   12,  6, 48,  4 }, {    -44,   70,   12,  6, 48,  4 }, {    -44,   71,   12,  6, 48,  4 }, {    -45,   72,   12,  7, 48,  4 },
    {    -45,   73,   12,  7, 48,  4 }, {    -45,   74,   13,  7, 48,  4 }, {    -45,   75,   13,  7, 48,  4 }, {    -46,   76,   13,  7, 48,  4 }, {    -46,   77,   13,  7, 48,  4 },
    {    -46,   78,   13,  7, 48,  4 }, {    -46,   79,   13,  7, 48,  4 }, {    -46,   80,   13,  7, 48,  4 }, {    -47,   81,   14,  7, 48,  4 }, {    -47,   82,   14,  7, 48,  4 },
    {    -47,   83,   14,  7, 48,  4 }, {    -47,   84,   14,  7, 48,  4 }, {    -47,   85,   14,  7, 48,  4 }, {    -47,   86,   14,  7, 48,  4 }, {    -48,   87,   14,  7, 48,  4 },
    {    -48,   88,   15,  8, 48,  4 }, {    -48,   89,   15,  8, 48,  4 }, {    -48,   90,   15,  8, 48,  4 }, {    -48,   91,   15,  8, 48,  4 }, {    -48,   92,   15,  8, 48,  4 },
    {    -48,   93,   15,  8, 48,  4 }, {    -48,   94,   15,  8, 48,  4 }, {    -48,   95,   16,  8, 48,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B22BD, {
    {     16,    0,    0,  8, 48,  4 }, {     16,    1,    0,  8, 48,  4 }, {     16,    2,    0,  8, 48,  4 }, {     16,    3,    0,  8, 48,  4 }, {     16,    4,    0,  8, 48,  4 },
    {     16,    5,    0,  8, 48,  4 }, {     16,    6,    0,  8, 48,  4 }, {     16,    7,    0,  8, 48,  4 }, {     16,    8,    1,  9, 48,  4 }, {     17,    9,    1,  9, 48,  4 },
    {     17,   10,    1,  9, 48,  4 }, {     17,   11,    1,  9, 48,  4 }, {     17,   12,    1,  9, 48,  4 }, {     17,   13,    1,  9, 48,  4 }, {     17,   14,    1,  9, 48,  4 },
    {     18,   15,    2,  9, 48,  4 }, {     18,   16,    2,  9, 48,  4 }, {     18,   17,    2,  9, 48,  4 }, {     18,   18,    2,  9, 48,  4 }, {     18,   19,    2,  9, 48,  4 },
    {     19,   20,    2,  9, 48,  4 }, {     19,   21,    2,  9, 48,  4 }, {     19,   22,    3, 10, 48,  4 }, {     19,   23,    3, 10, 48,  4 }, {     20,   24,    3, 10, 48,  4 },
    {     20,   25,    3, 10, 48,  4 }, {     20,   26,    3, 10, 48,  4 }, {     21,   27,    3, 10, 48,  4 }, {     21,   28,    3, 10, 48,  4 }, {     21,   29,    4, 10, 48,  4 },
    {     22,   30,    4, 10, 48,  4 }, {     22,   31,    4, 10, 48,  4 }, {     23,   32,    4, 10, 48,  4 }, {     23,   33,    4, 10, 48,  4 }, {     24,   34,    4, 10, 48,  4 },
    {     24,   35,    4, 10, 48,  4 }, {     25,   36,    5, 10, 48,  4 }, {     25,   37,    5, 11, 48,  4 }, {     26,   38,    5, 11, 48,  4 }, {     26,   39,    5, 11, 48,  4 },
    {     27,   40,    5, 11, 48,  4 }, {     28,   41,    5, 11, 48,  4 }, {     28,   42,    5, 11, 48,  4 }, {     29,   43,    6, 11, 48,  4 }, {     30,   44,    6, 11, 48,  4 },
    {     30,   45,    6, 11, 48,  4 }, {     31,   46,    6, 11, 48,  4 }, {     32,   47,    6, 11, 48,  4 }, {     32,   48,    6, 11, 48,  4 }, {     33,   49,    6, 11, 48,  4 },
    {     34,   50,    7, 12, 48,  4 }, {     35,   51,    7, 12, 48,  4 }, {     35,   52,    7, 12, 48,  4 }, {     36,   53,    7, 12, 48,  4 }, {     37,   54,    7, 12, 48,  4 },
    {     38,   55,    7, 12, 48,  4 }, {     39,   56,    7, 12, 48,  4 }, {     39,   57,    8, 12, 48,  4 }, {     40,   58,    8, 12, 48,  4 }, {     41,   59,    8, 12, 48,  4 },
    {     42,   60,    8, 12, 48,  4 }, {     43,   61,    8, 12, 48,  4 }, {     44,   61,    8, 12, 48,  4 }, {     45,   62,    8, 13, 48,  4 }, {     46,   63,    8, 13, 48,  4 },
    {     47,   64,    9, 13, 48,  4 }, {     48,   64,    9, 13, 48,  4 }, {     49,   65,    9, 13, 48,  4 }, {     50,   66,    9, 13, 48,  4 }, {     51,   66,    9, 13, 48,  4 },
    {     52,   67,    9, 13, 48,  4 }, {     53,   68,    9, 13, 48,  4 }, {     54,   68,   10, 13, 48,  4 }, {     55,   69,   10, 13, 48,  4 }, {     56,   70,   10, 13, 48,  4 },
    {     57,   70,   10, 13, 48,  4 }, {     58,   71,   10, 14, 48,  4 }, {     59,   71,   10, 14, 48,  4 }, {     60,   72,   10, 14, 48,  4 }, {     61,   72,   11, 14, 48,  4 },
    {     62,   73,   11, 14, 48,  4 }, {     63,   73,   11, 14, 48,  4 }, {     64,   74,   11, 14, 48,  4 }, {     65,   74,   11, 14, 48,  4 }, {     66,   75,   11, 14, 48,  4 },
    {     67,   75,   11, 14, 48,  4 }, {     68,   75,   12, 14, 48,  4 }, {     69,   76,   12, 14, 48,  4 }, {     70,   76,   12, 14, 48,  4 }, {     71,   76,   12, 14, 48,  4 },
    {     72,   77,   12, 15, 48,  4 }, {     73,   77,   12, 15, 48,  4 }, {     74,   77,   12, 15, 48,  4 }, {     75,   77,   13, 15, 48,  4 }, {     76,   78,   13, 15, 48,  4 },
    {     77,   78,   13, 15, 48,  4 }, {     78,   78,   13, 15, 48,  4 }, {     79,   78,   13, 15, 48,  4 }, {     80,   78,   13, 15, 48,  4 }, {     81,   79,   13, 15, 48,  4 },
    {     82,   79,   14, 15, 48,  4 }, {     83,   79,   14, 15, 48,  4 }, {     84,   79,   14, 15, 48,  4 }, {     85,   79,   14, 15, 48,  4 }, {     86,   79,   14, 15, 48,  4 },
    {     87,   80,   14, 15, 48,  4 }, {     88,   80,   14, 16, 48,  4 }, {     89,   80,   15, 16, 48,  4 }, {     90,   80,   15, 16, 48,  4 }, {     91,   80,   15, 16, 48,  4 },
    {     92,   80,   15, 16, 48,  4 }, {     93,   80,   15, 16, 48,  4 }, {     94,   80,   15, 16, 48,  4 }, {     95,   80,   15, 16, 48,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B26C1, {
    {      0,   16,    0, 16, 48,  4 }, {      1,   16,    0, 16, 48,  4 }, {      2,   16,    0, 16, 48,  4 }, {      3,   16,    0, 16, 48,  4 }, {      4,   16,    0, 16, 48,  4 },
    {      5,   16,    0, 16, 48,  4 }, {      6,   16,    0, 16, 48,  4 }, {      7,   16,    0, 16, 48,  4 }, {      8,   16,    1, 17, 48,  4 }, {      9,   15,    1, 17, 48,  4 },
    {     10,   15,    1, 17, 48,  4 }, {     11,   15,    1, 17, 48,  4 }, {     12,   15,    1, 17, 48,  4 }, {     13,   15,    1, 17, 48,  4 }, {     14,   15,    1, 17, 48,  4 },
    {     15,   14,    2, 17, 48,  4 }, {     16,   14,    2, 17, 48,  4 }, {     17,   14,    2, 17, 48,  4 }, {     18,   14,    2, 17, 48,  4 }, {     19,   14,    2, 17, 48,  4 },
    {     20,   13,    2, 17, 48,  4 }, {     21,   13,    2, 17, 48,  4 }, {     22,   13,    3, 18, 48,  4 }, {     23,   13,    3, 18, 48,  4 }, {     24,   12,    3, 18, 48,  4 },
    {     25,   12,    3, 18, 48,  4 }, {     26,   12,    3, 18, 48,  4 }, {     27,   11,    3, 18, 48,  4 }, {     28,   11,    3, 18, 48,  4 }, {     29,   11,    4, 18, 48,  4 },
    {     30,   10,    4, 18, 48,  4 }, {     31,   10,    4, 18, 48,  4 }, {     32,    9,    4, 18, 48,  4 }, {     33,    9,    4, 18, 48,  4 }, {     34,    8,    4, 18, 48,  4 },
    {     35,    8,    4, 18, 48,  4 }, {     36,    7,    5, 18, 48,  4 }, {     37,    7,    5, 19, 48,  4 }, {     38,    6,    5, 19, 48,  4 }, {     39,    6,    5, 19, 48,  4 },
    {     40,    5,    5, 19, 48,  4 }, {     41,    4,    5, 19, 48,  4 }, {     42,    4,    5, 19, 48,  4 }, {     43,    3,    5, 19, 48,  4 }, {     44,    2,    6, 19, 48,  4 },
    {     45,    2,    6, 19, 48,  4 }, {     46,    1,    6, 19, 48,  4 }, {     47,    0,    6, 19, 48,  4 }, {     48,    0,    6, 19, 48,  4 }, {     49,   -1,    6, 19, 48,  4 },
    {     50,   -2,    6, 20, 48,  4 }, {     51,   -3,    7, 20, 48,  4 }, {     52,   -3,    7, 20, 48,  4 }, {     53,   -4,    7, 20, 48,  4 }, {     54,   -5,    7, 20, 48,  4 },
    {     55,   -6,    7, 20, 48,  4 }, {     56,   -7,    7, 20, 48,  4 }, {     57,   -7,    7, 20, 48,  4 }, {     58,   -8,    8, 20, 48,  4 }, {     59,   -9,    8, 20, 48,  4 },
    {     60,  -10,    8, 20, 48,  4 }, {     61,  -11,    8, 20, 48,  4 }, {     61,  -12,    8, 20, 48,  4 }, {     62,  -13,    8, 21, 48,  4 }, {     63,  -14,    8, 21, 48,  4 },
    {     64,  -15,    9, 21, 48,  4 }, {     64,  -16,    9, 21, 48,  4 }, {     65,  -17,    9, 21, 48,  4 }, {     66,  -18,    9, 21, 48,  4 }, {     66,  -19,    9, 21, 48,  4 },
    {     67,  -20,    9, 21, 48,  4 }, {     68,  -21,    9, 21, 48,  4 }, {     68,  -22,   10, 21, 48,  4 }, {     69,  -23,   10, 21, 48,  4 }, {     70,  -24,   10, 21, 48,  4 },
    {     70,  -25,   10, 21, 48,  4 }, {     71,  -26,   10, 22, 48,  4 }, {     71,  -27,   10, 22, 48,  4 }, {     72,  -28,   10, 22, 48,  4 }, {     72,  -29,   10, 22, 48,  4 },
    {     73,  -30,   11, 22, 48,  4 }, {     73,  -31,   11, 22, 48,  4 }, {     74,  -32,   11, 22, 48,  4 }, {     74,  -33,   11, 22, 48,  4 }, {     75,  -34,   11, 22, 48,  4 },
    {     75,  -35,   11, 22, 48,  4 }, {     75,  -36,   11, 22, 48,  4 }, {     76,  -37,   12, 22, 48,  4 }, {     76,  -38,   12, 22, 48,  4 }, {     76,  -39,   12, 22, 48,  4 },
    {     77,  -40,   12, 23, 48,  4 }, {     77,  -41,   12, 23, 48,  4 }, {     77,  -42,   12, 23, 48,  4 }, {     77,  -43,   12, 23, 48,  4 }, {     78,  -44,   13, 23, 48,  4 },
    {     78,  -45,   13, 23, 48,  4 }, {     78,  -46,   13, 23, 48,  4 }, {     78,  -47,   13, 23, 48,  4 }, {     78,  -48,   13, 23, 48,  4 }, {     79,  -49,   13, 23, 48,  4 },
    {     79,  -50,   13, 23, 48,  4 }, {     79,  -51,   14, 23, 48,  4 }, {     79,  -52,   14, 23, 48,  4 }, {     79,  -53,   14, 23, 48,  4 }, {     79,  -54,   14, 23, 48,  4 },
    {     80,  -55,   14, 23, 48,  4 }, {     80,  -56,   14, 24, 48,  4 }, {     80,  -57,   14, 24, 48,  4 }, {     80,  -58,   15, 24, 48,  4 }, {     80,  -59,   15, 24, 48,  4 },
    {     80,  -60,   15, 24, 48,  4 }, {     80,  -61,   15, 24, 48,  4 }, {     80,  -62,   15, 24, 48,  4 }, {     80,  -63,   15, 24, 48,  4 }, {     80,  -64,   15, 24, 48,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B2ACE, {
    {     16,   31,    0, 24, 48,  4 }, {     16,   30,    0, 24, 48,  4 }, {     16,   29,    0, 24, 48,  4 }, {     16,   28,    0, 24, 48,  4 }, {     16,   27,    0, 24, 48,  4 },
    {     16,   26,    0, 24, 48,  4 }, {     16,   25,    0, 24, 48,  4 }, {     16,   24,    1, 25, 48,  4 }, {     15,   23,    1, 25, 48,  4 }, {     15,   22,    1, 25, 48,  4 },
    {     15,   21,    1, 25, 48,  4 }, {     15,   20,    1, 25, 48,  4 }, {     15,   19,    1, 25, 48,  4 }, {     15,   18,    1, 25, 48,  4 }, {     14,   17,    2, 25, 48,  4 },
    {     14,   16,    2, 25, 48,  4 }, {     14,   15,    2, 25, 48,  4 }, {     14,   14,    2, 25, 48,  4 }, {     14,   13,    2, 25, 48,  4 }, {     13,   12,    2, 25, 48,  4 },
    {     13,   11,    2, 25, 48,  4 }, {     13,   10,    3, 26, 48,  4 }, {     13,    9,    3, 26, 48,  4 }, {     12,    8,    3, 26, 48,  4 }, {     12,    7,    3, 26, 48,  4 },
    {     12,    6,    3, 26, 48,  4 }, {     11,    5,    3, 26, 48,  4 }, {     11,    4,    3, 26, 48,  4 }, {     11,    3,    4, 26, 48,  4 }, {     10,    2,    4, 26, 48,  4 },
    {     10,    1,    4, 26, 48,  4 }, {      9,    0,    4, 26, 48,  4 }, {      9,   -1,    4, 26, 48,  4 }, {      8,   -2,    4, 26, 48,  4 }, {      8,   -3,    4, 26, 48,  4 },
    {      7,   -4,    5, 26, 48,  4 }, {      7,   -5,    5, 27, 48,  4 }, {      6,   -6,    5, 27, 48,  4 }, {      6,   -7,    5, 27, 48,  4 }, {      5,   -8,    5, 27, 48,  4 },
    {      4,   -9,    5, 27, 48,  4 }, {      4,  -10,    5, 27, 48,  4 }, {      3,  -11,    6, 27, 48,  4 }, {      2,  -12,    6, 27, 48,  4 }, {      2,  -13,    6, 27, 48,  4 },
    {      1,  -14,    6, 27, 48,  4 }, {      0,  -15,    6, 27, 48,  4 }, {      0,  -16,    6, 27, 48,  4 }, {     -1,  -17,    6, 27, 48,  4 }, {     -2,  -18,    7, 28, 48,  4 },
    {     -3,  -19,    7, 28, 48,  4 }, {     -3,  -20,    7, 28, 48,  4 }, {     -4,  -21,    7, 28, 48,  4 }, {     -5,  -22,    7, 28, 48,  4 }, {     -6,  -23,    7, 28, 48,  4 },
    {     -7,  -24,    7, 28, 48,  4 }, {     -7,  -25,    8, 28, 48,  4 }, {     -8,  -26,    8, 28, 48,  4 }, {     -9,  -27,    8, 28, 48,  4 }, {    -10,  -28,    8, 28, 48,  4 },
    {    -11,  -29,    8, 28, 48,  4 }, {    -12,  -29,    8, 28, 48,  4 }, {    -13,  -30,    8, 29, 48,  4 }, {    -14,  -31,    8, 29, 48,  4 }, {    -15,  -32,    9, 29, 48,  4 },
    {    -16,  -32,    9, 29, 48,  4 }, {    -17,  -33,    9, 29, 48,  4 }, {    -18,  -34,    9, 29, 48,  4 }, {    -19,  -34,    9, 29, 48,  4 }, {    -20,  -35,    9, 29, 48,  4 },
    {    -21,  -36,    9, 29, 48,  4 }, {    -22,  -36,   10, 29, 48,  4 }, {    -23,  -37,   10, 29, 48,  4 }, {    -24,  -38,   10, 29, 48,  4 }, {    -25,  -38,   10, 29, 48,  4 },
    {    -26,  -39,   10, 30, 48,  4 }, {    -27,  -39,   10, 30, 48,  4 }, {    -28,  -40,   10, 30, 48,  4 }, {    -29,  -40,   11, 30, 48,  4 }, {    -30,  -41,   11, 30, 48,  4 },
    {    -31,  -41,   11, 30, 48,  4 }, {    -32,  -42,   11, 30, 48,  4 }, {    -33,  -42,   11, 30, 48,  4 }, {    -34,  -43,   11, 30, 48,  4 }, {    -35,  -43,   11, 30, 48,  4 },
    {    -36,  -43,   12, 30, 48,  4 }, {    -37,  -44,   12, 30, 48,  4 }, {    -38,  -44,   12, 30, 48,  4 }, {    -39,  -44,   12, 30, 48,  4 }, {    -40,  -45,   12, 31, 48,  4 },
    {    -41,  -45,   12, 31, 48,  4 }, {    -42,  -45,   12, 31, 48,  4 }, {    -43,  -45,   13, 31, 48,  4 }, {    -44,  -46,   13, 31, 48,  4 }, {    -45,  -46,   13, 31, 48,  4 },
    {    -46,  -46,   13, 31, 48,  4 }, {    -47,  -46,   13, 31, 48,  4 }, {    -48,  -46,   13, 31, 48,  4 }, {    -49,  -47,   13, 31, 48,  4 }, {    -50,  -47,   14, 31, 48,  4 },
    {    -51,  -47,   14, 31, 48,  4 }, {    -52,  -47,   14, 31, 48,  4 }, {    -53,  -47,   14, 31, 48,  4 }, {    -54,  -47,   14, 31, 48,  4 }, {    -55,  -48,   14, 31, 48,  4 },
    {    -56,  -48,   14,  0, 48,  4 }, {    -57,  -48,   15,  0, 48,  4 }, {    -58,  -48,   15,  0, 48,  4 }, {    -59,  -48,   15,  0, 48,  4 }, {    -60,  -48,   15,  0, 48,  4 },
    {    -61,  -48,   15,  0, 48,  4 }, {    -62,  -48,   15,  0, 48,  4 }, {    -63,  -48,   15,  0, 48,  4 }, {    -64,  -48,   16,  0, 48,  4 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B2ED2, {
    {     31,   16,   16,  0, 49,  2 }, {     30,   16,   16,  0, 49,  2 }, {     29,   16,   16,  0, 49,  2 }, {     28,   16,   16,  0, 49,  2 }, {     27,   16,   16,  0, 49,  2 },
    {     26,   16,   16,  0, 49,  2 }, {     25,   16,   16,  0, 49,  2 }, {     24,   16,   15, 31, 49,  2 }, {     23,   15,   15, 31, 49,  2 }, {     22,   15,   15, 31, 49,  2 },
    {     21,   15,   15, 31, 49,  2 }, {     20,   15,   15, 31, 49,  2 }, {     19,   15,   15, 31, 49,  2 }, {     18,   15,   15, 31, 49,  2 }, {     17,   14,   14, 31, 49,  2 },
    {     16,   14,   14, 31, 49,  2 }, {     15,   14,   14, 31, 49,  2 }, {     14,   14,   14, 31, 49,  2 }, {     13,   14,   14, 31, 49,  2 }, {     12,   13,   14, 31, 49,  2 },
    {     11,   13,   14, 31, 49,  2 }, {     10,   13,   13, 30, 49,  2 }, {      9,   13,   13, 30, 49,  2 }, {      8,   12,   13, 30, 49,  2 }, {      7,   12,   13, 30, 49,  2 },
    {      6,   12,   13, 30, 49,  2 }, {      5,   11,   13, 30, 49,  2 }, {      4,   11,   13, 30, 49,  2 }, {      3,   11,   12, 30, 49,  2 }, {      2,   10,   12, 30, 49,  2 },
    {      1,   10,   12, 30, 49,  2 }, {      0,    9,   12, 30, 49,  2 }, {     -1,    9,   12, 30, 49,  2 }, {     -2,    8,   12, 30, 49,  2 }, {     -3,    8,   12, 30, 49,  2 },
    {     -4,    7,   11, 30, 49,  2 }, {     -5,    7,   11, 29, 49,  2 }, {     -6,    6,   11, 29, 49,  2 }, {     -7,    6,   11, 29, 49,  2 }, {     -8,    5,   11, 29, 49,  2 },
    {     -9,    4,   11, 29, 49,  2 }, {    -10,    4,   11, 29, 49,  2 }, {    -11,    3,   10, 29, 49,  2 }, {    -12,    2,   10, 29, 49,  2 }, {    -13,    2,   10, 29, 49,  2 },
    {    -14,    1,   10, 29, 49,  2 }, {    -15,    0,   10, 29, 49,  2 }, {    -16,    0,   10, 29, 49,  2 }, {    -17,   -1,   10, 29, 49,  2 }, {    -18,   -2,    9, 28, 49,  2 },
    {    -19,   -3,    9, 28, 49,  2 }, {    -20,   -3,    9, 28, 49,  2 }, {    -21,   -4,    9, 28, 49,  2 }, {    -22,   -5,    9, 28, 49,  2 }, {    -23,   -6,    9, 28, 49,  2 },
    {    -24,   -7,    9, 28, 49,  2 }, {    -25,   -7,    8, 28, 49,  2 }, {    -26,   -8,    8, 28, 49,  2 }, {    -27,   -9,    8, 28, 49,  2 }, {    -28,  -10,    8, 28, 49,  2 },
    {    -29,  -11,    8, 28, 49,  2 }, {    -29,  -12,    8, 28, 49,  2 }, {    -30,  -13,    8, 27, 49,  2 }, {    -31,  -14,    8, 27, 49,  2 }, {    -32,  -15,    7, 27, 49,  2 },
    {    -32,  -16,    7, 27, 49,  2 }, {    -33,  -17,    7, 27, 49,  2 }, {    -34,  -18,    7, 27, 49,  2 }, {    -34,  -19,    7, 27, 49,  2 }, {    -35,  -20,    7, 27, 49,  2 },
    {    -36,  -21,    7, 27, 49,  2 }, {    -36,  -22,    6, 27, 49,  2 }, {    -37,  -23,    6, 27, 49,  2 }, {    -38,  -24,    6, 27, 49,  2 }, {    -38,  -25,    6, 27, 49,  2 },
    {    -39,  -26,    6, 26, 49,  2 }, {    -39,  -27,    6, 26, 49,  2 }, {    -40,  -28,    6, 26, 49,  2 }, {    -40,  -29,    5, 26, 49,  2 }, {    -41,  -30,    5, 26, 49,  2 },
    {    -41,  -31,    5, 26, 49,  2 }, {    -42,  -32,    5, 26, 49,  2 }, {    -42,  -33,    5, 26, 49,  2 }, {    -43,  -34,    5, 26, 49,  2 }, {    -43,  -35,    5, 26, 49,  2 },
    {    -43,  -36,    4, 26, 49,  2 }, {    -44,  -37,    4, 26, 49,  2 }, {    -44,  -38,    4, 26, 49,  2 }, {    -44,  -39,    4, 26, 49,  2 }, {    -45,  -40,    4, 25, 49,  2 },
    {    -45,  -41,    4, 25, 49,  2 }, {    -45,  -42,    4, 25, 49,  2 }, {    -45,  -43,    3, 25, 49,  2 }, {    -46,  -44,    3, 25, 49,  2 }, {    -46,  -45,    3, 25, 49,  2 },
    {    -46,  -46,    3, 25, 49,  2 }, {    -46,  -47,    3, 25, 49,  2 }, {    -46,  -48,    3, 25, 49,  2 }, {    -47,  -49,    3, 25, 49,  2 }, {    -47,  -50,    2, 25, 49,  2 },
    {    -47,  -51,    2, 25, 49,  2 }, {    -47,  -52,    2, 25, 49,  2 }, {    -47,  -53,    2, 25, 49,  2 }, {    -47,  -54,    2, 25, 49,  2 }, {    -48,  -55,    2, 25, 49,  2 },
    {    -48,  -56,    2, 24, 49,  2 }, {    -48,  -57,    1, 24, 49,  2 }, {    -48,  -58,    1, 24, 49,  2 }, {    -48,  -59,    1, 24, 49,  2 }, {    -48,  -60,    1, 24, 49,  2 },
    {    -48,  -61,    1, 24, 49,  2 }, {    -48,  -62,    1, 24, 49,  2 }, {    -48,  -63,    1, 24, 49,  2 }, {    -48,  -64,    0, 24, 49,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B32D6, {
    {     16,    0,   16,  8, 49,  2 }, {     16,    1,   16,  8, 49,  2 }, {     16,    2,   16,  8, 49,  2 }, {     16,    3,   16,  8, 49,  2 }, {     16,    4,   16,  8, 49,  2 },
    {     16,    5,   16,  8, 49,  2 }, {     16,    6,   16,  8, 49,  2 }, {     16,    7,   16,  8, 49,  2 }, {     16,    8,   15,  7, 49,  2 }, {     15,    9,   15,  7, 49,  2 },
    {     15,   10,   15,  7, 49,  2 }, {     15,   11,   15,  7, 49,  2 }, {     15,   12,   15,  7, 49,  2 }, {     15,   13,   15,  7, 49,  2 }, {     15,   14,   15,  7, 49,  2 },
    {     14,   15,   14,  7, 49,  2 }, {     14,   16,   14,  7, 49,  2 }, {     14,   17,   14,  7, 49,  2 }, {     14,   18,   14,  7, 49,  2 }, {     14,   19,   14,  7, 49,  2 },
    {     13,   20,   14,  7, 49,  2 }, {     13,   21,   14,  7, 49,  2 }, {     13,   22,   13,  6, 49,  2 }, {     13,   23,   13,  6, 49,  2 }, {     12,   24,   13,  6, 49,  2 },
    {     12,   25,   13,  6, 49,  2 }, {     12,   26,   13,  6, 49,  2 }, {     11,   27,   13,  6, 49,  2 }, {     11,   28,   13,  6, 49,  2 }, {     11,   29,   12,  6, 49,  2 },
    {     10,   30,   12,  6, 49,  2 }, {     10,   31,   12,  6, 49,  2 }, {      9,   32,   12,  6, 49,  2 }, {      9,   33,   12,  6, 49,  2 }, {      8,   34,   12,  6, 49,  2 },
    {      8,   35,   12,  6, 49,  2 }, {      7,   36,   11,  6, 49,  2 }, {      7,   37,   11,  5, 49,  2 }, {      6,   38,   11,  5, 49,  2 }, {      6,   39,   11,  5, 49,  2 },
    {      5,   40,   11,  5, 49,  2 }, {      4,   41,   11,  5, 49,  2 }, {      4,   42,   11,  5, 49,  2 }, {      3,   43,   11,  5, 49,  2 }, {      2,   44,   10,  5, 49,  2 },
    {      2,   45,   10,  5, 49,  2 }, {      1,   46,   10,  5, 49,  2 }, {      0,   47,   10,  5, 49,  2 }, {      0,   48,   10,  5, 49,  2 }, {     -1,   49,   10,  5, 49,  2 },
    {     -2,   50,   10,  4, 49,  2 }, {     -3,   51,    9,  4, 49,  2 }, {     -3,   52,    9,  4, 49,  2 }, {     -4,   53,    9,  4, 49,  2 }, {     -5,   54,    9,  4, 49,  2 },
    {     -6,   55,    9,  4, 49,  2 }, {     -7,   56,    9,  4, 49,  2 }, {     -7,   57,    9,  4, 49,  2 }, {     -8,   58,    8,  4, 49,  2 }, {     -9,   59,    8,  4, 49,  2 },
    {    -10,   60,    8,  4, 49,  2 }, {    -11,   61,    8,  4, 49,  2 }, {    -12,   61,    8,  4, 49,  2 }, {    -13,   62,    8,  3, 49,  2 }, {    -14,   63,    8,  3, 49,  2 },
    {    -15,   64,    7,  3, 49,  2 }, {    -16,   64,    7,  3, 49,  2 }, {    -17,   65,    7,  3, 49,  2 }, {    -18,   66,    7,  3, 49,  2 }, {    -19,   66,    7,  3, 49,  2 },
    {    -20,   67,    7,  3, 49,  2 }, {    -21,   68,    7,  3, 49,  2 }, {    -22,   68,    6,  3, 49,  2 }, {    -23,   69,    6,  3, 49,  2 }, {    -24,   70,    6,  3, 49,  2 },
    {    -25,   70,    6,  3, 49,  2 }, {    -26,   71,    6,  2, 49,  2 }, {    -27,   71,    6,  2, 49,  2 }, {    -28,   72,    6,  2, 49,  2 }, {    -29,   72,    6,  2, 49,  2 },
    {    -30,   73,    5,  2, 49,  2 }, {    -31,   73,    5,  2, 49,  2 }, {    -32,   74,    5,  2, 49,  2 }, {    -33,   74,    5,  2, 49,  2 }, {    -34,   75,    5,  2, 49,  2 },
    {    -35,   75,    5,  2, 49,  2 }, {    -36,   75,    5,  2, 49,  2 }, {    -37,   76,    4,  2, 49,  2 }, {    -38,   76,    4,  2, 49,  2 }, {    -39,   76,    4,  2, 49,  2 },
    {    -40,   77,    4,  1, 49,  2 }, {    -41,   77,    4,  1, 49,  2 }, {    -42,   77,    4,  1, 49,  2 }, {    -43,   77,    4,  1, 49,  2 }, {    -44,   78,    3,  1, 49,  2 },
    {    -45,   78,    3,  1, 49,  2 }, {    -46,   78,    3,  1, 49,  2 }, {    -47,   78,    3,  1, 49,  2 }, {    -48,   78,    3,  1, 49,  2 }, {    -49,   79,    3,  1, 49,  2 },
    {    -50,   79,    3,  1, 49,  2 }, {    -51,   79,    2,  1, 49,  2 }, {    -52,   79,    2,  1, 49,  2 }, {    -53,   79,    2,  1, 49,  2 }, {    -54,   79,    2,  1, 49,  2 },
    {    -55,   80,    2,  1, 49,  2 }, {    -56,   80,    2,  0, 49,  2 }, {    -57,   80,    2,  0, 49,  2 }, {    -58,   80,    1,  0, 49,  2 }, {    -59,   80,    1,  0, 49,  2 },
    {    -60,   80,    1,  0, 49,  2 }, {    -61,   80,    1,  0, 49,  2 }, {    -62,   80,    1,  0, 49,  2 }, {    -63,   80,    1,  0, 49,  2 }, {    -64,   80,    1,  0, 49,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B36E3, {
    {      0,   16,   16, 16, 49,  2 }, {      1,   16,   16, 16, 49,  2 }, {      2,   16,   16, 16, 49,  2 }, {      3,   16,   16, 16, 49,  2 }, {      4,   16,   16, 16, 49,  2 },
    {      5,   16,   16, 16, 49,  2 }, {      6,   16,   16, 16, 49,  2 }, {      7,   16,   16, 16, 49,  2 }, {      8,   16,   15, 15, 49,  2 }, {      9,   17,   15, 15, 49,  2 },
    {     10,   17,   15, 15, 49,  2 }, {     11,   17,   15, 15, 49,  2 }, {     12,   17,   15, 15, 49,  2 }, {     13,   17,   15, 15, 49,  2 }, {     14,   17,   15, 15, 49,  2 },
    {     15,   18,   14, 15, 49,  2 }, {     16,   18,   14, 15, 49,  2 }, {     17,   18,   14, 15, 49,  2 }, {     18,   18,   14, 15, 49,  2 }, {     19,   18,   14, 15, 49,  2 },
    {     20,   19,   14, 15, 49,  2 }, {     21,   19,   14, 15, 49,  2 }, {     22,   19,   13, 14, 49,  2 }, {     23,   19,   13, 14, 49,  2 }, {     24,   20,   13, 14, 49,  2 },
    {     25,   20,   13, 14, 49,  2 }, {     26,   20,   13, 14, 49,  2 }, {     27,   21,   13, 14, 49,  2 }, {     28,   21,   13, 14, 49,  2 }, {     29,   21,   12, 14, 49,  2 },
    {     30,   22,   12, 14, 49,  2 }, {     31,   22,   12, 14, 49,  2 }, {     32,   23,   12, 14, 49,  2 }, {     33,   23,   12, 14, 49,  2 }, {     34,   24,   12, 14, 49,  2 },
    {     35,   24,   12, 14, 49,  2 }, {     36,   25,   11, 14, 49,  2 }, {     37,   25,   11, 13, 49,  2 }, {     38,   26,   11, 13, 49,  2 }, {     39,   26,   11, 13, 49,  2 },
    {     40,   27,   11, 13, 49,  2 }, {     41,   28,   11, 13, 49,  2 }, {     42,   28,   11, 13, 49,  2 }, {     43,   29,   10, 13, 49,  2 }, {     44,   30,   10, 13, 49,  2 },
    {     45,   30,   10, 13, 49,  2 }, {     46,   31,   10, 13, 49,  2 }, {     47,   32,   10, 13, 49,  2 }, {     48,   32,   10, 13, 49,  2 }, {     49,   33,   10, 13, 49,  2 },
    {     50,   34,    9, 12, 49,  2 }, {     51,   35,    9, 12, 49,  2 }, {     52,   35,    9, 12, 49,  2 }, {     53,   36,    9, 12, 49,  2 }, {     54,   37,    9, 12, 49,  2 },
    {     55,   38,    9, 12, 49,  2 }, {     56,   39,    9, 12, 49,  2 }, {     57,   39,    8, 12, 49,  2 }, {     58,   40,    8, 12, 49,  2 }, {     59,   41,    8, 12, 49,  2 },
    {     60,   42,    8, 12, 49,  2 }, {     61,   43,    8, 12, 49,  2 }, {     61,   44,    8, 12, 49,  2 }, {     62,   45,    8, 11, 49,  2 }, {     63,   46,    8, 11, 49,  2 },
    {     64,   47,    7, 11, 49,  2 }, {     64,   48,    7, 11, 49,  2 }, {     65,   49,    7, 11, 49,  2 }, {     66,   50,    7, 11, 49,  2 }, {     66,   51,    7, 11, 49,  2 },
    {     67,   52,    7, 11, 49,  2 }, {     68,   53,    7, 11, 49,  2 }, {     68,   54,    6, 11, 49,  2 }, {     69,   55,    6, 11, 49,  2 }, {     70,   56,    6, 11, 49,  2 },
    {     70,   57,    6, 11, 49,  2 }, {     71,   58,    6, 10, 49,  2 }, {     71,   59,    6, 10, 49,  2 }, {     72,   60,    6, 10, 49,  2 }, {     72,   61,    5, 10, 49,  2 },
    {     73,   62,    5, 10, 49,  2 }, {     73,   63,    5, 10, 49,  2 }, {     74,   64,    5, 10, 49,  2 }, {     74,   65,    5, 10, 49,  2 }, {     75,   66,    5, 10, 49,  2 },
    {     75,   67,    5, 10, 49,  2 }, {     75,   68,    4, 10, 49,  2 }, {     76,   69,    4, 10, 49,  2 }, {     76,   70,    4, 10, 49,  2 }, {     76,   71,    4, 10, 49,  2 },
    {     77,   72,    4,  9, 49,  2 }, {     77,   73,    4,  9, 49,  2 }, {     77,   74,    4,  9, 49,  2 }, {     77,   75,    3,  9, 49,  2 }, {     78,   76,    3,  9, 49,  2 },
    {     78,   77,    3,  9, 49,  2 }, {     78,   78,    3,  9, 49,  2 }, {     78,   79,    3,  9, 49,  2 }, {     78,   80,    3,  9, 49,  2 }, {     79,   81,    3,  9, 49,  2 },
    {     79,   82,    2,  9, 49,  2 }, {     79,   83,    2,  9, 49,  2 }, {     79,   84,    2,  9, 49,  2 }, {     79,   85,    2,  9, 49,  2 }, {     79,   86,    2,  9, 49,  2 },
    {     80,   87,    2,  9, 49,  2 }, {     80,   88,    2,  8, 49,  2 }, {     80,   89,    1,  8, 49,  2 }, {     80,   90,    1,  8, 49,  2 }, {     80,   91,    1,  8, 49,  2 },
    {     80,   92,    1,  8, 49,  2 }, {     80,   93,    1,  8, 49,  2 }, {     80,   94,    1,  8, 49,  2 }, {     80,   95,    1,  8, 49,  2 },
})

CREATE_VEHICLE_INFO(TrackVehicleInfo_8B3AE7, {
    {     16,   31,   16, 24, 49,  2 }, {     16,   30,   16, 24, 49,  2 }, {     16,   29,   16, 24, 49,  2 }, {     16,   28,   16, 24, 49,  2 }, {     16,   27,   16, 24, 49,  2 },
    {     16,   26,   16, 24, 49,  2 }, {     16,   25,   16, 24, 49,  2 }, {     16,   24,   15, 23, 49,  2 }, {     17,   23,   15, 23, 49,  2 }, {     17,   22,   15, 23, 49,  2 },
    {     17,   21,   15, 23, 49,  2 }, {     17,   20,   15, 23, 49,  2 }, {     17,   19,   15, 23, 49,  2 }, {     17,   18,   15, 23, 49,  2 }, {     18,   17,   14, 23, 49,  2 },
    {     18,   16,   14, 23, 49,  2 }, {     18,   15,   14, 23, 49,  2 }, {     18,   14,   14, 23, 49,  2 }, {     18,   13,   14, 23, 49,  2 }, {     19,   12,   14, 23, 49,  2 },
    {     19,   11,   14, 23, 49,  2 }, {     19,   10,   13, 22, 49,  2 }, {     19,    9,   13, 22, 49,  2 }, {     20,    8,   13, 22, 49,  2 }, {     20,    7,   13, 22, 49,  2 },
    {     20,    6,   13, 22, 49,  2 }, {     21,    5,   13, 22, 49,  2 }, {     21,    4,   13, 22, 49,  2 }, {     21,    3,   12, 22, 49,  2 }, {     22,    2,   12, 22, 49,  2 },
    {     22,    1,   12, 22, 49,  2 }, {     23,    0,   12, 22, 49,  2 }, {     23,   -1,   12, 22, 49,  2 }, {     24,   -2,   12, 22, 49,  2 }, {     24,   -3,   12, 22, 49,  2 },
    {     25,   -4,   11, 22, 49,  2 }, {     25,   -5,   11, 21, 49,  2 }, {     26,   -6,   11, 21, 49,  2 }, {     26,   -7,   11, 21, 49,  2 }, {     27,   -8,   11, 21, 49,  2 },
    {     28,   -9,   11, 21, 49,  2 }, {     28,  -10,   11, 21, 49,  2 }, {     29,  -11,   10, 21, 49,  2 }, {     30,  -12,   10, 21, 49,  2 }, {     30,  -13,   10, 21, 49,  2 },
    {     31,  -14,   10, 21, 49,  2 }, {     32,  -15,   10, 21, 49,  2 }, {     32,  -16,   10, 21, 49,  2 }, {     33,  -17,   10, 21, 49,  2 }, {     34,  -18,    9, 20, 49,  2 },
    {     35,  -19,    9, 20, 49,  2 }, {     35,  -20,    9, 20, 49,  2 }, {     36,  -21,    9, 20, 49,  2 }, {     37,  -22,    9, 20, 49,  2 }, {     38,  -23,    9, 20, 49,  2 },
    {     39,  -24,    9, 20, 49,  2 }, {     39,  -25,    8, 20, 49,  2 }, {     40,  -26,    8, 20, 49,  2 }, {     41,  -27,    8, 20, 49,  2 }, {     42,  -28,    8, 20, 49,  2 },
    {     43,  -29,    8, 20, 49,  2 }, {     44,  -29,    8, 20, 49,  2 }, {     45,  -30,    8, 19, 49,  2 }, {     46,  -31,    7, 19, 49,  2 }, {     47,  -32,    7, 19, 49,  2 },
    {     48,  -32,    7, 19, 49,  2 }, {     49,  -33,    7, 19, 49,  2 }, {     50,  -34,    7, 19, 49,  2 }, {     51,  -34,    7, 19, 49,  2 }, {     52,  -35,    7, 19, 49,  2 },
    {     53,  -36,    6, 19, 49,  2 }, {     54,  -36,    6, 19, 49,  2 }, {     55,  -37,    6, 19, 49,  2 }, {     56,  -38,    6, 19, 49,  2 }, {     57,  -38,    6, 19, 49,  2 },
    {     58,  -39,    6, 18, 49,  2 }, {     59,  -39,    6, 18, 49,  2 }, {     60,  -40,    5, 18, 49,  2 }, {  