/************************************************************************
*																		*
*					Personal Work  - Jim Schimpf						*
*				Pandora Products Inc - STANDARD BUFFERED FILE I/O		*
*  					Copyright 1988 Jim Schimpf							*
*  					Copyright 1991 Jim Schimpf							*
*  					Copyright 1992 Jim Schimpf							*
*					Copyright 1995 Jim Schimpf							*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*					BUFFERED FILE OPERATIONS							*
*																		*
*		Module: filepac1.c												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		 12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		29-Jul-91	J.Schimpf	Add rewind function					*
*	0.3		 3-Aug-91	J.Schimpf	Add ftell,fseek & rewind			*
*	0.4		31-Dec-92	J.Schimpf	Convert for THINK C 5.0				*
*	0.5		 1-Jan-93	J.Schimpf	Don't return file name in input		*
*	0.6		16-Feb-93	J.Schimpf	Add fprintf							*
*	0.7		16-Feb-93	J.Schimpf	Put in correction for FTELL			*
*	0.8		12-Mar-93	J.Schimpf	Accept \n as line terminator in 	*
*									FGETS								*
*	0.9		 8-Aug-95	J.Schimpf	Convert to object					*
*	1.0		10-Aug-95	J.Schimpf	Allow user control of type,signature*
*									file type lists						*
*	1.1		 9-Nov-95	J.Schimpf	Change to buffered only				*
*	1.2		14-May-96	J.Schimpf	Add ref # to open by name			*
*	1.3		28-Jun-96	J.Schimpf	Add FSSpec operations				*
*	1.4		 2-Aug-96	J.Schimpf	Add FSSpec CREATE (only sys 7)		*
*	1.5		 3-Aug-96	J.Schimpf	Add GETEOF (file size) operation	*
*	1.6		18-Aug-96	J.Schimpf	Remove inherited					*
*	1.7		26-Sep-98	J.Schimpf	Convert to ANSI std operations		*
*	1.8		29-Sep-98	J.Schimpf	Use VA_ARGS to handle fprintf		*
*																		*
*	DESCRIPTION:													    *
*		This file uses the ANSI std file technique to open a file		*
*		These are ment as adjuncts to a UNIX style program				*
*		These are buffered file I/O routines							*
*																		*
*	Methods:															*
*																		*
*	Name					Description 								*
*-----------------------------------------------------------------------*
*																		*
************************************************************************/

/******* INCLUDE FILES ******/

#include "CBufFile.h"
#include <stdarg.h>

/***** MODULE GLOBALS ******/

/***********************************************************************
*		CONSTRUCTOR/DESCTRUCTOR OPERATIONS
***********************************************************************/
/***********************************************************************
*
*  CBufFile(void)	- Class constructor
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*			Initialize all internal variables to default states
*
***********************************************************************/

CBufFile::CBufFile(void)
{
	fp = NULL;		// Mark FILE pointer as MT
}

/***********************************************************************
*
*  ~CBufFile(void)	- Class destructor
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*			If file is not closed then close it now
*
***********************************************************************/

CBufFile::~CBufFile(void)
{
	if( fp != NULL )
		this->fclose();
}


/***********************************************************************
*		OPEN/CLOSE OPERATIONS
***********************************************************************/
/***********************************************************************
*
*  fopen( name,type )	- Open a buffered file
*
*	INPUT:	name	- File name to be opened
*						(NOTE: CAN BE '\0', this is the default name)
*			type	- "r" or "w" supported
*						"r" => OPEN
*						"w" => CREATE
*
*	OUTPUT:	Pointer to file buffer structure
*			NULL returned if open not possible
*			NOTE: Opened file name returned in fp->filename
*
************************************************************************/

bool CBufFile::fopen(char *name,char *type)
{

	fp = ::fopen( name,type );
	if( fp != NULL )
		return( true );
	else
		return( false );
}


/***********************************************************************
*
*  FCLOSE( void )	- Close a buffered file
*
*	INPUT:	NONE
*
*	OUTPUT:	Close the file and reset the buffer structure
*
************************************************************************/

void CBufFile::fclose( void )
{
	if( fp != NULL )
		::fclose( fp );
	fp = NULL;
}

/***********************************************************************
*		BUFFERED FILE I/O OPERATIONS
************************************************************************/
/***********************************************************************
*
*  int FPRINTF(char *format,...)	- FPRINT for MY_FILE **** PROBLEM WITH THIS***
*
*	INPUT:	format	- File format for print
*
*	OUTPUT:	# Items printed
*
************************************************************************/

int CBufFile::fprintf(char *format,...)
{
	int count;
	va_list arg;
	
	va_start( arg,format );

	count = ::vfprintf(fp,format,arg);
	
	va_end( arg );
	
	return( count );
}

/***********************************************************************
*
*  FPUTS( str )
*
*	INPUT:	str		- String to be output
*
*	OUTPUT:	Outputs string to file with no appended \n
*			EOF returned on error
*			# Characters written returned otherwise
*
************************************************************************/

int CBufFile::fputs( char *str )
{
	int err;
		
	if( fp != NULL )
		err = ::fputs( str,fp );
	else
		err = EOF;
	return( err );
}

/***********************************************************************
*
*  FGETS( str,size )
*
*	INPUT:	str		- String to be output
*			size	- Size of buffer
*
*	OUTPUT:	NULL returned if file at EOF
*			Otherwise copy file data into str up to and
*			including a terminating \n
*			Return pointer to buffer
*
************************************************************************/

char * CBufFile::fgets( char *str,int size )
{
	char *ptr = NULL;

	if( fp != NULL )
		ptr = ::fgets(str,size,fp);
	return( ptr );
}

/***********************************************************************
*
*  FREAD(char *buffer,int size)
*
*	INPUT:	buffer	- Data returned in here
*			size	- Read this many characters 
*
*	OUTPUT:	# bytes actually read or EOF
*			Return pointer to buffer
*
************************************************************************/

int CBufFile::fread( char *str,int size )
{
	int rtn = EOF;

	if( fp != NULL )
		rtn = ::fread(str,size,1,fp);
	return( rtn );
	
}

/***********************************************************************
*
*  FWRITE( char *buf,int size )
*
*	INPUT:	buf		- Buffer to be output
*			size	- # Bytes in buffer
*			
*
*	OUTPUT:	Outputs buffer to file
*			EOF returned on error
*			# Characters written returned otherwise
*
************************************************************************/

int CBufFile::fwrite( char *buf,int size )
{
	int err = EOF;

	if( fp != NULL )
		err = ::fwrite( buf,size,1,fp );
	return( err );
	
}

/***********************************************************************
*		BUFFERED FILE POSITION OPERATIONS
************************************************************************/
/***********************************************************************
*
*  FTELL( void )	- Read present psn in file
*
*	INPUT:	NONE
*
*	OUTPUT:	Present psn in file or -1 otherwise
*
************************************************************************/

long  CBufFile::ftell( void )
{
	long result = (long) 0;

	if( fp != NULL )
		result = ::ftell( fp );
	return( result );
	
}

/***********************************************************************
*
*  FSEEK( long offset,int whence )	- Move to psn in file
*
*	INPUT:	offset	- Byte # of psn in file
*			whence	- SEEK_SET	=> Beginning of file
*					- SEEK_CUR	=> Current psn
*					- SEEK_END	=> End of file
*
*	OUTPUT:	0 if OK, <> 0 if not
*
************************************************************************/

int  CBufFile::fseek( long offset,int whence )
{
	long result = (long)EOF;

	if( fp != NULL )
		result = ::fseek( fp, offset,whence );
	return( result );
	
}

/***********************************************************************
*
*  FFLUSH( void )	- Flush buffers
*
*	INPUT:	NONE
*
*	OUTPUT:	NONE
*			Flush output buffer
*
************************************************************************/

void  CBufFile::fflush( )
{

	if( fp != NULL )
		::fflush( fp );
}

/***********************************************************************
*
*  REWIND( void )	- Move a buffered file back to start
*
*	INPUT:	NONE
*
*	OUTPUT:	<> = false if OK
*			Rewind a file back to start
*
************************************************************************/

int  CBufFile::rewind( void )
{
	int result;
	
	/* Use the fseek to do this */
	
	result = this->fseek((long)0,SEEK_SET );
	return( result );
}
