/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf Std Support Stuff			*
*					Copyright 1998 Jim Schimpf							*
*  																		*
*						MAC FILE LEXICAL ANALYZER						*
*																		*
*		Module:CTokFile.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		12-Feb-88	J.Schimpf	Initial Version						*
*	0.2		 3-Aug-91	J.Schimpf	Add seek,tell & rewind				*
*	0.3		 1-Jan-92	J.Schimpf	Add file name to MFILE				*
*	0.4		 8-Aug-95	J.Schimpf	Convert to object					*
*	0.5		22-Sep-95	J.Schimpf	Convert to file tokenizer			*
*	0.6		22-Jan-97	J.Schimpf	Add initializer						*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*																		*
************************************************************************/

#include "CTokFile.h"

#pragma once

/*  USEFUL STUFF */

#define MAX_LEX_TOK_SIZE	32			// Max size of searched for token

typedef struct {
					int lex_value;
					char token[MAX_LEX_TOK_SIZE];
				} LEX_TOKEN;

#define MAX_LEX_LIST_SIZE	32			// Maximum # tokens to find


// Lexical returns

#define LEX_BUF_EOL		-2		// End of line found
#define LEX_BUF_EOF		-1		// End of FILE found
#define LEX_BUF_TOK		-3		// Token returned	Unmatched token found
#define LEX_QUOT_TOK	-4		// Quoted token
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class CLexFile : public CTokFile {

	public:
	
		void init(int cnt,LEX_TOKEN *tlist);	// Initialize for run
		
		int get_token( char *token );			// Get a token
		void unget_token(void);					// Unget last token received
		
	private:

		LEX_TOKEN	list[MAX_LEX_LIST_SIZE];
		int numTokens;							// # Tokens in list

};
