/************************************************************************
*																		*
* 					Jim Schimpf - Pandora Products 						*
*					Copyright 2002 Jim Schimpf							*
*  																		*
*					MAC PROJECT BUILDER LEXICAL ANALYZER				*
*																		*
*		Module:CpbxLexFile.h											*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	1.0		27-Jul-2002	J.Schimpf	Convert to pbxproj file lexer		*
*	1.1		27-Sep-2003 J.Schimpf	Add string marker					*
*																		*
*	DESCRIPTION:													    *
*		Converts file to a stream of tokens								*
*		TOKEN := [<WS chars>]<Contigious characters = TOKEN>[<WS>]		*
*				 Maximum # characters in token in MAX_TOK				*
*		Characters in a line following <COMMENT_CHAR> are ignored to EOL*
*		NOTE: Files are treated as lines and TOKENS cannot be extend	*
*		over line breaks												*
*																		*
*																		*
************************************************************************/

#include "CLexFile.h"

#pragma once

/*  USEFUL STUFF */

#define MAX_C_TOKEN		128

// *** POSSIBLE C TYPES TO BE DECODED ***
enum {
		P_TOK_PATH,
		P_TOK_OBJ_START,
		P_TOK_OBJ_END,
		P_TOK_END,
		P_TOK_LINK,
		P_TOK_LIST,
		P_TOK_NAME,
		P_TOK_UNKPUNCT
	};
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class CpbxLexFile : public CLexFile {

	public:
	
		void init(void);	// Initialize for run
		
		int get_token( char *token );			// Get a token
		void unget_token();						// Unget last token received
		int get_char( );						// Pull one character at a time
		void unget_char();						// Restore last char to buf
	private:

		int get_pending_token( char *token );

		char cur_token[MAX_C_TOKEN];
		int tok_psn;
		
		// Added to handle UNGET
		
		bool unget;
		char unget_val[MAX_C_TOKEN];
		int unget_type;

};
