/************************************************************************
*                                                                       *
*           			JIm Schimpf Pandora Products        			*
*                   	Copyright 2002  Pandora Products             	*
*                                                                       *
*                            BASE DATA TYPES                            *
*                                                                       *
*       Module:base.h                                                   *
*                                                                       *
*   Version     Date    Person      Description                         *
*-----------------------------------------------------------------------*
*	0.1		28-Jul-2002	J.Schimpf	Initial version						(
*                                                                       *
*   DESCRIPTION:                                                        *
*       These are the base data types                                   *
*                                                                       *
*																		*
************************************************************************/

#ifndef _BASE_
#define _BASE_ 1


/*  BASE DATA TYPES */

#ifndef NULL
#define	NULL	(void *) 0	/*  DEFINED SO WE DON'T NEED STDIO */
#endif
#ifndef EOF
#define	EOF	(-1)
#endif

typedef char BOOLEAN;		/* TRUE/FALSE type */
typedef int  (*IFC)(void);	/* Function returning an int */
typedef void (*VFC)(void);	/* Pointer to void function */

typedef int (*VFY)(int w,char *data);	/* Verify FUNCTION */

/*  BASE CONSTANTS */

#ifndef TRUE
#define TRUE    0xff
#define FALSE   0
#endif

#define LESS    0
#define EQUAL   1
#define MORE    2

/*  Useful MACROS */

#define FREE(x)         if( x != NULL )\
				free( (char *)x )

#define COMPARE( x,y )  ( x == y ? EQUAL : ( x < y ? LESS : MORE ))

/*  Return TRUE on > 0 and FALSE on < 0 */

#define SIGN( x )       (( x < 0 ) ? FALSE : TRUE )

#endif

