/************************************************************************
*																		*
* 			Pandora Products - Jim Schimpf PBXPROJ File Reader			*
*					Copyright 2002 Jim Schimpf							*
*  																		*
*		MAC FILE SYNTAX ANALYZER FOR Mac Project Builder Files			*
*																		*
*		Module:CPBXPROJ.h												*
*																		*
*	Version		Date	Person  	Description							*
*-----------------------------------------------------------------------*
*	0.1		28-Jul-2002	J.Schimpf	Initial Version						*
*	0.2		31-Jul-2002 J.Schimpf	Got makefile generation to work		*
*	0.3		14-Mar-2003	J.Schimpf	Put isa's in their own symbol table	*
*																		*
*	DESCRIPTION:													    *
*		This file reads the tokens from a PBXPROJ file and produces a 	*
*	file structure linked list of objects								*
*																		*
*																		*
************************************************************************/

#include "CSymbol.h"
#include "CpbxLexFile.h"

#pragma once

// ***** STRUCTURE DEF *******

typedef struct pbx_dummy
{
	struct pbx_dummy	*child;			// Child object
	struct pbx_dummy	*sibling;		// Object on same level
	struct pbx_dummy	*parent;		// Object on next level
	char				*name;			// Object name
	char				*isa;			// ISA Value
	char				*value;			// Value of object (if any)
} PBXPROJ;
			
/************************************************************
*		OBJECT DEFS
************************************************************/

class CPbxProj  {

	public:
	
		CPbxProj(CpbxLexFile *fp,bool debug_flag );		// Start project
		~CPbxProj( void );								// End project
		
		PBXPROJ *GetPBX(void);							// Get the created object
		
		void printPBX( PBXPROJ *proj );					// Print listing
		
		PBXPROJ *find_object( PBXPROJ *parent,			// Search tree
							  char *name,
							  char *value);
							  
		PBXPROJ *find_objectbysym( int nth,char *name );	// Search symbol table
		
	private:
	
		PBXPROJ *build_object( PBXPROJ *parent,
							   char *name);
		
		void finish_object( PBXPROJ *object );
	
		void do_comment(void);					// Eat a comment line
		void do_path( char *path,bool abs );
		void remove_object( PBXPROJ *object );	// Remove this object and all children

		void printPBXint( int indent,PBXPROJ *proj );// Print listing
		
		PBXPROJ *find_objint( bool name_srch,
		                      char *name,
							  bool val_srch,
							  char *value,
							  PBXPROJ *object );
							  
		CpbxLexFile 	*in;					// Input object
		CSymbol			*syms;					// Symbol list
		
		PBXPROJ			*base;					// Base symbol list
		
		bool			debug;					// DEBUG Print

};
