/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class ExtremityTriangle
extends Extremity {
    private UPolygon polygon = new UPolygon();
    private final boolean fill;
    private final HColor backgroundColor;
    private final XPoint2D contact;

    @Override
    public XPoint2D somePoint() {
        return this.contact;
    }

    public ExtremityTriangle(XPoint2D p1, double angle, boolean fill, HColor backgroundColor, int xWing, int yAperture) {
        this.backgroundColor = backgroundColor;
        this.fill = fill;
        this.contact = new XPoint2D(p1.getX(), p1.getY());
        angle = this.manageround(angle);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.addPoint(-xWing, -yAperture);
        this.polygon.addPoint(-xWing, yAperture);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(angle + 1.5707963267948966);
        this.polygon = this.polygon.translate(p1.getX(), p1.getY());
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.backgroundColor != null) {
            ug = ug.apply(this.backgroundColor.bg());
        } else if (this.fill) {
            ug = ug.apply(HColors.changeBack(ug));
        }
        ug.draw(this.polygon);
    }
}

