/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.internal;

import java.util.Iterator;
import java.util.Stack;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;

public class CognitiveComplexityVisitor
extends JavaParserVisitorAdapter {
    public static final CognitiveComplexityVisitor INSTANCE = new CognitiveComplexityVisitor();

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        State state = (State)data;
        boolean isNotElseIf = !(node.getNthParent(2) instanceof ASTIfStatement);
        node.getCondition().jjtAccept(this, data);
        if (isNotElseIf) {
            state.structuralComplexity();
        }
        node.getThenBranch().jjtAccept(this, data);
        if (isNotElseIf) {
            state.decreaseNestingLevel();
        }
        if (node.hasElse()) {
            state.hybridComplexity();
            node.getElseBranch().jjtAccept(this, data);
            state.decreaseNestingLevel();
        }
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return data;
    }

    @Override
    public Object visit(ASTContinueStatement node, Object data) {
        boolean hasLabel;
        State state = (State)data;
        boolean bl = hasLabel = node.getImage() != null;
        if (hasLabel) {
            state.fundamentalComplexity();
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTBreakStatement node, Object data) {
        boolean hasLabel;
        State state = (State)data;
        boolean bl = hasLabel = node.getImage() != null;
        if (hasLabel) {
            state.fundamentalComplexity();
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return data;
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return data;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return data;
    }

    @Override
    public Object visit(ASTConditionalAndExpression node, Object data) {
        State state = (State)data;
        state.booleanOperation(State.BooleanOp.AND);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        State state = (State)data;
        state.booleanOperation(State.BooleanOp.OR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUnaryExpressionNotPlusMinus node, Object data) {
        State state = (State)data;
        String op = node.getOperator();
        if ("!".equals(op)) {
            state.booleanOperation(null);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTBlockStatement node, Object data) {
        State state = (State)data;
        for (JavaNode child : node.children()) {
            state.booleanOperation(null);
            child.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        State state = (State)data;
        state.pushMethod(node);
        super.visit(node, data);
        state.popMethod();
        return data;
    }

    @Override
    public Object visit(ASTPrimaryPrefix node, Object data) {
        ASTName name;
        JavaNode child;
        State state = (State)data;
        Iterator it = node.children().iterator();
        if (it.hasNext() && (child = (JavaNode)it.next()) instanceof ASTName && (name = (ASTName)child).getNameDeclaration() instanceof MethodNameDeclaration) {
            ASTMethodDeclaration parent = (ASTMethodDeclaration)name.getNameDeclaration().getNode().getParent();
            state.callMethod(parent);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        State state = (State)data;
        state.structuralComplexity();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return state;
    }

    @Override
    public Object visit(ASTLambdaExpression node, Object data) {
        State state = (State)data;
        state.increaseNestingLevel();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return state;
    }

    @Override
    public Object visit(ASTClassOrInterfaceBody node, Object data) {
        State state = (State)data;
        state.increaseNestingLevel();
        super.visit(node, data);
        state.decreaseNestingLevel();
        return state;
    }

    public static class State {
        private int complexity = 0;
        private int nestingLevel = 0;
        private BooleanOp currentBooleanOperation = null;
        private Stack<ASTMethodDeclaration> methodStack = new Stack();

        public double getComplexity() {
            return this.complexity;
        }

        void hybridComplexity() {
            ++this.complexity;
            ++this.nestingLevel;
        }

        void fundamentalComplexity() {
            ++this.complexity;
        }

        void structuralComplexity() {
            ++this.complexity;
            this.complexity += this.nestingLevel;
            ++this.nestingLevel;
        }

        void increaseNestingLevel() {
            ++this.nestingLevel;
        }

        void decreaseNestingLevel() {
            --this.nestingLevel;
        }

        void booleanOperation(BooleanOp op) {
            if (this.currentBooleanOperation != op) {
                if (op != null) {
                    this.fundamentalComplexity();
                }
                this.currentBooleanOperation = op;
            }
        }

        void pushMethod(ASTMethodDeclaration calledMethod) {
            this.methodStack.push(calledMethod);
        }

        void popMethod() {
            this.methodStack.pop();
        }

        void callMethod(ASTMethodDeclaration calledMethod) {
            if (this.methodStack.contains(calledMethod)) {
                this.fundamentalComplexity();
            }
        }

        public static enum BooleanOp {
            AND,
            OR;

        }
    }
}

