/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuraEnabledContextRule
implements AnnotationContextRule {
    private static final AuraEnabledContextRule INSTANCE = new AuraEnabledContextRule();
    private static final Pattern AURA_PROPERTY_NAME = Pattern.compile("(?i)get(.*)");
    private static final TypeInfoVisitor<Boolean> NOOP = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        protected Boolean _default(TypeInfo type) {
            return true;
        }
    };
    private static final TypeInfoVisitor<Boolean> VISITOR = new TypeInfoVisitor.Default<Boolean>(){

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return type.getCodeUnitDetails().isApexSourceBased();
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            return type.getBasicType() != BasicType.SET && type.andArguments(this);
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType() == BasicType.VOID || type.getBasicType().getXmlType() != null;
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }
    };

    private AuraEnabledContextRule() {
    }

    public static AuraEnabledContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        MethodInfo method = context.getMethodInfo();
        assert (!method.isConstructor());
        if (method.getModifiers().not(ModifierTypeInfos.STATIC)) {
            Matcher matcher = AURA_PROPERTY_NAME.matcher(method.getName());
            if (!matcher.matches()) {
                context.addNodeError(I18nSupport.getLabel("non.static.aura.method.must.begin.with.get"));
            } else {
                String propertyName = matcher.group(1);
                FieldInfo field = context.getDefiningType().fields().get(context.getSymbols(), context.getDefiningType(), propertyName, FieldTable.LookupMode.INSTANCE_VARIABLE);
                if (field != null && field.getModifiers().has(AnnotationTypeInfos.AURA_ENABLED)) {
                    context.addNodeError(I18nSupport.getLabel("aura.duplicate.method.field", propertyName));
                }
            }
            if (!method.getParameters().isEmpty()) {
                context.addNodeError(I18nSupport.getLabel("non.static.aura.method.cannot.have.params"));
            }
            AnnotationRuleUtil.validate(context, AnnotationTypeInfos.AURA_ENABLED, NOOP, VISITOR);
        } else {
            AnnotationRuleUtil.validate(context, AnnotationTypeInfos.AURA_ENABLED, VISITOR, VISITOR);
        }
    }

    @Override
    public void validate(FieldContext context) {
        if (context.getFieldInfo().getMemberType() != Member.Type.PROPERTY) {
            AnnotationRuleUtil.validate(context, AnnotationTypeInfos.AURA_ENABLED, VISITOR);
        }
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

