/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.impl.document.BadLocationException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Optional;
import org.eclipse.lsp4j.Position;

public class PrefixCompletionActivationStrategy {
    private static final char FULLY_QUALIFIED_NAME_SEPARATOR_CHAR = '.';
    private final Document document;
    private final Position position;

    @AssistedInject
    public PrefixCompletionActivationStrategy(@Assisted Document document, @Assisted Position position) {
        this.document = document;
        this.position = position;
    }

    public boolean shouldSuggestTopLevel() {
        try {
            Optional<String> completionPrefix = this.getCompletionPrefix();
            return completionPrefix.filter(s -> s.indexOf(46) == -1).isPresent();
        }
        catch (BadLocationException ble) {
            return false;
        }
    }

    public Optional<String> getCompletionPrefix() throws BadLocationException {
        char currentChar;
        int lineOffset = this.document.getLineOffset(this.position.getLine());
        int offset = lineOffset + this.position.getCharacter();
        if (offset > this.document.getLength()) {
            return Optional.empty();
        }
        int length = 0;
        while (--offset >= 0 && (Character.isJavaIdentifierPart(currentChar = this.document.getChar(offset)) || currentChar == '.')) {
            ++length;
        }
        return Optional.of(this.document.getSource(offset + 1, length));
    }
}

