/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.common.collect.MoreCollections;
import apex.common.collect.MoreIterables;
import apex.jorje.semantic.common.iterable.EnclosingTypeIterable;
import apex.jorje.semantic.common.iterable.ExtendedTypeIterable;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import java.util.Collection;
import java.util.List;

public class TypeInfoUtil {
    private TypeInfoUtil() {
    }

    public static boolean isTopLevel(TypeInfo type) {
        return type.getEnclosingType() == null;
    }

    public static boolean isInnerType(TypeInfo type) {
        return type.getEnclosingType() != null;
    }

    public static TypeInfo getTopLevel(TypeInfo type) {
        return TypeInfoUtil.isTopLevel(type) ? type : type.getEnclosingType();
    }

    public static boolean isInnerTypeOfAnonymous(TypeInfo type) {
        return TypeInfoUtil.isInnerType(type) && type.getEnclosingType().getUnitType() == UnitType.ANONYMOUS;
    }

    public static boolean isInnerTypeOfTrigger(TypeInfo type) {
        return TypeInfoUtil.isInnerType(type) && type.getEnclosingType().getUnitType() == UnitType.TRIGGER;
    }

    public static boolean isTestClass(TypeInfo type) {
        return MoreIterables.ensureAny(new EnclosingTypeIterable(type), input -> input.getModifiers().isTest());
    }

    public static boolean isTestSetup(TypeInfo type) {
        return MoreIterables.ensureAny(new EnclosingTypeIterable(type), input -> input.getModifiers().has(AnnotationTypeInfos.TEST_SETUP));
    }

    public static boolean areTopLevelTypesSame(TypeInfo left, TypeInfo right) {
        return TypeInfoUtil.isRawEquivalent(TypeInfoUtil.getTopLevel(left), TypeInfoUtil.getTopLevel(right));
    }

    private static boolean isRawEquivalent(TypeInfo left, TypeInfo right) {
        return TypeInfoEquivalence.isEquivalent(GenericTypeInfoUtil.getRootType(left), GenericTypeInfoUtil.getRootType(right));
    }

    public static boolean isInTestClass(Member member) {
        return TypeInfoUtil.isTestClass(member.getDefiningType());
    }

    public static boolean isFastCallType(TypeInfo type) {
        return type.isResolved() && (CollectionTypeInfoUtil.isMapOrCollection(type) || CollectionTypeInfoUtil.isListIterator(type));
    }

    public static boolean hasFastCallType(List<TypeInfo> types) {
        for (TypeInfo type : types) {
            if (!TypeInfoUtil.isFastCallType(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstructable(TypeInfo type) {
        return type.methods().hasConstructors();
    }

    public static boolean isAncestor(TypeInfo type, TypeInfo ancestor) {
        for (TypeInfo current : new ExtendedTypeIterable(type)) {
            if (!TypeInfoEquivalence.isEquivalent(current, ancestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPlaceholders(List<TypeInfo> argumentTypes) {
        return MoreIterables.ensureAny(argumentTypes, TypeNameUtil.HAS_PLACEHOLDER);
    }

    public static TypeInfo peelType(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) ? CollectionTypeInfoUtil.getElementType(type) : type;
    }

    public static Collection<TypeInfo> parentTypes(TypeInfo type) {
        return type.parents().superType() == null ? type.parents().immediateInterfaces() : MoreCollections.prependCollection(type.parents().superType(), type.parents().immediateInterfaces());
    }

    public static TypeInfo getRealType(final SymbolResolver symbols, final TypeInfo definingType, TypeInfo type) {
        return type.accept(new TypeInfoVisitor.Default<TypeInfo>(){

            @Override
            protected TypeInfo _default(TypeInfo type) {
                return type;
            }

            @Override
            public TypeInfo visit(InternalTypeInfo type) {
                return symbols.lookupTypeInfo(definingType, type);
            }
        });
    }
}

