/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.lsp.impl.visitors.IntegerScope;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.common.collect.Iterables;
import java.util.List;

public class IndexUtil {
    public static int computeEndOffset(final String source, AstNode node) {
        return IntegerScope.evaluate(node, new AstVisitor<IntegerScope>(){

            @Override
            protected boolean defaultVisit() {
                return false;
            }

            @Override
            public void visitEnd(ArrayLoadExpression node, IntegerScope scope) {
                int endOffset = IndexUtil.computeEndOffset(source, node.getIndex());
                scope.setValue(source.indexOf(93, endOffset) + 1);
            }

            @Override
            public void visitEnd(ArrayStoreExpression node, IntegerScope scope) {
                int endOffset = IndexUtil.computeEndOffset(source, node.getIndex());
                scope.setValue(source.indexOf(93, endOffset) + 1);
            }

            @Override
            public void visitEnd(BinaryExpression node, IntegerScope scope) {
                scope.setValue(IndexUtil.computeEndOffset(source, node.getRight()));
            }

            @Override
            public void visitEnd(BooleanExpression node, IntegerScope scope) {
                scope.setValue(IndexUtil.computeEndOffset(source, node.getRight()));
            }

            @Override
            public void visitEnd(CastExpression node, IntegerScope scope) {
                scope.setValue(IndexUtil.computeEndOffset(source, node.getExpression()));
            }

            @Override
            public void visitEnd(ClassRefExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(InstanceOfExpression node, IntegerScope scope) {
                if (node.getTypeRef() == null) {
                    scope.setValue(node.getLoc().getEndIndex());
                    return;
                }
                int endOffset = node.getTypeRef().getTypeArguments().isEmpty() ? Iterables.getLast(node.getTypeRef().getNames()).getLoc().getEndIndex() : source.indexOf(62, IndexUtil.computeEndOffset(source, node.getTypeRef().getTypeArguments())) + 1;
                scope.setValue(endOffset);
            }

            @Override
            public void visitEnd(JavaMethodCallExpression node, IntegerScope scope) {
                int endOffset = node.getParameters().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getParameters()));
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(JavaVariableExpression node, IntegerScope scope) {
                scope.setValue(Iterables.getLast(node.getNames()).getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(LiteralExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(MethodCallExpression node, IntegerScope scope) {
                int endOffset = node.getInputParameters().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getInputParameters()));
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewKeyValueObjectExpression node, IntegerScope scope) {
                int endOffset = node.getParameters().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getParameters()).getExpression());
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewListInitExpression node, IntegerScope scope) {
                int endOffset = node.getInit() == Expression.NOOP ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, node.getInit());
                scope.setValue(source.indexOf(IndexUtil.getNewListInitEndToken(source, node), endOffset) + 1);
            }

            @Override
            public void visitEnd(NewListLiteralExpression node, IntegerScope scope) {
                int endOffset = node.getElements().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getElements()));
                scope.setValue(source.indexOf(125, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewMapInitExpression node, IntegerScope scope) {
                int endOffset = node.getInit() == Expression.NOOP ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, node.getInit());
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewMapLiteralExpression node, IntegerScope scope) {
                int endOffset = node.getEntries().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getEntries()).getValue());
                scope.setValue(source.indexOf(125, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewObjectExpression node, IntegerScope scope) {
                int endOffset = node.getParameters().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getParameters()));
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewSetInitExpression node, IntegerScope scope) {
                int endOffset = node.getInit() == Expression.NOOP ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, node.getInit());
                scope.setValue(source.indexOf(41, endOffset) + 1);
            }

            @Override
            public void visitEnd(NewSetLiteralExpression node, IntegerScope scope) {
                int endOffset = node.getElements().isEmpty() ? node.getLoc().getEndIndex() : IndexUtil.computeEndOffset(source, Iterables.getLast(node.getElements()));
                scope.setValue(source.indexOf(125, endOffset) + 1);
            }

            @Override
            public void visitEnd(PrefixExpression node, IntegerScope scope) {
                scope.setValue(IndexUtil.computeEndOffset(source, node.getExpression()));
            }

            @Override
            public void visitEnd(SoqlExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(SoslExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(TernaryExpression node, IntegerScope scope) {
                scope.setValue(IndexUtil.computeEndOffset(source, node.getFalseExpression()));
            }

            @Override
            public void visitEnd(TriggerVariableExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }

            @Override
            public void visitEnd(VariableExpression node, IntegerScope scope) {
                scope.setValue(node.getLoc().getEndIndex());
            }
        }, -1);
    }

    private static int computeEndOffset(String source, List<TypeRef> typeRefs) {
        if (typeRefs.isEmpty()) {
            return -1;
        }
        TypeRef lastTypeRef = Iterables.getLast(typeRefs);
        if (lastTypeRef.getTypeArguments().isEmpty()) {
            return Iterables.getLast(lastTypeRef.getNames()).getLoc().getEndIndex();
        }
        return source.indexOf(62, IndexUtil.computeEndOffset(source, lastTypeRef.getTypeArguments())) + 1;
    }

    private static char getNewListInitEndToken(String source, NewListInitExpression expression) {
        for (int i = expression.getLoc().getEndIndex(); i < source.length(); ++i) {
            if (source.charAt(i) == '(') {
                return ')';
            }
            if (source.charAt(i) != '[') continue;
            return ']';
        }
        return source.charAt(source.length() - 1);
    }
}

