/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath.saxon;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.internal.AstNodeOwner;
import net.sourceforge.pmd.lang.ast.xpath.saxon.AttributeNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.BaseNodeInfo;
import net.sourceforge.pmd.lang.ast.xpath.saxon.DocumentNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.IdGenerator;
import net.sourceforge.pmd.lang.rule.xpath.SaxonXPathRuleQuery;

@Deprecated
@InternalApi
public class ElementNode
extends BaseNodeInfo
implements AstNodeOwner {
    protected final DocumentNode document;
    protected final ElementNode parent;
    protected final Node node;
    protected final int id;
    protected final int siblingPosition;
    protected final NodeInfo[] children;
    private Map<Integer, AttributeNode> attributes;

    @Deprecated
    public ElementNode(DocumentNode document, IdGenerator idGenerator, ElementNode parent, Node node, int siblingPosition) {
        this(document, idGenerator, parent, node, siblingPosition, SaxonXPathRuleQuery.getNamePool());
    }

    public ElementNode(DocumentNode document, IdGenerator idGenerator, ElementNode parent, Node node, int siblingPosition, NamePool namePool) {
        super(1, namePool, node.getXPathNodeName(), parent);
        this.document = document;
        this.parent = parent;
        this.node = node;
        this.id = idGenerator.getNextId();
        this.siblingPosition = siblingPosition;
        if (node.getNumChildren() > 0) {
            this.children = new NodeInfo[node.getNumChildren()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = new ElementNode(document, idGenerator, this, node.getChild(i), i, namePool);
            }
        } else {
            this.children = null;
        }
        document.nodeToElementNode.put(node, this);
    }

    private Map<Integer, AttributeNode> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Integer, AttributeNode>();
            Iterator<Attribute> iter = this.node.getXPathAttributesIterator();
            int idx = 0;
            while (iter.hasNext()) {
                Attribute next = iter.next();
                AttributeNode attrNode = new AttributeNode(this, next, idx++);
                this.attributes.put(attrNode.getFingerprint(), attrNode);
            }
        }
        return this.attributes;
    }

    @Override
    public Node getUnderlyingNode() {
        return this.node;
    }

    @Override
    public int getSiblingPosition() {
        return this.siblingPosition;
    }

    @Override
    public int getColumnNumber() {
        return this.node.getBeginColumn();
    }

    @Override
    public int getLineNumber() {
        return this.node.getBeginLine();
    }

    @Override
    public boolean hasChildNodes() {
        return this.children != null;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this.document;
    }

    @Override
    public String getLocalPart() {
        return this.node.getXPathNodeName();
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    @Override
    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public CharSequence getStringValueCS() {
        return "";
    }

    @Override
    public int compareOrder(NodeInfo other) {
        int result;
        if (this.isSameNodeInfo(other)) {
            result = 0;
        } else {
            result = Integer.signum(this.getLineNumber() - other.getLineNumber());
            if (result == 0) {
                result = Integer.signum(this.getColumnNumber() - other.getColumnNumber());
            }
            if (result == 0) {
                result = this.getParent().equals((Object)other.getParent()) ? Integer.signum(this.getSiblingPosition() - ((ElementNode)other).getSiblingPosition()) : 1;
            }
        }
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.getLocalPart();
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (axisNumber == 2 && nodeTest instanceof NameTest) {
            if ((nodeTest.getNodeKindMask() & 4) == 0) {
                return EmptyIterator.getInstance();
            }
            int fp = nodeTest.getFingerprint();
            if (fp != -1) {
                return SingleNodeIterator.makeIterator((NodeInfo)((NodeInfo)this.getAttributes().get(fp)));
            }
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: {
                return new Navigator.AncestorEnumeration((NodeInfo)this, false);
            }
            case 1: {
                return new Navigator.AncestorEnumeration((NodeInfo)this, true);
            }
            case 2: {
                return new AttributeEnumeration();
            }
            case 3: {
                if (this.children == null) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.children);
            }
            case 4: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
            }
            case 5: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration((NodeInfo)this);
            }
            case 7: {
                if (this.parent == null || this.siblingPosition == this.parent.children.length - 1) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.parent.children, this.siblingPosition + 1, this.parent.children.length);
            }
            case 8: {
                return super.iterateAxis(axisNumber);
            }
            case 9: {
                return SingleNodeIterator.makeIterator((NodeInfo)this.parent);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, false);
            }
            case 11: {
                if (this.parent == null || this.siblingPosition == 0) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.parent.children, 0, this.siblingPosition);
            }
            case 12: {
                return SingleNodeIterator.makeIterator((NodeInfo)this);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, true);
            }
        }
        return super.iterateAxis(axisNumber);
    }

    private class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private final Iterator<AttributeNode> iter;

        private AttributeEnumeration() {
            this.iter = ElementNode.this.getAttributes().values().iterator();
        }

        public void advance() {
            this.current = this.iter.hasNext() ? (NodeInfo)this.iter.next() : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration();
        }
    }
}

