/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.datasource.internal.AbstractDataSource;

public class ReaderDataSource
extends AbstractDataSource {
    private final Reader reader;
    private String dataSourceName;

    public ReaderDataSource(Reader reader, String dataSourceName) {
        this.reader = reader;
        this.dataSourceName = dataSourceName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return IOUtil.fromReader(this.reader);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputFileName) {
        return this.getDataSourceName();
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String toString() {
        return ReaderDataSource.class.getSimpleName() + '[' + this.dataSourceName + ']';
    }
}

