/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class AbstractClassWithoutAbstractMethodRule
extends AbstractJavaRule {
    public AbstractClassWithoutAbstractMethodRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isAbstract() || this.doesExtend(node) || this.doesImplement(node)) {
            return data;
        }
        int countOfAbstractMethods = 0;
        for (ASTAnyTypeBodyDeclaration decl : node.getDeclarations()) {
            ASTMethodDeclaration methodDecl;
            if (decl.getKind() != ASTAnyTypeBodyDeclaration.DeclarationKind.METHOD || !(methodDecl = (ASTMethodDeclaration)decl.getDeclarationNode()).isAbstract()) continue;
            ++countOfAbstractMethods;
        }
        if (countOfAbstractMethods == 0) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean doesExtend(ASTClassOrInterfaceDeclaration node) {
        return node.getFirstChildOfType(ASTExtendsList.class) != null;
    }

    private boolean doesImplement(ASTClassOrInterfaceDeclaration node) {
        return node.getFirstChildOfType(ASTImplementsList.class) != null;
    }
}

