/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import edu.emory.mathcs.backport.java.util.Collections;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.CommandLineOptions;
import net.sourceforge.pmd.DataSource;
import net.sourceforge.pmd.FileDataSource;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceFileSelector;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeDiscoverer;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import net.sourceforge.pmd.ZipDataSource;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.SourceFileOrDirectoryFilter;
import net.sourceforge.pmd.parsers.Parser;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandler;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandlerBroker;

public class PMD {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String VERSION = "3.9";
    public static final String EXCLUDE_MARKER = "NOPMD";
    private String excludeMarker = "NOPMD";
    private SourceTypeDiscoverer sourceTypeDiscoverer = new SourceTypeDiscoverer();

    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        SourceType sourceType = this.getSourceTypeOfFile(ctx.getSourceCodeFilename());
        this.processFile(reader, ruleSets, ctx, sourceType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx, SourceType sourceType) throws PMDException {
        try {
            try {
                SourceTypeHandler sourceTypeHandler = SourceTypeHandlerBroker.getVisitorsFactoryForSourceType(sourceType);
                ctx.setSourceType(sourceType);
                Parser parser = sourceTypeHandler.getParser();
                parser.setExcludeMarker(this.excludeMarker);
                Object rootNode = parser.parse(reader);
                ctx.excludeLines(parser.getExcludeMap());
                Thread.yield();
                sourceTypeHandler.getSymbolFacade().start(rootNode);
                Language language = SourceTypeToRuleLanguageMapper.getMappedLanguage(sourceType);
                if (ruleSets.usesDFA(language)) {
                    sourceTypeHandler.getDataFlowFacade().start(rootNode);
                }
                if (ruleSets.usesTypeResolution(language)) {
                    sourceTypeHandler.getTypeResolutionFacade().start(rootNode);
                }
                ArrayList<Object> acus = new ArrayList<Object>();
                acus.add(rootNode);
                ruleSets.apply(acus, ctx, language);
            }
            catch (ParseException pe) {
                throw new PMDException("Error while parsing " + ctx.getSourceCodeFilename(), pe);
            }
            catch (Exception e) {
                throw new PMDException("Error while processing " + ctx.getSourceCodeFilename(), e);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PMDException("Error while closing " + ctx.getSourceCodeFilename(), e);
            }
        }
        try {}
        catch (IOException e) {
            throw new PMDException("Error while closing " + ctx.getSourceCodeFilename(), e);
        }
        reader.close();
    }

    private SourceType getSourceTypeOfFile(String fileName) {
        SourceType sourceType = this.sourceTypeDiscoverer.getSourceTypeOfFile(fileName);
        if (sourceType == null) {
            sourceType = this.sourceTypeDiscoverer.getSourceTypeOfJavaFiles();
        }
        return sourceType;
    }

    public void processFile(Reader reader, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(reader, new RuleSets(ruleSet), ctx);
    }

    public void processFile(InputStream fileContents, String encoding, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSet, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException("Unsupported encoding exception: " + uee.getMessage());
        }
    }

    public void processFile(InputStream fileContents, String encoding, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSets, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException("Unsupported encoding exception: " + uee.getMessage());
        }
    }

    public void processFile(InputStream fileContents, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(fileContents, System.getProperty("file.encoding"), ruleSet, ctx);
    }

    public void setExcludeMarker(String marker) {
        this.excludeMarker = marker;
    }

    public void setJavaVersion(SourceType javaVersion) {
        this.sourceTypeDiscoverer.setSourceTypeOfJavaFiles(javaVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Writer w;
        CommandLineOptions opts;
        block21: {
            SourceType sourceType;
            opts = new CommandLineOptions(args);
            SourceFileSelector fileSelector = new SourceFileSelector();
            fileSelector.setSelectJavaFiles(opts.isCheckJavaFiles());
            fileSelector.setSelectJspFiles(opts.isCheckJspFiles());
            List files = opts.containsCommaSeparatedFileList() ? PMD.collectFromCommaDelimitedString(opts.getInputPath(), fileSelector) : PMD.collectFilesFromOneName(opts.getInputPath(), fileSelector);
            if (opts.getTargetJDK().equals("1.3")) {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.3 mode");
                }
                sourceType = SourceType.JAVA_13;
            } else if (opts.getTargetJDK().equals("1.5")) {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.5 mode");
                }
                sourceType = SourceType.JAVA_15;
            } else if (opts.getTargetJDK().equals("1.6")) {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.6 mode");
                }
                sourceType = SourceType.JAVA_16;
            } else {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.4 mode");
                }
                sourceType = SourceType.JAVA_14;
            }
            RuleContext ctx = new RuleContext();
            Report report = new Report();
            ctx.setReport(report);
            report.start();
            try {
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                ruleSetFactory.setMinimumPriority(opts.getMinPriority());
                RuleSets rulesets = ruleSetFactory.createRuleSets(opts.getRulesets());
                PMD.printRuleNamesInDebug(opts.debugEnabled(), rulesets);
                PMD.processFiles(opts.getCpus(), ruleSetFactory, sourceType, files, ctx, opts.getRulesets(), opts.debugEnabled(), opts.shortNamesEnabled(), opts.getInputPath(), opts.getEncoding(), opts.getExcludeMarker());
            }
            catch (RuleSetNotFoundException rsnfe) {
                System.out.println(opts.usage());
                rsnfe.printStackTrace();
            }
            report.end();
            w = null;
            Renderer r = opts.createRenderer();
            w = opts.getReportFile() != null ? new BufferedWriter(new FileWriter(opts.getReportFile())) : new OutputStreamWriter(System.out);
            r.render(w, ctx.getReport());
            w.write(EOL);
            w.flush();
            if (opts.getReportFile() == null) break block21;
            w.close();
        }
        Object var10_11 = null;
        if (opts.getReportFile() == null || w == null) return;
        try {
            w.close();
            return;
        }
        catch (Exception e2) {
            System.out.println(e2.getMessage());
        }
        return;
        {
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(opts.usage());
                if (opts.debugEnabled()) {
                    e.printStackTrace();
                }
                Object var10_12 = null;
                if (opts.getReportFile() == null || w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (Exception e2) {
                    System.out.println(e2.getMessage());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (opts.getReportFile() == null || w == null) throw throwable;
            try {
                w.close();
                throw throwable;
            }
            catch (Exception e2) {
                System.out.println(e2.getMessage());
            }
            throw throwable;
        }
    }

    public static void processFiles(int threadCount, RuleSetFactory ruleSetFactory, SourceType sourceType, List files, RuleContext ctx, String rulesets, boolean debugEnabled, boolean shortNamesEnabled, String inputPath, String encoding, String excludeMarker) {
        Object r;
        PmdThreadFactory factory = new PmdThreadFactory(ruleSetFactory);
        ExecutorService executor = Executors.newFixedThreadPool((int)threadCount, (ThreadFactory)factory);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            DataSource dataSource = (DataSource)i.next();
            String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
            r = new PmdRunnable(executor, dataSource, niceFileName, sourceType, debugEnabled, encoding, rulesets, excludeMarker);
            executor.execute((Runnable)r);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Report mainReport = ctx.getReport();
        Iterator i2 = factory.threadList.iterator();
        while (i2.hasNext()) {
            PmdThread thread = (PmdThread)i2.next();
            r = thread.context.getReport();
            mainReport.merge((Report)r);
        }
    }

    public void processFiles(List files, RuleContext ctx, RuleSets rulesets, boolean debugEnabled, boolean shortNamesEnabled, String inputPath, String encoding) throws IOException {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            DataSource dataSource = (DataSource)i.next();
            String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
            ctx.setSourceCodeFilename(niceFileName);
            if (debugEnabled) {
                System.out.println("Processing " + ctx.getSourceCodeFilename());
            }
            try {
                BufferedInputStream stream = new BufferedInputStream(dataSource.getInputStream());
                this.processFile((InputStream)stream, encoding, rulesets, ctx);
            }
            catch (PMDException pmde) {
                if (debugEnabled) {
                    pmde.getReason().printStackTrace();
                }
                ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), niceFileName));
            }
        }
    }

    private static void printRuleNamesInDebug(boolean debugEnabled, RuleSets rulesets) {
        if (debugEnabled) {
            Iterator i = rulesets.getAllRules().iterator();
            while (i.hasNext()) {
                Rule r = (Rule)i.next();
                System.out.println("Loaded rule " + r.getName());
            }
        }
    }

    private static List collectFilesFromOneName(String inputFileName, SourceFileSelector fileSelector) {
        return PMD.collect(inputFileName, fileSelector);
    }

    private static List collectFromCommaDelimitedString(String fileList, SourceFileSelector fileSelector) {
        ArrayList files = new ArrayList();
        StringTokenizer st = new StringTokenizer(fileList, ",");
        while (st.hasMoreTokens()) {
            files.addAll(PMD.collect(st.nextToken(), fileSelector));
        }
        return files;
    }

    private static List collect(String filename, SourceFileSelector fileSelector) {
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new RuntimeException("File " + inputFile.getName() + " doesn't exist");
        }
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (!inputFile.isDirectory()) {
            if (filename.endsWith(".zip") || filename.endsWith(".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(inputFile);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (!fileSelector.isWantedFile(zipEntry.getName())) continue;
                        dataSources.add(new ZipDataSource(zipFile, zipEntry));
                    }
                }
                catch (IOException ze) {
                    throw new RuntimeException("Zip file " + inputFile.getName() + " can't be opened");
                }
            } else {
                dataSources.add(new FileDataSource(inputFile));
            }
        } else {
            FileFinder finder = new FileFinder();
            List files = finder.findFilesFrom(inputFile.getAbsolutePath(), new SourceFileOrDirectoryFilter(fileSelector), true);
            Iterator i = files.iterator();
            while (i.hasNext()) {
                dataSources.add(new FileDataSource((File)i.next()));
            }
        }
        return dataSources;
    }

    private static class PmdThread
    extends Thread {
        private int id;
        private RuleContext context;
        private RuleSets rulesets;
        private RuleSetFactory ruleSetFactory;

        public PmdThread(int id, Runnable r, RuleSetFactory ruleSetFactory) {
            super(r, "PmdThread " + id);
            this.id = id;
            this.context = new RuleContext();
            this.context.setReport(new Report());
            this.ruleSetFactory = ruleSetFactory;
        }

        public RuleContext getRuleContext() {
            return this.context;
        }

        public RuleSets getRuleSets(String rsList) {
            if (this.rulesets == null) {
                try {
                    this.rulesets = this.ruleSetFactory.createRuleSets(rsList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.rulesets;
        }

        public String toString() {
            return "PmdThread " + this.id;
        }
    }

    private static class PmdThreadFactory
    implements ThreadFactory {
        private final RuleSetFactory ruleSetFactory;
        private final AtomicInteger counter = new AtomicInteger();
        public List threadList = Collections.synchronizedList(new LinkedList());

        public PmdThreadFactory(RuleSetFactory ruleSetFactory) {
            this.ruleSetFactory = ruleSetFactory;
        }

        public Thread newThread(Runnable r) {
            PmdThread t = new PmdThread(this.counter.incrementAndGet(), r, this.ruleSetFactory);
            this.threadList.add(t);
            return t;
        }
    }

    private static class PmdRunnable
    extends PMD
    implements Runnable {
        private final ExecutorService executor;
        private final DataSource dataSource;
        private final String fileName;
        private final boolean debugEnabled;
        private final String encoding;
        private final String rulesets;

        public PmdRunnable(ExecutorService executor, DataSource dataSource, String fileName, SourceType sourceType, boolean debugEnabled, String encoding, String rulesets, String excludeMarker) {
            this.executor = executor;
            this.dataSource = dataSource;
            this.fileName = fileName;
            this.debugEnabled = debugEnabled;
            this.encoding = encoding;
            this.rulesets = rulesets;
            this.setJavaVersion(sourceType);
            this.setExcludeMarker(excludeMarker);
        }

        public void run() {
            PmdThread thread = (PmdThread)Thread.currentThread();
            RuleContext ctx = thread.getRuleContext();
            RuleSets rs = thread.getRuleSets(this.rulesets);
            ctx.setSourceCodeFilename(this.fileName);
            if (this.debugEnabled) {
                System.out.println("Processing " + ctx.getSourceCodeFilename());
            }
            try {
                BufferedInputStream stream = new BufferedInputStream(this.dataSource.getInputStream());
                this.processFile((InputStream)stream, this.encoding, rs, ctx);
            }
            catch (PMDException pmde) {
                if (this.debugEnabled) {
                    pmde.getReason().printStackTrace();
                }
                ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), this.fileName));
            }
            catch (Throwable t) {
                if (this.debugEnabled) {
                    t.printStackTrace();
                }
                ctx.getReport().addError(new Report.ProcessingError(t.getMessage(), this.fileName));
                this.executor.shutdownNow();
            }
        }
    }
}

