/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;

public class AvoidFieldNameMatchingMethodName
extends AbstractRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        String varName = node.getVariableName();
        String fieldDeclaringType = this.getDeclaringType(node);
        if (varName != null) {
            varName = varName.toLowerCase();
            ASTClassOrInterfaceDeclaration cl = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
            if (cl != null) {
                List methods = cl.findChildrenOfType(ASTMethodDeclaration.class);
                Iterator it = methods.iterator();
                while (it.hasNext()) {
                    String n;
                    ASTMethodDeclaration m = (ASTMethodDeclaration)it.next();
                    if (!fieldDeclaringType.equals(this.getDeclaringType(m)) || !varName.equals((n = m.getMethodName()).toLowerCase())) continue;
                    this.addViolation(data, node);
                }
            }
        }
        return data;
    }
}

