/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xwpf.usermodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class UpdateEmbeddedDoc {
    private XWPFDocument doc;
    private File docFile;
    private static final int SHEET_NUM = 0;
    private static final int ROW_NUM = 0;
    private static final int CELL_NUM = 0;
    private static final double NEW_VALUE = 100.98;
    private static final String BINARY_EXTENSION = "xls";
    private static final String OPENXML_EXTENSION = "xlsx";

    public UpdateEmbeddedDoc(String filename) throws FileNotFoundException, IOException {
        this.docFile = new File(filename);
        if (!this.docFile.exists()) {
            throw new FileNotFoundException("The Word document " + filename + " does not exist.");
        }
        try (FileInputStream fis = new FileInputStream(this.docFile);){
            this.doc = new XWPFDocument((InputStream)fis);
        }
    }

    public void updateEmbeddedDoc() throws OpenXML4JException, IOException {
        List embeddedDocs = this.doc.getAllEmbeddedParts();
        for (PackagePart pPart : embeddedDocs) {
            String ext = pPart.getPartName().getExtension();
            if (!BINARY_EXTENSION.equals(ext) && !OPENXML_EXTENSION.equals(ext)) continue;
            InputStream is = pPart.getInputStream();
            Throwable throwable = null;
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                Throwable throwable2 = null;
                try {
                    OutputStream os = pPart.getOutputStream();
                    Throwable throwable3 = null;
                    try {
                        Sheet sheet = workbook.getSheetAt(0);
                        Row row = sheet.getRow(0);
                        Cell cell = row.getCell(0);
                        cell.setCellValue(100.98);
                        workbook.write(os);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable3 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (workbook == null) continue;
                    if (throwable2 != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    workbook.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                is.close();
            }
        }
        if (!embeddedDocs.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(this.docFile);){
                this.doc.write((OutputStream)fos);
            }
        }
    }

    public void checkUpdatedDoc() throws OpenXML4JException, IOException {
        for (PackagePart pPart : this.doc.getAllEmbeddedParts()) {
            String ext = pPart.getPartName().getExtension();
            if (!BINARY_EXTENSION.equals(ext) && !OPENXML_EXTENSION.equals(ext)) continue;
            InputStream is = pPart.getInputStream();
            Throwable throwable = null;
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)is);
                Throwable throwable2 = null;
                try {
                    Sheet sheet = workbook.getSheetAt(0);
                    Row row = sheet.getRow(0);
                    Cell cell = row.getCell(0);
                    if (cell.getNumericCellValue() == 100.98) continue;
                    throw new IllegalStateException("Failed to validate document content.");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (workbook == null) continue;
                    if (throwable2 != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    workbook.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public static void main(String[] args) throws IOException, OpenXML4JException {
        UpdateEmbeddedDoc ued = new UpdateEmbeddedDoc(args[0]);
        ued.updateEmbeddedDoc();
        ued.checkUpdatedDoc();
    }
}

