/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.context;

import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.internal.factory.BeanFactoryProvider;
import org.springframework.util.ClassUtils;

public class DefaultBeanFactoryProvider
implements BeanFactoryProvider {
    public void registerBeanDefinition(BeanDefinitionRegistry registry) {
        RootBeanDefinition factoryBean = new RootBeanDefinition();
        String factoryBeanName = this.getClass().getName();
        factoryBean.setBeanClassName(this.getClass().getName());
        factoryBean.addMetadataAttribute(new BeanMetadataAttribute("JAVA_CONFIG_IGNORE", (Object)true));
        registry.registerBeanDefinition(factoryBeanName, (BeanDefinition)factoryBean);
        RootBeanDefinition bff = new RootBeanDefinition();
        bff.setFactoryBeanName(factoryBeanName);
        bff.setFactoryMethodName("createBeanFactory");
        bff.setScope("prototype");
        bff.addMetadataAttribute(new BeanMetadataAttribute("JAVA_CONFIG_IGNORE", (Object)true));
        registry.registerBeanDefinition(BeanFactoryProvider.BEAN_NAME, (BeanDefinition)bff);
    }

    public BeanFactory createBeanFactory(String className) throws Exception {
        return new JavaConfigApplicationContext(ClassUtils.getDefaultClassLoader().loadClass(className));
    }
}

