/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.enhancement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.core.DefaultGeneratorStrategy;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.ClassWriter;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.AutoBean;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.ExternalBean;
import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.annotation.aop.ScopedProxy;
import org.springframework.config.java.internal.enhancement.AddAnnotationAdapter;
import org.springframework.config.java.internal.enhancement.CglibCallbackThreadLocalCleanup;
import org.springframework.config.java.internal.enhancement.ConfigurationEnhancer;
import org.springframework.config.java.internal.factory.BeanVisibility;
import org.springframework.config.java.internal.factory.JavaConfigBeanFactory;
import org.springframework.config.java.internal.factory.support.ConfigurationModelBeanDefinitionReader;
import org.springframework.config.java.model.ModelMethod;
import org.springframework.config.java.valuesource.CompositeValueResolver;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CglibConfigurationEnhancer
implements ConfigurationEnhancer {
    private static final Log log = LogFactory.getLog(CglibConfigurationEnhancer.class);
    private static final CallbackFilter CALLBACK_FILTER = new CallbackFilter(){

        public int accept(Method candidateMethod) {
            if (AnnotationUtils.findAnnotation((Method)candidateMethod, Bean.class) != null) {
                return 1;
            }
            if (AnnotationUtils.findAnnotation((Method)candidateMethod, ExternalBean.class) != null) {
                return 2;
            }
            if (AnnotationUtils.findAnnotation((Method)candidateMethod, AutoBean.class) != null) {
                return 3;
            }
            if (AnnotationUtils.findAnnotation((Method)candidateMethod, ExternalValue.class) != null) {
                return 4;
            }
            return 0;
        }
    };
    private static final Class<?>[] CALLBACK_TYPES = new Class[]{NoOp.class, BeanMethodInterceptor.class, ExternalBeanMethodInterceptor.class, AutoBeanMethodInterceptor.class, ExternalValueMethodInterceptor.class};
    private final JavaConfigBeanFactory beanFactory;

    public CglibConfigurationEnhancer(JavaConfigBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must be non-null");
        this.beanFactory = beanFactory;
        this.registerThreadLocalCleanupBeanDefinition();
    }

    private void registerThreadLocalCleanupBeanDefinition() {
        RootBeanDefinition beanDef = new RootBeanDefinition(CglibCallbackThreadLocalCleanup.class);
        beanDef.addMetadataAttribute(new BeanMetadataAttribute("JAVA_CONFIG_IGNORE", (Object)true));
        this.beanFactory.registerBeanDefinition("cglibThreadLocalCleanup", (BeanDefinition)beanDef);
    }

    @Override
    public String enhance(String configClassName) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Enhancing " + configClassName));
        }
        Class<?> superclass = this.loadClassFromName(configClassName);
        Class<?> subclass = CglibConfigurationEnhancer.newEnhancer(superclass).createClass();
        subclass = this.nestOneClassDeeperIfAspect(superclass, subclass);
        Enhancer.registerCallbacks(subclass, (Callback[])new Callback[]{NoOp.INSTANCE, new BeanMethodInterceptor(this.beanFactory), new ExternalBeanMethodInterceptor(this.beanFactory), new AutoBeanMethodInterceptor(this.beanFactory), new ExternalValueMethodInterceptor(this.beanFactory)});
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Successfully enhanced %s; enhanced class name is: %s", configClassName, subclass.getName()));
        }
        return subclass.getName();
    }

    private Class<?> nestOneClassDeeperIfAspect(Class<?> superclass, Class<?> subclass) {
        boolean superclassIsAnAspect = false;
        Annotation[] annotationArray = superclass.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation anno = annotationArray[n2];
            if (anno.annotationType().getName().equals("org.aspectj.lang.annotation.Aspect")) {
                superclassIsAnAspect = true;
            }
            ++n2;
        }
        if (!superclassIsAnAspect) {
            return subclass;
        }
        Enhancer enhancer = CglibConfigurationEnhancer.newEnhancer(subclass);
        enhancer.setStrategy((GeneratorStrategy)new DefaultGeneratorStrategy(){

            protected byte[] transform(byte[] b) throws Exception {
                ClassWriter writer = new ClassWriter(false);
                AddAnnotationAdapter adapter = new AddAnnotationAdapter((ClassVisitor)writer, "Lorg/aspectj/lang/annotation/Aspect;");
                ClassReader reader = new ClassReader(b);
                reader.accept((ClassVisitor)adapter, false);
                return writer.toByteArray();
            }
        });
        return enhancer.createClass();
    }

    private static Enhancer newEnhancer(Class<?> superclass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setUseCache(true);
        enhancer.setSuperclass(superclass);
        enhancer.setUseFactory(false);
        enhancer.setCallbackFilter(CALLBACK_FILTER);
        enhancer.setCallbackTypes((Class[])CALLBACK_TYPES);
        return enhancer;
    }

    private Class<?> loadClassFromName(String configClassName) {
        try {
            return ClassUtils.getDefaultClassLoader().loadClass(configClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("class must be loadable", ex);
        }
    }

    static abstract class AbstractMethodInterceptor
    implements MethodInterceptor {
        protected final Log log = LogFactory.getLog(this.getClass());
        protected final JavaConfigBeanFactory beanFactory;

        public AbstractMethodInterceptor(JavaConfigBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Object intercept(Object o, Method m, Object[] args, MethodProxy mp) throws Throwable {
            ModelMethod beanMethod = ModelMethod.forMethod(m);
            String beanName = this.beanFactory.getBeanNamingStrategy().getBeanName(beanMethod);
            return this.doIntercept(o, m, args, mp, beanName);
        }

        protected abstract Object doIntercept(Object var1, Method var2, Object[] var3, MethodProxy var4, String var5) throws Throwable;
    }

    static class AutoBeanMethodInterceptor
    extends AbstractMethodInterceptor {
        public AutoBeanMethodInterceptor(JavaConfigBeanFactory beanFactory) {
            super(beanFactory);
        }

        public Object doIntercept(Object o, Method m, Object[] args, MethodProxy mp, String beanName) throws Throwable {
            AutoBean metadata = (AutoBean)AnnotationUtils.findAnnotation((Method)m, AutoBean.class);
            Assert.notNull((Object)metadata, (String)"AutoBean methods must be annotated with @AutoBean");
            return this.beanFactory.getBean(beanName);
        }
    }

    static class BeanMethodInterceptor
    extends AbstractMethodInterceptor {
        public BeanMethodInterceptor(JavaConfigBeanFactory beanFactory) {
            super(beanFactory);
        }

        public Object doIntercept(Object o, Method m, Object[] args, MethodProxy mp, String _beanName) throws Throwable {
            boolean isScopedProxy = AnnotationUtils.findAnnotation((Method)m, ScopedProxy.class) != null;
            String scopedBeanName = ConfigurationModelBeanDefinitionReader.resolveHiddenScopedProxyBeanName(_beanName);
            String beanName = isScopedProxy && this.beanFactory.isCurrentlyInCreation(scopedBeanName) ? scopedBeanName : _beanName;
            if (this.factoryContainsBean(beanName)) {
                Object cachedBean = this.beanFactory.getBean(beanName);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)String.format("Returning cached singleton object [%s] for @Bean method %s.%s", cachedBean, m.getDeclaringClass().getSimpleName(), beanName));
                }
                return cachedBean;
            }
            Object bean = mp.invokeSuper(o, args);
            Bean metadata = (Bean)AnnotationUtils.findAnnotation((Method)m, Bean.class);
            if (metadata.scope().equals("singleton")) {
                BeanVisibility visibility = BeanVisibility.visibilityOf(m.getModifiers());
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)String.format("Registering new %s singleton object [%s] for @Bean method %s.%s", new Object[]{visibility, bean, m.getDeclaringClass().getSimpleName(), beanName}));
                }
                this.beanFactory.registerSingleton(beanName, bean, visibility);
            }
            return bean;
        }

        private boolean factoryContainsBean(String beanName) {
            return this.beanFactory.containsBean(beanName) && !this.beanFactory.isCurrentlyInCreation(beanName);
        }
    }

    static class ExternalBeanMethodInterceptor
    extends AbstractMethodInterceptor {
        public ExternalBeanMethodInterceptor(JavaConfigBeanFactory beanFactory) {
            super(beanFactory);
        }

        public Object doIntercept(Object o, Method m, Object[] args, MethodProxy mp, String beanName) throws Throwable {
            ExternalBean extBean = (ExternalBean)AnnotationUtils.findAnnotation((Method)m, ExternalBean.class);
            Assert.notNull((Object)extBean, (String)"ExternalBean methods must be annotated with @ExternalBean");
            String alternateName = extBean.value();
            return this.beanFactory.getBean(StringUtils.hasLength((String)alternateName) ? alternateName : beanName);
        }
    }

    static class ExternalValueMethodInterceptor
    extends AbstractMethodInterceptor {
        private CompositeValueResolver valueResolver;

        public ExternalValueMethodInterceptor(JavaConfigBeanFactory beanFactory) {
            super(beanFactory);
        }

        public Object doIntercept(Object o, Method m, Object[] args, MethodProxy mp, String beanName) throws Throwable {
            ExternalValue metadata = (ExternalValue)AnnotationUtils.findAnnotation((Method)m, ExternalValue.class);
            Assert.notNull((Object)metadata, (String)"ExternalValue methods must be annotated with @ExternalValue");
            String name = metadata.value();
            if (!StringUtils.hasLength((String)name) && (name = m.getName()).startsWith("get") && Character.isUpperCase(name.charAt(3))) {
                name = String.valueOf(Character.toLowerCase(name.charAt(3))) + name.substring(4);
            }
            Class<?> requiredType = m.getReturnType();
            if (this.valueResolver == null) {
                this.valueResolver = CompositeValueResolver.forMember(this.beanFactory.getParentBeanFactory(), m);
            }
            try {
                return this.valueResolver.resolve(name, requiredType);
            }
            catch (ValueResolutionException ex) {
                if (Modifier.isAbstract(m.getModifiers())) {
                    throw ex;
                }
                return mp.invokeSuper(o, args);
            }
        }
    }
}

