/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.model;

import java.lang.annotation.Annotation;
import java.util.List;
import org.springframework.config.java.annotation.AutoBean;
import org.springframework.config.java.internal.model.AbstractValidatableAnnotatedMethod;
import org.springframework.config.java.internal.model.UsageError;
import org.springframework.config.java.internal.util.AnnotationExtractionUtils;
import org.springframework.config.java.internal.util.MethodAnnotationPrototype;
import org.springframework.config.java.model.ModelClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoBeanMethod
extends AbstractValidatableAnnotatedMethod<AutoBean> {
    private static final AutoBean defaultAnno = AnnotationExtractionUtils.extractMethodAnnotation(AutoBean.class, new MethodAnnotationPrototype(){

        @AutoBean
        public void targetMethod() {
        }
    }.getClass());
    private final ModelClass returnType;

    public AutoBeanMethod(String name, ModelClass returnType, int modifiers, Annotation ... annotations) {
        super(name, modifiers, annotations);
        this.returnType = returnType;
    }

    AutoBeanMethod(String name, ModelClass returnType, int modifiers) {
        this(name, returnType, modifiers, defaultAnno);
    }

    public static boolean identifyAsExternalBeanMethod(Annotation[] annotations) {
        return AnnotationExtractionUtils.findAnnotation(AutoBean.class, annotations) != null;
    }

    public ModelClass getReturnType() {
        return this.returnType;
    }

    @Override
    public void detectUsageErrors(List<UsageError> errors) {
        super.detectUsageErrors(errors);
        if (this.returnType.isInterface()) {
            errors.add(new AbstractAutoBeanReturnTypeError());
        }
    }

    @Override
    public String toString() {
        return String.format("%s; returnType=%s", super.toString(), this.returnType.getSimpleName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoBeanMethod other = (AutoBeanMethod)obj;
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public class AbstractAutoBeanReturnTypeError
    extends UsageError {
        public AbstractAutoBeanReturnTypeError() {
            super(AutoBeanMethod.this.getDeclaringClass(), AutoBeanMethod.this.getLineNumber());
        }

        public String getDescription() {
            return "@AutoBean methods must return a concrete type";
        }
    }
}

