/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.process;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

import org.springframework.config.java.context.DefaultBeanFactoryProvider;
import org.springframework.config.java.internal.process.InternalConfigurationPostProcessor;
import org.springframework.config.java.naming.BeanNamingStrategy;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

import org.springframework.core.Ordered;

import org.springframework.util.Assert;


/** TODO: JAVADOC */
public class ConfigurationPostProcessor implements Ordered, ApplicationContextAware, BeanFactoryPostProcessor {

    private AbstractApplicationContext ctx;
    private BeanNamingStrategy beanNamingStrategy;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        new ConfigurationBeanDefinitionDecoratingBeanFactoryPostProcessor().postProcessBeanFactory(beanFactory);

        InternalConfigurationPostProcessor icpp =
            new InternalConfigurationPostProcessor(ctx, beanNamingStrategy, new DefaultBeanFactoryProvider());
        icpp.addIgnoredBeanPostProcessor(this.getClass().getName());
        icpp.postProcessBeanFactory(beanFactory);
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        Assert.isInstanceOf(AbstractApplicationContext.class, ctx);
        this.ctx = (AbstractApplicationContext) ctx;
    }

    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

    /**
     * In place for backward-compatibility with existing milestone releases.
     *
     * @deprecated  Use {@link #setBeanNamingStrategy(BeanNamingStrategy)} instead
     */
    @Deprecated
    public void setNamingStrategy(BeanNamingStrategy namingStrategy) {
        setBeanNamingStrategy(namingStrategy);
    }

    public void setBeanNamingStrategy(BeanNamingStrategy namingStrategy) {
        this.beanNamingStrategy = namingStrategy;
    }

}
