/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.atconfiguration;

import static org.junit.Assert.assertTrue;

import org.junit.Assert;
import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.internal.model.ConfigurationClass.FinalConfigurationError;
import org.springframework.config.java.internal.model.MalformedJavaConfigurationException;

import test.common.beans.TestBean;


/**
 * System test for usage errors with {@link Configuration} classes. Note: deals only specifically
 * with errors relating to the declaration and formatting of the classes themselves. For error
 * handling related to individual Bean/ExternalBean methods, etc., see their respective system test
 * packages.
 *
 * @author  Chris Beams
 */
public class ConfigurationErrorHandlingTests {

    @Test
    public void testInvalidFinalConfigurationClass() {
        try {
            // should throw, rejecting final configuration class;
            new JavaConfigApplicationContext(InvalidFinalConfigurationClass.class);
            Assert.fail("exception expected");
        } catch (MalformedJavaConfigurationException ex) {
            assertTrue(ex.containsError(FinalConfigurationError.class));
        }
    }

    @Configuration
    public static final class InvalidFinalConfigurationClass {
        @Bean
        public TestBean testBean() { return new TestBean(); }
    }

}
