/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.atimport;

import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.ImportXml;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.internal.model.ConfigurationModelBeanDefinitionReaderTests;
import org.springframework.config.java.internal.model.AsmConfigurationParserTests;

import test.common.beans.TestBean;

/**
 * Integration tests for {@code @ImportXml} support.
 *
 * @see AsmConfigurationParserTests#testRegistrationOfXmlImportAnnotation()
 * @see ConfigurationModelBeanDefinitionReaderTests#testXmlImport()
 *
 * @author Chris Beams
 */
public class ImportXmlTests {
    @Test
    public void testImportXmlWorks() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(ImportsXml.class);
        assertTrue("did not contain java-declared bean", ctx.containsBean("javaDeclaredBean"));
        assertTrue("did not contain xml-declared bean", ctx.containsBean("xmlDeclaredBean"));
    }

    @Configuration
    @ImportXml(locations="classpath:test/feature/atimport/beans.xml")
    static class ImportsXml {
        public @Bean TestBean javaDeclaredBean() {
            return new TestBean("java.declared");
        }
    }

    // -------------------------------------------------------------------------

    @Test
    public void testImportXmlWorksWithRelativePathing() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(ImportsXmlWithRelativeTo.class);
        assertTrue("did not contain java-declared bean", ctx.containsBean("javaDeclaredBean"));
        assertTrue("did not contain xml-declared bean", ctx.containsBean("xmlDeclaredBean"));
    }

    @Configuration
    @ImportXml(locations="beans.xml", relativeTo=ImportXmlTests.class)
    static class ImportsXmlWithRelativeTo {
        public @Bean TestBean javaDeclaredBean() {
            return new TestBean("java.declared");
        }
    }

}
