/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.jdbc;

import org.springframework.config.java.test.JavaConfigContextLoader;
import org.springframework.samples.petclinic.AbstractClinicTests;
import org.springframework.test.context.ContextConfiguration;

/**
 * Integration tests for the {@link SimpleJdbcClinic} implementation.
 * Demonstrates use of JavaConfigContextLoader to integrate with Spring 2.5's TestContext
 * framework. See SJC-71, SJC-184
 *
 * @author Thomas Risberg
 * @author Chris Beams
 */
@ContextConfiguration(locations = "org.springframework.samples.petclinic.config.JdbcPetclinicApplicationConfig",
                      loader = JavaConfigContextLoader.class)
public class SimpleJdbcClinicTests extends AbstractClinicTests { }
