/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.context.annotation.ScopedProxyMode;


/** TODO: JAVADOC */
public class ComponentScanDeclaration {

    private String[] basePackages;
    private String resourcePattern;
    private Class<?> nameGenerator;
    private boolean useDefaultFilters = true;
    private ScopedProxyMode scopedProxyMode = ScopedProxyMode.NO;
    private Class<?> scopeResolver;
    private boolean annotationConfig = true;
    // TODO: SJC-223
    // private Filter[] includeFilters;
    // private Filter[] excludeFilters;


    public String[] getBasePackages() {
        return basePackages;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }


    public boolean isUseDefaultFilters() {
        return useDefaultFilters;
    }

    public void setUseDefaultFilters(boolean useDefaultFilters) {
        this.useDefaultFilters = useDefaultFilters;
    }


    public String getResourcePattern() {
        return resourcePattern;
    }

    public void setResourcePattern(String resourcePattern) {
        this.resourcePattern = resourcePattern;
    }


    public Class<?> getNameGenerator() {
        return nameGenerator;
    }

    public void setNameGenerator(Class<?> nameGenerator) {
        this.nameGenerator = nameGenerator;
    }


    public Class<?> getScopeResolver() {
        return scopeResolver;
    }

    public void setScopeResolver(Class<?> scopeResolver) {
        this.scopeResolver = scopeResolver;
    }


    public ScopedProxyMode getScopedProxy() {
        return scopedProxyMode;
    }

    public void setScopedProxy(ScopedProxyMode scopedProxyMode) {
        this.scopedProxyMode = scopedProxyMode;
    }


    public boolean isAnnotationConfig() {
        return annotationConfig;
    }

    public void setAnnotationConfig(boolean annotationConfig) {
        this.annotationConfig = annotationConfig;
    }


    // TODO: SJC-223
    // public void setIncludeFilters(Filter[] includeFilters) {
    //    this.includeFilters = includeFilters;
    // }
    //
    // public void setExcludeFilters(Filter[] excludeFilters) {
    //    this.excludeFilters = excludeFilters;
    // }

}
