/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;

public interface ConnectionFactory {
    public MemcachedConnection createConnection(List<InetSocketAddress> var1) throws IOException;

    public MemcachedNode createMemcachedNode(SocketAddress var1, SocketChannel var2, int var3);

    public BlockingQueue<Operation> createOperationQueue();

    public BlockingQueue<Operation> createReadOperationQueue();

    public BlockingQueue<Operation> createWriteOperationQueue();

    public long getOpQueueMaxBlockTime();

    public NodeLocator createLocator(List<MemcachedNode> var1);

    public OperationFactory getOperationFactory();

    public long getOperationTimeout();

    public boolean isDaemon();

    public boolean useNagleAlgorithm();

    public Collection<ConnectionObserver> getInitialObservers();

    public FailureMode getFailureMode();

    public Transcoder<Object> getDefaultTranscoder();

    public boolean shouldOptimize();

    public int getReadBufSize();

    public HashAlgorithm getHashAlg();

    public long getMaxReconnectDelay();

    public AuthDescriptor getAuthDescriptor();

    public int getTimeoutExceptionThreshold();
}

