/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol;

import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.OperationStatus;

public class GetCallbackWrapper
implements GetOperation.Callback {
    private static final OperationStatus END = new OperationStatus(true, "END");
    private boolean completed = false;
    private int remainingKeys = 0;
    private GetOperation.Callback cb = null;

    public GetCallbackWrapper(int k, GetOperation.Callback c) {
        this.remainingKeys = k;
        this.cb = c;
    }

    @Override
    public void gotData(String key, int flags, byte[] data) {
        assert (!this.completed) : "Got data for a completed wrapped op";
        this.cb.gotData(key, flags, data);
        if (--this.remainingKeys == 0) {
            this.receivedStatus(END);
        }
    }

    @Override
    public void receivedStatus(OperationStatus status) {
        if (!this.completed) {
            this.cb.receivedStatus(status);
        }
    }

    @Override
    public void complete() {
        assert (!this.completed);
        this.cb.complete();
        this.completed = true;
    }
}

