/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.caching;

import de.jollyday.HolidayManager;
import de.jollyday.ManagerParameter;
import de.jollyday.datasource.ConfigurationDataSource;
import de.jollyday.datasource.ConfigurationDataSourceManager;
import de.jollyday.util.Cache;
import de.jollyday.util.ClassLoadingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolidayManagerValueHandler
extends Cache.ValueHandler<HolidayManager> {
    private ManagerParameter parameter;
    private String managerImplClassName;
    private ConfigurationDataSourceManager configurationDataSourceManager = new ConfigurationDataSourceManager();
    private ClassLoadingUtil classLoadingUtil = new ClassLoadingUtil();

    public HolidayManagerValueHandler(ManagerParameter parameter, String managerImplClassName) {
        this.parameter = parameter;
        this.managerImplClassName = managerImplClassName;
    }

    @Override
    public String getKey() {
        return this.parameter.createCacheKey();
    }

    @Override
    public HolidayManager createValue() {
        HolidayManager manager = this.instantiateManagerImpl(this.managerImplClassName);
        ConfigurationDataSource configurationDataSource = this.configurationDataSourceManager.getConfigurationDataSource(this.parameter);
        manager.setConfigurationDataSource(configurationDataSource);
        manager.init(this.parameter);
        return manager;
    }

    private HolidayManager instantiateManagerImpl(String managerImplClassName) {
        try {
            Class<?> managerImplClass = this.classLoadingUtil.loadClass(managerImplClassName);
            Object managerImplObject = managerImplClass.newInstance();
            return (HolidayManager)HolidayManager.class.cast(managerImplObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create manager class " + managerImplClassName, e);
        }
    }
}

