/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.data.DenseMatrix64F;

public class QrHelperFunctions {
    public static double findMax(double[] dArray, int n, int n2) {
        double d = -1.0;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            double d2 = dArray[i];
            double d3 = d2 = d2 < 0.0 ? -d2 : d2;
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static void divideElements(int n, int n2, double[] dArray, double d) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / d;
        }
    }

    public static void divideElements(int n, int n2, double[] dArray, int n3, double d) {
        for (int i = n; i < n2; ++i) {
            int n4 = i + n3;
            dArray[n4] = dArray[n4] / d;
        }
    }

    public static void divideElements_Brow(int n, int n2, double[] dArray, double[] dArray2, int n3, double d) {
        for (int i = n; i < n2; ++i) {
            int n4 = i + n3;
            double d2 = dArray2[n4] / d;
            dArray2[n4] = d2;
            dArray[i] = d2;
        }
    }

    public static void divideElements_Bcol(int n, int n2, int n3, double[] dArray, double[] dArray2, int n4, double d) {
        int n5 = n * n3 + n4;
        int n6 = n;
        while (n6 < n2) {
            int n7 = n6++;
            double d2 = dArray[n7] / d;
            dArray[n7] = d2;
            dArray2[n5] = d2;
            n5 += n3;
        }
    }

    public static double computeTauAndDivide(int n, int n2, double[] dArray, int n3, double d) {
        double d2 = 0.0;
        for (int i = n; i < n2; ++i) {
            int n4 = n3 + i;
            double d3 = dArray[n4] / d;
            dArray[n4] = d3;
            double d4 = d3;
            d2 += d4 * d4;
        }
        d2 = Math.sqrt(d2);
        if (dArray[n3 + n] < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    public static double computeTauAndDivide(int n, int n2, double[] dArray, double d) {
        double d2 = 0.0;
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            double d3 = dArray[n4] / d;
            dArray[n4] = d3;
            double d4 = d3;
            d2 += d4 * d4;
        }
        d2 = Math.sqrt(d2);
        if (dArray[n] < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    public static void rank1UpdateMultR(DenseMatrix64F denseMatrix64F, double[] dArray, double d, int n, int n2, int n3, double[] dArray2) {
        int n4;
        int n5;
        for (n5 = n; n5 < denseMatrix64F.numCols; ++n5) {
            dArray2[n5] = dArray[n2] * denseMatrix64F.data[n2 * denseMatrix64F.numCols + n5];
        }
        for (n5 = n2 + 1; n5 < n3; ++n5) {
            int n6 = n5 * denseMatrix64F.numCols + n;
            double d2 = dArray[n5];
            n4 = n;
            while (n4 < denseMatrix64F.numCols) {
                int n7 = n4++;
                dArray2[n7] = dArray2[n7] + d2 * denseMatrix64F.data[n6++];
            }
        }
        n5 = n;
        while (n5 < denseMatrix64F.numCols) {
            int n8 = n5++;
            dArray2[n8] = dArray2[n8] * d;
        }
        for (n5 = n2; n5 < n3; ++n5) {
            double d3 = dArray[n5];
            int n9 = n5 * denseMatrix64F.numCols + n;
            for (n4 = n; n4 < denseMatrix64F.numCols; ++n4) {
                int n10 = n9++;
                denseMatrix64F.data[n10] = denseMatrix64F.data[n10] - d3 * dArray2[n4];
            }
        }
    }

    public static void rank1UpdateMultR(DenseMatrix64F denseMatrix64F, double[] dArray, int n, double d, int n2, int n3, int n4, double[] dArray2) {
        int n5;
        int n6;
        for (n6 = n2; n6 < denseMatrix64F.numCols; ++n6) {
            dArray2[n6] = dArray[n3 + n] * denseMatrix64F.data[n3 * denseMatrix64F.numCols + n6];
        }
        for (n6 = n3 + 1; n6 < n4; ++n6) {
            int n7 = n6 * denseMatrix64F.numCols + n2;
            double d2 = dArray[n6 + n];
            n5 = n2;
            while (n5 < denseMatrix64F.numCols) {
                int n8 = n5++;
                dArray2[n8] = dArray2[n8] + d2 * denseMatrix64F.data[n7++];
            }
        }
        n6 = n2;
        while (n6 < denseMatrix64F.numCols) {
            int n9 = n6++;
            dArray2[n9] = dArray2[n9] * d;
        }
        for (n6 = n3; n6 < n4; ++n6) {
            double d3 = dArray[n6 + n];
            int n10 = n6 * denseMatrix64F.numCols + n2;
            for (n5 = n2; n5 < denseMatrix64F.numCols; ++n5) {
                int n11 = n10++;
                denseMatrix64F.data[n11] = denseMatrix64F.data[n11] - d3 * dArray2[n5];
            }
        }
    }

    public static void rank1UpdateMultL(DenseMatrix64F denseMatrix64F, double[] dArray, double d, int n, int n2, int n3) {
        for (int i = n; i < denseMatrix64F.numRows; ++i) {
            int n4;
            int n5 = i * denseMatrix64F.numCols + n2;
            double d2 = 0.0;
            int n6 = n5;
            for (n4 = n2; n4 < n3; ++n4) {
                d2 += denseMatrix64F.data[n6++] * dArray[n4];
            }
            d2 = -d * d2;
            n6 = n5;
            for (n4 = n2; n4 < n3; ++n4) {
                int n7 = n6++;
                denseMatrix64F.data[n7] = denseMatrix64F.data[n7] + d2 * dArray[n4];
            }
        }
    }
}

