/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;

public class CompositeRegistry
implements Registry {
    private final List<Registry> registryList;

    public CompositeRegistry() {
        this.registryList = new ArrayList<Registry>();
    }

    public CompositeRegistry(List<Registry> registries) {
        this.registryList = registries;
    }

    public void addRegistry(Registry registry) {
        this.registryList.add(registry);
    }

    List<Registry> getRegistryList() {
        return this.registryList;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        T answer = null;
        NoSuchBeanException ex = null;
        for (Registry registry : this.registryList) {
            try {
                answer = registry.lookupByNameAndType(name, type);
            }
            catch (Throwable e) {
                ex = e instanceof NoSuchBeanException ? (NoSuchBeanException)e : new NoSuchBeanException(name, "Cannot lookup: " + name + " from registry: " + registry + " with expected type: " + type + " due: " + e.getMessage(), e);
            }
            if (answer == null) continue;
            return answer;
        }
        if (ex != null) {
            throw ex;
        }
        return answer;
    }

    @Override
    public Object lookupByName(String name) {
        Registry registry;
        Object answer = null;
        Iterator<Registry> iterator = this.registryList.iterator();
        while (iterator.hasNext() && (answer = (registry = iterator.next()).lookupByName(name)) == null) {
        }
        return answer;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Registry registry;
        Map<Object, Object> answer = Collections.emptyMap();
        Iterator<Registry> iterator = this.registryList.iterator();
        while (iterator.hasNext() && (answer = (registry = iterator.next()).findByTypeWithName(type)).isEmpty()) {
        }
        return answer;
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        Registry registry;
        Set answer = Collections.emptySet();
        Iterator<Registry> iterator = this.registryList.iterator();
        while (iterator.hasNext() && (answer = (registry = iterator.next()).findByType(type)).isEmpty()) {
        }
        return answer;
    }

    @Override
    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }
}

