/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.ByteConverter;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;

public class ShortConverter
implements BytesConverter<Short> {
    public static final BytesConverter<Short> INSTANCE = new ShortConverter();
    private static final int BYTES = 2;

    static short getShort(byte[] bytes) {
        if (bytes.length < 2) {
            return ByteConverter.getByte(bytes);
        }
        if (bytes.length > 2) {
            throw new IllegalArgumentException("byte[] is too large for a single short value: " + bytes.length);
        }
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    static byte[] getBytes(short k) {
        if (k >= -128 && k <= 127) {
            return ByteConverter.getBytes((byte)k);
        }
        return new byte[]{(byte)(k >> 8), (byte)k};
    }

    @Override
    public Short fromBytes(byte[] bytes) {
        return ShortConverter.getShort(bytes);
    }

    @Override
    public byte[] toBytes(Short value) {
        return ShortConverter.getBytes(value);
    }
}

