/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.ToStringBuilder;

public class ColumnDescriptor {
    protected DbAttribute attribute;
    protected String tableName;
    protected String procedureName;
    protected String name;
    protected String namePrefix;
    protected String dataRowKey;
    protected int jdbcType;
    protected String javaClass;
    protected boolean isExpression;

    public ColumnDescriptor() {
    }

    public ColumnDescriptor(String columnName, int jdbcType) {
        this(columnName, jdbcType, TypesMapping.getJavaBySqlType(jdbcType));
    }

    public ColumnDescriptor(String columnName, int jdbcType, String javaClass) {
        this.name = columnName;
        this.dataRowKey = columnName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
    }

    public ColumnDescriptor(DbAttribute attribute, String tableAlias) {
        this(attribute.getName(), attribute.getType());
        this.attribute = attribute;
        this.namePrefix = tableAlias;
        this.javaClass = TypesMapping.getJavaBySqlType(attribute);
        if (attribute.getEntity() != null) {
            this.tableName = attribute.getEntity().getName();
        }
    }

    public ColumnDescriptor(ObjAttribute objAttribute, DbAttribute dbAttribute, String columnAlias) {
        this(dbAttribute, columnAlias);
        this.dataRowKey = objAttribute.getDbAttributePath();
        this.javaClass = objAttribute.getType();
    }

    public ColumnDescriptor(ProcedureParameter parameter) {
        this(parameter.getName(), parameter.getType());
        if (parameter.getProcedure() != null) {
            this.procedureName = parameter.getProcedure().getName();
        }
    }

    public ColumnDescriptor(String columnName, ResultSetMetaData metaData, int position) throws SQLException {
        this(columnName, metaData.getColumnType(position));
    }

    public ColumnDescriptor(ResultSetMetaData metaData, int position) throws SQLException {
        this(ColumnDescriptor.getColumnNameFromMeta(metaData, position), metaData, position);
    }

    private static String getColumnNameFromMeta(ResultSetMetaData metaData, int position) throws SQLException {
        String name = metaData.getColumnLabel(position);
        if (!(name != null && name.length() != 0 || (name = metaData.getColumnName(position)) != null && name.length() != 0)) {
            name = "column_" + position;
        }
        return name;
    }

    public DbAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(DbAttribute attribute) {
        this.attribute = attribute;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor rhs = (ColumnDescriptor)o;
        return new EqualsBuilder().append(this.name, rhs.name).append(this.namePrefix, rhs.namePrefix).append(this.procedureName, rhs.procedureName).append(this.dataRowKey, rhs.dataRowKey).append(this.tableName, rhs.tableName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 43).append(this.name).append(this.namePrefix).append(this.procedureName).append(this.tableName).append(this.dataRowKey).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("namePrefix", this.namePrefix);
        builder.append("name", this.getName());
        builder.append("dataRowKey", this.getDataRowKey());
        builder.append("tableName", this.getTableName());
        builder.append("procedureName", this.getProcedureName());
        builder.append("javaClass", this.getJavaClass());
        builder.append("jdbcType", this.getJdbcType());
        return builder.toString();
    }

    public String getQualifiedColumnName() {
        return this.namePrefix != null ? this.namePrefix + '.' + this.name : this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setJdbcType(int i) {
        this.jdbcType = i;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String string) {
        this.javaClass = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getDataRowKey() {
        return this.dataRowKey != null ? this.dataRowKey : this.getName();
    }

    public void setDataRowKey(String dataRowKey) {
        this.dataRowKey = dataRowKey;
    }

    public void setIsExpression(boolean isExpression) {
        this.isExpression = isExpression;
    }

    public boolean isExpression() {
        return this.isExpression;
    }
}

