/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.reflect.ConverterFactory;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyUtils;

public class BeanAccessor
implements Accessor {
    private static final long serialVersionUID = 606253801447018099L;
    protected String propertyName;
    protected Method readMethod;
    protected Method writeMethod;
    protected Object nullValue;

    public BeanAccessor(Class<?> objectClass, String propertyName, Class<?> propertyType) {
        this(objectClass, propertyName, propertyType, BeanAccessor.defaultBooleanGetterName(propertyName), BeanAccessor.defaultGetterName(propertyName), BeanAccessor.defaultSetterName(propertyName));
    }

    protected BeanAccessor(Class<?> objectClass, String propertyName, Class<?> propertyType, String booleanGetterName, String getterName, String setterName) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        BeanAccessor.checkPropertyName(propertyName);
        if (booleanGetterName == null) {
            throw new IllegalArgumentException("Null booleanGetterName");
        }
        if (getterName == null) {
            throw new IllegalArgumentException("Null getterName");
        }
        if (setterName == null) {
            throw new IllegalArgumentException("Null setterName");
        }
        this.propertyName = propertyName;
        this.nullValue = PropertyUtils.defaultNullValueForType(propertyType);
        Method[] publicMethods = objectClass.getMethods();
        Method getter = null;
        for (Method method : publicMethods) {
            Class<?> returnType = method.getReturnType();
            if (method.getName().equals(booleanGetterName) && returnType.equals(Boolean.TYPE) && method.getParameterTypes().length == 0) {
                getter = method;
                break;
            }
            if (!method.getName().equals(getterName) || method.getParameterTypes().length != 0) continue;
            if (returnType.isPrimitive()) {
                Method method2 = getter = returnType.equals(Void.TYPE) ? null : method;
                if (!returnType.equals(Boolean.TYPE)) break;
                continue;
            }
            if (getter != null && !getter.getReturnType().isAssignableFrom(returnType)) continue;
            getter = method;
        }
        if (getter == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' is not readable");
        }
        this.readMethod = getter;
        for (Method method : publicMethods) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(setterName) || !method.getReturnType().equals(Void.TYPE) || (parameterTypes = method.getParameterTypes()).length != 1 || !getter.getReturnType().isAssignableFrom(parameterTypes[0])) continue;
            this.writeMethod = method;
            break;
        }
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        try {
            return this.readMethod.invoke(object, (Object[])null);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        if (this.writeMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not writable", (Accessor)this, object, new Object[0]);
        }
        Class<?> type = this.writeMethod.getParameterTypes()[0];
        Converter<?> converter = ConverterFactory.factory.getConverter(type);
        try {
            Object object2 = newValue = converter != null ? converter.convert(newValue, type) : newValue;
            if (newValue == null) {
                newValue = this.nullValue;
            }
            this.writeMethod.invoke(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error writing property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    private static String defaultSetterName(String propertyName) {
        BeanAccessor.checkPropertyName(propertyName);
        String capitalized = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return "set" + capitalized;
    }

    private static String defaultGetterName(String propertyName) {
        BeanAccessor.checkPropertyName(propertyName);
        String capitalized = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return "get" + capitalized;
    }

    private static String defaultBooleanGetterName(String propertyName) {
        BeanAccessor.checkPropertyName(propertyName);
        String capitalized = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        return "is" + capitalized;
    }

    private static void checkPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Empty propertyName");
        }
    }
}

