/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.exec.ProcessDestroyer;

public class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private final List<Process> processes = new ArrayList<Process>();
    private ProcessDestroyerThread destroyProcessThread;
    private final AtomicBoolean added = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Process process) {
        List<Process> list = this.processes;
        synchronized (list) {
            if (this.processes.isEmpty()) {
                this.addShutdownHook();
            }
            this.processes.add(process);
            return this.processes.contains(process);
        }
    }

    private void addShutdownHook() {
        if (!this.running.get()) {
            this.destroyProcessThread = new ProcessDestroyerThread();
            Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
            this.added.compareAndSet(false, true);
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added.get();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Process process) {
        List<Process> list = this.processes;
        synchronized (list) {
            boolean processRemoved = this.processes.remove(process);
            if (processRemoved && this.processes.isEmpty()) {
                this.removeShutdownHook();
            }
            return processRemoved;
        }
    }

    private void removeShutdownHook() {
        if (this.added.get() && !this.running.get()) {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!removed) {
                System.err.println("Could not remove shutdown hook");
            }
            this.destroyProcessThread.setShouldDestroy(false);
            this.destroyProcessThread.start();
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added.compareAndSet(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Process> list = this.processes;
        synchronized (list) {
            this.running.compareAndSet(false, true);
            this.processes.forEach(process -> {
                try {
                    process.destroy();
                }
                catch (Throwable t) {
                    System.err.println("Unable to terminate process during process shutdown");
                }
            });
        }
    }

    @Override
    public int size() {
        return this.processes.size();
    }

    private final class ProcessDestroyerThread
    extends Thread {
        private final AtomicBoolean shouldDestroy;

        private ProcessDestroyerThread() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.shouldDestroy.get()) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy.compareAndSet(!shouldDestroy, shouldDestroy);
        }
    }
}

