/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test;

import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.XMLOutput;

public abstract class BaseJellyTest
extends TestCase {
    private Jelly jelly = null;
    private JellyContext context = null;
    private XMLOutput xmlOutput = null;

    public BaseJellyTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.jelly = new Jelly();
        this.context = new JellyContext();
        this.xmlOutput = XMLOutput.createDummyXMLOutput();
    }

    protected void setUpScript(String scriptname) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource(scriptname);
        if (null == url) {
            throw new Exception("Could not find Jelly script: " + scriptname + " in package of class: " + ((Object)((Object)this)).getClass().getName());
        }
        this.jelly.setUrl(url);
        String exturl = url.toExternalForm();
        int lastSlash = exturl.lastIndexOf("/");
        String extBase = exturl.substring(0, lastSlash + 1);
        URL baseurl = new URL(extBase);
        this.context.setCurrentURL(baseurl);
    }

    protected Jelly getJelly() {
        return this.jelly;
    }

    protected JellyContext getJellyContext() {
        return this.context;
    }

    protected XMLOutput getXMLOutput() {
        return this.xmlOutput;
    }
}

