/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.core.ArgTag;
import org.apache.commons.jelly.tags.core.ArgTagParent;
import org.apache.commons.jelly.test.BaseJellyTest;

public class TestArgTag
extends BaseJellyTest {
    private MockArgTagParent parentTag = null;
    private ArgTag argTag = null;

    public TestArgTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestArgTag.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.parentTag = new MockArgTagParent();
        this.argTag = new ArgTag();
        this.argTag.setContext(this.getJellyContext());
        this.argTag.setParent((Tag)this.parentTag);
        this.argTag.setBody((Script)new MockScript());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.parentTag = null;
        this.argTag = null;
    }

    public void testToBooleanFromString() throws Exception {
        this.argTag.setType("boolean");
        this.argTag.setValue((Object)"true");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Boolean.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)Boolean.TRUE, (Object)this.parentTag.getValue(0));
    }

    public void testToCharFromString() throws Exception {
        this.argTag.setType("char");
        this.argTag.setValue((Object)"X");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Character.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Character('X'), (Object)this.parentTag.getValue(0));
    }

    public void testToByteFromString() throws Exception {
        this.argTag.setType("byte");
        this.argTag.setValue((Object)"17");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Byte.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Byte(17), (Object)this.parentTag.getValue(0));
    }

    public void testToByteFromNumber() throws Exception {
        this.argTag.setType("byte");
        this.argTag.setValue((Object)new Double(17.3));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Byte.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Byte(17), (Object)this.parentTag.getValue(0));
    }

    public void testToShortFromString() throws Exception {
        this.argTag.setType("short");
        this.argTag.setValue((Object)"17");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Short.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Short(17), (Object)this.parentTag.getValue(0));
    }

    public void testToShortFromNumber() throws Exception {
        this.argTag.setType("short");
        this.argTag.setValue((Object)new Double(17.3));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Short.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Short(17), (Object)this.parentTag.getValue(0));
    }

    public void testToIntFromString() throws Exception {
        this.argTag.setType("int");
        this.argTag.setValue((Object)"17");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Integer.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Integer(17), (Object)this.parentTag.getValue(0));
    }

    public void testToIntFromNumber() throws Exception {
        this.argTag.setType("int");
        this.argTag.setValue((Object)new Double(17.3));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Integer.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Integer(17), (Object)this.parentTag.getValue(0));
    }

    public void testToFloatFromString() throws Exception {
        this.argTag.setType("float");
        this.argTag.setValue((Object)"17.3");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Float.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Float(17.3f), (Object)this.parentTag.getValue(0));
    }

    public void testToFloatFromNumber() throws Exception {
        this.argTag.setType("float");
        this.argTag.setValue((Object)new Double(17.3));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Float.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Float(17.3f), (Object)this.parentTag.getValue(0));
    }

    public void testToLongFromString() throws Exception {
        this.argTag.setType("long");
        this.argTag.setValue((Object)"17");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Long.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Long(17L), (Object)this.parentTag.getValue(0));
    }

    public void testToLongFromNumber() throws Exception {
        this.argTag.setType("long");
        this.argTag.setValue((Object)new Double(17.3));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Long.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Long(17L), (Object)this.parentTag.getValue(0));
    }

    public void testToDoubleFromString() throws Exception {
        this.argTag.setType("double");
        this.argTag.setValue((Object)"17.3");
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Double.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Double(17.3), (Object)this.parentTag.getValue(0));
    }

    public void testToDoubleFromNumber() throws Exception {
        this.argTag.setType("double");
        this.argTag.setValue((Object)new Long(17L));
        this.argTag.doTag(this.getXMLOutput());
        TestArgTag.assertEquals(Double.TYPE, (Object)this.parentTag.getType(0));
        TestArgTag.assertEquals((Object)new Double(17.0), (Object)this.parentTag.getValue(0));
    }

    public void testToPrimitiveFromNull() throws Exception {
        String[] types = new String[]{"boolean", "char", "byte", "short", "int", "float", "long", "double"};
        for (int i = 0; i < types.length; ++i) {
            this.argTag.setType(types[i]);
            this.argTag.setValue(null);
            try {
                this.argTag.doTag(this.getXMLOutput());
                TestArgTag.fail((String)"Expected JellyException");
                continue;
            }
            catch (JellyException jellyException) {
                // empty catch block
            }
        }
    }

    public void testFromNull() throws Exception {
        Class[] types = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class, String.class, Object.class};
        for (int i = 0; i < types.length; ++i) {
            this.argTag.setType(types[i].getName());
            this.argTag.setValue(null);
            this.argTag.doTag(this.getXMLOutput());
            TestArgTag.assertEquals((Object)types[i], (Object)this.parentTag.getType(i));
            TestArgTag.assertNull((Object)this.parentTag.getValue(i));
        }
    }

    class MockScript
    implements Script {
        MockScript() {
        }

        public Script compile() throws JellyException {
            return this;
        }

        public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        }
    }

    class MockArgTagParent
    extends TagSupport
    implements ArgTagParent {
        private List typeList = new ArrayList();
        private List valueList = new ArrayList();

        MockArgTagParent() {
        }

        public void addArgument(Class type, Object value) {
            this.typeList.add(type);
            this.valueList.add(value);
        }

        public void doTag(XMLOutput output) {
        }

        private Class getType(int i) {
            return (Class)this.typeList.get(i);
        }

        private Object getValue(int i) {
            return this.valueList.get(i);
        }
    }
}

