/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.junit.Assert;
import org.junit.Test;

public class SimpleVectorValueCheckerTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testIterationCheckPrecondition() {
        new SimpleVectorValueChecker(0.1, 0.01, 0);
    }

    @Test
    public void testIterationCheck() {
        int max = 10;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(0.1, 0.01, 10);
        Assert.assertTrue((boolean)checker.converged(10, null, null));
        Assert.assertTrue((boolean)checker.converged(11, null, null));
    }

    @Test
    public void testIterationCheckDisabled() {
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(1.0E-8, 1.0E-8);
        PointVectorValuePair a = new PointVectorValuePair(new double[]{1.0}, new double[]{1.0});
        PointVectorValuePair b = new PointVectorValuePair(new double[]{10.0}, new double[]{10.0});
        Assert.assertFalse((boolean)checker.converged(-1, a, b));
        Assert.assertFalse((boolean)checker.converged(0, a, b));
        Assert.assertFalse((boolean)checker.converged(1000000, a, b));
        Assert.assertTrue((boolean)checker.converged(-1, a, a));
        Assert.assertTrue((boolean)checker.converged(-1, b, b));
    }
}

