/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive;

import java.util.ArrayList;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.stat.descriptive.AggregateSummaryStatistics;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class AggregateSummaryStatisticsTest {
    @Test
    public void testAggregation() {
        AggregateSummaryStatistics aggregate = new AggregateSummaryStatistics();
        SummaryStatistics setOneStats = aggregate.createContributingStatistics();
        SummaryStatistics setTwoStats = aggregate.createContributingStatistics();
        Assert.assertNotNull((String)"The set one contributing stats are null", (Object)setOneStats);
        Assert.assertNotNull((String)"The set two contributing stats are null", (Object)setTwoStats);
        Assert.assertNotSame((String)"Contributing stats objects are the same", (Object)setOneStats, (Object)setTwoStats);
        setOneStats.addValue(2.0);
        setOneStats.addValue(3.0);
        setOneStats.addValue(5.0);
        setOneStats.addValue(7.0);
        setOneStats.addValue(11.0);
        Assert.assertEquals((String)"Wrong number of set one values", (long)5L, (long)setOneStats.getN());
        Assert.assertTrue((String)"Wrong sum of set one values", (boolean)Precision.equals((double)28.0, (double)setOneStats.getSum(), (int)1));
        setTwoStats.addValue(2.0);
        setTwoStats.addValue(4.0);
        setTwoStats.addValue(8.0);
        Assert.assertEquals((String)"Wrong number of set two values", (long)3L, (long)setTwoStats.getN());
        Assert.assertTrue((String)"Wrong sum of set two values", (boolean)Precision.equals((double)14.0, (double)setTwoStats.getSum(), (int)1));
        Assert.assertEquals((String)"Wrong number of aggregate values", (long)8L, (long)aggregate.getN());
        Assert.assertTrue((String)"Wrong aggregate sum", (boolean)Precision.equals((double)42.0, (double)aggregate.getSum(), (int)1));
    }

    @Test
    public void testAggregationConsistency() {
        int i;
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        AggregateSummaryStatistics aggregate = new AggregateSummaryStatistics();
        SummaryStatistics totalStats = new SummaryStatistics();
        SummaryStatistics[] componentStats = new SummaryStatistics[nSamples];
        for (i = 0; i < nSamples; ++i) {
            componentStats[i] = aggregate.createContributingStatistics();
            for (int j = 0; j < subSamples[i].length; ++j) {
                componentStats[i].addValue(subSamples[i][j]);
            }
        }
        for (i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        Assert.assertEquals((Object)totalStats.getSummary(), (Object)aggregate.getSummary());
    }

    @Test
    public void testAggregate() {
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        SummaryStatistics totalStats = new SummaryStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        SummaryStatistics[] subSampleStats = new SummaryStatistics[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            subSampleStats[i] = new SummaryStatistics();
        }
        ArrayList<SummaryStatistics> aggregate = new ArrayList<SummaryStatistics>();
        for (int i = 0; i < nSamples; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummaryValues aggregatedStats = AggregateSummaryStatistics.aggregate(aggregate);
        AggregateSummaryStatisticsTest.assertEquals(totalStats.getSummary(), (StatisticalSummary)aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateStatisticalSummary() {
        double[] totalSample = this.generateSample();
        double[][] subSamples = this.generatePartition(totalSample);
        int nSamples = subSamples.length;
        SummaryStatistics totalStats = new SummaryStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        SummaryStatistics[] subSampleStats = new SummaryStatistics[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            subSampleStats[i] = new SummaryStatistics();
        }
        ArrayList<StatisticalSummary> aggregate = new ArrayList<StatisticalSummary>();
        for (int i = 0; i < nSamples; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i].getSummary());
        }
        StatisticalSummaryValues aggregatedStats = AggregateSummaryStatistics.aggregate(aggregate);
        AggregateSummaryStatisticsTest.assertEquals(totalStats.getSummary(), (StatisticalSummary)aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateDegenerate() {
        double[] totalSample = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[][] subSamples = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}, {5.0}};
        SummaryStatistics totalStats = new SummaryStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        SummaryStatistics[] subSampleStats = new SummaryStatistics[5];
        for (int i = 0; i < 5; ++i) {
            subSampleStats[i] = new SummaryStatistics();
        }
        ArrayList<SummaryStatistics> aggregate = new ArrayList<SummaryStatistics>();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummaryValues aggregatedStats = AggregateSummaryStatistics.aggregate(aggregate);
        AggregateSummaryStatisticsTest.assertEquals(totalStats.getSummary(), (StatisticalSummary)aggregatedStats, 1.0E-11);
    }

    @Test
    public void testAggregateSpecialValues() {
        double[] totalSample = new double[]{Double.POSITIVE_INFINITY, 2.0, 3.0, Double.NaN, 5.0};
        double[][] subSamples = new double[][]{{Double.POSITIVE_INFINITY, 2.0}, {3.0}, {Double.NaN}, {5.0}};
        SummaryStatistics totalStats = new SummaryStatistics();
        for (int i = 0; i < totalSample.length; ++i) {
            totalStats.addValue(totalSample[i]);
        }
        SummaryStatistics[] subSampleStats = new SummaryStatistics[5];
        for (int i = 0; i < 4; ++i) {
            subSampleStats[i] = new SummaryStatistics();
        }
        ArrayList<SummaryStatistics> aggregate = new ArrayList<SummaryStatistics>();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < subSamples[i].length; ++j) {
                subSampleStats[i].addValue(subSamples[i][j]);
            }
            aggregate.add(subSampleStats[i]);
        }
        StatisticalSummaryValues aggregatedStats = AggregateSummaryStatistics.aggregate(aggregate);
        AggregateSummaryStatisticsTest.assertEquals(totalStats.getSummary(), (StatisticalSummary)aggregatedStats, 1.0E-11);
    }

    protected static void assertEquals(StatisticalSummary expected, StatisticalSummary observed, double delta) {
        TestUtils.assertEquals(expected.getMax(), observed.getMax(), 0.0);
        TestUtils.assertEquals(expected.getMin(), observed.getMin(), 0.0);
        Assert.assertEquals((long)expected.getN(), (long)observed.getN());
        TestUtils.assertEquals(expected.getSum(), observed.getSum(), delta);
        TestUtils.assertEquals(expected.getMean(), observed.getMean(), delta);
        TestUtils.assertEquals(expected.getStandardDeviation(), observed.getStandardDeviation(), delta);
        TestUtils.assertEquals(expected.getVariance(), observed.getVariance(), delta);
    }

    private double[] generateSample() {
        UniformIntegerDistribution size = new UniformIntegerDistribution(10, 100);
        UniformRealDistribution randomData = new UniformRealDistribution(-100.0, 100.0);
        int sampleSize = size.sample();
        double[] out = randomData.sample(sampleSize);
        return out;
    }

    private double[][] generatePartition(double[] sample) {
        int subLength;
        int length = sample.length;
        double[][] out = new double[5][];
        int cur = 0;
        int offset = 0;
        int sampleCount = 0;
        for (int i = 0; i < 5 && cur != length && offset != length; offset += subLength, ++i) {
            int next = i == 4 || cur == length - 1 ? length - 1 : new UniformIntegerDistribution(cur, length - 1).sample();
            subLength = next - cur + 1;
            out[i] = new double[subLength];
            System.arraycopy(sample, offset, out[i], 0, subLength);
            cur = next + 1;
            ++sampleCount;
        }
        if (sampleCount < 5) {
            double[][] out2 = new double[sampleCount][];
            for (int j = 0; j < sampleCount; ++j) {
                int curSize = out[j].length;
                out2[j] = new double[curSize];
                System.arraycopy(out[j], 0, out2[j], 0, curSize);
            }
            return out2;
        }
        return out;
    }
}

