/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.neuralnet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.math4.neuralnet.Neuron;
import org.apache.commons.math4.neuralnet.internal.NeuralNetException;

public class Network
implements Iterable<Neuron> {
    private final ConcurrentHashMap<Long, Neuron> neuronMap = new ConcurrentHashMap();
    private final AtomicLong nextId;
    private final int featureSize;
    private final ConcurrentHashMap<Long, Set<Long>> linkMap = new ConcurrentHashMap();

    public Network(long firstId, int featureSize) {
        this.nextId = new AtomicLong(firstId);
        this.featureSize = featureSize;
    }

    public static Network from(int featureSize, long[] idList, double[][] featureList, long[][] neighbourIdList) {
        int i;
        int numNeurons = idList.length;
        if (idList.length != featureList.length) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", idList.length, featureList.length);
        }
        if (idList.length != neighbourIdList.length) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", idList.length, neighbourIdList.length);
        }
        Network net = new Network(Long.MIN_VALUE, featureSize);
        for (i = 0; i < numNeurons; ++i) {
            long id = idList[i];
            net.createNeuron(id, featureList[i]);
        }
        for (i = 0; i < numNeurons; ++i) {
            Neuron a = net.getNeuron(idList[i]);
            for (long id : neighbourIdList[i]) {
                Neuron b = net.neuronMap.get(id);
                if (b == null) {
                    throw new NeuralNetException("Identifier not found: {0}", id);
                }
                net.addLink(a, b);
            }
        }
        return net;
    }

    public synchronized Network copy() {
        Network copy = new Network(this.nextId.get(), this.featureSize);
        for (Map.Entry<Long, Neuron> entry : this.neuronMap.entrySet()) {
            copy.neuronMap.put(entry.getKey(), entry.getValue().copy());
        }
        for (Map.Entry<Long, Object> entry : this.linkMap.entrySet()) {
            copy.linkMap.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        return copy;
    }

    @Override
    public Iterator<Neuron> iterator() {
        return this.neuronMap.values().iterator();
    }

    public Collection<Neuron> getNeurons() {
        return Collections.unmodifiableCollection(this.neuronMap.values());
    }

    public long createNeuron(double[] features) {
        return this.createNeuron(this.createNextId(), features);
    }

    private long createNeuron(long id, double[] features) {
        if (this.neuronMap.get(id) != null) {
            throw new NeuralNetException("Identifier already in use: {0}", id);
        }
        if (features.length != this.featureSize) {
            throw new NeuralNetException("Size mismatch: {0} != {1}", features.length, this.featureSize);
        }
        this.neuronMap.put(id, new Neuron(id, (double[])features.clone()));
        this.linkMap.put(id, new HashSet());
        if (id > this.nextId.get()) {
            this.nextId.set(id);
        }
        return id;
    }

    public void deleteNeuron(Neuron neuron) {
        this.getNeighbours(neuron).forEach(neighbour -> this.deleteLink((Neuron)neighbour, neuron));
        this.neuronMap.remove(neuron.getIdentifier());
    }

    public int getFeaturesSize() {
        return this.featureSize;
    }

    public void addLink(Neuron a, Neuron b) {
        long aId = a.getIdentifier();
        if (a != this.getNeuron(aId)) {
            throw new NoSuchElementException(Long.toString(aId));
        }
        long bId = b.getIdentifier();
        if (b != this.getNeuron(bId)) {
            throw new NoSuchElementException(Long.toString(bId));
        }
        this.addLinkToLinkSet(this.linkMap.get(aId), bId);
    }

    private void addLinkToLinkSet(Set<Long> linkSet, long id) {
        linkSet.add(id);
    }

    public void deleteLink(Neuron a, Neuron b) {
        long aId = a.getIdentifier();
        if (a != this.getNeuron(aId)) {
            throw new NoSuchElementException(Long.toString(aId));
        }
        long bId = b.getIdentifier();
        if (b != this.getNeuron(bId)) {
            throw new NoSuchElementException(Long.toString(bId));
        }
        this.deleteLinkFromLinkSet(this.linkMap.get(aId), bId);
    }

    private void deleteLinkFromLinkSet(Set<Long> linkSet, long id) {
        linkSet.remove(id);
    }

    public Neuron getNeuron(long id) {
        Neuron n = this.neuronMap.get(id);
        if (n == null) {
            throw new NoSuchElementException(Long.toString(id));
        }
        return n;
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> neurons) {
        return this.getNeighbours(neurons, null);
    }

    public Collection<Neuron> getNeighbours(Iterable<Neuron> neurons, Iterable<Neuron> exclude) {
        HashSet idList = new HashSet();
        neurons.forEach(n -> idList.addAll(this.linkMap.get(n.getIdentifier())));
        if (exclude != null) {
            exclude.forEach(n -> idList.remove(n.getIdentifier()));
        }
        return idList.stream().map(this::getNeuron).collect(Collectors.toList());
    }

    public Collection<Neuron> getNeighbours(Neuron neuron) {
        return this.getNeighbours(neuron, null);
    }

    public Collection<Neuron> getNeighbours(Neuron neuron, Iterable<Neuron> exclude) {
        Set<Long> idList = this.linkMap.get(neuron.getIdentifier());
        if (exclude != null) {
            for (Neuron n : exclude) {
                idList.remove(n.getIdentifier());
            }
        }
        ArrayList<Neuron> neuronList = new ArrayList<Neuron>();
        for (Long id : idList) {
            neuronList.add(this.getNeuron(id));
        }
        return neuronList;
    }

    private Long createNextId() {
        return this.nextId.getAndIncrement();
    }
}

