/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPrivateKey;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public class EcdhDirectKeyDecryptionAlgorithm
extends DirectKeyDecryptionAlgorithm {
    private final ECPrivateKey privateKey;

    public EcdhDirectKeyDecryptionAlgorithm(ECPrivateKey privateKey) {
        super((byte[])null);
        this.privateKey = privateKey;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        super.validateKeyEncryptionKey(jweDecryptionInput);
        return this.getDecryptedContentEncryptionKeyFromHeaders(jweDecryptionInput.getJweHeaders(), this.privateKey);
    }

    protected byte[] getDecryptedContentEncryptionKeyFromHeaders(JweHeaders headers, ECPrivateKey key) {
        ContentAlgorithm jwtAlgo = headers.getContentEncryptionAlgorithm();
        JsonWebKey publicJwk = headers.getJsonWebKey("epk");
        String apuHeader = (String)headers.getHeader("apu");
        byte[] apuBytes = apuHeader == null ? null : JoseUtils.decode(apuHeader);
        String apvHeader = (String)headers.getHeader("apv");
        byte[] apvBytes = apvHeader == null ? null : JoseUtils.decode(apvHeader);
        return JweUtils.getECDHKey(key, JwkUtils.toECPublicKey(publicJwk), apuBytes, apvBytes, jwtAlgo.getJwaName(), jwtAlgo.getKeySizeBits());
    }
}

