/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class DisconnectConsumerMessage
extends PacketImpl {
    private long consumerId;

    public DisconnectConsumerMessage(long consumerId) {
        super((byte)12);
        this.consumerId = consumerId;
    }

    public DisconnectConsumerMessage() {
        super((byte)12);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerId);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerId = buffer.readLong();
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", consumerId=" + this.consumerId);
        return sb.toString();
    }

    public long getConsumerId() {
        return this.consumerId;
    }
}

