/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactHashIterator;
import org.apache.datasketches.theta.PreambleUtil;

final class SingleItemSketch
extends CompactThetaSketch {
    private static final long DEFAULT_SEED_HASH = (long)Util.computeSeedHash(9001L) & 0xFFFFL;
    private static final long PRE0_LO6_SI = 63771674608385L;
    private long pre0_ = 0L;
    private long hash_ = 0L;

    private SingleItemSketch(long hash) {
        this.pre0_ = DEFAULT_SEED_HASH << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    SingleItemSketch(long hash, long seed) {
        long seedHash = (long)Util.computeSeedHash(seed) & 0xFFFFL;
        this.pre0_ = seedHash << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    SingleItemSketch(long hash, short seedHash) {
        long seedH = (long)seedHash & 0xFFFFL;
        this.pre0_ = seedH << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    static SingleItemSketch heapify(MemorySegment srcSeg, short expectedSeedHash) {
        Util.checkSeedHashes((short)PreambleUtil.extractSeedHash(srcSeg), expectedSeedHash);
        boolean singleItem = SingleItemSketch.checkForSingleItem(srcSeg);
        if (singleItem) {
            return new SingleItemSketch(srcSeg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L), expectedSeedHash);
        }
        throw new SketchesArgumentException("Input MemorySegment is not a SingleItemSketch.");
    }

    @Override
    public CompactThetaSketch compact(boolean dstOrdered, MemorySegment dstSeg) {
        if (dstSeg == null) {
            return this;
        }
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, this.pre0_);
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.hash_);
        return new DirectCompactSketch(dstSeg);
    }

    static SingleItemSketch create(long datum) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(String datum) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(char[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(int[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(long[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(long datum, long seed) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1);
    }

    static SingleItemSketch create(double datum, long seed) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(String datum, long seed) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(byte[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(char[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(int[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(long[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    @Override
    public int getCountLessThanThetaLong(long thetaLong) {
        return this.hash_ < thetaLong ? 1 : 0;
    }

    @Override
    public int getCurrentBytes() {
        return 16;
    }

    @Override
    public double getEstimate() {
        return 1.0;
    }

    @Override
    public HashIterator iterator() {
        return new HeapCompactHashIterator(new long[]{this.hash_});
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 1;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public byte[] toByteArray() {
        byte[] out = new byte[16];
        ByteArrayUtil.putLongLE(out, 0, this.pre0_);
        ByteArrayUtil.putLongLE(out, 8, this.hash_);
        return out;
    }

    @Override
    long[] getCache() {
        return new long[]{this.hash_};
    }

    @Override
    int getCompactPreambleLongs() {
        return 1;
    }

    @Override
    int getCurrentPreambleLongs() {
        return 1;
    }

    @Override
    short getSeedHash() {
        return (short)(this.pre0_ >>> 48);
    }

    static boolean checkForSingleItem(MemorySegment seg) {
        int preLongs = PreambleUtil.checkSegPreambleCap(seg);
        return SingleItemSketch.checkForSingleItem(preLongs, PreambleUtil.extractSerVer(seg), PreambleUtil.extractFamilyID(seg), PreambleUtil.extractFlags(seg));
    }

    static boolean checkForSingleItem(int preLongs, int serVer, int famId, int flags) {
        boolean preLongsOK = preLongs == 1;
        boolean serVerOK = serVer >= 3;
        boolean famIdOK = famId == Family.COMPACT.getID();
        boolean flagsOK = (flags & 0x1F) == 26;
        boolean singleFlagOK = (flags & 0x20) > 0;
        return preLongsOK && serVerOK && famIdOK && flagsOK || singleFlagOK;
    }
}

