/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityReferences
implements EntityResolver {
    private Map<String, byte[]> entityReferences = new HashMap<String, byte[]>();

    public void addEntityReference(String systemId, byte[] content) {
        if (systemId == null) {
            throw new NullPointerException("systemId must not be null");
        }
        if (content == null) {
            throw new NullPointerException("content must not be null");
        }
        if (this.entityReferences.containsKey(systemId)) {
            throw new IllegalArgumentException("systemId is already defined");
        }
        this.entityReferences.put(systemId, content);
    }

    public boolean containsSystemId(String systemId) {
        return this.entityReferences.containsKey(systemId);
    }

    public Map<String, byte[]> getEntityReferences() {
        return new HashMap<String, byte[]>(this.entityReferences);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        byte[] content = this.entityReferences.get(systemId);
        if (content == null) {
            return null;
        }
        return new InputSource(new ByteArrayInputStream(content));
    }
}

