/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import java.io.IOException;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.dns.io.encoder.RecordEncoder;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.mina.core.buffer.IoBuffer;

public abstract class ResourceRecordEncoder
implements RecordEncoder {
    @Override
    public void put(IoBuffer byteBuffer, ResourceRecord record) throws IOException {
        this.putDomainName(byteBuffer, record.getDomainName());
        this.putRecordType(byteBuffer, record.getRecordType());
        this.putRecordClass(byteBuffer, record.getRecordClass());
        byteBuffer.putInt(record.getTimeToLive());
        this.putResourceRecord(byteBuffer, record);
    }

    protected abstract void putResourceRecordData(IoBuffer var1, ResourceRecord var2);

    protected void putResourceRecord(IoBuffer byteBuffer, ResourceRecord record) {
        int startPosition = byteBuffer.position();
        byteBuffer.position(startPosition + 2);
        this.putResourceRecordData(byteBuffer, record);
        this.putDataSize(byteBuffer, startPosition);
    }

    protected void putDataSize(IoBuffer byteBuffer, int startPosition) {
        int endPosition = byteBuffer.position();
        short length = (short)(endPosition - startPosition - 2);
        byteBuffer.position(startPosition);
        byteBuffer.putShort(length);
        byteBuffer.position(endPosition);
    }

    protected void putDomainName(IoBuffer byteBuffer, String domainName) {
        if (!Strings.isEmpty((String)domainName)) {
            String[] labels;
            for (String label : labels = domainName.split("\\.")) {
                char[] characters;
                byteBuffer.put((byte)label.length());
                for (char c : characters = label.toCharArray()) {
                    byteBuffer.put((byte)c);
                }
            }
        }
        byteBuffer.put((byte)0);
    }

    protected void putRecordType(IoBuffer byteBuffer, RecordType recordType) {
        byteBuffer.putShort(recordType.convert().shortValue());
    }

    protected void putRecordClass(IoBuffer byteBuffer, RecordClass recordClass) {
        byteBuffer.putShort(recordClass.convert().shortValue());
    }

    protected void putCharacterString(IoBuffer byteBuffer, String characterString) {
        byteBuffer.put((byte)characterString.length());
        char[] characters = characterString.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            byteBuffer.put((byte)characters[ii]);
        }
    }
}

