/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class ScopeDialog
extends Dialog {
    private String dialogTitle;
    private boolean multipleEntriesSelected;
    private SearchScope scope;
    private Button objectScopeButton;
    private Button onelevelScopeButton;
    private Button subtreeScopeButton;

    public ScopeDialog(Shell parentShell, String dialogTitle, boolean multipleEntriesSelected) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.dialogTitle = dialogTitle;
        this.multipleEntriesSelected = multipleEntriesSelected;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void okPressed() {
        this.scope = this.objectScopeButton.getSelection() ? SearchScope.OBJECT : (this.onelevelScopeButton.getSelection() ? SearchScope.ONELEVEL : SearchScope.SUBTREE);
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("ScopeDialog.SelectCopyDepth"), (int)1);
        this.objectScopeButton = new Button((Composite)group, 16);
        this.objectScopeButton.setSelection(true);
        this.objectScopeButton.setText(this.multipleEntriesSelected ? Messages.getString("ScopeDialog.OnlyCopiedEntries") : Messages.getString("ScopeDialog.OnlyCopiedEntry"));
        this.onelevelScopeButton = new Button((Composite)group, 16);
        this.onelevelScopeButton.setText(this.multipleEntriesSelected ? Messages.getString("ScopeDialog.CopiedEntriesAndDirectChildren") : Messages.getString("ScopeDialog.CopiedEntryAndDirectChildren"));
        this.subtreeScopeButton = new Button((Composite)group, 16);
        this.subtreeScopeButton.setText(this.multipleEntriesSelected ? Messages.getString("ScopeDialog.WholeSubtrees") : Messages.getString("ScopeDialog.WholeSubtree"));
        ScopeDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public SearchScope getScope() {
        return this.scope;
    }
}

